<?php
/**
 * MERGED LARGE index.php - autogenerated
 * This file concatenates original PHP files. Each file's execution is wrapped so that
 * if a file throws an exception/fatal, the rest of the site continues to run.
 *
 * IMPORTANT: This is a best-effort merge. Test thoroughly on a staging server.
 */

error_reporting(E_ALL);
// Convert warnings/notices to exceptions so try-catch can handle them
set_error_handler(function($errno, $errstr, $errfile, $errline) {
    // ignore @-suppressed errors
    if (error_reporting() === 0) return false;
    throw new ErrorException($errstr, 0, $errno, $errfile, $errline);
});
set_exception_handler(function($e){
    // render a minimal friendly error but do not produce HTTP 500
    http_response_code(200);
    echo "<div style='font-family:Tahoma,Arial,sans-serif;background:#fff;padding:12px;border-radius:6px;margin:10px'>";
    echo "<h3 style='color:#c33'>بخش خطادار غیرفعال شد — ادامه سایت</h3>";
    echo "<p class='small' style='color:#666'>اگر پیام خطا مفصل می‌خواهید، لاگ سرور را بررسی کنید.</p>";
    echo "</div>";
    error_log("Uncaught exception: " . $e->getMessage() . " in " . $e->getFile() . ":" . $e->getLine());
    // do not exit here because we want graceful degradation in wrappers.
});
register_shutdown_function(function() {
    $err = error_get_last();
    if ($err && ($err['type'] & (E_ERROR|E_PARSE|E_CORE_ERROR|E_COMPILE_ERROR))) {
        // fatal error occurred; show a friendly message but do not expose internals
        http_response_code(200);
        echo "<div style='font-family:Tahoma,Arial,sans-serif;background:#fff;padding:12px;border-radius:6px;margin:10px'>";
        echo "<h3 style='color:#c33'>یک خطای جدی رخ داده — بخش مشکل غیرفعال شده</h3>";
        echo "<p class='small' style='color:#666'>بقیهٔ سایت ادامه دارد.</p>";
        echo "</div>";
        error_log("Shutdown error: " . json_encode($err));
    }
});

// Helper to execute a file's content with output buffering and exception isolation.
function _merge_exec($fname, $content) {
    echo "\n<!-- START FILE: $fname -->\n";
    ob_start();
    try {
        // evaluate content by writing it to a temporary file and including it, to preserve original PHP/HTML mix.
        $tmp = tempnam(sys_get_temp_dir(), 'mrg_');
        file_put_contents($tmp, $content);
        include $tmp;
        @unlink($tmp);
        if (ob_get_length() !== false) ob_end_flush();
    } catch (Throwable $e) {
        ob_end_clean();
        error_log("Error executing merged file $fname: " . $e->getMessage());
        echo "<div style='color:#900;background:#fee;padding:8px;border-radius:6px;margin:6px'>بخش {$fname} به دلیل خطا غیرفعال شد.</div>";
    }
    echo "<!-- END FILE: $fname -->\n";
}

?>


<?php _merge_exec('config/config.php', <<<'PHP'
<?php
// config/config.php - Site Configuration (final fixed)

// Site Information
define('SITE_NAME', 'Crashify');
define('SITE_URL', 'https://mifrestamet.co.uk/crashify');
define('SITE_DESCRIPTION', 'The ultimate crypto betting platform');
define('SITE_KEYWORDS', 'crypto betting, sports betting, casino, live betting');
define('SITE_AUTHOR', 'Crashify Team');
define('SITE_VERSION', '2.0.0');

// Database constants (must be set before loading database.php)
if (!defined('DB_HOST'))     define('DB_HOST', 'localhost');
if (!defined('DB_NAME'))     define('DB_NAME', 'difrzeer_crashify');
if (!defined('DB_USER'))     define('DB_USER', 'difrzeer_crashify');
if (!defined('DB_PASS'))     define('DB_PASS', 'Tiam1017#');
if (!defined('DB_CHARSET'))  define('DB_CHARSET', 'utf8mb4');
if (!defined('DB_COLLATION'))define('DB_COLLATION', 'utf8mb4_unicode_ci');

// Session settings: only set ini_* before session_start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.cookie_httponly', 1);
    @ini_set('session.cookie_secure', 1); // requires HTTPS
    @ini_set('session.use_strict_mode', 1);
    @ini_set('session.cookie_samesite', 'Strict');
    session_start();
}

// Helper: site_url()
if (!function_exists('site_url')) {
    function site_url($path = '') {
        return rtrim(SITE_URL, '/') . '/' . ltrim($path, '/');
    }
}

PHP
); ?>

<?php _merge_exec('config/database.php', <<<'PHP'
<?php
// config/database.php - Database Configuration and Connection
// تنظیمات و اتصال پایگاه داده

class Database {
    private static $instance = null;
    private $connection;
    private $host;
    private $username;
    private $password;
    private $database;
    private $charset;
    private $options;

    private function __construct() {
        $this->host = defined('DB_HOST') ? DB_HOST : (getenv('DB_HOST') ?: '127.0.0.1');
        $this->username = defined('DB_USER') ? DB_USER : (getenv('DB_USER') ?: 'root');
        $this->password = defined('DB_PASS') ? DB_PASS : (getenv('DB_PASS') ?: '');
        $this->database = defined('DB_NAME') ? DB_NAME : (getenv('DB_NAME') ?: 'crashify');
        $this->charset = defined('DB_CHARSET') ? DB_CHARSET : (getenv('DB_CHARSET') ?: 'utf8mb4');
        
        // PDO options
        $this->options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
            PDO::ATTR_PERSISTENT => true,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES {$this->charset} COLLATE utf8mb4_unicode_ci"
        ];

        $this->connect();
    }

    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function connect() {
        try {
            $dsn = "mysql:host={$this->host};dbname={$this->database};charset={$this->charset}";
            $this->connection = new PDO($dsn, $this->username, $this->password, $this->options);
            
            // Set timezone
            $this->connection->exec("SET time_zone = '+00:00'");
            
        } catch (PDOException $e) {
            error_log("Database connection failed: " . $e->getMessage());
            throw new Exception("Database connection failed");
        }
    }

    public function getConnection() {
        // Check if connection is still alive
        if ($this->connection === null) {
            $this->connect();
        }
        
        try {
            $this->connection->query('SELECT 1');
        } catch (PDOException $e) {
            $this->connect();
        }
        
        return $this->connection;
    }

    // Prevent cloning
    private function __clone() {}

    // Prevent unserialization
    public function __wakeup() {
        throw new Exception("Cannot unserialize singleton");
    }
}

// Database helper functions
function getDB() {
    return Database::getInstance()->getConnection();
}

function executeQuery($sql, $params = []) {
    try {
        $db = getDB();
        $stmt = $db->prepare($sql);
        $stmt->execute($params);
        return $stmt;
    } catch (PDOException $e) {
        error_log("Query execution failed: " . $e->getMessage());
        error_log("SQL: " . $sql);
        error_log("Params: " . json_encode($params));
        throw new Exception("Database query failed");
    }
}

function fetchOne($sql, $params = []) {
    $stmt = executeQuery($sql, $params);
    return $stmt->fetch();
}

function fetchAll($sql, $params = []) {
    $stmt = executeQuery($sql, $params);
    return $stmt->fetchAll();
}

function fetchColumn($sql, $params = []) {
    $stmt = executeQuery($sql, $params);
    return $stmt->fetchColumn();
}

function insertRecord($table, $data) {
    $columns = array_keys($data);
    $placeholders = ':' . implode(', :', $columns);
    $columnList = implode(', ', $columns);
    
    $sql = "INSERT INTO {$table} ({$columnList}) VALUES ({$placeholders})";
    
    executeQuery($sql, $data);
    return getDB()->lastInsertId();
}

function updateRecord($table, $data, $where, $whereParams = []) {
    $setParts = [];
    foreach (array_keys($data) as $column) {
        $setParts[] = "{$column} = :{$column}";
    }
    $setClause = implode(', ', $setParts);
    
    $sql = "UPDATE {$table} SET {$setClause} WHERE {$where}";
    
    $params = array_merge($data, $whereParams);
    $stmt = executeQuery($sql, $params);
    
    return $stmt->rowCount();
}

function deleteRecord($table, $where, $params = []) {
    $sql = "DELETE FROM {$table} WHERE {$where}";
    $stmt = executeQuery($sql, $params);
    return $stmt->rowCount();
}

// Transaction helpers
function beginTransaction() {
    return getDB()->beginTransaction();
}

function commit() {
    return getDB()->commit();
}

function rollback() {
    return getDB()->rollBack();
}

function inTransaction() {
    return getDB()->inTransaction();
}

// Database schema creation and migration functions
function createTables() {
    $db = getDB();
    
    // Users table
    $db->exec("
        CREATE TABLE IF NOT EXISTS users (
            id INT PRIMARY KEY AUTO_INCREMENT,
            username VARCHAR(50) UNIQUE NOT NULL,
            email VARCHAR(255) UNIQUE NOT NULL,
            password_hash VARCHAR(255) NOT NULL,
            first_name VARCHAR(100),
            last_name VARCHAR(100),
            phone VARCHAR(20),
            country VARCHAR(2),
            date_of_birth DATE,
            avatar VARCHAR(255),
            balance DECIMAL(20,8) DEFAULT 0.00000000,
            bonus_balance DECIMAL(20,8) DEFAULT 0.00000000,
            level INT DEFAULT 1,
            vip_status ENUM('none', 'bronze', 'silver', 'gold', 'platinum', 'diamond') DEFAULT 'none',
            total_bets INT DEFAULT 0,
            total_wins INT DEFAULT 0,
            total_losses INT DEFAULT 0,
            win_rate DECIMAL(5,2) DEFAULT 0.00,
            total_wagered DECIMAL(20,8) DEFAULT 0.00000000,
            total_winnings DECIMAL(20,8) DEFAULT 0.00000000,
            loyalty_points INT DEFAULT 0,
            email_verified BOOLEAN DEFAULT FALSE,
            phone_verified BOOLEAN DEFAULT FALSE,
            identity_verified BOOLEAN DEFAULT FALSE,
            two_factor_enabled BOOLEAN DEFAULT FALSE,
            two_factor_secret VARCHAR(32),
            status ENUM('active', 'suspended', 'banned') DEFAULT 'active',
            last_login TIMESTAMP NULL,
            last_ip VARCHAR(45),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            
            INDEX idx_username (username),
            INDEX idx_email (email),
            INDEX idx_status (status),
            INDEX idx_created_at (created_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // User sessions table
    $db->exec("
        CREATE TABLE IF NOT EXISTS user_sessions (
            id VARCHAR(128) PRIMARY KEY,
            user_id INT NOT NULL,
            ip_address VARCHAR(45),
            user_agent TEXT,
            last_activity TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
            INDEX idx_user_id (user_id),
            INDEX idx_last_activity (last_activity)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Sports table
    $db->exec("
        CREATE TABLE IF NOT EXISTS sports (
            id INT PRIMARY KEY AUTO_INCREMENT,
            name VARCHAR(100) NOT NULL,
            slug VARCHAR(50) UNIQUE NOT NULL,
            icon VARCHAR(50),
            category ENUM('traditional', 'esports', 'virtual') DEFAULT 'traditional',
            active BOOLEAN DEFAULT TRUE,
            sort_order INT DEFAULT 0,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            
            INDEX idx_slug (slug),
            INDEX idx_category (category),
            INDEX idx_active (active)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Leagues table
    $db->exec("
        CREATE TABLE IF NOT EXISTS leagues (
            id INT PRIMARY KEY AUTO_INCREMENT,
            sport_id INT NOT NULL,
            name VARCHAR(200) NOT NULL,
            slug VARCHAR(100) UNIQUE NOT NULL,
            country VARCHAR(2),
            logo VARCHAR(255),
            active BOOLEAN DEFAULT TRUE,
            sort_order INT DEFAULT 0,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            
            FOREIGN KEY (sport_id) REFERENCES sports(id) ON DELETE CASCADE,
            INDEX idx_sport_id (sport_id),
            INDEX idx_slug (slug),
            INDEX idx_active (active)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Teams table
    $db->exec("
        CREATE TABLE IF NOT EXISTS teams (
            id INT PRIMARY KEY AUTO_INCREMENT,
            name VARCHAR(200) NOT NULL,
            slug VARCHAR(100) UNIQUE NOT NULL,
            short_name VARCHAR(10),
            logo VARCHAR(255),
            country VARCHAR(2),
            sport_id INT NOT NULL,
            active BOOLEAN DEFAULT TRUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            
            FOREIGN KEY (sport_id) REFERENCES sports(id) ON DELETE CASCADE,
            INDEX idx_sport_id (sport_id),
            INDEX idx_slug (slug),
            INDEX idx_active (active)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Events table
    $db->exec("
        CREATE TABLE IF NOT EXISTS events (
            id INT PRIMARY KEY AUTO_INCREMENT,
            sport_id INT NOT NULL,
            league_id INT NOT NULL,
            home_team_id INT NOT NULL,
            away_team_id INT NOT NULL,
            name VARCHAR(500) NOT NULL,
            start_time TIMESTAMP NOT NULL,
            status ENUM('scheduled', 'live', 'finished', 'cancelled', 'postponed') DEFAULT 'scheduled',
            home_score INT DEFAULT 0,
            away_score INT DEFAULT 0,
            match_time VARCHAR(10),
            featured BOOLEAN DEFAULT FALSE,
            live_streaming BOOLEAN DEFAULT FALSE,
            total_markets INT DEFAULT 0,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            
            FOREIGN KEY (sport_id) REFERENCES sports(id) ON DELETE CASCADE,
            FOREIGN KEY (league_id) REFERENCES leagues(id) ON DELETE CASCADE,
            FOREIGN KEY (home_team_id) REFERENCES teams(id) ON DELETE CASCADE,
            FOREIGN KEY (away_team_id) REFERENCES teams(id) ON DELETE CASCADE,
            INDEX idx_sport_id (sport_id),
            INDEX idx_league_id (league_id),
            INDEX idx_start_time (start_time),
            INDEX idx_status (status),
            INDEX idx_featured (featured)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Markets table
    $db->exec("
        CREATE TABLE IF NOT EXISTS markets (
            id INT PRIMARY KEY AUTO_INCREMENT,
            event_id INT NOT NULL,
            name VARCHAR(200) NOT NULL,
            type VARCHAR(50) NOT NULL,
            active BOOLEAN DEFAULT TRUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            
            FOREIGN KEY (event_id) REFERENCES events(id) ON DELETE CASCADE,
            INDEX idx_event_id (event_id),
            INDEX idx_type (type),
            INDEX idx_active (active)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Odds table
    $db->exec("
        CREATE TABLE IF NOT EXISTS odds (
            id INT PRIMARY KEY AUTO_INCREMENT,
            market_id INT NOT NULL,
            selection VARCHAR(100) NOT NULL,
            odds DECIMAL(10,2) NOT NULL,
            active BOOLEAN DEFAULT TRUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            
            FOREIGN KEY (market_id) REFERENCES markets(id) ON DELETE CASCADE,
            INDEX idx_market_id (market_id),
            INDEX idx_active (active),
            INDEX idx_updated_at (updated_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Bets table
    $db->exec("
        CREATE TABLE IF NOT EXISTS bets (
            id INT PRIMARY KEY AUTO_INCREMENT,
            user_id INT NOT NULL,
            event_id INT NOT NULL,
            market_id INT NOT NULL,
            odds_id INT NOT NULL,
            bet_type ENUM('single', 'accumulator', 'system') DEFAULT 'single',
            selection VARCHAR(100) NOT NULL,
            odds DECIMAL(10,2) NOT NULL,
            stake DECIMAL(20,8) NOT NULL,
            potential_payout DECIMAL(20,8) NOT NULL,
            actual_payout DECIMAL(20,8) DEFAULT 0.00000000,
            status ENUM('pending', 'won', 'lost', 'void', 'cancelled') DEFAULT 'pending',
            placed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            settled_at TIMESTAMP NULL,
            
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
            FOREIGN KEY (event_id) REFERENCES events(id) ON DELETE CASCADE,
            FOREIGN KEY (market_id) REFERENCES markets(id) ON DELETE CASCADE,
            FOREIGN KEY (odds_id) REFERENCES odds(id) ON DELETE CASCADE,
            INDEX idx_user_id (user_id),
            INDEX idx_event_id (event_id),
            INDEX idx_status (status),
            INDEX idx_placed_at (placed_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Transactions table
    $db->exec("
        CREATE TABLE IF NOT EXISTS transactions (
            id INT PRIMARY KEY AUTO_INCREMENT,
            user_id INT NOT NULL,
            type ENUM('deposit', 'withdrawal', 'bet', 'win', 'bonus', 'refund') NOT NULL,
            amount DECIMAL(20,8) NOT NULL,
            currency VARCHAR(10) DEFAULT 'USD',
            status ENUM('pending', 'completed', 'failed', 'cancelled') DEFAULT 'pending',
            transaction_hash VARCHAR(255),
            wallet_address VARCHAR(255),
            network VARCHAR(50),
            confirmations INT DEFAULT 0,
            required_confirmations INT DEFAULT 1,
            fee DECIMAL(20,8) DEFAULT 0.00000000,
            reference_id INT,
            reference_type VARCHAR(50),
            notes TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
            INDEX idx_user_id (user_id),
            INDEX idx_type (type),
            INDEX idx_status (status),
            INDEX idx_transaction_hash (transaction_hash),
            INDEX idx_created_at (created_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Bonuses table
    $db->exec("
        CREATE TABLE IF NOT EXISTS bonuses (
            id INT PRIMARY KEY AUTO_INCREMENT,
            name VARCHAR(200) NOT NULL,
            type ENUM('welcome', 'deposit', 'reload', 'no_deposit', 'free_bet', 'cashback', 'loyalty') NOT NULL,
            amount DECIMAL(20,8),
            percentage DECIMAL(5,2),
            max_amount DECIMAL(20,8),
            min_deposit DECIMAL(20,8),
            wagering_requirement INT DEFAULT 1,
            valid_days INT DEFAULT 30,
            code VARCHAR(50),
            active BOOLEAN DEFAULT TRUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            expires_at TIMESTAMP NULL,
            
            INDEX idx_type (type),
            INDEX idx_code (code),
            INDEX idx_active (active)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // User bonuses table
    $db->exec("
        CREATE TABLE IF NOT EXISTS user_bonuses (
            id INT PRIMARY KEY AUTO_INCREMENT,
            user_id INT NOT NULL,
            bonus_id INT NOT NULL,
            amount DECIMAL(20,8) NOT NULL,
            wagering_requirement DECIMAL(20,8) NOT NULL,
            wagered_amount DECIMAL(20,8) DEFAULT 0.00000000,
            status ENUM('active', 'completed', 'expired', 'cancelled') DEFAULT 'active',
            claimed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            expires_at TIMESTAMP NOT NULL,
            completed_at TIMESTAMP NULL,
            
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
            FOREIGN KEY (bonus_id) REFERENCES bonuses(id) ON DELETE CASCADE,
            INDEX idx_user_id (user_id),
            INDEX idx_status (status),
            INDEX idx_expires_at (expires_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Notifications table
    $db->exec("
        CREATE TABLE IF NOT EXISTS notifications (
            id INT PRIMARY KEY AUTO_INCREMENT,
            user_id INT NOT NULL,
            type VARCHAR(50) NOT NULL,
            title VARCHAR(200) NOT NULL,
            message TEXT NOT NULL,
            data JSON,
            read_at TIMESTAMP NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
            INDEX idx_user_id (user_id),
            INDEX idx_type (type),
            INDEX idx_read_at (read_at),
            INDEX idx_created_at (created_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Settings table
    $db->exec("
        CREATE TABLE IF NOT EXISTS settings (
            id INT PRIMARY KEY AUTO_INCREMENT,
            key_name VARCHAR(100) UNIQUE NOT NULL,
            value TEXT,
            type ENUM('string', 'integer', 'float', 'boolean', 'json') DEFAULT 'string',
            description TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            
            INDEX idx_key_name (key_name)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Insert default settings
    $defaultSettings = [
        ['site_name', 'Crashify', 'string', 'Site name'],
        ['site_description', 'Premium Crypto Betting Platform', 'string', 'Site description'],
        ['maintenance_mode', '0', 'boolean', 'Maintenance mode'],
        ['registration_enabled', '1', 'boolean', 'User registration enabled'],
        ['min_bet_amount', '0.01', 'float', 'Minimum bet amount'],
        ['max_bet_amount', '10000', 'float', 'Maximum bet amount'],
        ['max_payout', '100000', 'float', 'Maximum payout'],
        ['house_edge', '2.5', 'float', 'House edge percentage'],
        ['supported_currencies', '["BTC", "ETH", "USDT", "BNB"]', 'json', 'Supported cryptocurrencies']
    ];

    foreach ($defaultSettings as $setting) {
        $db->prepare("INSERT IGNORE INTO settings (key_name, value, type, description) VALUES (?, ?, ?, ?)")
           ->execute($setting);
    }

    return true;
}

// Initialize database
try {
    createTables();
} catch (Exception $e) {
    error_log("Database initialization failed: " . $e->getMessage());
}
?>

PHP
); ?>

<?php _merge_exec('config/languages.php', <<<'PHP'
<?php
// config/languages.php - Language Definitions
// تعریف زبان‌های پشتیبانی شده در سایت Crashify

class Language {
    private $currentLanguage;
    private $translations = [];
    private $fallbackLanguage = 'en';

    public function __construct($language = null) {
        $this->currentLanguage = $language ?: $this->detectLanguage();
        $this->loadTranslations();
    }

    private function detectLanguage() {
        // Check session
        if (isset($_SESSION['language']) && $this->isValidLanguage($_SESSION['language'])) {
            return $_SESSION['language'];
        }

        // Check cookie
        if (isset($_COOKIE['language']) && $this->isValidLanguage($_COOKIE['language'])) {
            return $_COOKIE['language'];
        }

        // Check browser language
        if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
            $browserLangs = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
            foreach ($browserLangs as $lang) {
                $lang = substr(trim($lang), 0, 2);
                if ($this->isValidLanguage($lang)) {
                    return $lang;
                }
            }
        }

        return DEFAULT_LANGUAGE;
    }

    private function isValidLanguage($lang) {
        return array_key_exists($lang, SUPPORTED_LANGUAGES);
    }

    private function loadTranslations() {
        $langFile = __DIR__ . "/../languages/{$this->currentLanguage}.php";
        if (file_exists($langFile)) {
            $this->translations = include $langFile;
        }

        // Load fallback if current language file is incomplete
        if ($this->currentLanguage !== $this->fallbackLanguage) {
            $fallbackFile = __DIR__ . "/../languages/{$this->fallbackLanguage}.php";
            if (file_exists($fallbackFile)) {
                $fallbackTranslations = include $fallbackFile;
                $this->translations = array_merge($fallbackTranslations, $this->translations);
            }
        }
    }

    public function get($key, $params = []) {
        $translation = $this->getNestedValue($this->translations, $key);
        
        if ($translation === null) {
            return $key; // Return key if translation not found
        }

        // Replace parameters
        if (!empty($params)) {
            foreach ($params as $param => $value) {
                $translation = str_replace("{{$param}}", $value, $translation);
            }
        }

        return $translation;
    }

    private function getNestedValue($array, $key) {
        $keys = explode('.', $key);
        $value = $array;

        foreach ($keys as $k) {
            if (!isset($value[$k])) {
                return null;
            }
            $value = $value[$k];
        }

        return $value;
    }

    public function setLanguage($language) {
        if ($this->isValidLanguage($language)) {
            $this->currentLanguage = $language;
            $_SESSION['language'] = $language;
            setcookie('language', $language, time() + (365 * 24 * 60 * 60), '/');
            $this->loadTranslations();
            return true;
        }
        return false;
    }

    public function getCurrentLanguage() {
        return $this->currentLanguage;
    }

    public function getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }

    public function isRTL() {
        return in_array($this->currentLanguage, ['ar', 'fa']);
    }

    public function getDirection() {
        return $this->isRTL() ? 'rtl' : 'ltr';
    }

    public function formatNumber($number, $decimals = 2) {
        $locales = [
            'en' => ['decimal' => '.', 'thousands' => ','],
            'fa' => ['decimal' => '/', 'thousands' => '،'],
            'ar' => ['decimal' => '.', 'thousands' => ','],
            'tr' => ['decimal' => ',', 'thousands' => '.'],
            'ru' => ['decimal' => ',', 'thousands' => ' '],
            'de' => ['decimal' => ',', 'thousands' => '.'],
            'fr' => ['decimal' => ',', 'thousands' => ' '],
            'es' => ['decimal' => ',', 'thousands' => '.']
        ];

        $locale = $locales[$this->currentLanguage] ?? $locales['en'];
        return number_format($number, $decimals, $locale['decimal'], $locale['thousands']);
    }

    public function formatCurrency($amount, $currency = 'USD') {
        $symbols = [
            'USD' => '$',
            'EUR' => '€',
            'GBP' => '£',
            'BTC' => '₿',
            'ETH' => 'Ξ',
            'USDT' => '₮'
        ];

        $symbol = $symbols[$currency] ?? $currency;
        $formattedAmount = $this->formatNumber($amount);

        // Different currency formats for different languages
        switch ($this->currentLanguage) {
            case 'fa':
                return $formattedAmount . ' ' . $symbol;
            case 'ar':
                return $symbol . ' ' . $formattedAmount;
            default:
                return $symbol . $formattedAmount;
        }
    }

    public function formatDate($timestamp, $format = 'default') {
        $formats = [
            'en' => [
                'default' => 'M j, Y H:i',
                'short' => 'M j',
                'long' => 'F j, Y \a\t H:i'
            ],
            'fa' => [
                'default' => 'j F Y H:i',
                'short' => 'j F',
                'long' => 'j F Y \s\a\a\t H:i'
            ],
            'ar' => [
                'default' => 'j F Y H:i',
                'short' => 'j F',
                'long' => 'j F Y \a\t H:i'
            ]
        ];

        $langFormats = $formats[$this->currentLanguage] ?? $formats['en'];
        $dateFormat = $langFormats[$format] ?? $langFormats['default'];

        return date($dateFormat, $timestamp);
    }
}

// Global language instance
$lang = new Language();

// Helper function for translations
function __($key, $params = []) {
    global $lang;
    return $lang->get($key, $params);
}

function _e($key, $params = []) {
    echo __($key, $params);
}

function getCurrentLanguage() {
    global $lang;
    return $lang->getCurrentLanguage();
}

function isRTL() {
    global $lang;
    return $lang->isRTL();
}

function getDirection() {
    global $lang;
    return $lang->getDirection();
}
?>

PHP
); ?>

<?php _merge_exec('includes/ footer.php', <<<'PHP'
<?php
// includes/footer.php - Footer Template
// فوتر سایت Crashify

?>
    </main>

    <!-- Footer -->
    <footer class="main-footer">
        <div class="container">
            <!-- Footer Top -->
            <div class="footer-top">
                <div class="footer-grid">
                    <!-- Company Info -->
                    <div class="footer-section">
                        <div class="footer-logo">
                            <div class="logo">
                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none">
                                    <rect width="40" height="40" rx="8" fill="url(#footerLogoGradient)"/>
                                    <path d="M12 28L20 12L28 28H24L20 20L16 28H12Z" fill="white"/>
                                    <defs>
                                        <linearGradient id="footerLogoGradient" x1="0" y1="0" x2="40" y2="40">
                                            <stop offset="0%" stop-color="#3B82F6"/>
                                            <stop offset="100%" stop-color="#1D4ED8"/>
                                        </linearGradient>
                                    </defs>
                                </svg>
                                <span class="logo-text">Crashify</span>
                            </div>
                        </div>
                        <p class="footer-description">
                            <?php _e('footer.company_description'); ?>
                        </p>
                        <div class="footer-stats">
                            <div class="stat-item">
                                <div class="stat-number" data-count="50000">0</div>
                                <div class="stat-label"><?php _e('footer.active_users'); ?></div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-number" data-count="1000000">0</div>
                                <div class="stat-label"><?php _e('footer.daily_volume'); ?></div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-number" data-count="99.9">0</div>
                                <div class="stat-label"><?php _e('footer.uptime'); ?>%</div>
                            </div>
                        </div>
                    </div>

                    <!-- Sports & Betting -->
                    <div class="footer-section">
                        <h4 class="footer-title"><?php _e('footer.sports_betting'); ?></h4>
                        <ul class="footer-links">
                            <li><a href="/pages/sportsbook.php"><?php _e('nav.sportsbook'); ?></a></li>
                            <li><a href="/pages/live-betting.php"><?php _e('nav.live_betting'); ?></a></li>
                            <li><a href="/pages/sportsbook.php?sport=football"><?php _e('sports.football'); ?></a></li>
                            <li><a href="/pages/sportsbook.php?sport=basketball"><?php _e('sports.basketball'); ?></a></li>
                            <li><a href="/pages/sportsbook.php?sport=tennis"><?php _e('sports.tennis'); ?></a></li>
                            <li><a href="/pages/esports.php"><?php _e('nav.esports'); ?></a></li>
                            <li><a href="/pages/virtual-sports.php"><?php _e('nav.virtual_sports'); ?></a></li>
                        </ul>
                    </div>

                    <!-- Casino -->
                    <div class="footer-section">
                        <h4 class="footer-title"><?php _e('footer.casino_games'); ?></h4>
                        <ul class="footer-links">
                            <li><a href="/pages/casino.php"><?php _e('nav.casino'); ?></a></li>
                            <li><a href="/pages/live-casino.php"><?php _e('casino.live_casino'); ?></a></li>
                            <li><a href="/pages/casino.php?category=slots"><?php _e('casino.slots'); ?></a></li>
                            <li><a href="/pages/casino.php?category=table"><?php _e('casino.table_games'); ?></a></li>
                            <li><a href="/pages/casino.php?category=crash"><?php _e('casino.crash_games'); ?></a></li>
                            <li><a href="/pages/casino.php?category=jackpots"><?php _e('casino.jackpots'); ?></a></li>
                            <li><a href="/pages/tournaments.php"><?php _e('casino.tournaments'); ?></a></li>
                        </ul>
                    </div>

                    <!-- Crypto & Payments -->
                    <div class="footer-section">
                        <h4 class="footer-title"><?php _e('footer.crypto_payments'); ?></h4>
                        <ul class="footer-links">
                            <li><a href="/pages/wallet.php"><?php _e('user.wallet'); ?></a></li>
                            <li><a href="/pages/deposit.php"><?php _e('wallet.deposit'); ?></a></li>
                            <li><a href="/pages/withdraw.php"><?php _e('wallet.withdraw'); ?></a></li>
                            <li><a href="/pages/crypto-guide.php"><?php _e('help.crypto_guide'); ?></a></li>
                            <li><a href="/pages/payment-methods.php">Payment Methods</a></li>
                            <li><a href="/pages/fees.php">Fees & Limits</a></li>
                        </ul>
                    </div>

                    <!-- Support -->
                    <div class="footer-section">
                        <h4 class="footer-title"><?php _e('footer.support_help'); ?></h4>
                        <ul class="footer-links">
                            <li><a href="/pages/support.php"><?php _e('support.help_center'); ?></a></li>
                            <li><a href="/pages/faq.php"><?php _e('support.faq'); ?></a></li>
                            <li><a href="/pages/live-chat.php"><?php _e('support.live_chat'); ?></a></li>
                            <li><a href="/pages/contact.php"><?php _e('support.contact_us'); ?></a></li>
                            <li><a href="/pages/responsible-gaming.php"><?php _e('support.responsible_gaming'); ?></a></li>
                            <li><a href="/pages/security.php"><?php _e('support.security'); ?></a></li>
                            <li><a href="/pages/guides.php"><?php _e('help.getting_started'); ?></a></li>
                        </ul>
                    </div>

                    <!-- Promotions -->
                    <div class="footer-section">
                        <h4 class="footer-title"><?php _e('footer.promotions'); ?></h4>
                        <ul class="footer-links">
                            <li><a href="/pages/promotions.php"><?php _e('nav.promotions'); ?></a></li>
                            <li><a href="/pages/bonuses.php"><?php _e('bonuses.welcome_bonus'); ?></a></li>
                            <li><a href="/pages/vip.php"><?php _e('nav.vip'); ?></a></li>
                            <li><a href="/pages/loyalty.php"><?php _e('bonuses.loyalty_points'); ?></a></li>
                            <li><a href="/pages/referral.php"><?php _e('bonuses.referral_program'); ?></a></li>
                            <li><a href="/pages/tournaments.php"><?php _e('nav.tournaments'); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Newsletter Section -->
            <div class="footer-newsletter">
                <div class="newsletter-content">
                    <div class="newsletter-text">
                        <h3><?php _e('newsletter.title'); ?></h3>
                        <p><?php _e('newsletter.description'); ?></p>
                        <div class="newsletter-benefits">
                            <div class="benefit-item">
                                <i class="fas fa-gift"></i>
                                <span><?php _e('newsletter.benefit_1'); ?></span>
                            </div>
                            <div class="benefit-item">
                                <i class="fas fa-bullhorn"></i>
                                <span><?php _e('newsletter.benefit_2'); ?></span>
                            </div>
                            <div class="benefit-item">
                                <i class="fas fa-chart-line"></i>
                                <span><?php _e('newsletter.benefit_3'); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="newsletter-form">
                        <form id="newsletterForm" class="newsletter-signup">
                            <div class="form-group">
                                <input type="email" 
                                       id="newsletterEmail" 
                                       placeholder="<?php _e('newsletter.email_placeholder'); ?>" 
                                       required>
                                <button type="submit" class="btn btn-primary">
                                    <?php _e('newsletter.subscribe'); ?>
                                    <i class="fas fa-arrow-right"></i>
                                </button>
                            </div>
                            <div class="newsletter-privacy">
                                <small>
                                    <i class="fas fa-shield-alt"></i>
                                    We respect your privacy. Unsubscribe at any time.
                                </small>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Payment Methods -->
            <div class="footer-payments">
                <div class="payments-section">
                    <h4>Accepted Cryptocurrencies</h4>
                    <div class="payment-methods">
                        <div class="payment-item">
                            <i class="fab fa-bitcoin"></i>
                            <span>Bitcoin</span>
                        </div>
                        <div class="payment-item">
                            <i class="fab fa-ethereum"></i>
                            <span>Ethereum</span>
                        </div>
                        <div class="payment-item">
                            <img src="/assets/images/crypto/usdt.png" alt="USDT">
                            <span>USDT</span>
                        </div>
                        <div class="payment-item">
                            <img src="/assets/images/crypto/bnb.png" alt="BNB">
                            <span>BNB</span>
                        </div>
                        <div class="payment-item">
                            <img src="/assets/images/crypto/ada.png" alt="ADA">
                            <span>Cardano</span>
                        </div>
                        <div class="payment-item">
                            <img src="/assets/images/crypto/dot.png" alt="DOT">
                            <span>Polkadot</span>
                        </div>
                        <div class="payment-item">
                            <img src="/assets/images/crypto/ltc.png" alt="LTC">
                            <span>Litecoin</span>
                        </div>
                        <div class="payment-item">
                            <img src="/assets/images/crypto/trx.png" alt="TRX">
                            <span>TRON</span>
                        </div>
                    </div>
                </div>

                <div class="security-badges">
                    <div class="badge-item">
                        <i class="fas fa-shield-alt"></i>
                        <span><?php _e('footer.ssl_secured'); ?></span>
                    </div>
                    <div class="badge-item">
                        <i class="fas fa-certificate"></i>
                        <span><?php _e('footer.fair_gaming'); ?></span>
                    </div>
                    <div class="badge-item">
                        <i class="fas fa-user-shield"></i>
                        <span>Licensed & Regulated</span>
                    </div>
                </div>
            </div>

            <!-- Social Media -->
            <div class="footer-social">
                <h4>Follow Us</h4>
                <div class="social-links">
                    <a href="https://twitter.com/crashify" target="_blank" class="social-link twitter">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <a href="https://facebook.com/crashify" target="_blank" class="social-link facebook">
                        <i class="fab fa-facebook"></i>
                    </a>
                    <a href="https://instagram.com/crashify" target="_blank" class="social-link instagram">
                        <i class="fab fa-instagram"></i>
                    </a>
                    <a href="https://youtube.com/crashify" target="_blank" class="social-link youtube">
                        <i class="fab fa-youtube"></i>
                    </a>
                    <a href="https://discord.gg/crashify" target="_blank" class="social-link discord">
                        <i class="fab fa-discord"></i>
                    </a>
                    <a href="https://t.me/crashify" target="_blank" class="social-link telegram">
                        <i class="fab fa-telegram"></i>
                    </a>
                </div>
            </div>

            <!-- Footer Bottom -->
            <div class="footer-bottom">
                <div class="footer-bottom-content">
                    <div class="footer-legal">
                        <div class="copyright">
                            <p>&copy; <?php echo date('Y'); ?> Crashify. <?php _e('footer.all_rights_reserved'); ?></p>
                            <p class="license-info"><?php _e('footer.license_info'); ?></p>
                        </div>
                        <div class="legal-links">
                            <a href="/pages/terms.php"><?php _e('legal.terms_conditions'); ?></a>
                            <a href="/pages/privacy.php"><?php _e('legal.privacy_policy'); ?></a>
                            <a href="/pages/cookies.php"><?php _e('legal.cookie_policy'); ?></a>
                            <a href="/pages/responsible-gaming.php"><?php _e('legal.responsible_gaming'); ?></a>
                            <a href="/pages/aml.php"><?php _e('legal.aml_policy'); ?></a>
                            <a href="/pages/kyc.php"><?php _e('legal.kyc_policy'); ?></a>
                        </div>
                    </div>

                    <div class="footer-age-verification">
                        <div class="age-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            <span><?php _e('footer.age_verification'); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Back to Top Button -->
    <button id="backToTop" class="back-to-top" onclick="scrollToTop()" style="display: none;">
        <i class="fas fa-arrow-up"></i>
    </button>

    <!-- Cookie Consent Banner -->
    <div id="cookieBanner" class="cookie-banner" style="display: none;">
        <div class="cookie-content">
            <div class="cookie-text">
                <i class="fas fa-cookie-bite"></i>
                <p><?php _e('cookies.consent_message'); ?></p>
            </div>
            <div class="cookie-actions">
                <button class="btn btn-outline btn-sm" onclick="showCookieSettings()">
                    <?php _e('cookies.settings'); ?>
                </button>
                <button class="btn btn-primary btn-sm" onclick="acceptCookies()">
                    <?php _e('cookies.accept_all'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- Cookie Settings Modal -->
    <div class="modal-backdrop" id="cookieSettingsModal">
        <div class="modal">
            <div class="modal-header">
                <h3 class="modal-title"><?php _e('cookies.settings'); ?></h3>
                <button class="modal-close" onclick="closeModal('cookieSettingsModal')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="cookie-categories">
                    <div class="cookie-category">
                        <div class="category-header">
                            <h4><?php _e('cookies.necessary'); ?></h4>
                            <label class="toggle-switch">
                                <input type="checkbox" checked disabled>
                                <span class="toggle-slider"></span>
                            </label>
                        </div>
                        <p>These cookies are essential for the website to function properly.</p>
                    </div>
                    
                    <div class="cookie-category">
                        <div class="category-header">
                            <h4><?php _e('cookies.analytics'); ?></h4>
                            <label class="toggle-switch">
                                <input type="checkbox" id="analyticsCookies">
                                <span class="toggle-slider"></span>
                            </label>
                        </div>
                        <p>These cookies help us understand how visitors interact with our website.</p>
                    </div>
                    
                    <div class="cookie-category">
                        <div class="category-header">
                            <h4><?php _e('cookies.marketing'); ?></h4>
                            <label class="toggle-switch">
                                <input type="checkbox" id="marketingCookies">
                                <span class="toggle-slider"></span>
                            </label>
                        </div>
                        <p>These cookies are used to deliver personalized advertisements.</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-outline" onclick="closeModal('cookieSettingsModal')">
                    <?php _e('common.cancel'); ?>
                </button>
                <button class="btn btn-primary" onclick="saveCookiePreferences()">
                    <?php _e('cookies.save_preferences'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="/assets/js/main.js"></script>
    <script src="/assets/js/components.js"></script>
    <script src="/assets/js/betting.js"></script>
    
    <!-- Initialize -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize theme
            const savedTheme = localStorage.getItem('theme') || 'light';
            initializeTheme(savedTheme);
            
            // Initialize user session
            <?php if ($currentUser): ?>
            initializeUserSession(<?php echo json_encode($currentUser); ?>);
            <?php endif; ?>
            
            // Check cookie consent
            checkCookieConsent();
            
            // Hide loading screen
            hideLoadingScreen();
            
            // Initialize footer stats animation
            initializeFooterStats();
            
            // Initialize newsletter form
            initializeNewsletterForm();
        });

        // Footer stats animation
        function initializeFooterStats() {
            const stats = document.querySelectorAll('.stat-number[data-count]');
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        animateCounter(entry.target);
                        observer.unobserve(entry.target);
                    }
                });
            });
            
            stats.forEach(stat => observer.observe(stat));
        }

        function animateCounter(element) {
            const target = parseInt(element.dataset.count);
            const duration = 2000;
            const start = performance.now();
            
            function update(currentTime) {
                const elapsed = currentTime - start;
                const progress = Math.min(elapsed / duration, 1);
                const current = Math.floor(progress * target);
                
                element.textContent = current.toLocaleString();
                
                if (progress < 1) {
                    requestAnimationFrame(update);
                }
            }
            
            requestAnimationFrame(update);
        }

        // Newsletter form
        function initializeNewsletterForm() {
            const form = document.getElementById('newsletterForm');
            if (form) {
                form.addEventListener('submit', async (e) => {
                    e.preventDefault();
                    
                    const email = document.getElementById('newsletterEmail').value;
                    const submitBtn = form.querySelector('button[type="submit"]');
                    
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Subscribing...';
                    
                    try {
                        const response = await Crashify.api.request('/newsletter/subscribe', {
                            method: 'POST',
                            body: JSON.stringify({ email })
                        });
                        
                        if (response.success) {
                            Crashify.ui.toast.success('<?php _e("newsletter.subscribed"); ?>');
                            form.reset();
                        } else {
                            throw new Error(response.message);
                        }
                    } catch (error) {
                        Crashify.ui.toast.error(error.message || 'Subscription failed');
                    } finally {
                        submitBtn.disabled = false;
                        submitBtn.innerHTML = '<?php _e("newsletter.subscribe"); ?> <i class="fas fa-arrow-right"></i>';
                    }
                });
            }
        }

        // Cookie preferences
        function saveCookiePreferences() {
            const analytics = document.getElementById('analyticsCookies').checked;
            const marketing = document.getElementById('marketingCookies').checked;
            
            const preferences = {
                necessary: true,
                analytics: analytics,
                marketing: marketing
            };
            
            Crashify.utils.storage.set('cookiePreferences', preferences);
            Crashify.utils.storage.set('cookieConsent', true);
            
            closeModal('cookieSettingsModal');
            
            const banner = document.getElementById('cookieBanner');
            if (banner) {
                Crashify.utils.fadeOut(banner);
            }
            
            Crashify.ui.toast.success('Cookie preferences saved');
        }
    </script>

    <!-- Additional page-specific scripts -->
    <?php if (isset($additionalScripts)): ?>
        <?php foreach ($additionalScripts as $script): ?>
            <script src="<?php echo $script; ?>"></script>
        <?php endforeach; ?>
    <?php endif; ?>

    <!-- Inline scripts -->
    <?php if (isset($inlineScripts)): ?>
        <script>
            <?php echo $inlineScripts; ?>
        </script>
    <?php endif; ?>
</body>
</html>
PHP
); ?>

<?php _merge_exec('includes/auth.php', <<<'PHP'
<?php
if (defined('CRASHIFY_AUTH_INCLUDED')) return;
define('CRASHIFY_AUTH_INCLUDED', true);

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/functions.php';

// includes/auth.php - Authentication System
// سیستم احراز هویت Crashify

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!class_exists('Auth')) {
class Auth {
    private static $instance = null;
    private $currentUser = null;
    private $sessionTimeout = 7200; // 2 hours
    
    private function __construct() {
        $this->checkSession();
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function checkSession() {
        // Check if user is logged in
        if (!isset($_SESSION['user_id'])) {
            return false;
        }
        
        // Check session timeout
        if (isset($_SESSION['last_activity']) && 
            (time() - $_SESSION['last_activity']) > $this->sessionTimeout) {
            $this->logout();
            return false;
        }
        
        // Update last activity
        $_SESSION['last_activity'] = time();
        
        // Load current user
        $this->loadCurrentUser();
        
        return true;
    }
    
    private function loadCurrentUser() {
        if (!isset($_SESSION['user_id'])) {
            return;
        }
        
        try {
            $this->currentUser = fetchOne(
                "SELECT u.*, 
                        COUNT(DISTINCT b.id) as total_bets,
                        COUNT(DISTINCT CASE WHEN b.status = 'won' THEN b.id END) as total_wins,
                        COUNT(DISTINCT CASE WHEN b.status = 'lost' THEN b.id END) as total_losses,
                        COALESCE(SUM(CASE WHEN b.status = 'won' THEN b.actual_payout ELSE 0 END), 0) as total_winnings,
                        COALESCE(SUM(b.stake), 0) as total_wagered,
                        COUNT(DISTINCT ub.id) as active_bonuses,
                        COUNT(DISTINCT CASE WHEN n.read_at IS NULL THEN n.id END) as unread_notifications
                 FROM users u 
                 LEFT JOIN bets b ON u.id = b.user_id 
                 LEFT JOIN user_bonuses ub ON u.id = ub.user_id AND ub.status = 'active'
                 LEFT JOIN notifications n ON u.id = n.user_id
                 WHERE u.id = ? AND u.status = 'active'
                 GROUP BY u.id",
                [$_SESSION['user_id']]
            );
            
            if (!$this->currentUser) {
                $this->logout();
                return;
            }
            
            // Calculate win rate
            $this->currentUser['win_rate'] = $this->currentUser['total_bets'] > 0 ? 
                ($this->currentUser['total_wins'] / $this->currentUser['total_bets']) * 100 : 0;
            
            // Update user's last activity
            updateRecord('users', [
                'last_login' => date('Y-m-d H:i:s'),
                'last_ip' => $this->getClientIP()
            ], 'id = ?', [$this->currentUser['id']]);
            
        } catch (Exception $e) {
            error_log("Failed to load current user: " . $e->getMessage());
            $this->logout();
        }
    }
    
    public function login($identifier, $password, $rememberMe = false) {
        try {
            // Rate limiting
            $clientIP = $this->getClientIP();
            if (!$this->checkRateLimit('login_' . $clientIP, 5, 900)) { // 5 attempts per 15 minutes
                return [
                    'success' => false, 
                    'message' => 'Too many login attempts. Please try again later.',
                    'code' => 'RATE_LIMITED'
                ];
            }
            
            // Find user by email or username
            $user = fetchOne(
                "SELECT * FROM users WHERE (email = ? OR username = ?) AND status = 'active'",
                [$identifier, $identifier]
            );
            
            if (!$user) {
                $this->recordFailedAttempt($identifier, $clientIP, 'user_not_found');
                return [
                    'success' => false, 
                    'message' => 'Invalid email/username or password',
                    'code' => 'INVALID_CREDENTIALS'
                ];
            }
            
            // Verify password
            if (!password_verify($password, $user['password_hash'])) {
                $this->recordFailedAttempt($identifier, $clientIP, 'invalid_password', $user['id']);
                return [
                    'success' => false, 
                    'message' => 'Invalid email/username or password',
                    'code' => 'INVALID_CREDENTIALS'
                ];
            }
            
            // Check if account is locked
            if ($this->isAccountLocked($user['id'])) {
                return [
                    'success' => false, 
                    'message' => 'Account is temporarily locked due to multiple failed attempts',
                    'code' => 'ACCOUNT_LOCKED'
                ];
            }
            
            // Check 2FA if enabled
            if ($user['two_factor_enabled']) {
                $_SESSION['2fa_user_id'] = $user['id'];
                return [
                    'success' => false,
                    'message' => 'Two-factor authentication required',
                    'code' => 'REQUIRE_2FA',
                    'redirect' => '/auth/2fa.php'
                ];
            }
            
            // Login successful
            $this->createSession($user, $rememberMe);
            $this->clearFailedAttempts($user['id']);
            $this->logActivity($user['id'], 'login', ['ip' => $clientIP]);
            
            return [
                'success' => true,
                'message' => 'Login successful',
                'user' => $this->sanitizeUserData($user),
                'redirect' => $_SESSION['redirect_after_login'] ?? '/dashboard'
            ];
            
        } catch (Exception $e) {
            error_log("Login error: " . $e->getMessage());
            return [
                'success' => false,
                'message' => 'An error occurred during login',
                'code' => 'SYSTEM_ERROR'
            ];
        }
    }
    
    public function register($userData) {
        try {
            // Validate input
            $validation = $this->validateRegistrationData($userData);
            if (!$validation['valid']) {
                return [
                    'success' => false,
                    'message' => 'Validation failed',
                    'errors' => $validation['errors']
                ];
            }
            
            // Rate limiting
            $clientIP = $this->getClientIP();
            if (!$this->checkRateLimit('register_' . $clientIP, 3, 3600)) { // 3 registrations per hour
                return [
                    'success' => false,
                    'message' => 'Too many registration attempts. Please try again later.',
                    'code' => 'RATE_LIMITED'
                ];
            }
            
            // Check if user already exists
            $existingUser = fetchOne(
                "SELECT id FROM users WHERE email = ? OR username = ?",
                [$userData['email'], $userData['username']]
            );
            
            if ($existingUser) {
                return [
                    'success' => false,
                    'message' => 'User with this email or username already exists',
                    'code' => 'USER_EXISTS'
                ];
            }
            
            beginTransaction();
            
            // Create user account
            $userId = insertRecord('users', [
                'username' => $userData['username'],
                'email' => $userData['email'],
                'password_hash' => password_hash($userData['password'], PASSWORD_ARGON2ID, [
                    'memory_cost' => 65536,
                    'time_cost' => 4,
                    'threads' => 3
                ]),
                'first_name' => $userData['first_name'] ?? '',
                'last_name' => $userData['last_name'] ?? '',
                'country' => $userData['country'] ?? '',
                'date_of_birth' => $userData['date_of_birth'] ?? null,
                'created_at' => date('Y-m-d H:i:s')
            ]);
            
            // Create email verification token
            $verificationToken = $this->generateSecureToken(64);
            insertRecord('email_verifications', [
                'user_id' => $userId,
                'token' => hash('sha256', $verificationToken),
                'expires_at' => date('Y-m-d H:i:s', strtotime('+24 hours'))
            ]);
            
            // Create welcome bonus
            $this->createWelcomeBonus($userId);
            
            // Send welcome email
            $this->sendWelcomeEmail($userData['email'], $userData['username'], $verificationToken);
            
            // Log activity
            $this->logActivity($userId, 'register', ['ip' => $clientIP]);
            
            commit();
            
            return [
                'success' => true,
                'message' => 'Registration successful! Please check your email to verify your account.',
                'user_id' => $userId
            ];
            
        } catch (Exception $e) {
            rollback();
            error_log("Registration error: " . $e->getMessage());
            return [
                'success' => false,
                'message' => 'An error occurred during registration',
                'code' => 'SYSTEM_ERROR'
            ];
        }
    }
    
    public function verify2FA($code) {
        if (!isset($_SESSION['2fa_user_id'])) {
            return ['success' => false, 'message' => 'Invalid session'];
        }
        
        $user = fetchOne("SELECT * FROM users WHERE id = ?", [$_SESSION['2fa_user_id']]);
        if (!$user) {
            return ['success' => false, 'message' => 'User not found'];
        }
        
        // Verify TOTP code
        if (!$this->verifyTOTP($user['two_factor_secret'], $code)) {
            return ['success' => false, 'message' => 'Invalid verification code'];
        }
        
        // Complete login
        unset($_SESSION['2fa_user_id']);
        $this->createSession($user);
        
        return [
            'success' => true,
            'message' => 'Login successful',
            'redirect' => '/dashboard'
        ];
    }
    
    public function logout() {
        if (isset($_SESSION['user_id'])) {
            // Log activity
            $this->logActivity($_SESSION['user_id'], 'logout');
            
            // Remove session from database
            deleteRecord('user_sessions', 'id = ?', [session_id()]);
            
            // Clear remember me token
            if (isset($_COOKIE['remember_token'])) {
                deleteRecord('remember_tokens', 'token = ?', [hash('sha256', $_COOKIE['remember_token'])]);
                setcookie('remember_token', '', time() - 3600, '/', '', true, true);
            }
        }
        
        // Clear session data
        session_unset();
        session_destroy();
        
        // Start new session
        session_start();
        session_regenerate_id(true);
        
        $this->currentUser = null;
    }
    
    public function getCurrentUser() {
        return $this->currentUser;
    }
    
    public function isLoggedIn() {
        return $this->currentUser !== null;
    }
    
    public function requireAuth() {
        if (!$this->isLoggedIn()) {
            $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];
            header('Location: /auth/login.php');
            exit;
        }
    }
    
    public function requireGuest() {
        if ($this->isLoggedIn()) {
            header('Location: /dashboard');
            exit;
        }
    }
    
    private function createSession($user, $rememberMe = false) {
        // Regenerate session ID
        session_regenerate_id(true);
        
        // Set session variables
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['login_time'] = time();
        $_SESSION['last_activity'] = time();
        
        // Create session record
        insertRecord('user_sessions', [
            'id' => session_id(),
            'user_id' => $user['id'],
            'ip_address' => $this->getClientIP(),
            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? '',
            'created_at' => date('Y-m-d H:i:s')
        ]);
        
        // Handle remember me
        if ($rememberMe) {
            $token = $this->generateSecureToken(64);
            $hashedToken = hash('sha256', $token);
            
            insertRecord('remember_tokens', [
                'user_id' => $user['id'],
                'token' => $hashedToken,
                'expires_at' => date('Y-m-d H:i:s', strtotime('+30 days'))
            ]);
            
            setcookie('remember_token', $token, time() + (30 * 24 * 60 * 60), '/', '', true, true);
        }
        
        $this->currentUser = $user;
    }
    
    private function validateRegistrationData($data) {
        $errors = [];
        
        // Username validation
        if (empty($data['username'])) {
            $errors['username'] = 'Username is required';
        } elseif (strlen($data['username']) < 3 || strlen($data['username']) > 20) {
            $errors['username'] = 'Username must be between 3 and 20 characters';
        } elseif (!preg_match('/^[a-zA-Z0-9_]+$/', $data['username'])) {
            $errors['username'] = 'Username can only contain letters, numbers, and underscores';
        }
        
        // Email validation
        if (empty($data['email'])) {
            $errors['email'] = 'Email is required';
        } elseif (!filter_var($data['email'], FILTER_VALIDATE_EMAIL)) {
            $errors['email'] = 'Invalid email format';
        }
        
        // Password validation
        if (empty($data['password'])) {
            $errors['password'] = 'Password is required';
        } elseif (strlen($data['password']) < 8) {
            $errors['password'] = 'Password must be at least 8 characters long';
        } elseif (!preg_match('/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)/', $data['password'])) {
            $errors['password'] = 'Password must contain at least one uppercase letter, one lowercase letter, and one number';
        }
        
        // Confirm password
        if (empty($data['confirm_password'])) {
            $errors['confirm_password'] = 'Please confirm your password';
        } elseif ($data['password'] !== $data['confirm_password']) {
            $errors['confirm_password'] = 'Passwords do not match';
        }
        
        // Age verification
        if (!empty($data['date_of_birth'])) {
            $birthDate = new DateTime($data['date_of_birth']);
            $today = new DateTime();
            $age = $today->diff($birthDate)->y;
            
            if ($age < 18) {
                $errors['date_of_birth'] = 'You must be at least 18 years old to register';
            }
        }
        
        // Terms acceptance
        if (empty($data['accept_terms'])) {
            $errors['accept_terms'] = 'You must accept the terms and conditions';
        }
        
        return [
            'valid' => empty($errors),
            'errors' => $errors
        ];
    }
    
    private function isAccountLocked($userId) {
        $lockTime = fetchColumn(
            "SELECT locked_until FROM users WHERE id = ? AND locked_until > NOW()",
            [$userId]
        );
        
        return $lockTime !== false;
    }
    
    private function recordFailedAttempt($identifier, $ip, $reason, $userId = null) {
        insertRecord('login_attempts', [
            'user_id' => $userId,
            'identifier' => $identifier,
            'ip_address' => $ip,
            'reason' => $reason,
            'created_at' => date('Y-m-d H:i:s')
        ]);
        
        // Check if we should lock the account
        if ($userId) {
            $recentAttempts = fetchColumn(
                "SELECT COUNT(*) FROM login_attempts 
                 WHERE user_id = ? AND created_at > DATE_SUB(NOW(), INTERVAL 15 MINUTE)",
                [$userId]
            );
            
            if ($recentAttempts >= 5) {
                updateRecord('users', [
                    'locked_until' => date('Y-m-d H:i:s', strtotime('+30 minutes'))
                ], 'id = ?', [$userId]);
            }
        }
    }
    
    private function clearFailedAttempts($userId) {
        deleteRecord('login_attempts', 'user_id = ?', [$userId]);
        updateRecord('users', ['locked_until' => null], 'id = ?', [$userId]);
    }
    
    private function checkRateLimit($key, $maxAttempts, $timeWindow) {
        $cacheKey = "rate_limit:{$key}";
        $attempts = apcu_fetch($cacheKey) ?: 0;
        
        if ($attempts >= $maxAttempts) {
            return false;
        }
        
        apcu_store($cacheKey, $attempts + 1, $timeWindow);
        return true;
    }
    
    private function generateSecureToken($length = 32) {
        return bin2hex(random_bytes($length));
    }
    
    private function getClientIP() {
        $ipKeys = ['HTTP_CF_CONNECTING_IP', 'HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'REMOTE_ADDR'];
        
        foreach ($ipKeys as $key) {
            if (array_key_exists($key, $_SERVER) === true) {
                foreach (explode(',', $_SERVER[$key]) as $ip) {
                    $ip = trim($ip);
                    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false) {
                        return $ip;
                    }
                }
            }
        }
        
        return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    }
    
    private function sanitizeUserData($user) {
        unset($user['password_hash']);
        unset($user['two_factor_secret']);
        return $user;
    }
    
    private function logActivity($userId, $action, $details = []) {
        insertRecord('activity_logs', [
            'user_id' => $userId,
            'action' => $action,
            'details' => json_encode($details),
            'ip_address' => $this->getClientIP(),
            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? '',
            'created_at' => date('Y-m-d H:i:s')
        ]);
    }
    
    private function createWelcomeBonus($userId) {
        $welcomeBonus = fetchOne(
            "SELECT * FROM bonuses WHERE type = 'welcome' AND active = 1 ORDER BY id DESC LIMIT 1"
        );
        
        if ($welcomeBonus) {
            $amount = $welcomeBonus['amount'];
            $wageringRequirement = $amount * $welcomeBonus['wagering_requirement'];
            $expiresAt = date('Y-m-d H:i:s', strtotime("+{$welcomeBonus['valid_days']} days"));
            
            insertRecord('user_bonuses', [
                'user_id' => $userId,
                'bonus_id' => $welcomeBonus['id'],
                'amount' => $amount,
                'wagering_requirement' => $wageringRequirement,
                'expires_at' => $expiresAt
            ]);
            
            // Add to user bonus balance
            updateRecord('users', [
                'bonus_balance' => $amount
            ], 'id = ?', [$userId]);
        }
    }
    
    private function sendWelcomeEmail($email, $username, $verificationToken) {
        // Email sending logic would go here
        // For now, just log it
        error_log("Welcome email sent to {$email} with verification token");
    }
    
    private function verifyTOTP($secret, $code) {
        // TOTP verification logic
        // This would use a library like RobThree/TwoFactorAuth
        return true; // Placeholder
    }
}
}

// Global auth instance
$auth = Auth::getInstance();
$currentUser = $auth->getCurrentUser();

// Helper functions
function requireAuth() {
    global $auth;
    $auth->requireAuth();
}

function requireGuest() {
    global $auth;
    $auth->requireGuest();
}

function isLoggedIn() {
    global $auth;
    return $auth->isLoggedIn();
}

function getCurrentUser() {
    global $currentUser;
    return $currentUser;
}
?>

PHP
); ?>

<?php _merge_exec('includes/functions.php', <<<'PHP'
<?php
if (defined('CRASHIFY_FUNCTIONS_INCLUDED')) return;
define('CRASHIFY_FUNCTIONS_INCLUDED', true);

require_once __DIR__ . '/../config/config.php';

// includes/functions.php - Common Functions
// توابع مشترک و کاربردی برای سایت Crashify

require_once __DIR__ . '/../config/config.php';
require_once '../config/database.php';
require_once '../config/languages.php';

// Security Functions
function sanitizeInput($input) {
    if (is_array($input)) {
        return array_map('sanitizeInput', $input);
    }
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

function validateEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

function validatePassword($password) {
    // At least 8 characters, 1 uppercase, 1 lowercase, 1 number
    return preg_match('/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)[a-zA-Z\d@$!%*?&]{8,}$/', $password);
}

function generateToken($length = 32) {
    return bin2hex(random_bytes($length));
}

function hashPassword($password) {
    return password_hash($password, PASSWORD_ARGON2ID, [
        'memory_cost' => 65536,
        'time_cost' => 4,
        'threads' => 3
    ]);
}

function verifyPassword($password, $hash) {
    return password_verify($password, $hash);
}

function generateJWT($payload) {
    $header = json_encode(['typ' => 'JWT', 'alg' => 'HS256']);
    $payload = json_encode($payload);
    
    $base64Header = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
    $base64Payload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));
    
    $signature = hash_hmac('sha256', $base64Header . "." . $base64Payload, JWT_SECRET, true);
    $base64Signature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));
    
    return $base64Header . "." . $base64Payload . "." . $base64Signature;
}

function verifyJWT($jwt) {
    $parts = explode('.', $jwt);
    if (count($parts) !== 3) {
        return false;
    }
    
    [$header, $payload, $signature] = $parts;
    
    $validSignature = hash_hmac('sha256', $header . "." . $payload, JWT_SECRET, true);
    $validSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($validSignature));
    
    if (!hash_equals($signature, $validSignature)) {
        return false;
    }
    
    $payload = json_decode(base64_decode(str_replace(['-', '_'], ['+', '/'], $payload)), true);
    
    // Check expiration
    if (isset($payload['exp']) && $payload['exp'] < time()) {
        return false;
    }
    
    return $payload;
}

// User Functions
function isLoggedIn() {
    return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
}

function getCurrentUser() {
    if (!isLoggedIn()) {
        return null;
    }
    
    global $db;
    return $db->fetch("SELECT * FROM users WHERE id = ? AND status = 'active'", [$_SESSION['user_id']]);
}

function getUserBalance($userId, $currency = 'USD') {
    global $db;
    $balance = $db->fetch("SELECT balance FROM user_balances WHERE user_id = ? AND currency = ?", [$userId, $currency]);
    return $balance ? floatval($balance['balance']) : 0.0;
}

function updateUserBalance($userId, $currency, $amount, $type = 'add') {
    global $db;
    
    $db->beginTransaction();
    try {
        $currentBalance = getUserBalance($userId, $currency);
        
        if ($type === 'subtract' && $currentBalance < $amount) {
            throw new Exception('Insufficient balance');
        }
        
        $newBalance = $type === 'add' ? $currentBalance + $amount : $currentBalance - $amount;
        
        $db->query("INSERT INTO user_balances (user_id, currency, balance) VALUES (?, ?, ?) 
                   ON DUPLICATE KEY UPDATE balance = ?", 
                   [$userId, $currency, $newBalance, $newBalance]);
        
        // Log transaction
        $db->insert('transactions', [
            'user_id' => $userId,
            'type' => $type,
            'amount' => $amount,
            'currency' => $currency,
            'balance_before' => $currentBalance,
            'balance_after' => $newBalance,
            'created_at' => date('Y-m-d H:i:s')
        ]);
        
        $db->commit();
        return true;
    } catch (Exception $e) {
        $db->rollback();
        return false;
    }
}

// Crypto Functions
function generateCryptoAddress($currency, $userId) {
    // This would integrate with actual crypto wallet APIs
    $addresses = [
        'BTC' => '1' . substr(hash('sha256', $userId . $currency . time()), 0, 33),
        'ETH' => '0x' . substr(hash('sha256', $userId . $currency . time()), 0, 40),
        'USDT' => '0x' . substr(hash('sha256', $userId . $currency . time()), 0, 40),
        'LTC' => 'L' . substr(hash('sha256', $userId . $currency . time()), 0, 33)
    ];
    
    return $addresses[$currency] ?? null;
}

function validateCryptoAddress($address, $currency) {
    $patterns = [
        'BTC' => '/^[13][a-km-zA-HJ-NP-Z1-9]{25,34}$/',
        'ETH' => '/^0x[a-fA-F0-9]{40}$/',
        'USDT' => '/^0x[a-fA-F0-9]{40}$/',
        'LTC' => '/^[LM3][a-km-zA-HJ-NP-Z1-9]{26,33}$/'
    ];
    
    return isset($patterns[$currency]) && preg_match($patterns[$currency], $address);
}

function getCryptoPrice($currency) {
    // This would integrate with actual crypto price APIs
    $prices = [
        'BTC' => 45000 + rand(-1000, 1000),
        'ETH' => 3000 + rand(-100, 100),
        'USDT' => 1.00,
        'LTC' => 150 + rand(-10, 10)
    ];
    
    return $prices[$currency] ?? 0;
}

// Betting Functions
function calculateOdds($probability) {
    if ($probability <= 0 || $probability >= 1) {
        return 1.01;
    }
    
    $fairOdds = 1 / $probability;
    $oddsWithMargin = $fairOdds * (1 + HOUSE_EDGE);
    
    return round($oddsWithMargin, 2);
}

function calculatePayout($stake, $odds) {
    return round($stake * $odds, 2);
}

function validateBet($userId, $amount, $odds) {
    if ($amount < MIN_BET_AMOUNT || $amount > MAX_BET_AMOUNT) {
        return ['valid' => false, 'message' => 'Invalid bet amount'];
    }
    
    if ($odds < 1.01 || $odds > MAX_ODDS) {
        return ['valid' => false, 'message' => 'Invalid odds'];
    }
    
    $payout = calculatePayout($amount, $odds);
    if ($payout > MAX_PAYOUT) {
        return ['valid' => false, 'message' => 'Payout exceeds maximum limit'];
    }
    
    $balance = getUserBalance($userId);
    if ($balance < $amount) {
        return ['valid' => false, 'message' => 'Insufficient balance'];
    }
    
    return ['valid' => true];
}

// Utility Functions
function formatCurrency($amount, $currency = 'USD', $decimals = 2) {
    global $lang;
    return $lang->formatCurrency($amount, $currency);
}

function formatDate($timestamp, $format = 'default') {
    global $lang;
    return $lang->formatDate($timestamp, $format);
}

function generateSlug($text) {
    $text = strtolower($text);
    $text = preg_replace('/[^a-z0-9\s-]/', '', $text);
    $text = preg_replace('/[\s-]+/', '-', $text);
    return trim($text, '-');
}

function uploadFile($file, $allowedTypes = null, $maxSize = null) {
    $allowedTypes = $allowedTypes ?: ALLOWED_IMAGE_TYPES;
    $maxSize = $maxSize ?: MAX_FILE_SIZE;
    
    if ($file['error'] !== UPLOAD_ERR_OK) {
        return ['success' => false, 'message' => 'Upload error'];
    }
    
    if ($file['size'] > $maxSize) {
        return ['success' => false, 'message' => 'File too large'];
    }
    
    $extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    if (!in_array($extension, $allowedTypes)) {
        return ['success' => false, 'message' => 'Invalid file type'];
    }
    
    $filename = uniqid() . '.' . $extension;
    $destination = UPLOAD_PATH . $filename;
    
    if (move_uploaded_file($file['tmp_name'], $destination)) {
        return ['success' => true, 'filename' => $filename];
    }
    
    return ['success' => false, 'message' => 'Upload failed'];
}

function sendEmail($to, $subject, $body, $isHTML = true) {
    // This would integrate with actual email service
    // For now, just log the email
    error_log("Email to {$to}: {$subject}");
    return true;
}

function logActivity($userId, $action, $details = []) {
    global $db;
    
    $db->insert('activity_logs', [
        'user_id' => $userId,
        'action' => $action,
        'details' => json_encode($details),
        'ip_address' => $_SERVER['REMOTE_ADDR'] ?? '',
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? '',
        'created_at' => date('Y-m-d H:i:s')
    ]);
}

function getRealTimeData($type, $params = []) {
    // This would integrate with real-time data providers
    switch ($type) {
        case 'sports_odds':
            return getSportsOdds($params);
        case 'crypto_prices':
            return getCryptoPrices($params);
        case 'live_scores':
            return getLiveScores($params);
        default:
            return [];
    }
}

function getSportsOdds($params = []) {
    // Mock data for demonstration
    return [
        [
            'event_id' => 1,
            'home_team' => 'Manchester United',
            'away_team' => 'Liverpool',
            'home_odds' => 2.10,
            'draw_odds' => 3.40,
            'away_odds' => 3.20,
            'updated_at' => time()
        ]
    ];
}

function getCryptoPrices($currencies = ['BTC', 'ETH', 'USDT', 'LTC']) {
    $prices = [];
    foreach ($currencies as $currency) {
        $prices[$currency] = getCryptoPrice($currency);
    }
    return $prices;
}

function getLiveScores($params = []) {
    // Mock data for demonstration
    return [
        [
            'event_id' => 1,
            'home_team' => 'Manchester United',
            'away_team' => 'Liverpool',
            'home_score' => 1,
            'away_score' => 2,
            'status' => 'live',
            'minute' => 67
        ]
    ];
}

// Cache Functions
function cacheGet($key) {
    if (!CACHE_ENABLED) return null;
    
    $filename = '../cache/' . md5($key) . '.cache';
    if (!file_exists($filename)) return null;
    
    $data = unserialize(file_get_contents($filename));
    if ($data['expires'] < time()) {
        unlink($filename);
        return null;
    }
    
    return $data['value'];
}

function cacheSet($key, $value, $lifetime = null) {
    if (!CACHE_ENABLED) return false;
    
    $lifetime = $lifetime ?: CACHE_LIFETIME;
    $data = [
        'value' => $value,
        'expires' => time() + $lifetime
    ];
    
    $filename = '../cache/' . md5($key) . '.cache';
    return file_put_contents($filename, serialize($data)) !== false;
}

function cacheDelete($key) {
    $filename = '../cache/' . md5($key) . '.cache';
    if (file_exists($filename)) {
        return unlink($filename);
    }
    return true;
}

// Response Functions
function jsonResponse($data, $status = 200) {
    http_response_code($status);
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

function redirectTo($url, $permanent = false) {
    $code = $permanent ? 301 : 302;
    http_response_code($code);
    header("Location: $url");
    exit;
}

function showError($message, $code = 400) {
    http_response_code($code);
    include '../pages/error.php';
    exit;
}
// includes/functions.php - Core Functions
// توابع اصلی سایت Crashify

// Security Functions
function generateCSRFToken() {
    if (!isset($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function verifyCSRFToken($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

function sanitizeInput($input) {
    if (is_array($input)) {
        return array_map('sanitizeInput', $input);
    }
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

function validateEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

function validatePassword($password) {
    // At least 8 characters, 1 uppercase, 1 lowercase, 1 number
    return preg_match('/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)[a-zA-Z\d@$!%*?&]{8,}$/', $password);
}

function hashPassword($password) {
    return password_hash($password, PASSWORD_ARGON2ID, [
        'memory_cost' => 65536,
        'time_cost' => 4,
        'threads' => 3
    ]);
}

function verifyPassword($password, $hash) {
    return password_verify($password, $hash);
}

function generateSecureToken($length = 32) {
    return bin2hex(random_bytes($length));
}

// User Functions
function getCurrentUser() {
    if (!isset($_SESSION['user_id'])) {
        return null;
    }
    
    $user = fetchOne(
        "SELECT u.*, 
                COUNT(b.id) as total_bets,
                COALESCE(SUM(CASE WHEN b.status = 'won' THEN 1 ELSE 0 END), 0) as total_wins,
                COALESCE(SUM(CASE WHEN b.status = 'lost' THEN 1 ELSE 0 END), 0) as total_losses,
                COALESCE(SUM(CASE WHEN b.status = 'won' THEN b.actual_payout ELSE 0 END), 0) as total_winnings,
                COALESCE(SUM(b.stake), 0) as total_wagered
         FROM users u 
         LEFT JOIN bets b ON u.id = b.user_id 
         WHERE u.id = ? AND u.status = 'active'
         GROUP BY u.id",
        [$_SESSION['user_id']]
    );
    
    if ($user) {
        // Calculate win rate
        $user['win_rate'] = $user['total_bets'] > 0 ? 
            ($user['total_wins'] / $user['total_bets']) * 100 : 0;
        
        // Update last activity
        updateRecord('users', 
            ['last_login' => date('Y-m-d H:i:s')], 
            'id = ?', 
            [$user['id']]
        );
    }
    
    return $user;
}

function loginUser($email, $password, $rememberMe = false) {
    $user = fetchOne(
        "SELECT * FROM users WHERE (email = ? OR username = ?) AND status = 'active'",
        [$email, $email]
    );
    
    if (!$user || !verifyPassword($password, $user['password_hash'])) {
        return ['success' => false, 'message' => 'Invalid credentials'];
    }
    
    // Check if account is locked
    if (isAccountLocked($user['id'])) {
        return ['success' => false, 'message' => 'Account temporarily locked'];
    }
    
    // Start session
    session_regenerate_id(true);
    $_SESSION['user_id'] = $user['id'];
    $_SESSION['username'] = $user['username'];
    $_SESSION['login_time'] = time();
    
    // Update user login info
    updateRecord('users', [
        'last_login' => date('Y-m-d H:i:s'),
        'last_ip' => $_SERVER['REMOTE_ADDR'] ?? ''
    ], 'id = ?', [$user['id']]);
    
    // Create session record
    $sessionId = session_id();
    insertRecord('user_sessions', [
        'id' => $sessionId,
        'user_id' => $user['id'],
        'ip_address' => $_SERVER['REMOTE_ADDR'] ?? '',
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? ''
    ]);
    
    // Set remember me cookie
    if ($rememberMe) {
        $token = generateSecureToken();
        setcookie('remember_token', $token, time() + (30 * 24 * 60 * 60), '/', '', true, true);
        // Store token in database (implement remember_tokens table)
    }
    
    // Clear failed login attempts
    clearFailedLoginAttempts($user['id']);
    
    return ['success' => true, 'user' => $user];
}

function registerUser($userData) {
    // Validate input
    $errors = [];
    
    if (empty($userData['username']) || strlen($userData['username']) < 3) {
        $errors[] = 'Username must be at least 3 characters';
    }
    
    if (!validateEmail($userData['email'])) {
        $errors[] = 'Invalid email address';
    }
    
    if (!validatePassword($userData['password'])) {
        $errors[] = 'Password must be at least 8 characters with uppercase, lowercase, and number';
    }
    
    if ($userData['password'] !== $userData['confirm_password']) {
        $errors[] = 'Passwords do not match';
    }
    
    if (!empty($errors)) {
        return ['success' => false, 'errors' => $errors];
    }
    
    // Check if user exists
    $existingUser = fetchOne(
        "SELECT id FROM users WHERE email = ? OR username = ?",
        [$userData['email'], $userData['username']]
    );
    
    if ($existingUser) {
        return ['success' => false, 'message' => 'User already exists'];
    }
    
    try {
        beginTransaction();
        
        // Create user
        $userId = insertRecord('users', [
            'username' => $userData['username'],
            'email' => $userData['email'],
            'password_hash' => hashPassword($userData['password']),
            'first_name' => $userData['first_name'] ?? '',
            'last_name' => $userData['last_name'] ?? '',
            'country' => $userData['country'] ?? '',
            'date_of_birth' => $userData['date_of_birth'] ?? null
        ]);
        
        // Send verification email
        $verificationToken = generateSecureToken();
        // Store verification token (implement email_verifications table)
        
        // Create welcome bonus
        createWelcomeBonus($userId);
        
        commit();
        
        return ['success' => true, 'user_id' => $userId];
        
    } catch (Exception $e) {
        rollback();
        error_log("Registration failed: " . $e->getMessage());
        return ['success' => false, 'message' => 'Registration failed'];
    }
}

function logoutUser() {
    if (isset($_SESSION['user_id'])) {
        // Remove session from database
        deleteRecord('user_sessions', 'id = ?', [session_id()]);
        
        // Clear remember me cookie
        if (isset($_COOKIE['remember_token'])) {
            setcookie('remember_token', '', time() - 3600, '/', '', true, true);
            // Remove token from database
        }
    }
    
    // Destroy session
    session_destroy();
    session_start();
    session_regenerate_id(true);
}

function isAccountLocked($userId) {
    // Check failed login attempts in last hour
    $attempts = fetchColumn(
        "SELECT COUNT(*) FROM login_attempts 
         WHERE user_id = ? AND created_at > DATE_SUB(NOW(), INTERVAL 1 HOUR)",
        [$userId]
    );
    
    return $attempts >= 5;
}

function recordFailedLoginAttempt($userId) {
    insertRecord('login_attempts', [
        'user_id' => $userId,
        'ip_address' => $_SERVER['REMOTE_ADDR'] ?? '',
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? ''
    ]);
}

function clearFailedLoginAttempts($userId) {
    deleteRecord('login_attempts', 'user_id = ?', [$userId]);
}

// Sports & Betting Functions
function getSportsData() {
    return fetchAll(
        "SELECT s.*, 
                COUNT(CASE WHEN e.status = 'live' THEN 1 END) as live_count,
                COUNT(e.id) as total_events
         FROM sports s 
         LEFT JOIN events e ON s.id = e.sport_id 
         WHERE s.active = 1 
         GROUP BY s.id 
         ORDER BY s.sort_order, s.name"
    );
}

function getFeaturedEvents($limit = 6) {
    return fetchAll(
        "SELECT e.*, 
                s.name as sport_name, s.icon as sport_icon,
                l.name as league_name, l.logo as league_logo,
                ht.name as home_team, ht.logo as home_team_logo,
                at.name as away_team, at.logo as away_team_logo,
                o1.odds as home_odds,
                o2.odds as draw_odds,
                o3.odds as away_odds
         FROM events e
         JOIN sports s ON e.sport_id = s.id
         JOIN leagues l ON e.league_id = l.id
         JOIN teams ht ON e.home_team_id = ht.id
         JOIN teams at ON e.away_team_id = at.id
         LEFT JOIN markets m ON e.id = m.event_id AND m.type = 'match_result'
         LEFT JOIN odds o1 ON m.id = o1.market_id AND o1.selection = 'home'
         LEFT JOIN odds o2 ON m.id = o2.market_id AND o2.selection = 'draw'
         LEFT JOIN odds o3 ON m.id = o3.market_id AND o3.selection = 'away'
         WHERE e.featured = 1 AND e.status IN ('scheduled', 'live')
         ORDER BY e.start_time ASC
         LIMIT ?",
        [$limit]
    );
}

function getLiveEvents($limit = 10) {
    return fetchAll(
        "SELECT e.*, 
                s.name as sport_name, s.icon as sport_icon,
                l.name as league_name, l.logo as league_logo,
                ht.name as home_team, ht.logo as home_team_logo,
                at.name as away_team, at.logo as away_team_logo,
                o1.odds as home_odds,
                o2.odds as draw_odds,
                o3.odds as away_odds
         FROM events e
         JOIN sports s ON e.sport_id = s.id
         JOIN leagues l ON e.league_id = l.id
         JOIN teams ht ON e.home_team_id = ht.id
         JOIN teams at ON e.away_team_id = at.id
         LEFT JOIN markets m ON e.id = m.event_id AND m.type = 'match_result'
         LEFT JOIN odds o1 ON m.id = o1.market_id AND o1.selection = 'home'
         LEFT JOIN odds o2 ON m.id = o2.market_id AND o2.selection = 'draw'
         LEFT JOIN odds o3 ON m.id = o3.market_id AND o3.selection = 'away'
         WHERE e.status = 'live'
         ORDER BY e.start_time ASC
         LIMIT ?",
        [$limit]
    );
}

function getUpcomingEvents($sport = 'all', $league = 'all', $timeFilter = 'today', $search = '', $limit = 50) {
    $conditions = ["e.status = 'scheduled'"];
    $params = [];
    
    if ($sport !== 'all') {
        $conditions[] = "s.slug = ?";
        $params[] = $sport;
    }
    
    if ($league !== 'all') {
        $conditions[] = "l.slug = ?";
        $params[] = $league;
    }
    
    switch ($timeFilter) {
        case 'today':
            $conditions[] = "DATE(e.start_time) = CURDATE()";
            break;
        case 'tomorrow':
            $conditions[] = "DATE(e.start_time) = DATE_ADD(CURDATE(), INTERVAL 1 DAY)";
            break;
        case 'week':
            $conditions[] = "e.start_time BETWEEN NOW() AND DATE_ADD(NOW(), INTERVAL 7 DAY)";
            break;
    }
    
    if (!empty($search)) {
        $conditions[] = "(ht.name LIKE ? OR at.name LIKE ? OR l.name LIKE ?)";
        $searchTerm = "%{$search}%";
        $params[] = $searchTerm;
        $params[] = $searchTerm;
        $params[] = $searchTerm;
    }
    
    $whereClause = implode(' AND ', $conditions);
    $params[] = $limit;
    
    return fetchAll(
        "SELECT e.*, 
                s.name as sport_name, s.icon as sport_icon,
                l.name as league_name, l.logo as league_logo,
                ht.name as home_team, ht.logo as home_team_logo,
                at.name as away_team, at.logo as away_team_logo,
                o1.odds as home_odds,
                o2.odds as draw_odds,
                o3.odds as away_odds
         FROM events e
         JOIN sports s ON e.sport_id = s.id
         JOIN leagues l ON e.league_id = l.id
         JOIN teams ht ON e.home_team_id = ht.id
         JOIN teams at ON e.away_team_id = at.id
         LEFT JOIN markets m ON e.id = m.event_id AND m.type = 'match_result'
         LEFT JOIN odds o1 ON m.id = o1.market_id AND o1.selection = 'home'
         LEFT JOIN odds o2 ON m.id = o2.market_id AND o2.selection = 'draw'
         LEFT JOIN odds o3 ON m.id = o3.market_id AND o3.selection = 'away'
         WHERE {$whereClause}
         ORDER BY e.start_time ASC
         LIMIT ?",
        $params
    );
}

function placeBet($userId, $betData) {
    try {
        beginTransaction();
        
        // Validate bet data
        $event = fetchOne("SELECT * FROM events WHERE id = ? AND status IN ('scheduled', 'live')", [$betData['event_id']]);
        if (!$event) {
            throw new Exception("Event not found or not available for betting");
        }
        
        $odds = fetchOne("SELECT * FROM odds WHERE id = ? AND active = 1", [$betData['odds_id']]);
        if (!$odds) {
            throw new Exception("Odds not found or not active");
        }
        
        // Validate stake
        $stake = floatval($betData['stake']);
        $minBet = getSetting('min_bet_amount', 0.01);
        $maxBet = getSetting('max_bet_amount', 10000);
        
        if ($stake < $minBet || $stake > $maxBet) {
            throw new Exception("Stake must be between {$minBet} and {$maxBet}");
        }
        
        // Check user balance
        $user = fetchOne("SELECT balance FROM users WHERE id = ?", [$userId]);
        if ($user['balance'] < $stake) {
            throw new Exception("Insufficient balance");
        }
        
        // Calculate potential payout
        $potentialPayout = $stake * $odds['odds'];
        $maxPayout = getSetting('max_payout', 100000);
        
        if ($potentialPayout > $maxPayout) {
            throw new Exception("Potential payout exceeds maximum limit");
        }
        
        // Deduct stake from user balance
        updateRecord('users', 
            ['balance' => $user['balance'] - $stake], 
            'id = ?', 
            [$userId]
        );
        
        // Create bet record
        $betId = insertRecord('bets', [
            'user_id' => $userId,
            'event_id' => $betData['event_id'],
            'market_id' => $odds['market_id'],
            'odds_id' => $betData['odds_id'],
            'selection' => $betData['selection'],
            'odds' => $odds['odds'],
            'stake' => $stake,
            'potential_payout' => $potentialPayout
        ]);
        
        // Create transaction record
        insertRecord('transactions', [
            'user_id' => $userId,
            'type' => 'bet',
            'amount' => -$stake,
            'status' => 'completed',
            'reference_id' => $betId,
            'reference_type' => 'bet'
        ]);
        
        // Create notification
        createNotification($userId, 'bet_placed', 'Bet Placed', 
            "Your bet of {$stake} has been placed successfully");
        
        commit();
        
        return ['success' => true, 'bet_id' => $betId];
        
    } catch (Exception $e) {
        rollback();
        error_log("Bet placement failed: " . $e->getMessage());
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

// Wallet Functions
function getUserBalance($userId) {
    return fetchOne(
        "SELECT balance, bonus_balance FROM users WHERE id = ?",
        [$userId]
    );
}

function createDeposit($userId, $amount, $currency, $walletAddress) {
    try {
        $transactionId = insertRecord('transactions', [
            'user_id' => $userId,
            'type' => 'deposit',
            'amount' => $amount,
            'currency' => $currency,
            'wallet_address' => $walletAddress,
            'status' => 'pending'
        ]);
        
        return ['success' => true, 'transaction_id' => $transactionId];
        
    } catch (Exception $e) {
        error_log("Deposit creation failed: " . $e->getMessage());
        return ['success' => false, 'message' => 'Deposit creation failed'];
    }
}

function processWithdrawal($userId, $amount, $walletAddress) {
    try {
        beginTransaction();
        
        // Check balance
        $user = fetchOne("SELECT balance FROM users WHERE id = ?", [$userId]);
        if ($user['balance'] < $amount) {
            throw new Exception("Insufficient balance");
        }
        
        // Deduct from balance
        updateRecord('users', 
            ['balance' => $user['balance'] - $amount], 
            'id = ?', 
            [$userId]
        );
        
        // Create withdrawal record
        $transactionId = insertRecord('transactions', [
            'user_id' => $userId,
            'type' => 'withdrawal',
            'amount' => -$amount,
            'wallet_address' => $walletAddress,
            'status' => 'pending'
        ]);
        
        commit();
        
        return ['success' => true, 'transaction_id' => $transactionId];
        
    } catch (Exception $e) {
        rollback();
        error_log("Withdrawal failed: " . $e->getMessage());
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

// Bonus Functions
function createWelcomeBonus($userId) {
    $welcomeBonus = fetchOne(
        "SELECT * FROM bonuses WHERE type = 'welcome' AND active = 1 LIMIT 1"
    );
    
    if ($welcomeBonus) {
        $amount = $welcomeBonus['amount'];
        $wageringRequirement = $amount * $welcomeBonus['wagering_requirement'];
        $expiresAt = date('Y-m-d H:i:s', strtotime("+{$welcomeBonus['valid_days']} days"));
        
        insertRecord('user_bonuses', [
            'user_id' => $userId,
            'bonus_id' => $welcomeBonus['id'],
            'amount' => $amount,
            'wagering_requirement' => $wageringRequirement,
            'expires_at' => $expiresAt
        ]);
        
        // Add to user bonus balance
        updateRecord('users', 
            ['bonus_balance' => $amount], 
            'id = ?', 
            [$userId]
        );
    }
}

// Notification Functions
function createNotification($userId, $type, $title, $message, $data = null) {
    return insertRecord('notifications', [
        'user_id' => $userId,
        'type' => $type,
        'title' => $title,
        'message' => $message,
        'data' => $data ? json_encode($data) : null
    ]);
}

function getUserNotifications($userId, $limit = 20) {
    return fetchAll(
        "SELECT * FROM notifications 
         WHERE user_id = ? 
         ORDER BY created_at DESC 
         LIMIT ?",
        [$userId, $limit]
    );
}

// Utility Functions
function formatCurrency($amount, $currency = 'USD', $decimals = 2) {
    return number_format($amount, $decimals) . ' ' . $currency;
}

function formatEventDate($datetime) {
    return date('M j, Y H:i', strtotime($datetime));
}

function getSetting($key, $default = null) {
    $setting = fetchOne("SELECT value, type FROM settings WHERE key_name = ?", [$key]);
    
    if (!$setting) {
        return $default;
    }
    
    switch ($setting['type']) {
        case 'boolean':
            return (bool) $setting['value'];
        case 'integer':
            return (int) $setting['value'];
        case 'float':
            return (float) $setting['value'];
        case 'json':
            return json_decode($setting['value'], true);
        default:
            return $setting['value'];
    }
}

function setSetting($key, $value, $type = 'string') {
    if ($type === 'json') {
        $value = json_encode($value);
    }
    
    return updateRecord('settings', 
        ['value' => $value, 'type' => $type], 
        'key_name = ?', 
        [$key]
    );
}

function isCurrentPage($path) {
    return $_SERVER['REQUEST_URI'] === $path || 
           (strpos($_SERVER['REQUEST_URI'], '?') !== false && 
            strpos($_SERVER['REQUEST_URI'], $path) === 0);
}

function redirect($url, $statusCode = 302) {
    header("Location: {$url}", true, $statusCode);
    exit;
}

function getClientIP() {
    $ipKeys = ['HTTP_CF_CONNECTING_IP', 'HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'REMOTE_ADDR'];
    
    foreach ($ipKeys as $key) {
        if (array_key_exists($key, $_SERVER) === true) {
            foreach (explode(',', $_SERVER[$key]) as $ip) {
                $ip = trim($ip);
                if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false) {
                    return $ip;
                }
            }
        }
    }
    
    return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
}

function logActivity($userId, $action, $details = null) {
    insertRecord('activity_logs', [
        'user_id' => $userId,
        'action' => $action,
        'details' => $details ? json_encode($details) : null,
        'ip_address' => getClientIP(),
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? ''
    ]);
}

function rateLimitCheck($key, $maxAttempts = 10, $timeWindow = 3600) {
    $cacheKey = "rate_limit:{$key}";
    $attempts = apcu_fetch($cacheKey) ?: 0;
    
    if ($attempts >= $maxAttempts) {
        return false;
    }
    
    apcu_store($cacheKey, $attempts + 1, $timeWindow);
    return true;
 }
?>
PHP
); ?>

<?php _merge_exec('includes/header.php', <<<'PHP'
<?php
// includes/header.php - Site Header
// هدر سایت

// Ensure we have access to global variables
global $pageTitle, $bodyClass, $breadcrumbs, $additionalScripts, $additionalStyles, $currentUser, $lang;

// Set default values if not set
$pageTitle = $pageTitle ?? 'Crashify - Crypto Sports Betting & Casino';
$bodyClass = $bodyClass ?? '';
$breadcrumbs = $breadcrumbs ?? [];
$additionalScripts = $additionalScripts ?? [];
$additionalStyles = $additionalStyles ?? [];

// Get current language
$currentLang = $_SESSION['language'] ?? 'en';
$langData = require_once __DIR__ . "/../languages/{$currentLang}.php";

// Get navigation items
$navItems = [
    'sportsbook' => [
        'title' => $langData['nav']['sportsbook'],
        'url' => '/pages/sportsbook.php',
        'icon' => 'fas fa-futbol',
        'active' => strpos($_SERVER['REQUEST_URI'], 'sportsbook') !== false
    ],
    'live_betting' => [
        'title' => $langData['nav']['live_betting'],
        'url' => '/pages/live-betting.php',
        'icon' => 'fas fa-broadcast-tower',
        'active' => strpos($_SERVER['REQUEST_URI'], 'live-betting') !== false,
        'badge' => 'LIVE'
    ],
    'casino' => [
        'title' => $langData['nav']['casino'],
        'url' => '/pages/casino.php',
        'icon' => 'fas fa-dice',
        'active' => strpos($_SERVER['REQUEST_URI'], 'casino') !== false
    ],
    'promotions' => [
        'title' => $langData['nav']['promotions'],
        'url' => '/pages/promotions.php',
        'icon' => 'fas fa-gift',
        'active' => strpos($_SERVER['REQUEST_URI'], 'promotions') !== false
    ],
    'vip' => [
        'title' => $langData['nav']['vip'],
        'url' => '/pages/vip.php',
        'icon' => 'fas fa-crown',
        'active' => strpos($_SERVER['REQUEST_URI'], 'vip') !== false
    ]
];

// Get user's unread notifications count
$notificationCount = 0;
if ($currentUser) {
    $notificationCount = fetchColumn(
        "SELECT COUNT(*) FROM notifications WHERE user_id = ? AND read_at IS NULL",
        [$currentUser['id']]
    ) ?: 0;
}
?>
<!DOCTYPE html>
<html lang="<?php echo $currentLang; ?>" dir="<?php echo $currentLang === 'fa' ? 'rtl' : 'ltr'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Crashify - The ultimate crypto sports betting and casino platform. Bet on sports, play casino games, and win big with instant crypto payouts.">
    <meta name="keywords" content="crypto betting, sports betting, casino games, cryptocurrency, bitcoin, ethereum, live betting">
    <meta name="author" content="Crashify">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="<?php echo htmlspecialchars($pageTitle); ?>">
    <meta property="og:description" content="The ultimate crypto sports betting and casino platform with instant payouts.">
    <meta property="og:image" content="<?php echo SITE_URL; ?>/assets/images/og-image.jpg">
    <meta property="og:url" content="<?php echo SITE_URL . $_SERVER['REQUEST_URI']; ?>">
    <meta property="og:type" content="website">
    
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo htmlspecialchars($pageTitle); ?>">
    <meta name="twitter:description" content="The ultimate crypto sports betting and casino platform with instant payouts.">
    <meta name="twitter:image" content="<?php echo SITE_URL; ?>/assets/images/twitter-card.jpg">
    
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/assets/images/favicon.ico">
    <link rel="apple-touch-icon" sizes="180x180" href="/assets/images/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/assets/images/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/assets/images/favicon-16x16.png">
    
    <!-- Preconnect to external domains -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://cdnjs.cloudflare.com">
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Main CSS -->
    <link href="/assets/css/main.css" rel="stylesheet">
    
    <!-- Additional Styles -->
    <?php foreach ($additionalStyles as $style): ?>
    <link href="<?php echo $style; ?>" rel="stylesheet">
    <?php endforeach; ?>
    
    <!-- Theme and Language -->
    <script>
        // Set initial theme and language
        document.documentElement.setAttribute('data-theme', localStorage.getItem('theme') || 'dark');
        document.documentElement.setAttribute('data-lang', '<?php echo $currentLang; ?>');
    </script>
</head>
<body class="<?php echo $bodyClass; ?>">
    <!-- Loading Screen -->
    <div id="loadingScreen" class="loading-screen">
        <div class="loading-content">
            <div class="loading-logo">
                <img src="/assets/images/logo.svg" alt="Crashify">
            </div>
            <div class="loading-spinner">
                <div class="spinner"></div>
            </div>
            <div class="loading-text">Loading...</div>
        </div>
    </div>
    
    <!-- Header -->
    <header class="site-header" id="siteHeader">
        <div class="container">
            <div class="header-content">
                <!-- Logo -->
                <div class="header-logo">
                    <a href="/" class="logo-link">
                        <img src="/assets/images/logo.svg" alt="Crashify" class="logo-img">
                        <span class="logo-text">Crashify</span>
                    </a>
                </div>
                
                <!-- Main Navigation -->
                <nav class="main-nav" id="mainNav">
                    <ul class="nav-list">
                        <?php foreach ($navItems as $key => $item): ?>
                        <li class="nav-item">
                            <a href="<?php echo $item['url']; ?>" 
                               class="nav-link <?php echo $item['active'] ? 'active' : ''; ?>">
                                <i class="<?php echo $item['icon']; ?>"></i>
                                <span><?php echo $item['title']; ?></span>
                                <?php if (isset($item['badge'])): ?>
                                <span class="nav-badge"><?php echo $item['badge']; ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </nav>
                
                <!-- Header Actions -->
                <div class="header-actions">
                    <!-- Search -->
                    <div class="search-container">
                        <button class="search-toggle" onclick="toggleSearch()">
                            <i class="fas fa-search"></i>
                        </button>
                        <div class="search-dropdown" id="searchDropdown">
                            <div class="search-input">
                                <i class="fas fa-search"></i>
                                <input type="text" 
                                       placeholder="Search events, teams, games..." 
                                       id="globalSearch"
                                       autocomplete="off">
                                <button class="search-clear" onclick="clearSearch()">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                            <div class="search-results" id="searchResults">
                                <!-- Search results will be populated here -->
                            </div>
                        </div>
                    </div>
                    
                    <!-- Language Switcher -->
                    <div class="language-switcher">
                        <button class="lang-toggle" onclick="toggleLanguageMenu()">
                            <i class="fas fa-globe"></i>
                            <span><?php echo strtoupper($currentLang); ?></span>
                            <i class="fas fa-chevron-down"></i>
                        </button>
                        <div class="lang-dropdown" id="langDropdown">
                            <a href="?lang=en" class="lang-option <?php echo $currentLang === 'en' ? 'active' : ''; ?>">
                                <img src="/assets/images/flags/en.svg" alt="English">
                                <span>English</span>
                            </a>
                            <a href="?lang=fa" class="lang-option <?php echo $currentLang === 'fa' ? 'active' : ''; ?>">
                                <img src="/assets/images/flags/fa.svg" alt="فارسی">
                                <span>فارسی</span>
                            </a>
                        </div>
                    </div>
                    
                    <!-- Theme Toggle -->
                    <button class="theme-toggle" onclick="toggleTheme()" title="Toggle Theme">
                        <i class="fas fa-moon dark-icon"></i>
                        <i class="fas fa-sun light-icon"></i>
                    </button>
                    
                    <?php if ($currentUser): ?>
                    <!-- User Menu -->
                    <div class="user-menu">
                        <!-- Notifications -->
                        <div class="notifications-container">
                            <button class="notifications-toggle" onclick="toggleNotifications()">
                                <i class="fas fa-bell"></i>
                                <?php if ($notificationCount > 0): ?>
                                <span class="notification-badge"><?php echo $notificationCount > 99 ? '99+' : $notificationCount; ?></span>
                                <?php endif; ?>
                            </button>
                            <div class="notifications-dropdown" id="notificationsDropdown">
                                <div class="notifications-header">
                                    <h3>Notifications</h3>
                                    <?php if ($notificationCount > 0): ?>
                                    <button class="mark-all-read" onclick="markAllNotificationsRead()">
                                        Mark all read
                                    </button>
                                    <?php endif; ?>
                                </div>
                                <div class="notifications-list" id="notificationsList">
                                    <!-- Notifications will be loaded here -->
                                </div>
                            </div>
                        </div>
                        
                        <!-- User Balance -->
                        <div class="user-balance">
                            <div class="balance-item">
                                <i class="fas fa-wallet"></i>
                                <span class="balance-amount" id="headerBalance">
                                    $<?php echo number_format($currentUser['balance'], 2); ?>
                                </span>
                            </div>
                            <?php if ($currentUser['bonus_balance'] > 0): ?>
                            <div class="balance-item bonus">
                                <i class="fas fa-gift"></i>
                                <span class="balance-amount">
                                    $<?php echo number_format($currentUser['bonus_balance'], 2); ?>
                                </span>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- User Profile -->
                        <div class="user-profile">
                            <button class="profile-toggle" onclick="toggleUserMenu()">
                                <?php if ($currentUser['avatar']): ?>
                                <img src="<?php echo $currentUser['avatar']; ?>" alt="<?php echo $currentUser['username']; ?>" class="user-avatar">
                                <?php else: ?>
                                <div class="user-avatar-placeholder">
                                    <?php echo strtoupper(substr($currentUser['username'], 0, 2)); ?>
                                </div>
                                <?php endif; ?>
                                <span class="username"><?php echo $currentUser['username']; ?></span>
                                <?php if ($currentUser['vip_level']): ?>
                                <span class="vip-badge">VIP</span>
                                <?php endif; ?>
                                <i class="fas fa-chevron-down"></i>
                            </button>
                            <div class="user-dropdown" id="userDropdown">
                                <div class="user-info">
                                    <div class="user-details">
                                        <div class="username"><?php echo $currentUser['username']; ?></div>
                                        <div class="user-email"><?php echo $currentUser['email']; ?></div>
                                    </div>
                                    <?php if ($currentUser['vip_level']): ?>
                                    <div class="vip-status">
                                        <i class="fas fa-crown"></i>
                                        <span>VIP Level <?php echo $currentUser['vip_level']; ?></span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="user-menu-items">
                                    <a href="/pages/dashboard.php" class="menu-item">
                                        <i class="fas fa-tachometer-alt"></i>
                                        <span>Dashboard</span>
                                    </a>
                                    <a href="/pages/profile.php" class="menu-item">
                                        <i class="fas fa-user"></i>
                                        <span>Profile</span>
                                    </a>
                                    <a href="/pages/wallet.php" class="menu-item">
                                        <i class="fas fa-wallet"></i>
                                        <span>Wallet</span>
                                    </a>
                                    <a href="/pages/bet-history.php" class="menu-item">
                                        <i class="fas fa-history"></i>
                                        <span>Bet History</span>
                                    </a>
                                    <a href="/pages/settings.php" class="menu-item">
                                        <i class="fas fa-cog"></i>
                                        <span>Settings</span>
                                    </a>
                                    <div class="menu-divider"></div>
                                    <a href="/auth/logout.php" class="menu-item logout">
                                        <i class="fas fa-sign-out-alt"></i>
                                        <span>Logout</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php else: ?>
                    <!-- Auth Buttons -->
                    <div class="auth-buttons">
                        <a href="/auth/login.php" class="btn btn-outline btn-sm">
                            <i class="fas fa-sign-in-alt"></i>
                            <span>Login</span>
                        </a>
                        <a href="/auth/register.php" class="btn btn-primary btn-sm">
                            <i class="fas fa-user-plus"></i>
                            <span>Sign Up</span>
                        </a>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Mobile Menu Toggle -->
                    <button class="mobile-menu-toggle" onclick="toggleMobileMenu()">
                        <span class="hamburger-line"></span>
                        <span class="hamburger-line"></span>
                        <span class="hamburger-line"></span>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Mobile Navigation -->
        <div class="mobile-nav" id="mobileNav">
            <div class="mobile-nav-content">
                <div class="mobile-nav-header">
                    <div class="mobile-logo">
                        <img src="/assets/images/logo.svg" alt="Crashify">
                        <span>Crashify</span>
                    </div>
                    <button class="mobile-nav-close" onclick="toggleMobileMenu()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                
                <div class="mobile-nav-body">
                    <?php if ($currentUser): ?>
                    <div class="mobile-user-info">
                        <div class="mobile-user-avatar">
                            <?php if ($currentUser['avatar']): ?>
                            <img src="<?php echo $currentUser['avatar']; ?>" alt="<?php echo $currentUser['username']; ?>">
                            <?php else: ?>
                            <div class="avatar-placeholder">
                                <?php echo strtoupper(substr($currentUser['username'], 0, 2)); ?>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="mobile-user-details">
                            <div class="username"><?php echo $currentUser['username']; ?></div>
                            <div class="balance">$<?php echo number_format($currentUser['balance'], 2); ?></div>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <nav class="mobile-nav-menu">
                        <?php foreach ($navItems as $key => $item): ?>
                        <a href="<?php echo $item['url']; ?>" class="mobile-nav-item <?php echo $item['active'] ? 'active' : ''; ?>">
                            <i class="<?php echo $item['icon']; ?>"></i>
                            <span><?php echo $item['title']; ?></span>
                            <?php if (isset($item['badge'])): ?>
                            <span class="nav-badge"><?php echo $item['badge']; ?></span>
                            <?php endif; ?>
                        </a>
                        <?php endforeach; ?>
                        
                        <?php if ($currentUser): ?>
                        <div class="mobile-nav-divider"></div>
                        <a href="/pages/dashboard.php" class="mobile-nav-item">
                            <i class="fas fa-tachometer-alt"></i>
                            <span>Dashboard</span>
                        </a>
                        <a href="/pages/wallet.php" class="mobile-nav-item">
                            <i class="fas fa-wallet"></i>
                            <span>Wallet</span>
                        </a>
                        <a href="/pages/profile.php" class="mobile-nav-item">
                            <i class="fas fa-user"></i>
                            <span>Profile</span>
                        </a>
                        <a href="/auth/logout.php" class="mobile-nav-item">
                            <i class="fas fa-sign-out-alt"></i>
                            <span>Logout</span>
                        </a>
                        <?php else: ?>
                        <div class="mobile-nav-divider"></div>
                        <a href="/auth/login.php" class="mobile-nav-item">
                            <i class="fas fa-sign-in-alt"></i>
                            <span>Login</span>
                        </a>
                        <a href="/auth/register.php" class="mobile-nav-item">
                            <i class="fas fa-user-plus"></i>
                            <span>Sign Up</span>
                        </a>
                        <?php endif; ?>
                    </nav>
                </div>
            </div>
        </div>
    </header>
    
    <!-- Breadcrumbs -->
    <?php if (!empty($breadcrumbs)): ?>
    <div class="breadcrumbs">
        <div class="container">
            <nav class="breadcrumb-nav">
                <a href="/" class="breadcrumb-item">
                    <i class="fas fa-home"></i>
                    <span>Home</span>
                </a>
                <?php foreach ($breadcrumbs as $crumb): ?>
                <i class="fas fa-chevron-right breadcrumb-separator"></i>
                <?php if (isset($crumb['url'])): ?>
                <a href="<?php echo $crumb['url']; ?>" class="breadcrumb-item">
                    <?php echo $crumb['title']; ?>
                </a>
                <?php else: ?>
                <span class="breadcrumb-item current"><?php echo $crumb['title']; ?></span>
                <?php endif; ?>
                <?php endforeach; ?>
            </nav>
        </div>
    </div>
    <?php endif; ?>
    
PHP
); ?>

<?php _merge_exec('includes/notifications.php', <<<'PHP'
<?php
// includes/notifications.php - Notification System
// سیستم اطلاع‌رسانی

class NotificationManager {
    private $pdo;
    private $user_id;
    
    public function __construct($pdo, $user_id = null) {
        $this->pdo = $pdo;
        $this->user_id = $user_id;
    }
    
    /**
     * Create a new notification
     */
    public function create($user_id, $type, $title, $message, $data = null, $priority = 'normal') {
        try {
            $stmt = $this->pdo->prepare("
                INSERT INTO notifications (user_id, type, title, message, data, priority, created_at)
                VALUES (?, ?, ?, ?, ?, ?, NOW())
            ");
            
            $result = $stmt->execute([
                $user_id,
                $type,
                $title,
                $message,
                $data ? json_encode($data) : null,
                $priority
            ]);
            
            if ($result) {
                $notification_id = $this->pdo->lastInsertId();
                
                // Send real-time notification if user is online
                $this->sendRealTimeNotification($user_id, [
                    'id' => $notification_id,
                    'type' => $type,
                    'title' => $title,
                    'message' => $message,
                    'priority' => $priority,
                    'created_at' => date('Y-m-d H:i:s')
                ]);
                
                return $notification_id;
            }
            
            return false;
        } catch (Exception $e) {
            error_log("Notification creation error: " . $e->getMessage());
            return false;
        }
    }
    
    /**
     * Get user notifications
     */
    public function getUserNotifications($user_id, $limit = 20, $offset = 0, $unread_only = false) {
        try {
            $where_clause = "WHERE user_id = ?";
            $params = [$user_id];
            
            if ($unread_only) {
                $where_clause .= " AND is_read = 0";
            }
            
            $stmt = $this->pdo->prepare("
                SELECT * FROM notifications 
                $where_clause
                ORDER BY priority DESC, created_at DESC 
                LIMIT ? OFFSET ?
            ");
            
            $params[] = $limit;
            $params[] = $offset;
            
            $stmt->execute($params);
            $notifications = $stmt->fetchAll();
            
            // Parse JSON data
            foreach ($notifications as &$notification) {
                if ($notification['data']) {
                    $notification['data'] = json_decode($notification['data'], true);
                }
            }
            
            return $notifications;
        } catch (Exception $e) {
            error_log("Get notifications error: " . $e->getMessage());
            return [];
        }
    }
    
    /**
     * Mark notification as read
     */
    public function markAsRead($notification_id, $user_id = null) {
        try {
            $where_clause = "WHERE id = ?";
            $params = [$notification_id];
            
            if ($user_id) {
                $where_clause .= " AND user_id = ?";
                $params[] = $user_id;
            }
            
            $stmt = $this->pdo->prepare("
                UPDATE notifications 
                SET is_read = 1, read_at = NOW() 
                $where_clause
            ");
            
            return $stmt->execute($params);
        } catch (Exception $e) {
            error_log("Mark as read error: " . $e->getMessage());
            return false;
        }
    }
    
    /**
     * Mark all notifications as read for user
     */
    public function markAllAsRead($user_id) {
        try {
            $stmt = $this->pdo->prepare("
                UPDATE notifications 
                SET is_read = 1, read_at = NOW() 
                WHERE user_id = ? AND is_read = 0
            ");
            
            return $stmt->execute([$user_id]);
        } catch (Exception $e) {
            error_log("Mark all as read error: " . $e->getMessage());
            return false;
        }
    }
    
    /**
     * Delete notification
     */
    public function delete($notification_id, $user_id = null) {
        try {
            $where_clause = "WHERE id = ?";
            $params = [$notification_id];
            
            if ($user_id) {
                $where_clause .= " AND user_id = ?";
                $params[] = $user_id;
            }
            
            $stmt = $this->pdo->prepare("DELETE FROM notifications $where_clause");
            return $stmt->execute($params);
        } catch (Exception $e) {
            error_log("Delete notification error: " . $e->getMessage());
            return false;
        }
    }
    
    /**
     * Get unread count
     */
    public function getUnreadCount($user_id) {
        try {
            $stmt = $this->pdo->prepare("
                SELECT COUNT(*) FROM notifications 
                WHERE user_id = ? AND is_read = 0
            ");
            $stmt->execute([$user_id]);
            return $stmt->fetchColumn();
        } catch (Exception $e) {
            error_log("Get unread count error: " . $e->getMessage());
            return 0;
        }
    }
    
    /**
     * Send real-time notification via WebSocket or Server-Sent Events
     */
    private function sendRealTimeNotification($user_id, $notification) {
        // Store in session for immediate display
        if (!isset($_SESSION['pending_notifications'])) {
            $_SESSION['pending_notifications'] = [];
        }
        
        $_SESSION['pending_notifications'][] = $notification;
        
        // Here you would integrate with WebSocket server or SSE
        // For now, we'll use session-based approach
    }
    
    /**
     * Create system notifications for different events
     */
    public function createWelcomeNotification($user_id) {
        return $this->create(
            $user_id,
            'welcome',
            'خوش آمدید!',
            'به Crashify خوش آمدید! از جوایز خوش‌آمدگویی خود استفاده کنید.',
            ['action' => 'view_bonuses', 'url' => '/pages/bonuses.php'],
            'high'
        );
    }
    
    public function createDepositNotification($user_id, $amount, $currency) {
        return $this->create(
            $user_id,
            'deposit',
            'واریز موفق',
            "مبلغ $amount $currency با موفقیت به حساب شما واریز شد.",
            ['amount' => $amount, 'currency' => $currency],
            'normal'
        );
    }
    
    public function createWithdrawalNotification($user_id, $amount, $currency, $status) {
        $messages = [
            'pending' => "درخواست برداشت $amount $currency در حال بررسی است.",
            'approved' => "درخواست برداشت $amount $currency تأیید شد.",
            'rejected' => "درخواست برداشت $amount $currency رد شد."
        ];
        
        return $this->create(
            $user_id,
            'withdrawal',
            'وضعیت برداشت',
            $messages[$status] ?? 'وضعیت برداشت تغییر کرد.',
            ['amount' => $amount, 'currency' => $currency, 'status' => $status],
            $status === 'rejected' ? 'high' : 'normal'
        );
    }
    
    public function createBonusNotification($user_id, $bonus_title, $amount) {
        return $this->create(
            $user_id,
            'bonus',
            'جایزه جدید!',
            "جایزه '$bonus_title' به مبلغ $$amount دریافت کردید.",
            ['bonus_title' => $bonus_title, 'amount' => $amount],
            'high'
        );
    }
    
    public function createBetWinNotification($user_id, $amount, $game_type) {
        return $this->create(
            $user_id,
            'win',
            'تبریک! برنده شدید!',
            "در بازی $game_type مبلغ $$amount برنده شدید.",
            ['amount' => $amount, 'game_type' => $game_type],
            'high'
        );
    }
    
    public function createSecurityNotification($user_id, $action, $ip_address) {
        $messages = [
            'login' => "ورود جدید از IP: $ip_address",
            'password_change' => 'رمز عبور تغییر کرد',
            'email_change' => 'ایمیل تغییر کرد',
            'suspicious_activity' => 'فعالیت مشکوک شناسایی شد'
        ];
        
        return $this->create(
            $user_id,
            'security',
            'اطلاعیه امنیتی',
            $messages[$action] ?? 'تغییرات امنیتی در حساب شما',
            ['action' => $action, 'ip_address' => $ip_address],
            'high'
        );
    }
    
    public function createPromotionNotification($user_id, $promotion_title, $description) {
        return $this->create(
            $user_id,
            'promotion',
            'پیشنهاد ویژه!',
            $promotion_title . ': ' . $description,
            ['promotion_title' => $promotion_title],
            'normal'
        );
    }
    
    /**
     * Clean old notifications
     */
    public function cleanOldNotifications($days = 30) {
        try {
            $stmt = $this->pdo->prepare("
                DELETE FROM notifications 
                WHERE created_at < DATE_SUB(NOW(), INTERVAL ? DAY)
            ");
            
            return $stmt->execute([$days]);
        } catch (Exception $e) {
            error_log("Clean old notifications error: " . $e->getMessage());
            return false;
        }
    }
    
    /**
     * Get notification preferences for user
     */
    public function getUserPreferences($user_id) {
        try {
            $stmt = $this->pdo->prepare("
                SELECT * FROM notification_preferences 
                WHERE user_id = ?
            ");
            $stmt->execute([$user_id]);
            $preferences = $stmt->fetch();
            
            if (!$preferences) {
                // Create default preferences
                $this->createDefaultPreferences($user_id);
                return $this->getUserPreferences($user_id);
            }
            
            return json_decode($preferences['preferences'], true);
        } catch (Exception $e) {
            error_log("Get user preferences error: " . $e->getMessage());
            return $this->getDefaultPreferences();
        }
    }
    
    /**
     * Update notification preferences
     */
    public function updateUserPreferences($user_id, $preferences) {
        try {
            $stmt = $this->pdo->prepare("
                INSERT INTO notification_preferences (user_id, preferences, updated_at)
                VALUES (?, ?, NOW())
                ON DUPLICATE KEY UPDATE 
                preferences = VALUES(preferences), 
                updated_at = VALUES(updated_at)
            ");
            
            return $stmt->execute([$user_id, json_encode($preferences)]);
        } catch (Exception $e) {
            error_log("Update user preferences error: " . $e->getMessage());
            return false;
        }
    }
    
    private function createDefaultPreferences($user_id) {
        $default_preferences = $this->getDefaultPreferences();
        return $this->updateUserPreferences($user_id, $default_preferences);
    }
    
    private function getDefaultPreferences() {
        return [
            'email' => [
                'welcome' => true,
                'deposit' => true,
                'withdrawal' => true,
                'bonus' => true,
                'win' => true,
                'security' => true,
                'promotion' => false
            ],
            'push' => [
                'welcome' => true,
                'deposit' => true,
                'withdrawal' => true,
                'bonus' => true,
                'win' => true,
                'security' => true,
                'promotion' => false
            ],
            'sms' => [
                'welcome' => false,
                'deposit' => false,
                'withdrawal' => true,
                'bonus' => false,
                'win' => false,
                'security' => true,
                'promotion' => false
            ]
        ];
    }
}

// Helper functions for easy access
function createNotification($user_id, $type, $title, $message, $data = null, $priority = 'normal') {
    global $pdo;
    $notificationManager = new NotificationManager($pdo);
    return $notificationManager->create($user_id, $type, $title, $message, $data, $priority);
}

function getUserNotifications($user_id, $limit = 20, $offset = 0, $unread_only = false) {
    global $pdo;
    $notificationManager = new NotificationManager($pdo);
    return $notificationManager->getUserNotifications($user_id, $limit, $offset, $unread_only);
}

function getUnreadNotificationCount($user_id) {
    global $pdo;
    $notificationManager = new NotificationManager($pdo);
    return $notificationManager->getUnreadCount($user_id);
}

function markNotificationAsRead($notification_id, $user_id = null) {
    global $pdo;
    $notificationManager = new NotificationManager($pdo);
    return $notificationManager->markAsRead($notification_id, $user_id);
}

function markAllNotificationsAsRead($user_id) {
    global $pdo;
    $notificationManager = new NotificationManager($pdo);
    return $notificationManager->markAllAsRead($user_id);
}

// Notification display functions
function displayNotificationIcon($type) {
    $icons = [
        'welcome' => 'fa-hand-holding-heart',
        'deposit' => 'fa-arrow-down',
        'withdrawal' => 'fa-arrow-up',
        'bonus' => 'fa-gift',
        'win' => 'fa-trophy',
        'security' => 'fa-shield-alt',
        'promotion' => 'fa-bullhorn',
        'system' => 'fa-cog',
        'default' => 'fa-bell'
    ];
    
    return $icons[$type] ?? $icons['default'];
}

function displayNotificationColor($type, $priority) {
    if ($priority === 'high') {
        return 'danger';
    }
    
    $colors = [
        'welcome' => 'success',
        'deposit' => 'success',
        'withdrawal' => 'warning',
        'bonus' => 'primary',
        'win' => 'success',
        'security' => 'danger',
        'promotion' => 'info',
        'system' => 'secondary',
        'default' => 'primary'
    ];
    
    return $colors[$type] ?? $colors['default'];
}

function formatNotificationTime($created_at) {
    $time = strtotime($created_at);
    $now = time();
    $diff = $now - $time;
    
    if ($diff < 60) {
        return 'همین الان';
    } elseif ($diff < 3600) {
        return floor($diff / 60) . ' دقیقه پیش';
    } elseif ($diff < 86400) {
        return floor($diff / 3600) . ' ساعت پیش';
    } elseif ($diff < 604800) {
        return floor($diff / 86400) . ' روز پیش';
    } else {
        return date('Y/m/d', $time);
    }
}
?>

PHP
); ?>

<?php _merge_exec('api/bets.php', <<<'PHP'
<?php
// api/bets.php - Bets API
// API شرط بندی

require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    throw new Exception('exit/die called in file api/bets.php');
}

$method = $_SERVER['REQUEST_METHOD'];
$endpoint = $_GET['endpoint'] ?? '';

try {
    // Require authentication for all bet operations
    requireAuth();
    
    switch ($endpoint) {
        case 'place':
            handlePlaceBetRequest($method);
            break;
            
        case 'history':
            handleBetHistoryRequest($method);
            break;
            
        case 'active':
            handleActiveBetsRequest($method);
            break;
            
        case 'cancel':
            handleCancelBetRequest($method);
            break;
            
        case 'cashout':
            handleCashoutRequest($method);
            break;
            
        case 'statistics':
            handleBetStatisticsRequest($method);
            break;
            
        default:
            throw new Exception('Invalid endpoint');
    }
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

function handlePlaceBetRequest($method) {
    global $currentUser;
    
    if ($method !== 'POST') {
        throw new Exception('Method not allowed');
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    $gameType = $input['game_type'] ?? '';
    $betAmount = floatval($input['bet_amount'] ?? 0);
    $betData = $input['bet_data'] ?? [];
    
    if (!$gameType) {
        throw new Exception('Game type is required');
    }
    
    if ($betAmount <= 0) {
        throw new Exception('Invalid bet amount');
    }
    
    // Check betting limits
    $minBet = getSetting('min_bet_amount', 1.00);
    $maxBet = getSetting('max_bet_amount', 10000.00);
    
    if ($betAmount < $minBet) {
        throw new Exception("Minimum bet amount is $" . number_format($minBet, 2));
    }
    
    if ($betAmount > $maxBet) {
        throw new Exception("Maximum bet amount is $" . number_format($maxBet, 2));
    }
    
    // Check if betting is enabled
    if (!getSetting('betting_enabled', true)) {
        throw new Exception('Betting is currently disabled');
    }
    
    // Check user balance
    $user = fetchRow("SELECT balance FROM users WHERE id = ?", [$currentUser['id']]);
    
    if ($user['balance'] < $betAmount) {
        throw new Exception('Insufficient balance');
    }
    
    // Handle different game types
    switch ($gameType) {
        case 'crash':
            $betId = placeCrashBet($currentUser['id'], $betAmount, $betData);
            break;
            
        case 'sports':
            $betId = placeSportsBet($currentUser['id'], $betAmount, $betData);
            break;
            
        case 'casino':
            $betId = placeCasinoBet($currentUser['id'], $betAmount, $betData);
            break;
            
        default:
            throw new Exception('Unsupported game type');
    }
    
    // Deduct bet amount from user balance
    execute("UPDATE users SET balance = balance - ? WHERE id = ?", [$betAmount, $currentUser['id']]);
    
    // Create transaction record
    execute(
        "INSERT INTO transactions (user_id, type, amount, status, description, created_at) 
         VALUES (?, 'bet', ?, 'completed', ?, NOW())",
        [$currentUser['id'], $betAmount, "Bet placed on $gameType"]
    );
    
    echo json_encode([
        'success' => true,
        'data' => [
            'bet_id' => $betId,
            'game_type' => $gameType,
            'bet_amount' => $betAmount,
            'status' => 'active',
            'placed_at' => date('Y-m-d H:i:s')
        ]
    ]);
}

function handleBetHistoryRequest($method) {
    global $currentUser;
    
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    $page = intval($_GET['page'] ?? 1);
    $limit = intval($_GET['limit'] ?? 20);
    $gameType = $_GET['game_type'] ?? 'all';
    $status = $_GET['status'] ?? 'all';
    $dateFrom = $_GET['date_from'] ?? '';
    $dateTo = $_GET['date_to'] ?? '';
    
    $offset = ($page - 1) * $limit;
    
    // Build query conditions
    $conditions = ["user_id = ?"];
    $params = [$currentUser['id']];
    
    if ($gameType !== 'all') {
        $conditions[] = "game_type = ?";
        $params[] = $gameType;
    }
    
    if ($status !== 'all') {
        $conditions[] = "status = ?";
        $params[] = $status;
    }
    
    if ($dateFrom) {
        $conditions[] = "DATE(created_at) >= ?";
        $params[] = $dateFrom;
    }
    
    if ($dateTo) {
        $conditions[] = "DATE(created_at) <= ?";
        $params[] = $dateTo;
    }
    
    $whereClause = implode(' AND ', $conditions);
    
    // Get total count
    $totalCount = fetchRow(
        "SELECT COUNT(*) as count FROM user_bets WHERE $whereClause",
        $params
    )['count'];
    
    // Get bets
    $bets = fetchAll(
        "SELECT * FROM user_bets 
         WHERE $whereClause 
         ORDER BY created_at DESC 
         LIMIT $limit OFFSET $offset",
        $params
    );
    
    // Calculate summary statistics
    $summary = fetchRow(
        "SELECT 
            COUNT(*) as total_bets,
            COALESCE(SUM(bet_amount), 0) as total_wagered,
            COALESCE(SUM(CASE WHEN status = 'won' THEN payout_amount ELSE 0 END), 0) as total_winnings,
            COALESCE(SUM(bet_amount) - SUM(CASE WHEN status = 'won' THEN payout_amount ELSE 0 END), 0) as net_loss
         FROM user_bets 
         WHERE $whereClause",
        $params
    );
    
    echo json_encode([
        'success' => true,
        'data' => [
            'bets' => $bets,
            'summary' => $summary,
            'pagination' => [
                'current_page' => $page,
                'total_pages' => ceil($totalCount / $limit),
                'total_count' => $totalCount,
                'per_page' => $limit
            ]
        ]
    ]);
}

function handleActiveBetsRequest($method) {
    global $currentUser;
    
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    $gameType = $_GET['game_type'] ?? 'all';
    
    // Build query conditions
    $conditions = ["user_id = ?", "status IN ('active', 'pending')"];
    $params = [$currentUser['id']];
    
    if ($gameType !== 'all') {
        $conditions[] = "game_type = ?";
        $params[] = $gameType;
    }
    
    $whereClause = implode(' AND ', $conditions);
    
    $activeBets = fetchAll(
        "SELECT * FROM user_bets 
         WHERE $whereClause 
         ORDER BY created_at DESC",
        $params
    );
    
    // Add real-time data for active bets
    foreach ($activeBets as &$bet) {
        if ($bet['game_type'] === 'crash' && $bet['status'] === 'active') {
            // Get current crash multiplier
            $bet['current_multiplier'] = getCurrentCrashMultiplier();
            $bet['potential_payout'] = $bet['bet_amount'] * $bet['current_multiplier'];
        } elseif ($bet['game_type'] === 'sports' && $bet['status'] === 'active') {
            // Get current match status
            $bet['match_status'] = getCurrentMatchStatus($bet['match_id'] ?? 0);
        }
    }
    
    echo json_encode([
        'success' => true,
        'data' => [
            'active_bets' => $activeBets,
            'total_active' => count($activeBets),
            'total_stake' => array_sum(array_column($activeBets, 'bet_amount'))
        ]
    ]);
}

function handleCancelBetRequest($method) {
    global $currentUser;
    
    if ($method !== 'POST') {
        throw new Exception('Method not allowed');
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    $betId = intval($input['bet_id'] ?? 0);
    
    if (!$betId) {
        throw new Exception('Bet ID is required');
    }
    
    // Get bet details
    $bet = fetchRow(
        "SELECT * FROM user_bets WHERE id = ? AND user_id = ?",
        [$betId, $currentUser['id']]
    );
    
    if (!$bet) {
        throw new Exception('Bet not found');
    }
    
    if ($bet['status'] !== 'pending') {
        throw new Exception('Only pending bets can be cancelled');
    }
    
    // Check if bet is still cancellable (e.g., sports bet before match starts)
    if (!isBetCancellable($bet)) {
        throw new Exception('This bet can no longer be cancelled');
    }
    
    // Cancel the bet
    execute(
        "UPDATE user_bets SET status = 'cancelled', updated_at = NOW() WHERE id = ?",
        [$betId]
    );
    
    // Refund the bet amount
    execute("UPDATE users SET balance = balance + ? WHERE id = ?", [$bet['bet_amount'], $currentUser['id']]);
    
    // Create refund transaction
    execute(
        "INSERT INTO transactions (user_id, type, amount, status, description, created_at) 
         VALUES (?, 'refund', ?, 'completed', ?, NOW())",
        [$currentUser['id'], $bet['bet_amount'], "Bet cancellation refund for bet #$betId"]
    );
    
    echo json_encode([
        'success' => true,
        'data' => [
            'bet_id' => $betId,
            'refund_amount' => $bet['bet_amount'],
            'message' => 'Bet cancelled successfully'
        ]
    ]);
}

function handleCashoutRequest($method) {
    global $currentUser;
    
    if ($method !== 'POST') {
        throw new Exception('Method not allowed');
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    $betId = intval($input['bet_id'] ?? 0);
    $cashoutMultiplier = floatval($input['multiplier'] ?? 0);
    
    if (!$betId) {
        throw new Exception('Bet ID is required');
    }
    
    // Get bet details
    $bet = fetchRow(
        "SELECT * FROM user_bets WHERE id = ? AND user_id = ?",
        [$betId, $currentUser['id']]
    );
    
    if (!$bet) {
        throw new Exception('Bet not found');
    }
    
    if ($bet['status'] !== 'active') {
        throw new Exception('Only active bets can be cashed out');
    }
    
    if ($bet['game_type'] !== 'crash') {
        throw new Exception('Cashout is only available for crash games');
    }
    
    // Validate cashout multiplier
    $currentMultiplier = getCurrentCrashMultiplier();
    
    if ($cashoutMultiplier > $currentMultiplier) {
        throw new Exception('Invalid cashout multiplier');
    }
    
    // Calculate payout
    $payoutAmount = $bet['bet_amount'] * $cashoutMultiplier;
    $maxWin = getSetting('max_win_amount', 100000.00);
    
    if ($payoutAmount > $maxWin) {
        $payoutAmount = $maxWin;
    }
    
    // Process cashout
    execute(
        "UPDATE user_bets SET 
            status = 'won', 
            payout_amount = ?, 
            cashout_multiplier = ?, 
            updated_at = NOW() 
         WHERE id = ?",
        [$payoutAmount, $cashoutMultiplier, $betId]
    );
    
    // Add winnings to user balance
    execute("UPDATE users SET balance = balance + ? WHERE id = ?", [$payoutAmount, $currentUser['id']]);
    
    // Create winning transaction
    execute(
        "INSERT INTO transactions (user_id, type, amount, status, description, created_at) 
         VALUES (?, 'win', ?, 'completed', ?, NOW())",
        [$currentUser['id'], $payoutAmount, "Crash game cashout at {$cashoutMultiplier}x"]
    );
    
    echo json_encode([
        'success' => true,
        'data' => [
            'bet_id' => $betId,
            'cashout_multiplier' => $cashoutMultiplier,
            'payout_amount' => $payoutAmount,
            'profit' => $payoutAmount - $bet['bet_amount'],
            'message' => 'Cashout successful'
        ]
    ]);
}

function handleBetStatisticsRequest($method) {
    global $currentUser;
    
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    $period = $_GET['period'] ?? '30days';
    
    // Calculate date range
    switch ($period) {
        case 'today':
            $dateFrom = date('Y-m-d');
            $dateTo = date('Y-m-d');
            break;
        case '7days':
            $dateFrom = date('Y-m-d', strtotime('-7 days'));
            $dateTo = date('Y-m-d');
            break;
        case '30days':
            $dateFrom = date('Y-m-d', strtotime('-30 days'));
            $dateTo = date('Y-m-d');
            break;
        case 'all':
            $dateFrom = '2020-01-01';
            $dateTo = date('Y-m-d');
            break;
        default:
            $dateFrom = date('Y-m-d', strtotime('-30 days'));
            $dateTo = date('Y-m-d');
    }
    
    // Overall statistics
    $overallStats = fetchRow(
        "SELECT 
            COUNT(*) as total_bets,
            COALESCE(SUM(bet_amount), 0) as total_wagered,
            COALESCE(SUM(CASE WHEN status = 'won' THEN payout_amount ELSE 0 END), 0) as total_winnings,
            COALESCE(AVG(bet_amount), 0) as avg_bet_amount,
            COUNT(CASE WHEN status = 'won' THEN 1 END) as wins,
            COUNT(CASE WHEN status = 'lost' THEN 1 END) as losses
         FROM user_bets 
         WHERE user_id = ? AND DATE(created_at) BETWEEN ? AND ?",
        [$currentUser['id'], $dateFrom, $dateTo]
    );
    
    // Calculate additional metrics
    $overallStats['net_profit'] = $overallStats['total_winnings'] - $overallStats['total_wagered'];
    $overallStats['win_rate'] = $overallStats['total_bets'] > 0 ? 
        ($overallStats['wins'] / $overallStats['total_bets']) * 100 : 0;
    $overallStats['rtp'] = $overallStats['total_wagered'] > 0 ? 
        ($overallStats['total_winnings'] / $overallStats['total_wagered']) * 100 : 0;
    
    // Game type breakdown
    $gameTypeStats = fetchAll(
        "SELECT 
            game_type,
            COUNT(*) as bet_count,
            COALESCE(SUM(bet_amount), 0) as total_wagered,
            COALESCE(SUM(CASE WHEN status = 'won' THEN payout_amount ELSE 0 END), 0) as total_winnings,
            COUNT(CASE WHEN status = 'won' THEN 1 END) as wins
         FROM user_bets 
         WHERE user_id = ? AND DATE(created_at) BETWEEN ? AND ?
         GROUP BY game_type
         ORDER BY total_wagered DESC",
        [$currentUser['id'], $dateFrom, $dateTo]
    );
    
    // Daily activity
    $dailyActivity = fetchAll(
        "SELECT 
            DATE(created_at) as date,
            COUNT(*) as bet_count,
            COALESCE(SUM(bet_amount), 0) as total_wagered,
            COALESCE(SUM(CASE WHEN status = 'won' THEN payout_amount ELSE 0 END), 0) as total_winnings
         FROM user_bets 
         WHERE user_id = ? AND DATE(created_at) BETWEEN ? AND ?
         GROUP BY DATE(created_at)
         ORDER BY date ASC",
        [$currentUser['id'], $dateFrom, $dateTo]
    );
    
    echo json_encode([
        'success' => true,
        'data' => [
            'period' => $period,
            'date_range' => [
                'from' => $dateFrom,
                'to' => $dateTo
            ],
            'overall' => $overallStats,
            'by_game_type' => $gameTypeStats,
            'daily_activity' => $dailyActivity
        ]
    ]);
}

// Helper functions
function placeCrashBet($userId, $betAmount, $betData) {
    $autoCashout = $betData['auto_cashout'] ?? null;
    
    return execute(
        "INSERT INTO user_bets (user_id, game_type, bet_amount, auto_cashout, status, created_at) 
         VALUES (?, 'crash', ?, ?, 'active', NOW())",
        [$userId, $betAmount, $autoCashout]
    );
}

function placeSportsBet($userId, $betAmount, $betData) {
    $matchId = $betData['match_id'] ?? 0;
    $betType = $betData['bet_type'] ?? '';
    $odds = $betData['odds'] ?? 0;
    
    if (!$matchId || !$betType || !$odds) {
        throw new Exception('Invalid sports bet data');
    }
    
    $potentialPayout = $betAmount * $odds;
    
    return execute(
        "INSERT INTO user_bets (user_id, game_type, bet_amount, match_id, bet_type, odds, potential_payout, status, created_at) 
         VALUES (?, 'sports', ?, ?, ?, ?, ?, 'pending', NOW())",
        [$userId, $betAmount, $matchId, $betType, $odds, $potentialPayout]
    );
}

function placeCasinoBet($userId, $betAmount, $betData) {
    $gameId = $betData['game_id'] ?? '';
    $betType = $betData['bet_type'] ?? '';
    
    if (!$gameId || !$betType) {
        throw new Exception('Invalid casino bet data');
    }
    
    return execute(
        "INSERT INTO user_bets (user_id, game_type, bet_amount, game_id, bet_type, status, created_at) 
         VALUES (?, 'casino', ?, ?, ?, 'pending', NOW())",
        [$userId, $betAmount, $gameId, $betType]
    );
}

function getCurrentCrashMultiplier() {
    // Mock function - in production, this would get the real-time multiplier
    return 1.5 + (rand(0, 500) / 100);
}

function getCurrentMatchStatus($matchId) {
    // Mock function - in production, this would get real match data
    return [
        'status' => 'live',
        'minute' => 45,
        'score' => '1-0'
    ];
}

function isBetCancellable($bet) {
    if ($bet['game_type'] === 'sports') {
        // Sports bets can be cancelled up to 5 minutes before match start
        // This is a simplified check
        return true;
    }
    
    return false;
}

function getSetting($key, $default = null) {
    $setting = fetchRow("SELECT setting_value FROM site_settings WHERE setting_key = ?", [$key]);
    return $setting ? $setting['setting_value'] : $default;
}
?>

PHP
); ?>

<?php _merge_exec('api/notifications.php', <<<'PHP'
<?php
// api/notifications.php - Notifications API
// API اطلاع‌رسانی

require_once '../includes/auth.php';
require_once '../includes/functions.php';
require_once '../includes/notifications.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit;
}

$user_id = $_SESSION['user_id'];
$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';

$notificationManager = new NotificationManager($pdo, $user_id);

try {
    switch ($method) {
        case 'GET':
            handleGetRequest($notificationManager, $user_id, $action);
            break;
            
        case 'POST':
            handlePostRequest($notificationManager, $user_id, $action);
            break;
            
        case 'PUT':
            handlePutRequest($notificationManager, $user_id, $action);
            break;
            
        case 'DELETE':
            handleDeleteRequest($notificationManager, $user_id, $action);
            break;
            
        default:
            http_response_code(405);
            echo json_encode(['success' => false, 'error' => 'Method not allowed']);
            break;
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Internal server error']);
    error_log("Notifications API error: " . $e->getMessage());
}

function handleGetRequest($notificationManager, $user_id, $action) {
    switch ($action) {
        case 'list':
            $limit = intval($_GET['limit'] ?? 20);
            $offset = intval($_GET['offset'] ?? 0);
            $unread_only = isset($_GET['unread_only']) && $_GET['unread_only'] === 'true';
            
            $notifications = $notificationManager->getUserNotifications($user_id, $limit, $offset, $unread_only);
            $total_count = getTotalNotificationCount($user_id, $unread_only);
            
            echo json_encode([
                'success' => true,
                'data' => [
                    'notifications' => formatNotificationsForAPI($notifications),
                    'total_count' => $total_count,
                    'has_more' => ($offset + $limit) < $total_count
                ]
            ]);
            break;
            
        case 'unread_count':
            $count = $notificationManager->getUnreadCount($user_id);
            echo json_encode([
                'success' => true,
                'data' => ['unread_count' => $count]
            ]);
            break;
            
        case 'preferences':
            $preferences = $notificationManager->getUserPreferences($user_id);
            echo json_encode([
                'success' => true,
                'data' => ['preferences' => $preferences]
            ]);
            break;
            
        case 'recent':
            $notifications = $notificationManager->getUserNotifications($user_id, 5, 0, false);
            echo json_encode([
                'success' => true,
                'data' => ['notifications' => formatNotificationsForAPI($notifications)]
            ]);
            break;
            
        default:
            http_response_code(400);
            echo json_encode(['success' => false, 'error' => 'Invalid action']);
            break;
    }
}

function handlePostRequest($notificationManager, $user_id, $action) {
    $input = json_decode(file_get_contents('php://input'), true);
    
    switch ($action) {
        case 'mark_read':
            $notification_id = intval($input['notification_id'] ?? 0);
            
            if (!$notification_id) {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Notification ID required']);
                return;
            }
            
            $result = $notificationManager->markAsRead($notification_id, $user_id);
            
            if ($result) {
                echo json_encode(['success' => true, 'message' => 'Notification marked as read']);
            } else {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Failed to mark notification as read']);
            }
            break;
            
        case 'mark_all_read':
            $result = $notificationManager->markAllAsRead($user_id);
            
            if ($result) {
                echo json_encode(['success' => true, 'message' => 'All notifications marked as read']);
            } else {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Failed to mark all notifications as read']);
            }
            break;
            
        case 'test':
            // Create test notification (for development)
            if (ENVIRONMENT === 'development') {
                $result = $notificationManager->create(
                    $user_id,
                    'system',
                    'Test Notification',
                    'This is a test notification created via API',
                    ['test' => true],
                    'normal'
                );
                
                if ($result) {
                    echo json_encode(['success' => true, 'message' => 'Test notification created']);
                } else {
                    http_response_code(400);
                    echo json_encode(['success' => false, 'error' => 'Failed to create test notification']);
                }
            } else {
                http_response_code(403);
                echo json_encode(['success' => false, 'error' => 'Test notifications only available in development']);
            }
            break;
            
        default:
            http_response_code(400);
            echo json_encode(['success' => false, 'error' => 'Invalid action']);
            break;
    }
}

function handlePutRequest($notificationManager, $user_id, $action) {
    $input = json_decode(file_get_contents('php://input'), true);
    
    switch ($action) {
        case 'preferences':
            $preferences = $input['preferences'] ?? [];
            
            if (empty($preferences)) {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Preferences data required']);
                return;
            }
            
            $result = $notificationManager->updateUserPreferences($user_id, $preferences);
            
            if ($result) {
                echo json_encode(['success' => true, 'message' => 'Preferences updated successfully']);
            } else {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Failed to update preferences']);
            }
            break;
            
        default:
            http_response_code(400);
            echo json_encode(['success' => false, 'error' => 'Invalid action']);
            break;
    }
}

function handleDeleteRequest($notificationManager, $user_id, $action) {
    switch ($action) {
        case 'delete':
            $notification_id = intval($_GET['id'] ?? 0);
            
            if (!$notification_id) {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Notification ID required']);
                return;
            }
            
            $result = $notificationManager->delete($notification_id, $user_id);
            
            if ($result) {
                echo json_encode(['success' => true, 'message' => 'Notification deleted successfully']);
            } else {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Failed to delete notification']);
            }
            break;
            
        case 'clear_all':
            global $pdo;
            $stmt = $pdo->prepare("DELETE FROM notifications WHERE user_id = ?");
            $result = $stmt->execute([$user_id]);
            
            if ($result) {
                echo json_encode(['success' => true, 'message' => 'All notifications cleared']);
            } else {
                http_response_code(400);
                echo json_encode(['success' => false, 'error' => 'Failed to clear notifications']);
            }
            break;
            
        default:
            http_response_code(400);
            echo json_encode(['success' => false, 'error' => 'Invalid action']);
            break;
    }
}

function formatNotificationsForAPI($notifications) {
    $formatted = [];
    
    foreach ($notifications as $notification) {
        $formatted[] = [
            'id' => $notification['id'],
            'type' => $notification['type'],
            'title' => $notification['title'],
            'message' => $notification['message'],
            'data' => $notification['data'],
            'priority' => $notification['priority'],
            'is_read' => (bool)$notification['is_read'],
            'created_at' => $notification['created_at'],
            'read_at' => $notification['read_at'],
            'formatted_time' => formatNotificationTime($notification['created_at']),
            'icon' => displayNotificationIcon($notification['type']),
            'color' => displayNotificationColor($notification['type'], $notification['priority'])
        ];
    }
    
    return $formatted;
}

function getTotalNotificationCount($user_id, $unread_only = false) {
    global $pdo;
    
    $where_clause = "WHERE user_id = ?";
    $params = [$user_id];
    
    if ($unread_only) {
        $where_clause .= " AND is_read = 0";
    }
    
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM notifications $where_clause");
    $stmt->execute($params);
    
    return $stmt->fetchColumn();
}

// WebSocket/SSE endpoint for real-time notifications
if ($action === 'stream') {
    // Set headers for Server-Sent Events
    header('Content-Type: text/event-stream');
    header('Cache-Control: no-cache');
    header('Connection: keep-alive');
    
    // Send initial connection message
    echo "data: " . json_encode(['type' => 'connected', 'message' => 'Connected to notification stream']) . "\n\n";
    
    // Check for new notifications every 5 seconds
    $last_check = time();
    
    while (true) {
        // Check if connection is still alive
        if (connection_aborted()) {
            break;
        }
        
        // Check for new notifications
        $current_time = time();
        if ($current_time - $last_check >= 5) {
            $notifications = $notificationManager->getUserNotifications($user_id, 10, 0, true);
            
            if (!empty($notifications)) {
                $formatted_notifications = formatNotificationsForAPI($notifications);
                echo "data: " . json_encode([
                    'type' => 'notifications',
                    'data' => $formatted_notifications
                ]) . "\n\n";
            }
            
            $last_check = $current_time;
        }
        
        // Send heartbeat
        echo "data: " . json_encode(['type' => 'heartbeat', 'timestamp' => time()]) . "\n\n";
        
        // Flush output
        if (ob_get_level()) {
            ob_flush();
        }
        flush();
        
        // Wait 1 second before next iteration
        sleep(1);
    }
}
?>

PHP
); ?>

<?php _merge_exec('api/odds.php', <<<'PHP'

<?php
// api/odds.php - Odds API
// API ضرایب

require_once '../config/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    throw new Exception('exit/die called in file api/odds.php');
}

$method = $_SERVER['REQUEST_METHOD'];
$endpoint = $_GET['endpoint'] ?? '';

try {
    switch ($endpoint) {
        case 'match':
            handleMatchOddsRequest($method);
            break;
            
        case 'live':
            handleLiveOddsRequest($method);
            break;
            
        case 'history':
            handleOddsHistoryRequest($method);
            break;
            
        case 'update':
            handleOddsUpdateRequest($method);
            break;
            
        case 'compare':
            handleOddsCompareRequest($method);
            break;
            
        default:
            throw new Exception('Invalid endpoint');
    }
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

function handleMatchOddsRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    $matchId = intval($_GET['match_id'] ?? 0);
    
    if (!$matchId) {
        throw new Exception('Match ID is required');
    }
    
    // Mock odds data - in production, this would come from odds providers
    $odds = [
        'match_id' => $matchId,
        'last_update' => date('Y-m-d H:i:s'),
        'markets' => [
            'match_result' => [
                'name' => 'Match Result',
                'options' => [
                    [
                        'id' => 'home_win',
                        'name' => 'Home Win',
                        'odds' => 1.85,
                        'change' => '+0.05',
                        'trend' => 'up'
                    ],
                    [
                        'id' => 'draw',
                        'name' => 'Draw',
                        'odds' => 3.20,
                        'change' => '-0.10',
                        'trend' => 'down'
                    ],
                    [
                        'id' => 'away_win',
                        'name' => 'Away Win',
                        'odds' => 2.10,
                        'change' => '+0.15',
                        'trend' => 'up'
                    ]
                ]
            ],
            'total_goals' => [
                'name' => 'Total Goals',
                'options' => [
                    [
                        'id' => 'over_2_5',
                        'name' => 'Over 2.5',
                        'odds' => 1.75,
                        'change' => '0.00',
                        'trend' => 'stable'
                    ],
                    [
                        'id' => 'under_2_5',
                        'name' => 'Under 2.5',
                        'odds' => 2.05,
                        'change' => '0.00',
                        'trend' => 'stable'
                    ]
                ]
            ],
            'both_teams_score' => [
                'name' => 'Both Teams to Score',
                'options' => [
                    [
                        'id' => 'yes',
                        'name' => 'Yes',
                        'odds' => 1.65,
                        'change' => '+0.05',
                        'trend' => 'up'
                    ],
                    [
                        'id' => 'no',
                        'name' => 'No',
                        'odds' => 2.25,
                        'change' => '-0.05',
                        'trend' => 'down'
                    ]
                ]
            ]
        ],
        'statistics' => [
            'total_volume' => 125000.50,
            'bet_count' => 1247,
            'most_popular' => 'home_win'
        ]
    ];
    
    echo json_encode([
        'success' => true,
        'data' => $odds
    ]);
}

function handleLiveOddsRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    // Get all live matches with current odds
    $liveOdds = [
        [
            'match_id' => 2,
            'home_team' => 'Green Bay Packers',
            'away_team' => 'Chicago Bears',
            'score' => '14-7',
            'minute' => 45,
            'status' => 'live',
            'odds' => [
                'home_win' => 1.65,
                'away_win' => 2.45,
                'draw' => 3.80
            ],
            'changes' => [
                'home_win' => '-0.20',
                'away_win' => '+0.35',
                'draw' => '+0.60'
            ],
            'last_update' => date('Y-m-d H:i:s', strtotime('-30 seconds'))
        ],
        [
            'match_id' => 5,
            'home_team' => 'Arsenal',
            'away_team' => 'Chelsea',
            'score' => '1-1',
            'minute' => 67,
            'status' => 'live',
            'odds' => [
                'home_win' => 2.10,
                'away_win' => 2.05,
                'draw' => 3.20
            ],
            'changes' => [
                'home_win' => '+0.10',
                'away_win' => '-0.05',
                'draw' => '-0.30'
            ],
            'last_update' => date('Y-m-d H:i:s', strtotime('-15 seconds'))
        ]
    ];
    
    echo json_encode([
        'success' => true,
        'data' => $liveOdds,
        'timestamp' => time(),
        'next_update' => time() + 30
    ]);
}

function handleOddsHistoryRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    $matchId = intval($_GET['match_id'] ?? 0);
    $market = $_GET['market'] ?? 'match_result';
    $hours = intval($_GET['hours'] ?? 24);
    
    if (!$matchId) {
        throw new Exception('Match ID is required');
    }
    
    // Mock historical odds data
    $history = [];
    $baseTime = time() - ($hours * 3600);
    
    for ($i = 0; $i < $hours; $i++) {
        $timestamp = $baseTime + ($i * 3600);
        
        // Simulate odds movement
        $homeOdds = 1.85 + (sin($i * 0.5) * 0.3) + (rand(-10, 10) / 100);
        $awayOdds = 2.10 + (cos($i * 0.3) * 0.2) + (rand(-10, 10) / 100);
        $drawOdds = 3.20 + (sin($i * 0.2) * 0.4) + (rand(-15, 15) / 100);
        
        $history[] = [
            'timestamp' => $timestamp,
            'datetime' => date('Y-m-d H:i:s', $timestamp),
            'odds' => [
                'home_win' => round($homeOdds, 2),
                'away_win' => round($awayOdds, 2),
                'draw' => round($drawOdds, 2)
            ]
        ];
    }
    
    echo json_encode([
        'success' => true,
        'data' => [
            'match_id' => $matchId,
            'market' => $market,
            'period' => $hours . ' hours',
            'history' => $history
        ]
    ]);
}

function handleOddsUpdateRequest($method) {
    if ($method !== 'POST') {
        throw new Exception('Method not allowed');
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    $matchId = intval($input['match_id'] ?? 0);
    $odds = $input['odds'] ?? [];
    
    if (!$matchId || empty($odds)) {
        throw new Exception('Match ID and odds are required');
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Odds updated successfully',
        'match_id' => $matchId,
        'updated_at' => date('Y-m-d H:i:s')
    ]);
}

function handleOddsCompareRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    $matchId = intval($_GET['match_id'] ?? 0);
    
    if (!$matchId) {
        throw new Exception('Match ID is required');
    }
    
    // Mock comparison data from different bookmakers
    $comparison = [
        'match_id' => $matchId,
        'bookmakers' => [
            [
                'name' => 'Crashify',
                'odds' => [
                    'home_win' => 1.85,
                    'draw' => 3.20,
                    'away_win' => 2.10
                ],
                'margin' => 4.2
            ],
            [
                'name' => 'Competitor A',
                'odds' => [
                    'home_win' => 1.82,
                    'draw' => 3.15,
                    'away_win' => 2.15
                ],
                'margin' => 4.8
            ],
            [
                'name' => 'Competitor B',
                'odds' => [
                    'home_win' => 1.88,
                    'draw' => 3.25,
                    'away_win' => 2.05
                ],
                'margin' => 3.9
            ]
        ],
        'best_odds' => [
            'home_win' => ['bookmaker' => 'Competitor B', 'odds' => 1.88],
            'draw' => ['bookmaker' => 'Competitor B', 'odds' => 3.25],
            'away_win' => ['bookmaker' => 'Competitor A', 'odds' => 2.15]
        ]
    ];
    
    echo json_encode([
        'success' => true,
        'data' => $comparison
    ]);
}
?>
PHP
); ?>

<?php _merge_exec('api/sports.php', <<<'PHP'
<?php
// api/sports.php - Sports API
// API ورزشی

require_once '../config/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    throw new Exception('exit/die called in file api/sports.php');
}

$method = $_SERVER['REQUEST_METHOD'];
$endpoint = $_GET['endpoint'] ?? '';

try {
    switch ($endpoint) {
        case 'sports':
            handleSportsRequest($method);
            break;
            
        case 'leagues':
            handleLeaguesRequest($method);
            break;
            
        case 'matches':
            handleMatchesRequest($method);
            break;
            
        case 'live':
            handleLiveMatchesRequest($method);
            break;
            
        case 'bet':
            handleBetRequest($method);
            break;
            
        default:
            throw new Exception('Invalid endpoint');
    }
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

function handleSportsRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    // Mock sports data - in production, this would come from a sports data provider
    $sports = [
        [
            'id' => 1,
            'name' => 'Football',
            'slug' => 'football',
            'icon' => 'fas fa-football-ball',
            'active' => true,
            'leagues_count' => 25,
            'live_matches' => 8
        ],
        [
            'id' => 2,
            'name' => 'Basketball',
            'slug' => 'basketball',
            'icon' => 'fas fa-basketball-ball',
            'active' => true,
            'leagues_count' => 15,
            'live_matches' => 3
        ],
        [
            'id' => 3,
            'name' => 'Tennis',
            'slug' => 'tennis',
            'icon' => 'fas fa-table-tennis',
            'active' => true,
            'leagues_count' => 12,
            'live_matches' => 5
        ],
        [
            'id' => 4,
            'name' => 'Soccer',
            'slug' => 'soccer',
            'icon' => 'fas fa-futbol',
            'active' => true,
            'leagues_count' => 30,
            'live_matches' => 12
        ],
        [
            'id' => 5,
            'name' => 'Baseball',
            'slug' => 'baseball',
            'icon' => 'fas fa-baseball-ball',
            'active' => true,
            'leagues_count' => 8,
            'live_matches' => 2
        ]
    ];
    
    echo json_encode([
        'success' => true,
        'data' => $sports
    ]);
}

function handleLeaguesRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    $sportId = intval($_GET['sport_id'] ?? 0);
    
    // Mock leagues data
    $leagues = [
        [
            'id' => 1,
            'sport_id' => 1,
            'name' => 'NFL',
            'country' => 'USA',
            'logo' => '/assets/images/leagues/nfl.png',
            'active' => true,
            'matches_count' => 16,
            'live_matches' => 2
        ],
        [
            'id' => 2,
            'sport_id' => 1,
            'name' => 'Premier League',
            'country' => 'England',
            'logo' => '/assets/images/leagues/premier-league.png',
            'active' => true,
            'matches_count' => 20,
            'live_matches' => 3
        ],
        [
            'id' => 3,
            'sport_id' => 2,
            'name' => 'NBA',
            'country' => 'USA',
            'logo' => '/assets/images/leagues/nba.png',
            'active' => true,
            'matches_count' => 12,
            'live_matches' => 1
        ],
        [
            'id' => 4,
            'sport_id' => 4,
            'name' => 'Champions League',
            'country' => 'Europe',
            'logo' => '/assets/images/leagues/champions-league.png',
            'active' => true,
            'matches_count' => 8,
            'live_matches' => 2
        ]
    ];
    
    if ($sportId > 0) {
        $leagues = array_filter($leagues, function($league) use ($sportId) {
            return $league['sport_id'] === $sportId;
        });
        $leagues = array_values($leagues);
    }
    
    echo json_encode([
        'success' => true,
        'data' => $leagues
    ]);
}

function handleMatchesRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    $leagueId = intval($_GET['league_id'] ?? 0);
    $date = $_GET['date'] ?? date('Y-m-d');
    $status = $_GET['status'] ?? 'all'; // all, upcoming, live, finished
    
    // Mock matches data
    $matches = [
        [
            'id' => 1,
            'league_id' => 1,
            'league_name' => 'NFL',
            'home_team' => 'Dallas Cowboys',
            'away_team' => 'New York Giants',
            'home_logo' => '/assets/images/teams/cowboys.png',
            'away_logo' => '/assets/images/teams/giants.png',
            'start_time' => date('Y-m-d H:i:s', strtotime('+2 hours')),
            'status' => 'upcoming',
            'home_score' => null,
            'away_score' => null,
            'odds' => [
                'home_win' => 1.85,
                'away_win' => 2.10,
                'draw' => 3.20
            ]
        ],
        [
            'id' => 2,
            'league_id' => 1,
            'league_name' => 'NFL',
            'home_team' => 'Green Bay Packers',
            'away_team' => 'Chicago Bears',
            'home_logo' => '/assets/images/teams/packers.png',
            'away_logo' => '/assets/images/teams/bears.png',
            'start_time' => date('Y-m-d H:i:s', strtotime('-1 hour')),
            'status' => 'live',
            'home_score' => 14,
            'away_score' => 7,
            'minute' => 45,
            'odds' => [
                'home_win' => 1.65,
                'away_win' => 2.45,
                'draw' => 3.80
            ]
        ],
        [
            'id' => 3,
            'league_id' => 2,
            'league_name' => 'Premier League',
            'home_team' => 'Manchester United',
            'away_team' => 'Liverpool',
            'home_logo' => '/assets/images/teams/man-utd.png',
            'away_logo' => '/assets/images/teams/liverpool.png',
            'start_time' => date('Y-m-d H:i:s', strtotime('+4 hours')),
            'status' => 'upcoming',
            'home_score' => null,
            'away_score' => null,
            'odds' => [
                'home_win' => 2.20,
                'away_win' => 1.75,
                'draw' => 3.40
            ]
        ],
        [
            'id' => 4,
            'league_id' => 3,
            'league_name' => 'NBA',
            'home_team' => 'Los Angeles Lakers',
            'away_team' => 'Boston Celtics',
            'home_logo' => '/assets/images/teams/lakers.png',
            'away_logo' => '/assets/images/teams/celtics.png',
            'start_time' => date('Y-m-d H:i:s', strtotime('-3 hours')),
            'status' => 'finished',
            'home_score' => 108,
            'away_score' => 112,
            'odds' => [
                'home_win' => 1.90,
                'away_win' => 1.95
            ]
        ]
    ];
    
    // Filter by league
    if ($leagueId > 0) {
        $matches = array_filter($matches, function($match) use ($leagueId) {
            return $match['league_id'] === $leagueId;
        });
    }
    
    // Filter by status
    if ($status !== 'all') {
        $matches = array_filter($matches, function($match) use ($status) {
            return $match['status'] === $status;
        });
    }
    
    $matches = array_values($matches);
    
    echo json_encode([
        'success' => true,
        'data' => $matches,
        'total' => count($matches)
    ]);
}

function handleLiveMatchesRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    // Mock live matches with real-time updates
    $liveMatches = [
        [
            'id' => 2,
            'league_name' => 'NFL',
            'home_team' => 'Green Bay Packers',
            'away_team' => 'Chicago Bears',
            'home_score' => 14,
            'away_score' => 7,
            'minute' => 45,
            'period' => '2nd Quarter',
            'status' => 'live',
            'odds' => [
                'home_win' => 1.65,
                'away_win' => 2.45,
                'draw' => 3.80
            ],
            'last_update' => date('Y-m-d H:i:s')
        ],
        [
            'id' => 5,
            'league_name' => 'Premier League',
            'home_team' => 'Arsenal',
            'away_team' => 'Chelsea',
            'home_score' => 1,
            'away_score' => 1,
            'minute' => 67,
            'period' => '2nd Half',
            'status' => 'live',
            'odds' => [
                'home_win' => 2.10,
                'away_win' => 2.05,
                'draw' => 3.20
            ],
            'last_update' => date('Y-m-d H:i:s')
        ],
        [
            'id' => 6,
            'league_name' => 'NBA',
            'home_team' => 'Golden State Warriors',
            'away_team' => 'Miami Heat',
            'home_score' => 89,
            'away_score' => 92,
            'minute' => 8,
            'period' => '4th Quarter',
            'status' => 'live',
            'odds' => [
                'home_win' => 1.85,
                'away_win' => 2.00
            ],
            'last_update' => date('Y-m-d H:i:s')
        ]
    ];
    
    echo json_encode([
        'success' => true,
        'data' => $liveMatches,
        'timestamp' => time()
    ]);
}

function handleBetRequest($method) {
    if ($method !== 'POST') {
        throw new Exception('Method not allowed');
    }
    
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    $matchId = intval($input['match_id'] ?? 0);
    $betType = $input['bet_type'] ?? '';
    $amount = floatval($input['amount'] ?? 0);
    $odds = floatval($input['odds'] ?? 0);
    $userId = intval($input['user_id'] ?? 0);
    
    if (!$matchId || !$betType || $amount <= 0 || $odds <= 0 || !$userId) {
        throw new Exception('Missing required parameters');
    }
    
    // Validate user and balance
    $user = fetchRow("SELECT * FROM users WHERE id = ? AND status = 'active'", [$userId]);
    if (!$user) {
        throw new Exception('Invalid user');
    }
    
    if ($user['balance'] < $amount) {
        throw new Exception('Insufficient balance');
    }
    
    // Get match details
    $match = getMatchById($matchId);
    if (!$match) {
        throw new Exception('Match not found');
    }
    
    if ($match['status'] !== 'upcoming' && $match['status'] !== 'live') {
        throw new Exception('Betting not available for this match');
    }
    
    // Calculate potential payout
    $potentialPayout = $amount * $odds;
    
    // Create bet record
    $betId = execute(
        "INSERT INTO sports_bets (user_id, match_id, bet_type, amount, odds, potential_payout, status, created_at) 
         VALUES (?, ?, ?, ?, ?, ?, 'pending', NOW())",
        [$userId, $matchId, $betType, $amount, $odds, $potentialPayout]
    );
    
    // Deduct amount from user balance
    execute("UPDATE users SET balance = balance - ? WHERE id = ?", [$amount, $userId]);
    
    // Create transaction record
    execute(
        "INSERT INTO transactions (user_id, type, amount, status, description, created_at) 
         VALUES (?, 'sports_bet', ?, 'completed', ?, NOW())",
        [$userId, $amount, "Sports bet on {$match['home_team']} vs {$match['away_team']}"]
    );
    
    echo json_encode([
        'success' => true,
        'bet_id' => $betId,
        'message' => 'Bet placed successfully',
        'bet_details' => [
            'match' => $match['home_team'] . ' vs ' . $match['away_team'],
            'bet_type' => $betType,
            'amount' => $amount,
            'odds' => $odds,
            'potential_payout' => $potentialPayout
        ]
    ]);
}

function getMatchById($matchId) {
    // In a real application, this would query the database
    // For now, return mock data
    $matches = [
        1 => [
            'id' => 1,
            'home_team' => 'Dallas Cowboys',
            'away_team' => 'New York Giants',
            'status' => 'upcoming'
        ],
        2 => [
            'id' => 2,
            'home_team' => 'Green Bay Packers',
            'away_team' => 'Chicago Bears',
            'status' => 'live'
        ]
    ];
    
    return $matches[$matchId] ?? null;
}

// Helper function to get current odds for a match
function getCurrentOdds($matchId) {
    // Mock odds that would normally come from odds provider
    return [
        'home_win' => 1.85 + (rand(-20, 20) / 100),
        'away_win' => 2.10 + (rand(-20, 20) / 100),
        'draw' => 3.20 + (rand(-30, 30) / 100)
    ];
}

// Helper function to update live match scores
function updateLiveScores() {
    // This would be called by a background process to update live scores
    // Mock implementation
    return true;
}
?>


PHP
); ?>

<?php _merge_exec('api/support.php', <<<'PHP'
<?php
// api/support.php - Support API
// API پشتیبانی

require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    throw new Exception('exit/die called in file api/support.php');
}

$method = $_SERVER['REQUEST_METHOD'];
$endpoint = $_GET['endpoint'] ?? '';

try {
    switch ($endpoint) {
        case 'tickets':
            handleTicketsRequest($method);
            break;
            
        case 'create':
            handleCreateTicketRequest($method);
            break;
            
        case 'reply':
            handleReplyRequest($method);
            break;
            
        case 'close':
            handleCloseTicketRequest($method);
            break;
            
        case 'categories':
            handleCategoriesRequest($method);
            break;
            
        case 'faq':
            handleFaqRequest($method);
            break;
            
        case 'chat':
            handleChatRequest($method);
            break;
            
        default:
            throw new Exception('Invalid endpoint');
    }
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

function handleTicketsRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    // Check if user is authenticated
    $isAuthenticated = isset($_SESSION['user_id']);
    $userId = $isAuthenticated ? $_SESSION['user_id'] : null;
    
    if (!$isAuthenticated) {
        throw new Exception('Authentication required');
    }
    
    $page = intval($_GET['page'] ?? 1);
    $limit = intval($_GET['limit'] ?? 10);
    $status = $_GET['status'] ?? 'all';
    $category = $_GET['category'] ?? 'all';
    
    $offset = ($page - 1) * $limit;
    
    // Build query conditions
    $conditions = ["user_id = ?"];
    $params = [$userId];
    
    if ($status !== 'all') {
        $conditions[] = "status = ?";
        $params[] = $status;
    }
    
    if ($category !== 'all') {
        $conditions[] = "category = ?";
        $params[] = $category;
    }
    
    $whereClause = implode(' AND ', $conditions);
    
    // Get total count
    $totalCount = fetchRow(
        "SELECT COUNT(*) as count FROM support_tickets WHERE $whereClause",
        $params
    )['count'];
    
    // Get tickets
    $tickets = fetchAll(
        "SELECT st.*, u.username, 
                (SELECT COUNT(*) FROM support_messages sm WHERE sm.ticket_id = st.id) as message_count,
                (SELECT created_at FROM support_messages sm WHERE sm.ticket_id = st.id ORDER BY created_at DESC LIMIT 1) as last_message_at
         FROM support_tickets st
         LEFT JOIN users u ON st.user_id = u.id
         WHERE $whereClause 
         ORDER BY st.updated_at DESC 
         LIMIT $limit OFFSET $offset",
        $params
    );
    
    echo json_encode([
        'success' => true,
        'data' => [
            'tickets' => $tickets,
            'pagination' => [
                'current_page' => $page,
                'total_pages' => ceil($totalCount / $limit),
                'total_count' => $totalCount,
                'per_page' => $limit
            ]
        ]
    ]);
}

function handleCreateTicketRequest($method) {
    if ($method !== 'POST') {
        throw new Exception('Method not allowed');
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    $subject = trim($input['subject'] ?? '');
    $message = trim($input['message'] ?? '');
    $category = $input['category'] ?? 'general';
    $priority = $input['priority'] ?? 'medium';
    $email = trim($input['email'] ?? '');
    $name = trim($input['name'] ?? '');
    
    if (!$subject || !$message) {
        throw new Exception('Subject and message are required');
    }
    
    if (strlen($subject) < 5) {
        throw new Exception('Subject must be at least 5 characters long');
    }
    
    if (strlen($message) < 10) {
        throw new Exception('Message must be at least 10 characters long');
    }
    
    // Check if user is authenticated
    $isAuthenticated = isset($_SESSION['user_id']);
    $userId = $isAuthenticated ? $_SESSION['user_id'] : null;
    
    // For guest users, email is required
    if (!$isAuthenticated && !$email) {
        throw new Exception('Email is required for guest tickets');
    }
    
    if (!$isAuthenticated && !$name) {
        throw new Exception('Name is required for guest tickets');
    }
    
    // Generate ticket number
    $ticketNumber = 'TKT-' . date('Ymd') . '-' . str_pad(rand(1, 9999), 4, '0', STR_PAD_LEFT);
    
    // Create ticket
    $ticketId = execute(
        "INSERT INTO support_tickets (ticket_number, user_id, subject, category, priority, status, guest_email, guest_name, created_at, updated_at) 
         VALUES (?, ?, ?, ?, ?, 'open', ?, ?, NOW(), NOW())",
        [$ticketNumber, $userId, $subject, $category, $priority, $email, $name]
    );
    
    // Add initial message
    execute(
        "INSERT INTO support_messages (ticket_id, user_id, message, is_staff, created_at) 
         VALUES (?, ?, ?, 0, NOW())",
        [$ticketId, $userId, $message]
    );
    
    // Send notification email (mock implementation)
    if ($email) {
        sendTicketNotification($email, $ticketNumber, $subject);
    }
    
    echo json_encode([
        'success' => true,
        'data' => [
            'ticket_id' => $ticketId,
            'ticket_number' => $ticketNumber,
            'subject' => $subject,
            'status' => 'open',
            'created_at' => date('Y-m-d H:i:s'),
            'message' => 'Support ticket created successfully'
        ]
    ]);
}

function handleReplyRequest($method) {
    if ($method !== 'POST') {
        throw new Exception('Method not allowed');
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    $ticketId = intval($input['ticket_id'] ?? 0);
    $message = trim($input['message'] ?? '');
    
    if (!$ticketId) {
        throw new Exception('Ticket ID is required');
    }
    
    if (!$message) {
        throw new Exception('Message is required');
    }
    
    if (strlen($message) < 5) {
        throw new Exception('Message must be at least 5 characters long');
    }
    
    // Check if user is authenticated
    $isAuthenticated = isset($_SESSION['user_id']);
    $userId = $isAuthenticated ? $_SESSION['user_id'] : null;
    
    if (!$isAuthenticated) {
        throw new Exception('Authentication required');
    }
    
    // Verify ticket ownership
    $ticket = fetchRow(
        "SELECT * FROM support_tickets WHERE id = ? AND user_id = ?",
        [$ticketId, $userId]
    );
    
    if (!$ticket) {
        throw new Exception('Ticket not found or access denied');
    }
    
    if ($ticket['status'] === 'closed') {
        throw new Exception('Cannot reply to closed ticket');
    }
    
    // Add reply message
    $messageId = execute(
        "INSERT INTO support_messages (ticket_id, user_id, message, is_staff, created_at) 
         VALUES (?, ?, ?, 0, NOW())",
        [$ticketId, $userId, $message]
    );
    
    // Update ticket status and timestamp
    execute(
        "UPDATE support_tickets SET status = 'awaiting_staff', updated_at = NOW() WHERE id = ?",
        [$ticketId]
    );
    
    echo json_encode([
        'success' => true,
        'data' => [
            'message_id' => $messageId,
            'ticket_id' => $ticketId,
            'message' => $message,
            'created_at' => date('Y-m-d H:i:s'),
            'status' => 'Reply added successfully'
        ]
    ]);
}

function handleCloseTicketRequest($method) {
    if ($method !== 'POST') {
        throw new Exception('Method not allowed');
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    $ticketId = intval($input['ticket_id'] ?? 0);
    $reason = trim($input['reason'] ?? '');
    
    if (!$ticketId) {
        throw new Exception('Ticket ID is required');
    }
    
    // Check if user is authenticated
    $isAuthenticated = isset($_SESSION['user_id']);
    $userId = $isAuthenticated ? $_SESSION['user_id'] : null;
    
    if (!$isAuthenticated) {
        throw new Exception('Authentication required');
    }
    
    // Verify ticket ownership
    $ticket = fetchRow(
        "SELECT * FROM support_tickets WHERE id = ? AND user_id = ?",
        [$ticketId, $userId]
    );
    
    if (!$ticket) {
        throw new Exception('Ticket not found or access denied');
    }
    
    if ($ticket['status'] === 'closed') {
        throw new Exception('Ticket is already closed');
    }
    
    // Close ticket
    execute(
        "UPDATE support_tickets SET status = 'closed', closed_at = NOW(), updated_at = NOW() WHERE id = ?",
        [$ticketId]
    );
    
    // Add closure message if reason provided
    if ($reason) {
        execute(
            "INSERT INTO support_messages (ticket_id, user_id, message, is_staff, created_at) 
             VALUES (?, ?, ?, 0, NOW())",
            [$ticketId, $userId, "Ticket closed by user. Reason: $reason"]
        );
    }
    
    echo json_encode([
        'success' => true,
        'data' => [
            'ticket_id' => $ticketId,
            'status' => 'closed',
            'closed_at' => date('Y-m-d H:i:s'),
            'message' => 'Ticket closed successfully'
        ]
    ]);
}

function handleCategoriesRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    // Support categories
    $categories = [
        [
            'id' => 'general',
            'name' => 'General Inquiry',
            'description' => 'General questions and inquiries',
            'icon' => 'fas fa-question-circle'
        ],
        [
            'id' => 'account',
            'name' => 'Account Issues',
            'description' => 'Login, registration, and account problems',
            'icon' => 'fas fa-user-circle'
        ],
        [
            'id' => 'payment',
            'name' => 'Payment & Withdrawal',
            'description' => 'Deposit and withdrawal related issues',
            'icon' => 'fas fa-credit-card'
        ],
        [
            'id' => 'betting',
            'name' => 'Betting Issues',
            'description' => 'Problems with placing bets or game results',
            'icon' => 'fas fa-dice'
        ],
        [
            'id' => 'technical',
            'name' => 'Technical Support',
            'description' => 'Website bugs and technical problems',
            'icon' => 'fas fa-cog'
        ],
        [
            'id' => 'complaint',
            'name' => 'Complaint',
            'description' => 'File a complaint about our services',
            'icon' => 'fas fa-exclamation-triangle'
        ]
    ];
    
    echo json_encode([
        'success' => true,
        'data' => $categories
    ]);
}

function handleFaqRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    $category = $_GET['category'] ?? 'all';
    
    // Mock FAQ data
    $faqs = [
        [
            'id' => 1,
            'category' => 'general',
            'question' => 'How do I create an account?',
            'answer' => 'To create an account, click on the "Register" button in the top right corner of the website and fill out the required information.',
            'order' => 1
        ],
        [
            'id' => 2,
            'category' => 'general',
            'question' => 'Is Crashify legal and licensed?',
            'answer' => 'Yes, Crashify operates under proper licensing and follows all applicable regulations.',
            'order' => 2
        ],
        [
            'id' => 3,
            'category' => 'payment',
            'question' => 'What payment methods do you accept?',
            'answer' => 'We accept credit cards, bank transfers, and various cryptocurrencies including Bitcoin and Ethereum.',
            'order' => 1
        ],
        [
            'id' => 4,
            'category' => 'payment',
            'question' => 'How long do withdrawals take?',
            'answer' => 'Withdrawal processing times vary by method: Crypto (10-60 minutes), Bank transfer (1-3 business days).',
            'order' => 2
        ],
        [
            'id' => 5,
            'category' => 'betting',
            'question' => 'What is the minimum bet amount?',
            'answer' => 'The minimum bet amount is $1.00 for most games.',
            'order' => 1
        ],
        [
            'id' => 6,
            'category' => 'betting',
            'question' => 'How does the crash game work?',
            'answer' => 'In the crash game, you place a bet and watch the multiplier increase. Cash out before it crashes to win!',
            'order' => 2
        ],
        [
            'id' => 7,
            'category' => 'account',
            'question' => 'How do I verify my account?',
            'answer' => 'Account verification requires uploading a government-issued ID and proof of address.',
            'order' => 1
        ],
        [
            'id' => 8,
            'category' => 'account',
            'question' => 'I forgot my password, what should I do?',
            'answer' => 'Click on "Forgot Password" on the login page and follow the instructions sent to your email.',
            'order' => 2
        ]
    ];
    
    // Filter by category if specified
    if ($category !== 'all') {
        $faqs = array_filter($faqs, function($faq) use ($category) {
            return $faq['category'] === $category;
        });
        $faqs = array_values($faqs);
    }
    
    // Group by category
    $groupedFaqs = [];
    foreach ($faqs as $faq) {
        $groupedFaqs[$faq['category']][] = $faq;
    }
    
    echo json_encode([
        'success' => true,
        'data' => [
            'faqs' => $faqs,
            'grouped' => $groupedFaqs,
            'total' => count($faqs)
        ]
    ]);
}

function handleChatRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    // Live chat availability
    $chatStatus = [
        'available' => true,
        'online_agents' => 3,
        'average_wait_time' => '2 minutes',
        'hours' => '24/7',
        'languages' => ['English', 'Persian']
    ];
    
    echo json_encode([
        'success' => true,
        'data' => $chatStatus
    ]);
}

function sendTicketNotification($email, $ticketNumber, $subject) {
    // Mock email sending - in production, integrate with email service
    // This would send an email notification about the new ticket
    return true;
}
?>
PHP
); ?>

<?php _merge_exec('api/wallet.php', <<<'PHP'
<?php
// api/wallet.php - Wallet API
// API کیف پول

require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    throw new Exception('exit/die called in file api/wallet.php');
}

$method = $_SERVER['REQUEST_METHOD'];
$endpoint = $_GET['endpoint'] ?? '';

try {
    // Require authentication for all wallet operations
    requireAuth();
    
    switch ($endpoint) {
        case 'balance':
            handleBalanceRequest($method);
            break;
            
        case 'deposit':
            handleDepositRequest($method);
            break;
            
        case 'withdraw':
            handleWithdrawRequest($method);
            break;
            
        case 'transactions':
            handleTransactionsRequest($method);
            break;
            
        case 'payment-methods':
            handlePaymentMethodsRequest($method);
            break;
            
        case 'limits':
            handleLimitsRequest($method);
            break;
            
        default:
            throw new Exception('Invalid endpoint');
    }
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

function handleBalanceRequest($method) {
    global $currentUser;
    
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    // Get current balance
    $user = fetchRow("SELECT balance, bonus_balance FROM users WHERE id = ?", [$currentUser['id']]);
    
    // Get pending transactions
    $pendingDeposits = fetchRow(
        "SELECT COUNT(*) as count, COALESCE(SUM(amount), 0) as total 
         FROM transactions 
         WHERE user_id = ? AND type = 'deposit' AND status = 'pending'",
        [$currentUser['id']]
    );
    
    $pendingWithdrawals = fetchRow(
        "SELECT COUNT(*) as count, COALESCE(SUM(amount), 0) as total 
         FROM transactions 
         WHERE user_id = ? AND type = 'withdrawal' AND status = 'pending'",
        [$currentUser['id']]
    );
    
    // Get recent transactions
    $recentTransactions = fetchAll(
        "SELECT * FROM transactions 
         WHERE user_id = ? 
         ORDER BY created_at DESC 
         LIMIT 5",
        [$currentUser['id']]
    );
    
    echo json_encode([
        'success' => true,
        'data' => [
            'balance' => floatval($user['balance']),
            'bonus_balance' => floatval($user['bonus_balance']),
            'total_balance' => floatval($user['balance']) + floatval($user['bonus_balance']),
            'pending' => [
                'deposits' => [
                    'count' => intval($pendingDeposits['count']),
                    'total' => floatval($pendingDeposits['total'])
                ],
                'withdrawals' => [
                    'count' => intval($pendingWithdrawals['count']),
                    'total' => floatval($pendingWithdrawals['total'])
                ]
            ],
            'recent_transactions' => $recentTransactions
        ]
    ]);
}

function handleDepositRequest($method) {
    global $currentUser;
    
    if ($method !== 'POST') {
        throw new Exception('Method not allowed');
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    $amount = floatval($input['amount'] ?? 0);
    $paymentMethod = $input['payment_method'] ?? '';
    $currency = $input['currency'] ?? 'USD';
    
    if ($amount <= 0) {
        throw new Exception('Invalid amount');
    }
    
    if (!$paymentMethod) {
        throw new Exception('Payment method is required');
    }
    
    // Get site settings
    $minDeposit = getSetting('min_deposit', 10.00);
    $maxDeposit = getSetting('max_deposit', 10000.00);
    
    if ($amount < $minDeposit) {
        throw new Exception("Minimum deposit amount is $" . number_format($minDeposit, 2));
    }
    
    if ($amount > $maxDeposit) {
        throw new Exception("Maximum deposit amount is $" . number_format($maxDeposit, 2));
    }
    
    // Check if deposits are enabled
    if (!getSetting('deposits_enabled', true)) {
        throw new Exception('Deposits are currently disabled');
    }
    
    // Create deposit transaction
    $transactionId = execute(
        "INSERT INTO transactions (user_id, type, amount, currency, payment_method, status, description, created_at) 
         VALUES (?, 'deposit', ?, ?, ?, 'pending', 'Deposit via API', NOW())",
        [$currentUser['id'], $amount, $currency, $paymentMethod]
    );
    
    // Generate payment URL/reference (mock implementation)
    $paymentReference = 'DEP_' . $transactionId . '_' . time();
    
    // Update transaction with payment reference
    execute(
        "UPDATE transactions SET reference = ? WHERE id = ?",
        [$paymentReference, $transactionId]
    );
    
    // In production, integrate with actual payment processors
    $paymentUrl = generatePaymentUrl($paymentMethod, $amount, $paymentReference);
    
    echo json_encode([
        'success' => true,
        'data' => [
            'transaction_id' => $transactionId,
            'payment_reference' => $paymentReference,
            'payment_url' => $paymentUrl,
            'amount' => $amount,
            'currency' => $currency,
            'payment_method' => $paymentMethod,
            'expires_at' => date('Y-m-d H:i:s', strtotime('+30 minutes'))
        ]
    ]);
}

function handleWithdrawRequest($method) {
    global $currentUser;
    
    if ($method !== 'POST') {
        throw new Exception('Method not allowed');
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Invalid JSON input');
    }
    
    $amount = floatval($input['amount'] ?? 0);
    $paymentMethod = $input['payment_method'] ?? '';
    $paymentDetails = $input['payment_details'] ?? [];
    
    if ($amount <= 0) {
        throw new Exception('Invalid amount');
    }
    
    if (!$paymentMethod) {
        throw new Exception('Payment method is required');
    }
    
    // Get current user balance
    $user = fetchRow("SELECT balance FROM users WHERE id = ?", [$currentUser['id']]);
    
    if ($user['balance'] < $amount) {
        throw new Exception('Insufficient balance');
    }
    
    // Get site settings
    $minWithdrawal = getSetting('min_withdrawal', 20.00);
    $maxWithdrawal = getSetting('max_withdrawal', 5000.00);
    $withdrawalFee = getSetting('withdrawal_fee', 0.00);
    
    if ($amount < $minWithdrawal) {
        throw new Exception("Minimum withdrawal amount is $" . number_format($minWithdrawal, 2));
    }
    
    if ($amount > $maxWithdrawal) {
        throw new Exception("Maximum withdrawal amount is $" . number_format($maxWithdrawal, 2));
    }
    
    // Check if withdrawals are enabled
    if (!getSetting('withdrawals_enabled', true)) {
        throw new Exception('Withdrawals are currently disabled');
    }
    
    // Check KYC requirement
    if (getSetting('kyc_required', false) && $currentUser['kyc_status'] !== 'verified') {
        throw new Exception('KYC verification is required for withdrawals');
    }
    
    $totalAmount = $amount + $withdrawalFee;
    
    if ($user['balance'] < $totalAmount) {
        throw new Exception('Insufficient balance including withdrawal fee');
    }
    
    // Create withdrawal transaction
    $transactionId = execute(
        "INSERT INTO transactions (user_id, type, amount, fee, payment_method, payment_details, status, description, created_at) 
         VALUES (?, 'withdrawal', ?, ?, ?, ?, 'pending', 'Withdrawal via API', NOW())",
        [$currentUser['id'], $amount, $withdrawalFee, $paymentMethod, json_encode($paymentDetails)]
    );
    
    // Deduct amount from user balance
    execute("UPDATE users SET balance = balance - ? WHERE id = ?", [$totalAmount, $currentUser['id']]);
    
    // Generate withdrawal reference
    $withdrawalReference = 'WTH_' . $transactionId . '_' . time();
    
    execute(
        "UPDATE transactions SET reference = ? WHERE id = ?",
        [$withdrawalReference, $transactionId]
    );
    
    echo json_encode([
        'success' => true,
        'data' => [
            'transaction_id' => $transactionId,
            'withdrawal_reference' => $withdrawalReference,
            'amount' => $amount,
            'fee' => $withdrawalFee,
            'total_deducted' => $totalAmount,
            'payment_method' => $paymentMethod,
            'status' => 'pending',
            'estimated_processing_time' => getSetting('withdrawal_processing_time', 24) . ' hours'
        ]
    ]);
}

function handleTransactionsRequest($method) {
    global $currentUser;
    
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    $page = intval($_GET['page'] ?? 1);
    $limit = intval($_GET['limit'] ?? 20);
    $type = $_GET['type'] ?? 'all';
    $status = $_GET['status'] ?? 'all';
    
    $offset = ($page - 1) * $limit;
    
    // Build query conditions
    $conditions = ["user_id = ?"];
    $params = [$currentUser['id']];
    
    if ($type !== 'all') {
        $conditions[] = "type = ?";
        $params[] = $type;
    }
    
    if ($status !== 'all') {
        $conditions[] = "status = ?";
        $params[] = $status;
    }
    
    $whereClause = implode(' AND ', $conditions);
    
    // Get total count
    $totalCount = fetchRow(
        "SELECT COUNT(*) as count FROM transactions WHERE $whereClause",
        $params
    )['count'];
    
    // Get transactions
    $transactions = fetchAll(
        "SELECT * FROM transactions 
         WHERE $whereClause 
         ORDER BY created_at DESC 
         LIMIT $limit OFFSET $offset",
        $params
    );
    
    echo json_encode([
        'success' => true,
        'data' => [
            'transactions' => $transactions,
            'pagination' => [
                'current_page' => $page,
                'total_pages' => ceil($totalCount / $limit),
                'total_count' => $totalCount,
                'per_page' => $limit
            ]
        ]
    ]);
}

function handlePaymentMethodsRequest($method) {
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    $type = $_GET['type'] ?? 'all'; // deposit, withdrawal, all
    
    // Mock payment methods - in production, this would be configurable
    $paymentMethods = [
        'deposit' => [
            [
                'id' => 'credit_card',
                'name' => 'Credit/Debit Card',
                'icon' => 'fas fa-credit-card',
                'min_amount' => 10.00,
                'max_amount' => 5000.00,
                'fee' => 0.00,
                'processing_time' => 'Instant',
                'currencies' => ['USD', 'EUR', 'GBP']
            ],
            [
                'id' => 'bank_transfer',
                'name' => 'Bank Transfer',
                'icon' => 'fas fa-university',
                'min_amount' => 50.00,
                'max_amount' => 10000.00,
                'fee' => 0.00,
                'processing_time' => '1-3 business days',
                'currencies' => ['USD', 'EUR']
            ],
            [
                'id' => 'crypto',
                'name' => 'Cryptocurrency',
                'icon' => 'fab fa-bitcoin',
                'min_amount' => 20.00,
                'max_amount' => 50000.00,
                'fee' => 0.00,
                'processing_time' => '10-60 minutes',
                'currencies' => ['BTC', 'ETH', 'USDT']
            ]
        ],
        'withdrawal' => [
            [
                'id' => 'bank_transfer',
                'name' => 'Bank Transfer',
                'icon' => 'fas fa-university',
                'min_amount' => 20.00,
                'max_amount' => 5000.00,
                'fee' => 5.00,
                'processing_time' => '1-3 business days',
                'currencies' => ['USD', 'EUR']
            ],
            [
                'id' => 'crypto',
                'name' => 'Cryptocurrency',
                'icon' => 'fab fa-bitcoin',
                'min_amount' => 20.00,
                'max_amount' => 10000.00,
                'fee' => 0.00,
                'processing_time' => '10-60 minutes',
                'currencies' => ['BTC', 'ETH', 'USDT']
            ]
        ]
    ];
    
    $result = [];
    if ($type === 'all') {
        $result = $paymentMethods;
    } else {
        $result = $paymentMethods[$type] ?? [];
    }
    
    echo json_encode([
        'success' => true,
        'data' => $result
    ]);
}

function handleLimitsRequest($method) {
    global $currentUser;
    
    if ($method !== 'GET') {
        throw new Exception('Method not allowed');
    }
    
    // Get user's current limits and usage
    $today = date('Y-m-d');
    $thisMonth = date('Y-m');
    
    $dailyDeposits = fetchRow(
        "SELECT COALESCE(SUM(amount), 0) as total 
         FROM transactions 
         WHERE user_id = ? AND type = 'deposit' AND status = 'completed' AND DATE(created_at) = ?",
        [$currentUser['id'], $today]
    )['total'];
    
    $monthlyDeposits = fetchRow(
        "SELECT COALESCE(SUM(amount), 0) as total 
         FROM transactions 
         WHERE user_id = ? AND type = 'deposit' AND status = 'completed' AND DATE_FORMAT(created_at, '%Y-%m') = ?",
        [$currentUser['id'], $thisMonth]
    )['total'];
    
    $dailyWithdrawals = fetchRow(
        "SELECT COALESCE(SUM(amount), 0) as total 
         FROM transactions 
         WHERE user_id = ? AND type = 'withdrawal' AND status IN ('completed', 'pending') AND DATE(created_at) = ?",
        [$currentUser['id'], $today]
    )['total'];
    
    $monthlyWithdrawals = fetchRow(
        "SELECT COALESCE(SUM(amount), 0) as total 
         FROM transactions 
         WHERE user_id = ? AND type = 'withdrawal' AND status IN ('completed', 'pending') AND DATE_FORMAT(created_at, '%Y-%m') = ?",
        [$currentUser['id'], $thisMonth]
    )['total'];
    
    // Default limits (would be configurable per user level)
    $limits = [
        'deposit' => [
            'min_amount' => floatval(getSetting('min_deposit', 10.00)),
            'max_amount' => floatval(getSetting('max_deposit', 10000.00)),
            'daily_limit' => 5000.00,
            'monthly_limit' => 50000.00,
            'daily_used' => floatval($dailyDeposits),
            'monthly_used' => floatval($monthlyDeposits)
        ],
        'withdrawal' => [
            'min_amount' => floatval(getSetting('min_withdrawal', 20.00)),
            'max_amount' => floatval(getSetting('max_withdrawal', 5000.00)),
            'daily_limit' => 2000.00,
            'monthly_limit' => 20000.00,
            'daily_used' => floatval($dailyWithdrawals),
            'monthly_used' => floatval($monthlyWithdrawals)
        ]
    ];
    
    // Calculate remaining limits
    $limits['deposit']['daily_remaining'] = max(0, $limits['deposit']['daily_limit'] - $limits['deposit']['daily_used']);
    $limits['deposit']['monthly_remaining'] = max(0, $limits['deposit']['monthly_limit'] - $limits['deposit']['monthly_used']);
    
    $limits['withdrawal']['daily_remaining'] = max(0, $limits['withdrawal']['daily_limit'] - $limits['withdrawal']['daily_used']);
    $limits['withdrawal']['monthly_remaining'] = max(0, $limits['withdrawal']['monthly_limit'] - $limits['withdrawal']['monthly_used']);
    
    echo json_encode([
        'success' => true,
        'data' => $limits
    ]);
}

function generatePaymentUrl($paymentMethod, $amount, $reference) {
    // Mock payment URL generation
    // In production, integrate with actual payment processors
    
    switch ($paymentMethod) {
        case 'credit_card':
            return "https://payment.crashify.com/card?ref=$reference&amount=$amount";
        case 'bank_transfer':
            return "https://payment.crashify.com/bank?ref=$reference&amount=$amount";
        case 'crypto':
            return "https://payment.crashify.com/crypto?ref=$reference&amount=$amount";
        default:
            return "https://payment.crashify.com/generic?ref=$reference&amount=$amount";
    }
}

function getSetting($key, $default = null) {
    $setting = fetchRow("SELECT setting_value FROM site_settings WHERE setting_key = ?", [$key]);
    return $setting ? $setting['setting_value'] : $default;
}
?>

PHP
); ?>

<?php _merge_exec('languages/ar.php', <<<'PHP'
<?php
// languages/ar.php - Arabic Language File
// فایل زبان عربی

return [
    // General
    'site_name' => 'Crashify',
    'welcome' => 'مرحباً',
    'home' => 'الرئيسية',
    'about' => 'حول',
    'contact' => 'اتصل بنا',
    'login' => 'تسجيل الدخول',
    'register' => 'التسجيل',
    'logout' => 'تسجيل الخروج',
    'dashboard' => 'لوحة التحكم',
    'profile' => 'الملف الشخصي',
    'settings' => 'الإعدادات',
    'help' => 'المساعدة',
    'support' => 'الدعم',
    'language' => 'اللغة',
    'currency' => 'العملة',
    'search' => 'البحث',
    'loading' => 'جاري التحميل...',
    'error' => 'خطأ',
    'success' => 'نجح',
    'warning' => 'تحذير',
    'info' => 'معلومات',
    'close' => 'إغلاق',
    'save' => 'حفظ',
    'cancel' => 'إلغاء',
    'delete' => 'حذف',
    'edit' => 'تعديل',
    'view' => 'عرض',
    'back' => 'العودة',
    'next' => 'التالي',
    'previous' => 'السابق',
    'submit' => 'إرسال',
    'confirm' => 'تأكيد',
    'yes' => 'نعم',
    'no' => 'لا',
    'ok' => 'موافق',
    'continue' => 'متابعة',
    'finish' => 'إنهاء',
    'start' => 'بدء',
    'stop' => 'توقف',
    'pause' => 'إيقاف مؤقت',
    'resume' => 'استئناف',
    'reset' => 'إعادة تعيين',
    'refresh' => 'تحديث',
    'update' => 'تحديث',
    'upgrade' => 'ترقية',
    'download' => 'تحميل',
    'upload' => 'رفع',
    'share' => 'مشاركة',
    'copy' => 'نسخ',
    'print' => 'طباعة',
    'export' => 'تصدير',
    'import' => 'استيراد',
    
    // Navigation
    'nav_home' => 'الرئيسية',
    'nav_casino' => 'الكازينو',
    'nav_sports' => 'الرياضة',
    'nav_live' => 'مباشر',
    'nav_promotions' => 'العروض',
    'nav_wallet' => 'المحفظة',
    'nav_history' => 'التاريخ',
    'nav_support' => 'الدعم',
    
    // Authentication
    'auth_login_title' => 'تسجيل الدخول إلى حسابك',
    'auth_register_title' => 'إنشاء حساب جديد',
    'auth_email' => 'البريد الإلكتروني',
    'auth_password' => 'كلمة المرور',
    'auth_confirm_password' => 'تأكيد كلمة المرور',
    'auth_remember_me' => 'تذكرني',
    'auth_forgot_password' => 'نسيت كلمة المرور؟',
    'auth_no_account' => 'ليس لديك حساب؟',
    'auth_have_account' => 'لديك حساب بالفعل؟',
    'auth_create_account' => 'إنشاء حساب',
    'auth_login_now' => 'تسجيل الدخول الآن',
    'auth_first_name' => 'الاسم الأول',
    'auth_last_name' => 'اسم العائلة',
    'auth_phone' => 'رقم الهاتف',
    'auth_birth_date' => 'تاريخ الميلاد',
    'auth_country' => 'البلد',
    'auth_city' => 'المدينة',
    'auth_address' => 'العنوان',
    'auth_agree_terms' => 'أوافق على الشروط والأحكام',
    'auth_agree_privacy' => 'أوافق على سياسة الخصوصية',
    'auth_login_success' => 'تم تسجيل الدخول بنجاح',
    'auth_register_success' => 'تم إنشاء الحساب بنجاح',
    'auth_logout_success' => 'تم تسجيل الخروج بنجاح',
    'auth_invalid_credentials' => 'بيانات الاعتماد غير صحيحة',
    'auth_email_exists' => 'البريد الإلكتروني مستخدم بالفعل',
    'auth_weak_password' => 'كلمة المرور ضعيفة',
    'auth_password_mismatch' => 'كلمات المرور غير متطابقة',
    
    // Dashboard
    'dashboard_welcome' => 'مرحباً بك، {name}',
    'dashboard_balance' => 'الرصيد',
    'dashboard_total_bets' => 'إجمالي الرهانات',
    'dashboard_total_wins' => 'إجمالي المكاسب',
    'dashboard_win_rate' => 'معدل الفوز',
    'dashboard_recent_games' => 'الألعاب الأخيرة',
    'dashboard_quick_deposit' => 'إيداع سريع',
    'dashboard_quick_withdraw' => 'سحب سريع',
    'dashboard_notifications' => 'الإشعارات',
    'dashboard_no_notifications' => 'لا توجد إشعارات جديدة',
    'dashboard_view_all' => 'عرض الكل',
    
    // Games
    'games_crash' => 'كراش',
    'games_slots' => 'ماكينات القمار',
    'games_blackjack' => 'بلاك جاك',
    'games_roulette' => 'الروليت',
    'games_baccarat' => 'باكارات',
    'games_poker' => 'البوكر',
    'games_dice' => 'النرد',
    'games_mines' => 'الألغام',
    'games_plinko' => 'بلينكو',
    'games_wheel' => 'العجلة',
    'games_keno' => 'كينو',
    'games_scratch' => 'بطاقات الخدش',
    'games_play_now' => 'العب الآن',
    'games_demo_mode' => 'وضع التجريب',
    'games_real_mode' => 'وضع حقيقي',
    'games_min_bet' => 'أقل رهان',
    'games_max_bet' => 'أكبر رهان',
    'games_max_win' => 'أكبر ربح',
    'games_rtp' => 'معدل العائد للاعب',
    'games_volatility' => 'التقلب',
    'games_provider' => 'المزود',
    
    // Betting
    'bet_amount' => 'مبلغ الرهان',
    'bet_place' => 'وضع الرهان',
    'bet_cancel' => 'إلغاء الرهان',
    'bet_cashout' => 'سحب الأرباح',
    'bet_auto' => 'رهان تلقائي',
    'bet_manual' => 'رهان يدوي',
    'bet_multiplier' => 'المضاعف',
    'bet_profit' => 'الربح',
    'bet_loss' => 'الخسارة',
    'bet_win' => 'الفوز',
    'bet_pending' => 'في الانتظار',
    'bet_settled' => 'مسوى',
    'bet_void' => 'ملغي',
    'bet_history' => 'تاريخ الرهانات',
    'bet_statistics' => 'إحصائيات الرهان',
    'bet_limits' => 'حدود الرهان',
    'bet_responsible' => 'الرهان المسؤول',
    
    // Wallet
    'wallet_balance' => 'رصيد المحفظة',
    'wallet_deposit' => 'إيداع',
    'wallet_withdraw' => 'سحب',
    'wallet_transfer' => 'تحويل',
    'wallet_history' => 'تاريخ المحفظة',
    'wallet_pending' => 'في الانتظار',
    'wallet_completed' => 'مكتمل',
    'wallet_failed' => 'فشل',
    'wallet_cancelled' => 'ملغي',
    'wallet_min_deposit' => 'أقل إيداع',
    'wallet_max_deposit' => 'أكبر إيداع',
    'wallet_min_withdraw' => 'أقل سحب',
    'wallet_max_withdraw' => 'أكبر سحب',
    'wallet_fee' => 'الرسوم',
    'wallet_processing_time' => 'وقت المعالجة',
    'wallet_payment_method' => 'طريقة الدفع',
    'wallet_card' => 'بطاقة',
    'wallet_bank' => 'بنك',
    'wallet_crypto' => 'عملة رقمية',
    'wallet_ewallet' => 'محفظة إلكترونية',
    
    // Sports Betting
    'sports_football' => 'كرة القدم',
    'sports_basketball' => 'كرة السلة',
    'sports_tennis' => 'التنس',
    'sports_baseball' => 'البيسبول',
    'sports_hockey' => 'الهوكي',
    'sports_soccer' => 'كرة القدم الأمريكية',
    'sports_boxing' => 'الملاكمة',
    'sports_mma' => 'فنون القتال المختلطة',
    'sports_cricket' => 'الكريكت',
    'sports_rugby' => 'الرجبي',
    'sports_golf' => 'الجولف',
    'sports_racing' => 'السباق',
    'sports_esports' => 'الرياضات الإلكترونية',
    'sports_live_betting' => 'الرهان المباشر',
    'sports_pre_match' => 'ما قبل المباراة',
    'sports_odds' => 'الاحتمالات',
    'sports_handicap' => 'الإعاقة',
    'sports_over_under' => 'أكثر/أقل',
    'sports_both_teams_score' => 'كلا الفريقين يسجل',
    'sports_correct_score' => 'النتيجة الصحيحة',
    'sports_first_goal' => 'أول هدف',
    'sports_match_winner' => 'الفائز بالمباراة',
    'sports_tournament_winner' => 'الفائز بالبطولة',
    
    // Promotions
    'promo_welcome_bonus' => 'مكافأة الترحيب',
    'promo_deposit_bonus' => 'مكافأة الإيداع',
    'promo_reload_bonus' => 'مكافأة إعادة التحميل',
    'promo_cashback' => 'استرداد نقدي',
    'promo_free_spins' => 'دورات مجانية',
    'promo_free_bet' => 'رهان مجاني',
    'promo_tournament' => 'بطولة',
    'promo_loyalty' => 'برنامج الولاء',
    'promo_vip' => 'برنامج VIP',
    'promo_refer_friend' => 'أحل صديق',
    'promo_code' => 'رمز الترويج',
    'promo_terms' => 'شروط العرض',
    'promo_wagering' => 'متطلبات الرهان',
    'promo_expiry' => 'تاريخ الانتهاء',
    'promo_claim' => 'المطالبة',
    'promo_claimed' => 'تم المطالبة',
    'promo_expired' => 'منتهي الصلاحية',
    'promo_active' => 'نشط',
    'promo_completed' => 'مكتمل',
    
    // Profile
    'profile_personal_info' => 'المعلومات الشخصية',
    'profile_account_settings' => 'إعدادات الحساب',
    'profile_security' => 'الأمان',
    'profile_preferences' => 'التفضيلات',
    'profile_verification' => 'التحقق',
    'profile_documents' => 'الوثائق',
    'profile_limits' => 'الحدود',
    'profile_self_exclusion' => 'الاستبعاد الذاتي',
    'profile_responsible_gaming' => 'اللعب المسؤول',
    'profile_notifications' => 'الإشعارات',
    'profile_privacy' => 'الخصوصية',
    'profile_change_password' => 'تغيير كلمة المرور',
    'profile_two_factor' => 'المصادقة الثنائية',
    'profile_login_history' => 'تاريخ تسجيل الدخول',
    'profile_device_management' => 'إدارة الأجهزة',
    
    // Support
    'support_contact' => 'اتصل بنا',
    'support_live_chat' => 'الدردشة المباشرة',
    'support_email' => 'البريد الإلكتروني',
    'support_phone' => 'الهاتف',
    'support_faq' => 'الأسئلة الشائعة',
    'support_help_center' => 'مركز المساعدة',
    'support_ticket' => 'تذكرة الدعم',
    'support_create_ticket' => 'إنشاء تذكرة',
    'support_ticket_status' => 'حالة التذكرة',
    'support_priority' => 'الأولوية',
    'support_category' => 'الفئة',
    'support_subject' => 'الموضوع',
    'support_message' => 'الرسالة',
    'support_attachment' => 'المرفق',
    'support_response' => 'الرد',
    'support_resolved' => 'محلول',
    'support_pending' => 'في الانتظار',
    'support_closed' => 'مغلق',
    
    // Notifications
    'notif_new_message' => 'رسالة جديدة',
    'notif_deposit_success' => 'تم الإيداع بنجاح',
    'notif_withdraw_success' => 'تم السحب بنجاح',
    'notif_bet_won' => 'فزت بالرهان!',
    'notif_bet_lost' => 'خسرت الرهان',
    'notif_bonus_received' => 'تم استلام المكافأة',
    'notif_promotion_available' => 'عرض ترويجي متاح',
    'notif_account_verified' => 'تم التحقق من الحساب',
    'notif_security_alert' => 'تنبيه أمني',
    'notif_maintenance' => 'صيانة النظام',
    'notif_mark_read' => 'تحديد كمقروء',
    'notif_mark_all_read' => 'تحديد الكل كمقروء',
    'notif_delete' => 'حذف الإشعار',
    'notif_settings' => 'إعدادات الإشعارات',
    
    // Errors
    'error_404' => 'الصفحة غير موجودة',
    'error_500' => 'خطأ في الخادم',
    'error_403' => 'غير مسموح بالوصول',
    'error_401' => 'غير مصرح',
    'error_400' => 'طلب خاطئ',
    'error_network' => 'خطأ في الشبكة',
    'error_timeout' => 'انتهت مهلة الطلب',
    'error_invalid_input' => 'مدخل غير صحيح',
    'error_required_field' => 'هذا الحقل مطلوب',
    'error_invalid_email' => 'بريد إلكتروني غير صحيح',
    'error_invalid_phone' => 'رقم هاتف غير صحيح',
    'error_min_length' => 'الحد الأدنى للطول {min} أحرف',
    'error_max_length' => 'الحد الأقصى للطول {max} حرف',
    'error_min_value' => 'القيمة الدنيا {min}',
    'error_max_value' => 'القيمة العليا {max}',
    'error_insufficient_balance' => 'رصيد غير كافي',
    'error_bet_limit_exceeded' => 'تم تجاوز حد الرهان',
    'error_game_unavailable' => 'اللعبة غير متاحة',
    'error_maintenance' => 'النظام تحت الصيانة',
    
    // Success Messages
    'success_saved' => 'تم الحفظ بنجاح',
    'success_updated' => 'تم التحديث بنجاح',
    'success_deleted' => 'تم الحذف بنجاح',
    'success_sent' => 'تم الإرسال بنجاح',
    'success_verified' => 'تم التحقق بنجاح',
    'success_activated' => 'تم التفعيل بنجاح',
    'success_deactivated' => 'تم إلغاء التفعيل بنجاح',
    'success_password_changed' => 'تم تغيير كلمة المرور بنجاح',
    'success_email_sent' => 'تم إرسال البريد الإلكتروني',
    'success_settings_saved' => 'تم حفظ الإعدادات',
    
    // Time and Date
    'time_now' => 'الآن',
    'time_minute_ago' => 'منذ دقيقة',
    'time_minutes_ago' => 'منذ {count} دقائق',
    'time_hour_ago' => 'منذ ساعة',
    'time_hours_ago' => 'منذ {count} ساعات',
    'time_day_ago' => 'منذ يوم',
    'time_days_ago' => 'منذ {count} أيام',
    'time_week_ago' => 'منذ أسبوع',
    'time_weeks_ago' => 'منذ {count} أسابيع',
    'time_month_ago' => 'منذ شهر',
    'time_months_ago' => 'منذ {count} أشهر',
    'time_year_ago' => 'منذ سنة',
    'time_years_ago' => 'منذ {count} سنوات',
    
    // Days of Week
    'day_monday' => 'الاثنين',
    'day_tuesday' => 'الثلاثاء',
    'day_wednesday' => 'الأربعاء',
    'day_thursday' => 'الخميس',
    'day_friday' => 'الجمعة',
    'day_saturday' => 'السبت',
    'day_sunday' => 'الأحد',
    
    // Months
    'month_january' => 'يناير',
    'month_february' => 'فبراير',
    'month_march' => 'مارس',
    'month_april' => 'أبريل',
    'month_may' => 'مايو',
    'month_june' => 'يونيو',
    'month_july' => 'يوليو',
    'month_august' => 'أغسطس',
    'month_september' => 'سبتمبر',
    'month_october' => 'أكتوبر',
    'month_november' => 'نوفمبر',
    'month_december' => 'ديسمبر',
    
    // Footer
    'footer_about_us' => 'من نحن',
    'footer_terms' => 'الشروط والأحكام',
    'footer_privacy' => 'سياسة الخصوصية',
    'footer_responsible_gaming' => 'اللعب المسؤول',
    'footer_contact' => 'اتصل بنا',
    'footer_help' => 'المساعدة',
    'footer_sitemap' => 'خريطة الموقع',
    'footer_copyright' => '© 2024 Crashify. جميع الحقوق محفوظة.',
    'footer_license' => 'مرخص ومنظم',
    'footer_18_plus' => '+18 فقط',
    'footer_gamble_responsibly' => 'العب بمسؤولية',
    
    // Legal
    'legal_terms_title' => 'الشروط والأحكام',
    'legal_privacy_title' => 'سياسة الخصوصية',
    'legal_responsible_title' => 'اللعب المسؤول',
    'legal_aml_title' => 'مكافحة غسيل الأموال',
    'legal_kyc_title' => 'اعرف عميلك',
    'legal_complaints_title' => 'إجراءات الشكاوى',
    'legal_licensing_title' => 'معلومات الترخيص',
    'legal_fairness_title' => 'العدالة والشفافية',
    
    // Admin
    'admin_dashboard' => 'لوحة الإدارة',
    'admin_users' => 'المستخدمون',
    'admin_transactions' => 'المعاملات',
    'admin_games' => 'الألعاب',
    'admin_reports' => 'التقارير',
    'admin_settings' => 'الإعدادات',
    'admin_logs' => 'السجلات',
    'admin_security' => 'الأمان',
    'admin_maintenance' => 'الصيانة',
    'admin_backup' => 'النسخ الاحتياطي',
];
?>
PHP
); ?>

<?php _merge_exec('languages/de.php', <<<'PHP'
<?php
// languages/de.php - German Language File
// فایل زبان آلمانی

return [
    // General
    'site_name' => 'Crashify',
    'welcome' => 'Willkommen',
    'home' => 'Startseite',
    'about' => 'Über uns',
    'contact' => 'Kontakt',
    'login' => 'Anmelden',
    'register' => 'Registrieren',
    'logout' => 'Abmelden',
    'dashboard' => 'Dashboard',
    'profile' => 'Profil',
    'settings' => 'Einstellungen',
    'help' => 'Hilfe',
    'support' => 'Support',
    'language' => 'Sprache',
    'currency' => 'Währung',
    'search' => 'Suchen',
    'loading' => 'Lädt...',
    'error' => 'Fehler',
    'success' => 'Erfolgreich',
    'warning' => 'Warnung',
    'info' => 'Information',
    'close' => 'Schließen',
    'save' => 'Speichern',
    'cancel' => 'Abbrechen',
    'delete' => 'Löschen',
    'edit' => 'Bearbeiten',
    'view' => 'Ansehen',
    'back' => 'Zurück',
    'next' => 'Weiter',
    'previous' => 'Vorherige',
    'submit' => 'Senden',
    'confirm' => 'Bestätigen',
    'yes' => 'Ja',
    'no' => 'Nein',
    'ok' => 'OK',
    'continue' => 'Fortfahren',
    'finish' => 'Beenden',
    'start' => 'Starten',
    'stop' => 'Stoppen',
    'pause' => 'Pausieren',
    'resume' => 'Fortsetzen',
    'reset' => 'Zurücksetzen',
    'refresh' => 'Aktualisieren',
    'update' => 'Aktualisieren',
    'upgrade' => 'Upgrade',
    'download' => 'Herunterladen',
    'upload' => 'Hochladen',
    'share' => 'Teilen',
    'copy' => 'Kopieren',
    'print' => 'Drucken',
    'export' => 'Exportieren',
    'import' => 'Importieren',
    
    // Navigation
    'nav_home' => 'Startseite',
    'nav_casino' => 'Casino',
    'nav_sports' => 'Sport',
    'nav_live' => 'Live',
    'nav_promotions' => 'Aktionen',
    'nav_wallet' => 'Geldbörse',
    'nav_history' => 'Verlauf',
    'nav_support' => 'Support',
    
    // Authentication
    'auth_login_title' => 'In Ihr Konto einloggen',
    'auth_register_title' => 'Neues Konto erstellen',
    'auth_email' => 'E-Mail',
    'auth_password' => 'Passwort',
    'auth_confirm_password' => 'Passwort bestätigen',
    'auth_remember_me' => 'Angemeldet bleiben',
    'auth_forgot_password' => 'Passwort vergessen?',
    'auth_no_account' => 'Kein Konto?',
    'auth_have_account' => 'Bereits ein Konto?',
    'auth_create_account' => 'Konto erstellen',
    'auth_login_now' => 'Jetzt anmelden',
    'auth_first_name' => 'Vorname',
    'auth_last_name' => 'Nachname',
    'auth_phone' => 'Telefonnummer',
    'auth_birth_date' => 'Geburtsdatum',
    'auth_country' => 'Land',
    'auth_city' => 'Stadt',
    'auth_address' => 'Adresse',
    'auth_agree_terms' => 'Ich stimme den AGB zu',
    'auth_agree_privacy' => 'Ich stimme der Datenschutzerklärung zu',
    'auth_login_success' => 'Erfolgreich angemeldet',
    'auth_register_success' => 'Konto erfolgreich erstellt',
    'auth_logout_success' => 'Erfolgreich abgemeldet',
    'auth_invalid_credentials' => 'Ungültige Anmeldedaten',
    'auth_email_exists' => 'E-Mail bereits verwendet',
    'auth_weak_password' => 'Schwaches Passwort',
    'auth_password_mismatch' => 'Passwörter stimmen nicht überein',
    
    // Dashboard
    'dashboard_welcome' => 'Willkommen, {name}',
    'dashboard_balance' => 'Guthaben',
    'dashboard_total_bets' => 'Gesamte Wetten',
    'dashboard_total_wins' => 'Gesamte Gewinne',
    'dashboard_win_rate' => 'Gewinnrate',
    'dashboard_recent_games' => 'Letzte Spiele',
    'dashboard_quick_deposit' => 'Schnelle Einzahlung',
    'dashboard_quick_withdraw' => 'Schnelle Auszahlung',
    'dashboard_notifications' => 'Benachrichtigungen',
    'dashboard_no_notifications' => 'Keine neuen Benachrichtigungen',
    'dashboard_view_all' => 'Alle anzeigen',
    
    // Games
    'games_crash' => 'Crash',
    'games_slots' => 'Spielautomaten',
    'games_blackjack' => 'Blackjack',
    'games_roulette' => 'Roulette',
    'games_baccarat' => 'Baccarat',
    'games_poker' => 'Poker',
    'games_dice' => 'Würfel',
    'games_mines' => 'Minen',
    'games_plinko' => 'Plinko',
    'games_wheel' => 'Rad',
    'games_keno' => 'Keno',
    'games_scratch' => 'Rubbellose',
    'games_play_now' => 'Jetzt spielen',
    'games_demo_mode' => 'Demo-Modus',
    'games_real_mode' => 'Echtgeld-Modus',
    'games_min_bet' => 'Min. Einsatz',
    'games_max_bet' => 'Max. Einsatz',
    'games_max_win' => 'Max. Gewinn',
    'games_rtp' => 'Auszahlungsquote',
    'games_volatility' => 'Volatilität',
    'games_provider' => 'Anbieter',
    
    // Betting
    'bet_amount' => 'Einsatzbetrag',
    'bet_place' => 'Wette platzieren',
    'bet_cancel' => 'Wette stornieren',
    'bet_cashout' => 'Auszahlen',
    'bet_auto' => 'Auto-Wette',
    'bet_manual' => 'Manuelle Wette',
    'bet_multiplier' => 'Multiplikator',
    'bet_profit' => 'Gewinn',
    'bet_loss' => 'Verlust',
    'bet_win' => 'Gewinn',
    'bet_pending' => 'Ausstehend',
    'bet_settled' => 'Abgerechnet',
    'bet_void' => 'Ungültig',
    'bet_history' => 'Wetthistorie',
    'bet_statistics' => 'Wettstatistiken',
    'bet_limits' => 'Wettlimits',
    'bet_responsible' => 'Verantwortungsvolles Spielen',
    
    // Wallet
    'wallet_balance' => 'Guthaben',
    'wallet_deposit' => 'Einzahlung',
    'wallet_withdraw' => 'Auszahlung',
    'wallet_transfer' => 'Überweisung',
    'wallet_history' => 'Transaktionshistorie',
    'wallet_pending' => 'Ausstehend',
    'wallet_completed' => 'Abgeschlossen',
    'wallet_failed' => 'Fehlgeschlagen',
    'wallet_cancelled' => 'Storniert',
    'wallet_min_deposit' => 'Min. Einzahlung',
    'wallet_max_deposit' => 'Max. Einzahlung',
    'wallet_min_withdraw' => 'Min. Auszahlung',
    'wallet_max_withdraw' => 'Max. Auszahlung',
    'wallet_fee' => 'Gebühr',
    'wallet_processing_time' => 'Bearbeitungszeit',
    'wallet_payment_method' => 'Zahlungsmethode',
    'wallet_card' => 'Karte',
    'wallet_bank' => 'Bank',
    'wallet_crypto' => 'Kryptowährung',
    'wallet_ewallet' => 'E-Wallet',
    
    // Sports Betting
    'sports_football' => 'Fußball',
    'sports_basketball' => 'Basketball',
    'sports_tennis' => 'Tennis',
    'sports_baseball' => 'Baseball',
    'sports_hockey' => 'Hockey',
    'sports_soccer' => 'American Football',
    'sports_boxing' => 'Boxen',
    'sports_mma' => 'Mixed Martial Arts',
    'sports_cricket' => 'Cricket',
    'sports_rugby' => 'Rugby',
    'sports_golf' => 'Golf',
    'sports_racing' => 'Rennsport',
    'sports_esports' => 'E-Sport',
    'sports_live_betting' => 'Live-Wetten',
    'sports_pre_match' => 'Vor dem Spiel',
    'sports_odds' => 'Quoten',
    'sports_handicap' => 'Handicap',
    'sports_over_under' => 'Über/Unter',
    'sports_both_teams_score' => 'Beide Teams treffen',
    'sports_correct_score' => 'Korrektes Ergebnis',
    'sports_first_goal' => 'Erstes Tor',
    'sports_match_winner' => 'Spielsieger',
    'sports_tournament_winner' => 'Turniersieger',
    
    // Promotions
    'promo_welcome_bonus' => 'Willkommensbonus',
    'promo_deposit_bonus' => 'Einzahlungsbonus',
    'promo_reload_bonus' => 'Reload-Bonus',
    'promo_cashback' => 'Cashback',
    'promo_free_spins' => 'Freispiele',
    'promo_free_bet' => 'Gratiswette',
    'promo_tournament' => 'Turnier',
    'promo_loyalty' => 'Treueprogramm',
    'promo_vip' => 'VIP-Programm',
    'promo_refer_friend' => 'Freund werben',
    'promo_code' => 'Promo-Code',
    'promo_terms' => 'Aktionsbedingungen',
    'promo_wagering' => 'Umsatzbedingungen',
    'promo_expiry' => 'Ablaufdatum',
    'promo_claim' => 'Beanspruchen',
    'promo_claimed' => 'Beansprucht',
    'promo_expired' => 'Abgelaufen',
    'promo_active' => 'Aktiv',
    'promo_completed' => 'Abgeschlossen',
    
    // Profile
    'profile_personal_info' => 'Persönliche Informationen',
    'profile_account_settings' => 'Kontoeinstellungen',
    'profile_security' => 'Sicherheit',
    'profile_preferences' => 'Einstellungen',
    'profile_verification' => 'Verifizierung',
    'profile_documents' => 'Dokumente',
    'profile_limits' => 'Limits',
    'profile_self_exclusion' => 'Selbstausschluss',
    'profile_responsible_gaming' => 'Verantwortungsvolles Spielen',
    'profile_notifications' => 'Benachrichtigungen',
    'profile_privacy' => 'Datenschutz',
    'profile_change_password' => 'Passwort ändern',
    'profile_two_factor' => 'Zwei-Faktor-Authentifizierung',
    'profile_login_history' => 'Anmeldeverlauf',
    'profile_device_management' => 'Geräteverwaltung',
    
    // Support
    'support_contact' => 'Kontakt aufnehmen',
    'support_live_chat' => 'Live-Chat',
    'support_email' => 'E-Mail',
    'support_phone' => 'Telefon',
    'support_faq' => 'Häufig gestellte Fragen',
    'support_help_center' => 'Hilfezentrum',
    'support_ticket' => 'Support-Ticket',
    'support_create_ticket' => 'Ticket erstellen',
    'support_ticket_status' => 'Ticket-Status',
    'support_priority' => 'Priorität',
    'support_category' => 'Kategorie',
    'support_subject' => 'Betreff',
    'support_message' => 'Nachricht',
    'support_attachment' => 'Anhang',
    'support_response' => 'Antwort',
    'support_resolved' => 'Gelöst',
    'support_pending' => 'Ausstehend',
    'support_closed' => 'Geschlossen',
    
    // Notifications
    'notif_new_message' => 'Neue Nachricht',
    'notif_deposit_success' => 'Einzahlung erfolgreich',
    'notif_withdraw_success' => 'Auszahlung erfolgreich',
    'notif_bet_won' => 'Wette gewonnen!',
    'notif_bet_lost' => 'Wette verloren',
    'notif_bonus_received' => 'Bonus erhalten',
    'notif_promotion_available' => 'Aktion verfügbar',
    'notif_account_verified' => 'Konto verifiziert',
    'notif_security_alert' => 'Sicherheitswarnung',
    'notif_maintenance' => 'Systemwartung',
    'notif_mark_read' => 'Als gelesen markieren',
    'notif_mark_all_read' => 'Alle als gelesen markieren',
    'notif_delete' => 'Benachrichtigung löschen',
    'notif_settings' => 'Benachrichtigungseinstellungen',
    
    // Errors
    'error_404' => 'Seite nicht gefunden',
    'error_500' => 'Serverfehler',
    'error_403' => 'Zugriff verweigert',
    'error_401' => 'Nicht autorisiert',
    'error_400' => 'Ungültige Anfrage',
    'error_network' => 'Netzwerkfehler',
    'error_timeout' => 'Zeitüberschreitung',
    'error_invalid_input' => 'Ungültige Eingabe',
    'error_required_field' => 'Dieses Feld ist erforderlich',
    'error_invalid_email' => 'Ungültige E-Mail',
    'error_invalid_phone' => 'Ungültige Telefonnummer',
    'error_min_length' => 'Mindestlänge {min} Zeichen',
    'error_max_length' => 'Maximale Länge {max} Zeichen',
    'error_min_value' => 'Mindestwert {min}',
    'error_max_value' => 'Maximalwert {max}',
    'error_insufficient_balance' => 'Unzureichendes Guthaben',
    'error_bet_limit_exceeded' => 'Wettlimit überschritten',
    'error_game_unavailable' => 'Spiel nicht verfügbar',
    'error_maintenance' => 'System in Wartung',
    
    // Success Messages
    'success_saved' => 'Erfolgreich gespeichert',
    'success_updated' => 'Erfolgreich aktualisiert',
    'success_deleted' => 'Erfolgreich gelöscht',
    'success_sent' => 'Erfolgreich gesendet',
    'success_verified' => 'Erfolgreich verifiziert',
    'success_activated' => 'Erfolgreich aktiviert',
    'success_deactivated' => 'Erfolgreich deaktiviert',
    'success_password_changed' => 'Passwort erfolgreich geändert',
    'success_email_sent' => 'E-Mail gesendet',
    'success_settings_saved' => 'Einstellungen gespeichert',
    
    // Time and Date
    'time_now' => 'jetzt',
    'time_minute_ago' => 'vor 1 Minute',
    'time_minutes_ago' => 'vor {count} Minuten',
    'time_hour_ago' => 'vor 1 Stunde',
    'time_hours_ago' => 'vor {count} Stunden',
    'time_day_ago' => 'vor 1 Tag',
    'time_days_ago' => 'vor {count} Tagen',
    'time_week_ago' => 'vor 1 Woche',
    'time_weeks_ago' => 'vor {count} Wochen',
    'time_month_ago' => 'vor 1 Monat',
    'time_months_ago' => 'vor {count} Monaten',
    'time_year_ago' => 'vor 1 Jahr',
    'time_years_ago' => 'vor {count} Jahren',
    
    // Days of Week
    'day_monday' => 'Montag',
    'day_tuesday' => 'Dienstag',
    'day_wednesday' => 'Mittwoch',
    'day_thursday' => 'Donnerstag',
    'day_friday' => 'Freitag',
    'day_saturday' => 'Samstag',
    'day_sunday' => 'Sonntag',
    
    // Months
    'month_january' => 'Januar',
    'month_february' => 'Februar',
    'month_march' => 'März',
    'month_april' => 'April',
    'month_may' => 'Mai',
    'month_june' => 'Juni',
    'month_july' => 'Juli',
    'month_august' => 'August',
    'month_september' => 'September',
    'month_october' => 'Oktober',
    'month_november' => 'November',
    'month_december' => 'Dezember',
    
    // Footer
    'footer_about_us' => 'Über uns',
    'footer_terms' => 'AGB',
    'footer_privacy' => 'Datenschutz',
    'footer_responsible_gaming' => 'Verantwortungsvolles Spielen',
    'footer_contact' => 'Kontakt',
    'footer_help' => 'Hilfe',
    'footer_sitemap' => 'Sitemap',
    'footer_copyright' => '© 2024 Crashify. Alle Rechte vorbehalten.',
    'footer_license' => 'Lizenziert und reguliert',
    'footer_18_plus' => 'Nur 18+',
    'footer_gamble_responsibly' => 'Spielen Sie verantwortungsvoll',
    
    // Legal
    'legal_terms_title' => 'Allgemeine Geschäftsbedingungen',
    'legal_privacy_title' => 'Datenschutzerklärung',
    'legal_responsible_title' => 'Verantwortungsvolles Spielen',
    'legal_aml_title' => 'Geldwäschebekämpfung',
    'legal_kyc_title' => 'Kundenidentifizierung',
    'legal_complaints_title' => 'Beschwerdeverfahren',
    'legal_licensing_title' => 'Lizenzinformationen',
    'legal_fairness_title' => 'Fairness und Transparenz',
    
    // Admin
    'admin_dashboard' => 'Admin-Dashboard',
    'admin_users' => 'Benutzer',
    'admin_transactions' => 'Transaktionen',
    'admin_games' => 'Spiele',
    'admin_reports' => 'Berichte',
    'admin_settings' => 'Einstellungen',
    'admin_logs' => 'Protokolle',
    'admin_security' => 'Sicherheit',
    'admin_maintenance' => 'Wartung',
    'admin_backup' => 'Sicherung',
];
?>

PHP
); ?>

<?php _merge_exec('languages/en.php', <<<'PHP'
<?php
// languages/en.php - English Language File
// فایل زبان انگلیسی Crashify

return [
    // Common
    'common' => [
        'yes' => 'Yes',
        'no' => 'No',
        'ok' => 'OK',
        'cancel' => 'Cancel',
        'save' => 'Save',
        'edit' => 'Edit',
        'delete' => 'Delete',
        'close' => 'Close',
        'back' => 'Back',
        'next' => 'Next',
        'previous' => 'Previous',
        'continue' => 'Continue',
        'submit' => 'Submit',
        'loading' => 'Loading...',
        'search' => 'Search',
        'filter' => 'Filter',
        'sort' => 'Sort',
        'view_all' => 'View All',
        'show_more' => 'Show More',
        'show_less' => 'Show Less',
        'copy' => 'Copy',
        'copied' => 'Copied!',
        'share' => 'Share',
        'download' => 'Download',
        'upload' => 'Upload',
        'refresh' => 'Refresh',
        'clear' => 'Clear',
        'reset' => 'Reset',
        'confirm' => 'Confirm',
        'success' => 'Success',
        'error' => 'Error',
        'warning' => 'Warning',
        'info' => 'Information',
        'welcome' => 'Welcome',
        'goodbye' => 'Goodbye',
        'hello' => 'Hello',
        'thanks' => 'Thank you',
        'please_wait' => 'Please wait...',
        'coming_soon' => 'Coming Soon',
        'maintenance' => 'Under Maintenance',
        'not_found' => 'Not Found',
        'access_denied' => 'Access Denied',
        'session_expired' => 'Session Expired',
        'try_again' => 'Try Again',
        'contact_support' => 'Contact Support'
    ],

    // Navigation
    'nav' => [
        'home' => 'Home',
        'sportsbook' => 'Sportsbook',
        'live_betting' => 'Live Betting',
        'casino' => 'Casino',
        'live_casino' => 'Live Casino',
        'esports' => 'Esports',
        'virtual_sports' => 'Virtual Sports',
        'promotions' => 'Promotions',
        'vip' => 'VIP',
        'tournaments' => 'Tournaments',
        'support' => 'Support',
        'about' => 'About Us',
        'contact' => 'Contact',
        'blog' => 'Blog',
        'affiliate' => 'Affiliate Program'
    ],

    // Authentication
    'auth' => [
        'login' => 'Login',
        'register' => 'Sign Up',
        'logout' => 'Logout',
        'forgot_password' => 'Forgot Password?',
        'reset_password' => 'Reset Password',
        'change_password' => 'Change Password',
        'email' => 'Email Address',
        'username' => 'Username',
        'password' => 'Password',
        'confirm_password' => 'Confirm Password',
        'current_password' => 'Current Password',
        'new_password' => 'New Password',
        'remember_me' => 'Remember Me',
        'login_success' => 'Login successful! Welcome back.',
        'login_failed' => 'Invalid email/username or password.',
        'register_success' => 'Registration successful! Please verify your email.',
        'register_failed' => 'Registration failed. Please try again.',
        'logout_success' => 'You have been logged out successfully.',
        'password_reset_sent' => 'Password reset link sent to your email.',
        'password_changed' => 'Password changed successfully.',
        'email_verified' => 'Email verified successfully.',
        'verification_sent' => 'Verification email sent.',
        'account_locked' => 'Account temporarily locked due to multiple failed attempts.',
        'two_factor_required' => 'Two-factor authentication required.',
        'invalid_2fa_code' => 'Invalid verification code.',
        'first_name' => 'First Name',
        'last_name' => 'Last Name',
        'date_of_birth' => 'Date of Birth',
        'country' => 'Country',
        'phone' => 'Phone Number',
        'accept_terms' => 'I accept the Terms & Conditions',
        'accept_privacy' => 'I accept the Privacy Policy',
        'age_confirmation' => 'I confirm that I am 18 years or older',
        'already_have_account' => 'Already have an account?',
        'dont_have_account' => "Don't have an account?",
        'sign_in_here' => 'Sign in here',
        'sign_up_here' => 'Sign up here'
    ],

    // User Profile
    'user' => [
        'profile' => 'Profile',
        'account' => 'Account',
        'settings' => 'Settings',
        'security' => 'Security',
        'preferences' => 'Preferences',
        'notifications' => 'Notifications',
        'wallet' => 'Wallet',
        'balance' => 'Balance',
        'bonus_balance' => 'Bonus Balance',
        'level' => 'Level',
        'vip_status' => 'VIP Status',
        'loyalty_points' => 'Loyalty Points',
        'total_bets' => 'Total Bets',
        'total_wins' => 'Total Wins',
        'total_losses' => 'Total Losses',
        'win_rate' => 'Win Rate',
        'total_wagered' => 'Total Wagered',
        'total_winnings' => 'Total Winnings',
        'member_since' => 'Member Since',
        'last_login' => 'Last Login',
        'email_verified' => 'Email Verified',
        'phone_verified' => 'Phone Verified',
        'identity_verified' => 'Identity Verified',
        'two_factor_enabled' => 'Two-Factor Authentication',
        'avatar' => 'Profile Picture',
        'personal_info' => 'Personal Information',
        'contact_info' => 'Contact Information',
        'verification_status' => 'Verification Status',
        'account_limits' => 'Account Limits',
        'responsible_gaming' => 'Responsible Gaming'
    ],

    // Sports & Betting
    'sports' => [
        'football' => 'Football',
        'basketball' => 'Basketball',
        'tennis' => 'Tennis',
        'baseball' => 'Baseball',
        'hockey' => 'Hockey',
        'soccer' => 'Soccer',
        'american_football' => 'American Football',
        'volleyball' => 'Volleyball',
        'cricket' => 'Cricket',
        'rugby' => 'Rugby',
        'golf' => 'Golf',
        'boxing' => 'Boxing',
        'mma' => 'MMA',
        'motorsports' => 'Motorsports',
        'cycling' => 'Cycling',
        'swimming' => 'Swimming',
        'athletics' => 'Athletics',
        'winter_sports' => 'Winter Sports'
    ],

    'betting' => [
        'place_bet' => 'Place Bet',
        'bet_slip' => 'Bet Slip',
        'single_bet' => 'Single Bet',
        'accumulator' => 'Accumulator',
        'system_bet' => 'System Bet',
        'live_bet' => 'Live Bet',
        'cash_out' => 'Cash Out',
        'stake' => 'Stake',
        'odds' => 'Odds',
        'potential_payout' => 'Potential Payout',
        'actual_payout' => 'Actual Payout',
        'bet_placed' => 'Bet Placed',
        'bet_won' => 'Bet Won',
        'bet_lost' => 'Bet Lost',
        'bet_void' => 'Bet Void',
        'bet_cancelled' => 'Bet Cancelled',
        'bet_pending' => 'Bet Pending',
        'bet_history' => 'Bet History',
        'open_bets' => 'Open Bets',
        'settled_bets' => 'Settled Bets',
        'min_stake' => 'Minimum Stake',
        'max_stake' => 'Maximum Stake',
        'max_payout' => 'Maximum Payout',
        'insufficient_balance' => 'Insufficient Balance',
        'bet_limit_exceeded' => 'Bet Limit Exceeded',
        'market_suspended' => 'Market Suspended',
        'odds_changed' => 'Odds Changed',
        'accept_odds_change' => 'Accept Odds Change',
        'home' => 'Home',
        'away' => 'Away',
        'draw' => 'Draw',
        'over' => 'Over',
        'under' => 'Under',
        'yes' => 'Yes',
        'no' => 'No',
        'handicap' => 'Handicap',
        'total_goals' => 'Total Goals',
        'both_teams_score' => 'Both Teams to Score',
        'correct_score' => 'Correct Score',
        'first_goalscorer' => 'First Goalscorer',
        'match_result' => 'Match Result',
        'double_chance' => 'Double Chance'
    ],

    // Casino
    'casino' => [
        'slots' => 'Slots',
        'table_games' => 'Table Games',
        'live_casino' => 'Live Casino',
        'crash_games' => 'Crash Games',
        'jackpots' => 'Jackpots',
        'tournaments' => 'Tournaments',
        'blackjack' => 'Blackjack',
        'roulette' => 'Roulette',
        'baccarat' => 'Baccarat',
        'poker' => 'Poker',
        'dice' => 'Dice',
        'keno' => 'Keno',
        'scratch_cards' => 'Scratch Cards',
        'video_poker' => 'Video Poker',
        'play_now' => 'Play Now',
        'demo_play' => 'Demo Play',
        'real_play' => 'Real Play',
        'free_spins' => 'Free Spins',
        'bonus_round' => 'Bonus Round',
        'progressive_jackpot' => 'Progressive Jackpot',
        'rtp' => 'RTP',
        'volatility' => 'Volatility',
        'min_bet' => 'Min Bet',
        'max_bet' => 'Max Bet',
        'autoplay' => 'Autoplay',
        'spin' => 'Spin',
        'deal' => 'Deal',
        'hit' => 'Hit',
        'stand' => 'Stand',
        'double' => 'Double',
        'split' => 'Split',
        'insurance' => 'Insurance',
        'surrender' => 'Surrender'
    ],

    // Wallet & Transactions
    'wallet' => [
        'deposit' => 'Deposit',
        'withdraw' => 'Withdraw',
        'transaction_history' => 'Transaction History',
        'pending_transactions' => 'Pending Transactions',
        'completed_transactions' => 'Completed Transactions',
        'failed_transactions' => 'Failed Transactions',
        'amount' => 'Amount',
        'currency' => 'Currency',
        'payment_method' => 'Payment Method',
        'wallet_address' => 'Wallet Address',
        'transaction_id' => 'Transaction ID',
        'transaction_hash' => 'Transaction Hash',
        'network' => 'Network',
        'confirmations' => 'Confirmations',
        'fee' => 'Fee',
        'status' => 'Status',
        'date' => 'Date',
        'deposit_successful' => 'Deposit Successful',
        'withdrawal_successful' => 'Withdrawal Successful',
        'transaction_pending' => 'Transaction Pending',
        'transaction_failed' => 'Transaction Failed',
        'insufficient_funds' => 'Insufficient Funds',
        'minimum_deposit' => 'Minimum Deposit',
        'maximum_deposit' => 'Maximum Deposit',
        'minimum_withdrawal' => 'Minimum Withdrawal',
        'maximum_withdrawal' => 'Maximum Withdrawal',
        'daily_limit' => 'Daily Limit',
        'weekly_limit' => 'Weekly Limit',
        'monthly_limit' => 'Monthly Limit',
        'processing_time' => 'Processing Time',
        'instant' => 'Instant',
        'crypto_deposit_info' => 'Send your cryptocurrency to the address below',
        'crypto_withdrawal_info' => 'Enter your wallet address to receive funds',
        'qr_code' => 'QR Code',
        'copy_address' => 'Copy Address',
        'verify_address' => 'Verify Address',
        'network_fee' => 'Network Fee',
        'exchange_rate' => 'Exchange Rate'
    ],

    // Bonuses & Promotions
    'bonuses' => [
        'welcome_bonus' => 'Welcome Bonus',
        'deposit_bonus' => 'Deposit Bonus',
        'reload_bonus' => 'Reload Bonus',
        'no_deposit_bonus' => 'No Deposit Bonus',
        'free_bet' => 'Free Bet',
        'cashback' => 'Cashback',
        'loyalty_points' => 'Loyalty Points',
        'referral_program' => 'Referral Program',
        'vip_rewards' => 'VIP Rewards',
        'tournament_prize' => 'Tournament Prize',
        'bonus_code' => 'Bonus Code',
        'claim_bonus' => 'Claim Bonus',
        'bonus_claimed' => 'Bonus Claimed',
        'bonus_expired' => 'Bonus Expired',
        'bonus_terms' => 'Bonus Terms',
        'wagering_requirement' => 'Wagering Requirement',
        'min_deposit' => 'Minimum Deposit',
        'max_bonus' => 'Maximum Bonus',
        'valid_until' => 'Valid Until',
        'bonus_balance' => 'Bonus Balance',
        'wagered_amount' => 'Wagered Amount',
        'remaining_wagering' => 'Remaining Wagering',
        'bonus_progress' => 'Bonus Progress',
        'eligible_games' => 'Eligible Games',
        'contribution_rate' => 'Contribution Rate',
        'active_bonuses' => 'Active Bonuses',
        'bonus_history' => 'Bonus History',
        'refer_friend' => 'Refer a Friend',
        'referral_code' => 'Referral Code',
        'referral_link' => 'Referral Link',
        'friends_referred' => 'Friends Referred',
        'referral_earnings' => 'Referral Earnings'
    ],

    // Support & Help
    'support' => [
        'help_center' => 'Help Center',
        'faq' => 'FAQ',
        'live_chat' => 'Live Chat',
        'contact_us' => 'Contact Us',
        'support_ticket' => 'Support Ticket',
        'knowledge_base' => 'Knowledge Base',
        'video_tutorials' => 'Video Tutorials',
        'game_guides' => 'Game Guides',
        'betting_guides' => 'Betting Guides',
        'responsible_gaming' => 'Responsible Gaming',
        'security' => 'Security',
        'privacy' => 'Privacy',
        'terms_conditions' => 'Terms & Conditions',
        'complaint' => 'Complaint',
        'feedback' => 'Feedback',
        'suggestion' => 'Suggestion',
        'bug_report' => 'Bug Report',
        'feature_request' => 'Feature Request',
        'technical_issue' => 'Technical Issue',
        'account_issue' => 'Account Issue',
        'payment_issue' => 'Payment Issue',
        'betting_issue' => 'Betting Issue',
        'general_inquiry' => 'General Inquiry',
        'priority' => 'Priority',
        'low' => 'Low',
        'medium' => 'Medium',
        'high' => 'High',
        'urgent' => 'Urgent',
        'ticket_submitted' => 'Ticket Submitted',
        'ticket_updated' => 'Ticket Updated',
        'ticket_resolved' => 'Ticket Resolved',
        'ticket_closed' => 'Ticket Closed',
        'response_time' => 'Response Time',
        'chat_online' => 'Chat Online',
        'chat_offline' => 'Chat Offline',
        'chat_queue' => 'Queue Position',
        'estimated_wait' => 'Estimated Wait Time'
    ],

    // Legal & Compliance
    'legal' => [
        'terms_conditions' => 'Terms & Conditions',
        'privacy_policy' => 'Privacy Policy',
        'cookie_policy' => 'Cookie Policy',
        'responsible_gaming' => 'Responsible Gaming',
        'aml_policy' => 'AML Policy',
        'kyc_policy' => 'KYC Policy',
        'licensing' => 'Licensing',
        'fairness' => 'Fairness',
        'security' => 'Security',
        'data_protection' => 'Data Protection',
        'dispute_resolution' => 'Dispute Resolution',
        'self_exclusion' => 'Self Exclusion',
        'deposit_limits' => 'Deposit Limits',
        'time_limits' => 'Time Limits',
        'reality_check' => 'Reality Check',
        'cooling_off' => 'Cooling Off Period',
        'problem_gambling' => 'Problem Gambling',
        'gambling_addiction' => 'Gambling Addiction',
        'help_resources' => 'Help Resources',
        'age_verification' => 'Age Verification',
        'identity_verification' => 'Identity Verification',
        'document_upload' => 'Document Upload',
        'verification_pending' => 'Verification Pending',
        'verification_approved' => 'Verification Approved',
        'verification_rejected' => 'Verification Rejected'
    ],

    // Footer
    'footer' => [
        'company_description' => 'Crashify is the premier cryptocurrency betting platform offering sports betting, live casino games, and instant payouts.',
        'sports_betting' => 'Sports & Betting',
        'casino_games' => 'Casino Games',
        'crypto_payments' => 'Crypto & Payments',
        'support_help' => 'Support & Help',
        'promotions' => 'Promotions',
        'active_users' => 'Active Users',
        'daily_volume' => 'Daily Volume',
        'uptime' => 'Uptime',
        'ssl_secured' => 'SSL Secured',
        'fair_gaming' => 'Provably Fair',
        'licensed_regulated' => 'Licensed & Regulated',
        'all_rights_reserved' => 'All rights reserved.',
        'license_info' => 'Licensed and regulated by the Gaming Authority.',
        'age_verification' => '18+ Only. Gambling can be addictive. Play responsibly.'
    ],

    // Newsletter
    'newsletter' => [
        'title' => 'Stay Updated',
        'description' => 'Subscribe to our newsletter for exclusive bonuses, promotions, and betting tips.',
        'email_placeholder' => 'Enter your email address',
        'subscribe' => 'Subscribe',
        'subscribed' => 'Successfully subscribed to newsletter!',
        'already_subscribed' => 'You are already subscribed.',
        'invalid_email' => 'Please enter a valid email address.',
        'benefit_1' => 'Exclusive Bonuses',
        'benefit_2' => 'Latest Promotions',
        'benefit_3' => 'Betting Tips & Insights'
    ],

    // Cookies
    'cookies' => [
        'consent_message' => 'We use cookies to enhance your experience and provide personalized content.',
        'accept_all' => 'Accept All',
        'settings' => 'Cookie Settings',
        'necessary' => 'Necessary Cookies',
        'analytics' => 'Analytics Cookies',
        'marketing' => 'Marketing Cookies',
        'save_preferences' => 'Save Preferences'
    ],

    // Help & Guides
    'help' => [
        'getting_started' => 'Getting Started',
        'how_to_bet' => 'How to Bet',
        'how_to_deposit' => 'How to Deposit',
        'how_to_withdraw' => 'How to Withdraw',
        'crypto_guide' => 'Cryptocurrency Guide',
        'betting_tips' => 'Betting Tips',
        'game_rules' => 'Game Rules',
        'odds_explained' => 'Odds Explained',
        'live_betting_guide' => 'Live Betting Guide',
        'casino_guide' => 'Casino Guide',
        'bonus_guide' => 'Bonus Guide',
        'vip_guide' => 'VIP Guide',
        'mobile_guide' => 'Mobile Guide',
        'troubleshooting' => 'Troubleshooting',
        'account_verification' => 'Account Verification',
        'payment_methods' => 'Payment Methods',
        'security_tips' => 'Security Tips'
    ],

    // Time & Date
    'time' => [
        'now' => 'Now',
        'today' => 'Today',
        'yesterday' => 'Yesterday',
        'tomorrow' => 'Tomorrow',
        'this_week' => 'This Week',
        'next_week' => 'Next Week',
        'this_month' => 'This Month',
        'next_month' => 'Next Month',
        'minutes_ago' => 'minutes ago',
        'hours_ago' => 'hours ago',
        'days_ago' => 'days ago',
        'weeks_ago' => 'weeks ago',
        'months_ago' => 'months ago',
        'years_ago' => 'years ago',
        'in_minutes' => 'in minutes',
        'in_hours' => 'in hours',
        'in_days' => 'in days',
        'live' => 'LIVE',
        'finished' => 'Finished',
        'cancelled' => 'Cancelled',
        'postponed' => 'Postponed',
        'scheduled' => 'Scheduled'
    ],

    // Status Messages
    'status' => [
        'online' => 'Online',
        'offline' => 'Offline',
        'active' => 'Active',
        'inactive' => 'Inactive',
        'enabled' => 'Enabled',
        'disabled' => 'Disabled',
        'available' => 'Available',
        'unavailable' => 'Unavailable',
        'open' => 'Open',
        'closed' => 'Closed',
        'pending' => 'Pending',
        'processing' => 'Processing',
        'completed' => 'Completed',
        'failed' => 'Failed',
        'cancelled' => 'Cancelled',
        'expired' => 'Expired',
        'suspended' => 'Suspended',
        'banned' => 'Banned',
        'verified' => 'Verified',
        'unverified' => 'Unverified',
        'approved' => 'Approved',
        'rejected' => 'Rejected',
        'in_progress' => 'In Progress',
        'maintenance' => 'Maintenance'
    ]
];
?>
PHP
); ?>

<?php _merge_exec('languages/es.php', <<<'PHP'
<?php
// languages/es.php - Spanish Language File
// فایل زبان اسپانیولی

return [
    // General
    'site_name' => 'Crashify',
    'welcome' => 'Bienvenido',
    'home' => 'Inicio',
    'about' => 'Acerca de',
    'contact' => 'Contacto',
    'login' => 'Iniciar sesión',
    'register' => 'Registrarse',
    'logout' => 'Cerrar sesión',
    'dashboard' => 'Panel de control',
    'profile' => 'Perfil',
    'settings' => 'Configuración',
    'help' => 'Ayuda',
    'support' => 'Soporte',
    'language' => 'Idioma',
    'currency' => 'Moneda',
    'search' => 'Buscar',
    'loading' => 'Cargando...',
    'error' => 'Error',
    'success' => 'Éxito',
    'warning' => 'Advertencia',
    'info' => 'Información',
    'close' => 'Cerrar',
    'save' => 'Guardar',
    'cancel' => 'Cancelar',
    'delete' => 'Eliminar',
    'edit' => 'Editar',
    'view' => 'Ver',
    'back' => 'Atrás',
    'next' => 'Siguiente',
    'previous' => 'Anterior',
    'submit' => 'Enviar',
    'confirm' => 'Confirmar',
    'yes' => 'Sí',
    'no' => 'No',
    'ok' => 'OK',
    'continue' => 'Continuar',
    'finish' => 'Finalizar',
    'start' => 'Comenzar',
    'stop' => 'Detener',
    'pause' => 'Pausar',
    'resume' => 'Reanudar',
    'reset' => 'Restablecer',
    'refresh' => 'Actualizar',
    'update' => 'Actualizar',
    'upgrade' => 'Actualización',
    'download' => 'Descargar',
    'upload' => 'Subir',
    'share' => 'Compartir',
    'copy' => 'Copiar',
    'print' => 'Imprimir',
    'export' => 'Exportar',
    'import' => 'Importar',
    
    // Navigation
    'nav_home' => 'Inicio',
    'nav_casino' => 'Casino',
    'nav_sports' => 'Deportes',
    'nav_live' => 'En vivo',
    'nav_promotions' => 'Promociones',
    'nav_wallet' => 'Billetera',
    'nav_history' => 'Historial',
    'nav_support' => 'Soporte',
    
    // Authentication
    'auth_login_title' => 'Inicia sesión en tu cuenta',
    'auth_register_title' => 'Crear nueva cuenta',
    'auth_email' => 'Correo electrónico',
    'auth_password' => 'Contraseña',
    'auth_confirm_password' => 'Confirmar contraseña',
    'auth_remember_me' => 'Recordarme',
    'auth_forgot_password' => '¿Olvidaste tu contraseña?',
    'auth_no_account' => '¿No tienes cuenta?',
    'auth_have_account' => '¿Ya tienes cuenta?',
    'auth_create_account' => 'Crear cuenta',
    'auth_login_now' => 'Iniciar sesión ahora',
    'auth_first_name' => 'Nombre',
    'auth_last_name' => 'Apellido',
    'auth_phone' => 'Número de teléfono',
    'auth_birth_date' => 'Fecha de nacimiento',
    'auth_country' => 'País',
    'auth_city' => 'Ciudad',
    'auth_address' => 'Dirección',
    'auth_agree_terms' => 'Acepto los términos y condiciones',
    'auth_agree_privacy' => 'Acepto la política de privacidad',
    'auth_login_success' => 'Inicio de sesión exitoso',
    'auth_register_success' => 'Cuenta creada exitosamente',
    'auth_logout_success' => 'Cierre de sesión exitoso',
    'auth_invalid_credentials' => 'Credenciales inválidas',
    'auth_email_exists' => 'El correo ya está en uso',
    'auth_weak_password' => 'Contraseña débil',
    'auth_password_mismatch' => 'Las contraseñas no coinciden',
    
    // Dashboard
    'dashboard_welcome' => 'Bienvenido, {name}',
    'dashboard_balance' => 'Saldo',
    'dashboard_total_bets' => 'Total de apuestas',
    'dashboard_total_wins' => 'Total de ganancias',
    'dashboard_win_rate' => 'Tasa de victorias',
    'dashboard_recent_games' => 'Juegos recientes',
    'dashboard_quick_deposit' => 'Depósito rápido',
    'dashboard_quick_withdraw' => 'Retiro rápido',
    'dashboard_notifications' => 'Notificaciones',
    'dashboard_no_notifications' => 'No hay notificaciones nuevas',
    'dashboard_view_all' => 'Ver todo',
    
    // Games
    'games_crash' => 'Crash',
    'games_slots' => 'Tragamonedas',
    'games_blackjack' => 'Blackjack',
    'games_roulette' => 'Ruleta',
    'games_baccarat' => 'Baccarat',
    'games_poker' => 'Poker',
    'games_dice' => 'Dados',
    'games_mines' => 'Minas',
    'games_plinko' => 'Plinko',
    'games_wheel' => 'Rueda',
    'games_keno' => 'Keno',
    'games_scratch' => 'Raspaditas',
    'games_play_now' => 'Jugar ahora',
    'games_demo_mode' => 'Modo demo',
    'games_real_mode' => 'Modo real',
    'games_min_bet' => 'Apuesta mín.',
    'games_max_bet' => 'Apuesta máx.',
    'games_max_win' => 'Ganancia máx.',
    'games_rtp' => 'Retorno al jugador',
    'games_volatility' => 'Volatilidad',
    'games_provider' => 'Proveedor',
    
    // Betting
    'bet_amount' => 'Cantidad de apuesta',
    'bet_place' => 'Realizar apuesta',
    'bet_cancel' => 'Cancelar apuesta',
    'bet_cashout' => 'Cobrar',
    'bet_auto' => 'Apuesta automática',
    'bet_manual' => 'Apuesta manual',
    'bet_multiplier' => 'Multiplicador',
    'bet_profit' => 'Ganancia',
    'bet_loss' => 'Pérdida',
    'bet_win' => 'Victoria',
    'bet_pending' => 'Pendiente',
    'bet_settled' => 'Liquidada',
    'bet_void' => 'Anulada',
    'bet_history' => 'Historial de apuestas',
    'bet_statistics' => 'Estadísticas de apuestas',
    'bet_limits' => 'Límites de apuestas',
    'bet_responsible' => 'Juego responsable',
    
    // Wallet
    'wallet_balance' => 'Saldo de billetera',
    'wallet_deposit' => 'Depósito',
    'wallet_withdraw' => 'Retiro',
    'wallet_transfer' => 'Transferencia',
    'wallet_history' => 'Historial de billetera',
    'wallet_pending' => 'Pendiente',
    'wallet_completed' => 'Completado',
    'wallet_failed' => 'Fallido',
    'wallet_cancelled' => 'Cancelado',
    'wallet_min_deposit' => 'Depósito mín.',
    'wallet_max_deposit' => 'Depósito máx.',
    'wallet_min_withdraw' => 'Retiro mín.',
    'wallet_max_withdraw' => 'Retiro máx.',
    'wallet_fee' => 'Comisión',
    'wallet_processing_time' => 'Tiempo de procesamiento',
    'wallet_payment_method' => 'Método de pago',
    'wallet_card' => 'Tarjeta',
    'wallet_bank' => 'Banco',
    'wallet_crypto' => 'Criptomoneda',
    'wallet_ewallet' => 'Billetera electrónica',
    
    // Sports Betting
    'sports_football' => 'Fútbol',
    'sports_basketball' => 'Baloncesto',
    'sports_tennis' => 'Tenis',
    'sports_baseball' => 'Béisbol',
    'sports_hockey' => 'Hockey',
    'sports_soccer' => 'Fútbol americano',
    'sports_boxing' => 'Boxeo',
    'sports_mma' => 'Artes marciales mixtas',
    'sports_cricket' => 'Cricket',
    'sports_rugby' => 'Rugby',
    'sports_golf' => 'Golf',
    'sports_racing' => 'Carreras',
    'sports_esports' => 'E-deportes',
    'sports_live_betting' => 'Apuestas en vivo',
    'sports_pre_match' => 'Pre-partido',
    'sports_odds' => 'Cuotas',
    'sports_handicap' => 'Hándicap',
    'sports_over_under' => 'Más/Menos',
    'sports_both_teams_score' => 'Ambos equipos anotan',
    'sports_correct_score' => 'Resultado exacto',
    'sports_first_goal' => 'Primer gol',
    'sports_match_winner' => 'Ganador del partido',
    'sports_tournament_winner' => 'Ganador del torneo',
    
    // Promotions
    'promo_welcome_bonus' => 'Bono de bienvenida',
    'promo_deposit_bonus' => 'Bono de depósito',
    'promo_reload_bonus' => 'Bono de recarga',
    'promo_cashback' => 'Reembolso',
    'promo_free_spins' => 'Giros gratis',
    'promo_free_bet' => 'Apuesta gratis',
    'promo_tournament' => 'Torneo',
    'promo_loyalty' => 'Programa de lealtad',
    'promo_vip' => 'Programa VIP',
    'promo_refer_friend' => 'Referir amigo',
    'promo_code' => 'Código promocional',
    'promo_terms' => 'Términos de la promoción',
    'promo_wagering' => 'Requisitos de apuesta',
    'promo_expiry' => 'Fecha de vencimiento',
    'promo_claim' => 'Reclamar',
    'promo_claimed' => 'Reclamado',
    'promo_expired' => 'Expirado',
    'promo_active' => 'Activo',
    'promo_completed' => 'Completado',
    
    // Profile
    'profile_personal_info' => 'Información personal',
    'profile_account_settings' => 'Configuración de cuenta',
    'profile_security' => 'Seguridad',
    'profile_preferences' => 'Preferencias',
    'profile_verification' => 'Verificación',
    'profile_documents' => 'Documentos',
    'profile_limits' => 'Límites',
    'profile_self_exclusion' => 'Autoexclusión',
    'profile_responsible_gaming' => 'Juego responsable',
    'profile_notifications' => 'Notificaciones',
    'profile_privacy' => 'Privacidad',
    'profile_change_password' => 'Cambiar contraseña',
    'profile_two_factor' => 'Autenticación de dos factores',
    'profile_login_history' => 'Historial de inicio de sesión',
    'profile_device_management' => 'Gestión de dispositivos',
    
    // Support
    'support_contact' => 'Contactarnos',
    'support_live_chat' => 'Chat en vivo',
    'support_email' => 'Correo electrónico',
    'support_phone' => 'Teléfono',
    'support_faq' => 'Preguntas frecuentes',
    'support_help_center' => 'Centro de ayuda',
    'support_ticket' => 'Ticket de soporte',
    'support_create_ticket' => 'Crear ticket',
    'support_ticket_status' => 'Estado del ticket',
    'support_priority' => 'Prioridad',
    'support_category' => 'Categoría',
    'support_subject' => 'Asunto',
    'support_message' => 'Mensaje',
    'support_attachment' => 'Adjunto',
    'support_response' => 'Respuesta',
    'support_resolved' => 'Resuelto',
    'support_pending' => 'Pendiente',
    'support_closed' => 'Cerrado',
    
    // Notifications
    'notif_new_message' => 'Nuevo mensaje',
    'notif_deposit_success' => 'Depósito exitoso',
    'notif_withdraw_success' => 'Retiro exitoso',
    'notif_bet_won' => '¡Apuesta ganada!',
    'notif_bet_lost' => 'Apuesta perdida',
    'notif_bonus_received' => 'Bono recibido',
    'notif_promotion_available' => 'Promoción disponible',
    'notif_account_verified' => 'Cuenta verificada',
    'notif_security_alert' => 'Alerta de seguridad',
    'notif_maintenance' => 'Mantenimiento del sistema',
    'notif_mark_read' => 'Marcar como leído',
    'notif_mark_all_read' => 'Marcar todo como leído',
    'notif_delete' => 'Eliminar notificación',
    'notif_settings' => 'Configuración de notificaciones',
    
    // Errors
    'error_404' => 'Página no encontrada',
    'error_500' => 'Error del servidor',
    'error_403' => 'Acceso denegado',
    'error_401' => 'No autorizado',
    'error_400' => 'Solicitud inválida',
    'error_network' => 'Error de red',
    'error_timeout' => 'Tiempo de espera agotado',
    'error_invalid_input' => 'Entrada inválida',
    'error_required_field' => 'Este campo es requerido',
    'error_invalid_email' => 'Correo electrónico inválido',
    'error_invalid_phone' => 'Número de teléfono inválido',
    'error_min_length' => 'Longitud mínima {min} caracteres',
    'error_max_length' => 'Longitud máxima {max} caracteres',
    'error_min_value' => 'Valor mínimo {min}',
    'error_max_value' => 'Valor máximo {max}',
    'error_insufficient_balance' => 'Saldo insuficiente',
    'error_bet_limit_exceeded' => 'Límite de apuesta excedido',
    'error_game_unavailable' => 'Juego no disponible',
    'error_maintenance' => 'Sistema en mantenimiento',
    
    // Success Messages
    'success_saved' => 'Guardado exitosamente',
    'success_updated' => 'Actualizado exitosamente',
    'success_deleted' => 'Eliminado exitosamente',
    'success_sent' => 'Enviado exitosamente',
    'success_verified' => 'Verificado exitosamente',
    'success_activated' => 'Activado exitosamente',
    'success_deactivated' => 'Desactivado exitosamente',
    'success_password_changed' => 'Contraseña cambiada exitosamente',
    'success_email_sent' => 'Correo enviado',
    'success_settings_saved' => 'Configuración guardada',
    
    // Time and Date
    'time_now' => 'ahora',
    'time_minute_ago' => 'hace 1 minuto',
    'time_minutes_ago' => 'hace {count} minutos',
    'time_hour_ago' => 'hace 1 hora',
    'time_hours_ago' => 'hace {count} horas',
    'time_day_ago' => 'hace 1 día',
    'time_days_ago' => 'hace {count} días',
    'time_week_ago' => 'hace 1 semana',
    'time_weeks_ago' => 'hace {count} semanas',
    'time_month_ago' => 'hace 1 mes',
    'time_months_ago' => 'hace {count} meses',
    'time_year_ago' => 'hace 1 año',
    'time_years_ago' => 'hace {count} años',
    
    // Days of Week
    'day_monday' => 'Lunes',
    'day_tuesday' => 'Martes',
    'day_wednesday' => 'Miércoles',
    'day_thursday' => 'Jueves',
    'day_friday' => 'Viernes',
    'day_saturday' => 'Sábado',
    'day_sunday' => 'Domingo',
    
    // Months
    'month_january' => 'Enero',
    'month_february' => 'Febrero',
    'month_march' => 'Marzo',
    'month_april' => 'Abril',
    'month_may' => 'Mayo',
    'month_june' => 'Junio',
    'month_july' => 'Julio',
    'month_august' => 'Agosto',
    'month_september' => 'Septiembre',
    'month_october' => 'Octubre',
    'month_november' => 'Noviembre',
    'month_december' => 'Diciembre',
    
    // Footer
    'footer_about_us' => 'Acerca de nosotros',
    'footer_terms' => 'Términos y condiciones',
    'footer_privacy' => 'Política de privacidad',
    'footer_responsible_gaming' => 'Juego responsable',
    'footer_contact' => 'Contacto',
    'footer_help' => 'Ayuda',
    'footer_sitemap' => 'Mapa del sitio',
    'footer_copyright' => '© 2024 Crashify. Todos los derechos reservados.',
    'footer_license' => 'Licenciado y regulado',
    'footer_18_plus' => 'Solo 18+',
    'footer_gamble_responsibly' => 'Juega responsablemente',
    
    // Legal
    'legal_terms_title' => 'Términos y condiciones',
    'legal_privacy_title' => 'Política de privacidad',
    'legal_responsible_title' => 'Juego responsable',
    'legal_aml_title' => 'Antilavado de dinero',
    'legal_kyc_title' => 'Conoce a tu cliente',
    'legal_complaints_title' => 'Procedimientos de quejas',
    'legal_licensing_title' => 'Información de licencia',
    'legal_fairness_title' => 'Equidad y transparencia',
    
    // Admin
    'admin_dashboard' => 'Panel de administración',
    'admin_users' => 'Usuarios',
    'admin_transactions' => 'Transacciones',
    'admin_games' => 'Juegos',
    'admin_reports' => 'Reportes',
    'admin_settings' => 'Configuración',
    'admin_logs' => 'Registros',
    'admin_security' => 'Seguridad',
    'admin_maintenance' => 'Mantenimiento',
    'admin_backup' => 'Respaldo',
];
?>
PHP
); ?>

<?php _merge_exec('languages/fa.php', <<<'PHP'
<?php
// languages/fa.php - Persian/Farsi Language File
// فایل زبان فارسی برای سایت Crashify

return [
    // Common/General
    'common' => [
        'loading' => 'در حال بارگذاری...',
        'save' => 'ذخیره',
        'cancel' => 'لغو',
        'delete' => 'حذف',
        'edit' => 'ویرایش',
        'view' => 'مشاهده',
        'search' => 'جستجو',
        'filter' => 'فیلتر',
        'sort' => 'مرتب‌سازی',
        'refresh' => 'بروزرسانی',
        'back' => 'بازگشت',
        'next' => 'بعدی',
        'previous' => 'قبلی',
        'submit' => 'ارسال',
        'confirm' => 'تأیید',
        'yes' => 'بله',
        'no' => 'خیر',
        'ok' => 'تأیید',
        'close' => 'بستن',
        'open' => 'باز کردن',
        'live' => 'زنده',
        'new' => 'جدید',
        'hot' => 'داغ',
        'popular' => 'محبوب',
        'featured' => 'ویژه',
        'coming_soon' => 'به زودی',
        'maintenance' => 'در حال تعمیر',
        'error' => 'خطا',
        'success' => 'موفقیت',
        'warning' => 'هشدار',
        'info' => 'اطلاعات',
        'live_updates' => 'بروزرسانی زنده',
        'back_to_top' => 'بازگشت به بالا'
    ],

    // Site Information
    'site' => [
        'tagline' => 'بهترین پلتفرم شرط‌بندی کریپتو',
        'welcome' => 'به کرشیفای خوش آمدید',
        'description' => 'آینده شرط‌بندی آنلاین را با پرداخت‌های فوری کریپتو، شرط‌بندی زنده ورزشی و بازی‌های کازینو پریمیوم تجربه کنید.'
    ],

    // Navigation
    'nav' => [
        'home' => 'خانه',
        'sportsbook' => 'شرط‌بندی ورزشی',
        'live_betting' => 'شرط‌بندی زنده',
        'casino' => 'کازینو',
        'esports' => 'ورزش‌های الکترونیک',
        'virtual_sports' => 'ورزش‌های مجازی',
        'lottery' => 'لاتاری',
        'bonuses' => 'جوایز',
        'more' => 'بیشتر',
        'promotions' => 'تبلیغات',
        'vip' => 'وی‌آی‌پی',
        'tournaments' => 'مسابقات'
    ],

    // Authentication
    'auth' => [
        'login' => 'ورود',
        'register' => 'ثبت‌نام',
        'logout' => 'خروج',
        'forgot_password' => 'رمز عبور را فراموش کرده‌اید؟',
        'reset_password' => 'بازنشانی رمز عبور',
        'change_password' => 'تغییر رمز عبور',
        'email' => 'ایمیل',
        'username' => 'نام کاربری',
        'password' => 'رمز عبور',
        'confirm_password' => 'تأیید رمز عبور',
        'remember_me' => 'مرا به خاطر بسپار',
        'login_success' => 'ورود موفقیت‌آمیز! خوش برگشتید.',
        'login_failed' => 'ورود ناموفق. لطفاً دوباره تلاش کنید.',
        'logout_success' => 'با موفقیت خارج شدید.',
        'registration_success' => 'ثبت‌نام موفقیت‌آمیز! لطفاً ایمیل خود را برای تأیید حساب بررسی کنید.',
        'registration_failed' => 'ثبت‌نام ناموفق. لطفاً دوباره تلاش کنید.',
        'invalid_credentials' => 'ایمیل/نام کاربری یا رمز عبور نامعتبر.',
        'account_locked' => 'حساب به دلیل تلاش‌های ناموفق زیاد قفل شده. {minutes} دقیقه دیگر تلاش کنید.',
        'account_inactive' => 'حساب شما غیرفعال است. لطفاً با پشتیبانی تماس بگیرید.',
        'user_exists' => 'کاربری با این ایمیل یا نام کاربری قبلاً وجود دارد.',
        'invalid_username' => 'نام کاربری باید حداقل ۳ کاراکتر باشد.',
        'invalid_email' => 'لطفاً یک آدرس ایمیل معتبر وارد کنید.',
        'invalid_password_format' => 'رمز عبور باید حداقل ۸ کاراکتر با حروف بزرگ، کوچک و عدد باشد.',
        'email_verified' => 'ایمیل با موفقیت تأیید شد! اکنون می‌توانید وارد شوید.',
        'invalid_verification_token' => 'توکن تأیید نامعتبر یا منقضی شده.',
        'verification_failed' => 'تأیید ایمیل ناموفق. لطفاً دوباره تلاش کنید.',
        'reset_email_sent' => 'اگر حسابی با این ایمیل وجود داشته باشد، دستورالعمل بازنشانی رمز عبور دریافت خواهید کرد.',
        'reset_request_failed' => 'درخواست بازنشانی رمز عبور ناموفق. لطفاً دوباره تلاش کنید.',
        'password_reset_success' => 'رمز عبور با موفقیت بازنشانی شد! اکنون می‌توانید با رمز عبور جدید وارد شوید.',
        'password_reset_failed' => 'بازنشانی رمز عبور ناموفق. لطفاً دوباره تلاش کنید.',
        'invalid_reset_token' => 'توکن بازنشانی نامعتبر یا منقضی شده.',
        'confirm_logout' => 'آیا مطمئن هستید که می‌خواهید خارج شوید؟',
        'verification_email_subject' => 'تأیید حساب کرشیفای شما',
        'verification_email_body' => 'برای تأیید حساب خود روی لینک زیر کلیک کنید: {url}',
        'reset_email_subject' => 'بازنشانی رمز عبور کرشیفای',
        'reset_email_body' => 'برای بازنشانی رمز عبور خود روی لینک زیر کلیک کنید: {url}',
        'two_factor_enabled' => 'احراز هویت دو مرحله‌ای با موفقیت فعال شد.',
        'two_factor_code' => 'کد دو مرحله‌ای',
        'invalid_2fa_code' => 'کد احراز هویت دو مرحله‌ای نامعتبر.'
    ],

    // User Profile & Account
    'user' => [
        'profile' => 'پروفایل',
        'account' => 'حساب',
        'settings' => 'تنظیمات',
        'wallet' => 'کیف پول',
        'bet_history' => 'تاریخچه شرط‌ها',
        'transaction_history' => 'تاریخچه تراکنش‌ها',
        'bonuses' => 'جوایز من',
        'support' => 'پشتیبانی',
        'preferences' => 'ترجیحات',
        'security' => 'امنیت',
        'verification' => 'تأیید هویت',
        'first_name' => 'نام',
        'last_name' => 'نام خانوادگی',
        'phone' => 'شماره تلفن',
        'country' => 'کشور',
        'date_of_birth' => 'تاریخ تولد',
        'address' => 'آدرس',
        'city' => 'شهر',
        'postal_code' => 'کد پستی',
        'total_bets' => 'کل شرط‌ها',
        'win_rate' => 'نرخ برد',
        'total_winnings' => 'کل برد',
        'level' => 'سطح',
        'vip_status' => 'وضعیت وی‌آی‌پی',
        'joined_date' => 'عضو از',
        'last_login' => 'آخرین ورود',
        'account_status' => 'وضعیت حساب',
        'email_verified' => 'ایمیل تأیید شده',
        'phone_verified' => 'تلفن تأیید شده',
        'identity_verified' => 'هویت تأیید شده'
    ],

    // Wallet & Payments
    'wallet' => [
        'my_wallet' => 'کیف پول من',
        'balance' => 'موجودی',
        'main_balance' => 'موجودی اصلی',
        'bonus_balance' => 'موجودی جایزه',
        'deposit' => 'واریز',
        'withdraw' => 'برداشت',
        'transfer' => 'انتقال',
        'transaction_history' => 'تاریخچه تراکنش‌ها',
        'pending_transactions' => 'تراکنش‌های در انتظار',
        'deposit_address' => 'آدرس واریز',
        'withdrawal_address' => 'آدرس برداشت',
        'amount' => 'مقدار',
        'currency' => 'ارز',
        'fee' => 'کارمزد',
        'total' => 'مجموع',
        'minimum_deposit' => 'حداقل واریز',
        'maximum_deposit' => 'حداکثر واریز',
        'minimum_withdrawal' => 'حداقل برداشت',
        'maximum_withdrawal' => 'حداکثر برداشت',
        'processing_time' => 'زمان پردازش',
        'instant' => 'فوری',
        'confirmations_required' => 'تأیید مورد نیاز',
        'transaction_id' => 'شناسه تراکنش',
        'status' => 'وضعیت',
        'pending' => 'در انتظار',
        'completed' => 'تکمیل شده',
        'failed' => 'ناموفق',
        'cancelled' => 'لغو شده',
        'deposit_success' => 'واریز با موفقیت انجام شد!',
        'withdrawal_success' => 'درخواست برداشت با موفقیت ارسال شد!',
        'insufficient_balance' => 'موجودی ناکافی.',
        'invalid_address' => 'آدرس کیف پول نامعتبر.',
        'invalid_amount' => 'مقدار نامعتبر.',
        'deposit_instructions' => 'ارز دیجیتال خود را به آدرس زیر ارسال کنید. موجودی شما پس از تأیید شبکه بروزرسانی خواهد شد.',
        'withdrawal_warning' => 'آدرس برداشت را دوباره بررسی کنید. تراکنش‌های ارز دیجیتال غیرقابل بازگشت هستند.',
        'copy_address' => 'کپی آدرس',
        'address_copied' => 'آدرس در کلیپ‌بورد کپی شد!',
        'generate_new_address' => 'تولید آدرس جدید'
    ],

    // Sports & Betting
    'sports' => [
        'football' => 'فوتبال',
        'basketball' => 'بسکتبال',
        'tennis' => 'تنیس',
        'baseball' => 'بیسبال',
        'hockey' => 'هاکی',
        'soccer' => 'فوتبال',
        'american_football' => 'فوتبال آمریکایی',
        'volleyball' => 'والیبال',
        'cricket' => 'کریکت',
        'rugby' => 'راگبی',
        'golf' => 'گلف',
        'boxing' => 'بوکس',
        'mma' => 'هنرهای رزمی ترکیبی',
        'motorsports' => 'ورزش‌های موتوری',
        'cycling' => 'دوچرخه‌سواری',
        'swimming' => 'شنا',
        'athletics' => 'دو و میدانی',
        'winter_sports' => 'ورزش‌های زمستانی'
    ],

    // Betting
    'betting' => [
        'bet_slip' => 'برگه شرط',
        'place_bet' => 'ثبت شرط',
        'place_bets' => 'ثبت شرط‌ها',
        'add_to_bet_slip' => 'افزودن به برگه شرط',
        'remove_from_bet_slip' => 'حذف از برگه شرط',
        'clear_bet_slip' => 'پاک کردن برگه شرط',
        'empty_bet_slip' => 'برگه شرط شما خالی است. برای شروع چند انتخاب اضافه کنید!',
        'stake' => 'مبلغ شرط',
        'total_stake' => 'کل مبلغ شرط',
        'odds' => 'ضریب',
        'potential_payout' => 'برد احتمالی',
        'potential_profit' => 'سود احتمالی',
        'bet_type' => 'نوع شرط',
        'single_bet' => 'شرط تکی',
        'accumulator' => 'شرط ترکیبی',
        'system_bet' => 'شرط سیستمی',
        'live_bet' => 'شرط زنده',
        'pre_match' => 'پیش از بازی',
        'in_play' => 'در حین بازی',
        'match_result' => 'نتیجه بازی',
        'over_under' => 'بالا/پایین',
        'both_teams_score' => 'گل زدن هر دو تیم',
        'correct_score' => 'نتیجه دقیق',
        'first_goalscorer' => 'اولین گلزن',
        'handicap' => 'هندیکپ',
        'double_chance' => 'شانس دوگانه',
        'draw_no_bet' => 'مساوی بدون شرط',
        'win' => 'برد',
        'lose' => 'باخت',
        'push' => 'مساوی',
        'void' => 'باطل',
        'settled' => 'تسویه شده',
        'unsettled' => 'تسویه نشده',
        'bet_placed' => 'شرط با موفقیت ثبت شد!',
        'bet_failed' => 'ثبت شرط ناموفق. لطفاً دوباره تلاش کنید.',
        'minimum_stake' => 'حداقل مبلغ شرط: {amount}',
        'maximum_stake' => 'حداکثر مبلغ شرط: {amount}',
        'maximum_payout' => 'حداکثر برد: {amount}',
        'odds_changed' => 'ضرایب تغییر کرده‌اند. لطفاً شرط خود را تأیید کنید.',
        'event_suspended' => 'این رویداد در حال حاضر متوقف شده است.',
        'market_closed' => 'این بازار بسته است.',
        'bet_limit_exceeded' => 'حد شرط تجاوز شده.',
        'accept_odds_changes' => 'پذیرش تغییرات ضریب',
        'reject_odds_changes' => 'رد تغییرات ضریب'
    ],

    // Casino
    'casino' => [
        'slots' => 'اسلات',
        'table_games' => 'بازی‌های میز',
        'live_casino' => 'کازینو زنده',
        'crash_games' => 'بازی‌های کرش',
        'jackpots' => 'جک‌پات',
        'tournaments' => 'مسابقات',
        'new_games' => 'بازی‌های جدید',
        'popular_games' => 'بازی‌های محبوب',
        'blackjack' => 'بلک‌جک',
        'roulette' => 'رولت',
        'baccarat' => 'باکارات',
        'poker' => 'پوکر',
        'dice' => 'تاس',
        'keno' => 'کنو',
        'scratch_cards' => 'کارت‌های خراشی',
        'video_poker' => 'ویدیو پوکر',
        'play_now' => 'بازی کنید',
        'play_for_fun' => 'بازی تفریحی',
        'play_for_real' => 'بازی واقعی',
        'game_loading' => 'بارگذاری بازی...',
        'game_error' => 'بارگذاری بازی ناموفق. لطفاً دوباره تلاش کنید.',
        'insufficient_balance' => 'موجودی ناکافی برای این بازی.',
        'bet_amount' => 'مبلغ شرط',
        'spin' => 'چرخش',
        'deal' => 'پخش',
        'hit' => 'کارت',
        'stand' => 'ایست',
        'double' => 'دوبرابر',
        'split' => 'تقسیم',
        'insurance' => 'بیمه',
        'surrender' => 'تسلیم',
        'auto_play' => 'بازی خودکار',
        'max_bet' => 'حداکثر شرط',
        'game_history' => 'تاریخچه بازی',
        'game_rules' => 'قوانین بازی',
        'paytable' => 'جدول پرداخت',
        'jackpot_amount' => 'مبلغ جک‌پات',
        'progressive_jackpot' => 'جک‌پات پیشرونده',
        'free_spins' => 'چرخش‌های رایگان',
        'bonus_round' => 'دور جایزه',
        'multiplier' => 'ضریب',
        'wild_symbol' => 'نماد وحشی',
        'scatter_symbol' => 'نماد پراکنده'
    ],

    // Bonuses & Promotions
    'bonuses' => [
        'all_bonuses' => 'همه جوایز',
        'active_bonuses' => 'جوایز فعال',
        'bonus_history' => 'تاریخچه جوایز',
        'welcome_bonus' => 'جایزه خوش‌آمدگویی',
        'deposit_bonus' => 'جایزه واریز',
        'reload_bonus' => 'جایزه بارگذاری مجدد',
        'no_deposit_bonus' => 'جایزه بدون واریز',
        'free_bet' => 'شرط رایگان',
        'free_spins' => 'چرخش‌های رایگان',
        'cashback' => 'بازگشت وجه',
        'vip_program' => 'برنامه وی‌آی‌پی',
        'referral_program' => 'برنامه معرفی',
        'loyalty_points' => 'امتیاز وفاداری',
        'bonus_code' => 'کد جایزه',
        'claim_bonus' => 'دریافت جایزه',
        'bonus_claimed' => 'جایزه با موفقیت دریافت شد!',
        'bonus_expired' => 'این جایزه منقضی شده است.',
        'bonus_requirements' => 'شرایط جایزه',
        'wagering_requirement' => 'شرط شرط‌بندی',
        'minimum_deposit' => 'حداقل واریز',
        'maximum_bonus' => 'حداکثر جایزه',
        'valid_until' => 'معتبر تا',
        'terms_and_conditions' => 'شرایط و ضوابط',
        'bonus_balance' => 'موجودی جایزه',
        'wagering_progress' => 'پیشرفت شرط‌بندی',
        'remaining_wagering' => 'شرط‌بندی باقی‌مانده',
        'hot_offer' => 'پیشنهاد داغ',
        'limited_time' => 'زمان محدود',
        'exclusive_offer' => 'پیشنهاد انحصاری',
        'welcome_offer_text' => '۱۰۰٪ جایزه تا ۱۰۰۰ دلار + ۱۰۰ چرخش رایگان در اولین واریز!'
    ],

    // Support & Help
    'support' => [
        'help_center' => 'مرکز راهنمایی',
        'live_chat' => 'گفتگوی زنده',
        'contact_us' => 'تماس با ما',
        'faq' => 'سوالات متداول',
        'chat' => 'گفتگو',
        'support_ticket' => 'تیکت پشتیبانی',
        'create_ticket' => 'ایجاد تیکت',
        'ticket_history' => 'تاریخچه تیکت‌ها',
        'subject' => 'موضوع',
        'message' => 'پیام',
        'priority' => 'اولویت',
        'low' => 'کم',
        'medium' => 'متوسط',
        'high' => 'زیاد',
        'urgent' => 'فوری',
        'ticket_submitted' => 'تیکت پشتیبانی با موفقیت ارسال شد!',
        'response_time' => 'زمان پاسخ',
        'average_response' => 'میانگین زمان پاسخ: ۲ ساعت',
        '24_7_chat' => 'گفتگوی زنده ۲۴/۷',
        'online_support' => 'پشتیبانی آنلاین',
        'offline_support' => 'آفلاین - پیام بگذارید',
        'responsible_gaming' => 'بازی مسئولانه',
        'security' => 'امنیت و حریم خصوصی',
        'how_to_deposit' => 'نحوه واریز',
        'how_to_withdraw' => 'نحوه برداشت',
        'account_verification' => 'تأیید حساب',
        'betting_rules' => 'قوانین شرط‌بندی',
        'casino_rules' => 'قوانین کازینو',
        'bonus_terms' => 'شرایط جایزه',
        'technical_issues' => 'مشکلات فنی',
        'payment_issues' => 'مشکلات پرداخت',
        'general_inquiry' => 'سوال عمومی'
    ],

    // Notifications
    'notifications' => [
        'title' => 'اعلان‌ها',
        'mark_all_read' => 'همه را خوانده علامت‌گذاری کن',
        'view_all' => 'مشاهده همه',
        'no_notifications' => 'اعلان جدیدی نیست',
        'bet_won' => 'تبریک! شرط شما برنده شد.',
        'bet_lost' => 'شرط شما ناموفق بود.',
        'deposit_confirmed' => 'واریز شما تأیید شد.',
        'withdrawal_processed' => 'برداشت شما پردازش شد.',
        'bonus_credited' => 'جایزه به حساب شما واریز شد.',
        'new_promotion' => 'تبلیغ جدید موجود است!',
        'account_verified' => 'حساب شما تأیید شد.',
        'security_alert' => 'هشدار امنیتی: ورود جدید شناسایی شد.',
        'maintenance_notice' => 'اطلاعیه تعمیر برنامه‌ریزی شده.',
        'game_update' => 'بازی‌های جدید اضافه شدند!',
        'tournament_reminder' => 'مسابقه به زودی شروع می‌شود!',
        'vip_invitation' => 'شما به برنامه وی‌آی‌پی ما دعوت شده‌اید!'
    ],

    // Footer
    'footer' => [
        'company_description' => 'معتبرترین پلتفرم شرط‌بندی کریپتو با پرداخت‌های فوری، شرط‌بندی زنده ورزشی و بازی‌های کازینو پریمیوم. دارای مجوز و تنظیم شده برای امنیت شما.',
        'sports_betting' => 'شرط‌بندی ورزشی',
        'casino_games' => 'بازی‌های کازینو',
        'crypto_payments' => 'کریپتو و پرداخت‌ها',
        'support_help' => 'پشتیبانی و راهنمایی',
        'promotions' => 'تبلیغات و جوایز',
        'active_users' => 'کاربران فعال',
        'daily_volume' => 'حجم روزانه',
        'uptime' => 'زمان فعالیت',
        'all_rights_reserved' => 'تمام حقوق محفوظ است.',
        'license_info' => 'دارای مجوز و تنظیم شده. قمار می‌تواند اعتیادآور باشد. مسئولانه بازی کنید.',
        'ssl_secured' => 'امن با SSL',
        'fair_gaming' => 'بازی عادلانه',
        'age_verification' => 'برای استفاده از این وب‌سایت باید ۱۸ سال یا بیشتر داشته باشید. قمار می‌تواند اعتیادآور باشد. مسئولانه بازی کنید.'
    ],

    // Legal
    'legal' => [
        'terms_conditions' => 'شرایط و ضوابط',
        'privacy_policy' => 'سیاست حریم خصوصی',
        'cookie_policy' => 'سیاست کوکی',
        'responsible_gaming' => 'بازی مسئولانه',
        'aml_policy' => 'سیاست ضد پولشویی',
        'kyc_policy' => 'سیاست شناخت مشتری'
    ],

    // Newsletter
    'newsletter' => [
        'title' => 'به‌روز بمانید',
        'description' => 'در خبرنامه ما عضو شوید تا جوایز انحصاری، تبلیغات و نکات شرط‌بندی دریافت کنید.',
        'email_placeholder' => 'آدرس ایمیل خود را وارد کنید',
        'subscribe' => 'عضویت',
        'subscribed' => 'با موفقیت عضو شدید!',
        'benefit_1' => 'جوایز انحصاری',
        'benefit_2' => 'آخرین تبلیغات',
        'benefit_3' => 'نکات و بینش‌های شرط‌بندی'
    ],

    // Cookies
    'cookies' => [
        'consent_message' => 'ما از کوکی‌ها برای بهبود تجربه شما و ارائه محتوای شخصی‌سازی شده استفاده می‌کنیم. با ادامه استفاده از سایت ما، با سیاست کوکی ما موافقت می‌کنید.',
        'accept_all' => 'پذیرش همه',
        'settings' => 'تنظیمات کوکی',
        'necessary' => 'کوکی‌های ضروری',
        'analytics' => 'کوکی‌های تحلیلی',
        'marketing' => 'کوکی‌های بازاریابی',
        'save_preferences' => 'ذخیره ترجیحات'
    ],

    // Settings
    'settings' => [
        'general' => 'تنظیمات عمومی',
        'account_settings' => 'تنظیمات حساب',
        'privacy_settings' => 'تنظیمات حریم خصوصی',
        'notification_settings' => 'تنظیمات اعلان‌ها',
        'language' => 'زبان',
        'theme' => 'تم',
        'timezone' => 'منطقه زمانی',
        'currency' => 'ارز',
        'odds_format' => 'فرمت ضرایب',
        'decimal' => 'اعشاری',
        'fractional' => 'کسری',
        'american' => 'آمریکایی',
        'email_notifications' => 'اعلان‌های ایمیل',
        'sms_notifications' => 'اعلان‌های پیامک',
        'push_notifications' => 'اعلان‌های فوری',
        'marketing_emails' => 'ایمیل‌های بازاریابی',
        'two_factor_auth' => 'احراز هویت دو مرحله‌ای',
        'change_theme' => 'تغییر تم',
        'auto_logout' => 'خروج خودکار',
        'session_timeout' => 'انقضای جلسه',
        'login_alerts' => 'هشدارهای ورود',
        'bet_confirmations' => 'تأیید شرط‌ها',
        'sound_effects' => 'جلوه‌های صوتی',
        'animations' => 'انیمیشن‌ها',
        'reduced_motion' => 'حرکت کاهش یافته'
    ],

    // Help & Guides
    'help' => [
        'getting_started' => 'شروع کار',
        'how_to_bet' => 'نحوه شرط‌بندی',
        'crypto_guide' => 'راهنمای ارز دیجیتال',
        'betting_guide' => 'راهنمای شرط‌بندی',
        'casino_guide' => 'راهنمای کازینو',
        'bonus_guide' => 'راهنمای جایزه',
        'security_guide' => 'راهنمای امنیت',
        'mobile_guide' => 'راهنمای موبایل',
        'troubleshooting' => 'عیب‌یابی',
        'video_tutorials' => 'آموزش‌های ویدیویی',
        'step_by_step' => 'راهنمای گام به گام',
        'tips_and_tricks' => 'نکات و ترفندها'
    ],

    // Errors
    'errors' => [
        'page_not_found' => 'صفحه یافت نشد',
        'access_denied' => 'دسترسی مجاز نیست',
        'server_error' => 'خطای سرور',
        'maintenance_mode' => 'سایت در حال تعمیر',
        'connection_error' => 'خطای اتصال',
        'timeout_error' => 'انقضای زمان درخواست',
        'invalid_request' => 'درخواست نامعتبر',
        'session_expired' => 'جلسه منقضی شده',
        'rate_limit_exceeded' => 'حد نرخ تجاوز شده',
        'file_not_found' => 'فایل یافت نشد',
        'permission_denied' => 'اجازه مجاز نیست',
        'validation_failed' => 'اعتبارسنجی ناموفق',
        'database_error' => 'خطای پایگاه داده',
        'network_error' => 'خطای شبکه',
        'unknown_error' => 'خطای نامشخص'
    ]
];
?>
PHP
); ?>

<?php _merge_exec('languages/fr.php', <<<'PHP'
<?php
// languages/fr.php - French Language File
// فایل زبان فرانسوی

return [
    // General
    'site_name' => 'Crashify',
    'welcome' => 'Bienvenue',
    'home' => 'Accueil',
    'about' => 'À propos',
    'contact' => 'Contact',
    'login' => 'Connexion',
    'register' => 'Inscription',
    'logout' => 'Déconnexion',
    'dashboard' => 'Tableau de bord',
    'profile' => 'Profil',
    'settings' => 'Paramètres',
    'help' => 'Aide',
    'support' => 'Support',
    'language' => 'Langue',
    'currency' => 'Devise',
    'search' => 'Rechercher',
    'loading' => 'Chargement...',
    'error' => 'Erreur',
    'success' => 'Succès',
    'warning' => 'Avertissement',
    'info' => 'Information',
    'close' => 'Fermer',
    'save' => 'Enregistrer',
    'cancel' => 'Annuler',
    'delete' => 'Supprimer',
    'edit' => 'Modifier',
    'view' => 'Voir',
    'back' => 'Retour',
    'next' => 'Suivant',
    'previous' => 'Précédent',
    'submit' => 'Soumettre',
    'confirm' => 'Confirmer',
    'yes' => 'Oui',
    'no' => 'Non',
    'ok' => 'OK',
    'continue' => 'Continuer',
    'finish' => 'Terminer',
    'start' => 'Commencer',
    'stop' => 'Arrêter',
    'pause' => 'Pause',
    'resume' => 'Reprendre',
    'reset' => 'Réinitialiser',
    'refresh' => 'Actualiser',
    'update' => 'Mettre à jour',
    'upgrade' => 'Mise à niveau',
    'download' => 'Télécharger',
    'upload' => 'Téléverser',
    'share' => 'Partager',
    'copy' => 'Copier',
    'print' => 'Imprimer',
    'export' => 'Exporter',
    'import' => 'Importer',
    
    // Navigation
    'nav_home' => 'Accueil',
    'nav_casino' => 'Casino',
    'nav_sports' => 'Sports',
    'nav_live' => 'En direct',
    'nav_promotions' => 'Promotions',
    'nav_wallet' => 'Portefeuille',
    'nav_history' => 'Historique',
    'nav_support' => 'Support',
    
    // Authentication
    'auth_login_title' => 'Connectez-vous à votre compte',
    'auth_register_title' => 'Créer un nouveau compte',
    'auth_email' => 'E-mail',
    'auth_password' => 'Mot de passe',
    'auth_confirm_password' => 'Confirmer le mot de passe',
    'auth_remember_me' => 'Se souvenir de moi',
    'auth_forgot_password' => 'Mot de passe oublié ?',
    'auth_no_account' => 'Pas de compte ?',
    'auth_have_account' => 'Déjà un compte ?',
    'auth_create_account' => 'Créer un compte',
    'auth_login_now' => 'Se connecter maintenant',
    'auth_first_name' => 'Prénom',
    'auth_last_name' => 'Nom de famille',
    'auth_phone' => 'Numéro de téléphone',
    'auth_birth_date' => 'Date de naissance',
    'auth_country' => 'Pays',
    'auth_city' => 'Ville',
    'auth_address' => 'Adresse',
    'auth_agree_terms' => 'J\'accepte les conditions générales',
    'auth_agree_privacy' => 'J\'accepte la politique de confidentialité',
    'auth_login_success' => 'Connexion réussie',
    'auth_register_success' => 'Compte créé avec succès',
    'auth_logout_success' => 'Déconnexion réussie',
    'auth_invalid_credentials' => 'Identifiants invalides',
    'auth_email_exists' => 'E-mail déjà utilisé',
    'auth_weak_password' => 'Mot de passe faible',
    'auth_password_mismatch' => 'Les mots de passe ne correspondent pas',
    
    // Dashboard
    'dashboard_welcome' => 'Bienvenue, {name}',
    'dashboard_balance' => 'Solde',
    'dashboard_total_bets' => 'Total des paris',
    'dashboard_total_wins' => 'Total des gains',
    'dashboard_win_rate' => 'Taux de victoire',
    'dashboard_recent_games' => 'Jeux récents',
    'dashboard_quick_deposit' => 'Dépôt rapide',
    'dashboard_quick_withdraw' => 'Retrait rapide',
    'dashboard_notifications' => 'Notifications',
    'dashboard_no_notifications' => 'Aucune nouvelle notification',
    'dashboard_view_all' => 'Voir tout',
    
    // Games
    'games_crash' => 'Crash',
    'games_slots' => 'Machines à sous',
    'games_blackjack' => 'Blackjack',
    'games_roulette' => 'Roulette',
    'games_baccarat' => 'Baccarat',
    'games_poker' => 'Poker',
    'games_dice' => 'Dés',
    'games_mines' => 'Mines',
    'games_plinko' => 'Plinko',
    'games_wheel' => 'Roue',
    'games_keno' => 'Keno',
    'games_scratch' => 'Cartes à gratter',
    'games_play_now' => 'Jouer maintenant',
    'games_demo_mode' => 'Mode démo',
    'games_real_mode' => 'Mode réel',
    'games_min_bet' => 'Mise min.',
    'games_max_bet' => 'Mise max.',
    'games_max_win' => 'Gain max.',
    'games_rtp' => 'Taux de retour',
    'games_volatility' => 'Volatilité',
    'games_provider' => 'Fournisseur',
    
    // Betting
    'bet_amount' => 'Montant du pari',
    'bet_place' => 'Placer le pari',
    'bet_cancel' => 'Annuler le pari',
    'bet_cashout' => 'Encaisser',
    'bet_auto' => 'Pari automatique',
    'bet_manual' => 'Pari manuel',
    'bet_multiplier' => 'Multiplicateur',
    'bet_profit' => 'Profit',
    'bet_loss' => 'Perte',
    'bet_win' => 'Gain',
    'bet_pending' => 'En attente',
    'bet_settled' => 'Réglé',
    'bet_void' => 'Annulé',
    'bet_history' => 'Historique des paris',
    'bet_statistics' => 'Statistiques des paris',
    'bet_limits' => 'Limites de paris',
    'bet_responsible' => 'Jeu responsable',
    
    // Wallet
    'wallet_balance' => 'Solde du portefeuille',
    'wallet_deposit' => 'Dépôt',
    'wallet_withdraw' => 'Retrait',
    'wallet_transfer' => 'Transfert',
    'wallet_history' => 'Historique du portefeuille',
    'wallet_pending' => 'En attente',
    'wallet_completed' => 'Terminé',
    'wallet_failed' => 'Échoué',
    'wallet_cancelled' => 'Annulé',
    'wallet_min_deposit' => 'Dépôt min.',
    'wallet_max_deposit' => 'Dépôt max.',
    'wallet_min_withdraw' => 'Retrait min.',
    'wallet_max_withdraw' => 'Retrait max.',
    'wallet_fee' => 'Frais',
    'wallet_processing_time' => 'Temps de traitement',
    'wallet_payment_method' => 'Méthode de paiement',
    'wallet_card' => 'Carte',
    'wallet_bank' => 'Banque',
    'wallet_crypto' => 'Cryptomonnaie',
    'wallet_ewallet' => 'Portefeuille électronique',
    
    // Sports Betting
    'sports_football' => 'Football',
    'sports_basketball' => 'Basketball',
    'sports_tennis' => 'Tennis',
    'sports_baseball' => 'Baseball',
    'sports_hockey' => 'Hockey',
    'sports_soccer' => 'Football américain',
    'sports_boxing' => 'Boxe',
    'sports_mma' => 'Arts martiaux mixtes',
    'sports_cricket' => 'Cricket',
    'sports_rugby' => 'Rugby',
    'sports_golf' => 'Golf',
    'sports_racing' => 'Course',
    'sports_esports' => 'E-sport',
    'sports_live_betting' => 'Paris en direct',
    'sports_pre_match' => 'Avant-match',
    'sports_odds' => 'Cotes',
    'sports_handicap' => 'Handicap',
    'sports_over_under' => 'Plus/Moins',
    'sports_both_teams_score' => 'Les deux équipes marquent',
    'sports_correct_score' => 'Score exact',
    'sports_first_goal' => 'Premier but',
    'sports_match_winner' => 'Vainqueur du match',
    'sports_tournament_winner' => 'Vainqueur du tournoi',
    
    // Promotions
    'promo_welcome_bonus' => 'Bonus de bienvenue',
    'promo_deposit_bonus' => 'Bonus de dépôt',
    'promo_reload_bonus' => 'Bonus de rechargement',
    'promo_cashback' => 'Remboursement',
    'promo_free_spins' => 'Tours gratuits',
    'promo_free_bet' => 'Pari gratuit',
    'promo_tournament' => 'Tournoi',
    'promo_loyalty' => 'Programme de fidélité',
    'promo_vip' => 'Programme VIP',
    'promo_refer_friend' => 'Parrainer un ami',
    'promo_code' => 'Code promo',
    'promo_terms' => 'Conditions de la promotion',
    'promo_wagering' => 'Conditions de mise',
    'promo_expiry' => 'Date d\'expiration',
    'promo_claim' => 'Réclamer',
    'promo_claimed' => 'Réclamé',
    'promo_expired' => 'Expiré',
    'promo_active' => 'Actif',
    'promo_completed' => 'Terminé',
    
    // Profile
    'profile_personal_info' => 'Informations personnelles',
    'profile_account_settings' => 'Paramètres du compte',
    'profile_security' => 'Sécurité',
    'profile_preferences' => 'Préférences',
    'profile_verification' => 'Vérification',
    'profile_documents' => 'Documents',
    'profile_limits' => 'Limites',
    'profile_self_exclusion' => 'Auto-exclusion',
    'profile_responsible_gaming' => 'Jeu responsable',
    'profile_notifications' => 'Notifications',
    'profile_privacy' => 'Confidentialité',
    'profile_change_password' => 'Changer le mot de passe',
    'profile_two_factor' => 'Authentification à deux facteurs',
    'profile_login_history' => 'Historique de connexion',
    'profile_device_management' => 'Gestion des appareils',
    
    // Support
    'support_contact' => 'Nous contacter',
    'support_live_chat' => 'Chat en direct',
    'support_email' => 'E-mail',
    'support_phone' => 'Téléphone',
    'support_faq' => 'Questions fréquentes',
    'support_help_center' => 'Centre d\'aide',
    'support_ticket' => 'Ticket de support',
    'support_create_ticket' => 'Créer un ticket',
    'support_ticket_status' => 'Statut du ticket',
    'support_priority' => 'Priorité',
    'support_category' => 'Catégorie',
    'support_subject' => 'Sujet',
    'support_message' => 'Message',
    'support_attachment' => 'Pièce jointe',
    'support_response' => 'Réponse',
    'support_resolved' => 'Résolu',
    'support_pending' => 'En attente',
    'support_closed' => 'Fermé',
    
    // Notifications
    'notif_new_message' => 'Nouveau message',
    'notif_deposit_success' => 'Dépôt réussi',
    'notif_withdraw_success' => 'Retrait réussi',
    'notif_bet_won' => 'Pari gagné !',
    'notif_bet_lost' => 'Pari perdu',
    'notif_bonus_received' => 'Bonus reçu',
    'notif_promotion_available' => 'Promotion disponible',
    'notif_account_verified' => 'Compte vérifié',
    'notif_security_alert' => 'Alerte de sécurité',
    'notif_maintenance' => 'Maintenance du système',
    'notif_mark_read' => 'Marquer comme lu',
    'notif_mark_all_read' => 'Tout marquer comme lu',
    'notif_delete' => 'Supprimer la notification',
    'notif_settings' => 'Paramètres de notification',
    
    // Errors
    'error_404' => 'Page non trouvée',
    'error_500' => 'Erreur du serveur',
    'error_403' => 'Accès refusé',
    'error_401' => 'Non autorisé',
    'error_400' => 'Requête invalide',
    'error_network' => 'Erreur réseau',
    'error_timeout' => 'Délai d\'attente dépassé',
    'error_invalid_input' => 'Saisie invalide',
    'error_required_field' => 'Ce champ est requis',
    'error_invalid_email' => 'E-mail invalide',
    'error_invalid_phone' => 'Numéro de téléphone invalide',
    'error_min_length' => 'Longueur minimale {min} caractères',
    'error_max_length' => 'Longueur maximale {max} caractères',
    'error_min_value' => 'Valeur minimale {min}',
    'error_max_value' => 'Valeur maximale {max}',
    'error_insufficient_balance' => 'Solde insuffisant',
    'error_bet_limit_exceeded' => 'Limite de pari dépassée',
    'error_game_unavailable' => 'Jeu indisponible',
    'error_maintenance' => 'Système en maintenance',
    
    // Success Messages
    'success_saved' => 'Enregistré avec succès',
    'success_updated' => 'Mis à jour avec succès',
    'success_deleted' => 'Supprimé avec succès',
    'success_sent' => 'Envoyé avec succès',
    'success_verified' => 'Vérifié avec succès',
    'success_activated' => 'Activé avec succès',
    'success_deactivated' => 'Désactivé avec succès',
    'success_password_changed' => 'Mot de passe changé avec succès',
    'success_email_sent' => 'E-mail envoyé',
    'success_settings_saved' => 'Paramètres enregistrés',
    
    // Time and Date
    'time_now' => 'maintenant',
    'time_minute_ago' => 'il y a 1 minute',
    'time_minutes_ago' => 'il y a {count} minutes',
    'time_hour_ago' => 'il y a 1 heure',
    'time_hours_ago' => 'il y a {count} heures',
    'time_day_ago' => 'il y a 1 jour',
    'time_days_ago' => 'il y a {count} jours',
    'time_week_ago' => 'il y a 1 semaine',
    'time_weeks_ago' => 'il y a {count} semaines',
    'time_month_ago' => 'il y a 1 mois',
    'time_months_ago' => 'il y a {count} mois',
    'time_year_ago' => 'il y a 1 an',
    'time_years_ago' => 'il y a {count} ans',
    
    // Days of Week
    'day_monday' => 'Lundi',
    'day_tuesday' => 'Mardi',
    'day_wednesday' => 'Mercredi',
    'day_thursday' => 'Jeudi',
    'day_friday' => 'Vendredi',
    'day_saturday' => 'Samedi',
    'day_sunday' => 'Dimanche',
    
    // Months
    'month_january' => 'Janvier',
    'month_february' => 'Février',
    'month_march' => 'Mars',
    'month_april' => 'Avril',
    'month_may' => 'Mai',
    'month_june' => 'Juin',
    'month_july' => 'Juillet',
    'month_august' => 'Août',
    'month_september' => 'Septembre',
    'month_october' => 'Octobre',
    'month_november' => 'Novembre',
    'month_december' => 'Décembre',
    
    // Footer
    'footer_about_us' => 'À propos de nous',
    'footer_terms' => 'Conditions générales',
    'footer_privacy' => 'Politique de confidentialité',
    'footer_responsible_gaming' => 'Jeu responsable',
    'footer_contact' => 'Contact',
    'footer_help' => 'Aide',
    'footer_sitemap' => 'Plan du site',
    'footer_copyright' => '© 2024 Crashify. Tous droits réservés.',
    'footer_license' => 'Licencié et réglementé',
    'footer_18_plus' => '18+ seulement',
    'footer_gamble_responsibly' => 'Jouez de manière responsable',
    
    // Legal
    'legal_terms_title' => 'Conditions générales',
    'legal_privacy_title' => 'Politique de confidentialité',
    'legal_responsible_title' => 'Jeu responsable',
    'legal_aml_title' => 'Lutte contre le blanchiment d\'argent',
    'legal_kyc_title' => 'Connaissance du client',
    'legal_complaints_title' => 'Procédures de plainte',
    'legal_licensing_title' => 'Informations de licence',
    'legal_fairness_title' => 'Équité et transparence',
    
    // Admin
    'admin_dashboard' => 'Tableau de bord admin',
    'admin_users' => 'Utilisateurs',
    'admin_transactions' => 'Transactions',
    'admin_games' => 'Jeux',
    'admin_reports' => 'Rapports',
    'admin_settings' => 'Paramètres',
    'admin_logs' => 'Journaux',
    'admin_security' => 'Sécurité',
    'admin_maintenance' => 'Maintenance',
    'admin_backup' => 'Sauvegarde',
];
?>

PHP
); ?>

<?php _merge_exec('languages/ru.php', <<<'PHP'
<?php
// languages/ru.php - Russian Language File
// فایل زبان روسی

return [
    // General
    'site_name' => 'Crashify',
    'welcome' => 'Добро пожаловать',
    'home' => 'Главная',
    'about' => 'О нас',
    'contact' => 'Контакты',
    'login' => 'Войти',
    'register' => 'Регистрация',
    'logout' => 'Выйти',
    'dashboard' => 'Панель управления',
    'profile' => 'Профиль',
    'settings' => 'Настройки',
    'help' => 'Помощь',
    'support' => 'Поддержка',
    'language' => 'Язык',
    'currency' => 'Валюта',
    'search' => 'Поиск',
    'loading' => 'Загрузка...',
    'error' => 'Ошибка',
    'success' => 'Успешно',
    'warning' => 'Предупреждение',
    'info' => 'Информация',
    'close' => 'Закрыть',
    'save' => 'Сохранить',
    'cancel' => 'Отмена',
    'delete' => 'Удалить',
    'edit' => 'Редактировать',
    'view' => 'Просмотр',
    'back' => 'Назад',
    'next' => 'Далее',
    'previous' => 'Предыдущий',
    'submit' => 'Отправить',
    'confirm' => 'Подтвердить',
    'yes' => 'Да',
    'no' => 'Нет',
    'ok' => 'ОК',
    'continue' => 'Продолжить',
    'finish' => 'Завершить',
    'start' => 'Начать',
    'stop' => 'Остановить',
    'pause' => 'Пауза',
    'resume' => 'Продолжить',
    'reset' => 'Сбросить',
    'refresh' => 'Обновить',
    'update' => 'Обновить',
    'upgrade' => 'Обновление',
    'download' => 'Скачать',
    'upload' => 'Загрузить',
    'share' => 'Поделиться',
    'copy' => 'Копировать',
    'print' => 'Печать',
    'export' => 'Экспорт',
    'import' => 'Импорт',
    
    // Navigation
    'nav_home' => 'Главная',
    'nav_casino' => 'Казино',
    'nav_sports' => 'Спорт',
    'nav_live' => 'Лайв',
    'nav_promotions' => 'Акции',
    'nav_wallet' => 'Кошелек',
    'nav_history' => 'История',
    'nav_support' => 'Поддержка',
    
    // Authentication
    'auth_login_title' => 'Войти в аккаунт',
    'auth_register_title' => 'Создать новый аккаунт',
    'auth_email' => 'Электронная почта',
    'auth_password' => 'Пароль',
    'auth_confirm_password' => 'Подтвердить пароль',
    'auth_remember_me' => 'Запомнить меня',
    'auth_forgot_password' => 'Забыли пароль?',
    'auth_no_account' => 'Нет аккаунта?',
    'auth_have_account' => 'Уже есть аккаунт?',
    'auth_create_account' => 'Создать аккаунт',
    'auth_login_now' => 'Войти сейчас',
    'auth_first_name' => 'Имя',
    'auth_last_name' => 'Фамилия',
    'auth_phone' => 'Номер телефона',
    'auth_birth_date' => 'Дата рождения',
    'auth_country' => 'Страна',
    'auth_city' => 'Город',
    'auth_address' => 'Адрес',
    'auth_agree_terms' => 'Я согласен с условиями использования',
    'auth_agree_privacy' => 'Я согласен с политикой конфиденциальности',
    'auth_login_success' => 'Успешный вход в систему',
    'auth_register_success' => 'Аккаунт успешно создан',
    'auth_logout_success' => 'Успешный выход из системы',
    'auth_invalid_credentials' => 'Неверные учетные данные',
    'auth_email_exists' => 'Электронная почта уже используется',
    'auth_weak_password' => 'Слабый пароль',
    'auth_password_mismatch' => 'Пароли не совпадают',
    
    // Dashboard
    'dashboard_welcome' => 'Добро пожаловать, {name}',
    'dashboard_balance' => 'Баланс',
    'dashboard_total_bets' => 'Всего ставок',
    'dashboard_total_wins' => 'Всего выигрышей',
    'dashboard_win_rate' => 'Процент побед',
    'dashboard_recent_games' => 'Последние игры',
    'dashboard_quick_deposit' => 'Быстрый депозит',
    'dashboard_quick_withdraw' => 'Быстрый вывод',
    'dashboard_notifications' => 'Уведомления',
    'dashboard_no_notifications' => 'Нет новых уведомлений',
    'dashboard_view_all' => 'Посмотреть все',
    
    // Games
    'games_crash' => 'Краш',
    'games_slots' => 'Слоты',
    'games_blackjack' => 'Блэкджек',
    'games_roulette' => 'Рулетка',
    'games_baccarat' => 'Баккара',
    'games_poker' => 'Покер',
    'games_dice' => 'Кости',
    'games_mines' => 'Мины',
    'games_plinko' => 'Плинко',
    'games_wheel' => 'Колесо',
    'games_keno' => 'Кено',
    'games_scratch' => 'Скретч-карты',
    'games_play_now' => 'Играть сейчас',
    'games_demo_mode' => 'Демо режим',
    'games_real_mode' => 'Реальный режим',
    'games_min_bet' => 'Мин. ставка',
    'games_max_bet' => 'Макс. ставка',
    'games_max_win' => 'Макс. выигрыш',
    'games_rtp' => 'Возврат игроку',
    'games_volatility' => 'Волатильность',
    'games_provider' => 'Провайдер',
    
    // Betting
    'bet_amount' => 'Сумма ставки',
    'bet_place' => 'Сделать ставку',
    'bet_cancel' => 'Отменить ставку',
    'bet_cashout' => 'Забрать выигрыш',
    'bet_auto' => 'Авто ставка',
    'bet_manual' => 'Ручная ставка',
    'bet_multiplier' => 'Множитель',
    'bet_profit' => 'Прибыль',
    'bet_loss' => 'Проигрыш',
    'bet_win' => 'Выигрыш',
    'bet_pending' => 'В ожидании',
    'bet_settled' => 'Рассчитана',
    'bet_void' => 'Отменена',
    'bet_history' => 'История ставок',
    'bet_statistics' => 'Статистика ставок',
    'bet_limits' => 'Лимиты ставок',
    'bet_responsible' => 'Ответственная игра',
    
    // Wallet
    'wallet_balance' => 'Баланс кошелька',
    'wallet_deposit' => 'Депозит',
    'wallet_withdraw' => 'Вывод',
    'wallet_transfer' => 'Перевод',
    'wallet_history' => 'История кошелька',
    'wallet_pending' => 'В ожидании',
    'wallet_completed' => 'Завершено',
    'wallet_failed' => 'Неудачно',
    'wallet_cancelled' => 'Отменено',
    'wallet_min_deposit' => 'Мин. депозит',
    'wallet_max_deposit' => 'Макс. депозит',
    'wallet_min_withdraw' => 'Мин. вывод',
    'wallet_max_withdraw' => 'Макс. вывод',
    'wallet_fee' => 'Комиссия',
    'wallet_processing_time' => 'Время обработки',
    'wallet_payment_method' => 'Способ оплаты',
    'wallet_card' => 'Карта',
    'wallet_bank' => 'Банк',
    'wallet_crypto' => 'Криптовалюта',
    'wallet_ewallet' => 'Электронный кошелек',
    
    // Sports Betting
    'sports_football' => 'Футбол',
    'sports_basketball' => 'Баскетбол',
    'sports_tennis' => 'Теннис',
    'sports_baseball' => 'Бейсбол',
    'sports_hockey' => 'Хоккей',
    'sports_soccer' => 'Американский футбол',
    'sports_boxing' => 'Бокс',
    'sports_mma' => 'Смешанные единоборства',
    'sports_cricket' => 'Крикет',
    'sports_rugby' => 'Регби',
    'sports_golf' => 'Гольф',
    'sports_racing' => 'Гонки',
    'sports_esports' => 'Киберспорт',
    'sports_live_betting' => 'Лайв ставки',
    'sports_pre_match' => 'До матча',
    'sports_odds' => 'Коэффициенты',
    'sports_handicap' => 'Гандикап',
    'sports_over_under' => 'Больше/Меньше',
    'sports_both_teams_score' => 'Обе команды забьют',
    'sports_correct_score' => 'Точный счет',
    'sports_first_goal' => 'Первый гол',
    'sports_match_winner' => 'Победитель матча',
    'sports_tournament_winner' => 'Победитель турнира',
    
    // Promotions
    'promo_welcome_bonus' => 'Приветственный бонус',
    'promo_deposit_bonus' => 'Бонус на депозит',
    'promo_reload_bonus' => 'Бонус на пополнение',
    'promo_cashback' => 'Кэшбэк',
    'promo_free_spins' => 'Бесплатные вращения',
    'promo_free_bet' => 'Бесплатная ставка',
    'promo_tournament' => 'Турнир',
    'promo_loyalty' => 'Программа лояльности',
    'promo_vip' => 'VIP программа',
    'promo_refer_friend' => 'Пригласить друга',
    'promo_code' => 'Промокод',
    'promo_terms' => 'Условия акции',
    'promo_wagering' => 'Требования по отыгрышу',
    'promo_expiry' => 'Срок действия',
    'promo_claim' => 'Получить',
    'promo_claimed' => 'Получено',
    'promo_expired' => 'Истек',
    'promo_active' => 'Активный',
    'promo_completed' => 'Завершен',
    
    // Profile
    'profile_personal_info' => 'Личная информация',
    'profile_account_settings' => 'Настройки аккаунта',
    'profile_security' => 'Безопасность',
    'profile_preferences' => 'Предпочтения',
    'profile_verification' => 'Верификация',
    'profile_documents' => 'Документы',
    'profile_limits' => 'Лимиты',
    'profile_self_exclusion' => 'Самоисключение',
    'profile_responsible_gaming' => 'Ответственная игра',
    'profile_notifications' => 'Уведомления',
    'profile_privacy' => 'Конфиденциальность',
    'profile_change_password' => 'Изменить пароль',
    'profile_two_factor' => 'Двухфакторная аутентификация',
    'profile_login_history' => 'История входов',
    'profile_device_management' => 'Управление устройствами',
    
    // Support
    'support_contact' => 'Связаться с нами',
    'support_live_chat' => 'Онлайн чат',
    'support_email' => 'Электронная почта',
    'support_phone' => 'Телефон',
    'support_faq' => 'Часто задаваемые вопросы',
    'support_help_center' => 'Центр помощи',
    'support_ticket' => 'Тикет поддержки',
    'support_create_ticket' => 'Создать тикет',
    'support_ticket_status' => 'Статус тикета',
    'support_priority' => 'Приоритет',
    'support_category' => 'Категория',
    'support_subject' => 'Тема',
    'support_message' => 'Сообщение',
    'support_attachment' => 'Вложение',
    'support_response' => 'Ответ',
    'support_resolved' => 'Решен',
    'support_pending' => 'В ожидании',
    'support_closed' => 'Закрыт',
    
    // Notifications
    'notif_new_message' => 'Новое сообщение',
    'notif_deposit_success' => 'Депозит успешно зачислен',
    'notif_withdraw_success' => 'Вывод успешно обработан',
    'notif_bet_won' => 'Вы выиграли ставку!',
    'notif_bet_lost' => 'Вы проиграли ставку',
    'notif_bonus_received' => 'Бонус получен',
    'notif_promotion_available' => 'Доступна акция',
    'notif_account_verified' => 'Аккаунт верифицирован',
    'notif_security_alert' => 'Предупреждение безопасности',
    'notif_maintenance' => 'Техническое обслуживание',
    'notif_mark_read' => 'Отметить как прочитанное',
    'notif_mark_all_read' => 'Отметить все как прочитанные',
    'notif_delete' => 'Удалить уведомление',
    'notif_settings' => 'Настройки уведомлений',
    
    // Errors
    'error_404' => 'Страница не найдена',
    'error_500' => 'Ошибка сервера',
    'error_403' => 'Доступ запрещен',
    'error_401' => 'Не авторизован',
    'error_400' => 'Неверный запрос',
    'error_network' => 'Ошибка сети',
    'error_timeout' => 'Время ожидания истекло',
    'error_invalid_input' => 'Неверный ввод',
    'error_required_field' => 'Это поле обязательно',
    'error_invalid_email' => 'Неверный email',
    'error_invalid_phone' => 'Неверный номер телефона',
    'error_min_length' => 'Минимальная длина {min} символов',
    'error_max_length' => 'Максимальная длина {max} символов',
    'error_min_value' => 'Минимальное значение {min}',
    'error_max_value' => 'Максимальное значение {max}',
    'error_insufficient_balance' => 'Недостаточно средств',
    'error_bet_limit_exceeded' => 'Превышен лимит ставки',
    'error_game_unavailable' => 'Игра недоступна',
    'error_maintenance' => 'Система на обслуживании',
    
    // Success Messages
    'success_saved' => 'Успешно сохранено',
    'success_updated' => 'Успешно обновлено',
    'success_deleted' => 'Успешно удалено',
    'success_sent' => 'Успешно отправлено',
    'success_verified' => 'Успешно верифицировано',
    'success_activated' => 'Успешно активировано',
    'success_deactivated' => 'Успешно деактивировано',
    'success_password_changed' => 'Пароль успешно изменен',
    'success_email_sent' => 'Email отправлен',
    'success_settings_saved' => 'Настройки сохранены',
    
    // Time and Date
    'time_now' => 'сейчас',
    'time_minute_ago' => '1 минуту назад',
    'time_minutes_ago' => '{count} минут назад',
    'time_hour_ago' => '1 час назад',
    'time_hours_ago' => '{count} часов назад',
    'time_day_ago' => '1 день назад',
    'time_days_ago' => '{count} дней назад',
    'time_week_ago' => '1 неделю назад',
    'time_weeks_ago' => '{count} недель назад',
    'time_month_ago' => '1 месяц назад',
    'time_months_ago' => '{count} месяцев назад',
    'time_year_ago' => '1 год назад',
    'time_years_ago' => '{count} лет назад',
    
    // Days of Week
    'day_monday' => 'Понедельник',
    'day_tuesday' => 'Вторник',
    'day_wednesday' => 'Среда',
    'day_thursday' => 'Четверг',
    'day_friday' => 'Пятница',
    'day_saturday' => 'Суббота',
    'day_sunday' => 'Воскресенье',
    
    // Months
    'month_january' => 'Январь',
    'month_february' => 'Февраль',
    'month_march' => 'Март',
    'month_april' => 'Апрель',
    'month_may' => 'Май',
    'month_june' => 'Июнь',
    'month_july' => 'Июль',
    'month_august' => 'Август',
    'month_september' => 'Сентябрь',
    'month_october' => 'Октябрь',
    'month_november' => 'Ноябрь',
    'month_december' => 'Декабрь',
    
    // Footer
    'footer_about_us' => 'О нас',
    'footer_terms' => 'Условия использования',
    'footer_privacy' => 'Политика конфиденциальности',
    'footer_responsible_gaming' => 'Ответственная игра',
    'footer_contact' => 'Контакты',
    'footer_help' => 'Помощь',
    'footer_sitemap' => 'Карта сайта',
    'footer_copyright' => '© 2024 Crashify. Все права защищены.',
    'footer_license' => 'Лицензировано и регулируется',
    'footer_18_plus' => 'Только 18+',
    'footer_gamble_responsibly' => 'Играйте ответственно',
    
    // Legal
    'legal_terms_title' => 'Условия использования',
    'legal_privacy_title' => 'Политика конфиденциальности',
    'legal_responsible_title' => 'Ответственная игра',
    'legal_aml_title' => 'Противодействие отмыванию денег',
    'legal_kyc_title' => 'Знай своего клиента',
    'legal_complaints_title' => 'Процедуры жалоб',
    'legal_licensing_title' => 'Информация о лицензии',
    'legal_fairness_title' => 'Справедливость и прозрачность',
    
    // Admin
    'admin_dashboard' => 'Панель администратора',
    'admin_users' => 'Пользователи',
    'admin_transactions' => 'Транзакции',
    'admin_games' => 'Игры',
    'admin_reports' => 'Отчеты',
    'admin_settings' => 'Настройки',
    'admin_logs' => 'Логи',
    'admin_security' => 'Безопасность',
    'admin_maintenance' => 'Обслуживание',
    'admin_backup' => 'Резервное копирование',
];
?>

PHP
); ?>

<?php _merge_exec('languages/tr.php', <<<'PHP'
<?php
// languages/tr.php - Turkish Language File
// فایل زبان ترکی

return [
    // General
    'site_name' => 'Crashify',
    'welcome' => 'Hoş geldiniz',
    'home' => 'Ana Sayfa',
    'about' => 'Hakkında',
    'contact' => 'İletişim',
    'login' => 'Giriş Yap',
    'register' => 'Kayıt Ol',
    'logout' => 'Çıkış Yap',
    'dashboard' => 'Kontrol Paneli',
    'profile' => 'Profil',
    'settings' => 'Ayarlar',
    'help' => 'Yardım',
    'support' => 'Destek',
    'language' => 'Dil',
    'currency' => 'Para Birimi',
    'search' => 'Ara',
    'loading' => 'Yükleniyor...',
    'error' => 'Hata',
    'success' => 'Başarılı',
    'warning' => 'Uyarı',
    'info' => 'Bilgi',
    'close' => 'Kapat',
    'save' => 'Kaydet',
    'cancel' => 'İptal',
    'delete' => 'Sil',
    'edit' => 'Düzenle',
    'view' => 'Görüntüle',
    'back' => 'Geri',
    'next' => 'İleri',
    'previous' => 'Önceki',
    'submit' => 'Gönder',
    'confirm' => 'Onayla',
    'yes' => 'Evet',
    'no' => 'Hayır',
    'ok' => 'Tamam',
    'continue' => 'Devam Et',
    'finish' => 'Bitir',
    'start' => 'Başla',
    'stop' => 'Durdur',
    'pause' => 'Duraklat',
    'resume' => 'Devam Et',
    'reset' => 'Sıfırla',
    'refresh' => 'Yenile',
    'update' => 'Güncelle',
    'upgrade' => 'Yükselt',
    'download' => 'İndir',
    'upload' => 'Yükle',
    'share' => 'Paylaş',
    'copy' => 'Kopyala',
    'print' => 'Yazdır',
    'export' => 'Dışa Aktar',
    'import' => 'İçe Aktar',
    
    // Navigation
    'nav_home' => 'Ana Sayfa',
    'nav_casino' => 'Casino',
    'nav_sports' => 'Spor',
    'nav_live' => 'Canlı',
    'nav_promotions' => 'Promosyonlar',
    'nav_wallet' => 'Cüzdan',
    'nav_history' => 'Geçmiş',
    'nav_support' => 'Destek',
    
    // Authentication
    'auth_login_title' => 'Hesabınıza Giriş Yapın',
    'auth_register_title' => 'Yeni Hesap Oluşturun',
    'auth_email' => 'E-posta',
    'auth_password' => 'Şifre',
    'auth_confirm_password' => 'Şifreyi Onayla',
    'auth_remember_me' => 'Beni Hatırla',
    'auth_forgot_password' => 'Şifrenizi mi unuttunuz?',
    'auth_no_account' => 'Hesabınız yok mu?',
    'auth_have_account' => 'Zaten hesabınız var mı?',
    'auth_create_account' => 'Hesap Oluştur',
    'auth_login_now' => 'Şimdi Giriş Yap',
    'auth_first_name' => 'Ad',
    'auth_last_name' => 'Soyad',
    'auth_phone' => 'Telefon Numarası',
    'auth_birth_date' => 'Doğum Tarihi',
    'auth_country' => 'Ülke',
    'auth_city' => 'Şehir',
    'auth_address' => 'Adres',
    'auth_agree_terms' => 'Şartlar ve Koşulları kabul ediyorum',
    'auth_agree_privacy' => 'Gizlilik Politikasını kabul ediyorum',
    'auth_login_success' => 'Başarıyla giriş yapıldı',
    'auth_register_success' => 'Hesap başarıyla oluşturuldu',
    'auth_logout_success' => 'Başarıyla çıkış yapıldı',
    'auth_invalid_credentials' => 'Geçersiz kimlik bilgileri',
    'auth_email_exists' => 'E-posta zaten kullanımda',
    'auth_weak_password' => 'Şifre çok zayıf',
    'auth_password_mismatch' => 'Şifreler eşleşmiyor',
    
    // Dashboard
    'dashboard_welcome' => 'Hoş geldin, {name}',
    'dashboard_balance' => 'Bakiye',
    'dashboard_total_bets' => 'Toplam Bahis',
    'dashboard_total_wins' => 'Toplam Kazanç',
    'dashboard_win_rate' => 'Kazanma Oranı',
    'dashboard_recent_games' => 'Son Oyunlar',
    'dashboard_quick_deposit' => 'Hızlı Para Yatırma',
    'dashboard_quick_withdraw' => 'Hızlı Para Çekme',
    'dashboard_notifications' => 'Bildirimler',
    'dashboard_no_notifications' => 'Yeni bildirim yok',
    'dashboard_view_all' => 'Tümünü Görüntüle',
    
    // Games
    'games_crash' => 'Crash',
    'games_slots' => 'Slot Makineleri',
    'games_blackjack' => 'Blackjack',
    'games_roulette' => 'Rulet',
    'games_baccarat' => 'Bakara',
    'games_poker' => 'Poker',
    'games_dice' => 'Zar',
    'games_mines' => 'Mayınlar',
    'games_plinko' => 'Plinko',
    'games_wheel' => 'Çark',
    'games_keno' => 'Keno',
    'games_scratch' => 'Kazı Kazan',
    'games_play_now' => 'Şimdi Oyna',
    'games_demo_mode' => 'Demo Modu',
    'games_real_mode' => 'Gerçek Mod',
    'games_min_bet' => 'Min Bahis',
    'games_max_bet' => 'Max Bahis',
    'games_max_win' => 'Max Kazanç',
    'games_rtp' => 'Oyuncuya Dönüş Oranı',
    'games_volatility' => 'Volatilite',
    'games_provider' => 'Sağlayıcı',
    
    // Betting
    'bet_amount' => 'Bahis Miktarı',
    'bet_place' => 'Bahis Yap',
    'bet_cancel' => 'Bahisi İptal Et',
    'bet_cashout' => 'Para Çek',
    'bet_auto' => 'Otomatik Bahis',
    'bet_manual' => 'Manuel Bahis',
    'bet_multiplier' => 'Çarpan',
    'bet_profit' => 'Kar',
    'bet_loss' => 'Kayıp',
    'bet_win' => 'Kazanç',
    'bet_pending' => 'Beklemede',
    'bet_settled' => 'Sonuçlandı',
    'bet_void' => 'İptal',
    'bet_history' => 'Bahis Geçmişi',
    'bet_statistics' => 'Bahis İstatistikleri',
    'bet_limits' => 'Bahis Limitleri',
    'bet_responsible' => 'Sorumlu Bahis',
    
    // Wallet
    'wallet_balance' => 'Cüzdan Bakiyesi',
    'wallet_deposit' => 'Para Yatır',
    'wallet_withdraw' => 'Para Çek',
    'wallet_transfer' => 'Transfer',
    'wallet_history' => 'Cüzdan Geçmişi',
    'wallet_pending' => 'Beklemede',
    'wallet_completed' => 'Tamamlandı',
    'wallet_failed' => 'Başarısız',
    'wallet_cancelled' => 'İptal Edildi',
    'wallet_min_deposit' => 'Min Para Yatırma',
    'wallet_max_deposit' => 'Max Para Yatırma',
    'wallet_min_withdraw' => 'Min Para Çekme',
    'wallet_max_withdraw' => 'Max Para Çekme',
    'wallet_fee' => 'Ücret',
    'wallet_processing_time' => 'İşlem Süresi',
    'wallet_payment_method' => 'Ödeme Yöntemi',
    'wallet_card' => 'Kart',
    'wallet_bank' => 'Banka',
    'wallet_crypto' => 'Kripto Para',
    'wallet_ewallet' => 'E-Cüzdan',
    
    // Sports Betting
    'sports_football' => 'Futbol',
    'sports_basketball' => 'Basketbol',
    'sports_tennis' => 'Tenis',
    'sports_baseball' => 'Beyzbol',
    'sports_hockey' => 'Hokey',
    'sports_soccer' => 'Amerikan Futbolu',
    'sports_boxing' => 'Boks',
    'sports_mma' => 'Karma Dövüş Sanatları',
    'sports_cricket' => 'Kriket',
    'sports_rugby' => 'Ragbi',
    'sports_golf' => 'Golf',
    'sports_racing' => 'Yarış',
    'sports_esports' => 'E-Spor',
    'sports_live_betting' => 'Canlı Bahis',
    'sports_pre_match' => 'Maç Öncesi',
    'sports_odds' => 'Oranlar',
    'sports_handicap' => 'Handikap',
    'sports_over_under' => 'Alt/Üst',
    'sports_both_teams_score' => 'İki Takım da Gol Atar',
    'sports_correct_score' => 'Doğru Skor',
    'sports_first_goal' => 'İlk Gol',
    'sports_match_winner' => 'Maç Galibi',
    'sports_tournament_winner' => 'Turnuva Galibi',
    
    // Promotions
    'promo_welcome_bonus' => 'Hoş Geldin Bonusu',
    'promo_deposit_bonus' => 'Para Yatırma Bonusu',
    'promo_reload_bonus' => 'Yeniden Yükleme Bonusu',
    'promo_cashback' => 'Nakit İade',
    'promo_free_spins' => 'Bedava Çevirme',
    'promo_free_bet' => 'Bedava Bahis',
    'promo_tournament' => 'Turnuva',
    'promo_loyalty' => 'Sadakat Programı',
    'promo_vip' => 'VIP Programı',
    'promo_refer_friend' => 'Arkadaş Davet Et',
    'promo_code' => 'Promosyon Kodu',
    'promo_terms' => 'Promosyon Şartları',
    'promo_wagering' => 'Çevrim Şartları',
    'promo_expiry' => 'Son Kullanma Tarihi',
    'promo_claim' => 'Talep Et',
    'promo_claimed' => 'Talep Edildi',
    'promo_expired' => 'Süresi Doldu',
    'promo_active' => 'Aktif',
    'promo_completed' => 'Tamamlandı',
    
    // Profile
    'profile_personal_info' => 'Kişisel Bilgiler',
    'profile_account_settings' => 'Hesap Ayarları',
    'profile_security' => 'Güvenlik',
    'profile_preferences' => 'Tercihler',
    'profile_verification' => 'Doğrulama',
    'profile_documents' => 'Belgeler',
    'profile_limits' => 'Limitler',
    'profile_self_exclusion' => 'Kendini Dışlama',
    'profile_responsible_gaming' => 'Sorumlu Oyun',
    'profile_notifications' => 'Bildirimler',
    'profile_privacy' => 'Gizlilik',
    'profile_change_password' => 'Şifre Değiştir',
    'profile_two_factor' => 'İki Faktörlü Doğrulama',
    'profile_login_history' => 'Giriş Geçmişi',
    'profile_device_management' => 'Cihaz Yönetimi',
    
    // Support
    'support_contact' => 'İletişime Geç',
    'support_live_chat' => 'Canlı Sohbet',
    'support_email' => 'E-posta',
    'support_phone' => 'Telefon',
    'support_faq' => 'Sık Sorulan Sorular',
    'support_help_center' => 'Yardım Merkezi',
    'support_ticket' => 'Destek Talebi',
    'support_create_ticket' => 'Talep Oluştur',
    'support_ticket_status' => 'Talep Durumu',
    'support_priority' => 'Öncelik',
    'support_category' => 'Kategori',
    'support_subject' => 'Konu',
    'support_message' => 'Mesaj',
    'support_attachment' => 'Ek Dosya',
    'support_response' => 'Yanıt',
    'support_resolved' => 'Çözüldü',
    'support_pending' => 'Beklemede',
    'support_closed' => 'Kapatıldı',
    
    // Notifications
    'notif_new_message' => 'Yeni mesaj',
    'notif_deposit_success' => 'Para yatırma başarılı',
    'notif_withdraw_success' => 'Para çekme başarılı',
    'notif_bet_won' => 'Bahsi kazandınız!',
    'notif_bet_lost' => 'Bahsi kaybettiniz',
    'notif_bonus_received' => 'Bonus alındı',
    'notif_promotion_available' => 'Promosyon mevcut',
    'notif_account_verified' => 'Hesap doğrulandı',
    'notif_security_alert' => 'Güvenlik uyarısı',
    'notif_maintenance' => 'Sistem bakımı',
    'notif_mark_read' => 'Okundu olarak işaretle',
    'notif_mark_all_read' => 'Tümünü okundu olarak işaretle',
    'notif_delete' => 'Bildirimi sil',
    'notif_settings' => 'Bildirim Ayarları',
    
    // Errors
    'error_404' => 'Sayfa bulunamadı',
    'error_500' => 'Sunucu hatası',
    'error_403' => 'Erişim reddedildi',
    'error_401' => 'Yetkisiz',
    'error_400' => 'Hatalı istek',
    'error_network' => 'Ağ hatası',
    'error_timeout' => 'İstek zaman aşımı',
    'error_invalid_input' => 'Geçersiz giriş',
    'error_required_field' => 'Bu alan zorunludur',
    'error_invalid_email' => 'Geçersiz e-posta',
    'error_invalid_phone' => 'Geçersiz telefon numarası',
    'error_min_length' => 'Minimum uzunluk {min} karakter',
    'error_max_length' => 'Maksimum uzunluk {max} karakter',
    'error_min_value' => 'Minimum değer {min}',
    'error_max_value' => 'Maksimum değer {max}',
    'error_insufficient_balance' => 'Yetersiz bakiye',
    'error_bet_limit_exceeded' => 'Bahis limiti aşıldı',
    'error_game_unavailable' => 'Oyun mevcut değil',
    'error_maintenance' => 'Sistem bakımda',
    
    // Success Messages
    'success_saved' => 'Başarıyla kaydedildi',
    'success_updated' => 'Başarıyla güncellendi',
    'success_deleted' => 'Başarıyla silindi',
    'success_sent' => 'Başarıyla gönderildi',
    'success_verified' => 'Başarıyla doğrulandı',
    'success_activated' => 'Başarıyla etkinleştirildi',
    'success_deactivated' => 'Başarıyla devre dışı bırakıldı',
    'success_password_changed' => 'Şifre başarıyla değiştirildi',
    'success_email_sent' => 'E-posta gönderildi',
    'success_settings_saved' => 'Ayarlar kaydedildi',
    
    // Time and Date
    'time_now' => 'şimdi',
    'time_minute_ago' => '1 dakika önce',
    'time_minutes_ago' => '{count} dakika önce',
    'time_hour_ago' => '1 saat önce',
    'time_hours_ago' => '{count} saat önce',
    'time_day_ago' => '1 gün önce',
    'time_days_ago' => '{count} gün önce',
    'time_week_ago' => '1 hafta önce',
    'time_weeks_ago' => '{count} hafta önce',
    'time_month_ago' => '1 ay önce',
    'time_months_ago' => '{count} ay önce',
    'time_year_ago' => '1 yıl önce',
    'time_years_ago' => '{count} yıl önce',
    
    // Days of Week
    'day_monday' => 'Pazartesi',
    'day_tuesday' => 'Salı',
    'day_wednesday' => 'Çarşamba',
    'day_thursday' => 'Perşembe',
    'day_friday' => 'Cuma',
    'day_saturday' => 'Cumartesi',
    'day_sunday' => 'Pazar',
    
    // Months
    'month_january' => 'Ocak',
    'month_february' => 'Şubat',
    'month_march' => 'Mart',
    'month_april' => 'Nisan',
    'month_may' => 'Mayıs',
    'month_june' => 'Haziran',
    'month_july' => 'Temmuz',
    'month_august' => 'Ağustos',
    'month_september' => 'Eylül',
    'month_october' => 'Ekim',
    'month_november' => 'Kasım',
    'month_december' => 'Aralık',
    
    // Footer
    'footer_about_us' => 'Hakkımızda',
    'footer_terms' => 'Şartlar ve Koşullar',
    'footer_privacy' => 'Gizlilik Politikası',
    'footer_responsible_gaming' => 'Sorumlu Oyun',
    'footer_contact' => 'İletişim',
    'footer_help' => 'Yardım',
    'footer_sitemap' => 'Site Haritası',
    'footer_copyright' => '© 2024 Crashify. Tüm hakları saklıdır.',
    'footer_license' => 'Lisanslı ve düzenlenmiş',
    'footer_18_plus' => 'Sadece 18+',
    'footer_gamble_responsibly' => 'Sorumlu oynayın',
    
    // Legal
    'legal_terms_title' => 'Şartlar ve Koşullar',
    'legal_privacy_title' => 'Gizlilik Politikası',
    'legal_responsible_title' => 'Sorumlu Oyun',
    'legal_aml_title' => 'Kara Para Aklamayla Mücadele',
    'legal_kyc_title' => 'Müşterini Tanı',
    'legal_complaints_title' => 'Şikayet Prosedürleri',
    'legal_licensing_title' => 'Lisans Bilgileri',
    'legal_fairness_title' => 'Adalet ve Şeffaflık',
    
    // Admin
    'admin_dashboard' => 'Yönetici Paneli',
    'admin_users' => 'Kullanıcılar',
    'admin_transactions' => 'İşlemler',
    'admin_games' => 'Oyunlar',
    'admin_reports' => 'Raporlar',
    'admin_settings' => 'Ayarlar',
    'admin_logs' => 'Günlükler',
    'admin_security' => 'Güvenlik',
    'admin_maintenance' => 'Bakım',
    'admin_backup' => 'Yedekleme',
];
?>
PHP
); ?>

<?php _merge_exec('pages/ profile.php', <<<'PHP'
<?php
// pages/profile.php - User Profile Page
// صفحه پروفایل کاربر

require_once '../includes/auth.php';
require_once '../includes/functions.php';

// Check if user is logged in
if (!isLoggedIn()) {
    header('Location: /auth/login.php');
    exit;
}

$user_id = $_SESSION['user_id'];
$page_title = 'پروفایل کاربری';
$current_page = 'profile';

// Handle form submissions
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update_profile'])) {
        // Update profile information
        $first_name = sanitizeInput($_POST['first_name']);
        $last_name = sanitizeInput($_POST['last_name']);
        $email = sanitizeInput($_POST['email']);
        $phone = sanitizeInput($_POST['phone']);
        $birth_date = sanitizeInput($_POST['birth_date']);
        $country = sanitizeInput($_POST['country']);
        $city = sanitizeInput($_POST['city']);
        
        // Validate email
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $error_message = 'ایمیل نامعتبر است';
        } else {
            // Check if email already exists for another user
            $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ? AND id != ?");
            $stmt->execute([$email, $user_id]);
            
            if ($stmt->rowCount() > 0) {
                $error_message = 'این ایمیل قبلاً استفاده شده است';
            } else {
                // Update user profile
                $stmt = $pdo->prepare("
                    UPDATE users SET 
                        first_name = ?, last_name = ?, email = ?, phone = ?, 
                        birth_date = ?, country = ?, city = ?, updated_at = NOW()
                    WHERE id = ?
                ");
                
                if ($stmt->execute([$first_name, $last_name, $email, $phone, $birth_date, $country, $city, $user_id])) {
                    $success_message = 'اطلاعات پروفایل با موفقیت به‌روزرسانی شد';
                    
                    // Update session data
                    $_SESSION['user_name'] = $first_name . ' ' . $last_name;
                    $_SESSION['user_email'] = $email;
                } else {
                    $error_message = 'خطا در به‌روزرسانی اطلاعات';
                }
            }
        }
    }
    
    if (isset($_POST['change_password'])) {
        // Change password
        $current_password = $_POST['current_password'];
        $new_password = $_POST['new_password'];
        $confirm_password = $_POST['confirm_password'];
        
        // Validate passwords
        if (strlen($new_password) < 6) {
            $error_message = 'رمز عبور جدید باید حداقل 6 کاراکتر باشد';
        } elseif ($new_password !== $confirm_password) {
            $error_message = 'تکرار رمز عبور مطابقت ندارد';
        } else {
            // Verify current password
            $stmt = $pdo->prepare("SELECT password FROM users WHERE id = ?");
            $stmt->execute([$user_id]);
            $user = $stmt->fetch();
            
            if (!password_verify($current_password, $user['password'])) {
                $error_message = 'رمز عبور فعلی اشتباه است';
            } else {
                // Update password
                $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                $stmt = $pdo->prepare("UPDATE users SET password = ?, updated_at = NOW() WHERE id = ?");
                
                if ($stmt->execute([$hashed_password, $user_id])) {
                    $success_message = 'رمز عبور با موفقیت تغییر کرد';
                } else {
                    $error_message = 'خطا در تغییر رمز عبور';
                }
            }
        }
    }
    
    if (isset($_POST['update_preferences'])) {
        // Update user preferences
        $language = sanitizeInput($_POST['language']);
        $timezone = sanitizeInput($_POST['timezone']);
        $currency = sanitizeInput($_POST['currency']);
        $notifications_email = isset($_POST['notifications_email']) ? 1 : 0;
        $notifications_sms = isset($_POST['notifications_sms']) ? 1 : 0;
        $notifications_push = isset($_POST['notifications_push']) ? 1 : 0;
        $two_factor_enabled = isset($_POST['two_factor_enabled']) ? 1 : 0;
        
        // Update preferences
        $stmt = $pdo->prepare("
            UPDATE users SET 
                language = ?, timezone = ?, currency = ?, 
                notifications_email = ?, notifications_sms = ?, notifications_push = ?,
                two_factor_enabled = ?, updated_at = NOW()
            WHERE id = ?
        ");
        
        if ($stmt->execute([$language, $timezone, $currency, $notifications_email, $notifications_sms, $notifications_push, $two_factor_enabled, $user_id])) {
            $success_message = 'تنظیمات با موفقیت به‌روزرسانی شد';
            $_SESSION['user_language'] = $language;
        } else {
            $error_message = 'خطا در به‌روزرسانی تنظیمات';
        }
    }
    
    if (isset($_POST['upload_avatar'])) {
        // Handle avatar upload
        if (isset($_FILES['avatar']) && $_FILES['avatar']['error'] === UPLOAD_ERR_OK) {
            $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
            $max_size = 2 * 1024 * 1024; // 2MB
            
            if (!in_array($_FILES['avatar']['type'], $allowed_types)) {
                $error_message = 'فرمت فایل مجاز نیست. فقط JPG، PNG و GIF مجاز است';
            } elseif ($_FILES['avatar']['size'] > $max_size) {
                $error_message = 'حجم فایل نباید بیشتر از 2 مگابایت باشد';
            } else {
                $upload_dir = '../uploads/avatars/';
                if (!is_dir($upload_dir)) {
                    mkdir($upload_dir, 0755, true);
                }
                
                $file_extension = pathinfo($_FILES['avatar']['name'], PATHINFO_EXTENSION);
                $new_filename = 'avatar_' . $user_id . '_' . time() . '.' . $file_extension;
                $upload_path = $upload_dir . $new_filename;
                
                if (move_uploaded_file($_FILES['avatar']['tmp_name'], $upload_path)) {
                    // Delete old avatar if exists
                    $stmt = $pdo->prepare("SELECT avatar FROM users WHERE id = ?");
                    $stmt->execute([$user_id]);
                    $old_avatar = $stmt->fetchColumn();
                    
                    if ($old_avatar && file_exists('../uploads/avatars/' . $old_avatar)) {
                        unlink('../uploads/avatars/' . $old_avatar);
                    }
                    
                    // Update database
                    $stmt = $pdo->prepare("UPDATE users SET avatar = ?, updated_at = NOW() WHERE id = ?");
                    if ($stmt->execute([$new_filename, $user_id])) {
                        $success_message = 'تصویر پروفایل با موفقیت به‌روزرسانی شد';
                    } else {
                        $error_message = 'خطا در به‌روزرسانی تصویر پروفایل';
                    }
                } else {
                    $error_message = 'خطا در آپلود فایل';
                }
            }
        } else {
            $error_message = 'لطفاً فایل تصویر را انتخاب کنید';
        }
    }
}

// Get user data
$stmt = $pdo->prepare("
    SELECT u.*, 
           COALESCE(SUM(CASE WHEN t.type = 'deposit' AND t.status = 'completed' THEN t.amount ELSE 0 END), 0) as total_deposits,
           COALESCE(SUM(CASE WHEN t.type = 'withdrawal' AND t.status = 'completed' THEN t.amount ELSE 0 END), 0) as total_withdrawals,
           COALESCE(COUNT(DISTINCT b.id), 0) as total_bets,
           COALESCE(SUM(CASE WHEN b.status = 'won' THEN b.payout_amount - b.bet_amount ELSE 0 END), 0) as total_winnings
    FROM users u
    LEFT JOIN transactions t ON u.id = t.user_id
    LEFT JOIN bets b ON u.id = b.user_id
    WHERE u.id = ?
    GROUP BY u.id
");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

// Get recent activity
$stmt = $pdo->prepare("
    (SELECT 'bet' as type, id, bet_amount as amount, game_type as description, status, created_at 
     FROM bets WHERE user_id = ? ORDER BY created_at DESC LIMIT 5)
    UNION ALL
    (SELECT 'transaction' as type, id, amount, type as description, status, created_at 
     FROM transactions WHERE user_id = ? ORDER BY created_at DESC LIMIT 5)
    ORDER BY created_at DESC LIMIT 10
");
$stmt->execute([$user_id, $user_id]);
$recent_activity = $stmt->fetchAll();

// Get verification status
$stmt = $pdo->prepare("SELECT * FROM user_verifications WHERE user_id = ?");
$stmt->execute([$user_id]);
$verification = $stmt->fetch();

include '../includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <!-- Profile Sidebar -->
        <div class="col-lg-3 col-md-4">
            <div class="card profile-sidebar">
                <div class="card-body text-center">
                    <div class="profile-avatar mb-3">
                        <?php if ($user['avatar']): ?>
                            <img src="/uploads/avatars/<?php echo htmlspecialchars($user['avatar']); ?>" 
                                 alt="Avatar" class="rounded-circle" width="120" height="120">
                        <?php else: ?>
                            <div class="avatar-placeholder rounded-circle d-flex align-items-center justify-content-center">
                                <i class="fas fa-user fa-3x text-muted"></i>
                            </div>
                        <?php endif; ?>
                        <div class="avatar-upload mt-2">
                            <form method="POST" enctype="multipart/form-data" class="d-inline">
                                <input type="file" name="avatar" id="avatar-input" accept="image/*" style="display: none;">
                                <label for="avatar-input" class="btn btn-sm btn-outline-primary">
                                    <i class="fas fa-camera"></i> تغییر تصویر
                                </label>
                                <button type="submit" name="upload_avatar" class="btn btn-sm btn-primary" id="upload-btn" style="display: none;">
                                    آپلود
                                </button>
                            </form>
                        </div>
                    </div>
                    
                    <h4><?php echo htmlspecialchars($user['first_name'] . ' ' . $user['last_name']); ?></h4>
                    <p class="text-muted"><?php echo htmlspecialchars($user['email']); ?></p>
                    
                    <div class="profile-stats mt-4">
                        <div class="row text-center">
                            <div class="col-6">
                                <div class="stat-item">
                                    <h5 class="mb-0">$<?php echo number_format($user['balance'], 2); ?></h5>
                                    <small class="text-muted">موجودی</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="stat-item">
                                    <h5 class="mb-0"><?php echo $user['total_bets']; ?></h5>
                                    <small class="text-muted">کل شرط‌ها</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Verification Status -->
                    <div class="verification-status mt-4">
                        <h6>وضعیت تأیید هویت</h6>
                        <div class="verification-items">
                            <div class="verification-item d-flex justify-content-between align-items-center">
                                <span>ایمیل</span>
                                <?php if ($user['email_verified']): ?>
                                    <span class="badge badge-success"><i class="fas fa-check"></i> تأیید شده</span>
                                <?php else: ?>
                                    <span class="badge badge-warning"><i class="fas fa-clock"></i> در انتظار</span>
                                <?php endif; ?>
                            </div>
                            <div class="verification-item d-flex justify-content-between align-items-center">
                                <span>شماره تلفن</span>
                                <?php if ($user['phone_verified']): ?>
                                    <span class="badge badge-success"><i class="fas fa-check"></i> تأیید شده</span>
                                <?php else: ?>
                                    <span class="badge badge-warning"><i class="fas fa-clock"></i> در انتظار</span>
                                <?php endif; ?>
                            </div>
                            <div class="verification-item d-flex justify-content-between align-items-center">
                                <span>مدارک هویتی</span>
                                <?php if ($verification && $verification['identity_status'] === 'approved'): ?>
                                    <span class="badge badge-success"><i class="fas fa-check"></i> تأیید شده</span>
                                <?php elseif ($verification && $verification['identity_status'] === 'pending'): ?>
                                    <span class="badge badge-warning"><i class="fas fa-clock"></i> در انتظار</span>
                                <?php else: ?>
                                    <span class="badge badge-danger"><i class="fas fa-times"></i> تأیید نشده</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Profile Content -->
        <div class="col-lg-9 col-md-8">
            <?php if ($success_message): ?>
                <div class="alert alert-success alert-dismissible fade show">
                    <?php echo $success_message; ?>
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                </div>
            <?php endif; ?>
            
            <?php if ($error_message): ?>
                <div class="alert alert-danger alert-dismissible fade show">
                    <?php echo $error_message; ?>
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                </div>
            <?php endif; ?>
            
            <!-- Profile Tabs -->
            <div class="card">
                <div class="card-header">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#profile-info" role="tab">
                                <i class="fas fa-user"></i> اطلاعات شخصی
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#security" role="tab">
                                <i class="fas fa-shield-alt"></i> امنیت
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#preferences" role="tab">
                                <i class="fas fa-cog"></i> تنظیمات
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#activity" role="tab">
                                <i class="fas fa-history"></i> فعالیت‌ها
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#statistics" role="tab">
                                <i class="fas fa-chart-bar"></i> آمار
                            </a>
                        </li>
                    </ul>
                </div>
                
                <div class="card-body">
                    <div class="tab-content">
                        <!-- Profile Information Tab -->
                        <div class="tab-pane fade show active" id="profile-info" role="tabpanel">
                            <form method="POST" class="profile-form">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="first_name">نام</label>
                                            <input type="text" class="form-control" id="first_name" name="first_name" 
                                                   value="<?php echo htmlspecialchars($user['first_name']); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="last_name">نام خانوادگی</label>
                                            <input type="text" class="form-control" id="last_name" name="last_name" 
                                                   value="<?php echo htmlspecialchars($user['last_name']); ?>" required>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="email">ایمیل</label>
                                            <input type="email" class="form-control" id="email" name="email" 
                                                   value="<?php echo htmlspecialchars($user['email']); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="phone">شماره تلفن</label>
                                            <input type="tel" class="form-control" id="phone" name="phone" 
                                                   value="<?php echo htmlspecialchars($user['phone']); ?>">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="birth_date">تاریخ تولد</label>
                                            <input type="date" class="form-control" id="birth_date" name="birth_date" 
                                                   value="<?php echo $user['birth_date']; ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="country">کشور</label>
                                            <select class="form-control" id="country" name="country">
                                                <option value="">انتخاب کنید</option>
                                                <option value="IR" <?php echo $user['country'] === 'IR' ? 'selected' : ''; ?>>ایران</option>
                                                <option value="US" <?php echo $user['country'] === 'US' ? 'selected' : ''; ?>>آمریکا</option>
                                                <option value="GB" <?php echo $user['country'] === 'GB' ? 'selected' : ''; ?>>انگلستان</option>
                                                <option value="DE" <?php echo $user['country'] === 'DE' ? 'selected' : ''; ?>>آلمان</option>
                                                <option value="FR" <?php echo $user['country'] === 'FR' ? 'selected' : ''; ?>>فرانسه</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="city">شهر</label>
                                            <input type="text" class="form-control" id="city" name="city" 
                                                   value="<?php echo htmlspecialchars($user['city']); ?>">
                                        </div>
                                    </div>
                                </div>
                                
                                <button type="submit" name="update_profile" class="btn btn-primary">
                                    <i class="fas fa-save"></i> ذخیره تغییرات
                                </button>
                            </form>
                        </div>
                        
                        <!-- Security Tab -->
                        <div class="tab-pane fade" id="security" role="tabpanel">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h5><i class="fas fa-key"></i> تغییر رمز عبور</h5>
                                        </div>
                                        <div class="card-body">
                                            <form method="POST" class="password-form">
                                                <div class="form-group">
                                                    <label for="current_password">رمز عبور فعلی</label>
                                                    <input type="password" class="form-control" id="current_password" 
                                                           name="current_password" required>
                                                </div>
                                                <div class="form-group">
                                                    <label for="new_password">رمز عبور جدید</label>
                                                    <input type="password" class="form-control" id="new_password" 
                                                           name="new_password" required minlength="6">
                                                </div>
                                                <div class="form-group">
                                                    <label for="confirm_password">تکرار رمز عبور جدید</label>
                                                    <input type="password" class="form-control" id="confirm_password" 
                                                           name="confirm_password" required minlength="6">
                                                </div>
                                                <button type="submit" name="change_password" class="btn btn-warning">
                                                    <i class="fas fa-lock"></i> تغییر رمز عبور
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h5><i class="fas fa-shield-alt"></i> تنظیمات امنیتی</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="security-item d-flex justify-content-between align-items-center mb-3">
                                                <div>
                                                    <strong>احراز هویت دو مرحله‌ای</strong>
                                                    <br><small class="text-muted">افزایش امنیت حساب کاربری</small>
                                                </div>
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input" id="two-factor" 
                                                           <?php echo $user['two_factor_enabled'] ? 'checked' : ''; ?>>
                                                    <label class="custom-control-label" for="two-factor"></label>
                                                </div>
                                            </div>
                                            
                                            <div class="security-item d-flex justify-content-between align-items-center mb-3">
                                                <div>
                                                    <strong>اعلان ورود</strong>
                                                    <br><small class="text-muted">اطلاع از ورود به حساب</small>
                                                </div>
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input" id="login-alerts" checked>
                                                    <label class="custom-control-label" for="login-alerts"></label>
                                                </div>
                                            </div>
                                            
                                            <div class="recent-logins mt-4">
                                                <h6>آخرین ورودها</h6>
                                                <div class="login-item d-flex justify-content-between">
                                                    <span>دستگاه فعلی</span>
                                                    <span class="text-success">الان</span>
                                                </div>
                                                <div class="login-item d-flex justify-content-between">
                                                    <span>Chrome - Windows</span>
                                                    <span class="text-muted">2 ساعت پیش</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Preferences Tab -->
                        <div class="tab-pane fade" id="preferences" role="tabpanel">
                            <form method="POST" class="preferences-form">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><i class="fas fa-globe"></i> تنظیمات عمومی</h5>
                                            </div>
                                            <div class="card-body">
                                                <div class="form-group">
                                                    <label for="language">زبان</label>
                                                    <select class="form-control" id="language" name="language">
                                                        <option value="fa" <?php echo $user['language'] === 'fa' ? 'selected' : ''; ?>>فارسی</option>
                                                        <option value="en" <?php echo $user['language'] === 'en' ? 'selected' : ''; ?>>English</option>
                                                    </select>
                                                </div>
                                                
                                                <div class="form-group">
                                                    <label for="timezone">منطقه زمانی</label>
                                                    <select class="form-control" id="timezone" name="timezone">
                                                        <option value="Asia/Tehran" <?php echo $user['timezone'] === 'Asia/Tehran' ? 'selected' : ''; ?>>تهران</option>
                                                        <option value="UTC" <?php echo $user['timezone'] === 'UTC' ? 'selected' : ''; ?>>UTC</option>
                                                        <option value="America/New_York" <?php echo $user['timezone'] === 'America/New_York' ? 'selected' : ''; ?>>نیویورک</option>
                                                    </select>
                                                </div>
                                                
                                                <div class="form-group">
                                                    <label for="currency">واحد پول</label>
                                                    <select class="form-control" id="currency" name="currency">
                                                        <option value="USD" <?php echo $user['currency'] === 'USD' ? 'selected' : ''; ?>>دلار آمریکا (USD)</option>
                                                        <option value="EUR" <?php echo $user['currency'] === 'EUR' ? 'selected' : ''; ?>>یورو (EUR)</option>
                                                        <option value="IRR" <?php echo $user['currency'] === 'IRR' ? 'selected' : ''; ?>>ریال ایران (IRR)</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><i class="fas fa-bell"></i> اعلان‌ها</h5>
                                            </div>
                                            <div class="card-body">
                                                <div class="form-group">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" id="notifications_email" 
                                                               name="notifications_email" <?php echo $user['notifications_email'] ? 'checked' : ''; ?>>
                                                        <label class="custom-control-label" for="notifications_email">
                                                            اعلان‌های ایمیل
                                                        </label>
                                                    </div>
                                                </div>
                                                
                                                <div class="form-group">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" id="notifications_sms" 
                                                               name="notifications_sms" <?php echo $user['notifications_sms'] ? 'checked' : ''; ?>>
                                                        <label class="custom-control-label" for="notifications_sms">
                                                            اعلان‌های پیامکی
                                                        </label>
                                                    </div>
                                                </div>
                                                
                                                <div class="form-group">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" id="notifications_push" 
                                                               name="notifications_push" <?php echo $user['notifications_push'] ? 'checked' : ''; ?>>
                                                        <label class="custom-control-label" for="notifications_push">
                                                            اعلان‌های فوری
                                                        </label>
                                                    </div>
                                                </div>
                                                
                                                <div class="form-group">
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" id="two_factor_enabled" 
                                                               name="two_factor_enabled" <?php echo $user['two_factor_enabled'] ? 'checked' : ''; ?>>
                                                        <label class="custom-control-label" for="two_factor_enabled">
                                                            احراز هویت دو مرحله‌ای
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="text-center mt-3">
                                    <button type="submit" name="update_preferences" class="btn btn-primary">
                                        <i class="fas fa-save"></i> ذخیره تنظیمات
                                    </button>
                                </div>
                            </form>
                        </div>
                        
                        <!-- Activity Tab -->
                        <div class="tab-pane fade" id="activity" role="tabpanel">
                            <div class="activity-timeline">
                                <h5><i class="fas fa-history"></i> فعالیت‌های اخیر</h5>
                                
                                <?php if (empty($recent_activity)): ?>
                                    <p class="text-muted text-center">فعالیتی یافت نشد</p>
                                <?php else: ?>
                                    <?php foreach ($recent_activity as $activity): ?>
                                        <div class="activity-item">
                                            <div class="activity-icon">
                                                <?php if ($activity['type'] === 'bet'): ?>
                                                    <i class="fas fa-dice text-primary"></i>
                                                <?php else: ?>
                                                    <i class="fas fa-exchange-alt text-success"></i>
                                                <?php endif; ?>
                                            </div>
                                            <div class="activity-content">
                                                <div class="activity-title">
                                                    <?php if ($activity['type'] === 'bet'): ?>
                                                        شرط <?php echo htmlspecialchars($activity['description']); ?>
                                                    <?php else: ?>
                                                        تراکنش <?php echo htmlspecialchars($activity['description']); ?>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="activity-details">
                                                    <span class="amount">$<?php echo number_format($activity['amount'], 2); ?></span>
                                                    <span class="status badge badge-<?php echo $activity['status'] === 'completed' || $activity['status'] === 'won' ? 'success' : ($activity['status'] === 'pending' ? 'warning' : 'danger'); ?>">
                                                        <?php echo htmlspecialchars($activity['status']); ?>
                                                    </span>
                                                </div>
                                                <div class="activity-time text-muted">
                                                    <?php echo timeAgo($activity['created_at']); ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <!-- Statistics Tab -->
                        <div class="tab-pane fade" id="statistics" role="tabpanel">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="stat-card text-center">
                                        <div class="stat-icon">
                                            <i class="fas fa-arrow-down text-success"></i>
                                        </div>
                                        <div class="stat-value">$<?php echo number_format($user['total_deposits'], 2); ?></div>
                                        <div class="stat-label">کل واریزها</div>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="stat-card text-center">
                                        <div class="stat-icon">
                                            <i class="fas fa-arrow-up text-danger"></i>
                                        </div>
                                        <div class="stat-value">$<?php echo number_format($user['total_withdrawals'], 2); ?></div>
                                        <div class="stat-label">کل برداشت‌ها</div>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="stat-card text-center">
                                        <div class="stat-icon">
                                            <i class="fas fa-dice text-primary"></i>
                                        </div>
                                        <div class="stat-value"><?php echo $user['total_bets']; ?></div>
                                        <div class="stat-label">کل شرط‌ها</div>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="stat-card text-center">
                                        <div class="stat-icon">
                                            <i class="fas fa-trophy text-warning"></i>
                                        </div>
                                        <div class="stat-value">$<?php echo number_format($user['total_winnings'], 2); ?></div>
                                        <div class="stat-label">کل برد</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row mt-4">
                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h5><i class="fas fa-chart-pie"></i> توزیع بازی‌ها</h5>
                                        </div>
                                        <div class="card-body">
                                            <canvas id="gamesChart" width="400" height="200"></canvas>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h5><i class="fas fa-chart-line"></i> روند موجودی</h5>
                                        </div>
                                        <div class="card-body">
                                            <canvas id="balanceChart" width="400" height="200"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.profile-sidebar {
    position: sticky;
    top: 20px;
}

.avatar-placeholder {
    width: 120px;
    height: 120px;
    background: #f8f9fa;
    border: 2px dashed #dee2e6;
    margin: 0 auto;
}

.profile-stats .stat-item {
    padding: 1rem 0;
    border-bottom: 1px solid #eee;
}

.profile-stats .stat-item:last-child {
    border-bottom: none;
}

.verification-items .verification-item {
    padding: 0.5rem 0;
    border-bottom: 1px solid #f8f9fa;
}

.verification-items .verification-item:last-child {
    border-bottom: none;
}

.activity-timeline {
    max-height: 500px;
    overflow-y: auto;
}

.activity-item {
    display: flex;
    align-items: flex-start;
    padding: 1rem 0;
    border-bottom: 1px solid #f8f9fa;
}

.activity-item:last-child {
    border-bottom: none;
}

.activity-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 1rem;
}

.activity-content {
    flex: 1;
}

.activity-title {
    font-weight: 500;
    margin-bottom: 0.25rem;
}

.activity-details {
    margin-bottom: 0.25rem;
}

.activity-details .amount {
    font-weight: 600;
    margin-right: 0.5rem;
}

.stat-card {
    background: #fff;
    border: 1px solid #dee2e6;
    border-radius: 0.5rem;
    padding: 1.5rem;
    margin-bottom: 1rem;
    transition: transform 0.2s;
}

.stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.stat-icon {
    font-size: 2rem;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.stat-label {
    color: #6c757d;
    font-size: 0.875rem;
}

.security-item {
    padding: 1rem 0;
    border-bottom: 1px solid #f8f9fa;
}

.security-item:last-child {
    border-bottom: none;
}

.login-item {
    padding: 0.5rem 0;
    border-bottom: 1px solid #f8f9fa;
}

.login-item:last-child {
    border-bottom: none;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Avatar upload preview
    document.getElementById('avatar-input').addEventListener('change', function(e) {
        if (e.target.files && e.target.files[0]) {
            document.getElementById('upload-btn').style.display = 'inline-block';
        }
    });
    
    // Password confirmation validation
    document.getElementById('confirm_password').addEventListener('input', function() {
        const newPassword = document.getElementById('new_password').value;
        const confirmPassword = this.value;
        
        if (newPassword !== confirmPassword) {
            this.setCustomValidity('رمز عبور مطابقت ندارد');
        } else {
            this.setCustomValidity('');
        }
    });
});
</script>

<?php include '../includes/footer.php'; ?>

PHP
); ?>

<?php _merge_exec('pages/bet-history.php', <<<'PHP'
<?php
// pages/bet-history.php - User Bet History Page
// صفحه تاریخچه شرط‌بندی کاربر

require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// Require authentication
requireAuth();

// Page settings
$pageTitle = 'Bet History - Crashify';
$bodyClass = 'bet-history-page';
$breadcrumbs = [
    ['title' => 'Account', 'url' => '/pages/dashboard.php'],
    ['title' => 'Bet History']
];

// Get filter parameters
$gameType = $_GET['game'] ?? 'all';
$status = $_GET['status'] ?? 'all';
$dateRange = $_GET['date'] ?? 'all';
$page = max(1, intval($_GET['page'] ?? 1));
$limit = 20;
$offset = ($page - 1) * $limit;

// Build WHERE clause
$whereConditions = ["user_id = ?"];
$params = [$currentUser['id']];

if ($gameType !== 'all') {
    $whereConditions[] = "game_type = ?";
    $params[] = $gameType;
}

if ($status !== 'all') {
    $whereConditions[] = "status = ?";
    $params[] = $status;
}

// Date range filter
switch ($dateRange) {
    case 'today':
        $whereConditions[] = "DATE(created_at) = CURDATE()";
        break;
    case 'week':
        $whereConditions[] = "created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)";
        break;
    case 'month':
        $whereConditions[] = "created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)";
        break;
    case 'year':
        $whereConditions[] = "created_at >= DATE_SUB(NOW(), INTERVAL 365 DAY)";
        break;
}

$whereClause = implode(' AND ', $whereConditions);

// Get total count for pagination
$totalBets = fetchValue(
    "SELECT COUNT(*) FROM user_bets WHERE $whereClause",
    $params
);

// Get bets with pagination
$bets = fetchAll(
    "SELECT * FROM user_bets 
     WHERE $whereClause 
     ORDER BY created_at DESC 
     LIMIT $limit OFFSET $offset",
    $params
);

// Calculate pagination
$totalPages = ceil($totalBets / $limit);

// Get summary statistics
$stats = fetchRow(
    "SELECT 
        COUNT(*) as total_bets,
        SUM(bet_amount) as total_wagered,
        SUM(CASE WHEN status = 'won' THEN win_amount ELSE 0 END) as total_winnings,
        SUM(CASE WHEN status = 'won' THEN win_amount - bet_amount ELSE -bet_amount END) as net_profit,
        COUNT(CASE WHEN status = 'won' THEN 1 END) as wins,
        COUNT(CASE WHEN status = 'lost' THEN 1 END) as losses,
        MAX(win_amount) as biggest_win,
        MAX(CASE WHEN status = 'won' THEN win_amount - bet_amount ELSE 0 END) as biggest_profit
     FROM user_bets 
     WHERE $whereClause",
    $params
) ?: [
    'total_bets' => 0,
    'total_wagered' => 0,
    'total_winnings' => 0,
    'net_profit' => 0,
    'wins' => 0,
    'losses' => 0,
    'biggest_win' => 0,
    'biggest_profit' => 0
];

// Game type options
$gameTypes = [
    'all' => 'All Games',
    'crash' => 'Crash Game',
    'sports' => 'Sports Betting',
    'casino' => 'Casino Games',
    'live' => 'Live Betting'
];

// Status options
$statusOptions = [
    'all' => 'All Status',
    'pending' => 'Pending',
    'won' => 'Won',
    'lost' => 'Lost',
    'cancelled' => 'Cancelled',
    'cashed_out' => 'Cashed Out'
];

// Date range options
$dateRangeOptions = [
    'all' => 'All Time',
    'today' => 'Today',
    'week' => 'This Week',
    'month' => 'This Month',
    'year' => 'This Year'
];

include '../includes/header.php';
?>

<!-- Bet History Header -->
<section class="page-header">
    <div class="container">
        <div class="header-content">
            <div class="page-info">
                <h1 class="page-title">
                    <i class="fas fa-history"></i>
                    Bet History
                </h1>
                <p class="page-description">
                    View and analyze your complete betting history and statistics.
                </p>
            </div>
            
            <div class="header-actions">
                <button class="btn btn-outline" onclick="exportBetHistory()">
                    <i class="fas fa-download"></i>
                    Export CSV
                </button>
                <button class="btn btn-primary" onclick="refreshHistory()">
                    <i class="fas fa-sync-alt"></i>
                    Refresh
                </button>
            </div>
        </div>
    </div>
</section>

<!-- Statistics Summary -->
<section class="bet-statistics">
    <div class="container">
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-chart-bar"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo number_format($stats['total_bets']); ?></div>
                    <div class="stat-label">Total Bets</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value">$<?php echo number_format($stats['total_wagered'], 2); ?></div>
                    <div class="stat-label">Total Wagered</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-trophy"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value">$<?php echo number_format($stats['total_winnings'], 2); ?></div>
                    <div class="stat-label">Total Winnings</div>
                </div>
            </div>
            
            <div class="stat-card <?php echo $stats['net_profit'] >= 0 ? 'positive' : 'negative'; ?>">
                <div class="stat-icon">
                    <i class="fas fa-<?php echo $stats['net_profit'] >= 0 ? 'arrow-up' : 'arrow-down'; ?>"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value">
                        <?php echo $stats['net_profit'] >= 0 ? '+' : ''; ?>$<?php echo number_format($stats['net_profit'], 2); ?>
                    </div>
                    <div class="stat-label">Net Profit</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-percentage"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value">
                        <?php echo $stats['total_bets'] > 0 ? round(($stats['wins'] / $stats['total_bets']) * 100, 1) : 0; ?>%
                    </div>
                    <div class="stat-label">Win Rate</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-star"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value">$<?php echo number_format($stats['biggest_win'], 2); ?></div>
                    <div class="stat-label">Biggest Win</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Filters -->
<section class="bet-filters">
    <div class="container">
        <form class="filters-form" method="GET" id="filtersForm">
            <div class="filter-group">
                <label for="gameFilter">Game Type</label>
                <select id="gameFilter" name="game" onchange="applyFilters()">
                    <?php foreach ($gameTypes as $value => $label): ?>
                    <option value="<?php echo $value; ?>" <?php echo $gameType === $value ? 'selected' : ''; ?>>
                        <?php echo $label; ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="filter-group">
                <label for="statusFilter">Status</label>
                <select id="statusFilter" name="status" onchange="applyFilters()">
                    <?php foreach ($statusOptions as $value => $label): ?>
                    <option value="<?php echo $value; ?>" <?php echo $status === $value ? 'selected' : ''; ?>>
                        <?php echo $label; ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="filter-group">
                <label for="dateFilter">Date Range</label>
                <select id="dateFilter" name="date" onchange="applyFilters()">
                    <?php foreach ($dateRangeOptions as $value => $label): ?>
                    <option value="<?php echo $value; ?>" <?php echo $dateRange === $value ? 'selected' : ''; ?>>
                        <?php echo $label; ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="filter-group">
                <button type="button" class="btn btn-outline" onclick="clearFilters()">
                    <i class="fas fa-times"></i>
                    Clear
                </button>
            </div>
        </form>
        
        <div class="results-info">
            <span class="results-count">
                Showing <?php echo count($bets); ?> of <?php echo number_format($totalBets); ?> bets
            </span>
        </div>
    </div>
</section>

<!-- Bet History Table -->
<section class="bet-history-content">
    <div class="container">
        <?php if (empty($bets)): ?>
        <div class="empty-state">
            <div class="empty-icon">
                <i class="fas fa-history"></i>
            </div>
            <h3>No Bets Found</h3>
            <p>You haven't placed any bets matching the current filters.</p>
            <div class="empty-actions">
                <a href="/pages/casino.php" class="btn btn-primary">
                    <i class="fas fa-dice"></i>
                    Start Playing
                </a>
                <button class="btn btn-outline" onclick="clearFilters()">
                    <i class="fas fa-filter"></i>
                    Clear Filters
                </button>
            </div>
        </div>
        <?php else: ?>
        <div class="bets-table-container">
            <table class="bets-table">
                <thead>
                    <tr>
                        <th>Date & Time</th>
                        <th>Game</th>
                        <th>Bet Details</th>
                        <th>Amount</th>
                        <th>Multiplier/Odds</th>
                        <th>Payout</th>
                        <th>Profit/Loss</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($bets as $bet): ?>
                    <tr class="bet-row" data-bet-id="<?php echo $bet['id']; ?>">
                        <td>
                            <div class="bet-date">
                                <div class="date"><?php echo date('M j, Y', strtotime($bet['created_at'])); ?></div>
                                <div class="time"><?php echo date('H:i:s', strtotime($bet['created_at'])); ?></div>
                            </div>
                        </td>
                        
                        <td>
                            <div class="game-info">
                                <div class="game-type">
                                    <i class="fas fa-<?php echo getGameIcon($bet['game_type']); ?>"></i>
                                    <?php echo ucfirst($bet['game_type']); ?>
                                </div>
                                <?php if ($bet['game_details']): ?>
                                <div class="game-details"><?php echo htmlspecialchars($bet['game_details']); ?></div>
                                <?php endif; ?>
                            </div>
                        </td>
                        
                        <td>
                            <div class="bet-details">
                                <?php if ($bet['selection']): ?>
                                <div class="selection"><?php echo htmlspecialchars($bet['selection']); ?></div>
                                <?php endif; ?>
                                <?php if ($bet['market']): ?>
                                <div class="market"><?php echo htmlspecialchars($bet['market']); ?></div>
                                <?php endif; ?>
                            </div>
                        </td>
                        
                        <td>
                            <div class="bet-amount">
                                $<?php echo number_format($bet['bet_amount'], 2); ?>
                            </div>
                        </td>
                        
                        <td>
                            <div class="odds-multiplier">
                                <?php if ($bet['multiplier']): ?>
                                <?php echo number_format($bet['multiplier'], 2); ?>x
                                <?php elseif ($bet['odds']): ?>
                                <?php echo number_format($bet['odds'], 2); ?>
                                <?php else: ?>
                                -
                                <?php endif; ?>
                            </div>
                        </td>
                        
                        <td>
                            <div class="payout-amount">
                                <?php if ($bet['win_amount'] > 0): ?>
                                $<?php echo number_format($bet['win_amount'], 2); ?>
                                <?php else: ?>
                                $0.00
                                <?php endif; ?>
                            </div>
                        </td>
                        
                        <td>
                            <div class="profit-loss <?php echo getProfitClass($bet); ?>">
                                <?php
                                $profit = 0;
                                if ($bet['status'] === 'won') {
                                    $profit = $bet['win_amount'] - $bet['bet_amount'];
                                } elseif ($bet['status'] === 'lost') {
                                    $profit = -$bet['bet_amount'];
                                } elseif ($bet['status'] === 'cashed_out') {
                                    $profit = $bet['win_amount'] - $bet['bet_amount'];
                                }
                                
                                echo ($profit >= 0 ? '+' : '') . '$' . number_format($profit, 2);
                                ?>
                            </div>
                        </td>
                        
                        <td>
                            <span class="status-badge status-<?php echo $bet['status']; ?>">
                                <?php echo getStatusLabel($bet['status']); ?>
                            </span>
                        </td>
                        
                        <td>
                            <div class="bet-actions">
                                <button class="btn btn-outline btn-xs" onclick="viewBetDetails(<?php echo $bet['id']; ?>)">
                                    <i class="fas fa-eye"></i>
                                    View
                                </button>
                                <?php if ($bet['status'] === 'pending'): ?>
                                <button class="btn btn-danger btn-xs" onclick="cancelBet(<?php echo $bet['id']; ?>)">
                                    <i class="fas fa-times"></i>
                                    Cancel
                                </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <?php if ($totalPages > 1): ?>
        <div class="pagination-container">
            <nav class="pagination">
                <?php if ($page > 1): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>" class="page-link prev">
                    <i class="fas fa-chevron-left"></i>
                    Previous
                </a>
                <?php endif; ?>
                
                <?php
                $startPage = max(1, $page - 2);
                $endPage = min($totalPages, $page + 2);
                
                if ($startPage > 1): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => 1])); ?>" class="page-link">1</a>
                <?php if ($startPage > 2): ?>
                <span class="page-dots">...</span>
                <?php endif; ?>
                <?php endif; ?>
                
                <?php for ($i = $startPage; $i <= $endPage; $i++): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" 
                   class="page-link <?php echo $i === $page ? 'active' : ''; ?>">
                    <?php echo $i; ?>
                </a>
                <?php endfor; ?>
                
                <?php if ($endPage < $totalPages): ?>
                <?php if ($endPage < $totalPages - 1): ?>
                <span class="page-dots">...</span>
                <?php endif; ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $totalPages])); ?>" class="page-link"><?php echo $totalPages; ?></a>
                <?php endif; ?>
                
                <?php if ($page < $totalPages): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>" class="page-link next">
                    Next
                    <i class="fas fa-chevron-right"></i>
                </a>
                <?php endif; ?>
            </nav>
        </div>
        <?php endif; ?>
        <?php endif; ?>
    </div>
</section>

<!-- Bet Details Modal -->
<div class="modal-backdrop" id="betDetailsModal">
    <div class="modal bet-details-modal">
        <div class="modal-header">
            <h3 class="modal-title">Bet Details</h3>
            <button class="modal-close" onclick="closeModal('betDetailsModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body" id="betDetailsContent">
            <!-- Bet details will be loaded here -->
        </div>
    </div>
</div>

<script>
function applyFilters() {
    document.getElementById('filtersForm').submit();
}

function clearFilters() {
    window.location.href = window.location.pathname;
}

function refreshHistory() {
    window.location.reload();
}

function exportBetHistory() {
    const params = new URLSearchParams(window.location.search);
    params.set('export', 'csv');
    
    window.open(`/api/bets/export?${params.toString()}`, '_blank');
}

function viewBetDetails(betId) {
    Crashify.ui.showLoading();
    
    Crashify.api.request(`/api/bets/${betId}`)
        .then(response => {
            if (response.success) {
                showBetDetailsModal(response.bet);
            } else {
                throw new Error(response.message);
            }
        })
        .catch(error => {
            Crashify.ui.toast.error(error.message || 'Failed to load bet details');
        })
        .finally(() => {
            Crashify.ui.hideLoading();
        });
}

function showBetDetailsModal(bet) {
    const content = `
        <div class="bet-details-content">
            <div class="detail-section">
                <h4>Basic Information</h4>
                <div class="detail-grid">
                    <div class="detail-item">
                        <label>Bet ID:</label>
                        <span>#${bet.id}</span>
                    </div>
                    <div class="detail-item">
                        <label>Date:</label>
                        <span>${new Date(bet.created_at).toLocaleString()}</span>
                    </div>
                    <div class="detail-item">
                        <label>Game Type:</label>
                        <span>${bet.game_type}</span>
                    </div>
                    <div class="detail-item">
                        <label>Status:</label>
                        <span class="status-badge status-${bet.status}">${bet.status}</span>
                    </div>
                </div>
            </div>
            
            <div class="detail-section">
                <h4>Bet Information</h4>
                <div class="detail-grid">
                    <div class="detail-item">
                        <label>Bet Amount:</label>
                        <span>$${parseFloat(bet.bet_amount).toFixed(2)}</span>
                    </div>
                    <div class="detail-item">
                        <label>Odds/Multiplier:</label>
                        <span>${bet.multiplier ? bet.multiplier + 'x' : (bet.odds || '-')}</span>
                    </div>
                    <div class="detail-item">
                        <label>Potential Win:</label>
                        <span>$${(bet.bet_amount * (bet.multiplier || bet.odds || 1)).toFixed(2)}</span>
                    </div>
                    <div class="detail-item">
                        <label>Actual Payout:</label>
                        <span>$${parseFloat(bet.win_amount || 0).toFixed(2)}</span>
                    </div>
                </div>
            </div>
            
            ${bet.selection || bet.market ? `
            <div class="detail-section">
                <h4>Selection Details</h4>
                <div class="detail-grid">
                    ${bet.selection ? `
                    <div class="detail-item">
                        <label>Selection:</label>
                        <span>${bet.selection}</span>
                    </div>
                    ` : ''}
                    ${bet.market ? `
                    <div class="detail-item">
                        <label>Market:</label>
                        <span>${bet.market}</span>
                    </div>
                    ` : ''}
                </div>
            </div>
            ` : ''}
        </div>
    `;
    
    document.getElementById('betDetailsContent').innerHTML = content;
    openModal('betDetailsModal');
}

function cancelBet(betId) {
    if (!confirm('Are you sure you want to cancel this bet?')) {
        return;
    }
    
    Crashify.ui.showLoading();
    
    Crashify.api.request(`/api/bets/${betId}/cancel`, {
        method: 'POST'
    })
    .then(response => {
        if (response.success) {
            Crashify.ui.toast.success('Bet cancelled successfully');
            setTimeout(() => {
                window.location.reload();
            }, 1500);
        } else {
            throw new Error(response.message);
        }
    })
    .catch(error => {
        Crashify.ui.toast.error(error.message || 'Failed to cancel bet');
    })
    .finally(() => {
        Crashify.ui.hideLoading();
    });
}
</script>

<?php
// Helper functions
function getGameIcon($gameType) {
    $icons = [
        'crash' => 'rocket',
        'sports' => 'futbol',
        'casino' => 'dice',
        'live' => 'broadcast-tower'
    ];
    return $icons[$gameType] ?? 'gamepad';
}

function getProfitClass($bet) {
    if ($bet['status'] === 'won' || $bet['status'] === 'cashed_out') {
        return 'profit';
    } elseif ($bet['status'] === 'lost') {
        return 'loss';
    }
    return '';
}

function getStatusLabel($status) {
    $labels = [
        'pending' => 'Pending',
        'won' => 'Won',
        'lost' => 'Lost',
        'cancelled' => 'Cancelled',
        'cashed_out' => 'Cashed Out'
    ];
    return $labels[$status] ?? ucfirst($status);
}

include '../includes/footer.php';
?>

PHP
); ?>

<?php _merge_exec('pages/bonuses.php', <<<'PHP'
<?php
// pages/bonuses.php - Bonuses and Promotions Page
// صفحه جوایز و تخفیف‌ها

require_once '../includes/auth.php';
require_once '../includes/functions.php';

$page_title = 'جوایز و تخفیف‌ها';
$current_page = 'bonuses';

// Handle bonus claim
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['claim_bonus'])) {
    if (!isLoggedIn()) {
        $error_message = 'برای دریافت جایزه باید وارد حساب کاربری شوید';
    } else {
        $bonus_id = intval($_POST['bonus_id']);
        $user_id = $_SESSION['user_id'];
        
        // Check if bonus exists and is active
        $stmt = $pdo->prepare("SELECT * FROM bonuses WHERE id = ? AND is_active = 1 AND start_date <= NOW() AND end_date >= NOW()");
        $stmt->execute([$bonus_id]);
        $bonus = $stmt->fetch();
        
        if (!$bonus) {
            $error_message = 'جایزه یافت نشد یا منقضی شده است';
        } else {
            // Check if user already claimed this bonus
            $stmt = $pdo->prepare("SELECT id FROM user_bonuses WHERE user_id = ? AND bonus_id = ?");
            $stmt->execute([$user_id, $bonus_id]);
            
            if ($stmt->rowCount() > 0) {
                $error_message = 'شما قبلاً این جایزه را دریافت کرده‌اید';
            } else {
                // Check bonus requirements
                $can_claim = true;
                $requirements_error = '';
                
                if ($bonus['min_deposit'] > 0) {
                    $stmt = $pdo->prepare("SELECT COALESCE(SUM(amount), 0) as total_deposits FROM transactions WHERE user_id = ? AND type = 'deposit' AND status = 'completed'");
                    $stmt->execute([$user_id]);
                    $total_deposits = $stmt->fetchColumn();
                    
                    if ($total_deposits < $bonus['min_deposit']) {
                        $can_claim = false;
                        $requirements_error = "حداقل واریز مورد نیاز: $" . number_format($bonus['min_deposit'], 2);
                    }
                }
                
                if ($bonus['min_bets'] > 0) {
                    $stmt = $pdo->prepare("SELECT COUNT(*) FROM bets WHERE user_id = ?");
                    $stmt->execute([$user_id]);
                    $total_bets = $stmt->fetchColumn();
                    
                    if ($total_bets < $bonus['min_bets']) {
                        $can_claim = false;
                        $requirements_error = "حداقل تعداد شرط مورد نیاز: " . $bonus['min_bets'];
                    }
                }
                
                if (!$can_claim) {
                    $error_message = 'شرایط دریافت جایزه را ندارید. ' . $requirements_error;
                } else {
                    // Calculate bonus amount
                    $bonus_amount = 0;
                    
                    if ($bonus['type'] === 'fixed') {
                        $bonus_amount = $bonus['amount'];
                    } elseif ($bonus['type'] === 'percentage') {
                        // Get user's last deposit for percentage bonus
                        $stmt = $pdo->prepare("SELECT amount FROM transactions WHERE user_id = ? AND type = 'deposit' AND status = 'completed' ORDER BY created_at DESC LIMIT 1");
                        $stmt->execute([$user_id]);
                        $last_deposit = $stmt->fetchColumn();
                        
                        if ($last_deposit) {
                            $bonus_amount = ($last_deposit * $bonus['percentage']) / 100;
                            if ($bonus['max_amount'] > 0) {
                                $bonus_amount = min($bonus_amount, $bonus['max_amount']);
                            }
                        }
                    }
                    
                    if ($bonus_amount > 0) {
                        try {
                            $pdo->beginTransaction();
                            
                            // Record bonus claim
                            $stmt = $pdo->prepare("
                                INSERT INTO user_bonuses (user_id, bonus_id, amount, status, claimed_at, expires_at)
                                VALUES (?, ?, ?, 'active', NOW(), DATE_ADD(NOW(), INTERVAL ? DAY))
                            ");
                            $stmt->execute([$user_id, $bonus_id, $bonus_amount, $bonus['validity_days'] ?: 30]);
                            
                            // Add bonus to user balance
                            $stmt = $pdo->prepare("UPDATE users SET balance = balance + ?, bonus_balance = bonus_balance + ? WHERE id = ?");
                            $stmt->execute([$bonus_amount, $bonus_amount, $user_id]);
                            
                            // Create transaction record
                            $stmt = $pdo->prepare("
                                INSERT INTO transactions (user_id, type, amount, status, description, created_at)
                                VALUES (?, 'bonus', ?, 'completed', ?, NOW())
                            ");
                            $stmt->execute([$user_id, $bonus_amount, 'دریافت جایزه: ' . $bonus['title']]);
                            
                            $pdo->commit();
                            $success_message = "جایزه با موفقیت دریافت شد! مبلغ $" . number_format($bonus_amount, 2) . " به حساب شما اضافه شد";
                            
                        } catch (Exception $e) {
                            $pdo->rollBack();
                            $error_message = 'خطا در پردازش جایزه';
                        }
                    } else {
                        $error_message = 'مبلغ جایزه محاسبه نشد';
                    }
                }
            }
        }
    }
}

// Get active bonuses
$stmt = $pdo->prepare("
    SELECT b.*, 
           CASE WHEN ub.id IS NOT NULL THEN 1 ELSE 0 END as is_claimed
    FROM bonuses b
    LEFT JOIN user_bonuses ub ON b.id = ub.bonus_id AND ub.user_id = ?
    WHERE b.is_active = 1 
    AND b.start_date <= NOW() 
    AND b.end_date >= NOW()
    ORDER BY b.sort_order ASC, b.created_at DESC
");
$stmt->execute([isLoggedIn() ? $_SESSION['user_id'] : 0]);
$bonuses = $stmt->fetchAll();

// Get user's active bonuses if logged in
$user_bonuses = [];
if (isLoggedIn()) {
    $stmt = $pdo->prepare("
        SELECT ub.*, b.title, b.description, b.type
        FROM user_bonuses ub
        JOIN bonuses b ON ub.bonus_id = b.id
        WHERE ub.user_id = ? AND ub.status = 'active' AND ub.expires_at > NOW()
        ORDER BY ub.claimed_at DESC
    ");
    $stmt->execute([$_SESSION['user_id']]);
    $user_bonuses = $stmt->fetchAll();
}

// Get bonus categories
$stmt = $pdo->prepare("SELECT DISTINCT category FROM bonuses WHERE is_active = 1 ORDER BY category");
$stmt->execute();
$categories = $stmt->fetchAll(PDO::FETCH_COLUMN);

include '../includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-header text-center">
                <h1><i class="fas fa-gift"></i> جوایز و تخفیف‌ها</h1>
                <p class="text-muted">از جوایز و تخفیف‌های ویژه ما بهره‌مند شوید</p>
            </div>
        </div>
    </div>
    
    <?php if ($success_message): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <i class="fas fa-check-circle"></i> <?php echo $success_message; ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
    <?php endif; ?>
    
    <?php if ($error_message): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="fas fa-exclamation-circle"></i> <?php echo $error_message; ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
    <?php endif; ?>
    
    <!-- User's Active Bonuses -->
    <?php if (isLoggedIn() && !empty($user_bonuses)): ?>
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5><i class="fas fa-star text-warning"></i> جوایز فعال شما</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <?php foreach ($user_bonuses as $user_bonus): ?>
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="active-bonus-card">
                                        <div class="bonus-header">
                                            <h6><?php echo htmlspecialchars($user_bonus['title']); ?></h6>
                                            <span class="bonus-amount">$<?php echo number_format($user_bonus['amount'], 2); ?></span>
                                        </div>
                                        <div class="bonus-details">
                                            <p class="bonus-description"><?php echo htmlspecialchars($user_bonus['description']); ?></p>
                                            <div class="bonus-expiry">
                                                <i class="fas fa-clock text-warning"></i>
                                                انقضا: <?php echo date('Y/m/d H:i', strtotime($user_bonus['expires_at'])); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    
    <!-- Bonus Categories Filter -->
    <?php if (!empty($categories)): ?>
        <div class="row mb-4">
            <div class="col-12">
                <div class="bonus-filters text-center">
                    <button class="btn btn-outline-primary active" data-category="all">همه</button>
                    <?php foreach ($categories as $category): ?>
                        <button class="btn btn-outline-primary" data-category="<?php echo htmlspecialchars($category); ?>">
                            <?php echo htmlspecialchars($category); ?>
                        </button>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
    
    <!-- Available Bonuses -->
    <div class="row" id="bonuses-container">
        <?php if (empty($bonuses)): ?>
            <div class="col-12">
                <div class="text-center py-5">
                    <i class="fas fa-gift fa-3x text-muted mb-3"></i>
                    <h4 class="text-muted">در حال حاضر جایزه‌ای موجود نیست</h4>
                    <p class="text-muted">به زودی جوایز جدید اضافه خواهد شد</p>
                </div>
            </div>
        <?php else: ?>
            <?php foreach ($bonuses as $bonus): ?>
                <div class="col-md-6 col-lg-4 mb-4 bonus-item" data-category="<?php echo htmlspecialchars($bonus['category']); ?>">
                    <div class="bonus-card <?php echo $bonus['is_claimed'] ? 'claimed' : ''; ?>">
                        <div class="bonus-ribbon">
                            <?php if ($bonus['is_claimed']): ?>
                                <span class="ribbon claimed-ribbon">دریافت شده</span>
                            <?php elseif ($bonus['type'] === 'welcome'): ?>
                                <span class="ribbon welcome-ribbon">خوش‌آمدگویی</span>
                            <?php elseif ($bonus['type'] === 'deposit'): ?>
                                <span class="ribbon deposit-ribbon">واریز</span>
                            <?php elseif ($bonus['type'] === 'cashback'): ?>
                                <span class="ribbon cashback-ribbon">بازگشت وجه</span>
                            <?php endif; ?>
                        </div>
                        
                        <div class="bonus-header">
                            <div class="bonus-icon">
                                <i class="fas fa-<?php echo getBonusIcon($bonus['type']); ?>"></i>
                            </div>
                            <h5 class="bonus-title"><?php echo htmlspecialchars($bonus['title']); ?></h5>
                        </div>
                        
                        <div class="bonus-body">
                            <div class="bonus-amount">
                                <?php if ($bonus['type'] === 'fixed'): ?>
                                    <span class="amount">$<?php echo number_format($bonus['amount'], 2); ?></span>
                                    <span class="amount-type">مبلغ ثابت</span>
                                <?php elseif ($bonus['type'] === 'percentage'): ?>
                                    <span class="amount"><?php echo $bonus['percentage']; ?>%</span>
                                    <span class="amount-type">درصد واریز</span>
                                    <?php if ($bonus['max_amount'] > 0): ?>
                                        <small class="text-muted d-block">حداکثر: $<?php echo number_format($bonus['max_amount'], 2); ?></small>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                            
                            <div class="bonus-description">
                                <p><?php echo nl2br(htmlspecialchars($bonus['description'])); ?></p>
                            </div>
                            
                            <div class="bonus-requirements">
                                <h6><i class="fas fa-list-check"></i> شرایط:</h6>
                                <ul class="requirements-list">
                                    <?php if ($bonus['min_deposit'] > 0): ?>
                                        <li>حداقل واریز: $<?php echo number_format($bonus['min_deposit'], 2); ?></li>
                                    <?php endif; ?>
                                    
                                    <?php if ($bonus['min_bets'] > 0): ?>
                                        <li>حداقل تعداد شرط: <?php echo $bonus['min_bets']; ?></li>
                                    <?php endif; ?>
                                    
                                    <?php if ($bonus['wagering_requirement'] > 0): ?>
                                        <li>ضریب گردش: <?php echo $bonus['wagering_requirement']; ?>x</li>
                                    <?php endif; ?>
                                    
                                    <?php if ($bonus['validity_days'] > 0): ?>
                                        <li>اعتبار: <?php echo $bonus['validity_days']; ?> روز</li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            
                            <div class="bonus-validity">
                                <div class="validity-info">
                                    <i class="fas fa-calendar-alt"></i>
                                    <span>تا <?php echo date('Y/m/d', strtotime($bonus['end_date'])); ?></span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="bonus-footer">
                            <?php if ($bonus['is_claimed']): ?>
                                <button class="btn btn-secondary btn-block" disabled>
                                    <i class="fas fa-check"></i> دریافت شده
                                </button>
                            <?php elseif (!isLoggedIn()): ?>
                                <a href="/auth/login.php" class="btn btn-primary btn-block">
                                    <i class="fas fa-sign-in-alt"></i> ورود برای دریافت
                                </a>
                            <?php else: ?>
                                <form method="POST" class="claim-bonus-form">
                                    <input type="hidden" name="bonus_id" value="<?php echo $bonus['id']; ?>">
                                    <button type="submit" name="claim_bonus" class="btn btn-success btn-block">
                                        <i class="fas fa-gift"></i> دریافت جایزه
                                    </button>
                                </form>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
    
    <!-- Bonus Terms and Conditions -->
    <div class="row mt-5">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5><i class="fas fa-file-contract"></i> قوانین و مقررات جوایز</h5>
                </div>
                <div class="card-body">
                    <div class="terms-content">
                        <h6>شرایط عمومی:</h6>
                        <ul>
                            <li>هر کاربر فقط یک بار می‌تواند از هر جایزه استفاده کند</li>
                            <li>جوایز دارای تاریخ انقضا هستند و پس از آن غیرقابل استفاده خواهند بود</li>
                            <li>برای برداشت جوایز، باید شرایط گردش (Wagering) را تکمیل کنید</li>
                            <li>سایت حق لغو یا تغییر جوایز را در هر زمان محفوظ می‌دارد</li>
                            <li>سوء استفاده از سیستم جوایز منجر به مسدود شدن حساب کاربری خواهد شد</li>
                        </ul>
                        
                        <h6>نحوه محاسبه ضریب گردش:</h6>
                        <p>
                            ضریب گردش به معنای تعداد دفعاتی است که باید مبلغ جایزه را شرط‌بندی کنید تا بتوانید آن را برداشت کنید.
                            مثال: اگر جایزه $100 با ضریب گردش 5x دریافت کنید، باید $500 شرط‌بندی کنید.
                        </p>
                        
                        <h6>بازی‌های مجاز:</h6>
                        <p>
                            تمام بازی‌های موجود در سایت برای تکمیل شرایط گردش مجاز هستند، اما درصد مشارکت آن‌ها متفاوت است:
                        </p>
                        <ul>
                            <li>بازی‌های کرش: 100%</li>
                            <li>اسلات‌ها: 100%</li>
                            <li>شرط‌بندی ورزشی: 50%</li>
                            <li>بازی‌های رومیزی: 10%</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.page-header {
    margin-bottom: 2rem;
    padding: 2rem 0;
}

.page-header h1 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
}

.bonus-filters {
    margin-bottom: 2rem;
}

.bonus-filters .btn {
    margin: 0 0.25rem 0.5rem;
    border-radius: 25px;
}

.bonus-filters .btn.active {
    background-color: #007bff;
    border-color: #007bff;
    color: white;
}

.bonus-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    transition: transform 0.3s, box-shadow 0.3s;
    position: relative;
    overflow: hidden;
    height: 100%;
    display: flex;
    flex-direction: column;
}

.bonus-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
}

.bonus-card.claimed {
    opacity: 0.7;
    background: #f8f9fa;
}

.bonus-ribbon {
    position: absolute;
    top: 15px;
    right: -30px;
    z-index: 2;
}

.ribbon {
    background: linear-gradient(45deg, #ff6b6b, #ee5a52);
    color: white;
    padding: 5px 40px;
    font-size: 0.75rem;
    font-weight: bold;
    transform: rotate(45deg);
    text-align: center;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
}

.welcome-ribbon {
    background: linear-gradient(45deg, #4ecdc4, #44a08d);
}

.deposit-ribbon {
    background: linear-gradient(45deg, #667eea, #764ba2);
}

.cashback-ribbon {
    background: linear-gradient(45deg, #f093fb, #f5576c);
}

.claimed-ribbon {
    background: linear-gradient(45deg, #95a5a6, #7f8c8d);
}

.bonus-header {
    text-align: center;
    padding: 2rem 1.5rem 1rem;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.bonus-icon {
    font-size: 2.5rem;
    margin-bottom: 1rem;
}

.bonus-title {
    margin: 0;
    font-size: 1.25rem;
    font-weight: 600;
}

.bonus-body {
    padding: 1.5rem;
    flex: 1;
    display: flex;
    flex-direction: column;
}

.bonus-amount {
    text-align: center;
    margin-bottom: 1.5rem;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 10px;
}

.bonus-amount .amount {
    display: block;
    font-size: 2rem;
    font-weight: bold;
    color: #28a745;
}

.bonus-amount .amount-type {
    font-size: 0.875rem;
    color: #6c757d;
}

.bonus-description {
    margin-bottom: 1.5rem;
    flex: 1;
}

.bonus-description p {
    color: #6c757d;
    line-height: 1.6;
}

.bonus-requirements {
    margin-bottom: 1.5rem;
}

.bonus-requirements h6 {
    color: #495057;
    margin-bottom: 0.75rem;
    font-size: 0.9rem;
}

.requirements-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.requirements-list li {
    padding: 0.25rem 0;
    font-size: 0.875rem;
    color: #6c757d;
    position: relative;
    padding-left: 1.5rem;
}

.requirements-list li:before {
    content: '✓';
    position: absolute;
    left: 0;
    color: #28a745;
    font-weight: bold;
}

.bonus-validity {
    margin-bottom: 1rem;
}

.validity-info {
    display: flex;
    align-items: center;
    justify-content: center;
    color: #6c757d;
    font-size: 0.875rem;
}

.validity-info i {
    margin-right: 0.5rem;
}

.bonus-footer {
    padding: 0 1.5rem 1.5rem;
    margin-top: auto;
}

.active-bonus-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 10px;
    padding: 1.5rem;
    height: 100%;
}

.active-bonus-card .bonus-header {
    display: flex;
    justify-content: between;
    align-items: center;
    margin-bottom: 1rem;
    padding: 0;
    background: none;
}

.active-bonus-card .bonus-amount {
    font-size: 1.25rem;
    font-weight: bold;
}

.active-bonus-card .bonus-description {
    margin-bottom: 1rem;
    opacity: 0.9;
}

.active-bonus-card .bonus-expiry {
    font-size: 0.875rem;
    opacity: 0.8;
}

.terms-content h6 {
    color: #495057;
    margin-top: 1.5rem;
    margin-bottom: 0.75rem;
}

.terms-content h6:first-child {
    margin-top: 0;
}

.terms-content ul {
    margin-bottom: 1.5rem;
}

.terms-content li {
    margin-bottom: 0.5rem;
    line-height: 1.6;
}

@media (max-width: 768px) {
    .bonus-filters .btn {
        font-size: 0.875rem;
        padding: 0.375rem 0.75rem;
    }
    
    .bonus-header {
        padding: 1.5rem 1rem 0.75rem;
    }
    
    .bonus-icon {
        font-size: 2rem;
    }
    
    .bonus-title {
        font-size: 1.1rem;
    }
    
    .bonus-amount .amount {
        font-size: 1.5rem;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Category filtering
    const filterButtons = document.querySelectorAll('[data-category]');
    const bonusItems = document.querySelectorAll('.bonus-item');
    
    filterButtons.forEach(button => {
        button.addEventListener('click', function() {
            const category = this.dataset.category;
            
            // Update active button
            filterButtons.forEach(btn => btn.classList.remove('active'));
            this.classList.add('active');
            
            // Filter bonus items
            bonusItems.forEach(item => {
                if (category === 'all' || item.dataset.category === category) {
                    item.style.display = 'block';
                } else {
                    item.style.display = 'none';
                }
            });
        });
    });
    
    // Claim bonus form handling
    const claimForms = document.querySelectorAll('.claim-bonus-form');
    claimForms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const button = this.querySelector('button[type="submit"]');
            button.disabled = true;
            button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال پردازش...';
        });
    });
});
</script>

<?php
// Helper function to get bonus icon
function getBonusIcon($type) {
    $icons = [
        'welcome' => 'hand-holding-heart',
        'deposit' => 'coins',
        'cashback' => 'undo-alt',
        'loyalty' => 'crown',
        'referral' => 'users',
        'tournament' => 'trophy',
        'default' => 'gift'
    ];
    
    return $icons[$type] ?? $icons['default'];
}

include '../includes/footer.php';
?>
PHP
); ?>

<?php _merge_exec('pages/casino.php', <<<'PHP'
<?php
// pages/casino.php - Casino Games Page
// صفحه بازی‌های کازینو

require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// Page settings
$pageTitle = 'Casino Games - Slots, Table Games & Live Casino';
$bodyClass = 'casino-page';
$breadcrumbs = [
    ['title' => 'Casino']
];

// Get filters from URL
$selectedCategory = $_GET['category'] ?? 'all';
$selectedProvider = $_GET['provider'] ?? 'all';
$searchQuery = $_GET['search'] ?? '';
$sortBy = $_GET['sort'] ?? 'popular';
$viewMode = $_GET['view'] ?? 'grid';

// Get casino data
$categories = [
    'all' => ['name' => 'All Games', 'icon' => 'fas fa-th', 'count' => 0],
    'slots' => ['name' => 'Slots', 'icon' => 'fas fa-coins', 'count' => 0],
    'table' => ['name' => 'Table Games', 'icon' => 'fas fa-table', 'count' => 0],
    'live' => ['name' => 'Live Casino', 'icon' => 'fas fa-video', 'count' => 0],
    'crash' => ['name' => 'Crash Games', 'icon' => 'fas fa-chart-line', 'count' => 0],
    'jackpots' => ['name' => 'Jackpots', 'icon' => 'fas fa-trophy', 'count' => 0],
    'new' => ['name' => 'New Games', 'icon' => 'fas fa-star', 'count' => 0]
];

// Sample games data (in real app, this would come from database)
$games = [
    [
        'id' => 1,
        'name' => 'Sweet Bonanza',
        'provider' => 'Pragmatic Play',
        'category' => 'slots',
        'image' => '/assets/images/games/sweet-bonanza.jpg',
        'rtp' => 96.51,
        'volatility' => 'High',
        'min_bet' => 0.20,
        'max_bet' => 100.00,
        'jackpot' => null,
        'featured' => true,
        'new' => false,
        'popular' => true,
        'demo_available' => true
    ],
    [
        'id' => 2,
        'name' => 'Lightning Roulette',
        'provider' => 'Evolution Gaming',
        'category' => 'live',
        'image' => '/assets/images/games/lightning-roulette.jpg',
        'rtp' => 97.30,
        'volatility' => 'Medium',
        'min_bet' => 0.20,
        'max_bet' => 5000.00,
        'jackpot' => null,
        'featured' => true,
        'new' => false,
        'popular' => true,
        'demo_available' => false
    ],
    [
        'id' => 3,
        'name' => 'Aviator',
        'provider' => 'Spribe',
        'category' => 'crash',
        'image' => '/assets/images/games/aviator.jpg',
        'rtp' => 97.00,
        'volatility' => 'High',
        'min_bet' => 0.10,
        'max_bet' => 100.00,
        'jackpot' => null,
        'featured' => true,
        'new' => false,
        'popular' => true,
        'demo_available' => true
    ],
    [
        'id' => 4,
        'name' => 'Mega Moolah',
        'provider' => 'Microgaming',
        'category' => 'jackpots',
        'image' => '/assets/images/games/mega-moolah.jpg',
        'rtp' => 88.12,
        'volatility' => 'Medium',
        'min_bet' => 0.25,
        'max_bet' => 6.25,
        'jackpot' => 15420000.50,
        'featured' => true,
        'new' => false,
        'popular' => true,
        'demo_available' => true
    ],
    [
        'id' => 5,
        'name' => 'Blackjack Classic',
        'provider' => 'NetEnt',
        'category' => 'table',
        'image' => '/assets/images/games/blackjack-classic.jpg',
        'rtp' => 99.28,
        'volatility' => 'Low',
        'min_bet' => 1.00,
        'max_bet' => 1000.00,
        'jackpot' => null,
        'featured' => false,
        'new' => false,
        'popular' => true,
        'demo_available' => true
    ]
];

// Filter games
$filteredGames = array_filter($games, function($game) use ($selectedCategory, $selectedProvider, $searchQuery) {
    if ($selectedCategory !== 'all' && $game['category'] !== $selectedCategory) {
        return false;
    }
    if ($selectedProvider !== 'all' && $game['provider'] !== $selectedProvider) {
        return false;
    }
    if ($searchQuery && stripos($game['name'], $searchQuery) === false) {
        return false;
    }
    return true;
});

// Sort games
usort($filteredGames, function($a, $b) use ($sortBy) {
    switch ($sortBy) {
        case 'name':
            return strcmp($a['name'], $b['name']);
        case 'rtp':
            return $b['rtp'] <=> $a['rtp'];
        case 'newest':
            return $b['new'] <=> $a['new'];
        case 'popular':
        default:
            return $b['popular'] <=> $a['popular'];
    }
});

// Get providers
$providers = array_unique(array_column($games, 'provider'));
sort($providers);

// Update category counts
foreach ($games as $game) {
    $categories[$game['category']]['count']++;
    $categories['all']['count']++;
}

// Get featured games
$featuredGames = array_filter($games, fn($game) => $game['featured']);

// Additional scripts
$additionalScripts = [
    '/assets/js/casino.js'
];

include '../includes/header.php';
?>

<!-- Hero Section -->
<section class="casino-hero">
    <div class="container">
        <div class="hero-content">
            <div class="hero-text">
                <h1 class="hero-title">
                    <i class="fas fa-dice"></i>
                    Casino Games
                </h1>
                <p class="hero-description">
                    Experience the thrill of premium casino games with instant crypto payouts. 
                    From classic slots to live dealer games, we have it all.
                </p>
                <div class="hero-features">
                    <div class="feature-item">
                        <i class="fas fa-bolt"></i>
                        <span>Instant Payouts</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-shield-alt"></i>
                        <span>Provably Fair</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-mobile-alt"></i>
                        <span>Mobile Optimized</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-headset"></i>
                        <span>24/7 Support</span>
                    </div>
                </div>
            </div>
            <div class="hero-image">
                <div class="floating-games">
                    <div class="game-card floating">
                        <img src="/assets/images/games/sweet-bonanza.jpg" alt="Sweet Bonanza">
                        <div class="game-overlay">
                            <button class="play-btn">
                                <i class="fas fa-play"></i>
                            </button>
                        </div>
                    </div>
                    <div class="game-card floating" style="animation-delay: 0.5s;">
                        <img src="/assets/images/games/lightning-roulette.jpg" alt="Lightning Roulette">
                        <div class="game-overlay">
                            <button class="play-btn">
                                <i class="fas fa-play"></i>
                            </button>
                        </div>
                    </div>
                    <div class="game-card floating" style="animation-delay: 1s;">
                        <img src="/assets/images/games/aviator.jpg" alt="Aviator">
                        <div class="game-overlay">
                            <button class="play-btn">
                                <i class="fas fa-play"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Categories Navigation -->
<section class="categories-nav">
    <div class="container">
        <div class="categories-tabs">
            <?php foreach ($categories as $key => $category): ?>
            <a href="?category=<?php echo $key; ?>" 
               class="category-tab <?php echo $selectedCategory === $key ? 'active' : ''; ?>">
                <i class="<?php echo $category['icon']; ?>"></i>
                <span><?php echo $category['name']; ?></span>
                <span class="game-count"><?php echo $category['count']; ?></span>
            </a>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Jackpot Ticker -->
<section class="jackpot-ticker">
    <div class="container">
        <div class="ticker-content">
            <div class="ticker-title">
                <i class="fas fa-trophy"></i>
                <span>Progressive Jackpots</span>
            </div>
            <div class="jackpots-list">
                <div class="jackpot-item">
                    <span class="game-name">Mega Moolah</span>
                    <span class="jackpot-amount" data-jackpot="15420000.50">$15,420,000.50</span>
                </div>
                <div class="jackpot-item">
                    <span class="game-name">Divine Fortune</span>
                    <span class="jackpot-amount" data-jackpot="2850000.25">$2,850,000.25</span>
                </div>
                <div class="jackpot-item">
                    <span class="game-name">Hall of Gods</span>
                    <span class="jackpot-amount" data-jackpot="1250000.75">$1,250,000.75</span>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Featured Games -->
<?php if (!empty($featuredGames) && $selectedCategory === 'all' && empty($searchQuery)): ?>
<section class="featured-games">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-star"></i>
                Featured Games
            </h2>
            <div class="section-actions">
                <button class="carousel-btn prev" onclick="scrollCarousel('featured', 'prev')">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button class="carousel-btn next" onclick="scrollCarousel('featured', 'next')">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>
        </div>
        
        <div class="games-carousel" id="featuredCarousel">
            <?php foreach ($featuredGames as $game): ?>
            <div class="game-card featured" data-game-id="<?php echo $game['id']; ?>">
                <div class="game-image">
                    <img src="<?php echo $game['image']; ?>" alt="<?php echo $game['name']; ?>">
                    <div class="game-overlay">
                        <div class="game-actions">
                            <?php if ($game['demo_available']): ?>
                            <button class="btn btn-outline btn-sm" onclick="playDemo(<?php echo $game['id']; ?>)">
                                <i class="fas fa-play"></i>
                                Demo
                            </button>
                            <?php endif; ?>
                            <button class="btn btn-primary btn-sm" onclick="playReal(<?php echo $game['id']; ?>)">
                                <i class="fas fa-coins"></i>
                                Play
                            </button>
                        </div>
                    </div>
                    <?php if ($game['new']): ?>
                    <span class="game-badge new">NEW</span>
                    <?php endif; ?>
                    <?php if ($game['jackpot']): ?>
                    <span class="game-badge jackpot">JACKPOT</span>
                    <?php endif; ?>
                </div>
                <div class="game-info">
                    <h3 class="game-title"><?php echo $game['name']; ?></h3>
                    <p class="game-provider"><?php echo $game['provider']; ?></p>
                    <div class="game-stats">
                        <div class="stat">
                            <span class="label">RTP:</span>
                            <span class="value"><?php echo $game['rtp']; ?>%</span>
                        </div>
                        <?php if ($game['jackpot']): ?>
                        <div class="stat jackpot">
                            <span class="label">Jackpot:</span>
                            <span class="value">$<?php echo number_format($game['jackpot'], 2); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Filters & Search -->
<section class="filters-section">
    <div class="container">
        <div class="filters-bar">
            <div class="filter-group">
                <label class="filter-label">Provider:</label>
                <select class="filter-select" id="providerFilter" onchange="applyFilters()">
                    <option value="all">All Providers</option>
                    <?php foreach ($providers as $provider): ?>
                    <option value="<?php echo $provider; ?>" <?php echo $selectedProvider === $provider ? 'selected' : ''; ?>>
                        <?php echo $provider; ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="filter-group">
                <label class="filter-label">Sort by:</label>
                <select class="filter-select" id="sortFilter" onchange="applyFilters()">
                    <option value="popular" <?php echo $sortBy === 'popular' ? 'selected' : ''; ?>>Most Popular</option>
                    <option value="newest" <?php echo $sortBy === 'newest' ? 'selected' : ''; ?>>Newest</option>
                    <option value="name" <?php echo $sortBy === 'name' ? 'selected' : ''; ?>>A-Z</option>
                    <option value="rtp" <?php echo $sortBy === 'rtp' ? 'selected' : ''; ?>>Highest RTP</option>
                </select>
            </div>
            
            <div class="search-group">
                <div class="search-input">
                    <i class="fas fa-search"></i>
                    <input type="text" 
                           placeholder="Search games..." 
                           value="<?php echo htmlspecialchars($searchQuery); ?>"
                           id="searchInput"
                           onkeyup="handleSearch(event)">
                    <?php if ($searchQuery): ?>
                    <button class="clear-search" onclick="clearSearch()">
                        <i class="fas fa-times"></i>
                    </button>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="view-toggle">
                <button class="view-btn <?php echo $viewMode === 'grid' ? 'active' : ''; ?>" 
                        onclick="changeView('grid')" data-view="grid">
                    <i class="fas fa-th"></i>
                </button>
                <button class="view-btn <?php echo $viewMode === 'list' ? 'active' : ''; ?>" 
                        onclick="changeView('list')" data-view="list">
                    <i class="fas fa-list"></i>
                </button>
            </div>
        </div>
    </div>
</section>

<!-- Games Grid -->
<section class="games-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">
                <?php 
                if ($selectedCategory !== 'all') {
                    echo $categories[$selectedCategory]['name'];
                } else {
                    echo 'All Games';
                }
                ?>
                <?php if ($searchQuery): ?>
                <span class="search-results">- Results for "<?php echo htmlspecialchars($searchQuery); ?>"</span>
                <?php endif; ?>
            </h2>
            <div class="results-count">
                <?php echo count($filteredGames); ?> games found
            </div>
        </div>
        
        <?php if (empty($filteredGames)): ?>
        <div class="empty-state">
            <div class="empty-icon">
                <i class="fas fa-gamepad"></i>
            </div>
            <h3>No Games Found</h3>
            <p>
                <?php if ($searchQuery): ?>
                    No games match your search criteria. Try adjusting your search terms.
                <?php else: ?>
                    No games available for the selected filters. Try changing your selection.
                <?php endif; ?>
            </p>
            <div class="empty-actions">
                <?php if ($searchQuery): ?>
                <button class="btn btn-primary" onclick="clearSearch()">Clear Search</button>
                <?php endif; ?>
                <a href="/pages/casino.php" class="btn btn-outline">View All Games</a>
            </div>
        </div>
        <?php else: ?>
        <div class="games-grid <?php echo $viewMode; ?>-view" id="gamesGrid">
            <?php foreach ($filteredGames as $game): ?>
            <div class="game-card" data-game-id="<?php echo $game['id']; ?>">
                <div class="game-image">
                    <img src="<?php echo $game['image']; ?>" alt="<?php echo $game['name']; ?>" loading="lazy">
                    <div class="game-overlay">
                        <div class="game-actions">
                            <?php if ($game['demo_available']): ?>
                            <button class="btn btn-outline btn-sm" onclick="playDemo(<?php echo $game['id']; ?>)">
                                <i class="fas fa-play"></i>
                                Demo
                            </button>
                            <?php endif; ?>
                            <button class="btn btn-primary btn-sm" onclick="playReal(<?php echo $game['id']; ?>)">
                                <i class="fas fa-coins"></i>
                                <?php echo $currentUser ? 'Play' : 'Login to Play'; ?>
                            </button>
                        </div>
                        <button class="favorite-btn" onclick="toggleFavorite(<?php echo $game['id']; ?>)">
                            <i class="far fa-heart"></i>
                        </button>
                    </div>
                    
                    <!-- Game Badges -->
                    <div class="game-badges">
                        <?php if ($game['new']): ?>
                        <span class="game-badge new">NEW</span>
                        <?php endif; ?>
                        <?php if ($game['jackpot']): ?>
                        <span class="game-badge jackpot">JACKPOT</span>
                        <?php endif; ?>
                        <?php if ($game['popular']): ?>
                        <span class="game-badge popular">HOT</span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="game-info">
                    <h3 class="game-title"><?php echo $game['name']; ?></h3>
                    <p class="game-provider"><?php echo $game['provider']; ?></p>
                    
                    <div class="game-stats">
                        <div class="stat">
                            <span class="label">RTP:</span>
                            <span class="value"><?php echo $game['rtp']; ?>%</span>
                        </div>
                        <div class="stat">
                            <span class="label">Volatility:</span>
                            <span class="value volatility-<?php echo strtolower($game['volatility']); ?>">
                                <?php echo $game['volatility']; ?>
                            </span>
                        </div>
                    </div>
                    
                    <div class="game-limits">
                        <span class="min-bet">Min: $<?php echo number_format($game['min_bet'], 2); ?></span>
                        <span class="max-bet">Max: $<?php echo number_format($game['max_bet'], 2); ?></span>
                    </div>
                    
                    <?php if ($game['jackpot']): ?>
                    <div class="jackpot-amount">
                        <i class="fas fa-trophy"></i>
                        <span>$<?php echo number_format($game['jackpot'], 2); ?></span>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Load More Button -->
        <div class="load-more-section">
            <button class="btn btn-outline load-more-btn" onclick="loadMoreGames()">
                <i class="fas fa-plus"></i>
                Load More Games
            </button>
        </div>
        <?php endif; ?>
    </div>
</section>

<!-- Game Modal -->
<div class="modal-backdrop" id="gameModal">
    <div class="modal game-modal">
        <div class="modal-header">
            <h3 class="modal-title" id="gameModalTitle">Game</h3>
            <button class="modal-close" onclick="closeGameModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            <div class="game-container" id="gameContainer">
                <!-- Game iframe will be loaded here -->
            </div>
        </div>
    </div>
</div>

<script>
// Page-specific JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Initialize casino functionality
    initializeCasino();
    
    // Update jackpot amounts
    setInterval(updateJackpots, 10000); // Every 10 seconds
    
    // Initialize filters
    initializeFilters();
});

function initializeCasino() {
    // Initialize game cards
    initializeGameCards();
    
    // Initialize carousels
    initializeCarousels();
    
    // Initialize search
    initializeSearch();
}

function playDemo(gameId) {
    // Load game in demo mode
    loadGame(gameId, 'demo');
}

function playReal(gameId) {
    <?php if (!$currentUser): ?>
    // Redirect to login if not authenticated
    window.location.href = '/auth/login.php?redirect=' + encodeURIComponent(window.location.href);
    return;
    <?php endif; ?>
    
    // Load game in real mode
    loadGame(gameId, 'real');
}

function loadGame(gameId, mode) {
    // Show loading
    Crashify.ui.showLoading();
    
    // Load game
    Crashify.api.request(`/api/games/${gameId}/launch`, {
        method: 'POST',
        body: JSON.stringify({ mode: mode })
    })
    .then(response => {
        if (response.success) {
            document.getElementById('gameContainer').innerHTML = response.html;
            document.getElementById('gameModalTitle').textContent = response.game.name;
            openModal('gameModal');
        } else {
            throw new Error(response.message);
        }
    })
    .catch(error => {
        Crashify.ui.toast.error(error.message || 'Failed to load game');
    })
    .finally(() => {
        Crashify.ui.hideLoading();
    });
}

function closeGameModal() {
    // Stop game
    const gameContainer = document.getElementById('gameContainer');
    gameContainer.innerHTML = '';
    
    // Close modal
    closeModal('gameModal');
}

function applyFilters() {
    const category = '<?php echo $selectedCategory; ?>';
    const provider = document.getElementById('providerFilter').value;
    const sort = document.getElementById('sortFilter').value;
    const search = document.getElementById('searchInput').value;
    
    const params = new URLSearchParams();
    if (category !== 'all') params.set('category', category);
    if (provider !== 'all') params.set('provider', provider);
    if (sort !== 'popular') params.set('sort', sort);
    if (search) params.set('search', search);
    
    window.location.href = `${window.location.pathname}?${params.toString()}`;
}

function handleSearch(event) {
    if (event.key === 'Enter') {
        applyFilters();
    }
}

function clearSearch() {
    document.getElementById('searchInput').value = '';
    applyFilters();
}

function changeView(viewMode) {
    const params = new URLSearchParams(window.location.search);
    params.set('view', viewMode);
    window.location.href = `${window.location.pathname}?${params.toString()}`;
}

function toggleFavorite(gameId) {
    <?php if (!$currentUser): ?>
    Crashify.ui.toast.error('Please login to add favorites');
    return;
    <?php endif; ?>
    
    Crashify.api.request(`/api/games/${gameId}/favorite`, {
        method: 'POST'
    })
    .then(response => {
        if (response.success) {
            const btn = event.target.closest('.favorite-btn');
            const icon = btn.querySelector('i');
            
            if (response.favorited) {
                icon.className = 'fas fa-heart';
                Crashify.ui.toast.success('Added to favorites');
            } else {
                icon.className = 'far fa-heart';
                Crashify.ui.toast.success('Removed from favorites');
            }
        }
    })
    .catch(error => {
        Crashify.ui.toast.error('Failed to update favorites');
    });
}

function updateJackpots() {
    // Update progressive jackpot amounts
    Crashify.api.request('/api/jackpots/current')
        .then(response => {
            if (response.success) {
                response.jackpots.forEach(jackpot => {
                    const elements = document.querySelectorAll(`[data-jackpot="${jackpot.game_id}"]`);
                    elements.forEach(el => {
                        el.textContent = '$' + jackpot.amount.toLocaleString();
                    });
                });
            }
        })
        .catch(error => {
            console.error('Failed to update jackpots:', error);
        });
}
</script>

<?php include '../includes/footer.php'; ?>
PHP
); ?>

<?php _merge_exec('pages/crash-game.php', <<<'PHP'
<?php
// pages/crash-game.php - Main Crash Game Page
// صفحه اصلی بازی کرش

require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// Require authentication
requireAuth();

// Page settings
$pageTitle = 'Crash Game - Crashify';
$bodyClass = 'crash-game-page';
$breadcrumbs = [
    ['title' => 'Games', 'url' => '/pages/casino.php'],
    ['title' => 'Crash Game']
];

// Get user's crash game stats
$userStats = fetchRow(
    "SELECT 
        COUNT(*) as total_games,
        SUM(CASE WHEN profit > 0 THEN 1 ELSE 0 END) as wins,
        SUM(bet_amount) as total_wagered,
        SUM(profit) as total_profit,
        MAX(multiplier) as highest_multiplier,
        AVG(multiplier) as avg_multiplier
     FROM crash_bets 
     WHERE user_id = ? AND status = 'completed'",
    [$currentUser['id']]
) ?: [
    'total_games' => 0,
    'wins' => 0,
    'total_wagered' => 0,
    'total_profit' => 0,
    'highest_multiplier' => 0,
    'avg_multiplier' => 0
];

// Get recent crash results
$recentResults = fetchAll(
    "SELECT multiplier, created_at 
     FROM crash_rounds 
     WHERE status = 'completed' 
     ORDER BY created_at DESC 
     LIMIT 20"
);

// Get current game state
$currentRound = fetchRow(
    "SELECT * FROM crash_rounds 
     WHERE status IN ('waiting', 'running') 
     ORDER BY created_at DESC 
     LIMIT 1"
);

// Get user's active bet for current round
$activeBet = null;
if ($currentRound) {
    $activeBet = fetchRow(
        "SELECT * FROM crash_bets 
         WHERE user_id = ? AND round_id = ? AND status = 'active'",
        [$currentUser['id'], $currentRound['id']]
    );
}

// Get top winners today
$topWinners = fetchAll(
    "SELECT u.username, cb.bet_amount, cb.multiplier, cb.profit
     FROM crash_bets cb
     JOIN users u ON cb.user_id = u.id
     WHERE DATE(cb.created_at) = CURDATE() 
     AND cb.profit > 0
     ORDER BY cb.profit DESC
     LIMIT 10"
);

$additionalScripts = [
    '/assets/js/crash-game.js',
    '/assets/js/chart.js'
];

include '../includes/header.php';
?>

<!-- Crash Game Container -->
<div class="crash-game-container">
    <!-- Game Header -->
    <section class="game-header">
        <div class="container">
            <div class="header-content">
                <div class="game-info">
                    <h1 class="game-title">
                        <i class="fas fa-rocket"></i>
                        Crash Game
                    </h1>
                    <p class="game-description">
                        Watch the multiplier rise and cash out before it crashes!
                    </p>
                </div>
                
                <div class="game-stats">
                    <div class="stat-item">
                        <div class="stat-value"><?php echo number_format($userStats['total_games']); ?></div>
                        <div class="stat-label">Games Played</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value"><?php echo $userStats['total_games'] > 0 ? round(($userStats['wins'] / $userStats['total_games']) * 100, 1) : 0; ?>%</div>
                        <div class="stat-label">Win Rate</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value"><?php echo $userStats['highest_multiplier'] > 0 ? number_format($userStats['highest_multiplier'], 2) : '0.00'; ?>x</div>
                        <div class="stat-label">Best Multiplier</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value">$<?php echo number_format($userStats['total_profit'], 2); ?></div>
                        <div class="stat-label">Total Profit</div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Main Game Area -->
    <section class="game-area">
        <div class="container">
            <div class="game-layout">
                <!-- Game Chart -->
                <div class="game-chart-container">
                    <div class="game-status" id="gameStatus">
                        <div class="status-waiting" id="statusWaiting" style="display: none;">
                            <div class="waiting-content">
                                <div class="waiting-icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                                <h3>Next Round Starting...</h3>
                                <div class="countdown" id="countdown">5</div>
                            </div>
                        </div>
                        
                        <div class="status-running" id="statusRunning" style="display: none;">
                            <div class="multiplier-display">
                                <div class="current-multiplier" id="currentMultiplier">1.00x</div>
                                <div class="multiplier-trend" id="multiplierTrend">
                                    <i class="fas fa-arrow-up"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="status-crashed" id="statusCrashed" style="display: none;">
                            <div class="crashed-content">
                                <div class="crashed-icon">
                                    <i class="fas fa-bomb"></i>
                                </div>
                                <h3>CRASHED!</h3>
                                <div class="crash-multiplier" id="crashMultiplier">0.00x</div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Chart Canvas -->
                    <div class="chart-container">
                        <canvas id="crashChart" width="800" height="400"></canvas>
                    </div>
                    
                    <!-- Recent Results -->
                    <div class="recent-results">
                        <h4>Recent Results</h4>
                        <div class="results-list" id="recentResults">
                            <?php foreach ($recentResults as $result): ?>
                            <div class="result-item <?php echo $result['multiplier'] >= 2 ? 'high' : ($result['multiplier'] >= 1.5 ? 'medium' : 'low'); ?>">
                                <?php echo number_format($result['multiplier'], 2); ?>x
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                
                <!-- Game Controls -->
                <div class="game-controls">
                    <!-- Betting Panel -->
                    <div class="betting-panel">
                        <div class="panel-header">
                            <h3>Place Your Bet</h3>
                            <div class="balance-display">
                                Balance: <span class="balance-amount">$<?php echo number_format($currentUser['balance'], 2); ?></span>
                            </div>
                        </div>
                        
                        <div class="betting-form" id="bettingForm">
                            <div class="bet-amount-section">
                                <label for="betAmount">Bet Amount</label>
                                <div class="amount-input">
                                    <span class="currency">$</span>
                                    <input type="number" 
                                           id="betAmount" 
                                           min="1" 
                                           max="<?php echo $currentUser['balance']; ?>" 
                                           step="0.01" 
                                           value="10.00"
                                           placeholder="0.00">
                                </div>
                                <div class="quick-amounts">
                                    <button class="quick-amount" onclick="setBetAmount(5)">$5</button>
                                    <button class="quick-amount" onclick="setBetAmount(10)">$10</button>
                                    <button class="quick-amount" onclick="setBetAmount(25)">$25</button>
                                    <button class="quick-amount" onclick="setBetAmount(50)">$50</button>
                                    <button class="quick-amount" onclick="setBetAmount(100)">$100</button>
                                    <button class="quick-amount max" onclick="setBetAmount(<?php echo $currentUser['balance']; ?>)">MAX</button>
                                </div>
                            </div>
                            
                            <div class="auto-cashout-section">
                                <label class="checkbox-label">
                                    <input type="checkbox" id="autoCashout">
                                    <span class="checkbox-custom"></span>
                                    <span class="checkbox-text">Auto Cash Out</span>
                                </label>
                                <div class="auto-cashout-input" id="autoCashoutInput" style="display: none;">
                                    <input type="number" 
                                           id="autoCashoutMultiplier" 
                                           min="1.01" 
                                           max="1000" 
                                           step="0.01" 
                                           value="2.00"
                                           placeholder="2.00">
                                    <span class="multiplier-suffix">x</span>
                                </div>
                            </div>
                            
                            <div class="betting-actions">
                                <button class="btn btn-primary btn-lg btn-place-bet" id="placeBetBtn" onclick="placeBet()">
                                    <i class="fas fa-rocket"></i>
                                    <span>Place Bet</span>
                                </button>
                                
                                <button class="btn btn-success btn-lg btn-cash-out" id="cashOutBtn" onclick="cashOut()" style="display: none;">
                                    <i class="fas fa-hand-paper"></i>
                                    <span>Cash Out</span>
                                    <div class="cash-out-amount" id="cashOutAmount">$0.00</div>
                                </button>
                            </div>
                        </div>
                        
                        <!-- Active Bet Display -->
                        <div class="active-bet" id="activeBet" style="display: none;">
                            <div class="bet-info">
                                <div class="bet-amount">
                                    <span class="label">Bet:</span>
                                    <span class="amount" id="activeBetAmount">$0.00</span>
                                </div>
                                <div class="potential-win">
                                    <span class="label">Potential Win:</span>
                                    <span class="amount" id="potentialWin">$0.00</span>
                                </div>
                            </div>
                            <div class="bet-status" id="betStatus">
                                <span class="status-text">Waiting for round...</span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Live Players -->
                    <div class="live-players-panel">
                        <div class="panel-header">
                            <h3>Live Players</h3>
                            <div class="players-count" id="playersCount">0 players</div>
                        </div>
                        
                        <div class="players-list" id="playersList">
                            <!-- Live players will be populated here -->
                        </div>
                    </div>
                    
                    <!-- Chat Panel -->
                    <div class="chat-panel">
                        <div class="panel-header">
                            <h3>Chat</h3>
                            <button class="chat-toggle" onclick="toggleChat()">
                                <i class="fas fa-comments"></i>
                            </button>
                        </div>
                        
                        <div class="chat-messages" id="chatMessages">
                            <!-- Chat messages will be populated here -->
                        </div>
                        
                        <div class="chat-input">
                            <input type="text" 
                                   id="chatMessageInput" 
                                   placeholder="Type a message..." 
                                   maxlength="200"
                                   onkeypress="handleChatKeyPress(event)">
                            <button class="send-btn" onclick="sendChatMessage()">
                                <i class="fas fa-paper-plane"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Game Statistics -->
    <section class="game-statistics">
        <div class="container">
            <div class="stats-grid">
                <!-- Top Winners Today -->
                <div class="stats-widget">
                    <div class="widget-header">
                        <h3>
                            <i class="fas fa-trophy"></i>
                            Top Winners Today
                        </h3>
                    </div>
                    <div class="winners-list">
                        <?php if (empty($topWinners)): ?>
                        <div class="empty-state">
                            <p>No winners yet today</p>
                        </div>
                        <?php else: ?>
                        <?php foreach ($topWinners as $index => $winner): ?>
                        <div class="winner-item">
                            <div class="winner-rank">#<?php echo $index + 1; ?></div>
                            <div class="winner-info">
                                <div class="winner-name"><?php echo htmlspecialchars($winner['username']); ?></div>
                                <div class="winner-details">
                                    $<?php echo number_format($winner['bet_amount'], 2); ?> @ <?php echo number_format($winner['multiplier'], 2); ?>x
                                </div>
                            </div>
                            <div class="winner-profit">
                                +$<?php echo number_format($winner['profit'], 2); ?>
                            </div>
                        </div>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Game Statistics -->
                <div class="stats-widget">
                    <div class="widget-header">
                        <h3>
                            <i class="fas fa-chart-bar"></i>
                            Game Statistics
                        </h3>
                    </div>
                    <div class="stats-list">
                        <div class="stat-row">
                            <span class="stat-label">Average Multiplier:</span>
                            <span class="stat-value"><?php echo number_format(array_sum(array_column($recentResults, 'multiplier')) / max(count($recentResults), 1), 2); ?>x</span>
                        </div>
                        <div class="stat-row">
                            <span class="stat-label">Highest Today:</span>
                            <span class="stat-value"><?php echo !empty($recentResults) ? number_format(max(array_column($recentResults, 'multiplier')), 2) : '0.00'; ?>x</span>
                        </div>
                        <div class="stat-row">
                            <span class="stat-label">Games > 2x:</span>
                            <span class="stat-value"><?php echo count(array_filter($recentResults, fn($r) => $r['multiplier'] >= 2)); ?>/<?php echo count($recentResults); ?></span>
                        </div>
                        <div class="stat-row">
                            <span class="stat-label">Games > 10x:</span>
                            <span class="stat-value"><?php echo count(array_filter($recentResults, fn($r) => $r['multiplier'] >= 10)); ?>/<?php echo count($recentResults); ?></span>
                        </div>
                    </div>
                </div>
                
                <!-- How to Play -->
                <div class="stats-widget">
                    <div class="widget-header">
                        <h3>
                            <i class="fas fa-question-circle"></i>
                            How to Play
                        </h3>
                    </div>
                    <div class="how-to-play">
                        <div class="step">
                            <div class="step-number">1</div>
                            <div class="step-text">Place your bet before the round starts</div>
                        </div>
                        <div class="step">
                            <div class="step-number">2</div>
                            <div class="step-text">Watch the multiplier rise</div>
                        </div>
                        <div class="step">
                            <div class="step-number">3</div>
                            <div class="step-text">Cash out before it crashes!</div>
                        </div>
                        <div class="step">
                            <div class="step-number">4</div>
                            <div class="step-text">Win = Bet × Multiplier</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Game Sounds -->
<audio id="soundBet" preload="auto">
    <source src="/assets/sounds/bet.mp3" type="audio/mpeg">
</audio>
<audio id="soundCashOut" preload="auto">
    <source src="/assets/sounds/cashout.mp3" type="audio/mpeg">
</audio>
<audio id="soundCrash" preload="auto">
    <source src="/assets/sounds/crash.mp3" type="audio/mpeg">
</audio>

<script>
// Initialize crash game
document.addEventListener('DOMContentLoaded', function() {
    initializeCrashGame();
});

// Game state
let gameState = {
    status: 'waiting', // waiting, running, crashed
    currentMultiplier: 1.00,
    startTime: null,
    activeBet: <?php echo $activeBet ? json_encode($activeBet) : 'null'; ?>,
    autoCashout: false,
    autoCashoutMultiplier: 2.00
};

function initializeCrashGame() {
    // Initialize WebSocket connection for real-time updates
    connectToGameServer();
    
    // Initialize chart
    initializeCrashChart();
    
    // Setup auto cashout toggle
    document.getElementById('autoCashout').addEventListener('change', function() {
        const autoCashoutInput = document.getElementById('autoCashoutInput');
        if (this.checked) {
            autoCashoutInput.style.display = 'block';
            gameState.autoCashout = true;
        } else {
            autoCashoutInput.style.display = 'none';
            gameState.autoCashout = false;
        }
    });
    
    // Setup auto cashout multiplier
    document.getElementById('autoCashoutMultiplier').addEventListener('input', function() {
        gameState.autoCashoutMultiplier = parseFloat(this.value) || 2.00;
    });
    
    // Load current game state
    loadGameState();
}

function connectToGameServer() {
    // This would connect to WebSocket server for real-time game updates
    // For demo purposes, we'll simulate with intervals
    
    // Simulate game rounds
    setInterval(() => {
        if (gameState.status === 'waiting') {
            startNewRound();
        }
    }, 10000); // New round every 10 seconds for demo
}

function loadGameState() {
    // Load current game state from server
    Crashify.api.request('/api/crash/state')
        .then(response => {
            if (response.success) {
                updateGameState(response.gameState);
            }
        })
        .catch(error => {
            console.error('Failed to load game state:', error);
        });
}

function updateGameState(newState) {
    gameState = { ...gameState, ...newState };
    
    // Update UI based on game state
    switch (gameState.status) {
        case 'waiting':
            showWaitingState();
            break;
        case 'running':
            showRunningState();
            break;
        case 'crashed':
            showCrashedState();
            break;
    }
}

function showWaitingState() {
    document.getElementById('statusWaiting').style.display = 'block';
    document.getElementById('statusRunning').style.display = 'none';
    document.getElementById('statusCrashed').style.display = 'none';
    
    // Enable betting
    document.getElementById('placeBetBtn').disabled = false;
    document.getElementById('cashOutBtn').style.display = 'none';
    
    // Start countdown
    startCountdown();
}

function showRunningState() {
    document.getElementById('statusWaiting').style.display = 'none';
    document.getElementById('statusRunning').style.display = 'block';
    document.getElementById('statusCrashed').style.display = 'none';
    
    // Disable betting, enable cash out if user has active bet
    document.getElementById('placeBetBtn').disabled = true;
    
    if (gameState.activeBet) {
        document.getElementById('cashOutBtn').style.display = 'block';
        updateCashOutButton();
    }
    
    // Start multiplier animation
    startMultiplierAnimation();
}

function showCrashedState() {
    document.getElementById('statusWaiting').style.display = 'none';
    document.getElementById('statusRunning').style.display = 'none';
    document.getElementById('statusCrashed').style.display = 'block';
    
    // Update crash multiplier
    document.getElementById('crashMultiplier').textContent = gameState.currentMultiplier.toFixed(2) + 'x';
    
    // Hide cash out button
    document.getElementById('cashOutBtn').style.display = 'none';
    
    // Play crash sound
    playSound('crash');
    
    // Show results after 3 seconds
    setTimeout(() => {
        showWaitingState();
    }, 3000);
}

function startCountdown() {
    let countdown = 5;
    const countdownElement = document.getElementById('countdown');
    
    const countdownInterval = setInterval(() => {
        countdownElement.textContent = countdown;
        countdown--;
        
        if (countdown < 0) {
            clearInterval(countdownInterval);
            // Start game round
            gameState.status = 'running';
            showRunningState();
        }
    }, 1000);
}

function startMultiplierAnimation() {
    gameState.startTime = Date.now();
    gameState.currentMultiplier = 1.00;
    
    const animationInterval = setInterval(() => {
        // Calculate multiplier based on time elapsed
        const elapsed = (Date.now() - gameState.startTime) / 1000;
        gameState.currentMultiplier = 1 + (elapsed * 0.1); // Simple linear growth
        
        // Update display
        document.getElementById('currentMultiplier').textContent = gameState.currentMultiplier.toFixed(2) + 'x';
        
        // Update chart
        updateCrashChart(gameState.currentMultiplier);
        
        // Check auto cashout
        if (gameState.autoCashout && gameState.activeBet && 
            gameState.currentMultiplier >= gameState.autoCashoutMultiplier) {
            cashOut();
        }
        
        // Random crash (for demo)
        if (Math.random() < 0.01 * elapsed) { // Increasing crash probability
            clearInterval(animationInterval);
            gameState.status = 'crashed';
            showCrashedState();
        }
        
        // Update cash out button
        if (gameState.activeBet) {
            updateCashOutButton();
        }
    }, 100);
}

function placeBet() {
    const betAmount = parseFloat(document.getElementById('betAmount').value);
    
    if (!betAmount || betAmount < 1) {
        Crashify.ui.toast.error('Please enter a valid bet amount');
        return;
    }
    
    if (betAmount > <?php echo $currentUser['balance']; ?>) {
        Crashify.ui.toast.error('Insufficient balance');
        return;
    }
    
    // Show loading
    const placeBetBtn = document.getElementById('placeBetBtn');
    placeBetBtn.classList.add('loading');
    placeBetBtn.disabled = true;
    
    // Place bet
    Crashify.api.request('/api/crash/bet', {
        method: 'POST',
        body: JSON.stringify({
            amount: betAmount,
            autoCashout: gameState.autoCashout,
            autoCashoutMultiplier: gameState.autoCashoutMultiplier
        })
    })
    .then(response => {
        if (response.success) {
            gameState.activeBet = response.bet;
            
            // Update UI
            showActiveBet();
            updateUserBalance(response.newBalance);
            
            // Play bet sound
            playSound('bet');
            
            Crashify.ui.toast.success('Bet placed successfully!');
        } else {
            throw new Error(response.message);
        }
    })
    .catch(error => {
        Crashify.ui.toast.error(error.message);
    })
    .finally(() => {
        placeBetBtn.classList.remove('loading');
        placeBetBtn.disabled = false;
    });
}

function cashOut() {
    if (!gameState.activeBet) return;
    
    // Show loading
    const cashOutBtn = document.getElementById('cashOutBtn');
    cashOutBtn.classList.add('loading');
    cashOutBtn.disabled = true;
    
    // Cash out
    Crashify.api.request('/api/crash/cashout', {
        method: 'POST',
        body: JSON.stringify({
            betId: gameState.activeBet.id,
            multiplier: gameState.currentMultiplier
        })
    })
    .then(response => {
        if (response.success) {
            const winAmount = response.winAmount;
            
            // Update UI
            hideActiveBet();
            updateUserBalance(response.newBalance);
            
            // Play cashout sound
            playSound('cashOut');
            
            // Show win notification
            Crashify.ui.toast.success(`Cashed out at ${gameState.currentMultiplier.toFixed(2)}x! Won $${winAmount.toFixed(2)}`);
            
            gameState.activeBet = null;
        } else {
            throw new Error(response.message);
        }
    })
    .catch(error => {
        Crashify.ui.toast.error(error.message);
    })
    .finally(() => {
        cashOutBtn.classList.remove('loading');
        cashOutBtn.disabled = false;
    });
}

function showActiveBet() {
    const activeBetElement = document.getElementById('activeBet');
    const bettingForm = document.getElementById('bettingForm');
    
    activeBetElement.style.display = 'block';
    bettingForm.style.display = 'none';
    
    document.getElementById('activeBetAmount').textContent = `$${gameState.activeBet.amount.toFixed(2)}`;
    updatePotentialWin();
}

function hideActiveBet() {
    const activeBetElement = document.getElementById('activeBet');
    const bettingForm = document.getElementById('bettingForm');
    
    activeBetElement.style.display = 'none';
    bettingForm.style.display = 'block';
}

function updatePotentialWin() {
    if (gameState.activeBet) {
        const potentialWin = gameState.activeBet.amount * gameState.currentMultiplier;
        document.getElementById('potentialWin').textContent = `$${potentialWin.toFixed(2)}`;
    }
}

function updateCashOutButton() {
    if (gameState.activeBet) {
        const cashOutAmount = gameState.activeBet.amount * gameState.currentMultiplier;
        document.getElementById('cashOutAmount').textContent = `$${cashOutAmount.toFixed(2)}`;
        updatePotentialWin();
    }
}

function setBetAmount(amount) {
    document.getElementById('betAmount').value = amount.toFixed(2);
}

function updateUserBalance(newBalance) {
    document.querySelector('.balance-amount').textContent = `$${newBalance.toFixed(2)}`;
    document.getElementById('headerBalance').textContent = `$${newBalance.toFixed(2)}`;
}

function playSound(soundName) {
    const audio = document.getElementById('sound' + soundName.charAt(0).toUpperCase() + soundName.slice(1));
    if (audio) {
        audio.currentTime = 0;
        audio.play().catch(e => console.log('Sound play failed:', e));
    }
}

// Chat functions
function toggleChat() {
    const chatPanel = document.querySelector('.chat-panel');
    chatPanel.classList.toggle('collapsed');
}

function handleChatKeyPress(event) {
    if (event.key === 'Enter') {
        sendChatMessage();
    }
}

function sendChatMessage() {
    const input = document.getElementById('chatMessageInput');
    const message = input.value.trim();
    
    if (!message) return;
    
    // Send message to server
    Crashify.api.request('/api/chat/send', {
        method: 'POST',
        body: JSON.stringify({ message })
    })
    .then(response => {
        if (response.success) {
            input.value = '';
        }
    })
    .catch(error => {
        Crashify.ui.toast.error('Failed to send message');
    });
}

// Chart functions (simplified)
function initializeCrashChart() {
    // Initialize chart canvas
    const canvas = document.getElementById('crashChart');
    const ctx = canvas.getContext('2d');
    
    // Basic chart setup
    ctx.strokeStyle = '#00ff88';
    ctx.lineWidth = 3;
    ctx.fillStyle = 'rgba(0, 255, 136, 0.1)';
}

function updateCrashChart(multiplier) {
    // Update chart with new multiplier point
    // This would be more complex in a real implementation
    console.log('Chart updated with multiplier:', multiplier);
}
</script>

<?php include '../includes/footer.php'; ?>

PHP
); ?>

<?php _merge_exec('pages/dashboard.php', <<<'PHP'
<?php
// pages/dashboard.php - User Dashboard
// داشبورد کاربر

require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// Require authentication
requireAuth();

// Page settings
$pageTitle = 'Dashboard - ' . $currentUser['username'];
$bodyClass = 'dashboard-page';
$breadcrumbs = [
    ['title' => 'Dashboard']
];

// Get user statistics
$userStats = [
    'total_bets' => $currentUser['total_bets'] ?? 0,
    'total_wins' => $currentUser['total_wins'] ?? 0,
    'total_losses' => $currentUser['total_losses'] ?? 0,
    'win_rate' => $currentUser['win_rate'] ?? 0,
    'total_wagered' => $currentUser['total_wagered'] ?? 0,
    'total_winnings' => $currentUser['total_winnings'] ?? 0,
    'profit_loss' => ($currentUser['total_winnings'] ?? 0) - ($currentUser['total_wagered'] ?? 0)
];

// Get recent bets
$recentBets = fetchAll(
    "SELECT b.*, s.name as sport_name, s.icon as sport_icon,
            e.home_team, e.away_team, e.league_name
     FROM bets b
     LEFT JOIN events e ON b.event_id = e.id
     LEFT JOIN sports s ON e.sport_id = s.id
     WHERE b.user_id = ?
     ORDER BY b.created_at DESC
     LIMIT 10",
    [$currentUser['id']]
);

// Get active bonuses
$activeBonuses = fetchAll(
    "SELECT ub.*, b.title, b.type, b.description
     FROM user_bonuses ub
     JOIN bonuses b ON ub.bonus_id = b.id
     WHERE ub.user_id = ? AND ub.status = 'active'
     ORDER BY ub.expires_at ASC
     LIMIT 5",
    [$currentUser['id']]
);

// Get recent transactions
$recentTransactions = fetchAll(
    "SELECT * FROM transactions
     WHERE user_id = ?
     ORDER BY created_at DESC
     LIMIT 10",
    [$currentUser['id']]
);

// Get notifications
$notifications = fetchAll(
    "SELECT * FROM notifications
     WHERE user_id = ? AND read_at IS NULL
     ORDER BY created_at DESC
     LIMIT 5",
    [$currentUser['id']]
);

// Get favorite events
$favoriteEvents = fetchAll(
    "SELECT e.*, s.name as sport_name, s.icon as sport_icon
     FROM events e
     JOIN user_favorites uf ON e.id = uf.event_id
     JOIN sports s ON e.sport_id = s.id
     WHERE uf.user_id = ? AND e.status IN ('upcoming', 'live')
     ORDER BY e.start_time ASC
     LIMIT 5",
    [$currentUser['id']]
);

$additionalScripts = [
    '/assets/js/dashboard.js',
    '/assets/js/charts.js'
];

include '../includes/header.php';
?>

<!-- Dashboard Header -->
<section class="dashboard-header">
    <div class="container">
        <div class="header-content">
            <div class="user-welcome">
                <div class="user-avatar">
                    <?php if ($currentUser['avatar']): ?>
                    <img src="<?php echo $currentUser['avatar']; ?>" alt="<?php echo $currentUser['username']; ?>">
                    <?php else: ?>
                    <div class="avatar-placeholder">
                        <?php echo strtoupper(substr($currentUser['username'], 0, 2)); ?>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="welcome-text">
                    <h1 class="welcome-title">Welcome back, <?php echo $currentUser['first_name'] ?: $currentUser['username']; ?>!</h1>
                    <p class="welcome-subtitle">
                        Member since <?php echo date('M Y', strtotime($currentUser['created_at'])); ?>
                        <?php if ($currentUser['vip_level']): ?>
                        • <span class="vip-badge">VIP Level <?php echo $currentUser['vip_level']; ?></span>
                        <?php endif; ?>
                    </p>
                </div>
            </div>
            
            <div class="quick-actions">
                <a href="/pages/wallet.php" class="quick-action deposit">
                    <i class="fas fa-plus"></i>
                    <span>Deposit</span>
                </a>
                <a href="/pages/sportsbook.php" class="quick-action bet">
                    <i class="fas fa-futbol"></i>
                    <span>Bet Now</span>
                </a>
                <a href="/pages/casino.php" class="quick-action casino">
                    <i class="fas fa-dice"></i>
                    <span>Casino</span>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Balance Cards -->
<section class="balance-section">
    <div class="container">
        <div class="balance-cards">
            <div class="balance-card main">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-wallet"></i>
                        Main Balance
                    </h3>
                    <button class="refresh-btn" onclick="refreshBalance()">
                        <i class="fas fa-sync-alt"></i>
                    </button>
                </div>
                <div class="balance-amount">
                    <span class="currency">$</span>
                    <span class="amount" id="mainBalance"><?php echo number_format($currentUser['balance'], 2); ?></span>
                </div>
                <div class="balance-actions">
                    <a href="/pages/wallet.php?action=deposit" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus"></i>
                        Deposit
                    </a>
                    <a href="/pages/wallet.php?action=withdraw" class="btn btn-outline btn-sm">
                        <i class="fas fa-minus"></i>
                        Withdraw
                    </a>
                </div>
            </div>
            
            <div class="balance-card bonus">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-gift"></i>
                        Bonus Balance
                    </h3>
                </div>
                <div class="balance-amount">
                    <span class="currency">$</span>
                    <span class="amount"><?php echo number_format($currentUser['bonus_balance'] ?? 0, 2); ?></span>
                </div>
                <div class="balance-info">
                    <span class="info-text">
                        <?php echo count($activeBonuses); ?> active bonus<?php echo count($activeBonuses) !== 1 ? 'es' : ''; ?>
                    </span>
                </div>
            </div>
            
            <div class="balance-card loyalty">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-star"></i>
                        Loyalty Points
                    </h3>
                </div>
                <div class="balance-amount">
                    <span class="amount"><?php echo number_format($currentUser['loyalty_points'] ?? 0); ?></span>
                    <span class="unit">pts</span>
                </div>
                <div class="balance-info">
                    <a href="/pages/vip.php" class="info-link">View VIP Benefits</a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Statistics Overview -->
<section class="stats-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-chart-bar"></i>
                Your Statistics
            </h2>
            <div class="time-filter">
                <select id="statsTimeFilter" onchange="updateStats()">
                    <option value="7">Last 7 days</option>
                    <option value="30" selected>Last 30 days</option>
                    <option value="90">Last 90 days</option>
                    <option value="365">Last year</option>
                    <option value="all">All time</option>
                </select>
            </div>
        </div>
        
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-dice"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo number_format($userStats['total_bets']); ?></div>
                    <div class="stat-label">Total Bets</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-trophy"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo number_format($userStats['total_wins']); ?></div>
                    <div class="stat-label">Wins</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-percentage"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value"><?php echo number_format($userStats['win_rate'], 1); ?>%</div>
                    <div class="stat-label">Win Rate</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value">$<?php echo number_format($userStats['total_wagered'], 2); ?></div>
                    <div class="stat-label">Total Wagered</div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-money-bill-wave"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value">$<?php echo number_format($userStats['total_winnings'], 2); ?></div>
                    <div class="stat-label">Total Winnings</div>
                </div>
            </div>
            
            <div class="stat-card <?php echo $userStats['profit_loss'] >= 0 ? 'positive' : 'negative'; ?>">
                <div class="stat-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-value">
                        <?php echo $userStats['profit_loss'] >= 0 ? '+' : ''; ?>$<?php echo number_format($userStats['profit_loss'], 2); ?>
                    </div>
                    <div class="stat-label">Profit/Loss</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Main Dashboard Content -->
<div class="dashboard-content">
    <div class="container">
        <div class="dashboard-grid">
            <!-- Left Column -->
            <div class="dashboard-left">
                <!-- Recent Bets -->
                <div class="dashboard-widget">
                    <div class="widget-header">
                        <h3 class="widget-title">
                            <i class="fas fa-history"></i>
                            Recent Bets
                        </h3>
                        <a href="/pages/bet-history.php" class="view-all-link">View All</a>
                    </div>
                    <div class="widget-content">
                        <?php if (empty($recentBets)): ?>
                        <div class="empty-state">
                            <i class="fas fa-dice"></i>
                            <p>No bets placed yet</p>
                            <a href="/pages/sportsbook.php" class="btn btn-primary btn-sm">Place Your First Bet</a>
                        </div>
                        <?php else: ?>
                        <div class="bets-list">
                            <?php foreach ($recentBets as $bet): ?>
                            <div class="bet-item">
                                <div class="bet-info">
                                    <div class="bet-event">
                                        <i class="<?php echo $bet['sport_icon']; ?>"></i>
                                        <span class="event-name">
                                            <?php echo $bet['home_team'] . ' vs ' . $bet['away_team']; ?>
                                        </span>
                                    </div>
                                    <div class="bet-details">
                                        <span class="bet-type"><?php echo ucfirst($bet['bet_type']); ?></span>
                                        <span class="bet-odds">@<?php echo number_format($bet['odds'], 2); ?></span>
                                    </div>
                                </div>
                                <div class="bet-amount">
                                    <div class="stake">$<?php echo number_format($bet['stake'], 2); ?></div>
                                    <div class="status status-<?php echo $bet['status']; ?>">
                                        <?php echo ucfirst($bet['status']); ?>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Active Bonuses -->
                <?php if (!empty($activeBonuses)): ?>
                <div class="dashboard-widget">
                    <div class="widget-header">
                        <h3 class="widget-title">
                            <i class="fas fa-gift"></i>
                            Active Bonuses
                        </h3>
                        <a href="/pages/promotions.php" class="view-all-link">View All</a>
                    </div>
                    <div class="widget-content">
                        <div class="bonuses-list">
                            <?php foreach ($activeBonuses as $bonus): ?>
                            <div class="bonus-item">
                                <div class="bonus-info">
                                    <h4 class="bonus-title"><?php echo $bonus['title']; ?></h4>
                                    <div class="bonus-amount">$<?php echo number_format($bonus['amount'], 2); ?></div>
                                </div>
                                <div class="bonus-progress">
                                    <div class="progress-bar">
                                        <div class="progress-fill" style="width: <?php echo min(100, ($bonus['wagered_amount'] / $bonus['wagering_requirement']) * 100); ?>%"></div>
                                    </div>
                                    <div class="progress-text">
                                        <?php echo number_format(($bonus['wagered_amount'] / $bonus['wagering_requirement']) * 100, 1); ?>% complete
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            
            <!-- Right Column -->
            <div class="dashboard-right">
                <!-- Notifications -->
                <?php if (!empty($notifications)): ?>
                <div class="dashboard-widget">
                    <div class="widget-header">
                        <h3 class="widget-title">
                            <i class="fas fa-bell"></i>
                            Notifications
                            <span class="notification-count"><?php echo count($notifications); ?></span>
                        </h3>
                        <button class="mark-all-read" onclick="markAllNotificationsRead()">Mark all read</button>
                    </div>
                    <div class="widget-content">
                        <div class="notifications-list">
                            <?php foreach ($notifications as $notification): ?>
                            <div class="notification-item" data-id="<?php echo $notification['id']; ?>">
                                <div class="notification-icon">
                                    <i class="<?php echo $notification['icon'] ?? 'fas fa-info-circle'; ?>"></i>
                                </div>
                                <div class="notification-content">
                                    <h4 class="notification-title"><?php echo $notification['title']; ?></h4>
                                    <p class="notification-message"><?php echo $notification['message']; ?></p>
                                    <span class="notification-time"><?php echo timeAgo($notification['created_at']); ?></span>
                                </div>
                                <button class="notification-close" onclick="markNotificationRead(<?php echo $notification['id']; ?>)">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                
                <!-- Recent Transactions -->
                <div class="dashboard-widget">
                    <div class="widget-header">
                        <h3 class="widget-title">
                            <i class="fas fa-exchange-alt"></i>
                            Recent Transactions
                        </h3>
                        <a href="/pages/wallet.php" class="view-all-link">View All</a>
                    </div>
                    <div class="widget-content">
                        <?php if (empty($recentTransactions)): ?>
                        <div class="empty-state">
                            <i class="fas fa-receipt"></i>
                            <p>No transactions yet</p>
                        </div>
                        <?php else: ?>
                        <div class="transactions-list">
                            <?php foreach ($recentTransactions as $transaction): ?>
                            <div class="transaction-item">
                                <div class="transaction-icon">
                                    <i class="fas fa-<?php echo $transaction['type'] === 'deposit' ? 'plus' : 'minus'; ?>"></i>
                                </div>
                                <div class="transaction-info">
                                    <div class="transaction-type"><?php echo ucfirst($transaction['type']); ?></div>
                                    <div class="transaction-method"><?php echo $transaction['payment_method']; ?></div>
                                    <div class="transaction-time"><?php echo timeAgo($transaction['created_at']); ?></div>
                                </div>
                                <div class="transaction-amount">
                                    <div class="amount <?php echo $transaction['type']; ?>">
                                        <?php echo $transaction['type'] === 'deposit' ? '+' : '-'; ?>$<?php echo number_format($transaction['amount'], 2); ?>
                                    </div>
                                    <div class="status status-<?php echo $transaction['status']; ?>">
                                        <?php echo ucfirst($transaction['status']); ?>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Favorite Events -->
                <?php if (!empty($favoriteEvents)): ?>
                <div class="dashboard-widget">
                    <div class="widget-header">
                        <h3 class="widget-title">
                            <i class="fas fa-star"></i>
                            Favorite Events
                        </h3>
                    </div>
                    <div class="widget-content">
                        <div class="events-list">
                            <?php foreach ($favoriteEvents as $event): ?>
                            <div class="event-item">
                                <div class="event-info">
                                    <i class="<?php echo $event['sport_icon']; ?>"></i>
                                    <div class="event-details">
                                        <div class="event-teams"><?php echo $event['home_team'] . ' vs ' . $event['away_team']; ?></div>
                                        <div class="event-time"><?php echo formatEventDate($event['start_time']); ?></div>
                                    </div>
                                </div>
                                <a href="/pages/event-details.php?id=<?php echo $event['id']; ?>" class="btn btn-outline btn-xs">
                                    Bet
                                </a>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    initializeDashboard();
});

function initializeDashboard() {
    // Initialize dashboard functionality
    updateLastActivity();
    
    // Auto-refresh balance every 30 seconds
    setInterval(refreshBalance, 30000);
    
    // Auto-refresh notifications every 60 seconds
    setInterval(refreshNotifications, 60000);
}

function refreshBalance() {
    Crashify.api.request('/api/user/balance')
        .then(response => {
            if (response.success) {
                document.getElementById('mainBalance').textContent = response.balance.toFixed(2);
            }
        })
        .catch(error => {
            console.error('Failed to refresh balance:', error);
        });
}

function updateStats() {
    const timeFilter = document.getElementById('statsTimeFilter').value;
    
    Crashify.api.request(`/api/user/stats?period=${timeFilter}`)
        .then(response => {
            if (response.success) {
                // Update stats display
                updateStatsDisplay(response.stats);
            }
        })
        .catch(error => {
            console.error('Failed to update stats:', error);
        });
}

function markNotificationRead(notificationId) {
    Crashify.api.request(`/api/notifications/${notificationId}/read`, {
        method: 'POST'
    })
    .then(response => {
        if (response.success) {
            const notificationElement = document.querySelector(`[data-id="${notificationId}"]`);
            if (notificationElement) {
                notificationElement.remove();
            }
        }
    });
}

function markAllNotificationsRead() {
    Crashify.api.request('/api/notifications/mark-all-read', {
        method: 'POST'
    })
    .then(response => {
        if (response.success) {
            const notificationsList = document.querySelector('.notifications-list');
            if (notificationsList) {
                notificationsList.innerHTML = '<div class="empty-state"><i class="fas fa-check"></i><p>All notifications read</p></div>';
            }
        }
    });
}

function refreshNotifications() {
    Crashify.api.request('/api/notifications/unread')
        .then(response => {
            if (response.success && response.notifications.length > 0) {
                // Update notifications display
                updateNotificationsDisplay(response.notifications);
            }
        })
        .catch(error => {
            console.error('Failed to refresh notifications:', error);
        });
}

function updateLastActivity() {
    // Update user's last activity timestamp
    Crashify.api.request('/api/user/activity', {
        method: 'POST'
    });
}
</script>

<?php include '../includes/footer.php'; ?>
PHP
); ?>

<?php _merge_exec('pages/live-betting.php', <<<'PHP'
<?php
// pages/live-betting.php - Live Betting Page
// صفحه شرط‌بندی زنده

require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// Page settings
$pageTitle = 'Live Betting - In-Play Sports Betting';
$bodyClass = 'live-betting-page';
$breadcrumbs = [
    ['title' => 'Sportsbook', 'url' => '/pages/sportsbook.php'],
    ['title' => 'Live Betting']
];

// Get filters from URL
$selectedSport = $_GET['sport'] ?? 'all';
$sortBy = $_GET['sort'] ?? 'time';
$searchQuery = $_GET['search'] ?? '';

// Get live events
$liveEvents = getLiveEvents(100);

// Filter events
if ($selectedSport !== 'all') {
    $liveEvents = array_filter($liveEvents, fn($event) => $event['sport_slug'] === $selectedSport);
}

if ($searchQuery) {
    $liveEvents = array_filter($liveEvents, function($event) use ($searchQuery) {
        return stripos($event['home_team'], $searchQuery) !== false ||
               stripos($event['away_team'], $searchQuery) !== false ||
               stripos($event['league_name'], $searchQuery) !== false;
    });
}

// Sort events
usort($liveEvents, function($a, $b) use ($sortBy) {
    switch ($sortBy) {
        case 'league':
            return strcmp($a['league_name'], $b['league_name']);
        case 'sport':
            return strcmp($a['sport_name'], $b['sport_name']);
        case 'time':
        default:
            return strcmp($a['start_time'], $b['start_time']);
    }
});

// Get sports with live events
$liveSports = [];
foreach ($liveEvents as $event) {
    $sportSlug = $event['sport_slug'] ?? strtolower(str_replace(' ', '-', $event['sport_name']));
    if (!isset($liveSports[$sportSlug])) {
        $liveSports[$sportSlug] = [
            'name' => $event['sport_name'],
            'icon' => $event['sport_icon'],
            'count' => 0
        ];
    }
    $liveSports[$sportSlug]['count']++;
}

$additionalScripts = [
    '/assets/js/betting.js',
    '/assets/js/live-betting.js'
];

include '../includes/header.php';
?>

<!-- Hero Section -->
<section class="live-betting-hero">
    <div class="container">
        <div class="hero-content">
            <div class="hero-text">
                <h1 class="hero-title">
                    <i class="fas fa-broadcast-tower"></i>
                    Live Betting
                    <span class="live-indicator">LIVE</span>
                </h1>
                <p class="hero-description">
                    Experience the thrill of in-play betting with real-time odds updates, 
                    live streaming, and instant bet placement on ongoing matches.
                </p>
                <div class="hero-stats">
                    <div class="stat-item">
                        <div class="stat-number live-counter" data-count="<?php echo count($liveEvents); ?>">
                            <?php echo count($liveEvents); ?>
                        </div>
                        <div class="stat-label">Live Events</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number"><?php echo count($liveSports); ?></div>
                        <div class="stat-label">Sports</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number">24/7</div>
                        <div class="stat-label">Coverage</div>
                    </div>
                </div>
            </div>
            <div class="hero-visual">
                <div class="live-match-card">
                    <div class="match-header">
                        <span class="live-badge pulsing">LIVE</span>
                        <span class="match-time">78'</span>
                    </div>
                    <div class="match-teams">
                        <div class="team">
                            <img src="/assets/images/teams/manchester-united.png" alt="Manchester United">
                            <span class="team-name">Man United</span>
                            <span class="score">2</span>
                        </div>
                        <div class="vs">-</div>
                        <div class="team">
                            <img src="/assets/images/teams/liverpool.png" alt="Liverpool">
                            <span class="team-name">Liverpool</span>
                            <span class="score">1</span>
                        </div>
                    </div>
                    <div class="live-odds">
                        <button class="odds-btn">2.10</button>
                        <button class="odds-btn">3.40</button>
                        <button class="odds-btn">3.20</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Live Sports Navigation -->
<section class="live-sports-nav">
    <div class="container">
        <div class="sports-tabs">
            <a href="?sport=all" class="sport-tab <?php echo $selectedSport === 'all' ? 'active' : ''; ?>">
                <i class="fas fa-globe"></i>
                <span>All Sports</span>
                <span class="event-count"><?php echo count($liveEvents); ?></span>
            </a>
            <?php foreach ($liveSports as $slug => $sport): ?>
            <a href="?sport=<?php echo $slug; ?>" 
               class="sport-tab <?php echo $selectedSport === $slug ? 'active' : ''; ?>">
                <i class="<?php echo $sport['icon']; ?>"></i>
                <span><?php echo $sport['name']; ?></span>
                <span class="event-count"><?php echo $sport['count']; ?></span>
            </a>
            <?php endforeach; ?>
        </div>
        
        <div class="nav-actions">
            <div class="auto-refresh">
                <label class="toggle-switch">
                    <input type="checkbox" id="autoRefresh" checked>
                    <span class="toggle-slider"></span>
                </label>
                <span>Auto Refresh</span>
            </div>
            <button class="refresh-btn" onclick="refreshLiveData()">
                <i class="fas fa-sync-alt"></i>
                <span>Refresh</span>
            </button>
        </div>
    </div>
</section>

<!-- Live Events -->
<section class="live-events-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-circle live-dot"></i>
                Live Events
                <?php if ($searchQuery): ?>
                <span class="search-results">- Results for "<?php echo htmlspecialchars($searchQuery); ?>"</span>
                <?php endif; ?>
            </h2>
            <div class="results-count">
                <span class="count"><?php echo count($liveEvents); ?></span>
                <span class="label">live events</span>
                <div class="last-update">
                    Last updated: <span id="lastUpdate"><?php echo date('H:i:s'); ?></span>
                </div>
            </div>
        </div>
        
        <?php if (empty($liveEvents)): ?>
        <div class="empty-state">
            <div class="empty-icon">
                <i class="fas fa-broadcast-tower"></i>
            </div>
            <h3>No Live Events</h3>
            <p>There are currently no live events. Check back soon!</p>
            <div class="empty-actions">
                <a href="/pages/sportsbook.php" class="btn btn-outline">View Upcoming Events</a>
            </div>
        </div>
        <?php else: ?>
        <div class="live-events-container" id="liveEventsContainer">
            <?php foreach ($liveEvents as $event): ?>
            <div class="live-event-card" data-event-id="<?php echo $event['id']; ?>">
                <div class="event-header">
                    <div class="event-meta">
                        <div class="sport-league">
                            <i class="<?php echo $event['sport_icon']; ?>"></i>
                            <span class="sport-name"><?php echo $event['sport_name']; ?></span>
                            <span class="separator">•</span>
                            <span class="league-name"><?php echo $event['league_name']; ?></span>
                        </div>
                        <div class="live-status">
                            <span class="live-badge pulsing">LIVE</span>
                            <span class="match-time"><?php echo $event['match_time']; ?>'</span>
                        </div>
                    </div>
                    
                    <div class="event-actions">
                        <button class="action-btn favorite" onclick="toggleFavorite(<?php echo $event['id']; ?>)">
                            <i class="far fa-star"></i>
                        </button>
                        <?php if ($event['live_streaming']): ?>
                        <button class="action-btn stream" onclick="openStream(<?php echo $event['id']; ?>)">
                            <i class="fas fa-play"></i>
                            <span>Stream</span>
                        </button>
                        <?php endif; ?>
                        <button class="action-btn stats" onclick="showMatchStats(<?php echo $event['id']; ?>)">
                            <i class="fas fa-chart-bar"></i>
                            <span>Stats</span>
                        </button>
                    </div>
                </div>
                
                <div class="match-info">
                    <div class="teams-section">
                        <div class="team home">
                            <div class="team-info">
                                <img src="<?php echo $event['home_team_logo'] ?: '/assets/images/default-team.png'; ?>" 
                                     alt="<?php echo $event['home_team']; ?>" class="team-logo">
                                <span class="team-name"><?php echo $event['home_team']; ?></span>
                            </div>
                            <div class="team-score"><?php echo $event['home_score']; ?></div>
                        </div>
                        
                        <div class="match-center">
                            <div class="score-display">
                                <span class="score"><?php echo $event['home_score']; ?> - <?php echo $event['away_score']; ?></span>
                            </div>
                        </div>
                        
                        <div class="team away">
                            <div class="team-score"><?php echo $event['away_score']; ?></div>
                            <div class="team-info">
                                <img src="<?php echo $event['away_team_logo'] ?: '/assets/images/default-team.png'; ?>" 
                                     alt="<?php echo $event['away_team']; ?>" class="team-logo">
                                <span class="team-name"><?php echo $event['away_team']; ?></span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="betting-section">
                    <div class="main-markets">
                        <div class="market-group">
                            <h4 class="market-title">Match Result</h4>
                            <div class="odds-row">
                                <?php if ($event['home_odds']): ?>
                                <button class="odds-btn home" onclick="addToBetSlip(<?php echo $event['id']; ?>, 'home', <?php echo $event['home_odds']; ?>)">
                                    <span class="label">1</span>
                                    <span class="odds"><?php echo number_format($event['home_odds'], 2); ?></span>
                                </button>
                                <?php endif; ?>
                                
                                <?php if ($event['draw_odds']): ?>
                                <button class="odds-btn draw" onclick="addToBetSlip(<?php echo $event['id']; ?>, 'draw', <?php echo $event['draw_odds']; ?>)">
                                    <span class="label">X</span>
                                    <span class="odds"><?php echo number_format($event['draw_odds'], 2); ?></span>
                                </button>
                                <?php endif; ?>
                                
                                <?php if ($event['away_odds']): ?>
                                <button class="odds-btn away" onclick="addToBetSlip(<?php echo $event['id']; ?>, 'away', <?php echo $event['away_odds']; ?>)">
                                    <span class="label">2</span>
                                    <span class="odds"><?php echo number_format($event['away_odds'], 2); ?></span>
                                </button>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="more-markets">
                            <button class="btn btn-outline btn-sm" onclick="showAllMarkets(<?php echo $event['id']; ?>)">
                                +<?php echo $event['total_markets'] ?? 50; ?> Markets
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    initializeLiveBetting();
    
    // Auto refresh if enabled
    const autoRefresh = document.getElementById('autoRefresh');
    if (autoRefresh && autoRefresh.checked) {
        setInterval(refreshLiveData, 15000); // Every 15 seconds
    }
});

function initializeLiveBetting() {
    // Initialize live betting functionality
    updateMatchTimes();
    setInterval(updateMatchTimes, 60000); // Update every minute
}

function refreshLiveData() {
    Crashify.api.request('/api/live-events/refresh')
        .then(response => {
            if (response.success) {
                updateLiveEvents(response.events);
                document.getElementById('lastUpdate').textContent = new Date().toLocaleTimeString();
            }
        })
        .catch(error => {
            console.error('Failed to refresh live data:', error);
        });
}

function updateMatchTimes() {
    const timeElements = document.querySelectorAll('.match-time');
    timeElements.forEach(element => {
        // Update match time logic would go here
    });
}

function openStream(eventId) {
    // Open live stream modal
    Crashify.ui.showModal('streamModal');
}

function showMatchStats(eventId) {
    // Show match statistics
    Crashify.api.request(`/api/events/${eventId}/stats`)
        .then(response => {
            if (response.success) {
                // Display stats
            }
        });
}

function showAllMarkets(eventId) {
    // Show all betting markets for event
    window.location.href = `/pages/event-details.php?id=${eventId}`;
}
</script>

<?php include '../includes/footer.php'; ?>

PHP
); ?>

<?php _merge_exec('pages/login.php', <<<'PHP'
<?php
// pages/login.php - Login Page
// صفحه ورود

require_once '../includes/functions.php';

$page_title = 'ورود';
$current_page = 'login';

// Redirect if already logged in
if (isLoggedIn()) {
    header('Location: /pages/dashboard.php');
    exit;
}

$error_message = '';
$success_message = '';

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = sanitizeInput($_POST['email']);
    $password = $_POST['password'];
    $remember_me = isset($_POST['remember_me']);
    
    if (empty($email) || empty($password)) {
        $error_message = 'لطفاً تمام فیلدها را پر کنید';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error_message = 'ایمیل نامعتبر است';
    } else {
        // Check user credentials
        $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? AND status = 'active'");
        $stmt->execute([$email]);
        $user = $stmt->fetch();
        
        if ($user && password_verify($password, $user['password'])) {
            // Check if account is banned
            if ($user['status'] === 'banned') {
                $error_message = 'حساب کاربری شما مسدود شده است';
            } else {
                // Login successful
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['user_name'] = $user['first_name'] . ' ' . $user['last_name'];
                $_SESSION['user_role'] = $user['role'];
                $_SESSION['user_language'] = $user['language'] ?: 'fa';
                
                // Update last login
                $stmt = $pdo->prepare("UPDATE users SET last_login = NOW(), last_ip = ? WHERE id = ?");
                $stmt->execute([$_SERVER['REMOTE_ADDR'], $user['id']]);
                
                // Handle remember me
                if ($remember_me) {
                    $token = bin2hex(random_bytes(32));
                    $expires = date('Y-m-d H:i:s', strtotime('+30 days'));
                    
                    // Store remember token
                    $stmt = $pdo->prepare("
                        INSERT INTO user_sessions (user_id, token, expires_at, created_at) 
                        VALUES (?, ?, ?, NOW())
                        ON DUPLICATE KEY UPDATE token = VALUES(token), expires_at = VALUES(expires_at)
                    ");
                    $stmt->execute([$user['id'], hash('sha256', $token), $expires]);
                    
                    // Set cookie
                    setcookie('remember_token', $token, strtotime('+30 days'), '/', '', true, true);
                }
                
                // Log login activity
                $stmt = $pdo->prepare("
                    INSERT INTO user_activity (user_id, activity_type, description, ip_address, user_agent, created_at)
                    VALUES (?, 'login', 'User logged in', ?, ?, NOW())
                ");
                $stmt->execute([$user['id'], $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT']]);
                
                // Redirect to intended page or dashboard
                $redirect_url = $_SESSION['redirect_after_login'] ?? '/pages/dashboard.php';
                unset($_SESSION['redirect_after_login']);
                
                header('Location: ' . $redirect_url);
                exit;
            }
        } else {
            $error_message = 'ایمیل یا رمز عبور اشتباه است';
            
            // Log failed login attempt
            $stmt = $pdo->prepare("
                INSERT INTO login_attempts (email, ip_address, user_agent, success, created_at)
                VALUES (?, ?, ?, 0, NOW())
            ");
            $stmt->execute([$email, $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT']]);
        }
    }
}

// Check for password reset success message
if (isset($_GET['reset']) && $_GET['reset'] === 'success') {
    $success_message = 'رمز عبور با موفقیت تغییر کرد. اکنون می‌توانید وارد شوید';
}

// Check for registration success message
if (isset($_GET['registered']) && $_GET['registered'] === 'success') {
    $success_message = 'ثبت نام با موفقیت انجام شد. اکنون می‌توانید وارد شوید';
}

include '../includes/header.php';
?>

<div class="auth-container">
    <div class="auth-wrapper">
        <div class="auth-card">
            <div class="auth-header">
                <div class="auth-logo">
                    <img src="/assets/images/logo.png" alt="Crashify" class="logo-img">
                    <h2>Crashify</h2>
                </div>
                <h3>ورود به حساب کاربری</h3>
                <p class="text-muted">به دنیای هیجان‌انگیز شرط‌بندی خوش آمدید</p>
            </div>
            
            <div class="auth-body">
                <?php if ($error_message): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle"></i>
                        <?php echo $error_message; ?>
                    </div>
                <?php endif; ?>
                
                <?php if ($success_message): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i>
                        <?php echo $success_message; ?>
                    </div>
                <?php endif; ?>
                
                <form method="POST" class="auth-form" id="loginForm">
                    <div class="form-group">
                        <label for="email">
                            <i class="fas fa-envelope"></i>
                            ایمیل
                        </label>
                        <input type="email" class="form-control" id="email" name="email" 
                               value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" 
                               placeholder="ایمیل خود را وارد کنید" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="password">
                            <i class="fas fa-lock"></i>
                            رمز عبور
                        </label>
                        <div class="password-input">
                            <input type="password" class="form-control" id="password" name="password" 
                                   placeholder="رمز عبور خود را وارد کنید" required>
                            <button type="button" class="password-toggle" onclick="togglePassword('password')">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="form-options">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="remember_me" name="remember_me">
                            <label class="custom-control-label" for="remember_me">
                                مرا به خاطر بسپار
                            </label>
                        </div>
                        
                        <a href="/auth/forgot-password.php" class="forgot-password-link">
                            رمز عبور را فراموش کرده‌اید؟
                        </a>
                    </div>
                    
                    <button type="submit" class="btn btn-primary btn-block auth-submit-btn">
                        <i class="fas fa-sign-in-alt"></i>
                        ورود
                    </button>
                </form>
                
                <!-- Social Login -->
                <div class="social-login">
                    <div class="divider">
                        <span>یا</span>
                    </div>
                    
                    <div class="social-buttons">
                        <button class="btn btn-social btn-google" onclick="socialLogin('google')">
                            <i class="fab fa-google"></i>
                            ورود با گوگل
                        </button>
                        
                        <button class="btn btn-social btn-facebook" onclick="socialLogin('facebook')">
                            <i class="fab fa-facebook-f"></i>
                            ورود با فیسبوک
                        </button>
                    </div>
                </div>
                
                <!-- Quick Demo Login -->
                <div class="demo-login">
                    <h6>ورود سریع برای تست:</h6>
                    <div class="demo-buttons">
                        <button class="btn btn-outline-secondary btn-sm" onclick="demoLogin('user')">
                            <i class="fas fa-user"></i>
                            کاربر عادی
                        </button>
                        <button class="btn btn-outline-warning btn-sm" onclick="demoLogin('admin')">
                            <i class="fas fa-user-shield"></i>
                            مدیر
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="auth-footer">
                <p>
                    حساب کاربری ندارید؟
                    <a href="/auth/register.php" class="register-link">
                        <strong>ثبت نام کنید</strong>
                    </a>
                </p>
                
                <div class="auth-links">
                    <a href="/pages/support.php">پشتیبانی</a>
                    <a href="/pages/terms.php">قوانین</a>
                    <a href="/pages/privacy.php">حریم خصوصی</a>
                </div>
            </div>
        </div>
        
        <!-- Features Sidebar -->
        <div class="features-sidebar">
            <div class="features-content">
                <h4>چرا Crashify؟</h4>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <div class="feature-text">
                        <h6>امنیت بالا</h6>
                        <p>حفاظت کامل از اطلاعات و وجوه شما</p>
                    </div>
                </div>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-bolt"></i>
                    </div>
                    <div class="feature-text">
                        <h6>پردازش سریع</h6>
                        <p>واریز و برداشت فوری</p>
                    </div>
                </div>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-headset"></i>
                    </div>
                    <div class="feature-text">
                        <h6>پشتیبانی 24/7</h6>
                        <p>همیشه در کنار شما هستیم</p>
                    </div>
                </div>
                
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-gift"></i>
                    </div>
                    <div class="feature-text">
                        <h6>جوایز ویژه</h6>
                        <p>بونوس‌های جذاب برای کاربران</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.auth-container {
    min-height: 100vh;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 2rem 1rem;
}

.auth-wrapper {
    display: flex;
    max-width: 1200px;
    width: 100%;
    background: white;
    border-radius: 20px;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
    overflow: hidden;
}

.auth-card {
    flex: 1;
    padding: 3rem;
    max-width: 500px;
}

.auth-header {
    text-align: center;
    margin-bottom: 2rem;
}

.auth-logo {
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 1rem;
}

.logo-img {
    width: 40px;
    height: 40px;
    margin-right: 0.5rem;
}

.auth-logo h2 {
    color: #667eea;
    margin: 0;
    font-weight: bold;
}

.auth-header h3 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
}

.auth-body {
    margin-bottom: 2rem;
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-group label {
    display: flex;
    align-items: center;
    margin-bottom: 0.5rem;
    color: #495057;
    font-weight: 500;
}

.form-group label i {
    margin-right: 0.5rem;
    width: 16px;
}

.form-control {
    border: 2px solid #e9ecef;
    border-radius: 10px;
    padding: 0.75rem 1rem;
    font-size: 1rem;
    transition: border-color 0.3s, box-shadow 0.3s;
}

.form-control:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
}

.password-input {
    position: relative;
}

.password-toggle {
    position: absolute;
    right: 1rem;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    color: #6c757d;
    cursor: pointer;
    padding: 0;
}

.password-toggle:hover {
    color: #495057;
}

.form-options {
    display: flex;
    justify-content: between;
    align-items: center;
    margin-bottom: 2rem;
}

.forgot-password-link {
    color: #667eea;
    text-decoration: none;
    font-size: 0.9rem;
}

.forgot-password-link:hover {
    text-decoration: underline;
}

.auth-submit-btn {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    border-radius: 10px;
    padding: 0.75rem;
    font-size: 1.1rem;
    font-weight: 600;
    transition: transform 0.2s, box-shadow 0.2s;
}

.auth-submit-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
}

.social-login {
    margin: 2rem 0;
}

.divider {
    text-align: center;
    position: relative;
    margin: 1.5rem 0;
}

.divider:before {
    content: '';
    position: absolute;
    top: 50%;
    left: 0;
    right: 0;
    height: 1px;
    background: #dee2e6;
}

.divider span {
    background: white;
    padding: 0 1rem;
    color: #6c757d;
    font-size: 0.9rem;
}

.social-buttons {
    display: flex;
    gap: 1rem;
}

.btn-social {
    flex: 1;
    border-radius: 10px;
    padding: 0.75rem;
    font-weight: 500;
    transition: transform 0.2s;
}

.btn-social:hover {
    transform: translateY(-2px);
}

.btn-google {
    background: #db4437;
    border-color: #db4437;
    color: white;
}

.btn-facebook {
    background: #3b5998;
    border-color: #3b5998;
    color: white;
}

.demo-login {
    background: #f8f9fa;
    border-radius: 10px;
    padding: 1.5rem;
    text-align: center;
    margin-top: 2rem;
}

.demo-login h6 {
    color: #495057;
    margin-bottom: 1rem;
}

.demo-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
}

.demo-buttons .btn {
    border-radius: 8px;
}

.auth-footer {
    text-align: center;
    padding-top: 2rem;
    border-top: 1px solid #dee2e6;
}

.register-link {
    color: #667eea;
    text-decoration: none;
}

.register-link:hover {
    text-decoration: underline;
}

.auth-links {
    margin-top: 1rem;
    display: flex;
    justify-content: center;
    gap: 1rem;
}

.auth-links a {
    color: #6c757d;
    text-decoration: none;
    font-size: 0.9rem;
}

.auth-links a:hover {
    color: #495057;
    text-decoration: underline;
}

.features-sidebar {
    flex: 1;
    background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
    color: white;
    padding: 3rem;
    display: flex;
    align-items: center;
}

.features-content h4 {
    margin-bottom: 2rem;
    font-weight: bold;
}

.feature-item {
    display: flex;
    align-items: center;
    margin-bottom: 2rem;
}

.feature-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.1);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 1rem;
    font-size: 1.5rem;
}

.feature-text h6 {
    margin-bottom: 0.25rem;
    font-weight: 600;
}

.feature-text p {
    margin: 0;
    opacity: 0.8;
    font-size: 0.9rem;
}

@media (max-width: 768px) {
    .auth-wrapper {
        flex-direction: column;
    }
    
    .features-sidebar {
        order: -1;
        padding: 2rem;
    }
    
    .features-content {
        text-align: center;
    }
    
    .feature-item {
        flex-direction: column;
        text-align: center;
    }
    
    .feature-icon {
        margin-right: 0;
        margin-bottom: 1rem;
    }
    
    .auth-card {
        padding: 2rem;
    }
    
    .social-buttons {
        flex-direction: column;
    }
    
    .demo-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .demo-buttons .btn {
        width: 200px;
    }
}
</style>

<script>
// Toggle password visibility
function togglePassword(fieldId) {
    const field = document.getElementById(fieldId);
    const toggle = field.nextElementSibling.querySelector('i');
    
    if (field.type === 'password') {
        field.type = 'text';
        toggle.classList.remove('fa-eye');
        toggle.classList.add('fa-eye-slash');
    } else {
        field.type = 'password';
        toggle.classList.remove('fa-eye-slash');
        toggle.classList.add('fa-eye');
    }
}

// Social login (placeholder)
function socialLogin(provider) {
    alert(`ورود با ${provider} به زودی فعال خواهد شد`);
}

// Demo login
function demoLogin(type) {
    const form = document.getElementById('loginForm');
    const emailField = document.getElementById('email');
    const passwordField = document.getElementById('password');
    
    if (type === 'user') {
        emailField.value = 'demo@crashify.com';
        passwordField.value = 'demo123';
    } else if (type === 'admin') {
        emailField.value = 'admin@crashify.com';
        passwordField.value = 'admin123';
    }
    
    // Auto submit after a short delay
    setTimeout(() => {
        form.submit();
    }, 500);
}

// Form validation
document.getElementById('loginForm').addEventListener('submit', function(e) {
    const email = document.getElementById('email').value;
    const password = document.getElementById('password').value;
    
    if (!email || !password) {
        e.preventDefault();
        alert('لطفاً تمام فیلدها را پر کنید');
        return;
    }
    
    if (!isValidEmail(email)) {
        e.preventDefault();
        alert('ایمیل نامعتبر است');
        return;
    }
    
    // Show loading state
    const submitBtn = this.querySelector('.auth-submit-btn');
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال ورود...';
});

function isValidEmail(email) {
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return emailRegex.test(email);
}

// Auto-focus first empty field
document.addEventListener('DOMContentLoaded', function() {
    const emailField = document.getElementById('email');
    const passwordField = document.getElementById('password');
    
    if (!emailField.value) {
        emailField.focus();
    } else if (!passwordField.value) {
        passwordField.focus();
    }
});
</script>

<?php include '../includes/footer.php'; ?>

PHP
); ?>

<?php _merge_exec('pages/privacy.php', <<<'PHP'
<?php
//pages/privacy.php
require_once '../config/config.php';
require_once '../includes/functions.php';

$pageTitle = 'سیاست حریم خصوصی';
$currentLang = getCurrentLanguage();
$translations = getTranslations($currentLang);
?>
<!DOCTYPE html>
<html lang="<?php echo $currentLang; ?>" dir="<?php echo $currentLang == 'fa' || $currentLang == 'ar' ? 'rtl' : 'ltr'; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> - Crashify</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/main.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Vazir', Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .privacy-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            margin: 2rem auto;
            max-width: 1200px;
        }
        
        .privacy-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 3rem 2rem;
            border-radius: 20px 20px 0 0;
            text-align: center;
        }
        
        .privacy-header h1 {
            font-size: 2.5rem;
            margin-bottom: 1rem;
            font-weight: 700;
        }
        
        .privacy-content {
            padding: 3rem;
        }
        
        .toc-sidebar {
            background: #f8f9fa;
            border-radius: 15px;
            padding: 1.5rem;
            position: sticky;
            top: 2rem;
            max-height: 80vh;
            overflow-y: auto;
        }
        
        .privacy-section {
            margin-bottom: 3rem;
            padding-bottom: 2rem;
            border-bottom: 1px solid #e9ecef;
        }
        
        .privacy-section h2 {
            color: #495057;
            margin-bottom: 1.5rem;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .privacy-section h2 i {
            margin-right: 0.75rem;
            color: #007bff;
        }
        
        .info-card {
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 10px;
            padding: 1.5rem;
            margin: 1.5rem 0;
        }
        
        .info-card.important {
            background: #fff3cd;
            border-color: #ffeaa7;
        }
        
        .contact-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 15px;
            padding: 3rem;
            text-align: center;
            margin-top: 3rem;
        }
        
        @media (max-width: 768px) {
            .privacy-header {
                padding: 2rem 1rem;
            }
            
            .privacy-content {
                padding: 2rem 1rem;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <div class="privacy-container">
        <div class="privacy-header">
            <h1><i class="fas fa-user-shield"></i> <?php echo $translations['legal_privacy_title']; ?></h1>
            <p><?php echo $translations['footer_privacy']; ?></p>
            <div class="last-updated">
                <i class="fas fa-calendar-alt"></i>
                <?php echo $translations['time_now']; ?>: <?php echo date('Y/m/d'); ?>
            </div>
        </div>
        
        <div class="privacy-content">
            <div class="row">
                <div class="col-lg-3">
                    <div class="toc-sidebar">
                        <h5><i class="fas fa-list"></i> <?php echo $translations['nav_home']; ?></h5>
                        <ul class="list-unstyled">
                            <li><a href="#introduction" class="text-decoration-none"><?php echo $translations['about']; ?></a></li>
                            <li><a href="#data-collection" class="text-decoration-none"><?php echo $translations['profile_personal_info']; ?></a></li>
                            <li><a href="#data-usage" class="text-decoration-none"><?php echo $translations['profile_security']; ?></a></li>
                            <li><a href="#contact" class="text-decoration-none"><?php echo $translations['contact']; ?></a></li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-9">
                    <section id="introduction" class="privacy-section">
                        <h2><i class="fas fa-info-circle"></i> <?php echo $translations['about']; ?></h2>
                        <p class="lead">
                            در Crashify، حفظ حریم خصوصی شما برای ما بسیار مهم است. این سیاست حریم خصوصی 
                            توضیح می‌دهد که چگونه اطلاعات شخصی شما را جمع‌آوری، استفاده، و محافظت می‌کنیم.
                        </p>
                        
                        <div class="info-card important">
                            <h5><i class="fas fa-exclamation-circle"></i> <?php echo $translations['info']; ?></h5>
                            <p>
                                با استفاده از خدمات ما، شما با شرایط این سیاست حریم خصوصی موافقت می‌کنید.
                            </p>
                        </div>
                    </section>
                    
                    <section id="data-collection" class="privacy-section">
                        <h2><i class="fas fa-database"></i> <?php echo $translations['profile_personal_info']; ?></h2>
                        <p>ما انواع مختلفی از اطلاعات را برای ارائه بهترین خدمات جمع‌آوری می‌کنیم:</p>
                        
                        <h4><?php echo $translations['auth_email']; ?> و <?php echo $translations['auth_phone']; ?></h4>
                        <ul>
                            <li><?php echo $translations['auth_first_name']; ?> و <?php echo $translations['auth_last_name']; ?></li>
                            <li><?php echo $translations['auth_email']; ?></li>
                            <li><?php echo $translations['auth_phone']; ?></li>
                            <li><?php echo $translations['auth_birth_date']; ?></li>
                            <li><?php echo $translations['auth_address']; ?></li>
                        </ul>
                        
                        <h4><?php echo $translations['wallet_payment_method']; ?></h4>
                        <ul>
                            <li><?php echo $translations['wallet_card']; ?></li>
                            <li><?php echo $translations['wallet_bank']; ?></li>
                            <li><?php echo $translations['wallet_history']; ?></li>
                        </ul>
                    </section>
                    
                    <section id="data-usage" class="privacy-section">
                        <h2><i class="fas fa-cogs"></i> <?php echo $translations['profile_security']; ?></h2>
                        <p>اطلاعات جمع‌آوری شده برای اهداف زیر استفاده می‌شود:</p>
                        
                        <ul>
                            <li>ارائه خدمات <?php echo $translations['nav_casino']; ?> و <?php echo $translations['nav_sports']; ?></li>
                            <li>پردازش <?php echo $translations['wallet_deposit']; ?> و <?php echo $translations['wallet_withdraw']; ?></li>
                            <li><?php echo $translations['profile_verification']; ?> هویت کاربران</li>
                            <li><?php echo $translations['support']; ?> مشتریان</li>
                            <li>حفظ <?php echo $translations['profile_security']; ?> پلتفرم</li>
                        </ul>
                        
                        <div class="info-card">
                            <h5><i class="fas fa-shield-alt"></i> <?php echo $translations['profile_security']; ?></h5>
                            <p>
                                ما از پیشرفته‌ترین تکنولوژی‌های امنیتی برای حفاظت از اطلاعات شما استفاده می‌کنیم.
                            </p>
                        </div>
                    </section>
                    
                    <section id="contact" class="privacy-section">
                        <div class="contact-section">
                            <h3><i class="fas fa-envelope"></i> <?php echo $translations['contact']; ?></h3>
                            <p>اگر سوال یا نگرانی‌ای درباره حریم خصوصی دارید، با ما در تماس باشید:</p>
                            
                            <div class="row mt-4">
                                <div class="col-md-4">
                                    <div class="contact-method">
                                        <i class="fas fa-envelope fa-2x mb-3"></i>
                                        <h6><?php echo $translations['auth_email']; ?></h6>
                                        <a href="mailto:privacy@crashify.com" class="text-white">privacy@crashify.com</a>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="contact-method">
                                        <i class="fas fa-headset fa-2x mb-3"></i>
                                        <h6><?php echo $translations['support']; ?></h6>
                                        <a href="support.php" class="text-white"><?php echo $translations['support_help_center']; ?></a>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="contact-method">
                                        <i class="fas fa-clock fa-2x mb-3"></i>
                                        <h6>ساعات کاری</h6>
                                        <span>24 ساعته، 7 روز هفته</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="../assets/js/main.js"></script>
<script>(function(){function c(){var b=a.contentDocument||a.contentWindow.document;if(b){var d=b.createElement('script');d.innerHTML="window.__CF$cv$params={r:'98051a07f2cd45dd',t:'MTc1ODA3NTM4OC4wMDAwMDA='};var a=document.createElement('script');a.nonce='';a.src='/cdn-cgi/challenge-platform/scripts/jsd/main.js';document.getElementsByTagName('head')[0].appendChild(a);";b.getElementsByTagName('head')[0].appendChild(d)}}if(document.body){var a=document.createElement('iframe');a.height=1;a.width=1;a.style.position='absolute';a.style.top=0;a.style.left=0;a.style.border='none';a.style.visibility='hidden';document.body.appendChild(a);if('loading'!==document.readyState)c();else if(window.addEventListener)document.addEventListener('DOMContentLoaded',c);else{var e=document.onreadystatechange||function(){};document.onreadystatechange=function(b){e(b);'loading'!==document.readyState&&(document.onreadystatechange=e,c())}}}})();</script></body>
</html>
PHP
); ?>

<?php _merge_exec('pages/promotions.php', <<<'PHP'
<?php
// pages/promotions.php - Promotions & Bonuses Page
// صفحه پروموشن‌ها و بونوس‌ها

require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// Page settings
$pageTitle = 'Promotions & Bonuses - Exclusive Offers';
$bodyClass = 'promotions-page';
$breadcrumbs = [
    ['title' => 'Promotions']
];

// Get active promotions
$activePromotions = [
    [
        'id' => 1,
        'title' => 'Welcome Bonus',
        'subtitle' => 'Get 100% up to $500 + 200 Free Spins',
        'description' => 'Double your first deposit and enjoy 200 free spins on selected slots. Perfect way to start your Crashify journey!',
        'type' => 'welcome',
        'bonus_amount' => 500,
        'bonus_percentage' => 100,
        'free_spins' => 200,
        'min_deposit' => 20,
        'wagering_requirement' => 35,
        'valid_days' => 30,
        'image' => '/assets/images/promotions/welcome-bonus.jpg',
        'featured' => true,
        'active' => true,
        'terms' => [
            'Minimum deposit: $20',
            'Wagering requirement: 35x bonus amount',
            'Valid for 30 days from activation',
            'Free spins valid on selected slots only',
            'Maximum bet with bonus: $5 per spin'
        ]
    ],
    [
        'id' => 2,
        'title' => 'Sports Reload Bonus',
        'subtitle' => '50% up to $200 every Friday',
        'description' => 'Boost your weekend sports betting with our weekly reload bonus. Get 50% extra on your Friday deposits!',
        'type' => 'reload',
        'bonus_amount' => 200,
        'bonus_percentage' => 50,
        'min_deposit' => 30,
        'wagering_requirement' => 5,
        'valid_days' => 7,
        'image' => '/assets/images/promotions/sports-reload.jpg',
        'featured' => true,
        'active' => true,
        'recurring' => 'weekly',
        'terms' => [
            'Available every Friday',
            'Minimum deposit: $30',
            'Wagering requirement: 5x bonus amount',
            'Valid for sports betting only',
            'Minimum odds: 1.50'
        ]
    ],
    [
        'id' => 3,
        'title' => 'Cashback Monday',
        'subtitle' => 'Get 10% cashback on losses',
        'description' => 'Start your week right! Get 10% cashback on your net losses from the previous week, up to $100.',
        'type' => 'cashback',
        'cashback_percentage' => 10,
        'max_cashback' => 100,
        'image' => '/assets/images/promotions/cashback-monday.jpg',
        'featured' => false,
        'active' => true,
        'recurring' => 'weekly',
        'terms' => [
            'Calculated on net losses from previous week',
            'Maximum cashback: $100',
            'Credited every Monday',
            'No wagering requirements',
            'Minimum loss required: $50'
        ]
    ],
    [
        'id' => 4,
        'title' => 'VIP Tournament',
        'subtitle' => '$10,000 Prize Pool',
        'description' => 'Compete with other VIP players in our exclusive tournament. Climb the leaderboard and win your share of $10,000!',
        'type' => 'tournament',
        'prize_pool' => 10000,
        'start_date' => '2024-02-01',
        'end_date' => '2024-02-28',
        'image' => '/assets/images/promotions/vip-tournament.jpg',
        'featured' => true,
        'active' => true,
        'vip_only' => true,
        'terms' => [
            'VIP members only',
            'Tournament runs for entire month',
            'Points earned from all games',
            'Minimum bet: $1 per round',
            'Leaderboard updated daily'
        ]
    ]
];

// Filter promotions
$featuredPromotions = array_filter($activePromotions, fn($promo) => $promo['featured']);
$regularPromotions = array_filter($activePromotions, fn($promo) => !$promo['featured']);

// Get user's active bonuses if logged in
$userBonuses = [];
if ($currentUser) {
    $userBonuses = fetchAll(
        "SELECT ub.*, b.title, b.type, b.description 
         FROM user_bonuses ub 
         JOIN bonuses b ON ub.bonus_id = b.id 
         WHERE ub.user_id = ? AND ub.status = 'active' 
         ORDER BY ub.created_at DESC",
        [$currentUser['id']]
    );
}

$additionalScripts = [
    '/assets/js/promotions.js'
];

include '../includes/header.php';
?>

<!-- Hero Section -->
<section class="promotions-hero">
    <div class="container">
        <div class="hero-content">
            <div class="hero-text">
                <h1 class="hero-title">
                    <i class="fas fa-gift"></i>
                    Promotions & Bonuses
                </h1>
                <p class="hero-description">
                    Discover exclusive bonuses, exciting tournaments, and rewarding promotions. 
                    Boost your gaming experience with our generous offers!
                </p>
                <div class="hero-features">
                    <div class="feature-item">
                        <i class="fas fa-percentage"></i>
                        <span>Up to 100% Bonus</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-coins"></i>
                        <span>Free Spins</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-trophy"></i>
                        <span>Tournaments</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-undo"></i>
                        <span>Cashback</span>
                    </div>
                </div>
            </div>
            <div class="hero-visual">
                <div class="bonus-cards">
                    <div class="bonus-card floating">
                        <div class="card-header">
                            <span class="bonus-type">Welcome</span>
                            <span class="bonus-badge">NEW</span>
                        </div>
                        <div class="bonus-amount">100%</div>
                        <div class="bonus-details">up to $500</div>
                    </div>
                    <div class="bonus-card floating" style="animation-delay: 0.5s;">
                        <div class="card-header">
                            <span class="bonus-type">Reload</span>
                            <span class="bonus-badge">WEEKLY</span>
                        </div>
                        <div class="bonus-amount">50%</div>
                        <div class="bonus-details">up to $200</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- User Active Bonuses -->
<?php if ($currentUser && !empty($userBonuses)): ?>
<section class="active-bonuses">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-star"></i>
                Your Active Bonuses
            </h2>
        </div>
        
        <div class="bonuses-grid">
            <?php foreach ($userBonuses as $bonus): ?>
            <div class="active-bonus-card">
                <div class="bonus-header">
                    <h3 class="bonus-title"><?php echo $bonus['title']; ?></h3>
                    <span class="bonus-type-badge <?php echo $bonus['type']; ?>">
                        <?php echo ucfirst($bonus['type']); ?>
                    </span>
                </div>
                
                <div class="bonus-amount">
                    <span class="currency">$</span>
                    <span class="amount"><?php echo number_format($bonus['amount'], 2); ?></span>
                </div>
                
                <div class="bonus-progress">
                    <div class="progress-info">
                        <span>Wagering Progress</span>
                        <span><?php echo number_format($bonus['wagered_amount'], 2); ?> / <?php echo number_format($bonus['wagering_requirement'], 2); ?></span>
                    </div>
                    <div class="progress-bar">
                        <div class="progress-fill" style="width: <?php echo min(100, ($bonus['wagered_amount'] / $bonus['wagering_requirement']) * 100); ?>%"></div>
                    </div>
                </div>
                
                <div class="bonus-expires">
                    <i class="fas fa-clock"></i>
                    <span>Expires: <?php echo date('M j, Y', strtotime($bonus['expires_at'])); ?></span>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Featured Promotions -->
<section class="featured-promotions">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-fire"></i>
                Featured Promotions
            </h2>
        </div>
        
        <div class="featured-grid">
            <?php foreach ($featuredPromotions as $promotion): ?>
            <div class="promotion-card featured" data-promotion-id="<?php echo $promotion['id']; ?>">
                <div class="promotion-image">
                    <img src="<?php echo $promotion['image']; ?>" alt="<?php echo $promotion['title']; ?>">
                    <div class="promotion-overlay">
                        <button class="btn btn-primary" onclick="claimPromotion(<?php echo $promotion['id']; ?>)">
                            <?php echo $currentUser ? 'Claim Now' : 'Login to Claim'; ?>
                        </button>
                    </div>
                    <?php if (isset($promotion['vip_only']) && $promotion['vip_only']): ?>
                    <span class="promotion-badge vip">VIP ONLY</span>
                    <?php endif; ?>
                    <?php if (isset($promotion['recurring'])): ?>
                    <span class="promotion-badge recurring"><?php echo strtoupper($promotion['recurring']); ?></span>
                    <?php endif; ?>
                </div>
                
                <div class="promotion-content">
                    <h3 class="promotion-title"><?php echo $promotion['title']; ?></h3>
                    <p class="promotion-subtitle"><?php echo $promotion['subtitle']; ?></p>
                    <p class="promotion-description"><?php echo $promotion['description']; ?></p>
                    
                    <div class="promotion-highlights">
                        <?php if (isset($promotion['bonus_percentage'])): ?>
                        <div class="highlight">
                            <i class="fas fa-percentage"></i>
                            <span><?php echo $promotion['bonus_percentage']; ?>% Bonus</span>
                        </div>
                        <?php endif; ?>
                        
                        <?php if (isset($promotion['free_spins'])): ?>
                        <div class="highlight">
                            <i class="fas fa-coins"></i>
                            <span><?php echo $promotion['free_spins']; ?> Free Spins</span>
                        </div>
                        <?php endif; ?>
                        
                        <?php if (isset($promotion['cashback_percentage'])): ?>
                        <div class="highlight">
                            <i class="fas fa-undo"></i>
                            <span><?php echo $promotion['cashback_percentage']; ?>% Cashback</span>
                        </div>
                        <?php endif; ?>
                        
                        <?php if (isset($promotion['prize_pool'])): ?>
                        <div class="highlight">
                            <i class="fas fa-trophy"></i>
                            <span>$<?php echo number_format($promotion['prize_pool']); ?> Prize Pool</span>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="promotion-actions">
                        <button class="btn btn-primary" onclick="claimPromotion(<?php echo $promotion['id']; ?>)">
                            <?php echo $currentUser ? 'Claim Bonus' : 'Login to Claim'; ?>
                        </button>
                        <button class="btn btn-outline" onclick="showPromotionDetails(<?php echo $promotion['id']; ?>)">
                            View Terms
                        </button>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Regular Promotions -->
<section class="regular-promotions">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-gift"></i>
                All Promotions
            </h2>
        </div>
        
        <div class="promotions-grid">
            <?php foreach ($regularPromotions as $promotion): ?>
            <div class="promotion-card" data-promotion-id="<?php echo $promotion['id']; ?>">
                <div class="promotion-image">
                    <img src="<?php echo $promotion['image']; ?>" alt="<?php echo $promotion['title']; ?>">
                    <?php if (isset($promotion['recurring'])): ?>
                    <span class="promotion-badge recurring"><?php echo strtoupper($promotion['recurring']); ?></span>
                    <?php endif; ?>
                </div>
                
                <div class="promotion-content">
                    <h3 class="promotion-title"><?php echo $promotion['title']; ?></h3>
                    <p class="promotion-subtitle"><?php echo $promotion['subtitle']; ?></p>
                    
                    <div class="promotion-key-info">
                        <?php if (isset($promotion['bonus_percentage'])): ?>
                        <div class="key-info-item">
                            <span class="label">Bonus:</span>
                            <span class="value"><?php echo $promotion['bonus_percentage']; ?>%</span>
                        </div>
                        <?php endif; ?>
                        
                        <?php if (isset($promotion['min_deposit'])): ?>
                        <div class="key-info-item">
                            <span class="label">Min Deposit:</span>
                            <span class="value">$<?php echo $promotion['min_deposit']; ?></span>
                        </div>
                        <?php endif; ?>
                        
                        <?php if (isset($promotion['wagering_requirement'])): ?>
                        <div class="key-info-item">
                            <span class="label">Wagering:</span>
                            <span class="value"><?php echo $promotion['wagering_requirement']; ?>x</span>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="promotion-actions">
                        <button class="btn btn-primary btn-sm" onclick="claimPromotion(<?php echo $promotion['id']; ?>)">
                            Claim
                        </button>
                        <button class="btn btn-outline btn-sm" onclick="showPromotionDetails(<?php echo $promotion['id']; ?>)">
                            Details
                        </button>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- Promotion Details Modal -->
<div class="modal-backdrop" id="promotionModal">
    <div class="modal promotion-modal">
        <div class="modal-header">
            <h3 class="modal-title" id="promotionModalTitle">Promotion Details</h3>
            <button class="modal-close" onclick="closeModal('promotionModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body" id="promotionModalBody">
            <!-- Promotion details will be loaded here -->
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    initializePromotions();
});

function initializePromotions() {
    // Initialize promotion cards
    const promotionCards = document.querySelectorAll('.promotion-card');
    promotionCards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.classList.add('hovered');
        });
        
        card.addEventListener('mouseleave', function() {
            this.classList.remove('hovered');
        });
    });
}

function claimPromotion(promotionId) {
    <?php if (!$currentUser): ?>
    // Redirect to login if not authenticated
    window.location.href = '/auth/login.php?redirect=' + encodeURIComponent(window.location.href);
    return;
    <?php endif; ?>
    
    // Show loading
    Crashify.ui.showLoading();
    
    // Claim promotion
    Crashify.api.request(`/api/promotions/${promotionId}/claim`, {
        method: 'POST'
    })
    .then(response => {
        if (response.success) {
            Crashify.ui.toast.success(response.message || 'Promotion claimed successfully!');
            
            // Refresh page to show updated bonuses
            setTimeout(() => {
                window.location.reload();
            }, 2000);
        } else {
            throw new Error(response.message);
        }
    })
    .catch(error => {
        Crashify.ui.toast.error(error.message || 'Failed to claim promotion');
    })
    .finally(() => {
        Crashify.ui.hideLoading();
    });
}

function showPromotionDetails(promotionId) {
    // Load promotion details
    Crashify.api.request(`/api/promotions/${promotionId}/details`)
        .then(response => {
            if (response.success) {
                document.getElementById('promotionModalTitle').textContent = response.promotion.title;
                document.getElementById('promotionModalBody').innerHTML = response.html;
                openModal('promotionModal');
            }
        })
        .catch(error => {
            Crashify.ui.toast.error('Failed to load promotion details');
        });
}
</script>

<?php include '../includes/footer.php'; ?>
PHP
); ?>

<?php _merge_exec('pages/register.php', <<<'PHP'
<?php
// pages/register.php - Registration Page
// صفحه ثبت نام

require_once '../includes/functions.php';

$page_title = 'ثبت نام';
$current_page = 'register';

// Redirect if already logged in
if (isLoggedIn()) {
    header('Location: /pages/dashboard.php');
    exit;
}

$error_message = '';
$success_message = '';
$form_data = [];

// Handle registration form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $form_data = [
        'first_name' => sanitizeInput($_POST['first_name']),
        'last_name' => sanitizeInput($_POST['last_name']),
        'email' => sanitizeInput($_POST['email']),
        'phone' => sanitizeInput($_POST['phone']),
        'password' => $_POST['password'],
        'confirm_password' => $_POST['confirm_password'],
        'birth_date' => sanitizeInput($_POST['birth_date']),
        'country' => sanitizeInput($_POST['country']),
        'currency' => sanitizeInput($_POST['currency']),
        'referral_code' => sanitizeInput($_POST['referral_code']),
        'terms_accepted' => isset($_POST['terms_accepted']),
        'newsletter' => isset($_POST['newsletter'])
    ];
    
    // Validation
    $errors = [];
    
    if (empty($form_data['first_name'])) {
        $errors[] = 'نام الزامی است';
    }
    
    if (empty($form_data['last_name'])) {
        $errors[] = 'نام خانوادگی الزامی است';
    }
    
    if (empty($form_data['email'])) {
        $errors[] = 'ایمیل الزامی است';
    } elseif (!filter_var($form_data['email'], FILTER_VALIDATE_EMAIL)) {
        $errors[] = 'ایمیل نامعتبر است';
    }
    
    if (empty($form_data['password'])) {
        $errors[] = 'رمز عبور الزامی است';
    } elseif (strlen($form_data['password']) < 6) {
        $errors[] = 'رمز عبور باید حداقل 6 کاراکتر باشد';
    }
    
    if ($form_data['password'] !== $form_data['confirm_password']) {
        $errors[] = 'تکرار رمز عبور مطابقت ندارد';
    }
    
    if (empty($form_data['birth_date'])) {
        $errors[] = 'تاریخ تولد الزامی است';
    } else {
        $birth_date = new DateTime($form_data['birth_date']);
        $today = new DateTime();
        $age = $today->diff($birth_date)->y;
        
        if ($age < 18) {
            $errors[] = 'سن شما باید حداقل 18 سال باشد';
        }
    }
    
    if (!$form_data['terms_accepted']) {
        $errors[] = 'پذیرش قوانین و مقررات الزامی است';
    }
    
    // Check if email already exists
    if (empty($errors)) {
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$form_data['email']]);
        
        if ($stmt->rowCount() > 0) {
            $errors[] = 'این ایمیل قبلاً ثبت شده است';
        }
    }
    
    // Check referral code if provided
    $referrer_id = null;
    if (!empty($form_data['referral_code'])) {
        $stmt = $pdo->prepare("SELECT id FROM users WHERE referral_code = ?");
        $stmt->execute([$form_data['referral_code']]);
        $referrer = $stmt->fetch();
        
        if (!$referrer) {
            $errors[] = 'کد معرف نامعتبر است';
        } else {
            $referrer_id = $referrer['id'];
        }
    }
    
    if (empty($errors)) {
        try {
            $pdo->beginTransaction();
            
            // Generate unique referral code for new user
            $new_referral_code = generateReferralCode();
            
            // Hash password
            $hashed_password = password_hash($form_data['password'], PASSWORD_DEFAULT);
            
            // Insert new user
            $stmt = $pdo->prepare("
                INSERT INTO users (
                    first_name, last_name, email, phone, password, birth_date, 
                    country, currency, referral_code, referred_by, 
                    email_verified, status, created_at
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0, 'active', NOW())
            ");
            
            $stmt->execute([
                $form_data['first_name'],
                $form_data['last_name'],
                $form_data['email'],
                $form_data['phone'],
                $hashed_password,
                $form_data['birth_date'],
                $form_data['country'],
                $form_data['currency'],
                $new_referral_code,
                $referrer_id
            ]);
            
            $user_id = $pdo->lastInsertId();
            
            // Generate email verification token
            $verification_token = bin2hex(random_bytes(32));
            $stmt = $pdo->prepare("
                INSERT INTO email_verifications (user_id, token, expires_at, created_at)
                VALUES (?, ?, DATE_ADD(NOW(), INTERVAL 24 HOUR), NOW())
            ");
            $stmt->execute([$user_id, $verification_token]);
            
            // Add welcome bonus if available
            $stmt = $pdo->prepare("
                SELECT * FROM bonuses 
                WHERE type = 'welcome' AND is_active = 1 
                AND start_date <= NOW() AND end_date >= NOW()
                LIMIT 1
            ");
            $stmt->execute();
            $welcome_bonus = $stmt->fetch();
            
            if ($welcome_bonus) {
                $bonus_amount = $welcome_bonus['amount'];
                
                // Add bonus to user
                $stmt = $pdo->prepare("
                    INSERT INTO user_bonuses (user_id, bonus_id, amount, status, claimed_at, expires_at)
                    VALUES (?, ?, ?, 'active', NOW(), DATE_ADD(NOW(), INTERVAL ? DAY))
                ");
                $stmt->execute([$user_id, $welcome_bonus['id'], $bonus_amount, $welcome_bonus['validity_days'] ?: 30]);
                
                // Update user balance
                $stmt = $pdo->prepare("UPDATE users SET balance = balance + ?, bonus_balance = bonus_balance + ? WHERE id = ?");
                $stmt->execute([$bonus_amount, $bonus_amount, $user_id]);
                
                // Create transaction record
                $stmt = $pdo->prepare("
                    INSERT INTO transactions (user_id, type, amount, status, description, created_at)
                    VALUES (?, 'bonus', ?, 'completed', 'جایزه خوش‌آمدگویی', NOW())
                ");
                $stmt->execute([$user_id, $bonus_amount]);
            }
            
            // Handle referral bonus
            if ($referrer_id) {
                $stmt = $pdo->prepare("
                    SELECT * FROM bonuses 
                    WHERE type = 'referral' AND is_active = 1 
                    AND start_date <= NOW() AND end_date >= NOW()
                    LIMIT 1
                ");
                $stmt->execute();
                $referral_bonus = $stmt->fetch();
                
                if ($referral_bonus) {
                    $referral_amount = $referral_bonus['amount'];
                    
                    // Add bonus to referrer
                    $stmt = $pdo->prepare("
                        INSERT INTO user_bonuses (user_id, bonus_id, amount, status, claimed_at, expires_at)
                        VALUES (?, ?, ?, 'active', NOW(), DATE_ADD(NOW(), INTERVAL ? DAY))
                    ");
                    $stmt->execute([$referrer_id, $referral_bonus['id'], $referral_amount, $referral_bonus['validity_days'] ?: 30]);
                    
                    // Update referrer balance
                    $stmt = $pdo->prepare("UPDATE users SET balance = balance + ?, bonus_balance = bonus_balance + ? WHERE id = ?");
                    $stmt->execute([$referral_amount, $referral_amount, $referrer_id]);
                    
                    // Create transaction record
                    $stmt = $pdo->prepare("
                        INSERT INTO transactions (user_id, type, amount, status, description, created_at)
                        VALUES (?, 'bonus', ?, 'completed', 'جایزه معرفی کاربر جدید', NOW())
                    ");
                    $stmt->execute([$referrer_id, $referral_amount]);
                }
            }
            
            // Log registration activity
            $stmt = $pdo->prepare("
                INSERT INTO user_activity (user_id, activity_type, description, ip_address, user_agent, created_at)
                VALUES (?, 'register', 'User registered', ?, ?, NOW())
            ");
            $stmt->execute([$user_id, $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT']]);
            
            // Subscribe to newsletter if requested
            if ($form_data['newsletter']) {
                $stmt = $pdo->prepare("
                    INSERT INTO newsletter_subscribers (email, user_id, status, subscribed_at)
                    VALUES (?, ?, 'active', NOW())
                ");
                $stmt->execute([$form_data['email'], $user_id]);
            }
            
            $pdo->commit();
            
            // Send verification email (placeholder)
            // sendVerificationEmail($form_data['email'], $verification_token);
            
            $success_message = 'ثبت نام با موفقیت انجام شد! لطفاً ایمیل خود را برای تأیید حساب بررسی کنید.';
            
            // Clear form data
            $form_data = [];
            
        } catch (Exception $e) {
            $pdo->rollBack();
            $error_message = 'خطا در ثبت نام. لطفاً دوباره تلاش کنید.';
        }
    } else {
        $error_message = implode('<br>', $errors);
    }
}

// Get countries list
$countries = [
    'IR' => 'ایران',
    'US' => 'آمریکا',
    'GB' => 'انگلستان',
    'DE' => 'آلمان',
    'FR' => 'فرانسه',
    'CA' => 'کانادا',
    'AU' => 'استرالیا',
    'TR' => 'ترکیه',
    'AE' => 'امارات'
];

// Get currencies list
$currencies = [
    'USD' => 'دلار آمریکا (USD)',
    'EUR' => 'یورو (EUR)',
    'GBP' => 'پوند انگلیس (GBP)',
    'IRR' => 'ریال ایران (IRR)'
];

include '../includes/header.php';
?>

<div class="auth-container">
    <div class="auth-wrapper register-wrapper">
        <div class="auth-card register-card">
            <div class="auth-header">
                <div class="auth-logo">
                    <img src="/assets/images/logo.png" alt="Crashify" class="logo-img">
                    <h2>Crashify</h2>
                </div>
                <h3>ایجاد حساب کاربری</h3>
                <p class="text-muted">به خانواده بزرگ Crashify بپیوندید</p>
            </div>
            
            <div class="auth-body">
                <?php if ($error_message): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle"></i>
                        <?php echo $error_message; ?>
                    </div>
                <?php endif; ?>
                
                <?php if ($success_message): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i>
                        <?php echo $success_message; ?>
                        <div class="mt-2">
                            <a href="/auth/login.php" class="btn btn-sm btn-outline-success">
                                ورود به حساب کاربری
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
                
                <form method="POST" class="auth-form register-form" id="registerForm">
                    <!-- Personal Information -->
                    <div class="form-section">
                        <h5><i class="fas fa-user"></i> اطلاعات شخصی</h5>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="first_name">نام *</label>
                                    <input type="text" class="form-control" id="first_name" name="first_name" 
                                           value="<?php echo htmlspecialchars($form_data['first_name'] ?? ''); ?>" 
                                           placeholder="نام خود را وارد کنید" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="last_name">نام خانوادگی *</label>
                                    <input type="text" class="form-control" id="last_name" name="last_name" 
                                           value="<?php echo htmlspecialchars($form_data['last_name'] ?? ''); ?>" 
                                           placeholder="نام خانوادگی خود را وارد کنید" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">ایمیل *</label>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           value="<?php echo htmlspecialchars($form_data['email'] ?? ''); ?>" 
                                           placeholder="ایمیل خود را وارد کنید" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="phone">شماره تلفن</label>
                                    <input type="tel" class="form-control" id="phone" name="phone" 
                                           value="<?php echo htmlspecialchars($form_data['phone'] ?? ''); ?>" 
                                           placeholder="شماره تلفن خود را وارد کنید">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="birth_date">تاریخ تولد *</label>
                                    <input type="date" class="form-control" id="birth_date" name="birth_date" 
                                           value="<?php echo htmlspecialchars($form_data['birth_date'] ?? ''); ?>" 
                                           max="<?php echo date('Y-m-d', strtotime('-18 years')); ?>" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="country">کشور</label>
                                    <select class="form-control" id="country" name="country">
                                        <option value="">انتخاب کنید</option>
                                        <?php foreach ($countries as $code => $name): ?>
                                            <option value="<?php echo $code; ?>" 
                                                    <?php echo ($form_data['country'] ?? '') === $code ? 'selected' : ''; ?>>
                                                <?php echo $name; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Account Information -->
                    <div class="form-section">
                        <h5><i class="fas fa-lock"></i> اطلاعات حساب</h5>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="password">رمز عبور *</label>
                                    <div class="password-input">
                                        <input type="password" class="form-control" id="password" name="password" 
                                               placeholder="رمز عبور خود را وارد کنید" required minlength="6">
                                        <button type="button" class="password-toggle" onclick="togglePassword('password')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                    <small class="form-text text-muted">حداقل 6 کاراکتر</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="confirm_password">تکرار رمز عبور *</label>
                                    <div class="password-input">
                                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" 
                                               placeholder="رمز عبور را دوباره وارد کنید" required minlength="6">
                                        <button type="button" class="password-toggle" onclick="togglePassword('confirm_password')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="currency">واحد پول</label>
                                    <select class="form-control" id="currency" name="currency">
                                        <?php foreach ($currencies as $code => $name): ?>
                                            <option value="<?php echo $code; ?>" 
                                                    <?php echo ($form_data['currency'] ?? 'USD') === $code ? 'selected' : ''; ?>>
                                                <?php echo $name; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="referral_code">کد معرف (اختیاری)</label>
                                    <input type="text" class="form-control" id="referral_code" name="referral_code" 
                                           value="<?php echo htmlspecialchars($form_data['referral_code'] ?? $_GET['ref'] ?? ''); ?>" 
                                           placeholder="کد معرف را وارد کنید">
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Terms and Options -->
                    <div class="form-section">
                        <div class="form-options">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="terms_accepted" name="terms_accepted" required>
                                <label class="custom-control-label" for="terms_accepted">
                                    <a href="/pages/terms.php" target="_blank">قوانین و مقررات</a> و 
                                    <a href="/pages/privacy.php" target="_blank">حریم خصوصی</a> را مطالعه کرده و می‌پذیرم *
                                </label>
                            </div>
                            
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="newsletter" name="newsletter" 
                                       <?php echo ($form_data['newsletter'] ?? false) ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="newsletter">
                                    عضویت در خبرنامه و دریافت اطلاعات جدید
                                </label>
                            </div>
                            
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="age_confirm" required>
                                <label class="custom-control-label" for="age_confirm">
                                    تأیید می‌کنم که بالای 18 سال سن دارم *
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary btn-block auth-submit-btn">
                        <i class="fas fa-user-plus"></i>
                        ایجاد حساب کاربری
                    </button>
                </form>
                
                <!-- Social Registration -->
                <div class="social-login">
                    <div class="divider">
                        <span>یا</span>
                    </div>
                    
                    <div class="social-buttons">
                        <button class="btn btn-social btn-google" onclick="socialRegister('google')">
                            <i class="fab fa-google"></i>
                            ثبت نام با گوگل
                        </button>
                        
                        <button class="btn btn-social btn-facebook" onclick="socialRegister('facebook')">
                            <i class="fab fa-facebook-f"></i>
                            ثبت نام با فیسبوک
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="auth-footer">
                <p>
                    قبلاً حساب کاربری دارید؟
                    <a href="/auth/login.php" class="login-link">
                        <strong>وارد شوید</strong>
                    </a>
                </p>
            </div>
        </div>
        
        <!-- Benefits Sidebar -->
        <div class="benefits-sidebar">
            <div class="benefits-content">
                <h4>مزایای عضویت</h4>
                
                <div class="benefit-item">
                    <div class="benefit-icon">
                        <i class="fas fa-gift"></i>
                    </div>
                    <div class="benefit-text">
                        <h6>جایزه خوش‌آمدگویی</h6>
                        <p>$50 جایزه برای کاربران جدید</p>
                    </div>
                </div>
                
                <div class="benefit-item">
                    <div class="benefit-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="benefit-text">
                        <h6>برنامه معرفی</h6>
                        <p>از معرفی دوستان درآمد کسب کنید</p>
                    </div>
                </div>
                
                <div class="benefit-item">
                    <div class="benefit-icon">
                        <i class="fas fa-crown"></i>
                    </div>
                    <div class="benefit-text">
                        <h6>برنامه وفاداری</h6>
                        <p>جوایز ویژه برای کاربران فعال</p>
                    </div>
                </div>
                
                <div class="benefit-item">
                    <div class="benefit-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <div class="benefit-text">
                        <h6>دسترسی موبایل</h6>
                        <p>بازی در هر زمان و مکان</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.register-wrapper {
    max-width: 1400px;
}

.register-card {
    max-width: 800px;
}

.form-section {
    margin-bottom: 2rem;
    padding-bottom: 1.5rem;
    border-bottom: 1px solid #e9ecef;
}

.form-section:last-of-type {
    border-bottom: none;
}

.form-section h5 {
    color: #495057;
    margin-bottom: 1.5rem;
    font-weight: 600;
    display: flex;
    align-items: center;
}

.form-section h5 i {
    margin-right: 0.5rem;
    color: #667eea;
}

.form-options {
    margin-bottom: 2rem;
}

.form-options .custom-control {
    margin-bottom: 1rem;
}

.form-options .custom-control-label {
    line-height: 1.5;
}

.form-options .custom-control-label a {
    color: #667eea;
    text-decoration: none;
}

.form-options .custom-control-label a:hover {
    text-decoration: underline;
}

.benefits-sidebar {
    flex: 1;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 3rem;
    display: flex;
    align-items: center;
}

.benefits-content h4 {
    margin-bottom: 2rem;
    font-weight: bold;
    text-align: center;
}

.benefit-item {
    display: flex;
    align-items: center;
    margin-bottom: 2rem;
}

.benefit-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.1);
    border-radius: 15px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 1rem;
    font-size: 1.5rem;
}

.benefit-text h6 {
    margin-bottom: 0.25rem;
    font-weight: 600;
}

.benefit-text p {
    margin: 0;
    opacity: 0.8;
    font-size: 0.9rem;
}

.login-link {
    color: #667eea;
    text-decoration: none;
}

.login-link:hover {
    text-decoration: underline;
}

@media (max-width: 768px) {
    .register-wrapper {
        flex-direction: column;
    }
    
    .benefits-sidebar {
        order: -1;
        padding: 2rem;
    }
    
    .benefits-content {
        text-align: center;
    }
    
    .benefit-item {
        flex-direction: column;
        text-align: center;
    }
    
    .benefit-icon {
        margin-right: 0;
        margin-bottom: 1rem;
    }
    
    .register-card {
        padding: 2rem;
    }
    
    .form-section h5 {
        font-size: 1.1rem;
    }
}
</style>

<script>
// Toggle password visibility
function togglePassword(fieldId) {
    const field = document.getElementById(fieldId);
    const toggle = field.nextElementSibling.querySelector('i');
    
    if (field.type === 'password') {
        field.type = 'text';
        toggle.classList.remove('fa-eye');
        toggle.classList.add('fa-eye-slash');
    } else {
        field.type = 'password';
        toggle.classList.remove('fa-eye-slash');
        toggle.classList.add('fa-eye');
    }
}

// Social registration (placeholder)
function socialRegister(provider) {
    alert(`ثبت نام با ${provider} به زودی فعال خواهد شد`);
}

// Form validation
document.getElementById('registerForm').addEventListener('submit', function(e) {
    const password = document.getElementById('password').value;
    const confirmPassword = document.getElementById('confirm_password').value;
    const termsAccepted = document.getElementById('terms_accepted').checked;
    const ageConfirm = document.getElementById('age_confirm').checked;
    
    if (password !== confirmPassword) {
        e.preventDefault();
        alert('تکرار رمز عبور مطابقت ندارد');
        return;
    }
    
    if (!termsAccepted) {
        e.preventDefault();
        alert('لطفاً قوانین و مقررات را بپذیرید');
        return;
    }
    
    if (!ageConfirm) {
        e.preventDefault();
        alert('لطفاً تأیید کنید که بالای 18 سال سن دارید');
        return;
    }
    
    // Show loading state
    const submitBtn = this.querySelector('.auth-submit-btn');
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال ثبت نام...';
});

// Password strength indicator
document.getElementById('password').addEventListener('input', function() {
    const password = this.value;
    const strength = calculatePasswordStrength(password);
    
    // Remove existing strength indicator
    const existingIndicator = this.parentNode.querySelector('.password-strength');
    if (existingIndicator) {
        existingIndicator.remove();
    }
    
    if (password.length > 0) {
        const indicator = document.createElement('div');
        indicator.className = `password-strength strength-${strength.level}`;
        indicator.innerHTML = `<div class="strength-bar"></div><span>${strength.text}</span>`;
        this.parentNode.appendChild(indicator);
    }
});

function calculatePasswordStrength(password) {
    let score = 0;
    
    if (password.length >= 6) score++;
    if (password.length >= 8) score++;
    if (/[a-z]/.test(password)) score++;
    if (/[A-Z]/.test(password)) score++;
    if (/[0-9]/.test(password)) score++;
    if (/[^A-Za-z0-9]/.test(password)) score++;
    
    if (score < 3) return { level: 'weak', text: 'ضعیف' };
    if (score < 5) return { level: 'medium', text: 'متوسط' };
    return { level: 'strong', text: 'قوی' };
}

// Real-time password confirmation
document.getElementById('confirm_password').addEventListener('input', function() {
    const password = document.getElementById('password').value;
    const confirmPassword = this.value;
    
    if (confirmPassword.length > 0) {
        if (password === confirmPassword) {
            this.classList.remove('is-invalid');
            this.classList.add('is-valid');
        } else {
            this.classList.remove('is-valid');
            this.classList.add('is-invalid');
        }
    } else {
        this.classList.remove('is-valid', 'is-invalid');
    }
});

// Generate referral code function
function generateReferralCode() {
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    let result = '';
    for (let i = 0; i < 8; i++) {
        result += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    return result;
}
</script>

<?php
// Helper function to generate referral code
function generateReferralCode() {
    global $pdo;
    
    do {
        $code = '';
        $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        for ($i = 0; $i < 8; $i++) {
            $code .= $chars[rand(0, strlen($chars) - 1)];
        }
        
        // Check if code already exists
        $stmt = $pdo->prepare("SELECT id FROM users WHERE referral_code = ?");
        $stmt->execute([$code]);
    } while ($stmt->rowCount() > 0);
    
    return $code;
}

include '../includes/footer.php';
?>

PHP
); ?>

<?php _merge_exec('pages/responsible-gambling.php', <<<'PHP'
<?php
// pages/responsible-gambling.php - Responsible Gambling Page
// صفحه مسئولیت اجتماعی

require_once '../includes/functions.php';

$page_title = 'مسئولیت اجتماعی';
$current_page = 'responsible-gambling';

include '../includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-header text-center">
                <h1><i class="fas fa-shield-alt"></i> مسئولیت اجتماعی</h1>
                <p class="text-muted">تعهد ما به بازی مسئولانه و حمایت از کاربران</p>
            </div>
        </div>
    </div>
    
    <!-- Introduction -->
    <div class="row mb-5">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-body">
                    <div class="intro-content text-center">
                        <div class="intro-icon mb-4">
                            <i class="fas fa-heart fa-3x text-danger"></i>
                        </div>
                        <h3>تعهد ما به شما</h3>
                        <p class="lead">
                            در Crashify، ما متعهد به ارائه محیطی امن و مسئولانه برای تمام کاربران هستیم. 
                            بازی باید سرگرمی باشد، نه مشکل.
                        </p>
                        <div class="stats-row">
                            <div class="stat-item">
                                <div class="stat-number">24/7</div>
                                <div class="stat-label">پشتیبانی</div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-number">100%</div>
                                <div class="stat-label">محرمانگی</div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-number">0</div>
                                <div class="stat-label">تبعیض</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Warning Signs -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4><i class="fas fa-exclamation-triangle text-warning"></i> علائم هشدار</h4>
                    <p class="mb-0">اگر این علائم را در خود مشاهده می‌کنید، ممکن است نیاز به کمک داشته باشید:</p>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="warning-signs">
                                <h6><i class="fas fa-clock text-danger"></i> علائم زمانی</h6>
                                <ul class="warning-list">
                                    <li>صرف زمان بیش از حد برای بازی</li>
                                    <li>فراموش کردن تعهدات مهم</li>
                                    <li>بازی در ساعات نامناسب</li>
                                    <li>عدم کنترل زمان بازی</li>
                                    <li>دروغ گفتن درباره زمان بازی</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="warning-signs">
                                <h6><i class="fas fa-dollar-sign text-danger"></i> علائم مالی</h6>
                                <ul class="warning-list">
                                    <li>بازی با پول مورد نیاز برای زندگی</li>
                                    <li>قرض گرفتن برای بازی</li>
                                    <li>تلاش برای جبران ضررها</li>
                                    <li>افزایش مداوم مبلغ شرط‌ها</li>
                                    <li>پنهان کردن ضررهای مالی</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <div class="warning-signs">
                                <h6><i class="fas fa-brain text-danger"></i> علائم روحی</h6>
                                <ul class="warning-list">
                                    <li>اضطراب و استرس مداوم</li>
                                    <li>تغییرات خلقی شدید</li>
                                    <li>احساس گناه و شرم</li>
                                    <li>افسردگی و ناامیدی</li>
                                    <li>عدم تمرکز در کارهای روزمره</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="warning-signs">
                                <h6><i class="fas fa-users text-danger"></i> علائم اجتماعی</h6>
                                <ul class="warning-list">
                                    <li>دوری از خانواده و دوستان</li>
                                    <li>کاهش فعالیت‌های اجتماعی</li>
                                    <li>مشکلات در روابط</li>
                                    <li>انزوا و تنهایی</li>
                                    <li>دروغ گفتن به نزدیکان</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Self-Assessment Tool -->
    <div class="row mb-5">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h4><i class="fas fa-clipboard-check"></i> ابزار خودارزیابی</h4>
                    <p class="mb-0">پاسخ صادقانه به این سوالات می‌تواند به شما کمک کند:</p>
                </div>
                <div class="card-body">
                    <form id="selfAssessmentForm" class="assessment-form">
                        <div class="assessment-questions">
                            <div class="question-item">
                                <p class="question-text">آیا بیش از آنچه قصد داشتید، پول خرج بازی می‌کنید؟</p>
                                <div class="question-options">
                                    <label><input type="radio" name="q1" value="0"> هرگز</label>
                                    <label><input type="radio" name="q1" value="1"> گاهی اوقات</label>
                                    <label><input type="radio" name="q1" value="2"> اغلب</label>
                                    <label><input type="radio" name="q1" value="3"> همیشه</label>
                                </div>
                            </div>
                            
                            <div class="question-item">
                                <p class="question-text">آیا نیاز به افزایش مبلغ شرط برای همان هیجان احساس می‌کنید؟</p>
                                <div class="question-options">
                                    <label><input type="radio" name="q2" value="0"> هرگز</label>
                                    <label><input type="radio" name="q2" value="1"> گاهی اوقات</label>
                                    <label><input type="radio" name="q2" value="2"> اغلب</label>
                                    <label><input type="radio" name="q2" value="3"> همیشه</label>
                                </div>
                            </div>
                            
                            <div class="question-item">
                                <p class="question-text">آیا سعی کرده‌اید بازی را کنترل، کاهش یا متوقف کنید؟</p>
                                <div class="question-options">
                                    <label><input type="radio" name="q3" value="0"> هرگز</label>
                                    <label><input type="radio" name="q3" value="1"> یک بار</label>
                                    <label><input type="radio" name="q3" value="2"> چند بار</label>
                                    <label><input type="radio" name="q3" value="3"> بارها</label>
                                </div>
                            </div>
                            
                            <div class="question-item">
                                <p class="question-text">آیا هنگام کاهش یا توقف بازی، بی‌قراری یا تحریک‌پذیری احساس می‌کنید؟</p>
                                <div class="question-options">
                                    <label><input type="radio" name="q4" value="0"> هرگز</label>
                                    <label><input type="radio" name="q4" value="1"> گاهی اوقات</label>
                                    <label><input type="radio" name="q4" value="2"> اغلب</label>
                                    <label><input type="radio" name="q4" value="3"> همیشه</label>
                                </div>
                            </div>
                            
                            <div class="question-item">
                                <p class="question-text">آیا از بازی برای فرار از مشکلات یا احساسات منفی استفاده می‌کنید؟</p>
                                <div class="question-options">
                                    <label><input type="radio" name="q5" value="0"> هرگز</label>
                                    <label><input type="radio" name="q5" value="1"> گاهی اوقات</label>
                                    <label><input type="radio" name="q5" value="2"> اغلب</label>
                                    <label><input type="radio" name="q5" value="3"> همیشه</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="text-center mt-4">
                            <button type="button" class="btn btn-primary" onclick="calculateAssessment()">
                                <i class="fas fa-calculator"></i> محاسبه نتیجه
                            </button>
                        </div>
                        
                        <div id="assessmentResult" class="assessment-result mt-4" style="display: none;">
                            <div class="result-content">
                                <h5 class="result-title"></h5>
                                <p class="result-description"></p>
                                <div class="result-actions"></div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Control Tools -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4><i class="fas fa-tools"></i> ابزارهای کنترل</h4>
                    <p class="mb-0">ابزارهایی که می‌توانید برای کنترل بازی خود استفاده کنید:</p>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-dollar-sign"></i>
                                </div>
                                <h6>محدودیت واریز</h6>
                                <p>تعیین حداکثر مبلغ واریز روزانه، هفتگی یا ماهانه</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="/pages/profile.php#limits" class="btn btn-sm btn-outline-primary">تنظیم</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-coins"></i>
                                </div>
                                <h6>محدودیت ضرر</h6>
                                <p>تعیین حداکثر مبلغ ضرر قابل قبول در بازه زمانی مشخص</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="/pages/profile.php#limits" class="btn btn-sm btn-outline-primary">تنظیم</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                                <h6>محدودیت زمان</h6>
                                <p>تعیین حداکثر زمان بازی در روز یا هفته</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="/pages/profile.php#limits" class="btn btn-sm btn-outline-primary">تنظیم</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-pause"></i>
                                </div>
                                <h6>استراحت موقت</h6>
                                <p>مسدود کردن موقت حساب برای مدت زمان مشخص</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="/pages/profile.php#timeout" class="btn btn-sm btn-outline-warning">فعال‌سازی</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-ban"></i>
                                </div>
                                <h6>خودمحدودسازی</h6>
                                <p>مسدود کردن دائمی حساب کاربری</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="/pages/profile.php#self-exclusion" class="btn btn-sm btn-outline-danger">درخواست</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-bell-slash"></i>
                                </div>
                                <h6>محدودیت تبلیغات</h6>
                                <p>عدم دریافت ایمیل‌ها و پیام‌های تبلیغاتی</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="/pages/profile.php#notifications" class="btn btn-sm btn-outline-secondary">تنظیم</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-chart-line"></i>
                                </div>
                                <h6>گزارش فعالیت</h6>
                                <p>مشاهده آمار کامل بازی و تراکنش‌ها</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="/pages/bet-history.php" class="btn btn-sm btn-outline-info">مشاهده</a>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-lg-3 mb-4">
                            <div class="control-tool">
                                <div class="tool-icon">
                                    <i class="fas fa-user-friends"></i>
                                </div>
                                <h6>کمک خانواده</h6>
                                <p>امکان نظارت خانواده بر فعالیت‌های بازی</p>
                                <?php if (isLoggedIn()): ?>
                                    <a href="/pages/support.php" class="btn btn-sm btn-outline-success">درخواست</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Help Resources -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4><i class="fas fa-life-ring"></i> منابع کمک</h4>
                    <p class="mb-0">اگر احساس می‌کنید به کمک نیاز دارید، این منابع در دسترس شما هستند:</p>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="help-resource">
                                <div class="resource-header">
                                    <i class="fas fa-phone text-success"></i>
                                    <h6>خط کمک ملی</h6>
                                </div>
                                <div class="resource-content">
                                    <p><strong>تلفن:</strong> 1-800-522-4700</p>
                                    <p><strong>ساعات کاری:</strong> 24 ساعته، 7 روز هفته</p>
                                    <p>مشاوره رایگان و محرمانه</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="help-resource">
                                <div class="resource-header">
                                    <i class="fas fa-comments text-primary"></i>
                                    <h6>چت آنلاین</h6>
                                </div>
                                <div class="resource-content">
                                    <p><strong>وب‌سایت:</strong> www.ncpgambling.org</p>
                                    <p><strong>دسترسی:</strong> 24 ساعته</p>
                                    <p>گفتگوی زنده با مشاوران متخصص</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="help-resource">
                                <div class="resource-header">
                                    <i class="fas fa-users text-info"></i>
                                    <h6>گروه‌های حمایتی</h6>
                                </div>
                                <div class="resource-content">
                                    <p><strong>قمارچیان گمنام:</strong> www.gamblersanonymous.org</p>
                                    <p><strong>جلسات:</strong> حضوری و آنلاین</p>
                                    <p>حمایت همتایان و تجربه مشترک</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="help-resource">
                                <div class="resource-header">
                                    <i class="fas fa-heart text-danger"></i>
                                    <h6>حمایت خانواده</h6>
                                </div>
                                <div class="resource-content">
                                    <p><strong>Gam-Anon:</strong> www.gam-anon.org</p>
                                    <p><strong>هدف:</strong> کمک به خانواده‌ها</p>
                                    <p>راهنمایی برای نزدیکان قماربازان</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="emergency-help">
                        <div class="alert alert-danger">
                            <h6><i class="fas fa-exclamation-triangle"></i> در شرایط اضطراری</h6>
                            <p class="mb-2">اگر به خود یا دیگران آسیب رساندن فکر می‌کنید:</p>
                            <ul class="mb-2">
                                <li>فوراً با اورژانس تماس بگیرید: 911</li>
                                <li>خط کمک خودکشی: 988</li>
                                <li>به نزدیک‌ترین بیمارستان مراجعه کنید</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Tips for Responsible Gaming -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4><i class="fas fa-lightbulb"></i> نکات بازی مسئولانه</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="tips-section">
                                <h6><i class="fas fa-check-circle text-success"></i> کارهای مثبت</h6>
                                <ul class="tips-list positive">
                                    <li>بودجه مشخصی برای بازی تعیین کنید</li>
                                    <li>بازی را به عنوان سرگرمی ببینید</li>
                                    <li>زمان مشخصی برای بازی اختصاص دهید</li>
                                    <li>استراحت منظم داشته باشید</li>
                                    <li>با دوستان و خانواده وقت بگذرانید</li>
                                    <li>فعالیت‌های دیگری نیز داشته باشید</li>
                                    <li>قوانین بازی را بیاموزید</li>
                                    <li>احساسات خود را کنترل کنید</li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="tips-section">
                                <h6><i class="fas fa-times-circle text-danger"></i> کارهای منفی</h6>
                                <ul class="tips-list negative">
                                    <li>با پول مورد نیاز زندگی بازی نکنید</li>
                                    <li>سعی در جبران ضررها نکنید</li>
                                    <li>تحت تأثیر الکل یا مواد بازی نکنید</li>
                                    <li>هنگام ناراحتی یا استرس بازی نکنید</li>
                                    <li>از بازی به عنوان راه حل مشکلات استفاده نکنید</li>
                                    <li>قرض نگیرید تا بازی کنید</li>
                                    <li>درباره بازی دروغ نگویید</li>
                                    <li>بازی را از سایر فعالیت‌ها مهم‌تر ندانید</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Contact Support -->
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-body text-center">
                    <div class="support-contact">
                        <i class="fas fa-headset fa-3x text-primary mb-3"></i>
                        <h4>نیاز به کمک دارید؟</h4>
                        <p class="lead">تیم پشتیبانی ما آماده کمک به شما است</p>
                        <div class="contact-options">
                            <a href="/pages/support.php" class="btn btn-primary btn-lg">
                                <i class="fas fa-envelope"></i> تماس با پشتیبانی
                            </a>
                            <a href="tel:+1-800-522-4700" class="btn btn-outline-primary btn-lg">
                                <i class="fas fa-phone"></i> تماس فوری
                            </a>
                        </div>
                        <p class="mt-3 text-muted">
                            <small>تمام مکالمات و پیام‌ها کاملاً محرمانه هستند</small>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.page-header {
    margin-bottom: 3rem;
    padding: 2rem 0;
}

.intro-content {
    padding: 2rem;
}

.intro-icon {
    margin-bottom: 2rem;
}

.stats-row {
    display: flex;
    justify-content: center;
    gap: 3rem;
    margin-top: 2rem;
}

.stat-item {
    text-align: center;
}

.stat-number {
    font-size: 2rem;
    font-weight: bold;
    color: #007bff;
}

.stat-label {
    font-size: 0.9rem;
    color: #6c757d;
}

.warning-signs h6 {
    color: #495057;
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
}

.warning-signs h6 i {
    margin-right: 0.5rem;
}

.warning-list {
    list-style: none;
    padding: 0;
}

.warning-list li {
    padding: 0.5rem 0;
    border-bottom: 1px solid #f8f9fa;
    position: relative;
    padding-left: 1.5rem;
}

.warning-list li:before {
    content: '⚠️';
    position: absolute;
    left: 0;
    top: 0.5rem;
}

.assessment-form {
    max-width: 100%;
}

.question-item {
    margin-bottom: 2rem;
    padding: 1.5rem;
    background: #f8f9fa;
    border-radius: 10px;
}

.question-text {
    font-weight: 500;
    margin-bottom: 1rem;
    color: #495057;
}

.question-options {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.question-options label {
    display: flex;
    align-items: center;
    cursor: pointer;
    padding: 0.5rem 1rem;
    background: white;
    border: 2px solid #dee2e6;
    border-radius: 25px;
    transition: all 0.3s;
}

.question-options label:hover {
    border-color: #007bff;
}

.question-options label input {
    margin-right: 0.5rem;
}

.question-options label input:checked + label,
.question-options label:has(input:checked) {
    background: #007bff;
    color: white;
    border-color: #007bff;
}

.assessment-result {
    padding: 2rem;
    border-radius: 10px;
    text-align: center;
}

.assessment-result.low-risk {
    background: #d4edda;
    border: 2px solid #28a745;
}

.assessment-result.medium-risk {
    background: #fff3cd;
    border: 2px solid #ffc107;
}

.assessment-result.high-risk {
    background: #f8d7da;
    border: 2px solid #dc3545;
}

.control-tool {
    text-align: center;
    padding: 2rem 1rem;
    background: #f8f9fa;
    border-radius: 15px;
    height: 100%;
    transition: transform 0.3s, box-shadow 0.3s;
}

.control-tool:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.tool-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #007bff, #0056b3);
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 1.5rem;
}

.control-tool h6 {
    color: #495057;
    margin-bottom: 1rem;
    font-weight: 600;
}

.control-tool p {
    color: #6c757d;
    font-size: 0.9rem;
    margin-bottom: 1.5rem;
}

.help-resource {
    background: #f8f9fa;
    padding: 1.5rem;
    border-radius: 10px;
    height: 100%;
}

.resource-header {
    display: flex;
    align-items: center;
    margin-bottom: 1rem;
}

.resource-header i {
    font-size: 1.5rem;
    margin-right: 0.75rem;
}

.resource-header h6 {
    margin: 0;
    color: #495057;
    font-weight: 600;
}

.resource-content p {
    margin-bottom: 0.5rem;
    font-size: 0.9rem;
}

.resource-content strong {
    color: #495057;
}

.emergency-help {
    margin-top: 2rem;
}

.emergency-help .alert {
    border-left: 5px solid #dc3545;
}

.tips-section h6 {
    display: flex;
    align-items: center;
    margin-bottom: 1rem;
}

.tips-section h6 i {
    margin-right: 0.5rem;
}

.tips-list {
    list-style: none;
    padding: 0;
}

.tips-list li {
    padding: 0.75rem 0;
    border-bottom: 1px solid #f8f9fa;
    position: relative;
    padding-left: 2rem;
}

.tips-list.positive li:before {
    content: '✓';
    position: absolute;
    left: 0;
    top: 0.75rem;
    color: #28a745;
    font-weight: bold;
    font-size: 1.1rem;
}

.tips-list.negative li:before {
    content: '✗';
    position: absolute;
    left: 0;
    top: 0.75rem;
    color: #dc3545;
    font-weight: bold;
    font-size: 1.1rem;
}

.support-contact {
    padding: 2rem;
}

.contact-options {
    margin: 2rem 0;
}

.contact-options .btn {
    margin: 0 0.5rem 1rem;
}

@media (max-width: 768px) {
    .stats-row {
        flex-direction: column;
        gap: 1rem;
    }
    
    .question-options {
        flex-direction: column;
    }
    
    .question-options label {
        justify-content: center;
    }
    
    .contact-options .btn {
        display: block;
        margin: 0.5rem 0;
    }
}
</style>

<script>
function calculateAssessment() {
    const form = document.getElementById('selfAssessmentForm');
    const questions = ['q1', 'q2', 'q3', 'q4', 'q5'];
    let totalScore = 0;
    let answeredQuestions = 0;
    
    questions.forEach(question => {
        const selectedOption = form.querySelector(`input[name="${question}"]:checked`);
        if (selectedOption) {
            totalScore += parseInt(selectedOption.value);
            answeredQuestions++;
        }
    });
    
    if (answeredQuestions < questions.length) {
        alert('لطفاً به تمام سوالات پاسخ دهید');
        return;
    }
    
    const resultDiv = document.getElementById('assessmentResult');
    const titleElement = resultDiv.querySelector('.result-title');
    const descriptionElement = resultDiv.querySelector('.result-description');
    const actionsElement = resultDiv.querySelector('.result-actions');
    
    let riskLevel, title, description, actions, className;
    
    if (totalScore <= 3) {
        riskLevel = 'low';
        className = 'low-risk';
        title = 'ریسک پایین';
        description = 'الگوی بازی شما نسبتاً سالم به نظر می‌رسد. همچنان مراقب باشید و از ابزارهای کنترل استفاده کنید.';
        actions = `
            <div class="mt-3">
                <a href="#control-tools" class="btn btn-success">مشاهده ابزارهای کنترل</a>
            </div>
        `;
    } else if (totalScore <= 7) {
        riskLevel = 'medium';
        className = 'medium-risk';
        title = 'ریسک متوسط';
        description = 'ممکن است در حال توسعه مشکلات مرتبط با بازی باشید. توصیه می‌شود محدودیت‌هایی برای خود تعیین کنید.';
        actions = `
            <div class="mt-3">
                <a href="/pages/profile.php#limits" class="btn btn-warning">تنظیم محدودیت‌ها</a>
                <a href="/pages/support.php" class="btn btn-outline-primary">درخواست مشاوره</a>
            </div>
        `;
    } else {
        riskLevel = 'high';
        className = 'high-risk';
        title = 'ریسک بالا';
        description = 'نتایج نشان می‌دهد که ممکن است مشکل جدی با بازی داشته باشید. قویاً توصیه می‌شود کمک متخصص بگیرید.';
        actions = `
            <div class="mt-3">
                <a href="tel:+1-800-522-4700" class="btn btn-danger">تماس فوری با خط کمک</a>
                <a href="/pages/profile.php#self-exclusion" class="btn btn-outline-danger">خودمحدودسازی</a>
            </div>
        `;
    }
    
    resultDiv.className = `assessment-result ${className}`;
    titleElement.textContent = title;
    descriptionElement.textContent = description;
    actionsElement.innerHTML = actions;
    
    resultDiv.style.display = 'block';
    resultDiv.scrollIntoView({ behavior: 'smooth' });
}

// Smooth scrolling for anchor links
document.addEventListener('DOMContentLoaded', function() {
    const links = document.querySelectorAll('a[href^="#"]');
    
    links.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            
            const targetId = this.getAttribute('href').substring(1);
            const targetElement = document.getElementById(targetId);
            
            if (targetElement) {
                targetElement.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
});
</script>

<?php include '../includes/footer.php'; ?>

PHP
); ?>

<?php _merge_exec('pages/sportsbook.php', <<<'PHP'
<?php
// pages/sportsbook.php - Sportsbook Page
// صفحه شرط‌بندی ورزشی

require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// Page settings
$pageTitle = 'Sportsbook - Sports Betting';
$bodyClass = 'sportsbook-page';
$breadcrumbs = [
    ['title' => 'Sportsbook']
];

// Get filters from URL
$selectedSport = $_GET['sport'] ?? 'all';
$selectedLeague = $_GET['league'] ?? 'all';
$timeFilter = $_GET['time'] ?? 'today';
$searchQuery = $_GET['search'] ?? '';
$viewMode = $_GET['view'] ?? 'grid';

// Get sports data
$sportsData = getSportsData();
$featuredEvents = getFeaturedEvents(6);
$liveEvents = getLiveEvents(10);
$upcomingEvents = getUpcomingEvents($selectedSport, $selectedLeague, $timeFilter, $searchQuery, 50);

// Get leagues for selected sport
$leagues = [];
if ($selectedSport !== 'all') {
    $leagues = fetchAll(
        "SELECT l.* FROM leagues l 
         JOIN sports s ON l.sport_id = s.id 
         WHERE s.slug = ? AND l.active = 1 
         ORDER BY l.name",
        [$selectedSport]
    );
}

// Additional scripts
$additionalScripts = [
    '/assets/js/betting.js',
    '/assets/js/sportsbook.js'
];

include '../includes/header.php';
?>

<!-- Hero Section -->
<section class="sportsbook-hero">
    <div class="container">
        <div class="hero-content">
            <div class="hero-text">
                <h1 class="hero-title">
                    <i class="fas fa-futbol"></i>
                    Sports Betting
                </h1>
                <p class="hero-description">
                    Bet on your favorite sports with the best odds and instant crypto payouts. 
                    Live betting, pre-match markets, and exclusive promotions available.
                </p>
                <div class="hero-stats">
                    <div class="stat-item">
                        <div class="stat-number"><?php echo count($liveEvents); ?></div>
                        <div class="stat-label">Live Events</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number"><?php echo count($upcomingEvents); ?></div>
                        <div class="stat-label">Upcoming</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number"><?php echo count($sportsData); ?></div>
                        <div class="stat-label">Sports</div>
                    </div>
                </div>
            </div>
            <div class="hero-image">
                <div class="floating-cards">
                    <div class="betting-card">
                        <div class="card-header">
                            <span class="live-indicator">LIVE</span>
                            <span class="match-time">67'</span>
                        </div>
                        <div class="match-info">
                            <div class="team">
                                <img src="/assets/images/teams/barcelona.png" alt="Barcelona">
                                <span>Barcelona</span>
                                <span class="score">2</span>
                            </div>
                            <div class="vs">VS</div>
                            <div class="team">
                                <img src="/assets/images/teams/real-madrid.png" alt="Real Madrid">
                                <span>Real Madrid</span>
                                <span class="score">1</span>
                            </div>
                        </div>
                        <div class="odds-row">
                            <button class="odds-btn">1.85</button>
                            <button class="odds-btn">3.20</button>
                            <button class="odds-btn">4.50</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Sports Navigation -->
<section class="sports-nav-section">
    <div class="container">
        <div class="sports-nav">
            <div class="sports-tabs">
                <a href="?sport=all" class="sport-tab <?php echo $selectedSport === 'all' ? 'active' : ''; ?>">
                    <i class="fas fa-globe"></i>
                    <span>All Sports</span>
                    <span class="event-count"><?php echo array_sum(array_column($sportsData, 'total_events')); ?></span>
                </a>
                <?php foreach ($sportsData as $sport): ?>
                <a href="?sport=<?php echo $sport['slug']; ?>" 
                   class="sport-tab <?php echo $selectedSport === $sport['slug'] ? 'active' : ''; ?>">
                    <i class="<?php echo $sport['icon']; ?>"></i>
                    <span><?php echo $sport['name']; ?></span>
                    <span class="event-count"><?php echo $sport['total_events']; ?></span>
                    <?php if ($sport['live_count'] > 0): ?>
                    <span class="live-badge"><?php echo $sport['live_count']; ?></span>
                    <?php endif; ?>
                </a>
                <?php endforeach; ?>
            </div>
            
            <div class="nav-actions">
                <button class="live-events-btn" onclick="showLiveEvents()">
                    <i class="fas fa-broadcast-tower"></i>
                    <span>Live Events</span>
                    <span class="live-count"><?php echo count($liveEvents); ?></span>
                </button>
                <button class="favorites-btn" onclick="showFavorites()">
                    <i class="fas fa-star"></i>
                    <span>Favorites</span>
                </button>
            </div>
        </div>
    </div>
</section>

<!-- Live Events Ticker -->
<?php if (!empty($liveEvents)): ?>
<section class="live-ticker">
    <div class="container">
        <div class="ticker-header">
            <div class="ticker-title">
                <i class="fas fa-circle live-dot"></i>
                <span>Live Now</span>
            </div>
            <div class="ticker-controls">
                <button class="ticker-prev" onclick="scrollTicker('prev')">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button class="ticker-next" onclick="scrollTicker('next')">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>
        </div>
        <div class="ticker-content" id="liveTicker">
            <?php foreach ($liveEvents as $event): ?>
            <div class="ticker-item" data-event-id="<?php echo $event['id']; ?>">
                <div class="match-info">
                    <div class="teams">
                        <span class="home-team"><?php echo $event['home_team']; ?></span>
                        <span class="score"><?php echo $event['home_score']; ?>-<?php echo $event['away_score']; ?></span>
                        <span class="away-team"><?php echo $event['away_team']; ?></span>
                    </div>
                    <div class="match-status">
                        <span class="time"><?php echo $event['match_time']; ?>'</span>
                        <span class="sport"><?php echo $event['sport_name']; ?></span>
                    </div>
                </div>
                <div class="quick-odds">
                    <?php if ($event['home_odds']): ?>
                    <button class="odds-btn" onclick="addToBetSlip(<?php echo $event['id']; ?>, 'home', <?php echo $event['home_odds']; ?>)">
                        <?php echo number_format($event['home_odds'], 2); ?>
                    </button>
                    <?php endif; ?>
                    <?php if ($event['draw_odds']): ?>
                    <button class="odds-btn" onclick="addToBetSlip(<?php echo $event['id']; ?>, 'draw', <?php echo $event['draw_odds']; ?>)">
                        <?php echo number_format($event['draw_odds'], 2); ?>
                    </button>
                    <?php endif; ?>
                    <?php if ($event['away_odds']): ?>
                    <button class="odds-btn" onclick="addToBetSlip(<?php echo $event['id']; ?>, 'away', <?php echo $event['away_odds']; ?>)">
                        <?php echo number_format($event['away_odds'], 2); ?>
                    </button>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Filters & Search -->
<section class="filters-section">
    <div class="container">
        <div class="filters-bar">
            <div class="filter-group">
                <label class="filter-label">Time:</label>
                <select class="filter-select" id="timeFilter" onchange="applyFilters()">
                    <option value="today" <?php echo $timeFilter === 'today' ? 'selected' : ''; ?>>Today</option>
                    <option value="tomorrow" <?php echo $timeFilter === 'tomorrow' ? 'selected' : ''; ?>>Tomorrow</option>
                    <option value="week" <?php echo $timeFilter === 'week' ? 'selected' : ''; ?>>This Week</option>
                    <option value="all" <?php echo $timeFilter === 'all' ? 'selected' : ''; ?>>All Time</option>
                </select>
            </div>
            
            <?php if (!empty($leagues)): ?>
            <div class="filter-group">
                <label class="filter-label">League:</label>
                <select class="filter-select" id="leagueFilter" onchange="applyFilters()">
                    <option value="all">All Leagues</option>
                    <?php foreach ($leagues as $league): ?>
                    <option value="<?php echo $league['slug']; ?>" <?php echo $selectedLeague === $league['slug'] ? 'selected' : ''; ?>>
                        <?php echo $league['name']; ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <?php endif; ?>
            
            <div class="search-group">
                <div class="search-input">
                    <i class="fas fa-search"></i>
                    <input type="text" 
                           placeholder="Search teams, leagues..." 
                           value="<?php echo htmlspecialchars($searchQuery); ?>"
                           id="searchInput"
                           onkeyup="handleSearch(event)">
                    <?php if ($searchQuery): ?>
                    <button class="clear-search" onclick="clearSearch()">
                        <i class="fas fa-times"></i>
                    </button>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="view-toggle">
                <button class="view-btn <?php echo $viewMode === 'grid' ? 'active' : ''; ?>" 
                        onclick="changeView('grid')" data-view="grid">
                    <i class="fas fa-th"></i>
                </button>
                <button class="view-btn <?php echo $viewMode === 'list' ? 'active' : ''; ?>" 
                        onclick="changeView('list')" data-view="list">
                    <i class="fas fa-list"></i>
                </button>
            </div>
        </div>
    </div>
</section>

<!-- Featured Events -->
<?php if (!empty($featuredEvents) && $selectedSport === 'all' && empty($searchQuery)): ?>
<section class="featured-events">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-star"></i>
                Featured Events
            </h2>
            <a href="#upcoming-events" class="view-all-btn">View All Events</a>
        </div>
        
        <div class="featured-grid">
            <?php foreach ($featuredEvents as $event): ?>
            <div class="featured-event-card" data-event-id="<?php echo $event['id']; ?>">
                <div class="event-header">
                    <div class="league-info">
                        <img src="<?php echo $event['league_logo'] ?: '/assets/images/default-league.png'; ?>" 
                             alt="<?php echo $event['league_name']; ?>" class="league-logo">
                        <span class="league-name"><?php echo $event['league_name']; ?></span>
                    </div>
                    <div class="event-time">
                        <?php echo formatEventDate($event['start_time']); ?>
                    </div>
                </div>
                
                <div class="match-details">
                    <div class="team home-team">
                        <img src="<?php echo $event['home_team_logo'] ?: '/assets/images/default-team.png'; ?>" 
                             alt="<?php echo $event['home_team']; ?>" class="team-logo">
                        <span class="team-name"><?php echo $event['home_team']; ?></span>
                    </div>
                    
                    <div class="vs-section">
                        <span class="vs-text">VS</span>
                        <?php if ($event['status'] === 'live'): ?>
                        <div class="live-score">
                            <span class="score"><?php echo $event['home_score']; ?>-<?php echo $event['away_score']; ?></span>
                            <span class="live-indicator">LIVE</span>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="team away-team">
                        <img src="<?php echo $event['away_team_logo'] ?: '/assets/images/default-team.png'; ?>" 
                             alt="<?php echo $event['away_team']; ?>" class="team-logo">
                        <span class="team-name"><?php echo $event['away_team']; ?></span>
                    </div>
                </div>
                
                <div class="betting-options">
                    <?php if ($event['home_odds']): ?>
                    <button class="odds-btn home" 
                            onclick="addToBetSlip(<?php echo $event['id']; ?>, 'home', <?php echo $event['home_odds']; ?>, '<?php echo addslashes($event['home_team']); ?>')">
                        <span class="selection">1</span>
                        <span class="odds"><?php echo number_format($event['home_odds'], 2); ?></span>
                    </button>
                    <?php endif; ?>
                    
                    <?php if ($event['draw_odds']): ?>
                    <button class="odds-btn draw" 
                            onclick="addToBetSlip(<?php echo $event['id']; ?>, 'draw', <?php echo $event['draw_odds']; ?>, 'Draw')">
                        <span class="selection">X</span>
                        <span class="odds"><?php echo number_format($event['draw_odds'], 2); ?></span>
                    </button>
                    <?php endif; ?>
                    
                    <?php if ($event['away_odds']): ?>
                    <button class="odds-btn away" 
                            onclick="addToBetSlip(<?php echo $event['id']; ?>, 'away', <?php echo $event['away_odds']; ?>, '<?php echo addslashes($event['away_team']); ?>')">
                        <span class="selection">2</span>
                        <span class="odds"><?php echo number_format($event['away_odds'], 2); ?></span>
                    </button>
                    <?php endif; ?>
                </div>
                
                <div class="event-actions">
                    <button class="action-btn favorite" onclick="toggleFavorite(<?php echo $event['id']; ?>)">
                        <i class="far fa-star"></i>
                    </button>
                    <button class="action-btn more-markets" onclick="showMoreMarkets(<?php echo $event['id']; ?>)">
                        <span>+<?php echo $event['total_markets']; ?> Markets</span>
                    </button>
                    <?php if ($event['live_streaming']): ?>
                    <button class="action-btn stream" onclick="openStream(<?php echo $event['id']; ?>)">
                        <i class="fas fa-play"></i>
                    </button>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Upcoming Events -->
<section class="upcoming-events" id="upcoming-events">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">
                <i class="fas fa-calendar"></i>
                <?php 
                if ($selectedSport !== 'all') {
                    $sportName = array_filter($sportsData, fn($s) => $s['slug'] === $selectedSport)[0]['name'] ?? 'Sports';
                    echo $sportName . ' Events';
                } else {
                    echo 'Upcoming Events';
                }
                ?>
                <?php if ($searchQuery): ?>
                <span class="search-results">- Results for "<?php echo htmlspecialchars($searchQuery); ?>"</span>
                <?php endif; ?>
            </h2>
            <div class="results-count">
                <?php echo count($upcomingEvents); ?> events found
            </div>
        </div>
        
        <?php if (empty($upcomingEvents)): ?>
        <div class="empty-state">
            <div class="empty-icon">
                <i class="fas fa-calendar-times"></i>
            </div>
            <h3>No Events Found</h3>
            <p>
                <?php if ($searchQuery): ?>
                    No events match your search criteria. Try adjusting your search terms.
                <?php else: ?>
                    No events available for the selected filters. Try changing your selection.
                <?php endif; ?>
            </p>
            <div class="empty-actions">
                <?php if ($searchQuery): ?>
                <button class="btn btn-primary" onclick="clearSearch()">Clear Search</button>
                <?php endif; ?>
                <a href="/pages/sportsbook.php" class="btn btn-outline">View All Sports</a>
            </div>
        </div>
        <?php else: ?>
        <div class="events-container <?php echo $viewMode; ?>-view" id="eventsContainer">
            <?php foreach ($upcomingEvents as $event): ?>
            <div class="event-card" data-event-id="<?php echo $event['id']; ?>">
                <div class="event-info">
                    <div class="event-meta">
                        <div class="sport-league">
                            <i class="<?php echo $event['sport_icon']; ?>"></i>
                            <span class="sport-name"><?php echo $event['sport_name']; ?></span>
                            <span class="separator">•</span>
                            <span class="league-name"><?php echo $event['league_name']; ?></span>
                        </div>
                        <div class="event-time">
                            <?php echo formatEventDate($event['start_time']); ?>
                        </div>
                    </div>
                    
                    <div class="match-info">
                        <div class="teams">
                            <div class="team home">
                                <img src="<?php echo $event['home_team_logo'] ?: '/assets/images/default-team.png'; ?>" 
                                     alt="<?php echo $event['home_team']; ?>" class="team-logo">
                                <span class="team-name"><?php echo $event['home_team']; ?></span>
                            </div>
                            
                            <div class="vs">
                                <?php if ($event['status'] === 'live'): ?>
                                <div class="live-info">
                                    <span class="live-badge">LIVE</span>
                                    <span class="score"><?php echo $event['home_score']; ?>-<?php echo $event['away_score']; ?></span>
                                    <span class="time"><?php echo $event['match_time']; ?>'</span>
                                </div>
                                <?php else: ?>
                                <span class="vs-text">VS</span>
                                <?php endif; ?>
                            </div>
                            
                            <div class="team away">
                                <img src="<?php echo $event['away_team_logo'] ?: '/assets/images/default-team.png'; ?>" 
                                     alt="<?php echo $event['away_team']; ?>" class="team-logo">
                                <span class="team-name"><?php echo $event['away_team']; ?></span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="betting-section">
                    <div class="main-odds">
                        <?php if ($event['home_odds']): ?>
                        <button class="odds-btn home" 
                                onclick="addToBetSlip(<?php echo $event['id']; ?>, 'home', <?php echo $event['home_odds']; ?>, '<?php echo addslashes($event['home_team']); ?>')">
                            <span class="label">1</span>
                            <span class="odds"><?php echo number_format($event['home_odds'], 2); ?></span>
                        </button>
                        <?php endif; ?>
                        
                        <?php if ($event['draw_odds']): ?>
                        <button class="odds-btn draw" 
                                onclick="addToBetSlip(<?php echo $event['id']; ?>, 'draw', <?php echo $event['draw_odds']; ?>, 'Draw')">
                            <span class="label">X</span>
                            <span class="odds"><?php echo number_format($event['draw_odds'], 2); ?></span>
                        </button>
                        <?php endif; ?>
                        
                        <?php if ($event['away_odds']): ?>
                        <button class="odds-btn away" 
                                onclick="addToBetSlip(<?php echo $event['id']; ?>, 'away', <?php echo $event['away_odds']; ?>, '<?php echo addslashes($event['away_team']); ?>')">
                            <span class="label">2</span>
                            <span class="odds"><?php echo number_format($event['away_odds'], 2); ?></span>
                        </button>
                        <?php endif; ?>
                    </div>
                    
                    <div class="event-actions">
                        <button class="action-btn favorite" onclick="toggleFavorite(<?php echo $event['id']; ?>)" title="Add to Favorites">
                            <i class="far fa-star"></i>
                        </button>
                        <button class="action-btn markets" onclick="showEventDetails(<?php echo $event['id']; ?>)" title="All Markets">
                            <span>+<?php echo $event['total_markets']; ?></span>
                        </button>
                        <?php if ($event['live_streaming']): ?>
                        <button class="action-btn stream" onclick="openStream(<?php echo $event['id']; ?>)" title="Live Stream">
                            <i class="fas fa-play"></i>
                        </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Load More Button -->
        <div class="load-more-section">
            <button class="btn btn-outline load-more-btn" onclick="loadMoreEvents()">
                <i class="fas fa-plus"></i>
                Load More Events
            </button>
        </div>
        <?php endif; ?>
    </div>
</section>

<!-- Event Details Modal -->
<div class="modal-backdrop" id="eventDetailsModal">
    <div class="modal event-modal">
        <div class="modal-header">
            <h3 class="modal-title" id="eventModalTitle">Event Details</h3>
            <button class="modal-close" onclick="closeModal('eventDetailsModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body" id="eventModalBody">
            <!-- Event details will be loaded here -->
        </div>
    </div>
</div>

<!-- Live Stream Modal -->
<div class="modal-backdrop" id="streamModal">
    <div class="modal stream-modal">
        <div class="modal-header">
            <h3 class="modal-title">Live Stream</h3>
            <button class="modal-close" onclick="closeModal('streamModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            <div class="stream-container" id="streamContainer">
                <!-- Stream will be loaded here -->
            </div>
        </div>
    </div>
</div>

<script>
// Page-specific JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Initialize sportsbook functionality
    initializeSportsbook();
    
    // Auto-refresh live events
    setInterval(refreshLiveEvents, 30000); // Every 30 seconds
    
    // Initialize filters
    initializeFilters();
});

function initializeSportsbook() {
    // Initialize live ticker
    initializeLiveTicker();
    
    // Initialize event cards
    initializeEventCards();
    
    // Initialize search
    initializeSearch();
}

function applyFilters() {
    const timeFilter = document.getElementById('timeFilter').value;
    const leagueFilter = document.getElementById('leagueFilter')?.value || 'all';
    const searchQuery = document.getElementById('searchInput').value;
    
    const params = new URLSearchParams(window.location.search);
    params.set('time', timeFilter);
    params.set('league', leagueFilter);
    if (searchQuery) {
        params.set('search', searchQuery);
    } else {
        params.delete('search');
    }
    
    window.location.href = `${window.location.pathname}?${params.toString()}`;
}

function handleSearch(event) {
    if (event.key === 'Enter') {
        applyFilters();
    }
}

function clearSearch() {
    document.getElementById('searchInput').value = '';
    applyFilters();
}

function changeView(viewMode) {
    const params = new URLSearchParams(window.location.search);
    params.set('view', viewMode);
    window.location.href = `${window.location.pathname}?${params.toString()}`;
}

function showEventDetails(eventId) {
    // Load event details via AJAX
    Crashify.api.request(`/api/events/${eventId}/details`)
        .then(response => {
            if (response.success) {
                document.getElementById('eventModalBody').innerHTML = response.html;
                openModal('eventDetailsModal');
            }
        })
        .catch(error => {
            Crashify.ui.toast.error('Failed to load event details');
        });
}

function refreshLiveEvents() {
    // Refresh live events data
    Crashify.api.request('/api/events/live')
        .then(response => {
            if (response.success) {
                updateLiveEvents(response.events);
            }
        })
        .catch(error => {
            console.error('Failed to refresh live events:', error);
        });
}
</script>

<?php include '../includes/footer.php'; ?>

PHP
); ?>

<?php _merge_exec('pages/support.php', <<<'PHP'
<?php
// pages/support.php - Support Page
// صفحه پشتیبانی

require_once '../includes/auth.php';
require_once '../includes/functions.php';

$page_title = 'پشتیبانی';
$current_page = 'support';

// Handle form submissions
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['create_ticket'])) {
        $subject = sanitizeInput($_POST['subject']);
        $category = sanitizeInput($_POST['category']);
        $priority = sanitizeInput($_POST['priority']);
        $message = sanitizeInput($_POST['message']);
        
        if (empty($subject) || empty($message)) {
            $error_message = 'لطفاً تمام فیلدهای ضروری را پر کنید';
        } else {
            // Create support ticket
            $ticket_id = 'TK' . date('Ymd') . rand(1000, 9999);
            
            $stmt = $pdo->prepare("
                INSERT INTO support_tickets (ticket_id, user_id, subject, category, priority, status, created_at)
                VALUES (?, ?, ?, ?, ?, 'open', NOW())
            ");
            
            if ($stmt->execute([$ticket_id, $_SESSION['user_id'] ?? null, $subject, $category, $priority])) {
                $support_ticket_id = $pdo->lastInsertId();
                
                // Add initial message
                $stmt = $pdo->prepare("
                    INSERT INTO support_messages (ticket_id, user_id, message, is_admin, created_at)
                    VALUES (?, ?, ?, 0, NOW())
                ");
                
                if ($stmt->execute([$support_ticket_id, $_SESSION['user_id'] ?? null, $message])) {
                    $success_message = "تیکت شما با شماره $ticket_id ایجاد شد";
                } else {
                    $error_message = 'خطا در ارسال پیام';
                }
            } else {
                $error_message = 'خطا در ایجاد تیکت';
            }
        }
    }
    
    if (isset($_POST['send_message'])) {
        $ticket_id = intval($_POST['ticket_id']);
        $message = sanitizeInput($_POST['message']);
        
        if (empty($message)) {
            $error_message = 'لطفاً پیام خود را وارد کنید';
        } else {
            // Verify ticket belongs to user
            $stmt = $pdo->prepare("SELECT id FROM support_tickets WHERE id = ? AND (user_id = ? OR user_id IS NULL)");
            $stmt->execute([$ticket_id, $_SESSION['user_id'] ?? null]);
            
            if ($stmt->rowCount() > 0) {
                // Add message to ticket
                $stmt = $pdo->prepare("
                    INSERT INTO support_messages (ticket_id, user_id, message, is_admin, created_at)
                    VALUES (?, ?, ?, 0, NOW())
                ");
                
                if ($stmt->execute([$ticket_id, $_SESSION['user_id'] ?? null, $message])) {
                    // Update ticket status to 'waiting_admin'
                    $stmt = $pdo->prepare("UPDATE support_tickets SET status = 'waiting_admin', updated_at = NOW() WHERE id = ?");
                    $stmt->execute([$ticket_id]);
                    
                    $success_message = 'پیام شما ارسال شد';
                } else {
                    $error_message = 'خطا در ارسال پیام';
                }
            } else {
                $error_message = 'تیکت یافت نشد';
            }
        }
    }
}

// Get user tickets if logged in
$user_tickets = [];
if (isLoggedIn()) {
    $stmt = $pdo->prepare("
        SELECT st.*, 
               COUNT(sm.id) as message_count,
               MAX(sm.created_at) as last_message_at
        FROM support_tickets st
        LEFT JOIN support_messages sm ON st.id = sm.ticket_id
        WHERE st.user_id = ?
        GROUP BY st.id
        ORDER BY st.created_at DESC
        LIMIT 10
    ");
    $stmt->execute([$_SESSION['user_id']]);
    $user_tickets = $stmt->fetchAll();
}

// Get FAQ items
$stmt = $pdo->prepare("SELECT * FROM faq_items WHERE is_active = 1 ORDER BY sort_order ASC, id ASC");
$stmt->execute();
$faq_items = $stmt->fetchAll();

// Get current ticket if viewing one
$current_ticket = null;
$ticket_messages = [];
if (isset($_GET['ticket']) && isLoggedIn()) {
    $ticket_id = intval($_GET['ticket']);
    
    $stmt = $pdo->prepare("SELECT * FROM support_tickets WHERE id = ? AND user_id = ?");
    $stmt->execute([$ticket_id, $_SESSION['user_id']]);
    $current_ticket = $stmt->fetch();
    
    if ($current_ticket) {
        // Get ticket messages
        $stmt = $pdo->prepare("
            SELECT sm.*, u.first_name, u.last_name, u.avatar
            FROM support_messages sm
            LEFT JOIN users u ON sm.user_id = u.id
            WHERE sm.ticket_id = ?
            ORDER BY sm.created_at ASC
        ");
        $stmt->execute([$ticket_id]);
        $ticket_messages = $stmt->fetchAll();
        
        // Mark ticket as read by user
        $stmt = $pdo->prepare("UPDATE support_tickets SET user_read_at = NOW() WHERE id = ?");
        $stmt->execute([$ticket_id]);
    }
}

include '../includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-header">
                <h1><i class="fas fa-headset"></i> پشتیبانی</h1>
                <p class="text-muted">ما اینجا هستیم تا به شما کمک کنیم</p>
            </div>
        </div>
    </div>
    
    <?php if ($success_message): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?php echo $success_message; ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
    <?php endif; ?>
    
    <?php if ($error_message): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?php echo $error_message; ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
    <?php endif; ?>
    
    <?php if ($current_ticket): ?>
        <!-- Ticket View -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">
                                <i class="fas fa-ticket-alt"></i> 
                                تیکت #<?php echo htmlspecialchars($current_ticket['ticket_id']); ?>
                            </h5>
                            <small class="text-muted"><?php echo htmlspecialchars($current_ticket['subject']); ?></small>
                        </div>
                        <div>
                            <span class="badge badge-<?php echo getStatusBadgeClass($current_ticket['status']); ?>">
                                <?php echo getStatusLabel($current_ticket['status']); ?>
                            </span>
                            <a href="/pages/support.php" class="btn btn-sm btn-outline-secondary ml-2">
                                <i class="fas fa-arrow-left"></i> بازگشت
                            </a>
                        </div>
                    </div>
                    
                    <div class="card-body">
                        <!-- Ticket Messages -->
                        <div class="ticket-messages mb-4">
                            <?php foreach ($ticket_messages as $message): ?>
                                <div class="message-item <?php echo $message['is_admin'] ? 'admin-message' : 'user-message'; ?>">
                                    <div class="message-avatar">
                                        <?php if ($message['avatar']): ?>
                                            <img src="/uploads/avatars/<?php echo htmlspecialchars($message['avatar']); ?>" 
                                                 alt="Avatar" class="rounded-circle" width="40" height="40">
                                        <?php else: ?>
                                            <div class="avatar-placeholder">
                                                <i class="fas fa-<?php echo $message['is_admin'] ? 'user-tie' : 'user'; ?>"></i>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="message-content">
                                        <div class="message-header">
                                            <strong>
                                                <?php if ($message['is_admin']): ?>
                                                    پشتیبانی
                                                <?php else: ?>
                                                    <?php echo htmlspecialchars($message['first_name'] . ' ' . $message['last_name']); ?>
                                                <?php endif; ?>
                                            </strong>
                                            <span class="message-time">
                                                <?php echo timeAgo($message['created_at']); ?>
                                            </span>
                                        </div>
                                        <div class="message-text">
                                            <?php echo nl2br(htmlspecialchars($message['message'])); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        
                        <!-- Reply Form -->
                        <?php if ($current_ticket['status'] !== 'closed'): ?>
                            <form method="POST" class="reply-form">
                                <input type="hidden" name="ticket_id" value="<?php echo $current_ticket['id']; ?>">
                                <div class="form-group">
                                    <label for="message">پاسخ شما</label>
                                    <textarea class="form-control" id="message" name="message" rows="4" 
                                              placeholder="پیام خود را اینجا بنویسید..." required></textarea>
                                </div>
                                <button type="submit" name="send_message" class="btn btn-primary">
                                    <i class="fas fa-paper-plane"></i> ارسال پیام
                                </button>
                            </form>
                        <?php else: ?>
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i> این تیکت بسته شده است
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <!-- Support Dashboard -->
        <div class="row">
            <!-- Quick Actions -->
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card support-card">
                    <div class="card-body text-center">
                        <div class="support-icon">
                            <i class="fas fa-plus-circle text-primary"></i>
                        </div>
                        <h5>ایجاد تیکت جدید</h5>
                        <p class="text-muted">سوال یا مشکل جدید دارید؟</p>
                        <button class="btn btn-primary" data-toggle="modal" data-target="#newTicketModal">
                            <i class="fas fa-plus"></i> تیکت جدید
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card support-card">
                    <div class="card-body text-center">
                        <div class="support-icon">
                            <i class="fas fa-comments text-success"></i>
                        </div>
                        <h5>چت آنلاین</h5>
                        <p class="text-muted">گفتگو مستقیم با پشتیبانی</p>
                        <button class="btn btn-success" onclick="startLiveChat()">
                            <i class="fas fa-comment"></i> شروع چت
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card support-card">
                    <div class="card-body text-center">
                        <div class="support-icon">
                            <i class="fas fa-question-circle text-info"></i>
                        </div>
                        <h5>سوالات متداول</h5>
                        <p class="text-muted">پاسخ سوالات رایج</p>
                        <a href="#faq-section" class="btn btn-info">
                            <i class="fas fa-search"></i> مشاهده FAQ
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- User Tickets -->
        <?php if (isLoggedIn() && !empty($user_tickets)): ?>
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5><i class="fas fa-ticket-alt"></i> تیکت‌های شما</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>شماره تیکت</th>
                                            <th>موضوع</th>
                                            <th>دسته‌بندی</th>
                                            <th>وضعیت</th>
                                            <th>آخرین پیام</th>
                                            <th>عملیات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($user_tickets as $ticket): ?>
                                            <tr>
                                                <td>
                                                    <strong>#<?php echo htmlspecialchars($ticket['ticket_id']); ?></strong>
                                                </td>
                                                <td><?php echo htmlspecialchars($ticket['subject']); ?></td>
                                                <td>
                                                    <span class="badge badge-secondary">
                                                        <?php echo getCategoryLabel($ticket['category']); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="badge badge-<?php echo getStatusBadgeClass($ticket['status']); ?>">
                                                        <?php echo getStatusLabel($ticket['status']); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if ($ticket['last_message_at']): ?>
                                                        <?php echo timeAgo($ticket['last_message_at']); ?>
                                                    <?php else: ?>
                                                        -
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <a href="/pages/support.php?ticket=<?php echo $ticket['id']; ?>" 
                                                       class="btn btn-sm btn-outline-primary">
                                                        <i class="fas fa-eye"></i> مشاهده
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        
        <!-- FAQ Section -->
        <div class="row" id="faq-section">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5><i class="fas fa-question-circle"></i> سوالات متداول</h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($faq_items)): ?>
                            <p class="text-muted text-center">سوالی یافت نشد</p>
                        <?php else: ?>
                            <div class="accordion" id="faqAccordion">
                                <?php foreach ($faq_items as $index => $faq): ?>
                                    <div class="card">
                                        <div class="card-header" id="faq<?php echo $index; ?>">
                                            <h6 class="mb-0">
                                                <button class="btn btn-link collapsed" type="button" 
                                                        data-toggle="collapse" data-target="#collapse<?php echo $index; ?>" 
                                                        aria-expanded="false" aria-controls="collapse<?php echo $index; ?>">
                                                    <?php echo htmlspecialchars($faq['question']); ?>
                                                </button>
                                            </h6>
                                        </div>
                                        <div id="collapse<?php echo $index; ?>" class="collapse" 
                                             aria-labelledby="faq<?php echo $index; ?>" data-parent="#faqAccordion">
                                            <div class="card-body">
                                                <?php echo nl2br(htmlspecialchars($faq['answer'])); ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Contact Information -->
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5><i class="fas fa-phone"></i> اطلاعات تماس</h5>
                    </div>
                    <div class="card-body">
                        <div class="contact-item">
                            <i class="fas fa-envelope text-primary"></i>
                            <div class="contact-info">
                                <strong>ایمیل پشتیبانی</strong>
                                <p>support@crashify.com</p>
                            </div>
                        </div>
                        
                        <div class="contact-item">
                            <i class="fas fa-phone text-success"></i>
                            <div class="contact-info">
                                <strong>تلفن پشتیبانی</strong>
                                <p>+1 (555) 123-4567</p>
                            </div>
                        </div>
                        
                        <div class="contact-item">
                            <i class="fas fa-clock text-info"></i>
                            <div class="contact-info">
                                <strong>ساعات کاری</strong>
                                <p>24/7 - همه روزه</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5><i class="fas fa-info-circle"></i> راهنمای سریع</h5>
                    </div>
                    <div class="card-body">
                        <div class="quick-guide">
                            <div class="guide-item">
                                <i class="fas fa-user-plus text-primary"></i>
                                <div>
                                    <strong>ثبت نام</strong>
                                    <p>نحوه ایجاد حساب کاربری</p>
                                </div>
                            </div>
                            
                            <div class="guide-item">
                                <i class="fas fa-credit-card text-success"></i>
                                <div>
                                    <strong>واریز و برداشت</strong>
                                    <p>راهنمای تراکنش‌های مالی</p>
                                </div>
                            </div>
                            
                            <div class="guide-item">
                                <i class="fas fa-dice text-warning"></i>
                                <div>
                                    <strong>نحوه بازی</strong>
                                    <p>آموزش بازی‌های مختلف</p>
                                </div>
                            </div>
                            
                            <div class="guide-item">
                                <i class="fas fa-shield-alt text-danger"></i>
                                <div>
                                    <strong>امنیت حساب</strong>
                                    <p>تنظیمات امنیتی</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- New Ticket Modal -->
<div class="modal fade" id="newTicketModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-plus-circle"></i> ایجاد تیکت جدید
                </h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="subject">موضوع *</label>
                        <input type="text" class="form-control" id="subject" name="subject" 
                               placeholder="موضوع تیکت خود را وارد کنید" required>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category">دسته‌بندی</label>
                                <select class="form-control" id="category" name="category">
                                    <option value="general">عمومی</option>
                                    <option value="account">حساب کاربری</option>
                                    <option value="payment">پرداخت</option>
                                    <option value="technical">فنی</option>
                                    <option value="game">بازی</option>
                                    <option value="complaint">شکایت</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="priority">اولویت</label>
                                <select class="form-control" id="priority" name="priority">
                                    <option value="low">کم</option>
                                    <option value="medium" selected>متوسط</option>
                                    <option value="high">بالا</option>
                                    <option value="urgent">فوری</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="message">پیام *</label>
                        <textarea class="form-control" id="message" name="message" rows="6" 
                                  placeholder="توضیح کاملی از مشکل یا سوال خود ارائه دهید..." required></textarea>
                    </div>
                    
                    <?php if (!isLoggedIn()): ?>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            برای ایجاد تیکت، لطفاً ابتدا وارد حساب کاربری خود شوید
                        </div>
                    <?php endif; ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">انصراف</button>
                    <button type="submit" name="create_ticket" class="btn btn-primary" 
                            <?php echo !isLoggedIn() ? 'disabled' : ''; ?>>
                        <i class="fas fa-paper-plane"></i> ارسال تیکت
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
.support-card {
    transition: transform 0.2s;
    height: 100%;
}

.support-card:hover {
    transform: translateY(-5px);
}

.support-icon {
    font-size: 3rem;
    margin-bottom: 1rem;
}

.ticket-messages {
    max-height: 500px;
    overflow-y: auto;
}

.message-item {
    display: flex;
    margin-bottom: 1.5rem;
    padding: 1rem;
    border-radius: 8px;
}

.user-message {
    background: #f8f9fa;
    margin-left: 2rem;
}

.admin-message {
    background: #e3f2fd;
    margin-right: 2rem;
}

.message-avatar {
    margin-right: 1rem;
    flex-shrink: 0;
}

.avatar-placeholder {
    width: 40px;
    height: 40px;
    background: #dee2e6;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #6c757d;
}

.message-content {
    flex: 1;
}

.message-header {
    display: flex;
    justify-content: between;
    align-items: center;
    margin-bottom: 0.5rem;
}

.message-time {
    font-size: 0.875rem;
    color: #6c757d;
    margin-left: auto;
}

.message-text {
    line-height: 1.5;
}

.contact-item {
    display: flex;
    align-items: center;
    margin-bottom: 1rem;
    padding-bottom: 1rem;
    border-bottom: 1px solid #f8f9fa;
}

.contact-item:last-child {
    border-bottom: none;
    margin-bottom: 0;
    padding-bottom: 0;
}

.contact-item i {
    font-size: 1.5rem;
    margin-right: 1rem;
    width: 30px;
}

.contact-info strong {
    display: block;
    margin-bottom: 0.25rem;
}

.contact-info p {
    margin: 0;
    color: #6c757d;
}

.guide-item {
    display: flex;
    align-items: center;
    margin-bottom: 1rem;
    padding-bottom: 1rem;
    border-bottom: 1px solid #f8f9fa;
}

.guide-item:last-child {
    border-bottom: none;
    margin-bottom: 0;
    padding-bottom: 0;
}

.guide-item i {
    font-size: 1.5rem;
    margin-right: 1rem;
    width: 30px;
}

.guide-item strong {
    display: block;
    margin-bottom: 0.25rem;
}

.guide-item p {
    margin: 0;
    color: #6c757d;
    font-size: 0.875rem;
}

.page-header {
    margin-bottom: 2rem;
    text-align: center;
}

.page-header h1 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
}
</style>

<script>
function startLiveChat() {
    // Implement live chat functionality
    alert('چت آنلاین به زودی راه‌اندازی خواهد شد');
}

// Auto-resize textarea
document.addEventListener('DOMContentLoaded', function() {
    const textareas = document.querySelectorAll('textarea');
    textareas.forEach(textarea => {
        textarea.addEventListener('input', function() {
            this.style.height = 'auto';
            this.style.height = this.scrollHeight + 'px';
        });
    });
});
</script>

<?php
// Helper functions
function getStatusLabel($status) {
    $labels = [
        'open' => 'باز',
        'waiting_admin' => 'در انتظار پاسخ',
        'waiting_user' => 'در انتظار شما',
        'closed' => 'بسته شده',
        'resolved' => 'حل شده'
    ];
    
    return $labels[$status] ?? $status;
}

function getStatusBadgeClass($status) {
    $classes = [
        'open' => 'primary',
        'waiting_admin' => 'warning',
        'waiting_user' => 'info',
        'closed' => 'secondary',
        'resolved' => 'success'
    ];
    
    return $classes[$status] ?? 'secondary';
}

function getCategoryLabel($category) {
    $labels = [
        'general' => 'عمومی',
        'account' => 'حساب کاربری',
        'payment' => 'پرداخت',
        'technical' => 'فنی',
        'game' => 'بازی',
        'complaint' => 'شکایت'
    ];
    
    return $labels[$category] ?? $category;
}

include '../includes/footer.php';
?>
PHP
); ?>

<?php _merge_exec('pages/terms.php', <<<'PHP'
<?php
// pages/terms.php - Terms and Conditions Page
// صفحه قوانین و مقررات

require_once '../includes/functions.php';

$page_title = 'قوانین و مقررات';
$current_page = 'terms';

include '../includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-header text-center">
                <h1><i class="fas fa-file-contract"></i> قوانین و مقررات</h1>
                <p class="text-muted">شرایط استفاده از خدمات Crashify</p>
                <div class="last-updated">
                    <small class="text-muted">آخرین بروزرسانی: <?php echo date('Y/m/d'); ?></small>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Table of Contents -->
    <div class="row mb-4">
        <div class="col-lg-3">
            <div class="card sticky-top">
                <div class="card-header">
                    <h6><i class="fas fa-list"></i> فهرست مطالب</h6>
                </div>
                <div class="card-body p-0">
                    <nav class="toc-nav">
                        <ul class="nav nav-pills flex-column">
                            <li class="nav-item">
                                <a class="nav-link" href="#introduction">مقدمه</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#definitions">تعاریف</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#acceptance">پذیرش قوانین</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#eligibility">شرایط عضویت</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#account">حساب کاربری</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#deposits">واریز و برداشت</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#betting">قوانین شرط‌بندی</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#bonuses">جوایز و تخفیف‌ها</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#prohibited">فعالیت‌های ممنوع</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#responsible">بازی مسئولانه</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#privacy">حریم خصوصی</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#liability">مسئولیت</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#termination">خاتمه خدمات</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#changes">تغییرات</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#contact">تماس با ما</a>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
        
        <div class="col-lg-9">
            <div class="terms-content">
                <!-- Introduction -->
                <section id="introduction" class="terms-section">
                    <h2><i class="fas fa-info-circle"></i> مقدمه</h2>
                    <div class="section-content">
                        <p class="lead">
                            به Crashify خوش آمدید. این قوانین و مقررات ("قوانین") شرایط استفاده از وب‌سایت و خدمات ما را تعیین می‌کند.
                        </p>
                        <p>
                            Crashify یک پلتفرم شرط‌بندی آنلاین است که خدمات بازی‌های کازینو، شرط‌بندی ورزشی و سایر بازی‌های شانسی را ارائه می‌دهد. 
                            با استفاده از خدمات ما، شما موافقت می‌کنید که تمام قوانین و مقررات ذکر شده در این سند را رعایت کنید.
                        </p>
                        <div class="alert alert-info">
                            <i class="fas fa-exclamation-circle"></i>
                            <strong>مهم:</strong> لطفاً این قوانین را به دقت مطالعه کنید. استفاده از خدمات ما به معنای پذیرش کامل این شرایط است.
                        </div>
                    </div>
                </section>
                
                <!-- Definitions -->
                <section id="definitions" class="terms-section">
                    <h2><i class="fas fa-book"></i> تعاریف</h2>
                    <div class="section-content">
                        <p>در این قوانین، اصطلاحات زیر دارای معانی مشخص شده هستند:</p>
                        <dl class="definitions-list">
                            <dt>"شرکت" یا "ما" یا "Crashify"</dt>
                            <dd>به شرکت ارائه‌دهنده خدمات Crashify اطلاق می‌شود.</dd>
                            
                            <dt>"کاربر" یا "شما"</dt>
                            <dd>هر شخصی که از خدمات ما استفاده می‌کند یا حساب کاربری دارد.</dd>
                            
                            <dt>"خدمات"</dt>
                            <dd>تمام خدمات ارائه شده توسط Crashify شامل بازی‌ها، شرط‌بندی، و سایر امکانات.</dd>
                            
                            <dt>"حساب کاربری"</dt>
                            <dd>حساب شخصی که کاربر برای استفاده از خدمات ایجاد می‌کند.</dd>
                            
                            <dt>"شرط‌بندی"</dt>
                            <dd>قرار گذاشتن پول روی نتیجه یک رویداد یا بازی.</dd>
                            
                            <dt>"موجودی"</dt>
                            <dd>مبلغ پولی که در حساب کاربری موجود است.</dd>
                            
                            <dt>"جایزه" یا "بونوس"</dt>
                            <dd>مبالغ اضافی که شرکت به کاربران اعطا می‌کند.</dd>
                        </dl>
                    </div>
                </section>
                
                <!-- Acceptance -->
                <section id="acceptance" class="terms-section">
                    <h2><i class="fas fa-handshake"></i> پذیرش قوانین</h2>
                    <div class="section-content">
                        <p>
                            با ایجاد حساب کاربری، استفاده از خدمات، یا کلیک بر روی "موافقم" در هنگام ثبت نام، 
                            شما تأیید می‌کنید که:
                        </p>
                        <ul>
                            <li>این قوانین و مقررات را به طور کامل خوانده و درک کرده‌اید</li>
                            <li>با تمام شرایط ذکر شده موافق هستید</li>
                            <li>قانوناً صلاحیت انعقاد این قرارداد را دارید</li>
                            <li>تمام اطلاعات ارائه شده صحیح و کامل است</li>
                        </ul>
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            اگر با هر یک از این شرایط موافق نیستید، لطفاً از خدمات ما استفاده نکنید.
                        </div>
                    </div>
                </section>
                
                <!-- Eligibility -->
                <section id="eligibility" class="terms-section">
                    <h2><i class="fas fa-user-check"></i> شرایط عضویت</h2>
                    <div class="section-content">
                        <p>برای استفاده از خدمات Crashify، شما باید:</p>
                        <div class="eligibility-requirements">
                            <div class="requirement-item">
                                <i class="fas fa-birthday-cake text-primary"></i>
                                <div class="requirement-content">
                                    <h6>سن قانونی</h6>
                                    <p>حداقل 18 سال سن داشته باشید یا سن قانونی در کشور محل اقامت خود.</p>
                                </div>
                            </div>
                            
                            <div class="requirement-item">
                                <i class="fas fa-globe text-success"></i>
                                <div class="requirement-content">
                                    <h6>محدودیت جغرافیایی</h6>
                                    <p>در کشوری زندگی کنید که شرط‌بندی آنلاین قانونی است.</p>
                                </div>
                            </div>
                            
                            <div class="requirement-item">
                                <i class="fas fa-id-card text-info"></i>
                                <div class="requirement-content">
                                    <h6>هویت معتبر</h6>
                                    <p>مدارک هویتی معتبر برای تأیید حساب ارائه دهید.</p>
                                </div>
                            </div>
                            
                            <div class="requirement-item">
                                <i class="fas fa-user-times text-danger"></i>
                                <div class="requirement-content">
                                    <h6>عدم محدودیت</h6>
                                    <p>قبلاً از خدمات ما محروم نشده باشید.</p>
                                </div>
                            </div>
                        </div>
                        
                        <h5>کشورهای محدود</h5>
                        <p>متأسفانه خدمات ما در کشورهای زیر قابل دسترس نیست:</p>
                        <div class="restricted-countries">
                            <span class="country-tag">آمریکا</span>
                            <span class="country-tag">فرانسه</span>
                            <span class="country-tag">اسپانیا</span>
                            <span class="country-tag">ایتالیا</span>
                            <span class="country-tag">بلژیک</span>
                            <span class="country-tag">هلند</span>
                        </div>
                    </div>
                </section>
                
                <!-- Account -->
                <section id="account" class="terms-section">
                    <h2><i class="fas fa-user-cog"></i> حساب کاربری</h2>
                    <div class="section-content">
                        <h5>ایجاد حساب</h5>
                        <ul>
                            <li>هر شخص فقط می‌تواند یک حساب کاربری داشته باشد</li>
                            <li>تمام اطلاعات ارائه شده باید صحیح و به‌روز باشد</li>
                            <li>شما مسئول حفظ امنیت رمز عبور خود هستید</li>
                            <li>هرگونه فعالیت در حساب شما، مسئولیت شما محسوب می‌شود</li>
                        </ul>
                        
                        <h5>تأیید هویت</h5>
                        <p>ما حق داریم در هر زمان مدارک زیر را از شما درخواست کنیم:</p>
                        <ul>
                            <li>کارت شناسایی معتبر (شناسنامه، گذرنامه، کارت ملی)</li>
                            <li>مدرک اثبات آدرس (قبض آب، برق، گاز)</li>
                            <li>مدارک مالی (صورتحساب بانکی، کارت اعتباری)</li>
                        </ul>
                        
                        <h5>مسئولیت‌های کاربر</h5>
                        <div class="alert alert-info">
                            <ul class="mb-0">
                                <li>حفظ محرمانگی اطلاعات حساب</li>
                                <li>اطلاع‌رسانی فوری در صورت سوء استفاده</li>
                                <li>به‌روزرسانی اطلاعات شخصی</li>
                                <li>رعایت تمام قوانین و مقررات</li>
                            </ul>
                        </div>
                    </div>
                </section>
                
                <!-- Deposits and Withdrawals -->
                <section id="deposits" class="terms-section">
                    <h2><i class="fas fa-credit-card"></i> واریز و برداشت</h2>
                    <div class="section-content">
                        <h5>واریز وجه</h5>
                        <ul>
                            <li>حداقل مبلغ واریز: $10</li>
                            <li>حداکثر مبلغ واریز: $10,000 در روز</li>
                            <li>تمام واریزها فوری پردازش می‌شوند</li>
                            <li>کارمزد واریز بر عهده کاربر است</li>
                        </ul>
                        
                        <h5>برداشت وجه</h5>
                        <ul>
                            <li>حداقل مبلغ برداشت: $20</li>
                            <li>حداکثر مبلغ برداشت: $5,000 در روز</li>
                            <li>زمان پردازش: 1-3 روز کاری</li>
                            <li>تأیید هویت برای برداشت الزامی است</li>
                        </ul>
                        
                        <h5>روش‌های پرداخت</h5>
                        <div class="payment-methods">
                            <div class="payment-method">
                                <i class="fab fa-cc-visa"></i>
                                <span>کارت‌های اعتباری</span>
                            </div>
                            <div class="payment-method">
                                <i class="fab fa-bitcoin"></i>
                                <span>ارزهای دیجیتال</span>
                            </div>
                            <div class="payment-method">
                                <i class="fas fa-university"></i>
                                <span>انتقال بانکی</span>
                            </div>
                            <div class="payment-method">
                                <i class="fab fa-paypal"></i>
                                <span>کیف پول‌های دیجیتال</span>
                            </div>
                        </div>
                    </div>
                </section>
                
                <!-- Betting Rules -->
                <section id="betting" class="terms-section">
                    <h2><i class="fas fa-dice"></i> قوانین شرط‌بندی</h2>
                    <div class="section-content">
                        <h5>قوانین عمومی</h5>
                        <ul>
                            <li>تمام شرط‌ها نهایی و غیرقابل تغییر هستند</li>
                            <li>حداقل مبلغ شرط: $1</li>
                            <li>حداکثر مبلغ شرط: $1,000 (بسته به بازی)</li>
                            <li>نتایج بازی‌ها بر اساس الگوریتم‌های تأیید شده تعیین می‌شود</li>
                        </ul>
                        
                        <h5>بازی‌های کازینو</h5>
                        <ul>
                            <li>تمام بازی‌ها دارای RTP (Return to Player) مشخص هستند</li>
                            <li>نتایج بازی‌ها کاملاً تصادفی و قابل تأیید هستند</li>
                            <li>هیچ‌گونه دخالت در نتایج بازی‌ها صورت نمی‌گیرد</li>
                        </ul>
                        
                        <h5>شرط‌بندی ورزشی</h5>
                        <ul>
                            <li>شرط‌ها بر اساس نتایج رسمی تعیین می‌شوند</li>
                            <li>در صورت لغو مسابقه، شرط‌ها باطل می‌شوند</li>
                            <li>ضرایب ممکن است تا لحظه شروع مسابقه تغییر کنند</li>
                        </ul>
                        
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            <strong>هشدار:</strong> شرط‌بندی می‌تواند اعتیادآور باشد. لطفاً مسئولانه بازی کنید.
                        </div>
                    </div>
                </section>
                
                <!-- Bonuses -->
                <section id="bonuses" class="terms-section">
                    <h2><i class="fas fa-gift"></i> جوایز و تخفیف‌ها</h2>
                    <div class="section-content">
                        <h5>شرایط عمومی</h5>
                        <ul>
                            <li>تمام جوایز دارای شرایط گردش (Wagering) هستند</li>
                            <li>هر کاربر فقط یک بار از هر جایزه می‌تواند استفاده کند</li>
                            <li>جوایز دارای تاریخ انقضا هستند</li>
                            <li>سوء استفاده از جوایز منجر به لغو حساب می‌شود</li>
                        </ul>
                        
                        <h5>انواع جوایز</h5>
                        <div class="bonus-types">
                            <div class="bonus-type">
                                <h6><i class="fas fa-hand-holding-heart"></i> جایزه خوش‌آمدگویی</h6>
                                <p>100% تا $500 برای اولین واریز + 50 اسپین رایگان</p>
                                <small>شرایط گردش: 35x</small>
                            </div>
                            
                            <div class="bonus-type">
                                <h6><i class="fas fa-coins"></i> جایزه واریز</h6>
                                <p>50% تا $200 برای واریزهای بعدی</p>
                                <small>شرایط گردش: 25x</small>
                            </div>
                            
                            <div class="bonus-type">
                                <h6><i class="fas fa-undo-alt"></i> بازگشت وجه</h6>
                                <p>10% از ضررهای هفتگی تا $100</p>
                                <small>شرایط گردش: 15x</small>
                            </div>
                        </div>
                        
                        <h5>محاسبه شرایط گردش</h5>
                        <p>
                            شرایط گردش به معنای تعداد دفعاتی است که باید مبلغ جایزه را شرط‌بندی کنید. 
                            مثال: جایزه $100 با شرایط گردش 20x = $2,000 شرط‌بندی مورد نیاز.
                        </p>
                    </div>
                </section>
                
                <!-- Prohibited Activities -->
                <section id="prohibited" class="terms-section">
                    <h2><i class="fas fa-ban"></i> فعالیت‌های ممنوع</h2>
                    <div class="section-content">
                        <p>فعالیت‌های زیر اکیداً ممنوع بوده و منجر به تعلیق یا لغو حساب می‌شود:</p>
                        
                        <div class="prohibited-activities">
                            <div class="prohibited-item">
                                <i class="fas fa-users-slash text-danger"></i>
                                <div class="prohibited-content">
                                    <h6>حساب‌های متعدد</h6>
                                    <p>ایجاد بیش از یک حساب کاربری</p>
                                </div>
                            </div>
                            
                            <div class="prohibited-item">
                                <i class="fas fa-robot text-danger"></i>
                                <div class="prohibited-content">
                                    <h6>استفاده از ربات</h6>
                                    <p>استفاده از نرم‌افزارهای خودکار برای بازی</p>
                                </div>
                            </div>
                            
                            <div class="prohibited-item">
                                <i class="fas fa-handshake-slash text-danger"></i>
                                <div class="prohibited-content">
                                    <h6>تبانی</h6>
                                    <p>همکاری با سایر کاربران برای تقلب</p>
                                </div>
                            </div>
                            
                            <div class="prohibited-item">
                                <i class="fas fa-money-bill-wave-alt text-danger"></i>
                                <div class="prohibited-content">
                                    <h6>پولشویی</h6>
                                    <p>استفاده از پلتفرم برای پولشویی</p>
                                </div>
                            </div>
                            
                            <div class="prohibited-item">
                                <i class="fas fa-bug text-danger"></i>
                                <div class="prohibited-content">
                                    <h6>سوء استفاده از باگ</h6>
                                    <p>استفاده از اشکالات سیستم برای سود</p>
                                </div>
                            </div>
                            
                            <div class="prohibited-item">
                                <i class="fas fa-share-alt text-danger"></i>
                                <div class="prohibited-content">
                                    <h6>اشتراک حساب</h6>
                                    <p>اجازه استفاده از حساب به دیگران</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                
                <!-- Responsible Gaming -->
                <section id="responsible" class="terms-section">
                    <h2><i class="fas fa-shield-alt"></i> بازی مسئولانه</h2>
                    <div class="section-content">
                        <p>
                            ما متعهد به ترویج بازی مسئولانه هستیم و ابزارهای زیر را برای کمک به کاربران فراهم کرده‌ایم:
                        </p>
                        
                        <div class="responsible-tools">
                            <div class="tool-item">
                                <i class="fas fa-dollar-sign text-primary"></i>
                                <span>محدودیت واریز</span>
                            </div>
                            <div class="tool-item">
                                <i class="fas fa-coins text-primary"></i>
                                <span>محدودیت ضرر</span>
                            </div>
                            <div class="tool-item">
                                <i class="fas fa-clock text-primary"></i>
                                <span>محدودیت زمان</span>
                            </div>
                            <div class="tool-item">
                                <i class="fas fa-pause text-primary"></i>
                                <span>استراحت موقت</span>
                            </div>
                            <div class="tool-item">
                                <i class="fas fa-ban text-primary"></i>
                                <span>خودمحدودسازی</span>
                            </div>
                        </div>
                        
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            برای اطلاعات بیشتر درباره بازی مسئولانه، 
                            <a href="/pages/responsible-gambling.php">اینجا کلیک کنید</a>.
                        </div>
                    </div>
                </section>
                
                <!-- Privacy -->
                <section id="privacy" class="terms-section">
                    <h2><i class="fas fa-user-shield"></i> حریم خصوصی</h2>
                    <div class="section-content">
                        <p>
                            حفظ حریم خصوصی شما برای ما بسیار مهم است. ما متعهد به:
                        </p>
                        <ul>
                            <li>محافظت از اطلاعات شخصی شما</li>
                            <li>عدم فروش اطلاعات به اشخاص ثالث</li>
                            <li>استفاده از اطلاعات فقط برای ارائه خدمات</li>
                            <li>رعایت قوانین حفاظت از داده‌ها</li>
                        </ul>
                        
                        <p>
                            برای اطلاعات کامل درباره نحوه جمع‌آوری و استفاده از اطلاعات، 
                            لطفاً <a href="/pages/privacy.php">سیاست حریم خصوصی</a> ما را مطالعه کنید.
                        </p>
                    </div>
                </section>
                
                <!-- Liability -->
                <section id="liability" class="terms-section">
                    <h2><i class="fas fa-balance-scale"></i> مسئولیت</h2>
                    <div class="section-content">
                        <h5>محدودیت مسئولیت</h5>
                        <p>
                            Crashify در حد امکان تلاش می‌کند خدمات مطمئن و قابل اعتماد ارائه دهد، اما:
                        </p>
                        <ul>
                            <li>مسئولیتی در قبال ضررهای غیرمستقیم ندارد</li>
                            <li>خدمات "همان‌طور که هست" ارائه می‌شود</li>
                            <li>ممکن است خدمات موقتاً قطع شود</li>
                            <li>مسئولیت کل ما محدود به موجودی حساب شما است</li>
                        </ul>
                        
                        <h5>مسئولیت کاربر</h5>
                        <p>شما مسئول:</p>
                        <ul>
                            <li>رعایت قوانین محلی کشور خود</li>
                            <li>پرداخت مالیات‌های مربوطه</li>
                            <li>استفاده مسئولانه از خدمات</li>
                            <li>حفظ امنیت حساب کاربری</li>
                        </ul>
                    </div>
                </section>
                
                <!-- Termination -->
                <section id="termination" class="terms-section">
                    <h2><i class="fas fa-times-circle"></i> خاتمه خدمات</h2>
                    <div class="section-content">
                        <h5>خاتمه توسط کاربر</h5>
                        <p>شما می‌توانید در هر زمان:</p>
                        <ul>
                            <li>حساب خود را بستید</li>
                            <li>موجودی خود را برداشت کنید</li>
                            <li>استفاده از خدمات را متوقف کنید</li>
                        </ul>
                        
                        <h5>خاتمه توسط شرکت</h5>
                        <p>ما حق داریم در موارد زیر حساب شما را تعلیق یا لغو کنیم:</p>
                        <ul>
                            <li>نقض قوانین و مقررات</li>
                            <li>فعالیت‌های مشکوک یا تقلب</li>
                            <li>عدم تأیید هویت</li>
                            <li>درخواست مقامات قانونی</li>
                        </ul>
                        
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            در صورت لغو حساب، موجودی قانونی شما بازگردانده خواهد شد.
                        </div>
                    </div>
                </section>
                
                <!-- Changes -->
                <section id="changes" class="terms-section">
                    <h2><i class="fas fa-edit"></i> تغییرات</h2>
                    <div class="section-content">
                        <p>
                            ما حق داریم این قوانین و مقررات را در هر زمان تغییر دهیم. تغییرات مهم از طریق:
                        </p>
                        <ul>
                            <li>ایمیل به کاربران اطلاع‌رسانی می‌شود</li>
                            <li>در وب‌سایت اعلام می‌شود</li>
                            <li>در حساب کاربری نمایش داده می‌شود</li>
                        </ul>
                        
                        <p>
                            ادامه استفاده از خدمات پس از اعلام تغییرات، به معنای پذیرش آن‌ها است.
                        </p>
                    </div>
                </section>
                
                <!-- Contact -->
                <section id="contact" class="terms-section">
                    <h2><i class="fas fa-envelope"></i> تماس با ما</h2>
                    <div class="section-content">
                        <p>
                            اگر سوالی درباره این قوانین و مقررات دارید، می‌توانید با ما تماس بگیرید:
                        </p>
                        
                        <div class="contact-info">
                            <div class="contact-item">
                                <i class="fas fa-envelope text-primary"></i>
                                <div class="contact-details">
                                    <strong>ایمیل:</strong>
                                    <a href="mailto:legal@crashify.com">legal@crashify.com</a>
                                </div>
                            </div>
                            
                            <div class="contact-item">
                                <i class="fas fa-headset text-success"></i>
                                <div class="contact-details">
                                    <strong>پشتیبانی:</strong>
                                    <a href="/pages/support.php">مرکز پشتیبانی</a>
                                </div>
                            </div>
                            
                            <div class="contact-item">
                                <i class="fas fa-clock text-info"></i>
                                <div class="contact-details">
                                    <strong>ساعات کاری:</strong>
                                    24 ساعته، 7 روز هفته
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>

<style>
.page-header {
    margin-bottom: 2rem;
    padding: 2rem 0;
}

.last-updated {
    margin-top: 1rem;
}

.toc-nav {
    max-height: 70vh;
    overflow-y: auto;
}

.toc-nav .nav-link {
    color: #6c757d;
    font-size: 0.9rem;
    padding: 0.5rem 1rem;
    border-radius: 0;
    border-left: 3px solid transparent;
}

.toc-nav .nav-link:hover,
.toc-nav .nav-link.active {
    color: #007bff;
    background-color: #f8f9fa;
    border-left-color: #007bff;
}

.terms-content {
    padding-left: 2rem;
}

.terms-section {
    margin-bottom: 3rem;
    padding-bottom: 2rem;
    border-bottom: 1px solid #e9ecef;
}

.terms-section:last-child {
    border-bottom: none;
}

.terms-section h2 {
    color: #495057;
    margin-bottom: 1.5rem;
    display: flex;
    align-items: center;
}

.terms-section h2 i {
    margin-right: 0.75rem;
    color: #007bff;
}

.section-content {
    line-height: 1.7;
}

.section-content p {
    margin-bottom: 1rem;
}

.section-content ul,
.section-content ol {
    margin-bottom: 1.5rem;
}

.section-content li {
    margin-bottom: 0.5rem;
}

.definitions-list dt {
    font-weight: 600;
    color: #495057;
    margin-top: 1rem;
    margin-bottom: 0.5rem;
}

.definitions-list dd {
    margin-bottom: 1rem;
    margin-left: 1rem;
    color: #6c757d;
}

.eligibility-requirements {
    margin: 2rem 0;
}

.requirement-item {
    display: flex;
    align-items: flex-start;
    margin-bottom: 2rem;
    padding: 1.5rem;
    background: #f8f9fa;
    border-radius: 10px;
}

.requirement-item i {
    font-size: 2rem;
    margin-right: 1rem;
    margin-top: 0.25rem;
}

.requirement-content h6 {
    color: #495057;
    margin-bottom: 0.5rem;
    font-weight: 600;
}

.requirement-content p {
    margin: 0;
    color: #6c757d;
}

.restricted-countries {
    display: flex;
    flex-wrap: wrap;
    gap: 0.5rem;
    margin-top: 1rem;
}

.country-tag {
    background: #dc3545;
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 15px;
    font-size: 0.875rem;
}

.payment-methods {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
    margin-top: 1rem;
}

.payment-method {
    display: flex;
    align-items: center;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 10px;
    min-width: 150px;
}

.payment-method i {
    font-size: 1.5rem;
    margin-right: 0.75rem;
    color: #007bff;
}

.bonus-types {
    margin: 2rem 0;
}

.bonus-type {
    background: #f8f9fa;
    padding: 1.5rem;
    border-radius: 10px;
    margin-bottom: 1rem;
    border-left: 4px solid #007bff;
}

.bonus-type h6 {
    color: #495057;
    margin-bottom: 0.5rem;
    display: flex;
    align-items: center;
}

.bonus-type h6 i {
    margin-right: 0.5rem;
    color: #007bff;
}

.bonus-type p {
    margin-bottom: 0.5rem;
    font-weight: 500;
}

.bonus-type small {
    color: #6c757d;
}

.prohibited-activities {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1rem;
    margin: 2rem 0;
}

.prohibited-item {
    display: flex;
    align-items: flex-start;
    padding: 1.5rem;
    background: #fff5f5;
    border: 1px solid #fed7d7;
    border-radius: 10px;
}

.prohibited-item i {
    font-size: 1.5rem;
    margin-right: 1rem;
    margin-top: 0.25rem;
}

.prohibited-content h6 {
    color: #495057;
    margin-bottom: 0.5rem;
    font-weight: 600;
}

.prohibited-content p {
    margin: 0;
    color: #6c757d;
    font-size: 0.9rem;
}

.responsible-tools {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
    margin: 1.5rem 0;
}

.tool-item {
    display: flex;
    align-items: center;
    padding: 0.75rem 1rem;
    background: #e3f2fd;
    border-radius: 25px;
    font-size: 0.9rem;
}

.tool-item i {
    margin-right: 0.5rem;
}

.contact-info {
    margin-top: 2rem;
}

.contact-item {
    display: flex;
    align-items: center;
    margin-bottom: 1rem;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 10px;
}

.contact-item i {
    font-size: 1.5rem;
    margin-right: 1rem;
}

.contact-details strong {
    display: block;
    color: #495057;
    margin-bottom: 0.25rem;
}

.contact-details a {
    color: #007bff;
    text-decoration: none;
}

.contact-details a:hover {
    text-decoration: underline;
}

@media (max-width: 768px) {
    .terms-content {
        padding-left: 0;
    }
    
    .requirement-item,
    .prohibited-item {
        flex-direction: column;
        text-align: center;
    }
    
    .requirement-item i,
    .prohibited-item i {
        margin-right: 0;
        margin-bottom: 1rem;
    }
    
    .payment-methods {
        flex-direction: column;
    }
    
    .payment-method {
        justify-content: center;
    }
    
    .responsible-tools {
        flex-direction: column;
    }
    
    .tool-item {
        justify-content: center;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Smooth scrolling for table of contents
    const tocLinks = document.querySelectorAll('.toc-nav .nav-link');
    
    tocLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            
            const targetId = this.getAttribute('href').substring(1);
            const targetElement = document.getElementById(targetId);
            
            if (targetElement) {
                // Remove active class from all links
                tocLinks.forEach(l => l.classList.remove('active'));
                
                // Add active class to clicked link
                this.classList.add('active');
                
                // Smooth scroll to target
                targetElement.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
    
    // Update active link on scroll
    const sections = document.querySelectorAll('.terms-section');
    const navLinks = document.querySelectorAll('.toc-nav .nav-link');
    
    function updateActiveLink() {
        let current = '';
        
        sections.forEach(section => {
            const sectionTop = section.offsetTop;
            const sectionHeight = section.clientHeight;
            
            if (window.pageYOffset >= sectionTop - 100) {
                current = section.getAttribute('id');
            }
        });
        
        navLinks.forEach(link => {
            link.classList.remove('active');
            if (link.getAttribute('href') === '#' + current) {
                link.classList.add('active');
            }
        });
    }
    
    window.addEventListener('scroll', updateActiveLink);
    updateActiveLink(); // Initial call
});
</script>

<?php include '../includes/footer.php'; ?>

PHP
); ?>

<?php _merge_exec('pages/wallet.php', <<<'PHP'
    <?php
// pages/wallet.php - Wallet & Payment Management
// کیف پول و مدیریت پرداخت‌ها

require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

// Require authentication
requireAuth();

// Page settings
$pageTitle = 'Wallet - Deposits & Withdrawals';
$bodyClass = 'wallet-page';
$breadcrumbs = [
    ['title' => 'Wallet']
];

// Get current action
$currentAction = $_GET['action'] ?? 'overview';

// Get user's transaction history
$transactions = fetchAll(
    "SELECT * FROM transactions 
     WHERE user_id = ? 
     ORDER BY created_at DESC 
     LIMIT 50",
    [$currentUser['id']]
);

// Get payment methods
$paymentMethods = [
    'crypto' => [
        'bitcoin' => [
            'name' => 'Bitcoin',
            'symbol' => 'BTC',
            'icon' => 'fab fa-bitcoin',
            'min_deposit' => 0.001,
            'max_deposit' => 10,
            'min_withdraw' => 0.002,
            'max_withdraw' => 5,
            'fee' => 0.0005,
            'processing_time' => '10-30 minutes',
            'address' => 'bc1qxy2kgdygjrsqtzq2n0yrf2493p83kkfjhx0wlh'
        ],
        'ethereum' => [
            'name' => 'Ethereum',
            'symbol' => 'ETH',
            'icon' => 'fab fa-ethereum',
            'min_deposit' => 0.01,
            'max_deposit' => 100,
            'min_withdraw' => 0.02,
            'max_withdraw' => 50,
            'fee' => 0.005,
            'processing_time' => '5-15 minutes',
            'address' => '0x742d35Cc6634C0532925a3b8D4C9db96590b5c8e'
        ],
        'usdt' => [
            'name' => 'Tether USDT',
            'symbol' => 'USDT',
            'icon' => 'fas fa-dollar-sign',
            'min_deposit' => 10,
            'max_deposit' => 10000,
            'min_withdraw' => 20,
            'max_withdraw' => 5000,
            'fee' => 1,
            'processing_time' => '5-10 minutes',
            'address' => 'TQrZ8tKfjkdZs4ftzHBTHSUjrxLqd6OVEC'
        ]
    ],
    'traditional' => [
        'visa' => [
            'name' => 'Visa Card',
            'icon' => 'fab fa-cc-visa',
            'min_deposit' => 20,
            'max_deposit' => 5000,
            'fee_percentage' => 3.5,
            'processing_time' => 'Instant'
        ],
        'mastercard' => [
            'name' => 'Mastercard',
            'icon' => 'fab fa-cc-mastercard',
            'min_deposit' => 20,
            'max_deposit' => 5000,
            'fee_percentage' => 3.5,
            'processing_time' => 'Instant'
        ]
    ]
];

// Get user's pending transactions
$pendingTransactions = fetchAll(
    "SELECT * FROM transactions 
     WHERE user_id = ? AND status = 'pending' 
     ORDER BY created_at DESC",
    [$currentUser['id']]
);

$additionalScripts = [
    '/assets/js/wallet.js',
    '/assets/js/qrcode.js'
];

include '../includes/header.php';
?>

<!-- Wallet Header -->
<section class="wallet-header">
    <div class="container">
        <div class="header-content">
            <div class="wallet-info">
                <h1 class="page-title">
                    <i class="fas fa-wallet"></i>
                    Wallet
                </h1>
                <p class="page-description">
                    Manage your deposits, withdrawals, and transaction history securely.
                </p>
            </div>
            
            <div class="wallet-balance">
                <div class="balance-card main-balance">
                    <div class="balance-header">
                        <h3>Main Balance</h3>
                        <button class="refresh-btn" onclick="refreshBalance()">
                            <i class="fas fa-sync-alt"></i>
                        </button>
                    </div>
                    <div class="balance-amount">
                        <span class="currency">$</span>
                        <span class="amount" id="mainBalance"><?php echo number_format($currentUser['balance'], 2); ?></span>
                    </div>
                    <div class="balance-actions">
                        <button class="btn btn-primary" onclick="showDepositModal()">
                            <i class="fas fa-plus"></i>
                            Deposit
                        </button>
                        <button class="btn btn-outline" onclick="showWithdrawModal()">
                            <i class="fas fa-minus"></i>
                            Withdraw
                        </button>
                    </div>
                </div>
                
                <?php if ($currentUser['bonus_balance'] > 0): ?>
                <div class="balance-card bonus-balance">
                    <div class="balance-header">
                        <h3>Bonus Balance</h3>
                        <i class="fas fa-info-circle" title="Bonus funds with wagering requirements"></i>
                    </div>
                    <div class="balance-amount">
                        <span class="currency">$</span>
                        <span class="amount"><?php echo number_format($currentUser['bonus_balance'], 2); ?></span>
                    </div>
                    <div class="bonus-info">
                        <span class="wagering-info">Wagering required</span>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<!-- Wallet Navigation -->
<section class="wallet-nav">
    <div class="container">
        <div class="nav-tabs">
            <button class="tab-btn <?php echo $currentAction === 'overview' ? 'active' : ''; ?>" 
                    onclick="switchTab('overview')">
                <i class="fas fa-chart-pie"></i>
                <span>Overview</span>
            </button>
            <button class="tab-btn <?php echo $currentAction === 'deposit' ? 'active' : ''; ?>" 
                    onclick="switchTab('deposit')">
                <i class="fas fa-plus"></i>
                <span>Deposit</span>
            </button>
            <button class="tab-btn <?php echo $currentAction === 'withdraw' ? 'active' : ''; ?>" 
                    onclick="switchTab('withdraw')">
                <i class="fas fa-minus"></i>
                <span>Withdraw</span>
            </button>
            <button class="tab-btn <?php echo $currentAction === 'history' ? 'active' : ''; ?>" 
                    onclick="switchTab('history')">
                <i class="fas fa-history"></i>
                <span>History</span>
            </button>
        </div>
    </div>
</section>

<!-- Pending Transactions Alert -->
<?php if (!empty($pendingTransactions)): ?>
<section class="pending-transactions">
    <div class="container">
        <div class="alert alert-info">
            <div class="alert-icon">
                <i class="fas fa-clock"></i>
            </div>
            <div class="alert-content">
                <h4>Pending Transactions</h4>
                <p>You have <?php echo count($pendingTransactions); ?> pending transaction(s). Processing times may vary.</p>
            </div>
            <button class="alert-close" onclick="this.parentElement.parentElement.style.display='none'">
                <i class="fas fa-times"></i>
            </button>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Wallet Content -->
<section class="wallet-content">
    <div class="container">
        <!-- Overview Tab -->
        <div class="tab-content <?php echo $currentAction === 'overview' ? 'active' : ''; ?>" id="overviewTab">
            <div class="overview-grid">
                <!-- Quick Stats -->
                <div class="stats-widget">
                    <h3 class="widget-title">
                        <i class="fas fa-chart-bar"></i>
                        Quick Stats
                    </h3>
                    <div class="stats-grid">
                        <div class="stat-item">
                            <div class="stat-value">
                                $<?php echo number_format(array_sum(array_column(array_filter($transactions, fn($t) => $t['type'] === 'deposit' && $t['status'] === 'completed'), 'amount')), 2); ?>
                            </div>
                            <div class="stat-label">Total Deposited</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value">
                                $<?php echo number_format(array_sum(array_column(array_filter($transactions, fn($t) => $t['type'] === 'withdrawal' && $t['status'] === 'completed'), 'amount')), 2); ?>
                            </div>
                            <div class="stat-label">Total Withdrawn</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value">
                                <?php echo count(array_filter($transactions, fn($t) => $t['type'] === 'deposit')); ?>
                            </div>
                            <div class="stat-label">Deposits</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value">
                                <?php echo count(array_filter($transactions, fn($t) => $t['type'] === 'withdrawal')); ?>
                            </div>
                            <div class="stat-label">Withdrawals</div>
                        </div>
                    </div>
                </div>
                
                <!-- Recent Transactions -->
                <div class="recent-transactions-widget">
                    <div class="widget-header">
                        <h3 class="widget-title">
                            <i class="fas fa-history"></i>
                            Recent Transactions
                        </h3>
                        <a href="?action=history" class="view-all-link">View All</a>
                    </div>
                    <div class="transactions-list">
                        <?php if (empty($transactions)): ?>
                        <div class="empty-state">
                            <i class="fas fa-receipt"></i>
                            <p>No transactions yet</p>
                            <button class="btn btn-primary btn-sm" onclick="showDepositModal()">
                                Make Your First Deposit
                            </button>
                        </div>
                        <?php else: ?>
                        <?php foreach (array_slice($transactions, 0, 5) as $transaction): ?>
                        <div class="transaction-item">
                            <div class="transaction-icon">
                                <i class="fas fa-<?php echo $transaction['type'] === 'deposit' ? 'plus' : 'minus'; ?>"></i>
                            </div>
                            <div class="transaction-info">
                                <div class="transaction-type"><?php echo ucfirst($transaction['type']); ?></div>
                                <div class="transaction-method"><?php echo $transaction['payment_method']; ?></div>
                                <div class="transaction-time"><?php echo timeAgo($transaction['created_at']); ?></div>
                            </div>
                            <div class="transaction-amount">
                                <div class="amount <?php echo $transaction['type']; ?>">
                                    <?php echo $transaction['type'] === 'deposit' ? '+' : '-'; ?>$<?php echo number_format($transaction['amount'], 2); ?>
                                </div>
                                <div class="status status-<?php echo $transaction['status']; ?>">
                                    <?php echo ucfirst($transaction['status']); ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Deposit Tab -->
        <div class="tab-content <?php echo $currentAction === 'deposit' ? 'active' : ''; ?>" id="depositTab">
            <div class="deposit-content">
                <div class="payment-methods">
                    <h3 class="section-title">
                        <i class="fas fa-credit-card"></i>
                        Choose Payment Method
                    </h3>
                    
                    <!-- Crypto Methods -->
                    <div class="method-category">
                        <h4 class="category-title">
                            <i class="fab fa-bitcoin"></i>
                            Cryptocurrency (Recommended)
                        </h4>
                        <div class="methods-grid">
                            <?php foreach ($paymentMethods['crypto'] as $key => $method): ?>
                            <div class="payment-method crypto" data-method="<?php echo $key; ?>">
                                <div class="method-icon">
                                    <i class="<?php echo $method['icon']; ?>"></i>
                                </div>
                                <div class="method-info">
                                    <h5 class="method-name"><?php echo $method['name']; ?></h5>
                                    <div class="method-details">
                                        <span class="processing-time"><?php echo $method['processing_time']; ?></span>
                                        <span class="fee">Fee: <?php echo $method['fee']; ?> <?php echo $method['symbol']; ?></span>
                                    </div>
                                </div>
                                <div class="method-limits">
                                    <div class="limit">Min: <?php echo $method['min_deposit']; ?> <?php echo $method['symbol']; ?></div>
                                    <div class="limit">Max: <?php echo $method['max_deposit']; ?> <?php echo $method['symbol']; ?></div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    
                    <!-- Traditional Methods -->
                    <div class="method-category">
                        <h4 class="category-title">
                            <i class="fas fa-credit-card"></i>
                            Credit/Debit Cards
                        </h4>
                        <div class="methods-grid">
                            <?php foreach ($paymentMethods['traditional'] as $key => $method): ?>
                            <div class="payment-method traditional" data-method="<?php echo $key; ?>">
                                <div class="method-icon">
                                    <i class="<?php echo $method['icon']; ?>"></i>
                                </div>
                                <div class="method-info">
                                    <h5 class="method-name"><?php echo $method['name']; ?></h5>
                                    <div class="method-details">
                                        <span class="processing-time"><?php echo $method['processing_time']; ?></span>
                                        <span class="fee">Fee: <?php echo $method['fee_percentage']; ?>%</span>
                                    </div>
                                </div>
                                <div class="method-limits">
                                    <div class="limit">Min: $<?php echo $method['min_deposit']; ?></div>
                                    <div class="limit">Max: $<?php echo $method['max_deposit']; ?></div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Withdraw Tab -->
        <div class="tab-content <?php echo $currentAction === 'withdraw' ? 'active' : ''; ?>" id="withdrawTab">
            <div class="withdraw-content">
                <div class="withdraw-info">
                    <div class="info-card">
                        <h3>Withdrawal Information</h3>
                        <ul class="info-list">
                            <li><i class="fas fa-check"></i> Minimum withdrawal: $20</li>
                            <li><i class="fas fa-check"></i> Processing time: 1-24 hours</li>
                            <li><i class="fas fa-check"></i> No fees for crypto withdrawals</li>
                            <li><i class="fas fa-check"></i> KYC verification required</li>
                        </ul>
                    </div>
                </div>
                
                <div class="withdraw-form-container">
                    <h3 class="section-title">
                        <i class="fas fa-money-bill-wave"></i>
                        Withdraw Funds
                    </h3>
                    
                    <form class="withdraw-form" id="withdrawForm">
                        <div class="form-group">
                            <label for="withdrawMethod">Withdrawal Method</label>
                            <select id="withdrawMethod" name="method" required>
                                <option value="">Select method...</option>
                                <?php foreach ($paymentMethods['crypto'] as $key => $method): ?>
                                <option value="<?php echo $key; ?>"><?php echo $method['name']; ?> (<?php echo $method['symbol']; ?>)</option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="withdrawAmount">Amount (USD)</label>
                            <div class="amount-input">
                                <span class="currency-symbol">$</span>
                                <input type="number" 
                                       id="withdrawAmount" 
                                       name="amount" 
                                       min="20" 
                                       max="<?php echo $currentUser['balance']; ?>" 
                                       step="0.01" 
                                       placeholder="0.00" 
                                       required>
                                <button type="button" class="max-btn" onclick="setMaxAmount()">MAX</button>
                            </div>
                            <div class="amount-info">
                                <span>Available: $<?php echo number_format($currentUser['balance'], 2); ?></span>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="withdrawAddress">Wallet Address</label>
                            <input type="text" 
                                   id="withdrawAddress" 
                                   name="address" 
                                   placeholder="Enter your wallet address" 
                                   required>
                            <div class="address-help">
                                <i class="fas fa-info-circle"></i>
                                <span>Make sure the address is correct. Transactions cannot be reversed.</span>
                            </div>
                        </div>
                        
                        <div class="withdrawal-summary" id="withdrawalSummary" style="display: none;">
                            <h4>Withdrawal Summary</h4>
                            <div class="summary-row">
                                <span>Amount:</span>
                                <span id="summaryAmount">$0.00</span>
                            </div>
                            <div class="summary-row">
                                <span>Fee:</span>
                                <span id="summaryFee">$0.00</span>
                            </div>
                            <div class="summary-row total">
                                <span>You will receive:</span>
                                <span id="summaryTotal">$0.00</span>
                            </div>
                        </div>
                        
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-paper-plane"></i>
                            Request Withdrawal
                        </button>
                    </form>
                </div>
            </div>
        </div>
        
        <!-- History Tab -->
        <div class="tab-content <?php echo $currentAction === 'history' ? 'active' : ''; ?>" id="historyTab">
            <div class="history-content">
                <div class="history-filters">
                    <div class="filter-group">
                        <label for="typeFilter">Type</label>
                        <select id="typeFilter" onchange="filterTransactions()">
                            <option value="">All Types</option>
                            <option value="deposit">Deposits</option>
                            <option value="withdrawal">Withdrawals</option>
                        </select>
                    </div>
                    <div class="filter-group">
                        <label for="statusFilter">Status</label>
                        <select id="statusFilter" onchange="filterTransactions()">
                            <option value="">All Status</option>
                            <option value="completed">Completed</option>
                            <option value="pending">Pending</option>
                            <option value="failed">Failed</option>
                        </select>
                    </div>
                    <div class="filter-group">
                        <label for="dateFilter">Date Range</label>
                        <select id="dateFilter" onchange="filterTransactions()">
                            <option value="">All Time</option>
                            <option value="today">Today</option>
                            <option value="week">This Week</option>
                            <option value="month">This Month</option>
                            <option value="year">This Year</option>
                        </select>
                    </div>
                </div>
                
                <div class="transactions-table">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Type</th>
                                <th>Method</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody id="transactionsTableBody">
                            <?php foreach ($transactions as $transaction): ?>
                            <tr class="transaction-row" 
                                data-type="<?php echo $transaction['type']; ?>" 
                                data-status="<?php echo $transaction['status']; ?>"
                                data-date="<?php echo date('Y-m-d', strtotime($transaction['created_at'])); ?>">
                                <td>
                                    <div class="date-info">
                                        <div class="date"><?php echo date('M j, Y', strtotime($transaction['created_at'])); ?></div>
                                        <div class="time"><?php echo date('H:i', strtotime($transaction['created_at'])); ?></div>
                                    </div>
                                </td>
                                <td>
                                    <div class="type-info">
                                        <i class="fas fa-<?php echo $transaction['type'] === 'deposit' ? 'plus' : 'minus'; ?>"></i>
                                        <span><?php echo ucfirst($transaction['type']); ?></span>
                                    </div>
                                </td>
                                <td><?php echo $transaction['payment_method']; ?></td>
                                <td>
                                    <div class="amount <?php echo $transaction['type']; ?>">
                                        <?php echo $transaction['type'] === 'deposit' ? '+' : '-'; ?>$<?php echo number_format($transaction['amount'], 2); ?>
                                    </div>
                                </td>
                                <td>
                                    <span class="status-badge status-<?php echo $transaction['status']; ?>">
                                        <?php echo ucfirst($transaction['status']); ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="action-buttons">
                                        <button class="btn btn-outline btn-xs" onclick="viewTransaction(<?php echo $transaction['id']; ?>)">
                                            <i class="fas fa-eye"></i>
                                            View
                                        </button>
                                        <?php if ($transaction['status'] === 'pending' && $transaction['type'] === 'withdrawal'): ?>
                                        <button class="btn btn-danger btn-xs" onclick="cancelTransaction(<?php echo $transaction['id']; ?>)">
                                            <i class="fas fa-times"></i>
                                            Cancel
                                        </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Deposit Modal -->
<div class="modal-backdrop" id="depositModal">
    <div class="modal deposit-modal">
        <div class="modal-header">
            <h3 class="modal-title">Make a Deposit</h3>
            <button class="modal-close" onclick="closeModal('depositModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body" id="depositModalBody">
            <!-- Deposit form will be loaded here -->
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    initializeWallet();
});

function initializeWallet() {
    // Initialize payment method selection
    const paymentMethods = document.querySelectorAll('.payment-method');
    paymentMethods.forEach(method => {
        method.addEventListener('click', function() {
            selectPaymentMethod(this.dataset.method);
        });
    });
    
    // Initialize withdraw form
    const withdrawForm = document.getElementById('withdrawForm');
    if (withdrawForm) {
        withdrawForm.addEventListener('submit', handleWithdrawal);
        
        // Update summary on amount change
        const amountInput = document.getElementById('withdrawAmount');
        if (amountInput) {
            amountInput.addEventListener('input', updateWithdrawalSummary);
        }
    }
}

function switchTab(tabName) {
    // Update URL
    const url = new URL(window.location);
    url.searchParams.set('action', tabName);
    window.history.pushState({}, '', url);
    
    // Update tab buttons
    document.querySelectorAll('.tab-btn').forEach(btn => btn.classList.remove('active'));
    document.querySelector(`[onclick="switchTab('${tabName}')"]`).classList.add('active');
    
    // Update tab content
    document.querySelectorAll('.tab-content').forEach(content => content.classList.remove('active'));
    document.getElementById(tabName + 'Tab').classList.add('active');
}

function selectPaymentMethod(method) {
    // Remove previous selection
    document.querySelectorAll('.payment-method').forEach(m => m.classList.remove('selected'));
    
    // Select current method
    document.querySelector(`[data-method="${method}"]`).classList.add('selected');
    
    // Show deposit form for selected method
    showDepositForm(method);
}

function showDepositForm(method) {
    // This would show the appropriate deposit form
    console.log('Showing deposit form for:', method);
}

function showDepositModal() {
    openModal('depositModal');
    // Load deposit form content
}

function showWithdrawModal() {
    switchTab('withdraw');
}

function handleWithdrawal(e) {
    e.preventDefault();
    
    const formData = new FormData(e.target);
    const withdrawalData = {
        method: formData.get('method'),
        amount: parseFloat(formData.get('amount')),
        address: formData.get('address')
    };
    
    // Show loading
    Crashify.ui.showLoading();
    
    // Submit withdrawal request
    Crashify.api.request('/api/wallet/withdraw', {
        method: 'POST',
        body: JSON.stringify(withdrawalData)
    })
    .then(response => {
        if (response.success) {
            Crashify.ui.toast.success('Withdrawal request submitted successfully!');
            
            // Reset form and refresh page
            e.target.reset();
            setTimeout(() => {
                window.location.reload();
            }, 2000);
        } else {
            throw new Error(response.message);
        }
    })
    .catch(error => {
        Crashify.ui.toast.error(error.message || 'Failed to submit withdrawal request');
    })
    .finally(() => {
        Crashify.ui.hideLoading();
    });
}

function updateWithdrawalSummary() {
    const amount = parseFloat(document.getElementById('withdrawAmount').value) || 0;
    const method = document.getElementById('withdrawMethod').value;
    
    if (amount > 0 && method) {
        // Calculate fee based on method
        const fee = calculateWithdrawalFee(method, amount);
        const total = amount - fee;
        
        // Update summary
        document.getElementById('summaryAmount').textContent = `$${amount.toFixed(2)}`;
        document.getElementById('summaryFee').textContent = `$${fee.toFixed(2)}`;
        document.getElementById('summaryTotal').textContent = `$${total.toFixed(2)}`;
        
        // Show summary
        document.getElementById('withdrawalSummary').style.display = 'block';
    } else {
        document.getElementById('withdrawalSummary').style.display = 'none';
    }
}

function calculateWithdrawalFee(method, amount) {
    // This would calculate the actual fee based on the method
    return 0; // Most crypto withdrawals are free
}

function setMaxAmount() {
    const maxAmount = <?php echo $currentUser['balance']; ?>;
    document.getElementById('withdrawAmount').value = maxAmount.toFixed(2);
    updateWithdrawalSummary();
}

function refreshBalance() {
    Crashify.api.request('/api/user/balance')
        .then(response => {
            if (response.success) {
                document.getElementById('mainBalance').textContent = response.balance.toFixed(2);
                document.getElementById('headerBalance').textContent = `$${response.balance.toFixed(2)}`;
            }
        })
        .catch(error => {
            console.error('Failed to refresh balance:', error);
        });
}

function filterTransactions() {
    const typeFilter = document.getElementById('typeFilter').value;
    const statusFilter = document.getElementById('statusFilter').value;
    const dateFilter = document.getElementById('dateFilter').value;
    
    const rows = document.querySelectorAll('.transaction-row');
    
    rows.forEach(row => {
        let show = true;
        
        if (typeFilter && row.dataset.type !== typeFilter) show = false;
        if (statusFilter && row.dataset.status !== statusFilter) show = false;
        if (dateFilter && !matchesDateFilter(row.dataset.date, dateFilter)) show = false;
        
        row.style.display = show ? '' : 'none';
    });
}

function matchesDateFilter(date, filter) {
    const transactionDate = new Date(date);
    const now = new Date();
    
    switch (filter) {
        case 'today':
            return transactionDate.toDateString() === now.toDateString();
        case 'week':
            const weekAgo = new Date(now.getTime() - 7 * 24 * 60 * 60 * 1000);
            return transactionDate >= weekAgo;
        case 'month':
            return transactionDate.getMonth() === now.getMonth() && 
                   transactionDate.getFullYear() === now.getFullYear();
        case 'year':
            return transactionDate.getFullYear() === now.getFullYear();
        default:
            return true;
    }
}

function viewTransaction(transactionId) {
    // Show transaction details modal
    Crashify.api.request(`/api/transactions/${transactionId}`)
        .then(response => {
            if (response.success) {
                // Show transaction details
                showTransactionDetails(response.transaction);
            }
        });
}

function cancelTransaction(transactionId) {
    if (confirm('Are you sure you want to cancel this withdrawal?')) {
        Crashify.api.request(`/api/transactions/${transactionId}/cancel`, {
            method: 'POST'
        })
        .then(response => {
            if (response.success) {
                Crashify.ui.toast.success('Transaction cancelled successfully');
                window.location.reload();
            }
        });
    }
}
</script>

<?php include '../includes/footer.php'; ?>
PHP
); ?>

<?php _merge_exec('admin/content.php', <<<'PHP'
<?php
// admin/content.php - Content Management
// مدیریت محتوا

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth.php';

// Require admin authentication
requireAuth();
requireAdmin();

// Page settings
$pageTitle = 'Content Management - Admin';
$bodyClass = 'admin-content';

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'update_page':
            $pageId = $_POST['page_id'] ?? '';
            $title = $_POST['title'] ?? '';
            $content = $_POST['content'] ?? '';
            $metaDescription = $_POST['meta_description'] ?? '';
            $status = $_POST['status'] ?? 'draft';
            
            if ($pageId && $title && $content) {
                execute(
                    "INSERT INTO cms_pages (page_id, title, content, meta_description, status, updated_at, updated_by) 
                     VALUES (?, ?, ?, ?, ?, NOW(), ?)
                     ON DUPLICATE KEY UPDATE 
                     title = VALUES(title), 
                     content = VALUES(content), 
                     meta_description = VALUES(meta_description),
                     status = VALUES(status),
                     updated_at = NOW(), 
                     updated_by = VALUES(updated_by)",
                    [$pageId, $title, $content, $metaDescription, $status, $currentUser['id']]
                );
                $successMessage = "Page updated successfully";
            }
            break;
            
        case 'add_promotion':
            $title = $_POST['promo_title'] ?? '';
            $description = $_POST['promo_description'] ?? '';
            $type = $_POST['promo_type'] ?? '';
            $value = $_POST['promo_value'] ?? '';
            $code = $_POST['promo_code'] ?? '';
            $startDate = $_POST['start_date'] ?? '';
            $endDate = $_POST['end_date'] ?? '';
            $status = $_POST['promo_status'] ?? 'active';
            
            if ($title && $description && $type && $value) {
                execute(
                    "INSERT INTO promotions (title, description, type, value, code, start_date, end_date, status, created_at, created_by) 
                     VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?)",
                    [$title, $description, $type, $value, $code, $startDate, $endDate, $status, $currentUser['id']]
                );
                $successMessage = "Promotion added successfully";
            }
            break;
            
        case 'add_news':
            $title = $_POST['news_title'] ?? '';
            $content = $_POST['news_content'] ?? '';
            $status = $_POST['news_status'] ?? 'draft';
            
            if ($title && $content) {
                execute(
                    "INSERT INTO news (title, content, status, created_at, created_by) 
                     VALUES (?, ?, ?, NOW(), ?)",
                    [$title, $content, $status, $currentUser['id']]
                );
                $successMessage = "News article added successfully";
            }
            break;
    }
}

// Get current tab
$tab = $_GET['tab'] ?? 'pages';

// Get CMS pages
$cmsPages = fetchAll(
    "SELECT cp.*, u.username as updated_by_username 
     FROM cms_pages cp 
     LEFT JOIN users u ON cp.updated_by = u.id 
     ORDER BY cp.updated_at DESC"
);

// Get promotions
$promotions = fetchAll(
    "SELECT p.*, u.username as created_by_username 
     FROM promotions p 
     LEFT JOIN users u ON p.created_by = u.id 
     ORDER BY p.created_at DESC"
);

// Get news/announcements
$news = fetchAll(
    "SELECT n.*, u.username as created_by_username 
     FROM news n 
     LEFT JOIN users u ON n.created_by = u.id 
     ORDER BY n.created_at DESC 
     LIMIT 20"
);

// Predefined pages
$predefinedPages = [
    'home' => 'Home Page',
    'about' => 'About Us',
    'terms' => 'Terms of Service',
    'privacy' => 'Privacy Policy',
    'faq' => 'FAQ',
    'contact' => 'Contact Us',
    'responsible-gambling' => 'Responsible Gambling',
    'help' => 'Help Center'
];

include '../includes/header.php';
?>

<!-- Admin Content Management -->
<div class="admin-container">
    <?php include 'sidebar.php'; ?>
    
    <main class="admin-main">
        <!-- Header -->
        <header class="admin-header">
            <div class="header-left">
                <h1 class="page-title">Content Management</h1>
                <p class="page-subtitle">Manage website content, pages, and promotions</p>
            </div>
            
            <div class="header-right">
                <button class="btn btn-outline" onclick="previewSite()">
                    <i class="fas fa-external-link-alt"></i>
                    Preview Site
                </button>
            </div>
        </header>
        
        <!-- Content Tabs -->
        <section class="tabs-section">
            <nav class="content-tabs">
                <a href="?tab=pages" class="tab-link <?php echo $tab === 'pages' ? 'active' : ''; ?>">
                    <i class="fas fa-file-alt"></i>
                    Pages
                </a>
                <a href="?tab=promotions" class="tab-link <?php echo $tab === 'promotions' ? 'active' : ''; ?>">
                    <i class="fas fa-tags"></i>
                    Promotions
                </a>
                <a href="?tab=news" class="tab-link <?php echo $tab === 'news' ? 'active' : ''; ?>">
                    <i class="fas fa-newspaper"></i>
                    News
                </a>
                <a href="?tab=banners" class="tab-link <?php echo $tab === 'banners' ? 'active' : ''; ?>">
                    <i class="fas fa-images"></i>
                    Banners
                </a>
            </nav>
        </section>
        
        <!-- Pages Tab -->
        <?php if ($tab === 'pages'): ?>
        <section class="content-section">
            <div class="section-header">
                <h3>Website Pages</h3>
                <button class="btn btn-primary" onclick="openPageEditor()">
                    <i class="fas fa-plus"></i>
                    Add New Page
                </button>
            </div>
            
            <div class="pages-grid">
                <?php foreach ($predefinedPages as $pageId => $pageName): ?>
                <?php 
                $existingPage = null;
                foreach ($cmsPages as $page) {
                    if ($page['page_id'] === $pageId) {
                        $existingPage = $page;
                        break;
                    }
                }
                ?>
                <div class="page-card">
                    <div class="page-header">
                        <div class="page-info">
                            <h4><?php echo $pageName; ?></h4>
                            <p class="page-id"><?php echo $pageId; ?></p>
                        </div>
                        <div class="page-status">
                            <?php if ($existingPage): ?>
                            <span class="status-badge status-<?php echo $existingPage['status']; ?>">
                                <?php echo ucfirst($existingPage['status']); ?>
                            </span>
                            <?php else: ?>
                            <span class="status-badge status-empty">Not Created</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="page-meta">
                        <?php if ($existingPage): ?>
                        <div class="meta-item">
                            <i class="fas fa-user"></i>
                            <?php echo htmlspecialchars($existingPage['updated_by_username'] ?? 'Unknown'); ?>
                        </div>
                        <div class="meta-item">
                            <i class="fas fa-clock"></i>
                            <?php echo date('M j, Y', strtotime($existingPage['updated_at'])); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="page-actions">
                        <button class="btn btn-primary btn-sm" onclick="editPage('<?php echo $pageId; ?>')">
                            <i class="fas fa-edit"></i>
                            <?php echo $existingPage ? 'Edit' : 'Create'; ?>
                        </button>
                        <?php if ($existingPage): ?>
                        <button class="btn btn-outline btn-sm" onclick="previewPage('<?php echo $pageId; ?>')">
                            <i class="fas fa-eye"></i>
                            Preview
                        </button>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </section>
        <?php endif; ?>
        
        <!-- Promotions Tab -->
        <?php if ($tab === 'promotions'): ?>
        <section class="content-section">
            <div class="section-header">
                <h3>Promotions & Bonuses</h3>
                <button class="btn btn-primary" onclick="openPromotionModal()">
                    <i class="fas fa-plus"></i>
                    Add Promotion
                </button>
            </div>
            
            <div class="table-container">
                <table class="admin-table">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Type</th>
                            <th>Value</th>
                            <th>Code</th>
                            <th>Period</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($promotions as $promo): ?>
                        <tr>
                            <td>
                                <div class="promo-info">
                                    <div class="promo-title"><?php echo htmlspecialchars($promo['title']); ?></div>
                                    <div class="promo-description"><?php echo htmlspecialchars(substr($promo['description'], 0, 100)); ?>...</div>
                                </div>
                            </td>
                            <td>
                                <span class="type-badge type-<?php echo $promo['type']; ?>">
                                    <?php echo ucfirst($promo['type']); ?>
                                </span>
                            </td>
                            <td>
                                <div class="promo-value">
                                    <?php if ($promo['type'] === 'percentage'): ?>
                                    <?php echo $promo['value']; ?>%
                                    <?php else: ?>
                                    $<?php echo number_format($promo['value'], 2); ?>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <?php if ($promo['code']): ?>
                                <code class="promo-code"><?php echo htmlspecialchars($promo['code']); ?></code>
                                <?php else: ?>
                                <span class="text-muted">No code</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="date-range">
                                    <?php if ($promo['start_date']): ?>
                                    <div class="start-date"><?php echo date('M j', strtotime($promo['start_date'])); ?></div>
                                    <?php endif; ?>
                                    <?php if ($promo['end_date']): ?>
                                    <div class="end-date">to <?php echo date('M j', strtotime($promo['end_date'])); ?></div>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <span class="status-badge status-<?php echo $promo['status']; ?>">
                                    <?php echo ucfirst($promo['status']); ?>
                                </span>
                            </td>
                            <td>
                                <div class="action-buttons">
                                    <button class="btn btn-outline btn-xs" onclick="editPromotion(<?php echo $promo['id']; ?>)">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-danger btn-xs" onclick="deletePromotion(<?php echo $promo['id']; ?>)">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </section>
        <?php endif; ?>
        
        <!-- News Tab -->
        <?php if ($tab === 'news'): ?>
        <section class="content-section">
            <div class="section-header">
                <h3>News & Announcements</h3>
                <button class="btn btn-primary" onclick="openNewsModal()">
                    <i class="fas fa-plus"></i>
                    Add News
                </button>
            </div>
            
            <div class="news-grid">
                <?php foreach ($news as $article): ?>
                <div class="news-card">
                    <div class="news-header">
                        <h4><?php echo htmlspecialchars($article['title']); ?></h4>
                        <span class="status-badge status-<?php echo $article['status']; ?>">
                            <?php echo ucfirst($article['status']); ?>
                        </span>
                    </div>
                    
                    <div class="news-content">
                        <?php echo htmlspecialchars(substr($article['content'], 0, 200)); ?>...
                    </div>
                    
                    <div class="news-meta">
                        <div class="meta-item">
                            <i class="fas fa-user"></i>
                            <?php echo htmlspecialchars($article['created_by_username']); ?>
                        </div>
                        <div class="meta-item">
                            <i class="fas fa-clock"></i>
                            <?php echo date('M j, Y', strtotime($article['created_at'])); ?>
                        </div>
                    </div>
                    
                    <div class="news-actions">
                        <button class="btn btn-primary btn-sm" onclick="editNews(<?php echo $article['id']; ?>)">
                            <i class="fas fa-edit"></i>
                            Edit
                        </button>
                        <button class="btn btn-outline btn-sm" onclick="previewNews(<?php echo $article['id']; ?>)">
                            <i class="fas fa-eye"></i>
                            Preview
                        </button>
                        <button class="btn btn-danger btn-sm" onclick="deleteNews(<?php echo $article['id']; ?>)">
                            <i class="fas fa-trash"></i>
                            Delete
                        </button>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </section>
        <?php endif; ?>
        
        <!-- Banners Tab -->
        <?php if ($tab === 'banners'): ?>
        <section class="content-section">
            <div class="section-header">
                <h3>Website Banners</h3>
                <button class="btn btn-primary" onclick="openBannerModal()">
                    <i class="fas fa-plus"></i>
                    Add Banner
                </button>
            </div>
            
            <div class="banners-container">
                <div class="banner-placeholder">
                    <i class="fas fa-image"></i>
                    <p>No banners configured yet</p>
                    <button class="btn btn-primary" onclick="openBannerModal()">Add First Banner</button>
                </div>
            </div>
        </section>
        <?php endif; ?>
    </main>
</div>

<!-- Page Editor Modal -->
<div class="modal-backdrop" id="pageEditorModal">
    <div class="modal page-editor-modal large">
        <div class="modal-header">
            <h3 class="modal-title">Page Editor</h3>
            <button class="modal-close" onclick="closeModal('pageEditorModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            <form id="pageEditorForm" method="POST">
                <input type="hidden" name="action" value="update_page">
                <input type="hidden" name="page_id" id="pageId">
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="pageTitle">Page Title</label>
                        <input type="text" name="title" id="pageTitle" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="pageStatus">Status</label>
                        <select name="status" id="pageStatus">
                            <option value="draft">Draft</option>
                            <option value="published">Published</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="metaDescription">Meta Description</label>
                    <textarea name="meta_description" id="metaDescription" rows="2" placeholder="SEO meta description..."></textarea>
                </div>
                
                <div class="form-group">
                    <label for="pageContent">Content</label>
                    <textarea name="content" id="pageContent" rows="15" required placeholder="Enter page content..."></textarea>
                </div>
                
                <div class="modal-actions">
                    <button type="button" class="btn btn-outline" onclick="closeModal('pageEditorModal')">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Page</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Promotion Modal -->
<div class="modal-backdrop" id="promotionModal">
    <div class="modal promotion-modal">
        <div class="modal-header">
            <h3 class="modal-title">Add Promotion</h3>
            <button class="modal-close" onclick="closeModal('promotionModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            <form id="promotionForm" method="POST">
                <input type="hidden" name="action" value="add_promotion">
                
                <div class="form-group">
                    <label for="promoTitle">Title</label>
                    <input type="text" name="promo_title" id="promoTitle" required>
                </div>
                
                <div class="form-group">
                    <label for="promoDescription">Description</label>
                    <textarea name="promo_description" id="promoDescription" rows="3" required></textarea>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="promoType">Type</label>
                        <select name="promo_type" id="promoType" required>
                            <option value="percentage">Percentage</option>
                            <option value="fixed">Fixed Amount</option>
                            <option value="free_spins">Free Spins</option>
                            <option value="cashback">Cashback</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="promoValue">Value</label>
                        <input type="number" name="promo_value" id="promoValue" step="0.01" required>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="promoCode">Promo Code (Optional)</label>
                    <input type="text" name="promo_code" id="promoCode" placeholder="e.g., WELCOME100">
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="startDate">Start Date</label>
                        <input type="date" name="start_date" id="startDate">
                    </div>
                    
                    <div class="form-group">
                        <label for="endDate">End Date</label>
                        <input type="date" name="end_date" id="endDate">
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="promoStatus">Status</label>
                    <select name="promo_status" id="promoStatus">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
                
                <div class="modal-actions">
                    <button type="button" class="btn btn-outline" onclick="closeModal('promotionModal')">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Promotion</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- News Modal -->
<div class="modal-backdrop" id="newsModal">
    <div class="modal news-modal">
        <div class="modal-header">
            <h3 class="modal-title">Add News Article</h3>
            <button class="modal-close" onclick="closeModal('newsModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            <form id="newsForm" method="POST">
                <input type="hidden" name="action" value="add_news">
                
                <div class="form-group">
                    <label for="newsTitle">Title</label>
                    <input type="text" name="news_title" id="newsTitle" required>
                </div>
                
                <div class="form-group">
                    <label for="newsContent">Content</label>
                    <textarea name="news_content" id="newsContent" rows="10" required></textarea>
                </div>
                
                <div class="form-group">
                    <label for="newsStatus">Status</label>
                    <select name="news_status" id="newsStatus">
                        <option value="draft">Draft</option>
                        <option value="published">Published</option>
                    </select>
                </div>
                
                <div class="modal-actions">
                    <button type="button" class="btn btn-outline" onclick="closeModal('newsModal')">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add News</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Content management functions
function editPage(pageId) {
    // Load existing page data if available
    fetch(`/api/admin/pages/${pageId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success && data.page) {
                document.getElementById('pageId').value = pageId;
                document.getElementById('pageTitle').value = data.page.title || '';
                document.getElementById('pageContent').value = data.page.content || '';
                document.getElementById('metaDescription').value = data.page.meta_description || '';
                document.getElementById('pageStatus').value = data.page.status || 'draft';
            } else {
                // New page
                document.getElementById('pageId').value = pageId;
                document.getElementById('pageTitle').value = '';
                document.getElementById('pageContent').value = '';
                document.getElementById('metaDescription').value = '';
                document.getElementById('pageStatus').value = 'draft';
            }
            openModal('pageEditorModal');
        })
        .catch(error => {
            console.error('Error:', error);
            // Open modal anyway for new page
            document.getElementById('pageId').value = pageId;
            openModal('pageEditorModal');
        });
}

function openPageEditor() {
    const pageId = prompt('Enter page ID (e.g., custom-page):');
    if (pageId) {
        editPage(pageId);
    }
}

function previewPage(pageId) {
    window.open(`/pages/${pageId}`, '_blank');
}

function openPromotionModal() {
    document.getElementById('promotionForm').reset();
    openModal('promotionModal');
}

function editPromotion(promoId) {
    // Load promotion data and open modal
    console.log('Edit promotion:', promoId);
}

function deletePromotion(promoId) {
    if (confirm('Are you sure you want to delete this promotion?')) {
        // Delete promotion
        console.log('Delete promotion:', promoId);
    }
}

function openNewsModal() {
    document.getElementById('newsForm').reset();
    openModal('newsModal');
}

function editNews(newsId) {
    // Load news data and open modal
    console.log('Edit news:', newsId);
}

function previewNews(newsId) {
    window.open(`/news/${newsId}`, '_blank');
}

function deleteNews(newsId) {
    if (confirm('Are you sure you want to delete this news article?')) {
        // Delete news
        console.log('Delete news:', newsId);
    }
}

function openBannerModal() {
    // Open banner management modal
    console.log('Open banner modal');
}

function previewSite() {
    window.open('/', '_blank');
}
</script>

<?php include '../includes/footer.php'; ?>

PHP
); ?>

<?php _merge_exec('admin/index.php', <<<'PHP'
<?php
// admin/index.php - Admin Dashboard
// داشبورد مدیریت

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth.php';

// Require admin authentication
requireAuth();
requireAdmin();

// Page settings
$pageTitle = 'Admin Dashboard - Crashify';
$bodyClass = 'admin-dashboard';

// Get dashboard statistics
$stats = [
    'users' => [
        'total' => fetchValue("SELECT COUNT(*) FROM users"),
        'active' => fetchValue("SELECT COUNT(*) FROM users WHERE status = 'active'"),
        'new_today' => fetchValue("SELECT COUNT(*) FROM users WHERE DATE(created_at) = CURDATE()"),
        'online' => fetchValue("SELECT COUNT(*) FROM users WHERE last_activity > DATE_SUB(NOW(), INTERVAL 15 MINUTE)")
    ],
    'transactions' => [
        'total' => fetchValue("SELECT COUNT(*) FROM transactions"),
        'today' => fetchValue("SELECT COUNT(*) FROM transactions WHERE DATE(created_at) = CURDATE()"),
        'volume_today' => fetchValue("SELECT SUM(amount) FROM transactions WHERE DATE(created_at) = CURDATE() AND status = 'completed'") ?: 0,
        'pending' => fetchValue("SELECT COUNT(*) FROM transactions WHERE status = 'pending'")
    ],
    'bets' => [
        'total' => fetchValue("SELECT COUNT(*) FROM user_bets"),
        'today' => fetchValue("SELECT COUNT(*) FROM user_bets WHERE DATE(created_at) = CURDATE()"),
        'volume_today' => fetchValue("SELECT SUM(bet_amount) FROM user_bets WHERE DATE(created_at) = CURDATE()") ?: 0,
        'active' => fetchValue("SELECT COUNT(*) FROM user_bets WHERE status = 'pending'")
    ],
    'support' => [
        'total_tickets' => fetchValue("SELECT COUNT(*) FROM support_tickets"),
        'open_tickets' => fetchValue("SELECT COUNT(*) FROM support_tickets WHERE status IN ('open', 'pending')"),
        'new_today' => fetchValue("SELECT COUNT(*) FROM support_tickets WHERE DATE(created_at) = CURDATE()"),
        'avg_response_time' => fetchValue("SELECT AVG(TIMESTAMPDIFF(HOUR, created_at, updated_at)) FROM support_tickets WHERE status = 'closed'") ?: 0
    ]
];

// Get recent activities
$recentUsers = fetchAll(
    "SELECT id, username, email, created_at, status 
     FROM users 
     ORDER BY created_at DESC 
     LIMIT 10"
);

$recentTransactions = fetchAll(
    "SELECT t.*, u.username 
     FROM transactions t
     JOIN users u ON t.user_id = u.id
     ORDER BY t.created_at DESC 
     LIMIT 10"
);

$recentTickets = fetchAll(
    "SELECT st.*, u.username 
     FROM support_tickets st
     JOIN users u ON st.user_id = u.id
     ORDER BY st.created_at DESC 
     LIMIT 10"
);

// Get system status
$systemStatus = [
    'database' => checkDatabaseConnection(),
    'cache' => checkCacheStatus(),
    'storage' => checkStorageSpace(),
    'memory' => getMemoryUsage()
];

// Get revenue chart data (last 30 days)
$revenueData = fetchAll(
    "SELECT 
        DATE(created_at) as date,
        SUM(CASE WHEN type = 'deposit' THEN amount ELSE 0 END) as deposits,
        SUM(CASE WHEN type = 'withdrawal' THEN amount ELSE 0 END) as withdrawals,
        COUNT(*) as transactions
     FROM transactions 
     WHERE created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)
     AND status = 'completed'
     GROUP BY DATE(created_at)
     ORDER BY date DESC"
);

include '../includes/header.php';
?>

<!-- Admin Dashboard -->
<div class="admin-container">
    <!-- Admin Sidebar -->
    <aside class="admin-sidebar">
        <div class="sidebar-header">
            <div class="admin-logo">
                <i class="fas fa-shield-alt"></i>
                <span>Admin Panel</span>
            </div>
        </div>
        
        <nav class="sidebar-nav">
            <ul class="nav-menu">
                <li class="nav-item active">
                    <a href="/admin/index.php" class="nav-link">
                        <i class="fas fa-tachometer-alt"></i>
                        <span>Dashboard</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="/admin/users.php" class="nav-link">
                        <i class="fas fa-users"></i>
                        <span>Users</span>
                        <span class="nav-badge"><?php echo number_format($stats['users']['total']); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="/admin/transactions.php" class="nav-link">
                        <i class="fas fa-exchange-alt"></i>
                        <span>Transactions</span>
                        <?php if ($stats['transactions']['pending'] > 0): ?>
                        <span class="nav-badge warning"><?php echo $stats['transactions']['pending']; ?></span>
                        <?php endif; ?>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="/admin/support.php" class="nav-link">
                        <i class="fas fa-headset"></i>
                        <span>Support</span>
                        <?php if ($stats['support']['open_tickets'] > 0): ?>
                        <span class="nav-badge danger"><?php echo $stats['support']['open_tickets']; ?></span>
                        <?php endif; ?>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="/admin/content.php" class="nav-link">
                        <i class="fas fa-edit"></i>
                        <span>Content</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="/admin/settings.php" class="nav-link">
                        <i class="fas fa-cog"></i>
                        <span>Settings</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="/admin/reports.php" class="nav-link">
                        <i class="fas fa-chart-line"></i>
                        <span>Reports</span>
                    </a>
                </li>
            </ul>
        </nav>
        
        <div class="sidebar-footer">
            <div class="admin-user">
                <div class="user-avatar">
                    <i class="fas fa-user-shield"></i>
                </div>
                <div class="user-info">
                    <div class="user-name"><?php echo htmlspecialchars($currentUser['username']); ?></div>
                    <div class="user-role">Administrator</div>
                </div>
            </div>
        </div>
    </aside>
    
    <!-- Main Content -->
    <main class="admin-main">
        <!-- Top Bar -->
        <header class="admin-header">
            <div class="header-left">
                <button class="sidebar-toggle" onclick="toggleSidebar()">
                    <i class="fas fa-bars"></i>
                </button>
                <h1 class="page-title">Dashboard</h1>
            </div>
            
            <div class="header-right">
                <div class="header-stats">
                    <div class="stat-item">
                        <span class="stat-label">Online Users:</span>
                        <span class="stat-value"><?php echo number_format($stats['users']['online']); ?></span>
                    </div>
                    <div class="stat-item">
                        <span class="stat-label">Server Time:</span>
                        <span class="stat-value" id="serverTime"><?php echo date('H:i:s'); ?></span>
                    </div>
                </div>
                
                <div class="header-actions">
                    <button class="btn btn-outline" onclick="refreshDashboard()">
                        <i class="fas fa-sync-alt"></i>
                        Refresh
                    </button>
                    <a href="/pages/dashboard.php" class="btn btn-primary">
                        <i class="fas fa-external-link-alt"></i>
                        View Site
                    </a>
                </div>
            </div>
        </header>
        
        <!-- Dashboard Content -->
        <div class="dashboard-content">
            <!-- Statistics Cards -->
            <section class="stats-section">
                <div class="stats-grid">
                    <!-- Users Stats -->
                    <div class="stat-card">
                        <div class="card-header">
                            <div class="card-icon users">
                                <i class="fas fa-users"></i>
                            </div>
                            <div class="card-info">
                                <h3>Users</h3>
                                <div class="card-value"><?php echo number_format($stats['users']['total']); ?></div>
                            </div>
                        </div>
                        <div class="card-details">
                            <div class="detail-item">
                                <span class="label">Active:</span>
                                <span class="value"><?php echo number_format($stats['users']['active']); ?></span>
                            </div>
                            <div class="detail-item">
                                <span class="label">New Today:</span>
                                <span class="value success">+<?php echo number_format($stats['users']['new_today']); ?></span>
                            </div>
                            <div class="detail-item">
                                <span class="label">Online:</span>
                                <span class="value"><?php echo number_format($stats['users']['online']); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Transactions Stats -->
                    <div class="stat-card">
                        <div class="card-header">
                            <div class="card-icon transactions">
                                <i class="fas fa-exchange-alt"></i>
                            </div>
                            <div class="card-info">
                                <h3>Transactions</h3>
                                <div class="card-value"><?php echo number_format($stats['transactions']['total']); ?></div>
                            </div>
                        </div>
                        <div class="card-details">
                            <div class="detail-item">
                                <span class="label">Today:</span>
                                <span class="value"><?php echo number_format($stats['transactions']['today']); ?></span>
                            </div>
                            <div class="detail-item">
                                <span class="label">Volume:</span>
                                <span class="value">$<?php echo number_format($stats['transactions']['volume_today'], 2); ?></span>
                            </div>
                            <div class="detail-item">
                                <span class="label">Pending:</span>
                                <span class="value warning"><?php echo number_format($stats['transactions']['pending']); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Bets Stats -->
                    <div class="stat-card">
                        <div class="card-header">
                            <div class="card-icon bets">
                                <i class="fas fa-dice"></i>
                            </div>
                            <div class="card-info">
                                <h3>Bets</h3>
                                <div class="card-value"><?php echo number_format($stats['bets']['total']); ?></div>
                            </div>
                        </div>
                        <div class="card-details">
                            <div class="detail-item">
                                <span class="label">Today:</span>
                                <span class="value"><?php echo number_format($stats['bets']['today']); ?></span>
                            </div>
                            <div class="detail-item">
                                <span class="label">Volume:</span>
                                <span class="value">$<?php echo number_format($stats['bets']['volume_today'], 2); ?></span>
                            </div>
                            <div class="detail-item">
                                <span class="label">Active:</span>
                                <span class="value"><?php echo number_format($stats['bets']['active']); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Support Stats -->
                    <div class="stat-card">
                        <div class="card-header">
                            <div class="card-icon support">
                                <i class="fas fa-headset"></i>
                            </div>
                            <div class="card-info">
                                <h3>Support</h3>
                                <div class="card-value"><?php echo number_format($stats['support']['total_tickets']); ?></div>
                            </div>
                        </div>
                        <div class="card-details">
                            <div class="detail-item">
                                <span class="label">Open:</span>
                                <span class="value danger"><?php echo number_format($stats['support']['open_tickets']); ?></span>
                            </div>
                            <div class="detail-item">
                                <span class="label">New Today:</span>
                                <span class="value"><?php echo number_format($stats['support']['new_today']); ?></span>
                            </div>
                            <div class="detail-item">
                                <span class="label">Avg Response:</span>
                                <span class="value"><?php echo round($stats['support']['avg_response_time'], 1); ?>h</span>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            
            <!-- Charts Section -->
            <section class="charts-section">
                <div class="charts-grid">
                    <!-- Revenue Chart -->
                    <div class="chart-card">
                        <div class="card-header">
                            <h3>Revenue Overview (Last 30 Days)</h3>
                            <div class="chart-controls">
                                <select id="chartPeriod" onchange="updateChart()">
                                    <option value="30">Last 30 Days</option>
                                    <option value="7">Last 7 Days</option>
                                    <option value="1">Today</option>
                                </select>
                            </div>
                        </div>
                        <div class="chart-container">
                            <canvas id="revenueChart" width="800" height="300"></canvas>
                        </div>
                    </div>
                    
                    <!-- System Status -->
                    <div class="status-card">
                        <div class="card-header">
                            <h3>System Status</h3>
                            <div class="status-indicator <?php echo $systemStatus['database'] ? 'online' : 'offline'; ?>">
                                <i class="fas fa-circle"></i>
                                <?php echo $systemStatus['database'] ? 'Online' : 'Offline'; ?>
                            </div>
                        </div>
                        <div class="status-list">
                            <div class="status-item">
                                <div class="status-info">
                                    <i class="fas fa-database"></i>
                                    <span>Database</span>
                                </div>
                                <div class="status-value <?php echo $systemStatus['database'] ? 'success' : 'danger'; ?>">
                                    <?php echo $systemStatus['database'] ? 'Connected' : 'Disconnected'; ?>
                                </div>
                            </div>
                            
                            <div class="status-item">
                                <div class="status-info">
                                    <i class="fas fa-memory"></i>
                                    <span>Memory Usage</span>
                                </div>
                                <div class="status-value">
                                    <?php echo $systemStatus['memory']['percentage']; ?>%
                                </div>
                            </div>
                            
                            <div class="status-item">
                                <div class="status-info">
                                    <i class="fas fa-hdd"></i>
                                    <span>Storage</span>
                                </div>
                                <div class="status-value">
                                    <?php echo $systemStatus['storage']['percentage']; ?>%
                                </div>
                            </div>
                            
                            <div class="status-item">
                                <div class="status-info">
                                    <i class="fas fa-tachometer-alt"></i>
                                    <span>Cache</span>
                                </div>
                                <div class="status-value <?php echo $systemStatus['cache'] ? 'success' : 'warning'; ?>">
                                    <?php echo $systemStatus['cache'] ? 'Active' : 'Inactive'; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            
            <!-- Recent Activities -->
            <section class="activities-section">
                <div class="activities-grid">
                    <!-- Recent Users -->
                    <div class="activity-card">
                        <div class="card-header">
                            <h3>Recent Users</h3>
                            <a href="/admin/users.php" class="view-all">View All</a>
                        </div>
                        <div class="activity-list">
                            <?php foreach ($recentUsers as $user): ?>
                            <div class="activity-item">
                                <div class="activity-avatar">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div class="activity-info">
                                    <div class="activity-title"><?php echo htmlspecialchars($user['username']); ?></div>
                                    <div class="activity-meta"><?php echo htmlspecialchars($user['email']); ?></div>
                                </div>
                                <div class="activity-time">
                                    <?php echo timeAgo($user['created_at']); ?>
                                </div>
                                <div class="activity-status">
                                    <span class="status-badge status-<?php echo $user['status']; ?>">
                                        <?php echo ucfirst($user['status']); ?>
                                    </span>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    
                    <!-- Recent Transactions -->
                    <div class="activity-card">
                        <div class="card-header">
                            <h3>Recent Transactions</h3>
                            <a href="/admin/transactions.php" class="view-all">View All</a>
                        </div>
                        <div class="activity-list">
                            <?php foreach ($recentTransactions as $transaction): ?>
                            <div class="activity-item">
                                <div class="activity-avatar">
                                    <i class="fas fa-<?php echo $transaction['type'] === 'deposit' ? 'arrow-down' : 'arrow-up'; ?>"></i>
                                </div>
                                <div class="activity-info">
                                    <div class="activity-title"><?php echo htmlspecialchars($transaction['username']); ?></div>
                                    <div class="activity-meta"><?php echo ucfirst($transaction['type']); ?> - $<?php echo number_format($transaction['amount'], 2); ?></div>
                                </div>
                                <div class="activity-time">
                                    <?php echo timeAgo($transaction['created_at']); ?>
                                </div>
                                <div class="activity-status">
                                    <span class="status-badge status-<?php echo $transaction['status']; ?>">
                                        <?php echo ucfirst($transaction['status']); ?>
                                    </span>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    
                    <!-- Recent Support Tickets -->
                    <div class="activity-card">
                        <div class="card-header">
                            <h3>Recent Support Tickets</h3>
                            <a href="/admin/support.php" class="view-all">View All</a>
                        </div>
                        <div class="activity-list">
                            <?php foreach ($recentTickets as $ticket): ?>
                            <div class="activity-item">
                                <div class="activity-avatar">
                                    <i class="fas fa-ticket-alt"></i>
                                </div>
                                <div class="activity-info">
                                    <div class="activity-title"><?php echo htmlspecialchars($ticket['subject']); ?></div>
                                    <div class="activity-meta">by <?php echo htmlspecialchars($ticket['username']); ?></div>
                                </div>
                                <div class="activity-time">
                                    <?php echo timeAgo($ticket['created_at']); ?>
                                </div>
                                <div class="activity-status">
                                    <span class="status-badge status-<?php echo $ticket['status']; ?>">
                                        <?php echo ucfirst($ticket['status']); ?>
                                    </span>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>

<script>
// Initialize dashboard
document.addEventListener('DOMContentLoaded', function() {
    initializeCharts();
    startRealTimeUpdates();
    updateServerTime();
});

// Initialize charts
function initializeCharts() {
    const ctx = document.getElementById('revenueChart').getContext('2d');
    
    const revenueData = <?php echo json_encode($revenueData); ?>;
    
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: revenueData.map(item => item.date),
            datasets: [{
                label: 'Deposits',
                data: revenueData.map(item => item.deposits),
                borderColor: '#00ff88',
                backgroundColor: 'rgba(0, 255, 136, 0.1)',
                tension: 0.4
            }, {
                label: 'Withdrawals',
                data: revenueData.map(item => item.withdrawals),
                borderColor: '#ff4757',
                backgroundColor: 'rgba(255, 71, 87, 0.1)',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '$' + value.toLocaleString();
                        }
                    }
                }
            },
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return context.dataset.label + ': $' + context.parsed.y.toLocaleString();
                        }
                    }
                }
            }
        }
    });
}

// Start real-time updates
function startRealTimeUpdates() {
    // Update every 30 seconds
    setInterval(() => {
        updateDashboardStats();
    }, 30000);
}

// Update server time
function updateServerTime() {
    setInterval(() => {
        const now = new Date();
        document.getElementById('serverTime').textContent = now.toLocaleTimeString();
    }, 1000);
}

// Update dashboard statistics
function updateDashboardStats() {
    fetch('/api/admin/stats')
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                updateStatsDisplay(data.stats);
            }
        })
        .catch(error => {
            console.error('Failed to update stats:', error);
        });
}

// Update stats display
function updateStatsDisplay(stats) {
    // Update online users count
    const onlineUsersElement = document.querySelector('.header-stats .stat-value');
    if (onlineUsersElement) {
        onlineUsersElement.textContent = stats.users.online.toLocaleString();
    }
    
    // Update other stats as needed
    // This would update various elements on the page
}

// Refresh dashboard
function refreshDashboard() {
    window.location.reload();
}

// Toggle sidebar
function toggleSidebar() {
    document.querySelector('.admin-container').classList.toggle('sidebar-collapsed');
}

// Update chart period
function updateChart() {
    const period = document.getElementById('chartPeriod').value;
    
    fetch(`/api/admin/revenue-data?period=${period}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update chart with new data
                updateChartData(data.chartData);
            }
        })
        .catch(error => {
            console.error('Failed to update chart:', error);
        });
}

function updateChartData(newData) {
    // This would update the chart with new data
    console.log('Updating chart with:', newData);
}
</script>

<?php
// Helper functions for system status
function checkDatabaseConnection() {
    try {
        global $pdo;
        $pdo->query("SELECT 1");
        return true;
    } catch (Exception $e) {
        return false;
    }
}

function checkCacheStatus() {
    // Check if cache is working (Redis, Memcached, etc.)
    return true; // Simplified for demo
}

function checkStorageSpace() {
    $bytes = disk_free_space(".");
    $total = disk_total_space(".");
    $used = $total - $bytes;
    $percentage = round(($used / $total) * 100, 1);
    
    return [
        'free' => $bytes,
        'total' => $total,
        'used' => $used,
        'percentage' => $percentage
    ];
}

function getMemoryUsage() {
    $memory = memory_get_usage(true);
    $peak = memory_get_peak_usage(true);
    $limit = ini_get('memory_limit');
    
    // Convert limit to bytes
    $limitBytes = convertToBytes($limit);
    $percentage = round(($memory / $limitBytes) * 100, 1);
    
    return [
        'current' => $memory,
        'peak' => $peak,
        'limit' => $limitBytes,
        'percentage' => $percentage
    ];
}

function convertToBytes($val) {
    $val = trim($val);
    $last = strtolower($val[strlen($val)-1]);
    $val = (int) $val;
    
    switch($last) {
        case 'g':
            $val *= 1024;
        case 'm':
            $val *= 1024;
        case 'k':
            $val *= 1024;
    }
    
    return $val;
}

function timeAgo($datetime) {
    $time = time() - strtotime($datetime);
    
    if ($time < 60) return 'just now';
    if ($time < 3600) return floor($time/60) . 'm ago';
    if ($time < 86400) return floor($time/3600) . 'h ago';
    if ($time < 2592000) return floor($time/86400) . 'd ago';
    
    return date('M j, Y', strtotime($datetime));
}

include '../includes/footer.php';
?>

PHP
); ?>

<?php _merge_exec('admin/reports.php', <<<'PHP'
<?php
// admin/reports.php - Reports and Analytics
// گزارشات و آنالیتیک

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth.php';

// Require admin authentication
requireAuth();
requireAdmin();

// Page settings
$pageTitle = 'Reports & Analytics - Admin';
$bodyClass = 'admin-reports';

// Get date range parameters
$dateFrom = $_GET['date_from'] ?? date('Y-m-d', strtotime('-30 days'));
$dateTo = $_GET['date_to'] ?? date('Y-m-d');
$period = $_GET['period'] ?? '30days';

// Get current tab
$tab = $_GET['tab'] ?? 'overview';

// Financial Reports
$financialStats = fetchRow(
    "SELECT 
        SUM(CASE WHEN type = 'deposit' AND status = 'completed' THEN amount ELSE 0 END) as total_deposits,
        SUM(CASE WHEN type = 'withdrawal' AND status = 'completed' THEN amount ELSE 0 END) as total_withdrawals,
        COUNT(CASE WHEN type = 'deposit' AND status = 'completed' THEN 1 END) as deposit_count,
        COUNT(CASE WHEN type = 'withdrawal' AND status = 'completed' THEN 1 END) as withdrawal_count,
        SUM(CASE WHEN type = 'deposit' AND status = 'completed' AND DATE(created_at) BETWEEN ? AND ? THEN amount ELSE 0 END) as period_deposits,
        SUM(CASE WHEN type = 'withdrawal' AND status = 'completed' AND DATE(created_at) BETWEEN ? AND ? THEN amount ELSE 0 END) as period_withdrawals
     FROM transactions",
    [$dateFrom, $dateTo, $dateFrom, $dateTo]
);

// Betting Reports
$bettingStats = fetchRow(
    "SELECT 
        COUNT(*) as total_bets,
        SUM(bet_amount) as total_wagered,
        SUM(CASE WHEN status = 'won' THEN payout_amount ELSE 0 END) as total_payouts,
        SUM(bet_amount) - SUM(CASE WHEN status = 'won' THEN payout_amount ELSE 0 END) as house_profit,
        AVG(bet_amount) as avg_bet_amount,
        COUNT(CASE WHEN DATE(created_at) BETWEEN ? AND ? THEN 1 END) as period_bets,
        SUM(CASE WHEN DATE(created_at) BETWEEN ? AND ? THEN bet_amount ELSE 0 END) as period_wagered
     FROM user_bets",
    [$dateFrom, $dateTo, $dateFrom, $dateTo]
);

// User Reports
$userStats = fetchRow(
    "SELECT 
        COUNT(*) as total_users,
        COUNT(CASE WHEN status = 'active' THEN 1 END) as active_users,
        COUNT(CASE WHEN DATE(created_at) BETWEEN ? AND ? THEN 1 END) as new_users_period,
        COUNT(CASE WHEN last_activity > DATE_SUB(NOW(), INTERVAL 24 HOUR) THEN 1 END) as active_24h,
        COUNT(CASE WHEN last_activity > DATE_SUB(NOW(), INTERVAL 7 DAY) THEN 1 END) as active_7d,
        COUNT(CASE WHEN last_activity > DATE_SUB(NOW(), INTERVAL 30 DAY) THEN 1 END) as active_30d
     FROM users",
    [$dateFrom, $dateTo]
);

// Daily revenue data for charts
$dailyRevenue = fetchAll(
    "SELECT 
        DATE(created_at) as date,
        SUM(CASE WHEN type = 'deposit' AND status = 'completed' THEN amount ELSE 0 END) as deposits,
        SUM(CASE WHEN type = 'withdrawal' AND status = 'completed' THEN amount ELSE 0 END) as withdrawals
     FROM transactions 
     WHERE DATE(created_at) BETWEEN ? AND ?
     GROUP BY DATE(created_at)
     ORDER BY date ASC",
    [$dateFrom, $dateTo]
);

// Daily betting data
$dailyBetting = fetchAll(
    "SELECT 
        DATE(created_at) as date,
        COUNT(*) as bet_count,
        SUM(bet_amount) as total_wagered,
        SUM(CASE WHEN status = 'won' THEN payout_amount ELSE 0 END) as total_payouts
     FROM user_bets 
     WHERE DATE(created_at) BETWEEN ? AND ?
     GROUP BY DATE(created_at)
     ORDER BY date ASC",
    [$dateFrom, $dateTo]
);

// Top players by wagered amount
$topPlayers = fetchAll(
    "SELECT 
        u.username,
        u.email,
        COUNT(ub.id) as total_bets,
        SUM(ub.bet_amount) as total_wagered,
        SUM(CASE WHEN ub.status = 'won' THEN ub.payout_amount ELSE 0 END) as total_winnings,
        (SUM(ub.bet_amount) - SUM(CASE WHEN ub.status = 'won' THEN ub.payout_amount ELSE 0 END)) as net_loss
     FROM users u
     JOIN user_bets ub ON u.id = ub.user_id
     WHERE DATE(ub.created_at) BETWEEN ? AND ?
     GROUP BY u.id
     ORDER BY total_wagered DESC
     LIMIT 10",
    [$dateFrom, $dateTo]
);

// Game performance
$gameStats = fetchAll(
    "SELECT 
        game_type,
        COUNT(*) as bet_count,
        SUM(bet_amount) as total_wagered,
        SUM(CASE WHEN status = 'won' THEN payout_amount ELSE 0 END) as total_payouts,
        (SUM(bet_amount) - SUM(CASE WHEN status = 'won' THEN payout_amount ELSE 0 END)) as profit
     FROM user_bets 
     WHERE DATE(created_at) BETWEEN ? AND ?
     GROUP BY game_type
     ORDER BY total_wagered DESC",
    [$dateFrom, $dateTo]
);

include '../includes/header.php';
?>

<!-- Admin Reports -->
<div class="admin-container">
    <?php include 'sidebar.php'; ?>
    
    <main class="admin-main">
        <!-- Header -->
        <header class="admin-header">
            <div class="header-left">
                <h1 class="page-title">Reports & Analytics</h1>
                <p class="page-subtitle">Comprehensive business intelligence and reporting</p>
            </div>
            
            <div class="header-right">
                <div class="date-range-picker">
                    <input type="date" id="dateFrom" value="<?php echo $dateFrom; ?>">
                    <span>to</span>
                    <input type="date" id="dateTo" value="<?php echo $dateTo; ?>">
                    <button class="btn btn-primary" onclick="updateDateRange()">
                        <i class="fas fa-filter"></i>
                        Apply
                    </button>
                </div>
                
                <button class="btn btn-outline" onclick="exportReport()">
                    <i class="fas fa-download"></i>
                    Export
                </button>
            </div>
        </header>
        
        <!-- Quick Period Filters -->
        <section class="period-filters">
            <div class="filter-buttons">
                <button class="filter-btn <?php echo $period === 'today' ? 'active' : ''; ?>" onclick="setPeriod('today')">Today</button>
                <button class="filter-btn <?php echo $period === '7days' ? 'active' : ''; ?>" onclick="setPeriod('7days')">7 Days</button>
                <button class="filter-btn <?php echo $period === '30days' ? 'active' : ''; ?>" onclick="setPeriod('30days')">30 Days</button>
                <button class="filter-btn <?php echo $period === '90days' ? 'active' : ''; ?>" onclick="setPeriod('90days')">90 Days</button>
                <button class="filter-btn <?php echo $period === 'custom' ? 'active' : ''; ?>" onclick="setPeriod('custom')">Custom</button>
            </div>
        </section>
        
        <!-- Report Tabs -->
        <section class="tabs-section">
            <nav class="report-tabs">
                <a href="?tab=overview&period=<?php echo $period; ?>&date_from=<?php echo $dateFrom; ?>&date_to=<?php echo $dateTo; ?>" 
                   class="tab-link <?php echo $tab === 'overview' ? 'active' : ''; ?>">
                    <i class="fas fa-chart-line"></i>
                    Overview
                </a>
                <a href="?tab=financial&period=<?php echo $period; ?>&date_from=<?php echo $dateFrom; ?>&date_to=<?php echo $dateTo; ?>" 
                   class="tab-link <?php echo $tab === 'financial' ? 'active' : ''; ?>">
                    <i class="fas fa-dollar-sign"></i>
                    Financial
                </a>
                <a href="?tab=betting&period=<?php echo $period; ?>&date_from=<?php echo $dateFrom; ?>&date_to=<?php echo $dateTo; ?>" 
                   class="tab-link <?php echo $tab === 'betting' ? 'active' : ''; ?>">
                    <i class="fas fa-dice"></i>
                    Betting
                </a>
                <a href="?tab=users&period=<?php echo $period; ?>&date_from=<?php echo $dateFrom; ?>&date_to=<?php echo $dateTo; ?>" 
                   class="tab-link <?php echo $tab === 'users' ? 'active' : ''; ?>">
                    <i class="fas fa-users"></i>
                    Users
                </a>
                <a href="?tab=games&period=<?php echo $period; ?>&date_from=<?php echo $dateFrom; ?>&date_to=<?php echo $dateTo; ?>" 
                   class="tab-link <?php echo $tab === 'games' ? 'active' : ''; ?>">
                    <i class="fas fa-gamepad"></i>
                    Games
                </a>
            </nav>
        </section>
        
        <!-- Overview Tab -->
        <?php if ($tab === 'overview'): ?>
        <section class="report-section">
            <!-- Key Metrics -->
            <div class="metrics-grid">
                <div class="metric-card revenue">
                    <div class="metric-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="metric-content">
                        <div class="metric-value">$<?php echo number_format(($financialStats['period_deposits'] ?? 0) - ($financialStats['period_withdrawals'] ?? 0), 2); ?></div>
                        <div class="metric-label">Net Revenue</div>
                        <div class="metric-change positive">
                            <i class="fas fa-arrow-up"></i>
                            +12.5%
                        </div>
                    </div>
                </div>
                
                <div class="metric-card deposits">
                    <div class="metric-icon">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <div class="metric-content">
                        <div class="metric-value">$<?php echo number_format($financialStats['period_deposits'] ?? 0, 2); ?></div>
                        <div class="metric-label">Total Deposits</div>
                        <div class="metric-change positive">
                            <i class="fas fa-arrow-up"></i>
                            +8.3%
                        </div>
                    </div>
                </div>
                
                <div class="metric-card profit">
                    <div class="metric-icon">
                        <i class="fas fa-trophy"></i>
                    </div>
                    <div class="metric-content">
                        <div class="metric-value">$<?php echo number_format($bettingStats['house_profit'] ?? 0, 2); ?></div>
                        <div class="metric-label">House Profit</div>
                        <div class="metric-change positive">
                            <i class="fas fa-arrow-up"></i>
                            +15.7%
                        </div>
                    </div>
                </div>
                
                <div class="metric-card users">
                    <div class="metric-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="metric-content">
                        <div class="metric-value"><?php echo number_format($userStats['new_users_period'] ?? 0); ?></div>
                        <div class="metric-label">New Users</div>
                        <div class="metric-change positive">
                            <i class="fas fa-arrow-up"></i>
                            +22.1%
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Charts -->
            <div class="charts-grid">
                <div class="chart-card">
                    <div class="chart-header">
                        <h3>Revenue Overview</h3>
                        <div class="chart-controls">
                            <select id="revenueChartType">
                                <option value="line">Line Chart</option>
                                <option value="bar">Bar Chart</option>
                            </select>
                        </div>
                    </div>
                    <div class="chart-container">
                        <canvas id="revenueChart" width="800" height="300"></canvas>
                    </div>
                </div>
                
                <div class="chart-card">
                    <div class="chart-header">
                        <h3>Betting Activity</h3>
                    </div>
                    <div class="chart-container">
                        <canvas id="bettingChart" width="800" height="300"></canvas>
                    </div>
                </div>
            </div>
        </section>
        <?php endif; ?>
        
        <!-- Financial Tab -->
        <?php if ($tab === 'financial'): ?>
        <section class="report-section">
            <div class="financial-summary">
                <div class="summary-cards">
                    <div class="summary-card">
                        <h4>Total Deposits</h4>
                        <div class="amount positive">$<?php echo number_format($financialStats['total_deposits'] ?? 0, 2); ?></div>
                        <div class="count"><?php echo number_format($financialStats['deposit_count'] ?? 0); ?> transactions</div>
                    </div>
                    
                    <div class="summary-card">
                        <h4>Total Withdrawals</h4>
                        <div class="amount negative">$<?php echo number_format($financialStats['total_withdrawals'] ?? 0, 2); ?></div>
                        <div class="count"><?php echo number_format($financialStats['withdrawal_count'] ?? 0); ?> transactions</div>
                    </div>
                    
                    <div class="summary-card">
                        <h4>Net Balance</h4>
                        <div class="amount <?php echo ($financialStats['total_deposits'] - $financialStats['total_withdrawals']) >= 0 ? 'positive' : 'negative'; ?>">
                            $<?php echo number_format(($financialStats['total_deposits'] ?? 0) - ($financialStats['total_withdrawals'] ?? 0), 2); ?>
                        </div>
                        <div class="count">All time</div>
                    </div>
                </div>
            </div>
            
            <div class="financial-chart">
                <div class="chart-header">
                    <h3>Daily Financial Activity</h3>
                </div>
                <div class="chart-container">
                    <canvas id="financialChart" width="1000" height="400"></canvas>
                </div>
            </div>
        </section>
        <?php endif; ?>
        
        <!-- Betting Tab -->
        <?php if ($tab === 'betting'): ?>
        <section class="report-section">
            <div class="betting-summary">
                <div class="summary-cards">
                    <div class="summary-card">
                        <h4>Total Bets</h4>
                        <div class="amount"><?php echo number_format($bettingStats['total_bets'] ?? 0); ?></div>
                        <div class="count">All time</div>
                    </div>
                    
                    <div class="summary-card">
                        <h4>Total Wagered</h4>
                        <div class="amount">$<?php echo number_format($bettingStats['total_wagered'] ?? 0, 2); ?></div>
                        <div class="count">Avg: $<?php echo number_format($bettingStats['avg_bet_amount'] ?? 0, 2); ?></div>
                    </div>
                    
                    <div class="summary-card">
                        <h4>Total Payouts</h4>
                        <div class="amount negative">$<?php echo number_format($bettingStats['total_payouts'] ?? 0, 2); ?></div>
                        <div class="count">To players</div>
                    </div>
                    
                    <div class="summary-card">
                        <h4>House Profit</h4>
                        <div class="amount positive">$<?php echo number_format($bettingStats['house_profit'] ?? 0, 2); ?></div>
                        <div class="count">
                            <?php 
                            $profitMargin = $bettingStats['total_wagered'] > 0 ? 
                                ($bettingStats['house_profit'] / $bettingStats['total_wagered']) * 100 : 0;
                            echo number_format($profitMargin, 1); ?>% margin
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="betting-chart">
                <div class="chart-header">
                    <h3>Daily Betting Activity</h3>
                </div>
                <div class="chart-container">
                    <canvas id="bettingActivityChart" width="1000" height="400"></canvas>
                </div>
            </div>
        </section>
        <?php endif; ?>
        
        <!-- Users Tab -->
        <?php if ($tab === 'users'): ?>
        <section class="report-section">
            <div class="user-summary">
                <div class="summary-cards">
                    <div class="summary-card">
                        <h4>Total Users</h4>
                        <div class="amount"><?php echo number_format($userStats['total_users'] ?? 0); ?></div>
                        <div class="count">Registered</div>
                    </div>
                    
                    <div class="summary-card">
                        <h4>Active Users</h4>
                        <div class="amount"><?php echo number_format($userStats['active_users'] ?? 0); ?></div>
                        <div class="count">Verified accounts</div>
                    </div>
                    
                    <div class="summary-card">
                        <h4>Daily Active</h4>
                        <div class="amount"><?php echo number_format($userStats['active_24h'] ?? 0); ?></div>
                        <div class="count">Last 24 hours</div>
                    </div>
                    
                    <div class="summary-card">
                        <h4>Monthly Active</h4>
                        <div class="amount"><?php echo number_format($userStats['active_30d'] ?? 0); ?></div>
                        <div class="count">Last 30 days</div>
                    </div>
                </div>
            </div>
            
            <!-- Top Players Table -->
            <div class="top-players">
                <div class="table-header">
                    <h3>Top Players (by Wagered Amount)</h3>
                </div>
                <div class="table-container">
                    <table class="report-table">
                        <thead>
                            <tr>
                                <th>Rank</th>
                                <th>Player</th>
                                <th>Total Bets</th>
                                <th>Total Wagered</th>
                                <th>Total Winnings</th>
                                <th>Net P&L</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($topPlayers as $index => $player): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td>
                                    <div class="player-info">
                                        <div class="username"><?php echo htmlspecialchars($player['username']); ?></div>
                                        <div class="email"><?php echo htmlspecialchars($player['email']); ?></div>
                                    </div>
                                </td>
                                <td><?php echo number_format($player['total_bets']); ?></td>
                                <td>$<?php echo number_format($player['total_wagered'], 2); ?></td>
                                <td>$<?php echo number_format($player['total_winnings'], 2); ?></td>
                                <td class="<?php echo $player['net_loss'] >= 0 ? 'positive' : 'negative'; ?>">
                                    $<?php echo number_format($player['net_loss'], 2); ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <?php endif; ?>
        
        <!-- Games Tab -->
        <?php if ($tab === 'games'): ?>
        <section class="report-section">
            <div class="games-performance">
                <div class="table-header">
                    <h3>Game Performance</h3>
                </div>
                <div class="table-container">
                    <table class="report-table">
                        <thead>
                            <tr>
                                <th>Game Type</th>
                                <th>Total Bets</th>
                                <th>Total Wagered</th>
                                <th>Total Payouts</th>
                                <th>House Profit</th>
                                <th>Profit Margin</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($gameStats as $game): ?>
                            <tr>
                                <td>
                                    <div class="game-type">
                                        <i class="fas fa-dice"></i>
                                        <?php echo ucfirst($game['game_type']); ?>
                                    </div>
                                </td>
                                <td><?php echo number_format($game['bet_count']); ?></td>
                                <td>$<?php echo number_format($game['total_wagered'], 2); ?></td>
                                <td>$<?php echo number_format($game['total_payouts'], 2); ?></td>
                                <td class="positive">$<?php echo number_format($game['profit'], 2); ?></td>
                                <td>
                                    <?php 
                                    $margin = $game['total_wagered'] > 0 ? 
                                        ($game['profit'] / $game['total_wagered']) * 100 : 0;
                                    echo number_format($margin, 1); ?>%
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
        <?php endif; ?>
    </main>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Initialize charts
document.addEventListener('DOMContentLoaded', function() {
    initializeCharts();
});

function initializeCharts() {
    // Revenue Chart
    if (document.getElementById('revenueChart')) {
        const revenueData = <?php echo json_encode($dailyRevenue); ?>;
        
        const ctx = document.getElementById('revenueChart').getContext('2d');
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: revenueData.map(item => item.date),
                datasets: [{
                    label: 'Deposits',
                    data: revenueData.map(item => parseFloat(item.deposits)),
                    borderColor: '#00ff88',
                    backgroundColor: 'rgba(0, 255, 136, 0.1)',
                    tension: 0.4
                }, {
                    label: 'Withdrawals',
                    data: revenueData.map(item => parseFloat(item.withdrawals)),
                    borderColor: '#ff4757',
                    backgroundColor: 'rgba(255, 71, 87, 0.1)',
                    tension: 0.4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return '$' + value.toLocaleString();
                            }
                        }
                    }
                }
            }
        });
    }
    
    // Betting Chart
    if (document.getElementById('bettingChart')) {
        const bettingData = <?php echo json_encode($dailyBetting); ?>;
        
        const ctx = document.getElementById('bettingChart').getContext('2d');
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: bettingData.map(item => item.date),
                datasets: [{
                    label: 'Bets Count',
                    data: bettingData.map(item => parseInt(item.bet_count)),
                    backgroundColor: 'rgba(54, 162, 235, 0.8)',
                    yAxisID: 'y'
                }, {
                    label: 'Total Wagered',
                    data: bettingData.map(item => parseFloat(item.total_wagered)),
                    backgroundColor: 'rgba(255, 206, 86, 0.8)',
                    yAxisID: 'y1'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        type: 'linear',
                        display: true,
                        position: 'left',
                    },
                    y1: {
                        type: 'linear',
                        display: true,
                        position: 'right',
                        grid: {
                            drawOnChartArea: false,
                        },
                        ticks: {
                            callback: function(value) {
                                return '$' + value.toLocaleString();
                            }
                        }
                    }
                }
            }
        });
    }
}

function setPeriod(period) {
    const today = new Date();
    let dateFrom, dateTo;
    
    switch(period) {
        case 'today':
            dateFrom = dateTo = today.toISOString().split('T')[0];
            break;
        case '7days':
            dateFrom = new Date(today.getTime() - 7 * 24 * 60 * 60 * 1000).toISOString().split('T')[0];
            dateTo = today.toISOString().split('T')[0];
            break;
        case '30days':
            dateFrom = new Date(today.getTime() - 30 * 24 * 60 * 60 * 1000).toISOString().split('T')[0];
            dateTo = today.toISOString().split('T')[0];
            break;
        case '90days':
            dateFrom = new Date(today.getTime() - 90 * 24 * 60 * 60 * 1000).toISOString().split('T')[0];
            dateTo = today.toISOString().split('T')[0];
            break;
        case 'custom':
            return; // Don't change dates for custom
    }
    
    if (period !== 'custom') {
        document.getElementById('dateFrom').value = dateFrom;
        document.getElementById('dateTo').value = dateTo;
        updateDateRange();
    }
}

function updateDateRange() {
    const dateFrom = document.getElementById('dateFrom').value;
    const dateTo = document.getElementById('dateTo').value;
    const currentTab = '<?php echo $tab; ?>';
    
    window.location.href = `?tab=${currentTab}&period=custom&date_from=${dateFrom}&date_to=${dateTo}`;
}

function exportReport() {
    const dateFrom = document.getElementById('dateFrom').value;
    const dateTo = document.getElementById('dateTo').value;
    const currentTab = '<?php echo $tab; ?>';
    
    window.open(`/api/admin/reports/export?tab=${currentTab}&date_from=${dateFrom}&date_to=${dateTo}`, '_blank');
}
</script>

<?php include '../includes/footer.php'; ?>
PHP
); ?>

<?php _merge_exec('admin/settings.php', <<<'PHP'
<?php
// admin/settings.php - Site Settings
// تنظیمات سایت

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth.php';

// Require admin authentication
requireAuth();
requireAdmin();

// Page settings
$pageTitle = 'Site Settings - Admin';
$bodyClass = 'admin-settings';

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'update_general':
            $settings = [
                'site_name' => $_POST['site_name'] ?? '',
                'site_description' => $_POST['site_description'] ?? '',
                'site_keywords' => $_POST['site_keywords'] ?? '',
                'contact_email' => $_POST['contact_email'] ?? '',
                'support_email' => $_POST['support_email'] ?? '',
                'default_language' => $_POST['default_language'] ?? 'en',
                'default_currency' => $_POST['default_currency'] ?? 'USD',
                'timezone' => $_POST['timezone'] ?? 'UTC',
                'maintenance_mode' => isset($_POST['maintenance_mode']) ? '1' : '0'
            ];
            
            foreach ($settings as $key => $value) {
                execute(
                    "INSERT INTO site_settings (setting_key, setting_value, updated_at, updated_by) 
                     VALUES (?, ?, NOW(), ?)
                     ON DUPLICATE KEY UPDATE 
                     setting_value = VALUES(setting_value), 
                     updated_at = NOW(), 
                     updated_by = VALUES(updated_by)",
                    [$key, $value, $currentUser['id']]
                );
            }
            $successMessage = "General settings updated successfully";
            break;
            
        case 'update_betting':
            $settings = [
                'min_bet_amount' => $_POST['min_bet_amount'] ?? '1.00',
                'max_bet_amount' => $_POST['max_bet_amount'] ?? '10000.00',
                'max_win_amount' => $_POST['max_win_amount'] ?? '100000.00',
                'house_edge' => $_POST['house_edge'] ?? '2.00',
                'auto_cashout_enabled' => isset($_POST['auto_cashout_enabled']) ? '1' : '0',
                'max_auto_cashout' => $_POST['max_auto_cashout'] ?? '1000.00',
                'betting_enabled' => isset($_POST['betting_enabled']) ? '1' : '0'
            ];
            
            foreach ($settings as $key => $value) {
                execute(
                    "INSERT INTO site_settings (setting_key, setting_value, updated_at, updated_by) 
                     VALUES (?, ?, NOW(), ?)
                     ON DUPLICATE KEY UPDATE 
                     setting_value = VALUES(setting_value), 
                     updated_at = NOW(), 
                     updated_by = VALUES(updated_by)",
                    [$key, $value, $currentUser['id']]
                );
            }
            $successMessage = "Betting settings updated successfully";
            break;
            
        case 'update_payments':
            $settings = [
                'min_deposit' => $_POST['min_deposit'] ?? '10.00',
                'max_deposit' => $_POST['max_deposit'] ?? '10000.00',
                'min_withdrawal' => $_POST['min_withdrawal'] ?? '20.00',
                'max_withdrawal' => $_POST['max_withdrawal'] ?? '5000.00',
                'withdrawal_fee' => $_POST['withdrawal_fee'] ?? '0.00',
                'withdrawal_processing_time' => $_POST['withdrawal_processing_time'] ?? '24',
                'auto_withdrawal_limit' => $_POST['auto_withdrawal_limit'] ?? '1000.00',
                'kyc_required' => isset($_POST['kyc_required']) ? '1' : '0',
                'deposits_enabled' => isset($_POST['deposits_enabled']) ? '1' : '0',
                'withdrawals_enabled' => isset($_POST['withdrawals_enabled']) ? '1' : '0'
            ];
            
            foreach ($settings as $key => $value) {
                execute(
                    "INSERT INTO site_settings (setting_key, setting_value, updated_at, updated_by) 
                     VALUES (?, ?, NOW(), ?)
                     ON DUPLICATE KEY UPDATE 
                     setting_value = VALUES(setting_value), 
                     updated_at = NOW(), 
                     updated_by = VALUES(updated_by)",
                    [$key, $value, $currentUser['id']]
                );
            }
            $successMessage = "Payment settings updated successfully";
            break;
            
        case 'update_security':
            $settings = [
                'registration_enabled' => isset($_POST['registration_enabled']) ? '1' : '0',
                'email_verification' => isset($_POST['email_verification']) ? '1' : '0',
                'two_factor_auth' => isset($_POST['two_factor_auth']) ? '1' : '0',
                'session_timeout' => $_POST['session_timeout'] ?? '3600',
                'max_login_attempts' => $_POST['max_login_attempts'] ?? '5',
                'lockout_duration' => $_POST['lockout_duration'] ?? '900',
                'password_min_length' => $_POST['password_min_length'] ?? '8',
                'require_strong_password' => isset($_POST['require_strong_password']) ? '1' : '0'
            ];
            
            foreach ($settings as $key => $value) {
                execute(
                    "INSERT INTO site_settings (setting_key, setting_value, updated_at, updated_by) 
                     VALUES (?, ?, NOW(), ?)
                     ON DUPLICATE KEY UPDATE 
                     setting_value = VALUES(setting_value), 
                     updated_at = NOW(), 
                     updated_by = VALUES(updated_by)",
                    [$key, $value, $currentUser['id']]
                );
            }
            $successMessage = "Security settings updated successfully";
            break;
    }
}

// Get current settings
$currentSettings = [];
$settingsResult = fetchAll("SELECT setting_key, setting_value FROM site_settings");
foreach ($settingsResult as $setting) {
    $currentSettings[$setting['setting_key']] = $setting['setting_value'];
}

// Default values
$defaults = [
    'site_name' => 'Crashify',
    'site_description' => 'The Ultimate Crash Betting Experience',
    'site_keywords' => 'crash game, betting, casino, gambling',
    'contact_email' => 'contact@crashify.com',
    'support_email' => 'support@crashify.com',
    'default_language' => 'en',
    'default_currency' => 'USD',
    'timezone' => 'UTC',
    'maintenance_mode' => '0',
    'min_bet_amount' => '1.00',
    'max_bet_amount' => '10000.00',
    'max_win_amount' => '100000.00',
    'house_edge' => '2.00',
    'auto_cashout_enabled' => '1',
    'max_auto_cashout' => '1000.00',
    'betting_enabled' => '1',
    'min_deposit' => '10.00',
    'max_deposit' => '10000.00',
    'min_withdrawal' => '20.00',
    'max_withdrawal' => '5000.00',
    'withdrawal_fee' => '0.00',
    'withdrawal_processing_time' => '24',
    'auto_withdrawal_limit' => '1000.00',
    'kyc_required' => '0',
    'deposits_enabled' => '1',
    'withdrawals_enabled' => '1',
    'registration_enabled' => '1',
    'email_verification' => '1',
    'two_factor_auth' => '0',
    'session_timeout' => '3600',
    'max_login_attempts' => '5',
    'lockout_duration' => '900',
    'password_min_length' => '8',
    'require_strong_password' => '1'
];

// Merge with defaults
foreach ($defaults as $key => $value) {
    if (!isset($currentSettings[$key])) {
        $currentSettings[$key] = $value;
    }
}

// Get current tab
$tab = $_GET['tab'] ?? 'general';

include '../includes/header.php';
?>

<!-- Admin Settings -->
<div class="admin-container">
    <?php include 'sidebar.php'; ?>
    
    <main class="admin-main">
        <!-- Header -->
        <header class="admin-header">
            <div class="header-left">
                <h1 class="page-title">Site Settings</h1>
                <p class="page-subtitle">Configure website settings and preferences</p>
            </div>
            
            <div class="header-right">
                <button class="btn btn-outline" onclick="resetToDefaults()">
                    <i class="fas fa-undo"></i>
                    Reset to Defaults
                </button>
                <button class="btn btn-success" onclick="saveAllSettings()">
                    <i class="fas fa-save"></i>
                    Save All
                </button>
            </div>
        </header>
        
        <?php if (isset($successMessage)): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <?php echo $successMessage; ?>
        </div>
        <?php endif; ?>
        
        <!-- Settings Tabs -->
        <section class="tabs-section">
            <nav class="settings-tabs">
                <a href="?tab=general" class="tab-link <?php echo $tab === 'general' ? 'active' : ''; ?>">
                    <i class="fas fa-cog"></i>
                    General
                </a>
                <a href="?tab=betting" class="tab-link <?php echo $tab === 'betting' ? 'active' : ''; ?>">
                    <i class="fas fa-dice"></i>
                    Betting
                </a>
                <a href="?tab=payments" class="tab-link <?php echo $tab === 'payments' ? 'active' : ''; ?>">
                    <i class="fas fa-credit-card"></i>
                    Payments
                </a>
                <a href="?tab=security" class="tab-link <?php echo $tab === 'security' ? 'active' : ''; ?>">
                    <i class="fas fa-shield-alt"></i>
                    Security
                </a>
                <a href="?tab=notifications" class="tab-link <?php echo $tab === 'notifications' ? 'active' : ''; ?>">
                    <i class="fas fa-bell"></i>
                    Notifications
                </a>
            </nav>
        </section>
        
        <!-- General Settings -->
        <?php if ($tab === 'general'): ?>
        <section class="settings-section">
            <form method="POST" class="settings-form">
                <input type="hidden" name="action" value="update_general">
                
                <div class="settings-card">
                    <div class="card-header">
                        <h3>Site Information</h3>
                        <p>Basic website information and branding</p>
                    </div>
                    
                    <div class="card-body">
                        <div class="form-row">
                            <div class="form-group">
                                <label for="siteName">Site Name</label>
                                <input type="text" name="site_name" id="siteName" 
                                       value="<?php echo htmlspecialchars($currentSettings['site_name']); ?>" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="defaultLanguage">Default Language</label>
                                <select name="default_language" id="defaultLanguage">
                                    <option value="en" <?php echo $currentSettings['default_language'] === 'en' ? 'selected' : ''; ?>>English</option>
                                    <option value="fa" <?php echo $currentSettings['default_language'] === 'fa' ? 'selected' : ''; ?>>Persian</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="siteDescription">Site Description</label>
                            <textarea name="site_description" id="siteDescription" rows="3"><?php echo htmlspecialchars($currentSettings['site_description']); ?></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="siteKeywords">SEO Keywords</label>
                            <input type="text" name="site_keywords" id="siteKeywords" 
                                   value="<?php echo htmlspecialchars($currentSettings['site_keywords']); ?>"
                                   placeholder="Separate keywords with commas">
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="contactEmail">Contact Email</label>
                                <input type="email" name="contact_email" id="contactEmail" 
                                       value="<?php echo htmlspecialchars($currentSettings['contact_email']); ?>" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="supportEmail">Support Email</label>
                                <input type="email" name="support_email" id="supportEmail" 
                                       value="<?php echo htmlspecialchars($currentSettings['support_email']); ?>" required>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="defaultCurrency">Default Currency</label>
                                <select name="default_currency" id="defaultCurrency">
                                    <option value="USD" <?php echo $currentSettings['default_currency'] === 'USD' ? 'selected' : ''; ?>>USD - US Dollar</option>
                                    <option value="EUR" <?php echo $currentSettings['default_currency'] === 'EUR' ? 'selected' : ''; ?>>EUR - Euro</option>
                                    <option value="GBP" <?php echo $currentSettings['default_currency'] === 'GBP' ? 'selected' : ''; ?>>GBP - British Pound</option>
                                    <option value="BTC" <?php echo $currentSettings['default_currency'] === 'BTC' ? 'selected' : ''; ?>>BTC - Bitcoin</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="timezone">Timezone</label>
                                <select name="timezone" id="timezone">
                                    <option value="UTC" <?php echo $currentSettings['timezone'] === 'UTC' ? 'selected' : ''; ?>>UTC</option>
                                    <option value="America/New_York" <?php echo $currentSettings['timezone'] === 'America/New_York' ? 'selected' : ''; ?>>Eastern Time</option>
                                    <option value="Europe/London" <?php echo $currentSettings['timezone'] === 'Europe/London' ? 'selected' : ''; ?>>London</option>
                                    <option value="Asia/Tehran" <?php echo $currentSettings['timezone'] === 'Asia/Tehran' ? 'selected' : ''; ?>>Tehran</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="checkbox-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="maintenance_mode" 
                                           <?php echo $currentSettings['maintenance_mode'] === '1' ? 'checked' : ''; ?>>
                                    <span class="checkbox-custom"></span>
                                    Enable Maintenance Mode
                                </label>
                                <p class="help-text">When enabled, only administrators can access the site</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        Save General Settings
                    </button>
                </div>
            </form>
        </section>
        <?php endif; ?>
        
        <!-- Betting Settings -->
        <?php if ($tab === 'betting'): ?>
        <section class="settings-section">
            <form method="POST" class="settings-form">
                <input type="hidden" name="action" value="update_betting">
                
                <div class="settings-card">
                    <div class="card-header">
                        <h3>Betting Configuration</h3>
                        <p>Configure betting limits and game settings</p>
                    </div>
                    
                    <div class="card-body">
                        <div class="form-row">
                            <div class="form-group">
                                <label for="minBetAmount">Minimum Bet Amount</label>
                                <input type="number" name="min_bet_amount" id="minBetAmount" 
                                       value="<?php echo $currentSettings['min_bet_amount']; ?>" 
                                       step="0.01" min="0.01" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="maxBetAmount">Maximum Bet Amount</label>
                                <input type="number" name="max_bet_amount" id="maxBetAmount" 
                                       value="<?php echo $currentSettings['max_bet_amount']; ?>" 
                                       step="0.01" min="1" required>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="maxWinAmount">Maximum Win Amount</label>
                                <input type="number" name="max_win_amount" id="maxWinAmount" 
                                       value="<?php echo $currentSettings['max_win_amount']; ?>" 
                                       step="0.01" min="1" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="houseEdge">House Edge (%)</label>
                                <input type="number" name="house_edge" id="houseEdge" 
                                       value="<?php echo $currentSettings['house_edge']; ?>" 
                                       step="0.01" min="0" max="10" required>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="maxAutoCashout">Maximum Auto Cashout</label>
                            <input type="number" name="max_auto_cashout" id="maxAutoCashout" 
                                   value="<?php echo $currentSettings['max_auto_cashout']; ?>" 
                                   step="0.01" min="1" required>
                        </div>
                        
                        <div class="checkbox-group">
                            <label class="checkbox-label">
                                <input type="checkbox" name="auto_cashout_enabled" 
                                       <?php echo $currentSettings['auto_cashout_enabled'] === '1' ? 'checked' : ''; ?>>
                                <span class="checkbox-custom"></span>
                                Enable Auto Cashout Feature
                            </label>
                        </div>
                        
                        <div class="checkbox-group">
                            <label class="checkbox-label">
                                <input type="checkbox" name="betting_enabled" 
                                       <?php echo $currentSettings['betting_enabled'] === '1' ? 'checked' : ''; ?>>
                                <span class="checkbox-custom"></span>
                                Enable Betting (Master Switch)
                            </label>
                            <p class="help-text">When disabled, all betting functionality is turned off</p>
                        </div>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        Save Betting Settings
                    </button>
                </div>
            </form>
        </section>
        <?php endif; ?>
        
        <!-- Payment Settings -->
        <?php if ($tab === 'payments'): ?>
        <section class="settings-section">
            <form method="POST" class="settings-form">
                <input type="hidden" name="action" value="update_payments">
                
                <div class="settings-card">
                    <div class="card-header">
                        <h3>Payment Configuration</h3>
                        <p>Configure deposit and withdrawal settings</p>
                    </div>
                    
                    <div class="card-body">
                        <div class="form-section">
                            <h4>Deposit Settings</h4>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="minDeposit">Minimum Deposit</label>
                                    <input type="number" name="min_deposit" id="minDeposit" 
                                           value="<?php echo $currentSettings['min_deposit']; ?>" 
                                           step="0.01" min="1" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="maxDeposit">Maximum Deposit</label>
                                    <input type="number" name="max_deposit" id="maxDeposit" 
                                           value="<?php echo $currentSettings['max_deposit']; ?>" 
                                           step="0.01" min="1" required>
                                </div>
                            </div>
                            
                            <div class="checkbox-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="deposits_enabled" 
                                           <?php echo $currentSettings['deposits_enabled'] === '1' ? 'checked' : ''; ?>>
                                    <span class="checkbox-custom"></span>
                                    Enable Deposits
                                </label>
                            </div>
                        </div>
                        
                        <div class="form-section">
                            <h4>Withdrawal Settings</h4>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="minWithdrawal">Minimum Withdrawal</label>
                                    <input type="number" name="min_withdrawal" id="minWithdrawal" 
                                           value="<?php echo $currentSettings['min_withdrawal']; ?>" 
                                           step="0.01" min="1" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="maxWithdrawal">Maximum Withdrawal</label>
                                    <input type="number" name="max_withdrawal" id="maxWithdrawal" 
                                           value="<?php echo $currentSettings['max_withdrawal']; ?>" 
                                           step="0.01" min="1" required>
                                </div>
                            </div>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="withdrawalFee">Withdrawal Fee</label>
                                    <input type="number" name="withdrawal_fee" id="withdrawalFee" 
                                           value="<?php echo $currentSettings['withdrawal_fee']; ?>" 
                                           step="0.01" min="0">
                                </div>
                                
                                <div class="form-group">
                                    <label for="withdrawalProcessingTime">Processing Time (hours)</label>
                                    <input type="number" name="withdrawal_processing_time" id="withdrawalProcessingTime" 
                                           value="<?php echo $currentSettings['withdrawal_processing_time']; ?>" 
                                           min="1" required>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="autoWithdrawalLimit">Auto Withdrawal Limit</label>
                                <input type="number" name="auto_withdrawal_limit" id="autoWithdrawalLimit" 
                                       value="<?php echo $currentSettings['auto_withdrawal_limit']; ?>" 
                                       step="0.01" min="0">
                                <p class="help-text">Withdrawals above this amount require manual approval</p>
                            </div>
                            
                            <div class="checkbox-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="withdrawals_enabled" 
                                           <?php echo $currentSettings['withdrawals_enabled'] === '1' ? 'checked' : ''; ?>>
                                    <span class="checkbox-custom"></span>
                                    Enable Withdrawals
                                </label>
                            </div>
                            
                            <div class="checkbox-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="kyc_required" 
                                           <?php echo $currentSettings['kyc_required'] === '1' ? 'checked' : ''; ?>>
                                    <span class="checkbox-custom"></span>
                                    Require KYC for Withdrawals
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        Save Payment Settings
                    </button>
                </div>
            </form>
        </section>
        <?php endif; ?>
        
        <!-- Security Settings -->
        <?php if ($tab === 'security'): ?>
        <section class="settings-section">
            <form method="POST" class="settings-form">
                <input type="hidden" name="action" value="update_security">
                
                <div class="settings-card">
                    <div class="card-header">
                        <h3>Security Configuration</h3>
                        <p>Configure authentication and security settings</p>
                    </div>
                    
                    <div class="card-body">
                        <div class="form-section">
                            <h4>Registration & Authentication</h4>
                            
                            <div class="checkbox-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="registration_enabled" 
                                           <?php echo $currentSettings['registration_enabled'] === '1' ? 'checked' : ''; ?>>
                                    <span class="checkbox-custom"></span>
                                    Enable User Registration
                                </label>
                            </div>
                            
                            <div class="checkbox-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="email_verification" 
                                           <?php echo $currentSettings['email_verification'] === '1' ? 'checked' : ''; ?>>
                                    <span class="checkbox-custom"></span>
                                    Require Email Verification
                                </label>
                            </div>
                            
                            <div class="checkbox-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="two_factor_auth" 
                                           <?php echo $currentSettings['two_factor_auth'] === '1' ? 'checked' : ''; ?>>
                                    <span class="checkbox-custom"></span>
                                    Enable Two-Factor Authentication
                                </label>
                            </div>
                        </div>
                        
                        <div class="form-section">
                            <h4>Session & Login Security</h4>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="sessionTimeout">Session Timeout (seconds)</label>
                                    <input type="number" name="session_timeout" id="sessionTimeout" 
                                           value="<?php echo $currentSettings['session_timeout']; ?>" 
                                           min="300" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="maxLoginAttempts">Max Login Attempts</label>
                                    <input type="number" name="max_login_attempts" id="maxLoginAttempts" 
                                           value="<?php echo $currentSettings['max_login_attempts']; ?>" 
                                           min="3" max="10" required>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="lockoutDuration">Lockout Duration (seconds)</label>
                                <input type="number" name="lockout_duration" id="lockoutDuration" 
                                       value="<?php echo $currentSettings['lockout_duration']; ?>" 
                                       min="300" required>
                            </div>
                        </div>
                        
                        <div class="form-section">
                            <h4>Password Requirements</h4>
                            
                            <div class="form-group">
                                <label for="passwordMinLength">Minimum Password Length</label>
                                <input type="number" name="password_min_length" id="passwordMinLength" 
                                       value="<?php echo $currentSettings['password_min_length']; ?>" 
                                       min="6" max="20" required>
                            </div>
                            
                            <div class="checkbox-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="require_strong_password" 
                                           <?php echo $currentSettings['require_strong_password'] === '1' ? 'checked' : ''; ?>>
                                    <span class="checkbox-custom"></span>
                                    Require Strong Passwords
                                </label>
                                <p class="help-text">Requires uppercase, lowercase, numbers, and special characters</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        Save Security Settings
                    </button>
                </div>
            </form>
        </section>
        <?php endif; ?>
        
        <!-- Notifications Settings -->
        <?php if ($tab === 'notifications'): ?>
        <section class="settings-section">
            <div class="settings-card">
                <div class="card-header">
                    <h3>Notification Settings</h3>
                    <p>Configure email and system notifications</p>
                </div>
                
                <div class="card-body">
                    <div class="notification-placeholder">
                        <i class="fas fa-bell"></i>
                        <h4>Notification Settings</h4>
                        <p>Email templates and notification preferences will be configured here.</p>
                        <button class="btn btn-primary">Configure Notifications</button>
                    </div>
                </div>
            </div>
        </section>
        <?php endif; ?>
    </main>
</div>

<script>
function resetToDefaults() {
    if (confirm('Are you sure you want to reset all settings to default values? This action cannot be undone.')) {
        // Reset to defaults
        window.location.href = '/admin/settings.php?action=reset_defaults';
    }
}

function saveAllSettings() {
    // Save all forms
    const forms = document.querySelectorAll('.settings-form');
    let savedCount = 0;
    
    forms.forEach(form => {
        const formData = new FormData(form);
        
        fetch('/admin/settings.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(() => {
            savedCount++;
            if (savedCount === forms.length) {
                alert('All settings saved successfully!');
                window.location.reload();
            }
        })
        .catch(error => {
            console.error('Error saving settings:', error);
        });
    });
}

// Auto-save functionality
document.addEventListener('DOMContentLoaded', function() {
    const inputs = document.querySelectorAll('input, select, textarea');
    
    inputs.forEach(input => {
        input.addEventListener('change', function() {
            // Add visual indicator that settings have changed
            const saveButton = document.querySelector('.btn-success');
            if (saveButton) {
                saveButton.classList.add('pulse');
            }
        });
    });
});
</script>

<?php include '../includes/footer.php'; ?>

PHP
); ?>

<?php _merge_exec('admin/support.php', <<<'PHP'

<?php
// admin/support.php - Support Management
// مدیریت پشتیبانی

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth.php';

// Require admin authentication
requireAuth();
requireAdmin();

// Page settings
$pageTitle = 'Support Management - Admin';
$bodyClass = 'admin-support';

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $ticketId = intval($_POST['ticket_id'] ?? 0);
    
    switch ($action) {
        case 'reply':
            $message = $_POST['message'] ?? '';
            if ($message && $ticketId) {
                // Add reply
                execute(
                    "INSERT INTO support_messages (ticket_id, user_id, message, is_admin, created_at) VALUES (?, ?, ?, 1, NOW())",
                    [$ticketId, $currentUser['id'], $message]
                );
                
                // Update ticket status and last response
                execute(
                    "UPDATE support_tickets SET status = 'replied', last_response_at = NOW(), assigned_to = ? WHERE id = ?",
                    [$currentUser['id'], $ticketId]
                );
                
                $successMessage = "Reply sent successfully";
            }
            break;
            
        case 'update_status':
            $status = $_POST['status'] ?? '';
            if (in_array($status, ['open', 'pending', 'replied', 'closed'])) {
                execute("UPDATE support_tickets SET status = ?, updated_at = NOW() WHERE id = ?", [$status, $ticketId]);
                $successMessage = "Ticket status updated successfully";
            }
            break;
            
        case 'assign':
            $assignTo = intval($_POST['assign_to'] ?? 0);
            execute("UPDATE support_tickets SET assigned_to = ?, updated_at = NOW() WHERE id = ?", [$assignTo, $ticketId]);
            $successMessage = "Ticket assigned successfully";
            break;
            
        case 'update_priority':
            $priority = $_POST['priority'] ?? '';
            if (in_array($priority, ['low', 'medium', 'high', 'urgent'])) {
                execute("UPDATE support_tickets SET priority = ?, updated_at = NOW() WHERE id = ?", [$priority, $ticketId]);
                $successMessage = "Priority updated successfully";
            }
            break;
    }
}

// Get filter parameters
$search = $_GET['search'] ?? '';
$status = $_GET['status'] ?? 'all';
$priority = $_GET['priority'] ?? 'all';
$category = $_GET['category'] ?? 'all';
$assigned = $_GET['assigned'] ?? 'all';
$sortBy = $_GET['sort'] ?? 'created_at';
$sortOrder = $_GET['order'] ?? 'DESC';
$page = max(1, intval($_GET['page'] ?? 1));
$limit = 25;
$offset = ($page - 1) * $limit;

// Build WHERE clause
$whereConditions = [];
$params = [];

if ($search) {
    $whereConditions[] = "(st.subject LIKE ? OR u.username LIKE ? OR u.email LIKE ?)";
    $searchTerm = "%$search%";
    $params = array_merge($params, [$searchTerm, $searchTerm, $searchTerm]);
}

if ($status !== 'all') {
    $whereConditions[] = "st.status = ?";
    $params[] = $status;
}

if ($priority !== 'all') {
    $whereConditions[] = "st.priority = ?";
    $params[] = $priority;
}

if ($category !== 'all') {
    $whereConditions[] = "st.category = ?";
    $params[] = $category;
}

if ($assigned !== 'all') {
    if ($assigned === 'unassigned') {
        $whereConditions[] = "st.assigned_to IS NULL";
    } else {
        $whereConditions[] = "st.assigned_to = ?";
        $params[] = $assigned;
    }
}

$whereClause = !empty($whereConditions) ? 'WHERE ' . implode(' AND ', $whereConditions) : '';

// Validate sort parameters
$allowedSorts = ['id', 'subject', 'priority', 'status', 'created_at', 'updated_at'];
$sortBy = in_array($sortBy, $allowedSorts) ? "st.$sortBy" : 'st.created_at';
$sortOrder = strtoupper($sortOrder) === 'ASC' ? 'ASC' : 'DESC';

// Get total count
$totalTickets = fetchValue("SELECT COUNT(*) FROM support_tickets st JOIN users u ON st.user_id = u.id $whereClause", $params);

// Get tickets
$tickets = fetchAll(
    "SELECT st.*, u.username, u.email,
        (SELECT username FROM users WHERE id = st.assigned_to) as assigned_username,
        (SELECT COUNT(*) FROM support_messages WHERE ticket_id = st.id) as message_count,
        (SELECT COUNT(*) FROM support_messages WHERE ticket_id = st.id AND is_admin = 0 AND created_at > COALESCE(st.last_response_at, '1970-01-01')) as unread_count
     FROM support_tickets st 
     JOIN users u ON st.user_id = u.id 
     $whereClause 
     ORDER BY $sortBy $sortOrder 
     LIMIT $limit OFFSET $offset",
    $params
);

// Calculate pagination
$totalPages = ceil($totalTickets / $limit);

// Get support statistics
$supportStats = fetchRow(
    "SELECT 
        COUNT(*) as total_tickets,
        COUNT(CASE WHEN status = 'open' THEN 1 END) as open_tickets,
        COUNT(CASE WHEN status = 'pending' THEN 1 END) as pending_tickets,
        COUNT(CASE WHEN status = 'replied' THEN 1 END) as replied_tickets,
        COUNT(CASE WHEN status = 'closed' THEN 1 END) as closed_tickets,
        COUNT(CASE WHEN DATE(created_at) = CURDATE() THEN 1 END) as today_tickets,
        COUNT(CASE WHEN assigned_to IS NULL THEN 1 END) as unassigned_tickets,
        AVG(CASE WHEN status = 'closed' AND last_response_at IS NOT NULL THEN TIMESTAMPDIFF(HOUR, created_at, last_response_at) END) as avg_response_time
     FROM support_tickets"
);

// Get admin users for assignment
$adminUsers = fetchAll("SELECT id, username FROM users WHERE role = 'admin' AND status = 'active'");

include '../includes/header.php';
?>

<!-- Admin Support Management -->
<div class="admin-container">
    <?php include 'sidebar.php'; ?>
    
    <main class="admin-main">
        <!-- Header -->
        <header class="admin-header">
            <div class="header-left">
                <h1 class="page-title">Support Management</h1>
                <p class="page-subtitle">Manage customer support tickets and inquiries</p>
            </div>
            
            <div class="header-right">
                <button class="btn btn-outline" onclick="exportTickets()">
                    <i class="fas fa-download"></i>
                    Export CSV
                </button>
                <button class="btn btn-primary" onclick="refreshTickets()">
                    <i class="fas fa-sync-alt"></i>
                    Refresh
                </button>
            </div>
        </header>
        
        <!-- Support Statistics -->
        <section class="stats-section">
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-ticket-alt"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($supportStats['total_tickets']); ?></div>
                        <div class="stat-label">Total Tickets</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon danger">
                        <i class="fas fa-exclamation-circle"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($supportStats['open_tickets']); ?></div>
                        <div class="stat-label">Open Tickets</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon warning">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($supportStats['pending_tickets']); ?></div>
                        <div class="stat-label">Pending</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon success">
                        <i class="fas fa-reply"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($supportStats['replied_tickets']); ?></div>
                        <div class="stat-label">Replied</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-user-slash"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($supportStats['unassigned_tickets']); ?></div>
                        <div class="stat-label">Unassigned</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-stopwatch"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo round($supportStats['avg_response_time'] ?: 0, 1); ?>h</div>
                        <div class="stat-label">Avg Response Time</div>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- Filters and Search -->
        <section class="filters-section">
            <form class="filters-form" method="GET">
                <div class="filter-group">
                    <div class="search-box">
                        <i class="fas fa-search"></i>
                        <input type="text" 
                               name="search" 
                               value="<?php echo htmlspecialchars($search); ?>" 
                               placeholder="Search tickets..."
                               class="search-input">
                    </div>
                </div>
                
                <div class="filter-group">
                    <select name="status" onchange="this.form.submit()">
                        <option value="all" <?php echo $status === 'all' ? 'selected' : ''; ?>>All Status</option>
                        <option value="open" <?php echo $status === 'open' ? 'selected' : ''; ?>>Open</option>
                        <option value="pending" <?php echo $status === 'pending' ? 'selected' : ''; ?>>Pending</option>
                        <option value="replied" <?php echo $status === 'replied' ? 'selected' : ''; ?>>Replied</option>
                        <option value="closed" <?php echo $status === 'closed' ? 'selected' : ''; ?>>Closed</option>
                    </select>
                </div>
                
                <div class="filter-group">
                    <select name="priority" onchange="this.form.submit()">
                        <option value="all" <?php echo $priority === 'all' ? 'selected' : ''; ?>>All Priority</option>
                        <option value="low" <?php echo $priority === 'low' ? 'selected' : ''; ?>>Low</option>
                        <option value="medium" <?php echo $priority === 'medium' ? 'selected' : ''; ?>>Medium</option>
                        <option value="high" <?php echo $priority === 'high' ? 'selected' : ''; ?>>High</option>
                        <option value="urgent" <?php echo $priority === 'urgent' ? 'selected' : ''; ?>>Urgent</option>
                    </select>
                </div>
                
                <div class="filter-group">
                    <select name="assigned" onchange="this.form.submit()">
                        <option value="all" <?php echo $assigned === 'all' ? 'selected' : ''; ?>>All Assigned</option>
                        <option value="unassigned" <?php echo $assigned === 'unassigned' ? 'selected' : ''; ?>>Unassigned</option>
                        <?php foreach ($adminUsers as $admin): ?>
                        <option value="<?php echo $admin['id']; ?>" <?php echo $assigned == $admin['id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($admin['username']); ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter"></i>
                    Filter
                </button>
                
                <a href="/admin/support.php" class="btn btn-outline">
                    <i class="fas fa-times"></i>
                    Clear
                </a>
            </form>
            
            <div class="results-info">
                Showing <?php echo count($tickets); ?> of <?php echo number_format($totalTickets); ?> tickets
            </div>
        </section>
        
        <!-- Tickets Table -->
        <section class="table-section">
            <div class="table-container">
                <table class="admin-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Subject</th>
                            <th>User</th>
                            <th>Category</th>
                            <th>Priority</th>
                            <th>Status</th>
                            <th>Assigned</th>
                            <th>Messages</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($tickets as $ticket): ?>
                        <tr class="ticket-row <?php echo $ticket['unread_count'] > 0 ? 'has-unread' : ''; ?>" data-ticket-id="<?php echo $ticket['id']; ?>">
                            <td>
                                <div class="ticket-id">
                                    <strong>#<?php echo $ticket['id']; ?></strong>
                                    <?php if ($ticket['unread_count'] > 0): ?>
                                    <span class="unread-badge"><?php echo $ticket['unread_count']; ?></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            
                            <td>
                                <div class="ticket-subject">
                                    <a href="#" onclick="viewTicket(<?php echo $ticket['id']; ?>)" class="subject-link">
                                        <?php echo htmlspecialchars($ticket['subject']); ?>
                                    </a>
                                </div>
                            </td>
                            
                            <td>
                                <div class="user-info">
                                    <div class="username"><?php echo htmlspecialchars($ticket['username']); ?></div>
                                    <div class="email"><?php echo htmlspecialchars($ticket['email']); ?></div>
                                </div>
                            </td>
                            
                            <td>
                                <span class="category-badge">
                                    <?php echo ucfirst($ticket['category']); ?>
                                </span>
                            </td>
                            
                            <td>
                                <span class="priority-badge priority-<?php echo $ticket['priority']; ?>">
                                    <?php echo ucfirst($ticket['priority']); ?>
                                </span>
                            </td>
                            
                            <td>
                                <span class="status-badge status-<?php echo $ticket['status']; ?>">
                                    <?php echo ucfirst($ticket['status']); ?>
                                </span>
                            </td>
                            
                            <td>
                                <div class="assigned-info">
                                    <?php if ($ticket['assigned_username']): ?>
                                    <span class="assigned-user"><?php echo htmlspecialchars($ticket['assigned_username']); ?></span>
                                    <?php else: ?>
                                    <span class="unassigned">Unassigned</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            
                            <td>
                                <div class="message-count">
                                    <i class="fas fa-comments"></i>
                                    <?php echo $ticket['message_count']; ?>
                                </div>
                            </td>
                            
                            <td>
                                <div class="date-info">
                                    <div class="date"><?php echo date('M j, Y', strtotime($ticket['created_at'])); ?></div>
                                    <div class="time"><?php echo date('H:i', strtotime($ticket['created_at'])); ?></div>
                                </div>
                            </td>
                            
                            <td>
                                <div class="action-buttons">
                                    <button class="btn btn-primary btn-xs" onclick="viewTicket(<?php echo $ticket['id']; ?>)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    
                                    <div class="dropdown">
                                        <button class="btn btn-outline btn-xs dropdown-toggle">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a href="#" onclick="assignTicket(<?php echo $ticket['id']; ?>)">Assign</a>
                                            <a href="#" onclick="updatePriority(<?php echo $ticket['id']; ?>)">Change Priority</a>
                                            <a href="#" onclick="updateStatus(<?php echo $ticket['id']; ?>, 'closed')">Close Ticket</a>
                                            <div class="dropdown-divider"></div>
                                            <a href="#" onclick="viewUserTickets(<?php echo $ticket['user_id']; ?>)">User's Tickets</a>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <?php if ($totalPages > 1): ?>
            <div class="pagination-container">
                <nav class="pagination">
                    <?php if ($page > 1): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>" class="page-link prev">
                        <i class="fas fa-chevron-left"></i>
                        Previous
                    </a>
                    <?php endif; ?>
                    
                    <?php
                    $startPage = max(1, $page - 2);
                    $endPage = min($totalPages, $page + 2);
                    
                    for ($i = $startPage; $i <= $endPage; $i++): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" 
                       class="page-link <?php echo $i === $page ? 'active' : ''; ?>">
                        <?php echo $i; ?>
                    </a>
                    <?php endfor; ?>
                    
                    <?php if ($page < $totalPages): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>" class="page-link next">
                        Next
                        <i class="fas fa-chevron-right"></i>
                    </a>
                    <?php endif; ?>
                </nav>
            </div>
            <?php endif; ?>
        </section>
    </main>
</div>

<!-- Ticket Details Modal -->
<div class="modal-backdrop" id="ticketModal">
    <div class="modal ticket-modal large">
        <div class="modal-header">
            <h3 class="modal-title">Ticket Details</h3>
            <button class="modal-close" onclick="closeModal('ticketModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body" id="ticketModalContent">
            <!-- Ticket details will be loaded here -->
        </div>
    </div>
</div>

<script>
// Support management functions
function viewTicket(ticketId) {
    fetch(`/api/admin/support/${ticketId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showTicketDetails(data.ticket, data.messages);
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
}

function showTicketDetails(ticket, messages) {
    const content = `
        <div class="ticket-details">
            <div class="ticket-header">
                <div class="ticket-info">
                    <h4>${ticket.subject}</h4>
                    <div class="ticket-meta">
                        <span class="ticket-id">#${ticket.id}</span>
                        <span class="status-badge status-${ticket.status}">${ticket.status}</span>
                        <span class="priority-badge priority-${ticket.priority}">${ticket.priority}</span>
                        <span class="category-badge">${ticket.category}</span>
                    </div>
                </div>
                <div class="ticket-actions">
                    <select onchange="updateTicketStatus(${ticket.id}, this.value)">
                        <option value="">Change Status</option>
                        <option value="open">Open</option>
                        <option value="pending">Pending</option>
                        <option value="replied">Replied</option>
                        <option value="closed">Closed</option>
                    </select>
                </div>
            </div>
            
            <div class="messages-container">
                ${messages.map(message => `
                    <div class="message ${message.is_admin ? 'admin-message' : 'user-message'}">
                        <div class="message-header">
                            <div class="message-author">
                                <i class="fas fa-${message.is_admin ? 'user-shield' : 'user'}"></i>
                                ${message.username}
                            </div>
                            <div class="message-time">
                                ${new Date(message.created_at).toLocaleString()}
                            </div>
                        </div>
                        <div class="message-content">
                            ${message.message.replace(/\n/g, '<br>')}
                        </div>
                    </div>
                `).join('')}
            </div>
            
            <div class="reply-form">
                <form onsubmit="sendReply(event, ${ticket.id})">
                    <div class="form-group">
                        <textarea name="message" rows="4" placeholder="Type your reply..." required></textarea>
                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-reply"></i>
                            Send Reply
                        </button>
                    </div>
                </form>
            </div>
        </div>
    `;
    
    document.getElementById('ticketModalContent').innerHTML = content;
    openModal('ticketModal');
}

function sendReply(event, ticketId) {
    event.preventDefault();
    
    const formData = new FormData(event.target);
    formData.append('action', 'reply');
    formData.append('ticket_id', ticketId);
    
    fetch('/admin/support.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.text())
    .then(() => {
        // Refresh ticket details
        viewTicket(ticketId);
        // Refresh page to update ticket list
        setTimeout(() => window.location.reload(), 1000);
    })
    .catch(error => {
        console.error('Error:', error);
    });
}

function updateTicketStatus(ticketId, status) {
    if (!status) return;
    
    const formData = new FormData();
    formData.append('action', 'update_status');
    formData.append('ticket_id', ticketId);
    formData.append('status', status);
    
    fetch('/admin/support.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.text())
    .then(() => {
        window.location.reload();
    })
    .catch(error => {
        console.error('Error:', error);
    });
}

function assignTicket(ticketId) {
    // Show assignment modal or dropdown
    console.log('Assign ticket:', ticketId);
}

function updatePriority(ticketId) {
    const priority = prompt('Enter new priority (low, medium, high, urgent):');
    if (priority && ['low', 'medium', 'high', 'urgent'].includes(priority)) {
        const formData = new FormData();
        formData.append('action', 'update_priority');
        formData.append('ticket_id', ticketId);
        formData.append('priority', priority);
        
        fetch('/admin/support.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(() => {
            window.location.reload();
        })
        .catch(error => {
            console.error('Error:', error);
        });
    }
}

function updateStatus(ticketId, status) {
    updateTicketStatus(ticketId, status);
}

function exportTickets() {
    const params = new URLSearchParams(window.location.search);
    params.set('export', 'csv');
    window.open(`/api/admin/support/export?${params.toString()}`, '_blank');
}

function refreshTickets() {
    window.location.reload();
}
</script>

<?php include '../includes/footer.php'; ?>

PHP
); ?>

<?php _merge_exec('admin/transactions.php', <<<'PHP'
<?php
// admin/transactions.php - Transaction Management
// مدیریت تراکنش‌ها

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth.php';

// Require admin authentication
requireAuth();
requireAdmin();

// Page settings
$pageTitle = 'Transaction Management - Admin';
$bodyClass = 'admin-transactions';

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $transactionId = intval($_POST['transaction_id'] ?? 0);
    
    switch ($action) {
        case 'approve':
            execute("UPDATE transactions SET status = 'completed', processed_at = NOW(), processed_by = ? WHERE id = ? AND status = 'pending'", [$currentUser['id'], $transactionId]);
            
            // Update user balance for deposits
            $transaction = fetchRow("SELECT * FROM transactions WHERE id = ?", [$transactionId]);
            if ($transaction && $transaction['type'] === 'deposit') {
                execute("UPDATE users SET balance = balance + ? WHERE id = ?", [$transaction['amount'], $transaction['user_id']]);
            }
            
            $message = "Transaction approved successfully";
            break;
            
        case 'reject':
            $reason = $_POST['reason'] ?? 'Rejected by admin';
            execute("UPDATE transactions SET status = 'failed', processed_at = NOW(), processed_by = ?, notes = ? WHERE id = ? AND status = 'pending'", [$currentUser['id'], $reason, $transactionId]);
            $message = "Transaction rejected successfully";
            break;
            
        case 'add_note':
            $note = $_POST['note'] ?? '';
            if ($note) {
                execute("UPDATE transactions SET notes = ? WHERE id = ?", [$note, $transactionId]);
                $message = "Note added successfully";
            }
            break;
    }
}

// Get filter parameters
$search = $_GET['search'] ?? '';
$type = $_GET['type'] ?? 'all';
$status = $_GET['status'] ?? 'all';
$dateFrom = $_GET['date_from'] ?? '';
$dateTo = $_GET['date_to'] ?? '';
$sortBy = $_GET['sort'] ?? 'created_at';
$sortOrder = $_GET['order'] ?? 'DESC';
$page = max(1, intval($_GET['page'] ?? 1));
$limit = 25;
$offset = ($page - 1) * $limit;

// Build WHERE clause
$whereConditions = [];
$params = [];

if ($search) {
    $whereConditions[] = "(u.username LIKE ? OR u.email LIKE ? OR t.transaction_id LIKE ?)";
    $searchTerm = "%$search%";
    $params = array_merge($params, [$searchTerm, $searchTerm, $searchTerm]);
}

if ($type !== 'all') {
    $whereConditions[] = "t.type = ?";
    $params[] = $type;
}

if ($status !== 'all') {
    $whereConditions[] = "t.status = ?";
    $params[] = $status;
}

if ($dateFrom) {
    $whereConditions[] = "DATE(t.created_at) >= ?";
    $params[] = $dateFrom;
}

if ($dateTo) {
    $whereConditions[] = "DATE(t.created_at) <= ?";
    $params[] = $dateTo;
}

$whereClause = !empty($whereConditions) ? 'WHERE ' . implode(' AND ', $whereConditions) : '';

// Validate sort parameters
$allowedSorts = ['id', 'amount', 'created_at', 'processed_at', 'type', 'status'];
$sortBy = in_array($sortBy, $allowedSorts) ? "t.$sortBy" : 't.created_at';
$sortOrder = strtoupper($sortOrder) === 'ASC' ? 'ASC' : 'DESC';

// Get total count
$totalTransactions = fetchValue("SELECT COUNT(*) FROM transactions t JOIN users u ON t.user_id = u.id $whereClause", $params);

// Get transactions
$transactions = fetchAll(
    "SELECT t.*, u.username, u.email,
        (SELECT username FROM users WHERE id = t.processed_by) as processed_by_username
     FROM transactions t 
     JOIN users u ON t.user_id = u.id 
     $whereClause 
     ORDER BY $sortBy $sortOrder 
     LIMIT $limit OFFSET $offset",
    $params
);

// Calculate pagination
$totalPages = ceil($totalTransactions / $limit);

// Get transaction statistics
$transactionStats = fetchRow(
    "SELECT 
        COUNT(*) as total_transactions,
        COUNT(CASE WHEN status = 'pending' THEN 1 END) as pending_transactions,
        COUNT(CASE WHEN status = 'completed' THEN 1 END) as completed_transactions,
        COUNT(CASE WHEN status = 'failed' THEN 1 END) as failed_transactions,
        SUM(CASE WHEN type = 'deposit' AND status = 'completed' THEN amount ELSE 0 END) as total_deposits,
        SUM(CASE WHEN type = 'withdrawal' AND status = 'completed' THEN amount ELSE 0 END) as total_withdrawals,
        COUNT(CASE WHEN DATE(created_at) = CURDATE() THEN 1 END) as today_transactions,
        SUM(CASE WHEN DATE(created_at) = CURDATE() AND status = 'completed' THEN amount ELSE 0 END) as today_volume
     FROM transactions"
);

include '../includes/header.php';
?>

<!-- Admin Transaction Management -->
<div class="admin-container">
    <?php include 'sidebar.php'; ?>
    
    <main class="admin-main">
        <!-- Header -->
        <header class="admin-header">
            <div class="header-left">
                <h1 class="page-title">Transaction Management</h1>
                <p class="page-subtitle">Monitor and manage all financial transactions</p>
            </div>
            
            <div class="header-right">
                <button class="btn btn-outline" onclick="exportTransactions()">
                    <i class="fas fa-download"></i>
                    Export CSV
                </button>
                <button class="btn btn-primary" onclick="refreshTransactions()">
                    <i class="fas fa-sync-alt"></i>
                    Refresh
                </button>
            </div>
        </header>
        
        <!-- Transaction Statistics -->
        <section class="stats-section">
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-exchange-alt"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($transactionStats['total_transactions']); ?></div>
                        <div class="stat-label">Total Transactions</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon warning">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($transactionStats['pending_transactions']); ?></div>
                        <div class="stat-label">Pending</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon success">
                        <i class="fas fa-arrow-down"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value">$<?php echo number_format($transactionStats['total_deposits'], 2); ?></div>
                        <div class="stat-label">Total Deposits</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon danger">
                        <i class="fas fa-arrow-up"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value">$<?php echo number_format($transactionStats['total_withdrawals'], 2); ?></div>
                        <div class="stat-label">Total Withdrawals</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-calendar-day"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($transactionStats['today_transactions']); ?></div>
                        <div class="stat-label">Today's Transactions</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value">$<?php echo number_format($transactionStats['today_volume'], 2); ?></div>
                        <div class="stat-label">Today's Volume</div>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- Filters and Search -->
        <section class="filters-section">
            <form class="filters-form" method="GET">
                <div class="filter-group">
                    <div class="search-box">
                        <i class="fas fa-search"></i>
                        <input type="text" 
                               name="search" 
                               value="<?php echo htmlspecialchars($search); ?>" 
                               placeholder="Search transactions..."
                               class="search-input">
                    </div>
                </div>
                
                <div class="filter-group">
                    <select name="type" onchange="this.form.submit()">
                        <option value="all" <?php echo $type === 'all' ? 'selected' : ''; ?>>All Types</option>
                        <option value="deposit" <?php echo $type === 'deposit' ? 'selected' : ''; ?>>Deposits</option>
                        <option value="withdrawal" <?php echo $type === 'withdrawal' ? 'selected' : ''; ?>>Withdrawals</option>
                        <option value="bet" <?php echo $type === 'bet' ? 'selected' : ''; ?>>Bets</option>
                        <option value="win" <?php echo $type === 'win' ? 'selected' : ''; ?>>Wins</option>
                        <option value="bonus" <?php echo $type === 'bonus' ? 'selected' : ''; ?>>Bonuses</option>
                    </select>
                </div>
                
                <div class="filter-group">
                    <select name="status" onchange="this.form.submit()">
                        <option value="all" <?php echo $status === 'all' ? 'selected' : ''; ?>>All Status</option>
                        <option value="pending" <?php echo $status === 'pending' ? 'selected' : ''; ?>>Pending</option>
                        <option value="completed" <?php echo $status === 'completed' ? 'selected' : ''; ?>>Completed</option>
                        <option value="failed" <?php echo $status === 'failed' ? 'selected' : ''; ?>>Failed</option>
                        <option value="cancelled" <?php echo $status === 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                    </select>
                </div>
                
                <div class="filter-group">
                    <input type="date" name="date_from" value="<?php echo $dateFrom; ?>" placeholder="From Date">
                </div>
                
                <div class="filter-group">
                    <input type="date" name="date_to" value="<?php echo $dateTo; ?>" placeholder="To Date">
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter"></i>
                    Filter
                </button>
                
                <a href="/admin/transactions.php" class="btn btn-outline">
                    <i class="fas fa-times"></i>
                    Clear
                </a>
            </form>
            
            <div class="results-info">
                Showing <?php echo count($transactions); ?> of <?php echo number_format($totalTransactions); ?> transactions
            </div>
        </section>
        
        <!-- Transactions Table -->
        <section class="table-section">
            <div class="table-container">
                <table class="admin-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>User</th>
                            <th>Type</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Method</th>
                            <th>Created</th>
                            <th>Processed</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transactions as $transaction): ?>
                        <tr class="transaction-row" data-transaction-id="<?php echo $transaction['id']; ?>">
                            <td>
                                <div class="transaction-id">
                                    <strong>#<?php echo $transaction['id']; ?></strong>
                                    <?php if ($transaction['transaction_id']): ?>
                                    <small><?php echo htmlspecialchars($transaction['transaction_id']); ?></small>
                                    <?php endif; ?>
                                </div>
                            </td>
                            
                            <td>
                                <div class="user-info">
                                    <div class="username"><?php echo htmlspecialchars($transaction['username']); ?></div>
                                    <div class="email"><?php echo htmlspecialchars($transaction['email']); ?></div>
                                </div>
                            </td>
                            
                            <td>
                                <span class="transaction-type type-<?php echo $transaction['type']; ?>">
                                    <i class="fas fa-<?php echo getTransactionIcon($transaction['type']); ?>"></i>
                                    <?php echo ucfirst($transaction['type']); ?>
                                </span>
                            </td>
                            
                            <td>
                                <div class="amount <?php echo in_array($transaction['type'], ['deposit', 'win', 'bonus']) ? 'positive' : 'negative'; ?>">
                                    <?php echo in_array($transaction['type'], ['deposit', 'win', 'bonus']) ? '+' : '-'; ?>$<?php echo number_format($transaction['amount'], 2); ?>
                                </div>
                            </td>
                            
                            <td>
                                <span class="status-badge status-<?php echo $transaction['status']; ?>">
                                    <?php echo ucfirst($transaction['status']); ?>
                                </span>
                            </td>
                            
                            <td>
                                <div class="payment-method">
                                    <?php if ($transaction['payment_method']): ?>
                                    <i class="fas fa-<?php echo getPaymentIcon($transaction['payment_method']); ?>"></i>
                                    <?php echo ucfirst($transaction['payment_method']); ?>
                                    <?php else: ?>
                                    -
                                    <?php endif; ?>
                                </div>
                            </td>
                            
                            <td>
                                <div class="date-info">
                                    <div class="date"><?php echo date('M j, Y', strtotime($transaction['created_at'])); ?></div>
                                    <div class="time"><?php echo date('H:i:s', strtotime($transaction['created_at'])); ?></div>
                                </div>
                            </td>
                            
                            <td>
                                <?php if ($transaction['processed_at']): ?>
                                <div class="date-info">
                                    <div class="date"><?php echo date('M j, Y', strtotime($transaction['processed_at'])); ?></div>
                                    <div class="time"><?php echo date('H:i:s', strtotime($transaction['processed_at'])); ?></div>
                                    <?php if ($transaction['processed_by_username']): ?>
                                    <small>by <?php echo htmlspecialchars($transaction['processed_by_username']); ?></small>
                                    <?php endif; ?>
                                </div>
                                <?php else: ?>
                                <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            
                            <td>
                                <div class="action-buttons">
                                    <button class="btn btn-outline btn-xs" onclick="viewTransaction(<?php echo $transaction['id']; ?>)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    
                                    <?php if ($transaction['status'] === 'pending'): ?>
                                    <button class="btn btn-success btn-xs" onclick="approveTransaction(<?php echo $transaction['id']; ?>)">
                                        <i class="fas fa-check"></i>
                                    </button>
                                    <button class="btn btn-danger btn-xs" onclick="rejectTransaction(<?php echo $transaction['id']; ?>)">
                                        <i class="fas fa-times"></i>
                                    </button>
                                    <?php endif; ?>
                                    
                                    <div class="dropdown">
                                        <button class="btn btn-outline btn-xs dropdown-toggle">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a href="#" onclick="addNote(<?php echo $transaction['id']; ?>)">Add Note</a>
                                            <a href="#" onclick="viewUserTransactions(<?php echo $transaction['user_id']; ?>)">User Transactions</a>
                                            <a href="#" onclick="downloadReceipt(<?php echo $transaction['id']; ?>)">Download Receipt</a>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <?php if ($totalPages > 1): ?>
            <div class="pagination-container">
                <nav class="pagination">
                    <?php if ($page > 1): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>" class="page-link prev">
                        <i class="fas fa-chevron-left"></i>
                        Previous
                    </a>
                    <?php endif; ?>
                    
                    <?php
                    $startPage = max(1, $page - 2);
                    $endPage = min($totalPages, $page + 2);
                    
                    for ($i = $startPage; $i <= $endPage; $i++): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" 
                       class="page-link <?php echo $i === $page ? 'active' : ''; ?>">
                        <?php echo $i; ?>
                    </a>
                    <?php endfor; ?>
                    
                    <?php if ($page < $totalPages): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>" class="page-link next">
                        Next
                        <i class="fas fa-chevron-right"></i>
                    </a>
                    <?php endif; ?>
                </nav>
            </div>
            <?php endif; ?>
        </section>
    </main>
</div>

<!-- Transaction Details Modal -->
<div class="modal-backdrop" id="transactionModal">
    <div class="modal transaction-modal">
        <div class="modal-header">
            <h3 class="modal-title">Transaction Details</h3>
            <button class="modal-close" onclick="closeModal('transactionModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body" id="transactionModalContent">
            <!-- Transaction details will be loaded here -->
        </div>
    </div>
</div>

<!-- Reject Transaction Modal -->
<div class="modal-backdrop" id="rejectModal">
    <div class="modal reject-modal">
        <div class="modal-header">
            <h3 class="modal-title">Reject Transaction</h3>
            <button class="modal-close" onclick="closeModal('rejectModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            <form id="rejectForm" method="POST">
                <input type="hidden" name="action" value="reject">
                <input type="hidden" name="transaction_id" id="rejectTransactionId">
                
                <div class="form-group">
                    <label for="rejectReason">Reason for Rejection</label>
                    <textarea name="reason" id="rejectReason" rows="4" required placeholder="Please provide a reason for rejecting this transaction..."></textarea>
                </div>
                
                <div class="modal-actions">
                    <button type="button" class="btn btn-outline" onclick="closeModal('rejectModal')">Cancel</button>
                    <button type="submit" class="btn btn-danger">Reject Transaction</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Transaction management functions
function viewTransaction(transactionId) {
    fetch(`/api/admin/transactions/${transactionId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showTransactionDetails(data.transaction);
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
}

function approveTransaction(transactionId) {
    if (confirm('Are you sure you want to approve this transaction?')) {
        const formData = new FormData();
        formData.append('action', 'approve');
        formData.append('transaction_id', transactionId);
        
        fetch('/admin/transactions.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(() => {
            window.location.reload();
        })
        .catch(error => {
            console.error('Error:', error);
        });
    }
}

function rejectTransaction(transactionId) {
    document.getElementById('rejectTransactionId').value = transactionId;
    openModal('rejectModal');
}

function addNote(transactionId) {
    const note = prompt('Add a note to this transaction:');
    if (note) {
        const formData = new FormData();
        formData.append('action', 'add_note');
        formData.append('transaction_id', transactionId);
        formData.append('note', note);
        
        fetch('/admin/transactions.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(() => {
            window.location.reload();
        })
        .catch(error => {
            console.error('Error:', error);
        });
    }
}

function exportTransactions() {
    const params = new URLSearchParams(window.location.search);
    params.set('export', 'csv');
    window.open(`/api/admin/transactions/export?${params.toString()}`, '_blank');
}

function refreshTransactions() {
    window.location.reload();
}

function showTransactionDetails(transaction) {
    const content = `
        <div class="transaction-details">
            <div class="detail-section">
                <h4>Basic Information</h4>
                <div class="detail-grid">
                    <div class="detail-item">
                        <label>Transaction ID:</label>
                        <span>#${transaction.id}</span>
                    </div>
                    <div class="detail-item">
                        <label>External ID:</label>
                        <span>${transaction.transaction_id || '-'}</span>
                    </div>
                    <div class="detail-item">
                        <label>Type:</label>
                        <span class="transaction-type type-${transaction.type}">${transaction.type}</span>
                    </div>
                    <div class="detail-item">
                        <label>Amount:</label>
                        <span class="amount">$${parseFloat(transaction.amount).toFixed(2)}</span>
                    </div>
                    <div class="detail-item">
                        <label>Status:</label>
                        <span class="status-badge status-${transaction.status}">${transaction.status}</span>
                    </div>
                    <div class="detail-item">
                        <label>Payment Method:</label>
                        <span>${transaction.payment_method || '-'}</span>
                    </div>
                </div>
            </div>
            
            <div class="detail-section">
                <h4>User Information</h4>
                <div class="detail-grid">
                    <div class="detail-item">
                        <label>Username:</label>
                        <span>${transaction.username}</span>
                    </div>
                    <div class="detail-item">
                        <label>Email:</label>
                        <span>${transaction.email}</span>
                    </div>
                </div>
            </div>
            
            <div class="detail-section">
                <h4>Timestamps</h4>
                <div class="detail-grid">
                    <div class="detail-item">
                        <label>Created:</label>
                        <span>${new Date(transaction.created_at).toLocaleString()}</span>
                    </div>
                    <div class="detail-item">
                        <label>Processed:</label>
                        <span>${transaction.processed_at ? new Date(transaction.processed_at).toLocaleString() : '-'}</span>
                    </div>
                </div>
            </div>
            
            ${transaction.notes ? `
            <div class="detail-section">
                <h4>Notes</h4>
                <div class="notes-content">
                    ${transaction.notes}
                </div>
            </div>
            ` : ''}
        </div>
    `;
    
    document.getElementById('transactionModalContent').innerHTML = content;
    openModal('transactionModal');
}
</script>

<?php
// Helper functions
function getTransactionIcon($type) {
    $icons = [
        'deposit' => 'arrow-down',
        'withdrawal' => 'arrow-up',
        'bet' => 'dice',
        'win' => 'trophy',
        'bonus' => 'gift'
    ];
    return $icons[$type] ?? 'exchange-alt';
}

function getPaymentIcon($method) {
    $icons = [
        'credit_card' => 'credit-card',
        'bank_transfer' => 'university',
        'paypal' => 'paypal',
        'crypto' => 'bitcoin',
        'skrill' => 'wallet',
        'neteller' => 'wallet'
    ];
    return $icons[$method] ?? 'credit-card';
}

include '../includes/footer.php';
?>

PHP
); ?>

<?php _merge_exec('admin/users.php', <<<'PHP'

<?php
// admin/users.php - User Management
// مدیریت کاربران

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth.php';

// Require admin authentication
requireAuth();
requireAdmin();

// Page settings
$pageTitle = 'User Management - Admin';
$bodyClass = 'admin-users';

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $userId = intval($_POST['user_id'] ?? 0);
    
    switch ($action) {
        case 'update_status':
            $status = $_POST['status'] ?? '';
            if (in_array($status, ['active', 'suspended', 'banned'])) {
                execute("UPDATE users SET status = ? WHERE id = ?", [$status, $userId]);
                $message = "User status updated successfully";
            }
            break;
            
        case 'update_balance':
            $amount = floatval($_POST['amount'] ?? 0);
            $type = $_POST['type'] ?? 'add'; // add or subtract
            
            if ($amount > 0) {
                if ($type === 'add') {
                    execute("UPDATE users SET balance = balance + ? WHERE id = ?", [$amount, $userId]);
                    execute("INSERT INTO transactions (user_id, type, amount, status, description, created_at) VALUES (?, 'admin_credit', ?, 'completed', 'Admin balance adjustment', NOW())", [$userId, $amount]);
                } else {
                    execute("UPDATE users SET balance = GREATEST(0, balance - ?) WHERE id = ?", [$amount, $userId]);
                    execute("INSERT INTO transactions (user_id, type, amount, status, description, created_at) VALUES (?, 'admin_debit', ?, 'completed', 'Admin balance adjustment', NOW())", [$userId, $amount]);
                }
                $message = "User balance updated successfully";
            }
            break;
            
        case 'send_message':
            $messageText = $_POST['message'] ?? '';
            if ($messageText) {
                execute("INSERT INTO admin_messages (user_id, admin_id, message, created_at) VALUES (?, ?, ?, NOW())", [$userId, $currentUser['id'], $messageText]);
                $message = "Message sent successfully";
            }
            break;
    }
}

// Get filter parameters
$search = $_GET['search'] ?? '';
$status = $_GET['status'] ?? 'all';
$sortBy = $_GET['sort'] ?? 'created_at';
$sortOrder = $_GET['order'] ?? 'DESC';
$page = max(1, intval($_GET['page'] ?? 1));
$limit = 25;
$offset = ($page - 1) * $limit;

// Build WHERE clause
$whereConditions = [];
$params = [];

if ($search) {
    $whereConditions[] = "(username LIKE ? OR email LIKE ? OR first_name LIKE ? OR last_name LIKE ?)";
    $searchTerm = "%$search%";
    $params = array_merge($params, [$searchTerm, $searchTerm, $searchTerm, $searchTerm]);
}

if ($status !== 'all') {
    $whereConditions[] = "status = ?";
    $params[] = $status;
}

$whereClause = !empty($whereConditions) ? 'WHERE ' . implode(' AND ', $whereConditions) : '';

// Validate sort parameters
$allowedSorts = ['id', 'username', 'email', 'balance', 'created_at', 'last_activity'];
$sortBy = in_array($sortBy, $allowedSorts) ? $sortBy : 'created_at';
$sortOrder = strtoupper($sortOrder) === 'ASC' ? 'ASC' : 'DESC';

// Get total count
$totalUsers = fetchValue("SELECT COUNT(*) FROM users $whereClause", $params);

// Get users
$users = fetchAll(
    "SELECT u.*, 
        (SELECT COUNT(*) FROM user_bets WHERE user_id = u.id) as total_bets,
        (SELECT SUM(bet_amount) FROM user_bets WHERE user_id = u.id) as total_wagered,
        (SELECT COUNT(*) FROM transactions WHERE user_id = u.id AND type = 'deposit') as total_deposits
     FROM users u 
     $whereClause 
     ORDER BY $sortBy $sortOrder 
     LIMIT $limit OFFSET $offset",
    $params
);

// Calculate pagination
$totalPages = ceil($totalUsers / $limit);

// Get user statistics
$userStats = fetchRow(
    "SELECT 
        COUNT(*) as total_users,
        COUNT(CASE WHEN status = 'active' THEN 1 END) as active_users,
        COUNT(CASE WHEN status = 'suspended' THEN 1 END) as suspended_users,
        COUNT(CASE WHEN status = 'banned' THEN 1 END) as banned_users,
        COUNT(CASE WHEN DATE(created_at) = CURDATE() THEN 1 END) as new_today,
        COUNT(CASE WHEN last_activity > DATE_SUB(NOW(), INTERVAL 15 MINUTE) THEN 1 END) as online_now
     FROM users"
);

include '../includes/header.php';
?>

<!-- Admin Users Management -->
<div class="admin-container">
    <?php include 'sidebar.php'; ?>
    
    <main class="admin-main">
        <!-- Header -->
        <header class="admin-header">
            <div class="header-left">
                <h1 class="page-title">User Management</h1>
                <p class="page-subtitle">Manage user accounts, balances, and permissions</p>
            </div>
            
            <div class="header-right">
                <button class="btn btn-outline" onclick="exportUsers()">
                    <i class="fas fa-download"></i>
                    Export CSV
                </button>
                <button class="btn btn-primary" onclick="openAddUserModal()">
                    <i class="fas fa-plus"></i>
                    Add User
                </button>
            </div>
        </header>
        
        <!-- User Statistics -->
        <section class="stats-section">
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($userStats['total_users']); ?></div>
                        <div class="stat-label">Total Users</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon active">
                        <i class="fas fa-user-check"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($userStats['active_users']); ?></div>
                        <div class="stat-label">Active Users</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon warning">
                        <i class="fas fa-user-clock"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($userStats['suspended_users']); ?></div>
                        <div class="stat-label">Suspended</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon danger">
                        <i class="fas fa-user-slash"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($userStats['banned_users']); ?></div>
                        <div class="stat-label">Banned</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon success">
                        <i class="fas fa-user-plus"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($userStats['new_today']); ?></div>
                        <div class="stat-label">New Today</div>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon online">
                        <i class="fas fa-circle"></i>
                    </div>
                    <div class="stat-content">
                        <div class="stat-value"><?php echo number_format($userStats['online_now']); ?></div>
                        <div class="stat-label">Online Now</div>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- Filters and Search -->
        <section class="filters-section">
            <form class="filters-form" method="GET">
                <div class="filter-group">
                    <div class="search-box">
                        <i class="fas fa-search"></i>
                        <input type="text" 
                               name="search" 
                               value="<?php echo htmlspecialchars($search); ?>" 
                               placeholder="Search users..."
                               class="search-input">
                    </div>
                </div>
                
                <div class="filter-group">
                    <select name="status" onchange="this.form.submit()">
                        <option value="all" <?php echo $status === 'all' ? 'selected' : ''; ?>>All Status</option>
                        <option value="active" <?php echo $status === 'active' ? 'selected' : ''; ?>>Active</option>
                        <option value="suspended" <?php echo $status === 'suspended' ? 'selected' : ''; ?>>Suspended</option>
                        <option value="banned" <?php echo $status === 'banned' ? 'selected' : ''; ?>>Banned</option>
                    </select>
                </div>
                
                <div class="filter-group">
                    <select name="sort" onchange="this.form.submit()">
                        <option value="created_at" <?php echo $sortBy === 'created_at' ? 'selected' : ''; ?>>Registration Date</option>
                        <option value="username" <?php echo $sortBy === 'username' ? 'selected' : ''; ?>>Username</option>
                        <option value="balance" <?php echo $sortBy === 'balance' ? 'selected' : ''; ?>>Balance</option>
                        <option value="last_activity" <?php echo $sortBy === 'last_activity' ? 'selected' : ''; ?>>Last Activity</option>
                    </select>
                </div>
                
                <div class="filter-group">
                    <select name="order" onchange="this.form.submit()">
                        <option value="DESC" <?php echo $sortOrder === 'DESC' ? 'selected' : ''; ?>>Descending</option>
                        <option value="ASC" <?php echo $sortOrder === 'ASC' ? 'selected' : ''; ?>>Ascending</option>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter"></i>
                    Filter
                </button>
                
                <a href="/admin/users.php" class="btn btn-outline">
                    <i class="fas fa-times"></i>
                    Clear
                </a>
            </form>
            
            <div class="results-info">
                Showing <?php echo count($users); ?> of <?php echo number_format($totalUsers); ?> users
            </div>
        </section>
        
        <!-- Users Table -->
        <section class="table-section">
            <div class="table-container">
                <table class="admin-table">
                    <thead>
                        <tr>
                            <th>
                                <input type="checkbox" id="selectAll" onchange="toggleSelectAll()">
                            </th>
                            <th>User</th>
                            <th>Contact</th>
                            <th>Balance</th>
                            <th>Activity</th>
                            <th>Registration</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): ?>
                        <tr class="user-row" data-user-id="<?php echo $user['id']; ?>">
                            <td>
                                <input type="checkbox" class="user-checkbox" value="<?php echo $user['id']; ?>">
                            </td>
                            
                            <td>
                                <div class="user-info">
                                    <div class="user-avatar">
                                        <?php if ($user['avatar']): ?>
                                        <img src="<?php echo htmlspecialchars($user['avatar']); ?>" alt="Avatar">
                                        <?php else: ?>
                                        <i class="fas fa-user"></i>
                                        <?php endif; ?>
                                        <?php if (strtotime($user['last_activity']) > strtotime('-15 minutes')): ?>
                                        <span class="online-indicator"></span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="user-details">
                                        <div class="username"><?php echo htmlspecialchars($user['username']); ?></div>
                                        <div class="user-id">ID: <?php echo $user['id']; ?></div>
                                        <?php if ($user['first_name'] || $user['last_name']): ?>
                                        <div class="full-name"><?php echo htmlspecialchars(trim($user['first_name'] . ' ' . $user['last_name'])); ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            
                            <td>
                                <div class="contact-info">
                                    <div class="email">
                                        <i class="fas fa-envelope"></i>
                                        <?php echo htmlspecialchars($user['email']); ?>
                                    </div>
                                    <?php if ($user['phone']): ?>
                                    <div class="phone">
                                        <i class="fas fa-phone"></i>
                                        <?php echo htmlspecialchars($user['phone']); ?>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </td>
                            
                            <td>
                                <div class="balance-info">
                                    <div class="balance-amount">$<?php echo number_format($user['balance'], 2); ?></div>
                                    <div class="balance-stats">
                                        <small>Bets: <?php echo number_format($user['total_bets'] ?: 0); ?></small>
                                        <small>Wagered: $<?php echo number_format($user['total_wagered'] ?: 0, 2); ?></small>
                                    </div>
                                </div>
                            </td>
                            
                            <td>
                                <div class="activity-info">
                                    <div class="last-activity">
                                        <?php if ($user['last_activity']): ?>
                                        <?php echo timeAgo($user['last_activity']); ?>
                                        <?php else: ?>
                                        Never
                                        <?php endif; ?>
                                    </div>
                                    <div class="activity-stats">
                                        <small>Deposits: <?php echo number_format($user['total_deposits'] ?: 0); ?></small>
                                    </div>
                                </div>
                            </td>
                            
                            <td>
                                <div class="registration-info">
                                    <div class="reg-date"><?php echo date('M j, Y', strtotime($user['created_at'])); ?></div>
                                    <div class="reg-time"><?php echo date('H:i', strtotime($user['created_at'])); ?></div>
                                </div>
                            </td>
                            
                            <td>
                                <span class="status-badge status-<?php echo $user['status']; ?>">
                                    <?php echo ucfirst($user['status']); ?>
                                </span>
                            </td>
                            
                            <td>
                                <div class="action-buttons">
                                    <button class="btn btn-outline btn-xs" onclick="viewUser(<?php echo $user['id']; ?>)">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    <button class="btn btn-primary btn-xs" onclick="editUser(<?php echo $user['id']; ?>)">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <div class="dropdown">
                                        <button class="btn btn-outline btn-xs dropdown-toggle">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a href="#" onclick="adjustBalance(<?php echo $user['id']; ?>)">Adjust Balance</a>
                                            <a href="#" onclick="sendMessage(<?php echo $user['id']; ?>)">Send Message</a>
                                            <a href="#" onclick="viewTransactions(<?php echo $user['id']; ?>)">View Transactions</a>
                                            <a href="#" onclick="loginAsUser(<?php echo $user['id']; ?>)">Login as User</a>
                                            <div class="dropdown-divider"></div>
                                            <?php if ($user['status'] !== 'suspended'): ?>
                                            <a href="#" onclick="suspendUser(<?php echo $user['id']; ?>)" class="text-warning">Suspend</a>
                                            <?php endif; ?>
                                            <?php if ($user['status'] !== 'banned'): ?>
                                            <a href="#" onclick="banUser(<?php echo $user['id']; ?>)" class="text-danger">Ban</a>
                                            <?php endif; ?>
                                            <?php if ($user['status'] !== 'active'): ?>
                                            <a href="#" onclick="activateUser(<?php echo $user['id']; ?>)" class="text-success">Activate</a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <?php if ($totalPages > 1): ?>
            <div class="pagination-container">
                <nav class="pagination">
                    <?php if ($page > 1): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>" class="page-link prev">
                        <i class="fas fa-chevron-left"></i>
                        Previous
                    </a>
                    <?php endif; ?>
                    
                    <?php
                    $startPage = max(1, $page - 2);
                    $endPage = min($totalPages, $page + 2);
                    
                    for ($i = $startPage; $i <= $endPage; $i++): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" 
                       class="page-link <?php echo $i === $page ? 'active' : ''; ?>">
                        <?php echo $i; ?>
                    </a>
                    <?php endfor; ?>
                    
                    <?php if ($page < $totalPages): ?>
                    <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>" class="page-link next">
                        Next
                        <i class="fas fa-chevron-right"></i>
                    </a>
                    <?php endif; ?>
                </nav>
            </div>
            <?php endif; ?>
        </section>
        
        <!-- Bulk Actions -->
        <section class="bulk-actions" id="bulkActions" style="display: none;">
            <div class="bulk-actions-bar">
                <div class="selected-count">
                    <span id="selectedCount">0</span> users selected
                </div>
                <div class="bulk-buttons">
                    <button class="btn btn-outline" onclick="bulkAction('activate')">
                        <i class="fas fa-check"></i>
                        Activate
                    </button>
                    <button class="btn btn-warning" onclick="bulkAction('suspend')">
                        <i class="fas fa-pause"></i>
                        Suspend
                    </button>
                    <button class="btn btn-danger" onclick="bulkAction('ban')">
                        <i class="fas fa-ban"></i>
                        Ban
                    </button>
                    <button class="btn btn-outline" onclick="bulkExport()">
                        <i class="fas fa-download"></i>
                        Export Selected
                    </button>
                </div>
            </div>
        </section>
    </main>
</div>

<!-- User Details Modal -->
<div class="modal-backdrop" id="userModal">
    <div class="modal user-modal">
        <div class="modal-header">
            <h3 class="modal-title">User Details</h3>
            <button class="modal-close" onclick="closeModal('userModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body" id="userModalContent">
            <!-- User details will be loaded here -->
        </div>
    </div>
</div>

<!-- Balance Adjustment Modal -->
<div class="modal-backdrop" id="balanceModal">
    <div class="modal balance-modal">
        <div class="modal-header">
            <h3 class="modal-title">Adjust Balance</h3>
            <button class="modal-close" onclick="closeModal('balanceModal')">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            <form id="balanceForm" method="POST">
                <input type="hidden" name="action" value="update_balance">
                <input type="hidden" name="user_id" id="balanceUserId">
                
                <div class="form-group">
                    <label>Current Balance</label>
                    <div class="current-balance" id="currentBalance">$0.00</div>
                </div>
                
                <div class="form-group">
                    <label for="balanceType">Action</label>
                    <select name="type" id="balanceType" required>
                        <option value="add">Add to Balance</option>
                        <option value="subtract">Subtract from Balance</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="balanceAmount">Amount</label>
                    <input type="number" name="amount" id="balanceAmount" step="0.01" min="0.01" required>
                </div>
                
                <div class="form-group">
                    <label for="balanceReason">Reason</label>
                    <textarea name="reason" id="balanceReason" rows="3" placeholder="Reason for balance adjustment..."></textarea>
                </div>
                
                <div class="modal-actions">
                    <button type="button" class="btn btn-outline" onclick="closeModal('balanceModal')">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Balance</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// User management functions
function viewUser(userId) {
    fetch(`/api/admin/users/${userId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showUserDetails(data.user);
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
}

function editUser(userId) {
    window.location.href = `/admin/user-edit.php?id=${userId}`;
}

function adjustBalance(userId) {
    fetch(`/api/admin/users/${userId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('balanceUserId').value = userId;
                document.getElementById('currentBalance').textContent = `$${parseFloat(data.user.balance).toFixed(2)}`;
                openModal('balanceModal');
            }
        });
}

function suspendUser(userId) {
    if (confirm('Are you sure you want to suspend this user?')) {
        updateUserStatus(userId, 'suspended');
    }
}

function banUser(userId) {
    if (confirm('Are you sure you want to ban this user?')) {
        updateUserStatus(userId, 'banned');
    }
}

function activateUser(userId) {
    updateUserStatus(userId, 'active');
}

function updateUserStatus(userId, status) {
    const formData = new FormData();
    formData.append('action', 'update_status');
    formData.append('user_id', userId);
    formData.append('status', status);
    
    fetch('/admin/users.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.text())
    .then(() => {
        window.location.reload();
    })
    .catch(error => {
        console.error('Error:', error);
    });
}

// Bulk actions
function toggleSelectAll() {
    const selectAll = document.getElementById('selectAll');
    const checkboxes = document.querySelectorAll('.user-checkbox');
    
    checkboxes.forEach(checkbox => {
        checkbox.checked = selectAll.checked;
    });
    
    updateBulkActions();
}

function updateBulkActions() {
    const checkboxes = document.querySelectorAll('.user-checkbox:checked');
    const bulkActions = document.getElementById('bulkActions');
    const selectedCount = document.getElementById('selectedCount');
    
    if (checkboxes.length > 0) {
        bulkActions.style.display = 'block';
        selectedCount.textContent = checkboxes.length;
    } else {
        bulkActions.style.display = 'none';
    }
}

// Add event listeners to checkboxes
document.addEventListener('DOMContentLoaded', function() {
    const checkboxes = document.querySelectorAll('.user-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateBulkActions);
    });
});

function bulkAction(action) {
    const selectedUsers = Array.from(document.querySelectorAll('.user-checkbox:checked'))
        .map(cb => cb.value);
    
    if (selectedUsers.length === 0) return;
    
    if (confirm(`Are you sure you want to ${action} ${selectedUsers.length} users?`)) {
        // Implement bulk action
        console.log(`Bulk ${action} for users:`, selectedUsers);
    }
}

function exportUsers() {
    const params = new URLSearchParams(window.location.search);
    params.set('export', 'csv');
    window.open(`/api/admin/users/export?${params.toString()}`, '_blank');
}
</script>

<?php include '../includes/footer.php'; ?>

PHP
); ?>

<?php _merge_exec('index.php', <<<'PHP'
<?php
// index.php - redirect to login or dashboard
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/auth.php';

if (function_exists('isLoggedIn') && isLoggedIn()) {
    header('Location: ' . SITE_URL . '/pages/dashboard.php');
    exit;
} else {
    header('Location: ' . SITE_URL . '/pages/login.php');
    exit;
}

PHP
); ?>
