<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>بازی سکسی</title>
    <link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon">
    <link rel="apple-touch-icon" type="image/x-icon" href="img/apple-touch-icon-57x57-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="72x72" href="img/apple-touch-icon-72x72-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="114x114" href="img/apple-touch-icon-114x114-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="144x144" href="img/apple-touch-icon-144x144-precomposed.png">
    <style>
        /* فونت فارسی */
        @font-face {
            font-family: 'Vazir';
            src: url('https://cdn.fontcdn.ir/Font/Persian/Vazir/Vazir.eot');
            src: url('https://cdn.fontcdn.ir/Font/Persian/Vazir/Vazir.eot?#iefix') format('embedded-opentype'),
                 url('https://cdn.fontcdn.ir/Font/Persian/Vazir/Vazir.woff2') format('woff2'),
                 url('https://cdn.fontcdn.ir/Font/Persian/Vazir/Vazir.woff') format('woff'),
                 url('https://cdn.fontcdn.ir/Font/Persian/Vazir/Vazir.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
        }
        
        /* ریست استایل‌ها */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Vazir', sans-serif;
        }
        
        body {
            background: #f8f9fa;
            color: #333;
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        /* تغییر تم رنگی به بنفش سکسی‌تر */
        :root {
            --primary-color: #b76fe4; /* بنفش جذاب */
            --primary-dark: #8e44ad; /* بنفش تیره‌تر */
            --primary-light: #d6b4f0; /* بنفش روشن‌تر */
            --accent-color: #ff4d94; /* صورتی برای تأکید */
            --gradient-start: #b76fe4;
            --gradient-end: #ff4d94;
            --error-color: #ff4757;
            --content-bg: #fcfcfc; /* رنگ پس‌زمینه بخش محتوا */
        }
        
        .container {
            width: 100%;
            max-width: 1200px;
            background: white;
            border-radius: 20px;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: row;
            overflow: hidden;
        }
        
        /* بخش سمت چپ */
        .content-left {
            flex: 1;
            background: linear-gradient(135deg, var(--gradient-start) 0%, var(--gradient-end) 100%);
            color: white;
            padding: 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            position: relative;
            min-height: 600px;
        }
        
        .content-left h2 {
            font-size: 2.5rem;
            margin-bottom: 20px;
            font-weight: 700;
            text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.2);
        }
        
        .content-left p {
            font-size: 1.2rem;
            margin-bottom: 30px;
            opacity: 0.9;
        }
        
        .btn-start {
            display: inline-block;
            background: white;
            color: var(--primary-color);
            padding: 15px 30px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.15);
            transition: all 0.3s;
            text-align: center;
            margin-top: 20px;
        }
        
        .btn-start:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
        }
        
        .copyright {
            position: absolute;
            bottom: 20px;
            right: 40px;
            font-size: 0.9rem;
            opacity: 0.7;
        }
        
        /* بخش سمت راست - فرم */
        .content-right {
            flex: 1.2;
            padding: 40px;
            overflow-y: auto;
            max-height: 600px;
            background: var(--content-bg); /* استفاده از رنگ سفید/خاکستری روشن */
        }
        
        .wizard-container {
            position: relative;
        }
        
        /* نوار پیشرفت */
        .progress-bar {
            height: 10px;
            background-color: #f1f1f1;
            border-radius: 10px;
            margin-bottom: 30px;
            overflow: hidden;
        }
        
        .progress {
            height: 100%;
            background: linear-gradient(to right, var(--gradient-start), var(--gradient-end));
            border-radius: 10px;
            width: 20%;
            transition: width 0.5s;
        }
        
        /* استایل steps */
        .step {
            display: none;
            background: transparent; /* پس‌زمینه شفاف */
        }
        
        .step.active {
            display: block;
            animation: fadeIn 0.5s;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .main_question {
            font-size: 1.5rem;
            margin-bottom: 25px;
            color: var(--primary-color);
            font-weight: 600;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }
        
        /* چک باکس‌های زیبا - نسخه اصلاح شده */
        .checkbox-container {
            display: block;
            position: relative;
            padding: 15px 15px 15px 50px;
            margin-bottom: 15px;
            cursor: pointer;
            font-size: 1.1rem;
            border: 1px solid #eee;
            border-radius: 10px;
            transition: all 0.3s;
            background: white;
        }
        
        .checkbox-container:hover {
            border-color: var(--primary-light);
            background-color: rgba(214, 180, 240, 0.1);
            transform: translateX(-5px);
        }
        
        .checkbox-container input {
            position: absolute;
            opacity: 0;
            cursor: pointer;
        }
        
        .checkmark {
            position: absolute;
            top: 50%;
            left: 15px;
            transform: translateY(-50%);
            height: 25px;
            width: 25px;
            background-color: #f1f1f1;
            border-radius: 5px;
            border: 2px solid #ddd;
            transition: all 0.3s;
        }
        
        .checkbox-container input:checked ~ .checkmark {
            background: linear-gradient(to right, var(--gradient-start), var(--gradient-end));
            border-color: var(--primary-color);
        }
        
        .checkmark:after {
            content: "";
            position: absolute;
            display: none;
            left: 7px;
            top: 3px;
            width: 7px;
            height: 12px;
            border: solid white;
            border-width: 0 3px 3px 0;
            transform: rotate(45deg);
        }
        
        .checkbox-container input:checked ~ .checkmark:after {
            display: block;
        }
        
        /* فیلدهای فرم */
        .form-group {
            margin-bottom: 20px;
            position: relative;
        }
        
        .form-control {
            width: 100%;
            padding: 15px;
            border: 1px solid #e1e1e1;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s;
            background: white;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 3px rgba(183, 111, 228, 0.2);
        }
        
        .form-control.error {
            border-color: var(--error-color);
        }
        
        .error-message {
            color: var(--error-color);
            font-size: 0.85rem;
            margin-top: 5px;
            display: none;
        }
        
        /* اسلایدر سن */
        .age-slider {
            margin: 40px 0;
        }
        
        .slider-container {
            position: relative;
            padding: 0 20px;
        }
        
        .slider {
            -webkit-appearance: none;
            width: 100%;
            height: 10px;
            border-radius: 5px;
            background: #f1f1f1;
            outline: none;
        }
        
        .slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 25px;
            height: 25px;
            border-radius: 50%;
            background: linear-gradient(to right, var(--gradient-start), var(--gradient-end));
            cursor: pointer;
            box-shadow: 0 4px 10px rgba(183, 111, 228, 0.5);
        }
        
        .slider-value {
            text-align: center;
            font-size: 1.2rem;
            margin-top: 15px;
            color: var(--primary-color);
            font-weight: 600;
        }
        
        /* دکمه‌ها */
        .wizard-buttons {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
        }
        
        .btn {
            padding: 12px 25px;
            border: none;
            border-radius: 10px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn-back {
            background: #f1f1f1;
            color: #555;
        }
        
        .btn-back:hover {
            background: #e5e5e5;
        }
        
        .btn-next {
            background: linear-gradient(to right, var(--gradient-start), var(--gradient-end));
            color: white;
            box-shadow: 0 4px 15px rgba(183, 111, 228, 0.4);
        }
        
        .btn-next:hover {
            transform: translateY(-2px);
            box-shadow: 0 7px 20px rgba(183, 111, 228, 0.5);
        }
        
        .btn-submit {
            background: linear-gradient(to right, var(--gradient-start), var(--gradient-end));
            color: white;
            padding: 15px 30px;
            width: 100%;
            box-shadow: 0 4px 15px rgba(183, 111, 228, 0.4);
        }
        
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 7px 20px rgba(183, 111, 228, 0.5);
        }
        
        /* خلاصه نهایی */
        .summary {
            background: #f9f9f9;
            padding: 20px;
            border-radius: 10px;
            border: 1px solid #eee;
        }
        
        .summary h5 {
            color: var(--primary-color);
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .summary p {
            margin-bottom: 15px;
            line-height: 1.8;
        }
        
        /* مودال قوانین */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            justify-content: center;
            align-items: center;
        }
        
        .modal-content {
            background: white;
            padding: 30px;
            border-radius: 15px;
            max-width: 500px;
            width: 90%;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }
        
        .modal-header h3 {
            color: var(--primary-color);
            font-weight: 600;
        }
        
        .close-modal {
            background: none;
            border: none;
            font-size: 1.5rem;
            cursor: pointer;
            color: #999;
        }
        
        .modal-body {
            line-height: 1.8;
            margin-bottom: 20px;
        }
        
        .modal-footer {
            text-align: left;
        }
        
        /* بخش گیف و تصاویر */
        .gif-container {
            text-align: center;
            margin: 20px 0;
        }
        
        .gif-image {
            width: 100%;
            max-width: 300px;
            height: auto;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        /* واکنش گرا */
        @media (max-width: 992px) {
            .container {
                flex-direction: column;
            }
            
            .content-left, .content-right {
                width: 100%;
            }
            
            .content-left {
                min-height: 300px;
            }
        }
        
        @media (max-width: 576px) {
            .content-left, .content-right {
                padding: 20px;
            }
            
            .content-left h2 {
                font-size: 1.8rem;
            }
            
            .main_question {
                font-size: 1.3rem;
            }
            
            .wizard-buttons {
                flex-direction: column;
                gap: 10px;
            }
            
            .btn {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="content-left">
            <h2>بازی سکسی</h2>
            <p>بازی باسلیقه شما، رضایت بیشتر شما</p>
            <a href="#" class="btn-start" id="start-btn">شروع کن!</a>
            
            <!-- نمایش گیف -->
            <div class="gif-container">
                <img src="gif.gif" alt="تصویر تبلیغاتی" class="gif-image">
            </div>
        </div>
        
        <div class="content-right">
            <div class="wizard-container">
                <div class="progress-bar">
                    <div class="progress" id="progress"></div>
                </div>
                
                <!-- فرم اصلی با action به send.php -->
                <form action="send.php" id="wrapped" method="POST" enctype="multipart/form-data">
                    <input id="website" name="website" type="text" value="" style="display: none;">
                    
                    <!-- Step 1 -->
                    <div class="step active" id="step1">
                        <h3 class="main_question"><strong>1/5</strong>سبک بازی خود را انتخاب کنید</h3>
                        
                        <label class="checkbox-container">لزبین
                            <input type="checkbox" name="question_1[]" value="لزبین" class="required" onchange="getVals(this, 'question_1');">
                            <span class="checkmark"></span>
                        </label>
                        
                        <label class="checkbox-container">گی
                            <input type="checkbox" name="question_1[]" value="گی" class="required" onchange="getVals(this, 'question_1');">
                            <span class="checkmark"></span>
                        </label>
                        
                        <label class="checkbox-container">تری سام
                            <input type="checkbox" name="question_1[]" value="تری سام" class="required" onchange="getVals(this, 'question_1');">
                            <span class="checkmark"></span>
                        </label>
                        
                        <label class="checkbox-container">ریلکس و مدرن
                            <input type="checkbox" name="question_1[]" value="ریلکس و مدرن" class="required" onchange="getVals(this, 'question_1');">
                            <span class="checkmark"></span>
                        </label>
                        
                        <label class="checkbox-container">ماساژی
                            <input type="checkbox" name="question_1[]" value="ماساژی" class="required" onchange="getVals(this, 'question_1');">
                            <span class="checkmark"></span>
                        </label>
                        
                        <label class="checkbox-container">خشن
                            <input type="checkbox" name="question_1[]" value="خشن" class="required" onchange="getVals(this, 'question_1');">
                            <span class="checkmark"></span>
                        </label>
                        
                        <div class="wizard-buttons">
                            <button type="button" class="btn btn-next" onclick="validateStep1()">ادامه</button>
                        </div>
                    </div>
                    
                    <!-- Step 2 -->
                    <div class="step" id="step2">
                        <h3 class="main_question"><strong>2/5</strong>لطفا جنسیت خود را انتخاب کنید</h3>
                        
                        <div class="form-group">
                            <select class="form-control wide required" name="country" id="country">
                                <option value="">انتخاب کنید</option>
                                <option value="01">آقا</option>
                                <option value="02">خانم</option>
                            </select>
                            <div class="error-message" id="gender-error">لطفا جنسیت خود را انتخاب کنید</div>
                        </div>
                        
                        <div class="wizard-buttons">
                            <button type="button" class="btn btn-back" onclick="prevStep(2)">بازگشت</button>
                            <button type="button" class="btn btn-next" onclick="validateStep2()">ادامه</button>
                        </div>
                    </div>
                    
                    <!-- Step 3 -->
                    <div class="step" id="step3">
                        <h3 class="main_question"><strong>3/5</strong>سن خود را انتخاب کنید</h3>
                        
                        <div class="age-slider">
                            <div class="slider-container">
                                <input type="range" min="18" max="70" value="18" class="slider" name="budget" id="age-slider" oninput="getVals(this, 'budget'); updateAgeValue(this.value)">
                            </div>
                            <div class="slider-value" id="age-value">18 سال</div>
                        </div>
                        
                        <div class="wizard-buttons">
                            <button type="button" class="btn btn-back" onclick="prevStep(3)">بازگشت</button>
                            <button type="button" class="btn btn-next" onclick="nextStep(3)">ادامه</button>
                        </div>
                    </div>
                    
                    <!-- Step 4 -->
                    <div class="step" id="step4">
                        <h3 class="main_question"><strong>4/5</strong>لطفا تمامی فیلد ها را با دقت پر کنید.</h3>
                        
                        <div class="form-group">
                            <input type="text" class="form-control required" name="firstname" id="firstname" placeholder="نام" oninput="validatePersianText(this, 'firstname-error')">
                            <div class="error-message" id="firstname-error">لطفا نام خود را به فارسی وارد کنید</div>
                        </div>
                        
                        <div class="form-group">
                            <input type="text" class="form-control required" name="lastname" id="lastname" placeholder="نام خانوادگی" oninput="validatePersianText(this, 'lastname-error')">
                            <div class="error-message" id="lastname-error">لطفا نام خانوادگی خود را به فارسی وارد کنید</div>
                        </div>
                        
                        <div class="form-group">
                            <input type="tel" class="form-control" name="phone" id="phone" placeholder="موبایل" oninput="validatePhone(this, 'phone-error')">
                            <div class="error-message" id="phone-error">شماره موبایل باید با 09 شروع شده و 11 رقم باشد</div>
                        </div>
                        
                        <div class="form-group">
                            <label class="checkbox-container">لطفا <a href="#" onclick="openModal()">قوانین و سیاست ها</a> را بادقت مطالعه کنید.
                                <input type="checkbox" name="terms" value="Yes" class="required" id="terms">
                                <span class="checkmark"></span>
                            </label>
                            <div class="error-message" id="terms-error">لطفا قوانین را مطالعه و تایید کنید</div>
                        </div>
                        
                        <div class="wizard-buttons">
                            <button type="button" class="btn btn-back" onclick="prevStep(4)">بازگشت</button>
                            <button type="button" class="btn btn-next" onclick="validateStep4()">ادامه</button>
                        </div>
                    </div>
                    
                    <!-- Step 5 -->
                    <div class="step" id="step5">
                        <h3 class="main_question"><strong>5/5</strong>نتیجه درخواست</h3>
                        
                        <div class="summary">
                            <ul>
                                <li>
                                    <h5>شروع بازی با سبک ساخته شده</h5>
                                    <p>کاربر عزیز، برای شروع بازی با سلیقه خود ابتدا 2000 تومان را پرداخت کنید</p>
                                    <p>این هزینه برای تایید هویت شما میباشد و بازی به مدت یکماه بدون نیاز به پرداخت مجدد، در اختیار شما قرار میگیرد، بعد از پرداخت و دریافت بازی، امکان تغییر سلیقه و سبک بازی نیز میباشد. لطفا یک بار کلیک کنید و 5 - 10 ثانیه صبر کنید!</p>
                                    <h5>⚖️  میتوانید با پشتیبانی تلگرام به آیدی : @GameSexyAdmin درصورت بروز هر گونه مشکل و  یا جهت فعال سازی اشتراک ارتباط بگیرید.</h5>
                                </li>
                            </ul>
                        </div>
                        
                        <button type="submit" name="process" class="btn btn-submit">برای ثبت و پرداخت هزینه یک بار کلیک کنید</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- مودال قوانین -->
    <div class="modal" id="terms-modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>قوانین و سیاست ها</h3>
                <button class="close-modal" onclick="closeModal()">&times;</button>
            </div>
            <div class="modal-body">
                <p>🧘‍♂ قوانین رزرو و ارایه خدمات بازی های سکسی:<br>
                ⚖️ هزینه 2 هزار تومان جهت رزرو نهایی از شما دریافت می‌گردد و این هزینه جهت اطمینان از واقعی بودن درخواست شما است.<br>
                ⚖️ بعد از پرداخت هزینه لطفا با پشتیبانی تلگرام هماهنگی جهت دریافت آپدیت ها انجام دهید.<br>
                ⚖️ اگر مایل به کنسل رزرو خود هستید شماره کارت و شماره موبایل خود را به پشتیبانی تلگرام ارسال کنید مبلغ 2 هزار تومان به حساب شما برگردانده شود.<br>
                ⚖️ در صورت مشاهده هر گونه مشکل در هر کدام از بخش های برنامه مثل مرحله پرداخت یا ثبت نام به پشتیبانی تلگرام  @GameSexyAdmin اطلاع دهید.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-back" onclick="closeModal()">بستن</button>
            </div>
        </div>
    </div>
    
    <!-- اضافه کردن jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <script>
        // مدیریت مراحل فرم
        let currentStep = 1;
        const totalSteps = 5;
        
        function updateProgressBar() {
            const progress = document.getElementById('progress');
            const percent = (currentStep / totalSteps) * 100;
            progress.style.width = percent + '%';
        }
        
        function nextStep(step) {
            if (step < totalSteps) {
                document.getElementById('step' + step).classList.remove('active');
                document.getElementById('step' + (step + 1)).classList.add('active');
                currentStep = step + 1;
                updateProgressBar();
            }
        }
        
        function prevStep(step) {
            if (step > 1) {
                document.getElementById('step' + step).classList.remove('active');
                document.getElementById('step' + (step - 1)).classList.add('active');
                currentStep = step - 1;
                updateProgressBar();
            }
        }
        
        // مدیریت اسلایدر سن
        function updateAgeValue(value) {
            document.getElementById('age-value').textContent = value + ' سال';
        }
        
        // مدیریت مودال
        function openModal() {
            document.getElementById('terms-modal').style.display = 'flex';
        }
        
        function closeModal() {
            document.getElementById('terms-modal').style.display = 'none';
        }
        
        // مدیریت کلیک روی دکمه شروع
        document.getElementById('start-btn').addEventListener('click', function(e) {
            e.preventDefault();
            document.querySelector('.content-left').scrollIntoView({ behavior: 'smooth' });
        });
        
        // اعتبارسنجی مرحله 1
        function validateStep1() {
            const checkboxes = document.querySelectorAll('input[name="question_1[]"]');
            let checked = false;
            
            for (let i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].checked) {
                    checked = true;
                    break;
                }
            }
            
            if (checked) {
                nextStep(1);
            } else {
                alert('لطفا حداقل یک سبک بازی انتخاب کنید');
            }
        }
        
        // اعتبارسنجی مرحله 2
        function validateStep2() {
            const country = document.getElementById('country');
            const error = document.getElementById('gender-error');
            
            if (country.value === '') {
                error.style.display = 'block';
                country.classList.add('error');
            } else {
                error.style.display = 'none';
                country.classList.remove('error');
                nextStep(2);
            }
        }
        
        // اعتبارسنجی متن فارسی
        function validatePersianText(input, errorId) {
            const error = document.getElementById(errorId);
            const persianRegex = /^[\u0600-\u06FF\s]+$/;
            
            if (input.value === '' || !persianRegex.test(input.value)) {
                error.style.display = 'block';
                input.classList.add('error');
                return false;
            } else {
                error.style.display = 'none';
                input.classList.remove('error');
                return true;
            }
        }
        
        // اعتبارسنجی شماره تلفن
        function validatePhone(input, errorId) {
            const error = document.getElementById(errorId);
            const phoneRegex = /^09[0-9]{9}$/;
            
            if (input.value === '' || !phoneRegex.test(input.value)) {
                error.style.display = 'block';
                input.classList.add('error');
                return false;
            } else {
                error.style.display = 'none';
                input.classList.remove('error');
                return true;
            }
        }
        
        // اعتبارسنجی مرحله 4
        function validateStep4() {
            const firstnameValid = validatePersianText(document.getElementById('firstname'), 'firstname-error');
            const lastnameValid = validatePersianText(document.getElementById('lastname'), 'lastname-error');
            const phoneValid = validatePhone(document.getElementById('phone'), 'phone-error');
            
            const terms = document.getElementById('terms');
            const termsError = document.getElementById('terms-error');
            
            if (!terms.checked) {
                termsError.style.display = 'block';
            } else {
                termsError.style.display = 'none';
            }
            
            if (firstnameValid && lastnameValid && phoneValid && terms.checked) {
                nextStep(4);
            }
        }
        
        // تابع getVals برای مدیریت مقادیر
        function getVals(formControl, controlType) {
            switch (controlType) {
                case 'question_1':
                    var checkboxName = $(formControl).attr('name');
                    var value = [];
                    $("input[name*='" + checkboxName + "']").each(function () {
                        if (jQuery(this).is(":checked")) {
                            value.push($(this).val());
                        }
                    });
                    $("#question_1").text(value.join(", "));
                    break;

                case 'budget':
                    var value = $(formControl).val();
                    $("#budget").text(value);
                    break;
            }
        }
        
        // بستن مودال با کلیک خارج از آن
        window.addEventListener('click', function(e) {
            const modal = document.getElementById('terms-modal');
            if (e.target === modal) {
                closeModal();
            }
        });
    </script>
</body>
</html>