<?php
// languages/es.php - Spanish Language File
// فایل زبان اسپانیولی

return [
    // General
    'site_name' => 'Crashify',
    'welcome' => 'Bienvenido',
    'home' => 'Inicio',
    'about' => 'Acerca de',
    'contact' => 'Contacto',
    'login' => 'Iniciar sesión',
    'register' => 'Registrarse',
    'logout' => 'Cerrar sesión',
    'dashboard' => 'Panel de control',
    'profile' => 'Perfil',
    'settings' => 'Configuración',
    'help' => 'Ayuda',
    'support' => 'Soporte',
    'language' => 'Idioma',
    'currency' => 'Moneda',
    'search' => 'Buscar',
    'loading' => 'Cargando...',
    'error' => 'Error',
    'success' => 'Éxito',
    'warning' => 'Advertencia',
    'info' => 'Información',
    'close' => 'Cerrar',
    'save' => 'Guardar',
    'cancel' => 'Cancelar',
    'delete' => 'Eliminar',
    'edit' => 'Editar',
    'view' => 'Ver',
    'back' => 'Atrás',
    'next' => 'Siguiente',
    'previous' => 'Anterior',
    'submit' => 'Enviar',
    'confirm' => 'Confirmar',
    'yes' => 'Sí',
    'no' => 'No',
    'ok' => 'OK',
    'continue' => 'Continuar',
    'finish' => 'Finalizar',
    'start' => 'Comenzar',
    'stop' => 'Detener',
    'pause' => 'Pausar',
    'resume' => 'Reanudar',
    'reset' => 'Restablecer',
    'refresh' => 'Actualizar',
    'update' => 'Actualizar',
    'upgrade' => 'Actualización',
    'download' => 'Descargar',
    'upload' => 'Subir',
    'share' => 'Compartir',
    'copy' => 'Copiar',
    'print' => 'Imprimir',
    'export' => 'Exportar',
    'import' => 'Importar',
    
    // Navigation
    'nav_home' => 'Inicio',
    'nav_casino' => 'Casino',
    'nav_sports' => 'Deportes',
    'nav_live' => 'En vivo',
    'nav_promotions' => 'Promociones',
    'nav_wallet' => 'Billetera',
    'nav_history' => 'Historial',
    'nav_support' => 'Soporte',
    
    // Authentication
    'auth_login_title' => 'Inicia sesión en tu cuenta',
    'auth_register_title' => 'Crear nueva cuenta',
    'auth_email' => 'Correo electrónico',
    'auth_password' => 'Contraseña',
    'auth_confirm_password' => 'Confirmar contraseña',
    'auth_remember_me' => 'Recordarme',
    'auth_forgot_password' => '¿Olvidaste tu contraseña?',
    'auth_no_account' => '¿No tienes cuenta?',
    'auth_have_account' => '¿Ya tienes cuenta?',
    'auth_create_account' => 'Crear cuenta',
    'auth_login_now' => 'Iniciar sesión ahora',
    'auth_first_name' => 'Nombre',
    'auth_last_name' => 'Apellido',
    'auth_phone' => 'Número de teléfono',
    'auth_birth_date' => 'Fecha de nacimiento',
    'auth_country' => 'País',
    'auth_city' => 'Ciudad',
    'auth_address' => 'Dirección',
    'auth_agree_terms' => 'Acepto los términos y condiciones',
    'auth_agree_privacy' => 'Acepto la política de privacidad',
    'auth_login_success' => 'Inicio de sesión exitoso',
    'auth_register_success' => 'Cuenta creada exitosamente',
    'auth_logout_success' => 'Cierre de sesión exitoso',
    'auth_invalid_credentials' => 'Credenciales inválidas',
    'auth_email_exists' => 'El correo ya está en uso',
    'auth_weak_password' => 'Contraseña débil',
    'auth_password_mismatch' => 'Las contraseñas no coinciden',
    
    // Dashboard
    'dashboard_welcome' => 'Bienvenido, {name}',
    'dashboard_balance' => 'Saldo',
    'dashboard_total_bets' => 'Total de apuestas',
    'dashboard_total_wins' => 'Total de ganancias',
    'dashboard_win_rate' => 'Tasa de victorias',
    'dashboard_recent_games' => 'Juegos recientes',
    'dashboard_quick_deposit' => 'Depósito rápido',
    'dashboard_quick_withdraw' => 'Retiro rápido',
    'dashboard_notifications' => 'Notificaciones',
    'dashboard_no_notifications' => 'No hay notificaciones nuevas',
    'dashboard_view_all' => 'Ver todo',
    
    // Games
    'games_crash' => 'Crash',
    'games_slots' => 'Tragamonedas',
    'games_blackjack' => 'Blackjack',
    'games_roulette' => 'Ruleta',
    'games_baccarat' => 'Baccarat',
    'games_poker' => 'Poker',
    'games_dice' => 'Dados',
    'games_mines' => 'Minas',
    'games_plinko' => 'Plinko',
    'games_wheel' => 'Rueda',
    'games_keno' => 'Keno',
    'games_scratch' => 'Raspaditas',
    'games_play_now' => 'Jugar ahora',
    'games_demo_mode' => 'Modo demo',
    'games_real_mode' => 'Modo real',
    'games_min_bet' => 'Apuesta mín.',
    'games_max_bet' => 'Apuesta máx.',
    'games_max_win' => 'Ganancia máx.',
    'games_rtp' => 'Retorno al jugador',
    'games_volatility' => 'Volatilidad',
    'games_provider' => 'Proveedor',
    
    // Betting
    'bet_amount' => 'Cantidad de apuesta',
    'bet_place' => 'Realizar apuesta',
    'bet_cancel' => 'Cancelar apuesta',
    'bet_cashout' => 'Cobrar',
    'bet_auto' => 'Apuesta automática',
    'bet_manual' => 'Apuesta manual',
    'bet_multiplier' => 'Multiplicador',
    'bet_profit' => 'Ganancia',
    'bet_loss' => 'Pérdida',
    'bet_win' => 'Victoria',
    'bet_pending' => 'Pendiente',
    'bet_settled' => 'Liquidada',
    'bet_void' => 'Anulada',
    'bet_history' => 'Historial de apuestas',
    'bet_statistics' => 'Estadísticas de apuestas',
    'bet_limits' => 'Límites de apuestas',
    'bet_responsible' => 'Juego responsable',
    
    // Wallet
    'wallet_balance' => 'Saldo de billetera',
    'wallet_deposit' => 'Depósito',
    'wallet_withdraw' => 'Retiro',
    'wallet_transfer' => 'Transferencia',
    'wallet_history' => 'Historial de billetera',
    'wallet_pending' => 'Pendiente',
    'wallet_completed' => 'Completado',
    'wallet_failed' => 'Fallido',
    'wallet_cancelled' => 'Cancelado',
    'wallet_min_deposit' => 'Depósito mín.',
    'wallet_max_deposit' => 'Depósito máx.',
    'wallet_min_withdraw' => 'Retiro mín.',
    'wallet_max_withdraw' => 'Retiro máx.',
    'wallet_fee' => 'Comisión',
    'wallet_processing_time' => 'Tiempo de procesamiento',
    'wallet_payment_method' => 'Método de pago',
    'wallet_card' => 'Tarjeta',
    'wallet_bank' => 'Banco',
    'wallet_crypto' => 'Criptomoneda',
    'wallet_ewallet' => 'Billetera electrónica',
    
    // Sports Betting
    'sports_football' => 'Fútbol',
    'sports_basketball' => 'Baloncesto',
    'sports_tennis' => 'Tenis',
    'sports_baseball' => 'Béisbol',
    'sports_hockey' => 'Hockey',
    'sports_soccer' => 'Fútbol americano',
    'sports_boxing' => 'Boxeo',
    'sports_mma' => 'Artes marciales mixtas',
    'sports_cricket' => 'Cricket',
    'sports_rugby' => 'Rugby',
    'sports_golf' => 'Golf',
    'sports_racing' => 'Carreras',
    'sports_esports' => 'E-deportes',
    'sports_live_betting' => 'Apuestas en vivo',
    'sports_pre_match' => 'Pre-partido',
    'sports_odds' => 'Cuotas',
    'sports_handicap' => 'Hándicap',
    'sports_over_under' => 'Más/Menos',
    'sports_both_teams_score' => 'Ambos equipos anotan',
    'sports_correct_score' => 'Resultado exacto',
    'sports_first_goal' => 'Primer gol',
    'sports_match_winner' => 'Ganador del partido',
    'sports_tournament_winner' => 'Ganador del torneo',
    
    // Promotions
    'promo_welcome_bonus' => 'Bono de bienvenida',
    'promo_deposit_bonus' => 'Bono de depósito',
    'promo_reload_bonus' => 'Bono de recarga',
    'promo_cashback' => 'Reembolso',
    'promo_free_spins' => 'Giros gratis',
    'promo_free_bet' => 'Apuesta gratis',
    'promo_tournament' => 'Torneo',
    'promo_loyalty' => 'Programa de lealtad',
    'promo_vip' => 'Programa VIP',
    'promo_refer_friend' => 'Referir amigo',
    'promo_code' => 'Código promocional',
    'promo_terms' => 'Términos de la promoción',
    'promo_wagering' => 'Requisitos de apuesta',
    'promo_expiry' => 'Fecha de vencimiento',
    'promo_claim' => 'Reclamar',
    'promo_claimed' => 'Reclamado',
    'promo_expired' => 'Expirado',
    'promo_active' => 'Activo',
    'promo_completed' => 'Completado',
    
    // Profile
    'profile_personal_info' => 'Información personal',
    'profile_account_settings' => 'Configuración de cuenta',
    'profile_security' => 'Seguridad',
    'profile_preferences' => 'Preferencias',
    'profile_verification' => 'Verificación',
    'profile_documents' => 'Documentos',
    'profile_limits' => 'Límites',
    'profile_self_exclusion' => 'Autoexclusión',
    'profile_responsible_gaming' => 'Juego responsable',
    'profile_notifications' => 'Notificaciones',
    'profile_privacy' => 'Privacidad',
    'profile_change_password' => 'Cambiar contraseña',
    'profile_two_factor' => 'Autenticación de dos factores',
    'profile_login_history' => 'Historial de inicio de sesión',
    'profile_device_management' => 'Gestión de dispositivos',
    
    // Support
    'support_contact' => 'Contactarnos',
    'support_live_chat' => 'Chat en vivo',
    'support_email' => 'Correo electrónico',
    'support_phone' => 'Teléfono',
    'support_faq' => 'Preguntas frecuentes',
    'support_help_center' => 'Centro de ayuda',
    'support_ticket' => 'Ticket de soporte',
    'support_create_ticket' => 'Crear ticket',
    'support_ticket_status' => 'Estado del ticket',
    'support_priority' => 'Prioridad',
    'support_category' => 'Categoría',
    'support_subject' => 'Asunto',
    'support_message' => 'Mensaje',
    'support_attachment' => 'Adjunto',
    'support_response' => 'Respuesta',
    'support_resolved' => 'Resuelto',
    'support_pending' => 'Pendiente',
    'support_closed' => 'Cerrado',
    
    // Notifications
    'notif_new_message' => 'Nuevo mensaje',
    'notif_deposit_success' => 'Depósito exitoso',
    'notif_withdraw_success' => 'Retiro exitoso',
    'notif_bet_won' => '¡Apuesta ganada!',
    'notif_bet_lost' => 'Apuesta perdida',
    'notif_bonus_received' => 'Bono recibido',
    'notif_promotion_available' => 'Promoción disponible',
    'notif_account_verified' => 'Cuenta verificada',
    'notif_security_alert' => 'Alerta de seguridad',
    'notif_maintenance' => 'Mantenimiento del sistema',
    'notif_mark_read' => 'Marcar como leído',
    'notif_mark_all_read' => 'Marcar todo como leído',
    'notif_delete' => 'Eliminar notificación',
    'notif_settings' => 'Configuración de notificaciones',
    
    // Errors
    'error_404' => 'Página no encontrada',
    'error_500' => 'Error del servidor',
    'error_403' => 'Acceso denegado',
    'error_401' => 'No autorizado',
    'error_400' => 'Solicitud inválida',
    'error_network' => 'Error de red',
    'error_timeout' => 'Tiempo de espera agotado',
    'error_invalid_input' => 'Entrada inválida',
    'error_required_field' => 'Este campo es requerido',
    'error_invalid_email' => 'Correo electrónico inválido',
    'error_invalid_phone' => 'Número de teléfono inválido',
    'error_min_length' => 'Longitud mínima {min} caracteres',
    'error_max_length' => 'Longitud máxima {max} caracteres',
    'error_min_value' => 'Valor mínimo {min}',
    'error_max_value' => 'Valor máximo {max}',
    'error_insufficient_balance' => 'Saldo insuficiente',
    'error_bet_limit_exceeded' => 'Límite de apuesta excedido',
    'error_game_unavailable' => 'Juego no disponible',
    'error_maintenance' => 'Sistema en mantenimiento',
    
    // Success Messages
    'success_saved' => 'Guardado exitosamente',
    'success_updated' => 'Actualizado exitosamente',
    'success_deleted' => 'Eliminado exitosamente',
    'success_sent' => 'Enviado exitosamente',
    'success_verified' => 'Verificado exitosamente',
    'success_activated' => 'Activado exitosamente',
    'success_deactivated' => 'Desactivado exitosamente',
    'success_password_changed' => 'Contraseña cambiada exitosamente',
    'success_email_sent' => 'Correo enviado',
    'success_settings_saved' => 'Configuración guardada',
    
    // Time and Date
    'time_now' => 'ahora',
    'time_minute_ago' => 'hace 1 minuto',
    'time_minutes_ago' => 'hace {count} minutos',
    'time_hour_ago' => 'hace 1 hora',
    'time_hours_ago' => 'hace {count} horas',
    'time_day_ago' => 'hace 1 día',
    'time_days_ago' => 'hace {count} días',
    'time_week_ago' => 'hace 1 semana',
    'time_weeks_ago' => 'hace {count} semanas',
    'time_month_ago' => 'hace 1 mes',
    'time_months_ago' => 'hace {count} meses',
    'time_year_ago' => 'hace 1 año',
    'time_years_ago' => 'hace {count} años',
    
    // Days of Week
    'day_monday' => 'Lunes',
    'day_tuesday' => 'Martes',
    'day_wednesday' => 'Miércoles',
    'day_thursday' => 'Jueves',
    'day_friday' => 'Viernes',
    'day_saturday' => 'Sábado',
    'day_sunday' => 'Domingo',
    
    // Months
    'month_january' => 'Enero',
    'month_february' => 'Febrero',
    'month_march' => 'Marzo',
    'month_april' => 'Abril',
    'month_may' => 'Mayo',
    'month_june' => 'Junio',
    'month_july' => 'Julio',
    'month_august' => 'Agosto',
    'month_september' => 'Septiembre',
    'month_october' => 'Octubre',
    'month_november' => 'Noviembre',
    'month_december' => 'Diciembre',
    
    // Footer
    'footer_about_us' => 'Acerca de nosotros',
    'footer_terms' => 'Términos y condiciones',
    'footer_privacy' => 'Política de privacidad',
    'footer_responsible_gaming' => 'Juego responsable',
    'footer_contact' => 'Contacto',
    'footer_help' => 'Ayuda',
    'footer_sitemap' => 'Mapa del sitio',
    'footer_copyright' => '© 2024 Crashify. Todos los derechos reservados.',
    'footer_license' => 'Licenciado y regulado',
    'footer_18_plus' => 'Solo 18+',
    'footer_gamble_responsibly' => 'Juega responsablemente',
    
    // Legal
    'legal_terms_title' => 'Términos y condiciones',
    'legal_privacy_title' => 'Política de privacidad',
    'legal_responsible_title' => 'Juego responsable',
    'legal_aml_title' => 'Antilavado de dinero',
    'legal_kyc_title' => 'Conoce a tu cliente',
    'legal_complaints_title' => 'Procedimientos de quejas',
    'legal_licensing_title' => 'Información de licencia',
    'legal_fairness_title' => 'Equidad y transparencia',
    
    // Admin
    'admin_dashboard' => 'Panel de administración',
    'admin_users' => 'Usuarios',
    'admin_transactions' => 'Transacciones',
    'admin_games' => 'Juegos',
    'admin_reports' => 'Reportes',
    'admin_settings' => 'Configuración',
    'admin_logs' => 'Registros',
    'admin_security' => 'Seguridad',
    'admin_maintenance' => 'Mantenimiento',
    'admin_backup' => 'Respaldo',
];
?>