<?php
// includes/footer.php - Footer Template
// فوتر سایت Crashify

?>
    </main>

    <!-- Footer -->
    <footer class="main-footer">
        <div class="container">
            <!-- Footer Top -->
            <div class="footer-top">
                <div class="footer-grid">
                    <!-- Company Info -->
                    <div class="footer-section">
                        <div class="footer-logo">
                            <div class="logo">
                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none">
                                    <rect width="40" height="40" rx="8" fill="url(#footerLogoGradient)"/>
                                    <path d="M12 28L20 12L28 28H24L20 20L16 28H12Z" fill="white"/>
                                    <defs>
                                        <linearGradient id="footerLogoGradient" x1="0" y1="0" x2="40" y2="40">
                                            <stop offset="0%" stop-color="#3B82F6"/>
                                            <stop offset="100%" stop-color="#1D4ED8"/>
                                        </linearGradient>
                                    </defs>
                                </svg>
                                <span class="logo-text">Crashify</span>
                            </div>
                        </div>
                        <p class="footer-description">
                            <?php _e('footer.company_description'); ?>
                        </p>
                        <div class="footer-stats">
                            <div class="stat-item">
                                <div class="stat-number" data-count="50000">0</div>
                                <div class="stat-label"><?php _e('footer.active_users'); ?></div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-number" data-count="1000000">0</div>
                                <div class="stat-label"><?php _e('footer.daily_volume'); ?></div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-number" data-count="99.9">0</div>
                                <div class="stat-label"><?php _e('footer.uptime'); ?>%</div>
                            </div>
                        </div>
                    </div>

                    <!-- Sports & Betting -->
                    <div class="footer-section">
                        <h4 class="footer-title"><?php _e('footer.sports_betting'); ?></h4>
                        <ul class="footer-links">
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/sportsbook.php"><?php _e('nav.sportsbook'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/live-betting.php"><?php _e('nav.live_betting'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/sportsbook.php?sport=football"><?php _e('sports.football'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/sportsbook.php?sport=basketball"><?php _e('sports.basketball'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/sportsbook.php?sport=tennis"><?php _e('sports.tennis'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/esports.php"><?php _e('nav.esports'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/virtual-sports.php"><?php _e('nav.virtual_sports'); ?></a></li>
                        </ul>
                    </div>

                    <!-- Casino -->
                    <div class="footer-section">
                        <h4 class="footer-title"><?php _e('footer.casino_games'); ?></h4>
                        <ul class="footer-links">
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/casino.php"><?php _e('nav.casino'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/live-casino.php"><?php _e('casino.live_casino'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/casino.php?category=slots"><?php _e('casino.slots'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/casino.php?category=table"><?php _e('casino.table_games'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/casino.php?category=crash"><?php _e('casino.crash_games'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/casino.php?category=jackpots"><?php _e('casino.jackpots'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/tournaments.php"><?php _e('casino.tournaments'); ?></a></li>
                        </ul>
                    </div>

                    <!-- Crypto & Payments -->
                    <div class="footer-section">
                        <h4 class="footer-title"><?php _e('footer.crypto_payments'); ?></h4>
                        <ul class="footer-links">
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/wallet.php"><?php _e('user.wallet'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/deposit.php"><?php _e('wallet.deposit'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/withdraw.php"><?php _e('wallet.withdraw'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/crypto-guide.php"><?php _e('help.crypto_guide'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/payment-methods.php">Payment Methods</a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/fees.php">Fees & Limits</a></li>
                        </ul>
                    </div>

                    <!-- Support -->
                    <div class="footer-section">
                        <h4 class="footer-title"><?php _e('footer.support_help'); ?></h4>
                        <ul class="footer-links">
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/support.php"><?php _e('support.help_center'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/faq.php"><?php _e('support.faq'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/live-chat.php"><?php _e('support.live_chat'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/contact.php"><?php _e('support.contact_us'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/responsible-gaming.php"><?php _e('support.responsible_gaming'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/security.php"><?php _e('support.security'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/guides.php"><?php _e('help.getting_started'); ?></a></li>
                        </ul>
                    </div>

                    <!-- Promotions -->
                    <div class="footer-section">
                        <h4 class="footer-title"><?php _e('footer.promotions'); ?></h4>
                        <ul class="footer-links">
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/promotions.php"><?php _e('nav.promotions'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/bonuses.php"><?php _e('bonuses.welcome_bonus'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/vip.php"><?php _e('nav.vip'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/loyalty.php"><?php _e('bonuses.loyalty_points'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/referral.php"><?php _e('bonuses.referral_program'); ?></a></li>
                            <li><a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/tournaments.php"><?php _e('nav.tournaments'); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Newsletter Section -->
            <div class="footer-newsletter">
                <div class="newsletter-content">
                    <div class="newsletter-text">
                        <h3><?php _e('newsletter.title'); ?></h3>
                        <p><?php _e('newsletter.description'); ?></p>
                        <div class="newsletter-benefits">
                            <div class="benefit-item">
                                <i class="fas fa-gift"></i>
                                <span><?php _e('newsletter.benefit_1'); ?></span>
                            </div>
                            <div class="benefit-item">
                                <i class="fas fa-bullhorn"></i>
                                <span><?php _e('newsletter.benefit_2'); ?></span>
                            </div>
                            <div class="benefit-item">
                                <i class="fas fa-chart-line"></i>
                                <span><?php _e('newsletter.benefit_3'); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="newsletter-form">
                        <form id="newsletterForm" class="newsletter-signup">
                            <div class="form-group">
                                <input type="email" 
                                       id="newsletterEmail" 
                                       placeholder="<?php _e('newsletter.email_placeholder'); ?>" 
                                       required>
                                <button type="submit" class="btn btn-primary">
                                    <?php _e('newsletter.subscribe'); ?>
                                    <i class="fas fa-arrow-right"></i>
                                </button>
                            </div>
                            <div class="newsletter-privacy">
                                <small>
                                    <i class="fas fa-shield-alt"></i>
                                    We respect your privacy. Unsubscribe at any time.
                                </small>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Payment Methods -->
            <div class="footer-payments">
                <div class="payments-section">
                    <h4>Accepted Cryptocurrencies</h4>
                    <div class="payment-methods">
                        <div class="payment-item">
                            <i class="fab fa-bitcoin"></i>
                            <span>Bitcoin</span>
                        </div>
                        <div class="payment-item">
                            <i class="fab fa-ethereum"></i>
                            <span>Ethereum</span>
                        </div>
                        <div class="payment-item">
                            <img src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/crypto/usdt.png" alt="USDT">
                            <span>USDT</span>
                        </div>
                        <div class="payment-item">
                            <img src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/crypto/bnb.png" alt="BNB">
                            <span>BNB</span>
                        </div>
                        <div class="payment-item">
                            <img src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/crypto/ada.png" alt="ADA">
                            <span>Cardano</span>
                        </div>
                        <div class="payment-item">
                            <img src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/crypto/dot.png" alt="DOT">
                            <span>Polkadot</span>
                        </div>
                        <div class="payment-item">
                            <img src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/crypto/ltc.png" alt="LTC">
                            <span>Litecoin</span>
                        </div>
                        <div class="payment-item">
                            <img src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/images/crypto/trx.png" alt="TRX">
                            <span>TRON</span>
                        </div>
                    </div>
                </div>

                <div class="security-badges">
                    <div class="badge-item">
                        <i class="fas fa-shield-alt"></i>
                        <span><?php _e('footer.ssl_secured'); ?></span>
                    </div>
                    <div class="badge-item">
                        <i class="fas fa-certificate"></i>
                        <span><?php _e('footer.fair_gaming'); ?></span>
                    </div>
                    <div class="badge-item">
                        <i class="fas fa-user-shield"></i>
                        <span>Licensed & Regulated</span>
                    </div>
                </div>
            </div>

            <!-- Social Media -->
            <div class="footer-social">
                <h4>Follow Us</h4>
                <div class="social-links">
                    <a href="https://twitter.com/crashify" target="_blank" class="social-link twitter">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <a href="https://facebook.com/crashify" target="_blank" class="social-link facebook">
                        <i class="fab fa-facebook"></i>
                    </a>
                    <a href="https://instagram.com/crashify" target="_blank" class="social-link instagram">
                        <i class="fab fa-instagram"></i>
                    </a>
                    <a href="https://youtube.com/crashify" target="_blank" class="social-link youtube">
                        <i class="fab fa-youtube"></i>
                    </a>
                    <a href="https://discord.gg/crashify" target="_blank" class="social-link discord">
                        <i class="fab fa-discord"></i>
                    </a>
                    <a href="https://t.me/crashify" target="_blank" class="social-link telegram">
                        <i class="fab fa-telegram"></i>
                    </a>
                </div>
            </div>

            <!-- Footer Bottom -->
            <div class="footer-bottom">
                <div class="footer-bottom-content">
                    <div class="footer-legal">
                        <div class="copyright">
                            <p>&copy; <?php echo date('Y'); ?> Crashify. <?php _e('footer.all_rights_reserved'); ?></p>
                            <p class="license-info"><?php _e('footer.license_info'); ?></p>
                        </div>
                        <div class="legal-links">
                            <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/terms.php"><?php _e('legal.terms_conditions'); ?></a>
                            <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/privacy.php"><?php _e('legal.privacy_policy'); ?></a>
                            <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/cookies.php"><?php _e('legal.cookie_policy'); ?></a>
                            <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/responsible-gaming.php"><?php _e('legal.responsible_gaming'); ?></a>
                            <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/aml.php"><?php _e('legal.aml_policy'); ?></a>
                            <a href="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'pages/kyc.php"><?php _e('legal.kyc_policy'); ?></a>
                        </div>
                    </div>

                    <div class="footer-age-verification">
                        <div class="age-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            <span><?php _e('footer.age_verification'); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Back to Top Button -->
    <button id="backToTop" class="back-to-top" onclick="scrollToTop()" style="display: none;">
        <i class="fas fa-arrow-up"></i>
    </button>

    <!-- Cookie Consent Banner -->
    <div id="cookieBanner" class="cookie-banner" style="display: none;">
        <div class="cookie-content">
            <div class="cookie-text">
                <i class="fas fa-cookie-bite"></i>
                <p><?php _e('cookies.consent_message'); ?></p>
            </div>
            <div class="cookie-actions">
                <button class="btn btn-outline btn-sm" onclick="showCookieSettings()">
                    <?php _e('cookies.settings'); ?>
                </button>
                <button class="btn btn-primary btn-sm" onclick="acceptCookies()">
                    <?php _e('cookies.accept_all'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- Cookie Settings Modal -->
    <div class="modal-backdrop" id="cookieSettingsModal">
        <div class="modal">
            <div class="modal-header">
                <h3 class="modal-title"><?php _e('cookies.settings'); ?></h3>
                <button class="modal-close" onclick="closeModal('cookieSettingsModal')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="cookie-categories">
                    <div class="cookie-category">
                        <div class="category-header">
                            <h4><?php _e('cookies.necessary'); ?></h4>
                            <label class="toggle-switch">
                                <input type="checkbox" checked disabled>
                                <span class="toggle-slider"></span>
                            </label>
                        </div>
                        <p>These cookies are essential for the website to function properly.</p>
                    </div>
                    
                    <div class="cookie-category">
                        <div class="category-header">
                            <h4><?php _e('cookies.analytics'); ?></h4>
                            <label class="toggle-switch">
                                <input type="checkbox" id="analyticsCookies">
                                <span class="toggle-slider"></span>
                            </label>
                        </div>
                        <p>These cookies help us understand how visitors interact with our website.</p>
                    </div>
                    
                    <div class="cookie-category">
                        <div class="category-header">
                            <h4><?php _e('cookies.marketing'); ?></h4>
                            <label class="toggle-switch">
                                <input type="checkbox" id="marketingCookies">
                                <span class="toggle-slider"></span>
                            </label>
                        </div>
                        <p>These cookies are used to deliver personalized advertisements.</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-outline" onclick="closeModal('cookieSettingsModal')">
                    <?php _e('common.cancel'); ?>
                </button>
                <button class="btn btn-primary" onclick="saveCookiePreferences()">
                    <?php _e('cookies.save_preferences'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/js/main.js"></script>
    <script src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/js/components.js"></script>
    <script src="<?php echo (defined('SITE_URL') ? SITE_URL : '') . '/'assets/js/betting.js"></script>
    
    <!-- Initialize -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize theme
            const savedTheme = localStorage.getItem('theme') || 'light';
            initializeTheme(savedTheme);
            
            // Initialize user session
            <?php if ($currentUser): ?>
            initializeUserSession(<?php echo json_encode($currentUser); ?>);
            <?php endif; ?>
            
            // Check cookie consent
            checkCookieConsent();
            
            // Hide loading screen
            hideLoadingScreen();
            
            // Initialize footer stats animation
            initializeFooterStats();
            
            // Initialize newsletter form
            initializeNewsletterForm();
        });

        // Footer stats animation
        function initializeFooterStats() {
            const stats = document.querySelectorAll('.stat-number[data-count]');
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        animateCounter(entry.target);
                        observer.unobserve(entry.target);
                    }
                });
            });
            
            stats.forEach(stat => observer.observe(stat));
        }

        function animateCounter(element) {
            const target = parseInt(element.dataset.count);
            const duration = 2000;
            const start = performance.now();
            
            function update(currentTime) {
                const elapsed = currentTime - start;
                const progress = Math.min(elapsed / duration, 1);
                const current = Math.floor(progress * target);
                
                element.textContent = current.toLocaleString();
                
                if (progress < 1) {
                    requestAnimationFrame(update);
                }
            }
            
            requestAnimationFrame(update);
        }

        // Newsletter form
        function initializeNewsletterForm() {
            const form = document.getElementById('newsletterForm');
            if (form) {
                form.addEventListener('submit', async (e) => {
                    e.preventDefault();
                    
                    const email = document.getElementById('newsletterEmail').value;
                    const submitBtn = form.querySelector('button[type="submit"]');
                    
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Subscribing...';
                    
                    try {
                        const response = await Crashify.api.request('/newsletter/subscribe', {
                            method: 'POST',
                            body: JSON.stringify({ email })
                        });
                        
                        if (response.success) {
                            Crashify.ui.toast.success('<?php _e("newsletter.subscribed"); ?>');
                            form.reset();
                        } else {
                            throw new Error(response.message);
                        }
                    } catch (error) {
                        Crashify.ui.toast.error(error.message || 'Subscription failed');
                    } finally {
                        submitBtn.disabled = false;
                        submitBtn.innerHTML = '<?php _e("newsletter.subscribe"); ?> <i class="fas fa-arrow-right"></i>';
                    }
                });
            }
        }

        // Cookie preferences
        function saveCookiePreferences() {
            const analytics = document.getElementById('analyticsCookies').checked;
            const marketing = document.getElementById('marketingCookies').checked;
            
            const preferences = {
                necessary: true,
                analytics: analytics,
                marketing: marketing
            };
            
            Crashify.utils.storage.set('cookiePreferences', preferences);
            Crashify.utils.storage.set('cookieConsent', true);
            
            closeModal('cookieSettingsModal');
            
            const banner = document.getElementById('cookieBanner');
            if (banner) {
                Crashify.utils.fadeOut(banner);
            }
            
            Crashify.ui.toast.success('Cookie preferences saved');
        }
    </script>

    <!-- Additional page-specific scripts -->
    <?php if (isset($additionalScripts)): ?>
        <?php foreach ($additionalScripts as $script): ?>
            <script src="<?php echo $script; ?>"></script>
        <?php endforeach; ?>
    <?php endif; ?>

    <!-- Inline scripts -->
    <?php if (isset($inlineScripts)): ?>
        <script>
            <?php echo $inlineScripts; ?>
        </script>
    <?php endif; ?>
</body>
</html>