<?php
require_once 'includes/header.php';

if (!$auth->isLoggedIn()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$user = $auth->getUser($user_id);
$vip_level = $user['vip_level'] ?? 0;
$vip_points = $user['vip_points'] ?? 0;

// محاسبه Cashback
$cashback_amount = $functions->calculateCashback($user_id);

// سطوح VIP
$vip_levels = [
    1 => ['points' => 1000, 'cashback' => '5%', 'benefits' => ['پشتیبانی優先', 'برداشت سریعتر']],
    2 => ['points' => 5000, 'cashback' => '7%', 'benefits' => ['بونوس های ویژه', 'محدودیت های بالاتر']],
    3 => ['points' => 15000, 'cashback' => '10%', 'benefits' => ['مدیر شخصی', 'هدایای ویژه']],
    4 => ['points' => 30000, 'cashback' => '12%', 'benefits' => ['شرایط خاص', 'رویدادهای انحصاری']],
    5 => ['points' => 50000, 'cashback' => '15%', 'benefits' => ['بالاترین مزایا', 'خدمات لوکس']]
];

// points مورد نیاز برای سطح بعدی
$next_level = $vip_level + 1;
$points_needed = isset($vip_levels[$next_level]) ? $vip_levels[$next_level]['points'] - $vip_points : 0;
?>

<div class="container">
    <div class="vip-container">
        <h1>برنامه VIP</h1>
        
        <div class="vip-status">
            <div class="vip-level">
                <h2>سطح فعلی: <?php echo $vip_level; ?></h2>
                <div class="level-progress">
                    <div class="progress-bar">
                        <div class="progress" style="width: <?php echo min(100, ($vip_points / ($vip_levels[$next_level]['points'] ?? 1)) * 100); ?>%"></div>
                    </div>
                    <div class="progress-text">
                        <span><?php echo $vip_points; ?> امتیاز</span>
                        <?php if ($next_level <= 5): ?>
                            <span><?php echo $vip_levels[$next_level]['points']; ?> امتیاز برای سطح <?php echo $next_level; ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <div class="cashback-info">
                <h3>Cashback هفته: $<?php echo number_format($cashback_amount, 2); ?></h3>
                <p>این مقدار بر اساس فعالیت هفته گذشته شما محاسبه شده است.</p>
            </div>
        </div>
        
        <div class="vip-benefits">
            <h2>مزایای VIP</h2>
            <div class="benefits-grid">
                <?php foreach ($vip_levels as $level => $data): ?>
                    <div class="benefit-card <?php echo $level <= $vip_level ? 'active' : ''; ?>">
                        <h3>سطح <?php echo $level; ?></h3>
                        <p class="points-needed"><?php echo $data['points']; ?> امتیاز</p>
                        <p class="cashback-percentage">Cashback: <?php echo $data['cashback']; ?></p>
                        <ul class="benefits-list">
                            <?php foreach ($data['benefits'] as $benefit): ?>
                                <li><?php echo $benefit; ?></li>
                            <?php endforeach; ?>
                        </ul>
                        <?php if ($level <= $vip_level): ?>
                            <span class="badge unlocked">قفل باز شده</span>
                        <?php else: ?>
                            <span class="badge locked">قفل شده</span>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <div class="vip-how-to">
            <h2>چگونه امتیاز VIP کسب کنیم؟</h2>
            <div class="how-to-content">
                <p>امتیازات VIP بر اساس فعالیت شما در سایت کسب می‌شود:</p>
                <ul>
                    <li>هر $1 شرط = 1 امتیاز</li>
                    <li>هر $1 برداشت = 2 امتیاز</li>
                    <li>هر دعوت موفق = 500 امتیاز</li>
                    <li>فعالیت روزانه = 10 امتیاز</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>