<?php
require_once 'includes/header.php';

if (!$auth->isLoggedIn()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// ارسال تیکت جدید
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['subject'])) {
    $subject = trim($_POST['subject']);
    $message = trim($_POST['message']);
    $priority = $_POST['priority'] ?? 'medium';
    
    if (!empty($subject) && !empty($message)) {
        $query = "INSERT INTO support_tickets (user_id, subject, message, priority) 
                  VALUES (:user_id, :subject, :message, :priority)";
        $stmt = $db->prepare($query);
        $stmt->bindParam(":user_id", $user_id);
        $stmt->bindParam(":subject", $subject);
        $stmt->bindParam(":message", $message);
        $stmt->bindParam(":priority", $priority);
        
        if ($stmt->execute()) {
            $ticket_id = $db->lastInsertId();
            $_SESSION['success'] = "تیکت پشتیبانی با موفقیت ایجاد شد.";
            header("Location: support.php?view=" . $ticket_id);
            exit;
        } else {
            $_SESSION['error'] = "خطا در ایجاد تیکت.";
        }
    } else {
        $_SESSION['error'] = "لطفا موضوع و پیام را وارد کنید.";
    }
}

// پاسخ به تیکت
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ticket_id'])) {
    $ticket_id = intval($_POST['ticket_id']);
    $message = trim($_POST['message']);
    
    if (!empty($message)) {
        // بررسی مالکیت تیکت
        $check_query = "SELECT id FROM support_tickets WHERE id = :ticket_id AND user_id = :user_id";
        $check_stmt = $db->prepare($check_query);
        $check_stmt->bindParam(":ticket_id", $ticket_id);
        $check_stmt->bindParam(":user_id", $user_id);
        $check_stmt->execute();
        
        if ($check_stmt->rowCount() > 0) {
            $is_admin = $auth->isAdmin() ? 1 : 0;
            
            $query = "INSERT INTO support_replies (ticket_id, user_id, message, is_admin) 
                      VALUES (:ticket_id, :user_id, :message, :is_admin)";
            $stmt = $db->prepare($query);
            $stmt->bindParam(":ticket_id", $ticket_id);
            $stmt->bindParam(":user_id", $user_id);
            $stmt->bindParam(":message", $message);
            $stmt->bindParam(":is_admin", $is_admin);
            
            if ($stmt->execute()) {
                // به روز رسانی وضعیت تیکت
                $update_query = "UPDATE support_tickets SET status = 'pending', updated_at = NOW() WHERE id = :ticket_id";
                $update_stmt = $db->prepare($update_query);
                $update_stmt->bindParam(":ticket_id", $ticket_id);
                $update_stmt->execute();
                
                $_SESSION['success'] = "پاسخ شما ارسال شد.";
                header("Location: support.php?view=" . $ticket_id);
                exit;
            } else {
                $_SESSION['error'] = "خطا در ارسال پاسخ.";
            }
        } else {
            $_SESSION['error'] = "تیکت یافت نشد.";
        }
    } else {
        $_SESSION['error'] = "لطفا پیام را وارد کنید.";
    }
}

// دریافت تیکت‌های کاربر
$query = "SELECT * FROM support_tickets WHERE user_id = :user_id ORDER BY created_at DESC";
$stmt = $db->prepare($query);
$stmt->bindParam(":user_id", $user_id);
$stmt->execute();
$tickets = $stmt->fetchAll();

// مشاهده تیکت خاص
$view_ticket = null;
$replies = [];
if (isset($_GET['view'])) {
    $ticket_id = intval($_GET['view']);
    
    $query = "SELECT * FROM support_tickets WHERE id = :ticket_id AND user_id = :user_id";
    $stmt = $db->prepare($query);
    $stmt->bindParam(":ticket_id", $ticket_id);
    $stmt->bindParam(":user_id", $user_id);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        $view_ticket = $stmt->fetch();
        
        // دریافت پاسخ‌ها
        $query = "SELECT sr.*, u.username 
                  FROM support_replies sr 
                  JOIN users u ON sr.user_id = u.id 
                  WHERE sr.ticket_id = :ticket_id 
                  ORDER BY sr.created_at ASC";
        $stmt = $db->prepare($query);
        $stmt->bindParam(":ticket_id", $ticket_id);
        $stmt->execute();
        $replies = $stmt->fetchAll();
    }
}
?>

<div class="container">
    <div class="support-container">
        <h1>پشتیبانی آنلاین</h1>
        
        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-error"><?php echo $_SESSION['error']; unset($_SESSION['error']); ?></div>
        <?php endif; ?>
        
        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success"><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></div>
        <?php endif; ?>
        
        <div class="support-content">
            <div class="tickets-list">
                <h2>تیکت‌های شما</h2>
                <button class="btn btn-primary" onclick="showNewTicketForm()">تیکت جدید</button>
                
                <div class="tickets">
                    <?php if (count($tickets) > 0): ?>
                        <?php foreach ($tickets as $ticket): ?>
                            <div class="ticket-item <?php echo $ticket['id'] == ($view_ticket['id'] ?? 0) ? 'active' : ''; ?>">
                                <a href="support.php?view=<?php echo $ticket['id']; ?>">
                                    <h3><?php echo htmlspecialchars($ticket['subject']); ?></h3>
                                    <p class="ticket-meta">
                                        <span class="status <?php echo $ticket['status']; ?>"><?php echo $ticket['status']; ?></span>
                                        <span class="priority <?php echo $ticket['priority']; ?>"><?php echo $ticket['priority']; ?></span>
                                        <span class="date"><?php echo date('Y-m-d H:i', strtotime($ticket['created_at'])); ?></span>
                                    </p>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p>هیچ تیکتی یافت نشد.</p>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="ticket-view">
                <?php if ($view_ticket): ?>
                    <div class="ticket-header">
                        <h2><?php echo htmlspecialchars($view_ticket['subject']); ?></h2>
                        <div class="ticket-info">
                            <span class="status <?php echo $view_ticket['status']; ?>"><?php echo $view_ticket['status']; ?></span>
                            <span class="priority <?php echo $view_ticket['priority']; ?>"><?php echo $view_ticket['priority']; ?></span>
                            <span class="date"><?php echo date('Y-m-d H:i', strtotime($view_ticket['created_at'])); ?></span>
                        </div>
                    </div>
                    
                    <div class="ticket-message">
                        <p><?php echo nl2br(htmlspecialchars($view_ticket['message'])); ?></p>
                    </div>
                    
                    <div class="ticket-replies">
                        <h3>پاسخ‌ها</h3>
                        <?php if (count($replies) > 0): ?>
                            <?php foreach ($replies as $reply): ?>
                                <div class="reply <?php echo $reply['is_admin'] ? 'admin-reply' : 'user-reply'; ?>">
                                    <div class="reply-header">
                                        <span class="user"><?php echo htmlspecialchars($reply['username']); ?></span>
                                        <span class="date"><?php echo date('Y-m-d H:i', strtotime($reply['created_at'])); ?></span>
                                        <?php if ($reply['is_admin']): ?>
                                            <span class="badge admin">ادمین</span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="reply-message">
                                        <p><?php echo nl2br(htmlspecialchars($reply['message'])); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <p>هیچ پاسخی وجود ندارد.</p>
                        <?php endif; ?>
                    </div>
                    
                    <div class="ticket-reply-form">
                        <h3>پاسخ دهید</h3>
                        <form method="POST">
                            <input type="hidden" name="ticket_id" value="<?php echo $view_ticket['id']; ?>">
                            <div class="form-group">
                                <textarea name="message" rows="5" placeholder="پیام شما..." required></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary">ارسال پاسخ</button>
                        </form>
                    </div>
                <?php else: ?>
                    <div class="no-ticket-selected">
                        <p>لطفا یک تیکت را برای مشاهده انتخاب کنید یا تیکت جدید ایجاد کنید.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <div id="newTicketForm" class="modal" style="display: none;">
            <div class="modal-content">
                <span class="close" onclick="hideNewTicketForm()">&times;</span>
                <h2>تیکت پشتیبانی جدید</h2>
                <form method="POST">
                    <div class="form-group">
                        <label>موضوع</label>
                        <input type="text" name="subject" required>
                    </div>
                    <div class="form-group">
                        <label>اولویت</label>
                        <select name="priority">
                            <option value="low">کم</option>
                            <option value="medium" selected>متوسط</option>
                            <option value="high">بالا</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>پیام</label>
                        <textarea name="message" rows="5" required></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">ارسال تیکت</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function showNewTicketForm() {
    document.getElementById('newTicketForm').style.display = 'block';
}

function hideNewTicketForm() {
    document.getElementById('newTicketForm').style.display = 'none';
}
</script>

<?php
require_once 'includes/footer.php';
?>