// مدیریت نمودارهای سایت
class ChartManager {
    constructor() {
        this.charts = {};
    }
    
    // ایجاد نمودار Crash
    initCrashChart(canvasId, gameData) {
        const ctx = document.getElementById(canvasId).getContext('2d');
        
        this.charts.crash = new Chart(ctx, {
            type: 'line',
            data: {
                datasets: [{
                    label: 'Multiplier',
                    data: gameData,
                    borderColor: '#4ecca3',
                    borderWidth: 3,
                    pointRadius: 0,
                    fill: false,
                    tension: 0.4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                animation: {
                    duration: 0
                },
                scales: {
                    x: {
                        type: 'linear',
                        display: false
                    },
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(255, 255, 255, 0.1)'
                        },
                        ticks: {
                            color: '#fff',
                            callback: function(value) {
                                return value + 'x';
                            }
                        }
                    }
                },
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        enabled: false
                    }
                }
            }
        });
        
        return this.charts.crash;
    }
    
    // به روز رسانی نمودار Crash
    updateCrashChart(multiplier, time) {
        if (this.charts.crash) {
            this.charts.crash.data.datasets[0].data.push({
                x: time,
                y: multiplier
            });
            
            this.charts.crash.update('none');
        }
    }
    
    // ایجاد نمودار آماری
    initStatsChart(canvasId, data, type = 'bar') {
        const ctx = document.getElementById(canvasId).getContext('2d');
        
        this.charts.stats = new Chart(ctx, {
            type: type,
            data: {
                labels: data.labels,
                datasets: [{
                    label: data.label,
                    data: data.values,
                    backgroundColor: '#4ecca3',
                    borderColor: '#4ecca3',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
        
        return this.charts.stats;
    }
    
    // ریست کردن نمودار
    resetChart(chartName) {
        if (this.charts[chartName]) {
            this.charts[chartName].data.datasets[0].data = [];
            this.charts[chartName].update();
        }
    }
    
    // تخریب نمودار
    destroyChart(chartName) {
        if (this.charts[chartName]) {
            this.charts[chartName].destroy();
            delete this.charts[chartName];
        }
    }
}

// نمونه‌ای از ChartManager
const chartManager = new ChartManager();

// تابع مقداردهی اولیه برای صفحاتی که نمودار دارند
function initCharts() {
    // نمودارهای صفحه اصلی
    if (document.getElementById('crashChart')) {
        chartManager.initCrashChart('crashChart', []);
    }
    
    // نمودارهای داشبورد
    if (document.getElementById('profitChart')) {
        const profitData = {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
            values: [12, 19, 3, 5, 2, 3],
            label: 'Profit'
        };
        chartManager.initStatsChart('profitChart', profitData, 'line');
    }
    
    // نمودارهای پنل مدیریت
    if (document.getElementById('userStatsChart')) {
        const userData = {
            labels: ['New', 'Active', 'Inactive', 'VIP'],
            values: [10, 15, 7, 5],
            label: 'Users'
        };
        chartManager.initStatsChart('userStatsChart', userData, 'doughnut');
    }
}

// مقداردهی اولیه هنگام لود صفحه
document.addEventListener('DOMContentLoaded', function() {
    initCharts();
});