<?php
require_once 'includes/header.php';

// شروع بازی جدید اگر لازم باشد
if (!isset($_SESSION['current_game']) || empty($_SESSION['current_game'])) {
    $game_data = $functions->startGame();
    $_SESSION['current_game'] = $game_data;
}

// دریافت بازی‌های اخیر
$recent_games = $functions->getRecentGames(10);
?>
<!-- قبل از بستن تگ body در index.php -->
<div class="bottom-nav">
    <div class="bottom-nav-container">
        <a href="<?php echo SITE_URL; ?>/index.php" class="bottom-nav-item active">
            <i class="fas fa-home"></i>
            <span>خانه</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/casino.php" class="bottom-nav-item">
            <i class="fas fa-dice"></i>
            <span>کازینو</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/sports.php" class="bottom-nav-item">
            <i class="fas fa-running"></i>
            <span>ورزشی</span>
        </a>
        <?php if ($auth->isLoggedIn()): ?>
            <a href="<?php echo SITE_URL; ?>/dashboard.php" class="bottom-nav-item">
                <i class="fas fa-user"></i>
                <span>پروفایل</span>
            </a>
        <?php else: ?>
            <a href="<?php echo SITE_URL; ?>/login.php" class="bottom-nav-item">
                <i class="fas fa-sign-in-alt"></i>
                <span>ورود</span>
            </a>
            <a href="<?php echo SITE_URL; ?>/register.php" class="bottom-nav-item">
                <i class="fas fa-user-plus"></i>
                <span>ثبت نام</span>
            </a>
        <?php endif; ?>
    </div>
</div>
<div class="container">
    <div class="game-container">
        <div class="game-header">
            <h1 data-translate="crash_game">Crash Game</h1>
            <div class="current-multiplier">1.00x</div>
        </div>
        
        <div class="game-chart">
            <canvas id="crashChart"></canvas>
        </div>
        
        <div class="game-controls">
            <?php if ($auth->isLoggedIn()): ?>
                <div class="bet-section">
                    <input type="number" id="betAmount" min="<?php echo MIN_BET; ?>" 
                           max="<?php echo MAX_BET; ?>" step="0.01" 
                           placeholder="<?php echo $translations['bet_amount']; ?>">
                    <input type="number" id="autoCashout" step="0.01" 
                           placeholder="<?php echo $translations['auto_cashout']; ?> (optional)">
                    <button id="placeBetBtn"><?php echo $translations['place_bet']; ?></button>
                    <button id="cashoutBtn" style="display: none;"><?php echo $translations['cashout']; ?></button>
                </div>
                
                <div class="user-stats">
                    <div class="stat">
                        <span data-translate="balance">Balance</span>: 
                        <strong>$<?php echo number_format($_SESSION['balance'], 2); ?></strong>
                    </div>
                    <div class="stat">
                        <span data-translate="active_bets">Active Bets</span>: 
                        <strong id="activeBets">0</strong>
                    </div>
                </div>
            <?php else: ?>
                <div class="login-prompt">
                    <p><?php echo $translations['login_to_play']; ?></p>
                    <div class="auth-buttons">
                        <a href="<?php echo SITE_URL; ?>/login.php" class="btn btn-primary"><?php echo $translations['login']; ?></a>
                        <a href="<?php echo SITE_URL; ?>/register.php" class="btn btn-secondary"><?php echo $translations['register']; ?></a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="game-history">
            <h3><?php echo $translations['recent_games']; ?></h3>
            <div class="history-list">
                <?php foreach ($recent_games as $game): ?>
                    <div class="history-item">
                        <span class="game-id">#<?php echo $game['id']; ?></span>
                        <span class="game-multiplier"><?php echo $game['crashed_at']; ?>x</span>
                        <span class="game-time"><?php echo date('H:i', strtotime($game['created_at'])); ?></span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <div class="live-bets">
            <h3>Live Bets</h3>
            <div class="bets-list" id="liveBets">
                <!-- لیست شرط‌های زنده -->
            </div>
        </div>
    </div>
</div>

<script src="<?php echo SITE_URL; ?>/public/js/crash.js"></script>
<script>
    const currentGameId = <?php echo $_SESSION['current_game']['game_id']; ?>;
    const currentMultiplier = <?php echo $_SESSION['current_game']['multiplier']; ?>;
    
    // مقداردهی اولیه بازی
    $(document).ready(function() {
        initGame(currentGameId, currentMultiplier);
    });
</script>

<?php
require_once 'includes/footer.php';
?>