<?php
require_once 'config.php';
require_once 'auth.php';

header('Content-Type: application/json');

$auth = new Auth();
$response = array('success' => false, 'message' => '');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $language = $_POST['language'] ?? '';
    
    // بررسی معتبر بودن زبان
    $allowed_languages = ['en', 'fa', 'ar', 'tr', 'de', 'fr'];
    if (in_array($language, $allowed_languages)) {
        $_SESSION['language'] = $language;
        
        // اگر کاربر لاگین کرده، زبان را در دیتابیس ذخیره کنید
        if ($auth->isLoggedIn()) {
            $user_id = $_SESSION['user_id'];
            $query = "UPDATE users SET language = :language WHERE id = :user_id";
            $stmt = $auth->db->prepare($query);
            $stmt->bindParam(":language", $language);
            $stmt->bindParam(":user_id", $user_id);
            $stmt->execute();
        }
        
        $response['success'] = true;
        $response['message'] = 'Language changed successfully';
    } else {
        $response['message'] = 'Invalid language';
    }
} else {
    $response['message'] = 'Invalid request method';
}

echo json_encode($response);
?>