<?php
require_once 'includes/header.php';

if (!$auth->isLoggedIn()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// دریافت پارامترهای صفحه‌بندی و فیلتر
$type = $_GET['type'] ?? '';
$page = $_GET['page'] ?? 1;
$limit = 20;
$offset = ($page - 1) * $limit;

// ساخت شرط‌های فیلتر
$conditions = ["user_id = :user_id"];
$params = [':user_id' => $user_id];

if (!empty($type)) {
    $conditions[] = "type = :type";
    $params[':type'] = $type;
}

// ترکیب شرط‌ها
$where = implode(' AND ', $conditions);

// دریافت تعداد کل تراکنش‌ها
$countQuery = "SELECT COUNT(*) as total FROM transactions WHERE $where";
$countStmt = $db->prepare($countQuery);
foreach ($params as $key => $value) {
    $countStmt->bindValue($key, $value);
}
$countStmt->execute();
$totalTransactions = $countStmt->fetch()['total'];
$totalPages = ceil($totalTransactions / $limit);

// دریافت تراکنش‌ها
$query = "SELECT * FROM transactions WHERE $where ORDER BY created_at DESC LIMIT :limit OFFSET :offset";
$stmt = $db->prepare($query);
foreach ($params as $key => $value) {
    $stmt->bindValue($key, $value);
}
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$transactions = $stmt->fetchAll();
?>

<div class="container">
    <div class="history-container">
        <h1 data-translate="history">History</h1>
        
        <div class="filters">
            <form method="GET" class="filter-form">
                <div class="form-group">
                    <label for="type" data-translate="type">Type</label>
                    <select id="type" name="type">
                        <option value="">همه انواع</option>
                        <option value="deposit" <?php echo $type == 'deposit' ? 'selected' : ''; ?> data-translate="deposit">Deposit</option>
                        <option value="withdraw" <?php echo $type == 'withdraw' ? 'selected' : ''; ?> data-translate="withdraw">Withdraw</option>
                        <option value="bet" <?php echo $type == 'bet' ? 'selected' : ''; ?> data-translate="bet">Bet</option>
                        <option value="win" <?php echo $type == 'win' ? 'selected' : ''; ?> data-translate="win">Win</option>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-primary" data-translate="apply_filter">Apply Filter</button>
                <a href="history.php" class="btn btn-secondary" data-translate="clear_filter">Clear Filter</a>
            </form>
        </div>
        
        <div class="transactions-list">
            <?php if (count($transactions) > 0): ?>
                <table class="transactions-table">
                    <thead>
                        <tr>
                            <th data-translate="type">Type</th>
                            <th data-translate="amount">Amount</th>
                            <th data-translate="status">Status</th>
                            <th data-translate="details">Details</th>
                            <th data-translate="date">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transactions as $transaction): ?>
                        <tr>
                            <td>
                                <?php 
                                $typeLabels = [
                                    'deposit' => 'واریز',
                                    'withdraw' => 'برداشت',
                                    'bet' => 'شرط',
                                    'win' => 'برد'
                                ];
                                echo $typeLabels[$transaction['type']] ?? $transaction['type'];
                                ?>
                            </td>
                            <td class="<?php echo $transaction['type'] == 'deposit' || $transaction['type'] == 'win' ? 'text-profit' : 'text-loss'; ?>">
                                $<?php echo number_format($transaction['amount'], 2); ?>
                            </td>
                            <td>
                                <span class="status-<?php echo $transaction['status']; ?>">
                                    <?php 
                                    $statusLabels = [
                                        'pending' => 'در انتظار',
                                        'completed' => 'تکمیل شده',
                                        'cancelled' => 'لغو شده'
                                    ];
                                    echo $statusLabels[$transaction['status']];
                                    ?>
                                </span>
                            </td>
                            <td><?php echo htmlspecialchars($transaction['details']); ?></td>
                            <td><?php echo date('Y-m-d H:i', strtotime($transaction['created_at'])); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                
                <!-- صفحه‌بندی -->
                <?php if ($totalPages > 1): ?>
                <div class="pagination">
                    <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                        <a href="?page=<?php echo $i; ?>&type=<?php echo urlencode($type); ?>" 
                           class="<?php echo $i == $page ? 'active' : ''; ?>">
                            <?php echo $i; ?>
                        </a>
                    <?php endfor; ?>
                </div>
                <?php endif; ?>
            <?php else: ?>
                <p class="no-data" data-translate="no_transactions">No transactions found.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>