<?php
require_once 'includes/header.php';

if ($auth->isLoggedIn()) {
    header("Location: dashboard.php");
    exit;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);
    $confirm_password = trim($_POST['confirm_password']);
    
    if (empty($username) || empty($email) || empty($password) || empty($confirm_password)) {
        $error = "لطفا تمام فیلدها را پر کنید.";
    } elseif ($password !== $confirm_password) {
        $error = "رمز عبور و تکرار آن مطابقت ندارند.";
    } elseif (strlen($password) < 6) {
        $error = "رمز عبور باید حداقل 6 کاراکتر باشد.";
    } else {
        if ($auth->register($username, $email, $password)) {
            $success = "حساب کاربری با موفقیت ایجاد شد. لطفا وارد شوید.";
        } else {
            $error = "نام کاربری یا ایمیل از قبل وجود دارد.";
        }
    }
}
?>

<div class="container">
    <div class="form-container">
        <h2 data-translate="register">Register</h2>
        
        <?php if (!empty($error)): ?>
            <div class="alert alert-error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if (!empty($success)): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label for="username" data-translate="username">Username</label>
                <input type="text" id="username" name="username" required>
            </div>
            
            <div class="form-group">
                <label for="email" data-translate="email">Email</label>
                <input type="email" id="email" name="email" required>
            </div>
            
            <div class="form-group">
                <label for="password" data-translate="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>
            
            <div class="form-group">
                <label for="confirm_password" data-translate="confirm_password">Confirm Password</label>
                <input type="password" id="confirm_password" name="confirm_password" required>
            </div>
            
            <div class="form-group">
                <label>
                    <input type="checkbox" name="terms" required>
                    <span data-translate="accept_terms">I accept the terms and conditions</span>
                </label>
            </div>
            
            <button type="submit" class="form-button" data-translate="register">Register</button>
        </form>
        
        <div class="form-footer">
            <p>
                <span data-translate="have_account">Already have an account?</span>
                <a href="login.php" data-translate="login">Login</a>
            </p>
        </div>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>