// مدیریت تغییر زبان
$(document).ready(function() {
    $('#languageSelector').change(function() {
        const language = $(this).val();
        
        $.ajax({
            url: 'includes/change_language.php',
            type: 'POST',
            data: { language: language },
            success: function(response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert('Error changing language');
                }
            },
            error: function() {
                alert('Error changing language');
            }
        });
    });
    
    // مدیریت فرم‌ها
    $('form').on('submit', function(e) {
        const form = $(this);
        const button = form.find('button[type="submit"]');
        const originalText = button.text();
        
        button.prop('disabled', true).text('Loading...');
        
        // اگر فرم از پیش اعتبارسنجی نشده باشد
        if (!form[0].checkValidity()) {
            form[0].reportValidity();
            button.prop('disabled', false).text(originalText);
            e.preventDefault();
            return false;
        }
    });
    
    // نمایش نوتیفیکیشن
    function showNotification(message, type = 'success') {
        const notification = $('<div class="notification"></div>');
        notification.text(message);
        notification.addClass(type);
        
        $('body').append(notification);
        
        // نمایش انیمیشن
        notification.animate({ top: '20px' }, 300);
        
        // حذف خودکار بعد از 3 ثانیه
        setTimeout(function() {
            notification.animate({ top: '-100px' }, 300, function() {
                notification.remove();
            });
        }, 3000);
    }
    
    // مدیریت کلیک خارج از منو
    $(document).click(function(e) {
        if (!$(e.target).closest('.dropdown').length) {
            $('.dropdown-content').hide();
        }
    });
});