// اسکریپت‌های مخصوص پنل مدیریت
class AdminManager {
    constructor() {
        this.init();
    }
    
    // مقداردهی اولیه
    init() {
        this.setupDataTables();
        this.setupForms();
        this.setupModals();
        this.loadStats();
    }
    
    // راه‌اندازی جداول داده
    setupDataTables() {
        // استفاده از DataTables برای جدول‌ها (اگر کتابخانه موجود باشد)
        if (typeof $.fn.DataTable === 'function') {
            $('.data-table').DataTable({
                pageLength: 25,
                language: {
                    search: "جستجو:",
                    lengthMenu: "نمایش _MENU_ رکورد در صفحه",
                    info: "نمایش _START_ تا _END_ از _TOTAL_ رکورد",
                    infoEmpty: "هیچ رکوردی یافت نشد",
                    paginate: {
                        first: "اولین",
                        last: "آخرین",
                        next: "بعدی",
                        previous: "قبلی"
                    }
                }
            });
        }
    }
    
    // راه‌اندازی فرم‌ها
    setupForms() {
        // اعتبارسنجی فرم‌ها
        $('form').on('submit', function(e) {
            const form = $(this);
            if (!form[0].checkValidity()) {
                e.preventDefault();
                e.stopPropagation();
            }
            form.addClass('was-validated');
        });
        
        // مدیریت فرم حذف
        $('.delete-form').on('submit', function(e) {
            e.preventDefault();
            const form = $(this);
            const message = form.data('confirm') || 'آیا از حذف این آیتم اطمینان دارید؟';
            
            if (confirm(message)) {
                form.off('submit').submit();
            }
        });
    }
    
    // راه‌اندازی مودال‌ها
    setupModals() {
        // مدیریت مودال‌های بوت‌استرپ (اگر موجود باشد)
        if (typeof $.fn.modal === 'function') {
            $('.modal').modal({
                backdrop: 'static',
                keyboard: false
            });
        }
        
        // باز کردن مودال ویرایش
        $('.edit-btn').on('click', function() {
            const id = $(this).data('id');
            $('#editModal').modal('show');
            // بارگذاری اطلاعات آیتم انتخاب شده
            loadEditData(id);
        });
    }
    
    // بارگذاری آمار
    loadStats() {
        $.ajax({
            url: 'admin/get_stats.php',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    this.updateStats(data.stats);
                }
            }.bind(this),
            error: function() {
                console.error('Error loading stats');
            }
        });
    }
    
    // به روز رسانی آمار
    updateStats(stats) {
        $('#totalUsers').text(stats.total_users);
        $('#activeUsers').text(stats.active_users);
        $('#totalDeposits').text('$' + stats.total_deposits);
        $('#totalWithdrawals').text('$' + stats.total_withdrawals);
        $('#totalBets').text(stats.total_bets);
        $('#totalProfit').text('$' + stats.total_profit);
    }
    
    // بارگذاری اطلاعات برای ویرایش
    loadEditData(id) {
        $.ajax({
            url: 'admin/get_item.php',
            type: 'GET',
            data: { id: id, type: $('#editModal').data('type') },
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    this.populateEditForm(data.item);
                }
            }.bind(this),
            error: function() {
                console.error('Error loading item data');
            }
        });
    }
    
    // پر کردن فرم ویرایش
    populateEditForm(item) {
        const form = $('#editForm');
        $.each(item, function(key, value) {
            const input = form.find('[name="' + key + '"]');
            if (input.length) {
                input.val(value);
            }
        });
    }
    
    // مدیریت وضعیت کاربران
    toggleUserStatus(userId, status) {
        $.ajax({
            url: 'admin/toggle_user_status.php',
            type: 'POST',
            data: { user_id: userId, status: status },
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    this.showAlert('وضعیت کاربر با موفقیت تغییر کرد', 'success');
                    // به روز رسانی جدول
                    this.refreshUsersTable();
                } else {
                    this.showAlert('خطا در تغییر وضعیت کاربر', 'error');
                }
            }.bind(this),
            error: function() {
                this.showAlert('خطا در تغییر وضعیت کاربر', 'error');
            }.bind(this)
        });
    }
    
    // نمایش اعلان
    showAlert(message, type = 'info') {
        // ایجاد اعلان
        const alert = $('<div class="alert alert-' + type + ' alert-dismissible fade show" role="alert">' +
            message +
            '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>' +
            '</div>');
        
        // افزودن به صفحه
        $('#alertsContainer').append(alert);
        
        // حذف خودکار بعد از 5 ثانیه
        setTimeout(function() {
            alert.alert('close');
        }, 5000);
    }
    
    // به روز رسانی جدول کاربران
    refreshUsersTable() {
        $.ajax({
            url: 'admin/users_table.php',
            type: 'GET',
            success: function(data) {
                $('#usersTable').html(data);
                this.setupDataTables();
            }.bind(this),
            error: function() {
                this.showAlert('خطا در به روز رسانی جدول', 'error');
            }.bind(this)
        });
    }
}

// مقداردهی اولیه هنگام لود صفحه
document.addEventListener('DOMContentLoaded', function() {
    if (document.querySelector('.admin-container')) {
        const adminManager = new AdminManager();
    }
});