<?php
require_once 'db.php';

class Auth {
    private $db;
    
    public function __construct() {
        $this->db = (new Database())->getConnection();
    }
    
    // ثبت کاربر جدید
    public function register($username, $email, $password) {
        // بررسی وجود کاربر
        $query = "SELECT id FROM users WHERE username = :username OR email = :email";
        $stmt = $this->db->prepare($query);
        $stmt->bindParam(":username", $username);
        $stmt->bindParam(":email", $email);
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            return false; // کاربر از قبل وجود دارد
        }
        
        // هش کردن رمز عبور
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        
        // ایجاد کاربر جدید
        $query = "INSERT INTO users (username, email, password, created_at) 
                  VALUES (:username, :email, :password, NOW())";
        $stmt = $this->db->prepare($query);
        $stmt->bindParam(":username", $username);
        $stmt->bindParam(":email", $email);
        $stmt->bindParam(":password", $hashed_password);
        
        if ($stmt->execute()) {
            return true;
        }
        return false;
    }
    
    // ورود کاربر
    public function login($username, $password) {
        $query = "SELECT id, username, password, email, balance, is_admin, language 
                  FROM users WHERE username = :username AND is_blocked = 0";
        $stmt = $this->db->prepare($query);
        $stmt->bindParam(":username", $username);
        $stmt->execute();
        
        if ($stmt->rowCount() == 1) {
            $user = $stmt->fetch();
            if (password_verify($password, $user['password'])) {
                // به روز رسانی آخرین زمان ورود
                $update_query = "UPDATE users SET last_login = NOW() WHERE id = :id";
                $update_stmt = $this->db->prepare($update_query);
                $update_stmt->bindParam(":id", $user['id']);
                $update_stmt->execute();
                
                // تنظیم session
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['email'] = $user['email'];
                $_SESSION['balance'] = $user['balance'];
                $_SESSION['is_admin'] = $user['is_admin'];
                $_SESSION['language'] = $user['language'];
                
                return true;
            }
        }
        return false;
    }
    
    // بررسی لاگین بودن کاربر
    public function isLoggedIn() {
        return isset($_SESSION['user_id']);
    }
    
    // بررسی ادمین بودن کاربر
    public function isAdmin() {
        return isset($_SESSION['is_admin']) && $_SESSION['is_admin'] == 1;
    }
    
    // خروج کاربر
    public function logout() {
        $_SESSION = array();
        session_destroy();
    }
    
    // به روز رسانی موجودی کاربر
    public function updateBalance($user_id, $amount) {
        $query = "UPDATE users SET balance = balance + :amount WHERE id = :user_id";
        $stmt = $this->db->prepare($query);
        $stmt->bindParam(":amount", $amount);
        $stmt->bindParam(":user_id", $user_id);
        return $stmt->execute();
    }
    
    // دریافت اطلاعات کاربر
    public function getUser($user_id) {
        $query = "SELECT id, username, email, balance, created_at, last_login, language 
                  FROM users WHERE id = :user_id";
        $stmt = $this->db->prepare($query);
        $stmt->bindParam(":user_id", $user_id);
        $stmt->execute();
        return $stmt->fetch();
    }
}
?>