<?php
require_once 'header.php';

// بررسی دسترسی ادمین
if (!$auth->isAdmin()) {
    header("Location: login.php");
    exit;
}

// دریافت پارامترهای جستجو و فیلتر
$search = $_GET['search'] ?? '';
$status = $_GET['status'] ?? '';
$page = $_GET['page'] ?? 1;
$limit = 20;
$offset = ($page - 1) * $limit;

// ساخت شرط‌های جستجو
$conditions = [];
$params = [];

if (!empty($search)) {
    $conditions[] = "(username LIKE :search OR email LIKE :search)";
    $params[':search'] = "%$search%";
}

if (!empty($status)) {
    $conditions[] = "is_blocked = :status";
    $params[':status'] = ($status == 'blocked') ? 1 : 0;
}

// ترکیب شرط‌ها
$where = '';
if (!empty($conditions)) {
    $where = 'WHERE ' . implode(' AND ', $conditions);
}

// دریافت تعداد کل کاربران
$countQuery = "SELECT COUNT(*) as total FROM users $where";
$countStmt = $db->prepare($countQuery);
foreach ($params as $key => $value) {
    $countStmt->bindValue($key, $value);
}
$countStmt->execute();
$totalUsers = $countStmt->fetch()['total'];
$totalPages = ceil($totalUsers / $limit);

// دریافت لیست کاربران
$query = "SELECT id, username, email, balance, is_blocked, is_admin, created_at, last_login 
          FROM users $where 
          ORDER BY created_at DESC 
          LIMIT :limit OFFSET :offset";
$stmt = $db->prepare($query);
foreach ($params as $key => $value) {
    $stmt->bindValue($key, $value);
}
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$users = $stmt->fetchAll();
?>

<div class="admin-content">
    <h1>مدیریت کاربران</h1>
    
    <div class="filters">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <input type="text" name="search" class="form-control" placeholder="جستجوی کاربر..." value="<?php echo htmlspecialchars($search); ?>">
            </div>
            <div class="col-md-3">
                <select name="status" class="form-select">
                    <option value="">همه وضعیت‌ها</option>
                    <option value="active" <?php echo $status == 'active' ? 'selected' : ''; ?>>فعال</option>
                    <option value="blocked" <?php echo $status == 'blocked' ? 'selected' : ''; ?>>مسدود شده</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-primary">اعمال فیلتر</button>
            </div>
            <div class="col-md-3 text-end">
                <a href="users.php" class="btn btn-secondary">پاک کردن فیلترها</a>
            </div>
        </form>
    </div>
    
    <div class="table-responsive">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>نام کاربری</th>
                    <th>ایمیل</th>
                    <th>موجودی</th>
                    <th>وضعیت</th>
                    <th>تاریخ ثبت‌نام</th>
                    <th>آخرین ورود</th>
                    <th>عملیات</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $user): ?>
                <tr>
                    <td><?php echo $user['id']; ?></td>
                    <td><?php echo htmlspecialchars($user['username']); ?></td>
                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                    <td>$<?php echo number_format($user['balance'], 2); ?></td>
                    <td>
                        <?php if ($user['is_blocked']): ?>
                            <span class="badge bg-danger">مسدود شده</span>
                        <?php else: ?>
                            <span class="badge bg-success">فعال</span>
                        <?php endif; ?>
                        
                        <?php if ($user['is_admin']): ?>
                            <span class="badge bg-primary">ادمین</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo date('Y-m-d H:i', strtotime($user['created_at'])); ?></td>
                    <td><?php echo $user['last_login'] ? date('Y-m-d H:i', strtotime($user['last_login'])) : 'Never'; ?></td>
                    <td>
                        <div class="btn-group">
                            <a href="user_edit.php?id=<?php echo $user['id']; ?>" class="btn btn-sm btn-primary">ویرایش</a>
                            <button type="button" class="btn btn-sm btn-<?php echo $user['is_blocked'] ? 'success' : 'warning'; ?>" 
                                onclick="toggleUserStatus(<?php echo $user['id']; ?>, <?php echo $user['is_blocked'] ? 0 : 1; ?>)">
                                <?php echo $user['is_blocked'] ? 'آزاد کردن' : 'مسدود کردن'; ?>
                            </button>
                            <button type="button" class="btn btn-sm btn-danger" 
                                onclick="confirmDelete(<?php echo $user['id']; ?>)">
                                حذف
                            </button>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <!-- صفحه‌بندی -->
    <?php if ($totalPages > 1): ?>
    <nav>
        <ul class="pagination">
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                    <a class="page-link" href="?page=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>&status=<?php echo urlencode($status); ?>">
                        <?php echo $i; ?>
                    </a>
                </li>
            <?php endfor; ?>
        </ul>
    </nav>
    <?php endif; ?>
</div>

<script>
function toggleUserStatus(userId, status) {
    if (confirm('آیا از تغییر وضعیت کاربر اطمینان دارید؟')) {
        $.ajax({
            url: 'toggle_user_status.php',
            type: 'POST',
            data: {
                user_id: userId,
                status: status
            },
            success: function(response) {
                if (response.success) {
                    alert('وضعیت کاربر با موفقیت تغییر کرد');
                    location.reload();
                } else {
                    alert('خطا در تغییر وضعیت کاربر');
                }
            },
            error: function() {
                alert('خطا در تغییر وضعیت کاربر');
            }
        });
    }
}

function confirmDelete(userId) {
    if (confirm('آیا از حذف این کاربر اطمینان دارید؟ این عمل غیرقابل بازگشت است.')) {
        $.ajax({
            url: 'delete_user.php',
            type: 'POST',
            data: {
                user_id: userId
            },
            success: function(response) {
                if (response.success) {
                    alert('کاربر با موفقیت حذف شد');
                    location.reload();
                } else {
                    alert('خطا در حذف کاربر');
                }
            },
            error: function() {
                alert('خطا در حذف کاربر');
            }
        });
    }
}
</script>

<?php
require_once 'footer.php';
?>