<?php
require_once 'header.php';

// بررسی دسترسی ادمین
if (!$auth->isAdmin()) {
    header("Location: login.php");
    exit;
}

// دریافت پارامترهای جستجو و فیلتر
$type = $_GET['type'] ?? '';
$status = $_GET['status'] ?? '';
$search = $_GET['search'] ?? '';
$page = $_GET['page'] ?? 1;
$limit = 20;
$offset = ($page - 1) * $limit;

// ساخت شرط‌های جستجو
$conditions = [];
$params = [];

if (!empty($type)) {
    $conditions[] = "type = :type";
    $params[':type'] = $type;
}

if (!empty($status)) {
    $conditions[] = "status = :status";
    $params[':status'] = $status;
}

if (!empty($search)) {
    $conditions[] = "(u.username LIKE :search OR u.email LIKE :search OR t.details LIKE :search)";
    $params[':search'] = "%$search%";
}

// ترکیب شرط‌ها
$where = '';
if (!empty($conditions)) {
    $where = 'WHERE ' . implode(' AND ', $conditions);
}

// دریافت تعداد کل تراکنش‌ها
$countQuery = "SELECT COUNT(*) as total FROM transactions t 
               LEFT JOIN users u ON t.user_id = u.id 
               $where";
$countStmt = $db->prepare($countQuery);
foreach ($params as $key => $value) {
    $countStmt->bindValue($key, $value);
}
$countStmt->execute();
$totalTransactions = $countStmt->fetch()['total'];
$totalPages = ceil($totalTransactions / $limit);

// دریافت لیست تراکنش‌ها
$query = "SELECT t.*, u.username, u.email 
          FROM transactions t 
          LEFT JOIN users u ON t.user_id = u.id 
          $where 
          ORDER BY t.created_at DESC 
          LIMIT :limit OFFSET :offset";
$stmt = $db->prepare($query);
foreach ($params as $key => $value) {
    $stmt->bindValue($key, $value);
}
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$transactions = $stmt->fetchAll();
?>

<div class="admin-content">
    <h1>مدیریت تراکنش‌ها</h1>
    
    <div class="filters">
        <form method="GET" class="row g-3">
            <div class="col-md-3">
                <select name="type" class="form-select">
                    <option value="">همه انواع</option>
                    <option value="deposit" <?php echo $type == 'deposit' ? 'selected' : ''; ?>>واریز</option>
                    <option value="withdraw" <?php echo $type == 'withdraw' ? 'selected' : ''; ?>>برداشت</option>
                    <option value="bet" <?php echo $type == 'bet' ? 'selected' : ''; ?>>شرط</option>
                    <option value="win" <?php echo $type == 'win' ? 'selected' : ''; ?>>برد</option>
                </select>
            </div>
            <div class="col-md-3">
                <select name="status" class="form-select">
                    <option value="">همه وضعیت‌ها</option>
                    <option value="pending" <?php echo $status == 'pending' ? 'selected' : ''; ?>>در انتظار</option>
                    <option value="completed" <?php echo $status == 'completed' ? 'selected' : ''; ?>>تکمیل شده</option>
                    <option value="cancelled" <?php echo $status == 'cancelled' ? 'selected' : ''; ?>>لغو شده</option>
                </select>
            </div>
            <div class="col-md-4">
                <input type="text" name="search" class="form-control" placeholder="جستجوی کاربر یا جزئیات..." value="<?php echo htmlspecialchars($search); ?>">
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-primary">اعمال فیلتر</button>
            </div>
        </form>
    </div>
    
    <div class="table-responsive">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>کاربر</th>
                    <th>نوع</th>
                    <th>مبلغ</th>
                    <th>وضعیت</th>
                    <th>جزئیات</th>
                    <th>تاریخ</th>
                    <th>عملیات</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactions as $transaction): ?>
                <tr>
                    <td><?php echo $transaction['id']; ?></td>
                    <td>
                        <?php echo htmlspecialchars($transaction['username']); ?><br>
                        <small><?php echo htmlspecialchars($transaction['email']); ?></small>
                    </td>
                    <td>
                        <?php 
                        $typeLabels = [
                            'deposit' => 'واریز',
                            'withdraw' => 'برداشت',
                            'bet' => 'شرط',
                            'win' => 'برد'
                        ];
                        echo $typeLabels[$transaction['type']] ?? $transaction['type'];
                        ?>
                    </td>
                    <td>$<?php echo number_format($transaction['amount'], 2); ?></td>
                    <td>
                        <?php 
                        $statusLabels = [
                            'pending' => 'در انتظار',
                            'completed' => 'تکمیل شده',
                            'cancelled' => 'لغو شده'
                        ];
                        $statusClass = [
                            'pending' => 'warning',
                            'completed' => 'success',
                            'cancelled' => 'danger'
                        ];
                        ?>
                        <span class="badge bg-<?php echo $statusClass[$transaction['status']]; ?>">
                            <?php echo $statusLabels[$transaction['status']]; ?>
                        </span>
                    </td>
                    <td><?php echo htmlspecialchars($transaction['details']); ?></td>
                    <td><?php echo date('Y-m-d H:i', strtotime($transaction['created_at'])); ?></td>
                    <td>
                        <div class="btn-group">
                            <?php if ($transaction['status'] == 'pending' && $transaction['type'] == 'withdraw'): ?>
                                <button type="button" class="btn btn-sm btn-success" 
                                    onclick="approveTransaction(<?php echo $transaction['id']; ?>)">
                                    تأیید
                                </button>
                                <button type="button" class="btn btn-sm btn-danger" 
                                    onclick="rejectTransaction(<?php echo $transaction['id']; ?>)">
                                    رد
                                </button>
                            <?php endif; ?>
                            
                            <?php if ($transaction['status'] == 'pending' && $transaction['type'] == 'deposit'): ?>
                                <button type="button" class="btn btn-sm btn-success" 
                                    onclick="approveTransaction(<?php echo $transaction['id']; ?>)">
                                    تأیید
                                </button>
                            <?php endif; ?>
                            
                            <button type="button" class="btn btn-sm btn-info" 
                                onclick="viewTransactionDetails(<?php echo $transaction['id']; ?>)">
                                جزئیات
                            </button>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <!-- صفحه‌بندی -->
    <?php if ($totalPages > 1): ?>
    <nav>
        <ul class="pagination">
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                    <a class="page-link" href="?page=<?php echo $i; ?>&type=<?php echo urlencode($type); ?>&status=<?php echo urlencode($status); ?>&search=<?php echo urlencode($search); ?>">
                        <?php echo $i; ?>
                    </a>
                </li>
            <?php endfor; ?>
        </ul>
    </nav>
    <?php endif; ?>
</div>

<script>
function approveTransaction(transactionId) {
    if (confirm('آیا از تأیید این تراکنش اطمینان دارید؟')) {
        $.ajax({
            url: 'approve_transaction.php',
            type: 'POST',
            data: {
                transaction_id: transactionId
            },
            success: function(response) {
                if (response.success) {
                    alert('تراکنش با موفقیت تأیید شد');
                    location.reload();
                } else {
                    alert('خطا در تأیید تراکنش');
                }
            },
            error: function() {
                alert('خطا در تأیید تراکنش');
            }
        });
    }
}

function rejectTransaction(transactionId) {
    if (confirm('آیا از رد این تراکنش اطمینان دارید؟')) {
        $.ajax({
            url: 'reject_transaction.php',
            type: 'POST',
            data: {
                transaction_id: transactionId
            },
            success: function(response) {
                if (response.success) {
                    alert('تراکنش با موفقیت رد شد');
                    location.reload();
                } else {
                    alert('خطا در رد تراکنش');
                }
            },
            error: function() {
                alert('خطا در رد تراکنش');
            }
        });
    }
}

function viewTransactionDetails(transactionId) {
    // باز کردن مودال با جزئیات تراکنش
    $('#transactionDetailsModal').modal('show');
    
    // بارگذاری جزئیات تراکنش
    $.ajax({
        url: 'get_transaction_details.php',
        type: 'GET',
        data: {
            transaction_id: transactionId
        },
        success: function(response) {
            if (response.success) {
                $('#transactionDetails').html(response.html);
            } else {
                $('#transactionDetails').html('خطا در بارگذاری جزئیات');
            }
        },
        error: function() {
            $('#transactionDetails').html('خطا در بارگذاری جزئیات');
        }
    });
}
</script>

<!-- مودال جزئیات تراکنش -->
<div class="modal fade" id="transactionDetailsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">جزئیات تراکنش</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="transactionDetails">
                در حال بارگذاری...
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">بستن</button>
            </div>
        </div>
    </div>
</div>

<?php
require_once 'footer.php';
?>