<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

$auth = new Auth();

if ($auth->isLoggedIn() && $auth->isAdmin()) {
    header("Location: index.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    
    if (!empty($username) && !empty($password)) {
        // بررسی با مقادیر ثابت به جای بررسی در دیتابیس
        if ($username === 'tiam1017#' && $password === 'tiam1017#') {
            // ایجاد session برای کاربر
            $_SESSION['user'] = [
                'username' => 'tiam1017#',
                'is_admin' => true
            ];
            
            header("Location: index.php");
            exit;
        } else {
            $error = "نام کاربری یا رمز عبور اشتباه است.";
        }
    } else {
        $error = "لطفا تمام فیلدها را پر کنید.";
    }
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ورود ادمین - Crashify</title>
    <link rel="stylesheet" href="../public/css/style.css">
    <style>
        .admin-login {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
        }
        
        .admin-login-container {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 15px;
            padding: 30px;
            width: 100%;
            max-width: 400px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .admin-login h2 {
            text-align: center;
            margin-bottom: 20px;
            color: #4ecca3;
        }
        
        .admin-login .form-group {
            margin-bottom: 20px;
        }
        
        .admin-login .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        
        .admin-login .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: none;
            border-radius: 5px;
            background: rgba(255, 255, 255, 0.1);
            color: #fff;
            font-size: 16px;
        }
        
        .admin-login .form-group input:focus {
            outline: 2px solid #4ecca3;
        }
        
        .admin-login .btn {
            width: 100%;
            padding: 12px;
            border: none;
            border-radius: 5px;
            background: #4ecca3;
            color: #1a1a2e;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: background 0.3s;
        }
        
        .admin-login .btn:hover {
            background: #3bb992;
        }
        
        .admin-login .error {
            color: #e94560;
            text-align: center;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <div class="admin-login">
        <div class="admin-login-container">
            <h2>ورود به پنل مدیریت</h2>
            
            <?php if (!empty($error)): ?>
                <div class="error"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-group">
                    <label for="username">نام کاربری</label>
                    <input type="text" id="username" name="username" required>
                </div>
                
                <div class="form-group">
                    <label for="password">رمز عبور</label>
                    <input type="password" id="password" name="password" required>
                </div>
                
                <button type="submit" class="btn">ورود</button>
            </form>
        </div>
    </div>
</body>
</html>