<?php
require_once '../includes/config.php';
require_once '../includes/auth.php';

$auth = new Auth();

if (!$auth->isLoggedIn() || !$auth->isAdmin()) {
    header("Location: login.php");
    exit;
}

// دریافت ترجمه‌ها
$lang = $_SESSION['language'] ?? DEFAULT_LANGUAGE;
require_once "../lang/$lang.php";
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پنل مدیریت - Crashify</title>
    <link rel="stylesheet" href="../public/css/style.css">
    <link rel="stylesheet" href="../public/css/admin.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <div class="admin-wrapper">
        <header class="admin-header">
            <div class="admin-header-container">
                <div class="admin-logo">
                    <a href="index.php">Crashify Admin</a>
                </div>
                <div class="admin-nav">
                    <a href="index.php">داشبورد</a>
                    <a href="users.php">کاربران</a>
                    <a href="transactions.php">تراکنش‌ها</a>
                    <a href="settings.php">تنظیمات</a>
                    <a href="support_tickets.php">تیکت‌ها</a>
                    <a href="../index.php">بازگشت به سایت</a>
                    <a href="../logout.php">خروج</a>
                </div>
            </div>
        </header>

        <main class="admin-main">
            <div class="admin-container">
                <!-- محتوای صفحه -->